/**********************************************************************

  Audacity: A Digital Audio Editor

  CommandContext.h

  Created by Paul Licameli on 4/22/16.

**********************************************************************/

#ifndef __AUDACITY_COMMAND_CONTEXT__
#define __AUDACITY_COMMAND_CONTEXT__

#include <memory>
#include <lib-strings/Identifier.h>

class TenacityProject;
class wxEvent;
class CommandOutputTargets;
using CommandParameter = CommandID;

class SelectedRegion;
class Track;

struct TemporarySelection {
   TemporarySelection() = default;
   TemporarySelection(const TemporarySelection&) = default;
   TemporarySelection &operator= (const TemporarySelection&) = default;

   SelectedRegion *pSelectedRegion = nullptr;
   Track *pTrack = nullptr;
};

class TENACITY_DLL_API CommandContext {
public:
   CommandContext(
      TenacityProject &p
      , const wxEvent *e = nullptr
      , int ii = 0
      , const CommandParameter &param = CommandParameter{}
   );

   CommandContext(
      TenacityProject &p,
      std::unique_ptr<CommandOutputTargets> target);

   ~CommandContext();

   virtual void Status( const wxString &message, bool bFlush = false ) const;
   virtual void Error(  const wxString &message ) const;
   virtual void Progress( double d ) const;

   // Output formatting...
   void StartArray() const;
   void EndArray() const;
   void StartStruct() const;
   void EndStruct() const;
   void StartField(const wxString &name) const;
   void EndField() const;
   void AddItem(const wxString &value , const wxString &name = {} ) const;
   void AddBool(const bool value      , const wxString &name = {} ) const;
   void AddItem(const double value    , const wxString &name = {} ) const;

   TenacityProject &project;
   std::unique_ptr<CommandOutputTargets> pOutput;
   const wxEvent *pEvt;
   int index;
   CommandParameter parameter;

   // This might depend on a point picked with a context menu
   TemporarySelection temporarySelection;
};
#endif
