/* DeleteFileTask.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DeleteFileTask.vala, do not modify */

/*
 * DeleteFileTask.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;
typedef struct _DeleteFileTaskPrivate DeleteFileTaskPrivate;
enum  {
	DELETE_FILE_TASK_0_PROPERTY,
	DELETE_FILE_TASK_NUM_PROPERTIES
};
static GParamSpec* delete_file_task_properties[DELETE_FILE_TASK_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _DeleteFileTask {
	AsyncTask parent_instance;
	DeleteFileTaskPrivate * priv;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean use_rsync;
	gint64 status_line_count;
	gint64 total_size;
	gchar* status_message;
	gchar* time_remaining;
};

struct _DeleteFileTaskClass {
	AsyncTaskClass parent_class;
};

struct _DeleteFileTaskPrivate {
	gchar* source_path;
	GeeHashMap* regex_list;
};

static gint DeleteFileTask_private_offset;
static gpointer delete_file_task_parent_class = NULL;

VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN void async_task_prepare (AsyncTask* self);
VALA_EXTERN gchar* async_task_build_script (AsyncTask* self);
VALA_EXTERN void async_task_parse_stdout_line (AsyncTask* self,
                                   const gchar* out_line);
VALA_EXTERN void async_task_parse_stderr_line (AsyncTask* self,
                                   const gchar* err_line);
VALA_EXTERN DeleteFileTask* delete_file_task_new (void);
VALA_EXTERN DeleteFileTask* delete_file_task_construct (GType object_type);
VALA_EXTERN AsyncTask* async_task_construct (GType object_type);
static void delete_file_task_init_regular_expressions (DeleteFileTask* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
static void delete_file_task_real_prepare (AsyncTask* base);
static gchar* delete_file_task_real_build_script (AsyncTask* base);
VALA_EXTERN gchar* tee_jee_misc_random_string (gint length,
                                   const gchar* charset);
VALA_EXTERN gboolean tee_jee_file_system_dir_create (const gchar* dir_path,
                                         gboolean show_message);
VALA_EXTERN gchar* tee_jee_file_system_remove_trailing_slash (const gchar* path);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
static void delete_file_task_real_parse_stdout_line (AsyncTask* base,
                                              const gchar* out_line);
VALA_EXTERN gboolean delete_file_task_update_progress_parse_console_output (DeleteFileTask* self,
                                                                const gchar* line);
static void delete_file_task_real_parse_stderr_line (AsyncTask* base,
                                              const gchar* err_line);
VALA_EXTERN void async_task_set_status_line (AsyncTask* self,
                                 const gchar* value);
static void delete_file_task_finalize (GObject * obj);
static GType delete_file_task_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
delete_file_task_get_instance_private (DeleteFileTask* self)
{
	return G_STRUCT_MEMBER_P (self, DeleteFileTask_private_offset);
}

DeleteFileTask*
delete_file_task_construct (GType object_type)
{
	DeleteFileTask * self = NULL;
	self = (DeleteFileTask*) async_task_construct (object_type);
	delete_file_task_init_regular_expressions (self);
	return self;
}

DeleteFileTask*
delete_file_task_new (void)
{
	return delete_file_task_construct (TYPE_DELETE_FILE_TASK);
}

static void
delete_file_task_init_regular_expressions (DeleteFileTask* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->regex_list;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_REGEX, (GBoxedCopyFunc) g_regex_ref, (GDestroyNotify) g_regex_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->regex_list);
	self->priv->regex_list = _tmp1_;
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_;
		GeeHashMap* _tmp4_;
		_tmp3_ = g_regex_new ("\\*deleting[ \\t]+(.*)", 0, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = self->priv->regex_list;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp4_, "rsync-deleted", _tmp2_);
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		tee_jee_logging_log_error (_tmp6_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
delete_file_task_real_prepare (AsyncTask* base)
{
	DeleteFileTask * self;
	self = (DeleteFileTask*) base;
	ASYNC_TASK_CLASS (delete_file_task_parent_class)->prepare (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASYNC_TASK, AsyncTask));
	self->status_line_count = (gint64) 0;
	self->total_size = (gint64) 0;
}

static gchar*
delete_file_task_real_build_script (AsyncTask* base)
{
	DeleteFileTask * self;
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gchar* result;
	self = (DeleteFileTask*) base;
	_tmp0_ = g_strdup ("");
	cmd = _tmp0_;
	if (self->io_nice) {
	}
	if (self->use_rsync) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp1_ = cmd;
		_tmp2_ = g_strconcat (_tmp1_, "rsync -aii", NULL);
		_g_free0 (cmd);
		cmd = _tmp2_;
		if (self->verbose) {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = cmd;
			_tmp4_ = g_strconcat (_tmp3_, " --verbose", NULL);
			_g_free0 (cmd);
			cmd = _tmp4_;
		} else {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = cmd;
			_tmp6_ = g_strconcat (_tmp5_, " --quiet", NULL);
			_g_free0 (cmd);
			cmd = _tmp6_;
		}
		_tmp7_ = cmd;
		_tmp8_ = g_strconcat (_tmp7_, " --delete", NULL);
		_g_free0 (cmd);
		cmd = _tmp8_;
		_tmp9_ = cmd;
		_tmp10_ = g_strconcat (_tmp9_, " --stats --relative", NULL);
		_g_free0 (cmd);
		cmd = _tmp10_;
		_tmp11_ = tee_jee_misc_random_string (8, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890");
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("/tmp/%s_empty", _tmp12_);
		_g_free0 (self->priv->source_path);
		self->priv->source_path = _tmp13_;
		_g_free0 (_tmp12_);
		_tmp14_ = self->priv->source_path;
		tee_jee_file_system_dir_create (_tmp14_, FALSE);
		_tmp15_ = self->priv->source_path;
		_tmp16_ = tee_jee_file_system_remove_trailing_slash (_tmp15_);
		_g_free0 (self->priv->source_path);
		self->priv->source_path = _tmp16_;
		_tmp17_ = self->dest_path;
		_tmp18_ = tee_jee_file_system_remove_trailing_slash (_tmp17_);
		_g_free0 (self->dest_path);
		self->dest_path = _tmp18_;
		_tmp19_ = cmd;
		_tmp20_ = self->priv->source_path;
		_tmp21_ = tee_jee_file_system_escape_single_quote (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf (" '%s/'", _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
		_g_free0 (cmd);
		cmd = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp26_ = cmd;
		_tmp27_ = self->dest_path;
		_tmp28_ = tee_jee_file_system_escape_single_quote (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strdup_printf (" '%s/'", _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp26_, _tmp31_, NULL);
		_g_free0 (cmd);
		cmd = _tmp32_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
	} else {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp33_ = cmd;
		_tmp34_ = g_strconcat (_tmp33_, "rm -rf", NULL);
		_g_free0 (cmd);
		cmd = _tmp34_;
		if (self->verbose) {
			const gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = cmd;
			_tmp36_ = g_strconcat (_tmp35_, "v", NULL);
			_g_free0 (cmd);
			cmd = _tmp36_;
		}
		_tmp37_ = cmd;
		_tmp38_ = self->dest_path;
		_tmp39_ = tee_jee_file_system_escape_single_quote (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strdup_printf (" '%s'", _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp37_, _tmp42_, NULL);
		_g_free0 (cmd);
		cmd = _tmp43_;
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
	}
	result = cmd;
	return result;
}

static void
delete_file_task_real_parse_stdout_line (AsyncTask* base,
                                         const gchar* out_line)
{
	DeleteFileTask * self;
	self = (DeleteFileTask*) base;
	g_return_if_fail (out_line != NULL);
	delete_file_task_update_progress_parse_console_output (self, out_line);
}

static void
delete_file_task_real_parse_stderr_line (AsyncTask* base,
                                         const gchar* err_line)
{
	DeleteFileTask * self;
	self = (DeleteFileTask*) base;
	g_return_if_fail (err_line != NULL);
	delete_file_task_update_progress_parse_console_output (self, err_line);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gboolean
delete_file_task_update_progress_parse_console_output (DeleteFileTask* self,
                                                       const gchar* line)
{
	gboolean _tmp0_ = FALSE;
	gint64 _tmp3_;
	GMatchInfo* match = NULL;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	GRegex* _tmp6_;
	GMatchInfo* _tmp7_ = NULL;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	if (line == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (line);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->status_line_count;
	self->status_line_count = _tmp3_ + 1;
	if (((AsyncTask*) self)->prg_count_total > ((gint64) 0)) {
		((AsyncTask*) self)->prg_count = self->status_line_count;
		((AsyncTask*) self)->progress = (((AsyncTask*) self)->prg_count * 1.0) / ((AsyncTask*) self)->prg_count_total;
	}
	_tmp4_ = self->priv->regex_list;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, "rsync-deleted");
	_tmp6_ = (GRegex*) _tmp5_;
	_tmp8_ = g_regex_match (_tmp6_, line, 0, &_tmp7_);
	_g_match_info_unref0 (match);
	match = _tmp7_;
	_tmp9_ = _tmp8_;
	_g_regex_unref0 (_tmp6_);
	if (_tmp9_) {
		GMatchInfo* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp10_ = match;
		_tmp11_ = g_match_info_fetch (_tmp10_, 1);
		_tmp12_ = _tmp11_;
		_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, " -> ", 0);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _vala_array_length (_tmp13_);
		_tmp16_ = _tmp15_[0];
		_tmp17_ = string_strip (_tmp16_);
		_tmp18_ = _tmp17_;
		async_task_set_status_line ((AsyncTask*) self, _tmp18_);
		_g_free0 (_tmp18_);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp12_);
	} else {
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = string_strip (line);
		_tmp20_ = _tmp19_;
		async_task_set_status_line ((AsyncTask*) self, _tmp20_);
		_g_free0 (_tmp20_);
	}
	result = TRUE;
	_g_match_info_unref0 (match);
	return result;
}

static void
delete_file_task_class_init (DeleteFileTaskClass * klass,
                             gpointer klass_data)
{
	delete_file_task_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DeleteFileTask_private_offset);
	((AsyncTaskClass *) klass)->prepare = (void (*) (AsyncTask*)) delete_file_task_real_prepare;
	((AsyncTaskClass *) klass)->build_script = (gchar* (*) (AsyncTask*)) delete_file_task_real_build_script;
	((AsyncTaskClass *) klass)->parse_stdout_line = (void (*) (AsyncTask*, const gchar*)) delete_file_task_real_parse_stdout_line;
	((AsyncTaskClass *) klass)->parse_stderr_line = (void (*) (AsyncTask*, const gchar*)) delete_file_task_real_parse_stderr_line;
	G_OBJECT_CLASS (klass)->finalize = delete_file_task_finalize;
}

static void
delete_file_task_instance_init (DeleteFileTask * self,
                                gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = delete_file_task_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->dest_path = _tmp0_;
	self->verbose = TRUE;
	self->io_nice = TRUE;
	self->use_rsync = FALSE;
	_tmp1_ = g_strdup ("");
	self->priv->source_path = _tmp1_;
	self->status_line_count = (gint64) 0;
	self->total_size = (gint64) 0;
	_tmp2_ = g_strdup ("");
	self->status_message = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->time_remaining = _tmp3_;
}

static void
delete_file_task_finalize (GObject * obj)
{
	DeleteFileTask * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DELETE_FILE_TASK, DeleteFileTask);
	_g_free0 (self->dest_path);
	_g_free0 (self->priv->source_path);
	_g_object_unref0 (self->priv->regex_list);
	_g_free0 (self->status_message);
	_g_free0 (self->time_remaining);
	G_OBJECT_CLASS (delete_file_task_parent_class)->finalize (obj);
}

static GType
delete_file_task_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DeleteFileTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) delete_file_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeleteFileTask), 0, (GInstanceInitFunc) delete_file_task_instance_init, NULL };
	GType delete_file_task_type_id;
	delete_file_task_type_id = g_type_register_static (TYPE_ASYNC_TASK, "DeleteFileTask", &g_define_type_info, 0);
	DeleteFileTask_private_offset = g_type_add_instance_private (delete_file_task_type_id, sizeof (DeleteFileTaskPrivate));
	return delete_file_task_type_id;
}

GType
delete_file_task_get_type (void)
{
	static volatile gsize delete_file_task_type_id__once = 0;
	if (g_once_init_enter (&delete_file_task_type_id__once)) {
		GType delete_file_task_type_id;
		delete_file_task_type_id = delete_file_task_get_type_once ();
		g_once_init_leave (&delete_file_task_type_id__once, delete_file_task_type_id);
	}
	return delete_file_task_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

