/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	traefikiov1alpha1 "github.com/traefik/traefik/v3/pkg/provider/kubernetes/crd/traefikio/v1alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// IngressRouteTCPLister helps list IngressRouteTCPs.
// All objects returned here must be treated as read-only.
type IngressRouteTCPLister interface {
	// List lists all IngressRouteTCPs in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*traefikiov1alpha1.IngressRouteTCP, err error)
	// IngressRouteTCPs returns an object that can list and get IngressRouteTCPs.
	IngressRouteTCPs(namespace string) IngressRouteTCPNamespaceLister
	IngressRouteTCPListerExpansion
}

// ingressRouteTCPLister implements the IngressRouteTCPLister interface.
type ingressRouteTCPLister struct {
	listers.ResourceIndexer[*traefikiov1alpha1.IngressRouteTCP]
}

// NewIngressRouteTCPLister returns a new IngressRouteTCPLister.
func NewIngressRouteTCPLister(indexer cache.Indexer) IngressRouteTCPLister {
	return &ingressRouteTCPLister{listers.New[*traefikiov1alpha1.IngressRouteTCP](indexer, traefikiov1alpha1.Resource("ingressroutetcp"))}
}

// IngressRouteTCPs returns an object that can list and get IngressRouteTCPs.
func (s *ingressRouteTCPLister) IngressRouteTCPs(namespace string) IngressRouteTCPNamespaceLister {
	return ingressRouteTCPNamespaceLister{listers.NewNamespaced[*traefikiov1alpha1.IngressRouteTCP](s.ResourceIndexer, namespace)}
}

// IngressRouteTCPNamespaceLister helps list and get IngressRouteTCPs.
// All objects returned here must be treated as read-only.
type IngressRouteTCPNamespaceLister interface {
	// List lists all IngressRouteTCPs in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*traefikiov1alpha1.IngressRouteTCP, err error)
	// Get retrieves the IngressRouteTCP from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*traefikiov1alpha1.IngressRouteTCP, error)
	IngressRouteTCPNamespaceListerExpansion
}

// ingressRouteTCPNamespaceLister implements the IngressRouteTCPNamespaceLister
// interface.
type ingressRouteTCPNamespaceLister struct {
	listers.ResourceIndexer[*traefikiov1alpha1.IngressRouteTCP]
}
