// Display images inside a terminal
// Copyright (C) 2023  JustKidding
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef WINDOW_H
#define WINDOW_H

#include <concepts>
#include <memory>

class Window
{
public:
    virtual ~Window() = default;
    virtual void draw() = 0;
    virtual void generate_frame() = 0;
    virtual void show() {};
    virtual void hide() {};
};

template<class T>
concept WindowType = std::is_base_of<Window, T>::value;

#endif
