/**
 * @file options.cpp
 * Declaration and initializers for all options.
 * Automatically generated by <code>scripts/make_options.py</code>
 * from options.h.
 */


#include "uncrustify_types.h"

namespace uncrustify
{

//BEGIN declarations of option object instances

namespace options
{

Option<line_end_e> newlines = {
  "newlines",
  R"__(
The type of line endings.
)__",
  LE_AUTO
};

BoundedOption<unsigned, 1, 32> input_tab_size = {
  "input_tab_size",
  R"__(
The original size of tabs in the input.
)__",
  8
};

BoundedOption<unsigned, 1, 32> output_tab_size = {
  "output_tab_size",
  R"__(
The size of tabs in the output (only used if align_with_tabs=true).
)__",
  8
};

BoundedOption<unsigned, 0, 255> string_escape_char = {
  "string_escape_char",
  R"__(
The ASCII value of the string escape char, usually 92 (\) or (Pawn) 94 (^).
)__",
  '\\'
};

BoundedOption<unsigned, 0, 255> string_escape_char2 = {
  "string_escape_char2",
  R"__(
Alternate string escape char (usually only used for Pawn).
Only works right before the quote char.
)__"
};

Option<bool> string_replace_tab_chars = {
  "string_replace_tab_chars",
  R"__(
Replace tab characters found in string literals with the escape sequence \t
instead.
)__"
};

Option<bool> tok_split_gte = {
  "tok_split_gte",
  R"__(
Allow interpreting '>=' and '>>=' as part of a template in code like
'void f(list<list<B>>=val);'. If true, 'assert(x<0 && y>=3)' will be broken.
Improvements to template detection may make this option obsolete.
)__"
};

Option<bool> disable_processing_nl_cont = {
  "disable_processing_nl_cont",
  R"__(
Disable formatting of NL_CONT ('\\n') ended lines (e.g. multi-line macros).
)__"
};

Option<string> disable_processing_cmt = {
  "disable_processing_cmt",
  R"__(
Specify the marker used in comments to disable processing of part of the
file.
)__",
  UNCRUSTIFY_OFF_TEXT
};

Option<string> enable_processing_cmt = {
  "enable_processing_cmt",
  R"__(
Specify the marker used in comments to (re)enable processing in a file.
)__",
  UNCRUSTIFY_ON_TEXT
};

Option<bool> enable_digraphs = {
  "enable_digraphs",
  R"__(
Enable parsing of digraphs.
)__"
};

Option<bool> processing_cmt_as_regex = {
  "processing_cmt_as_regex",
  R"__(
Option to allow both disable_processing_cmt and enable_processing_cmt
strings, if specified, to be interpreted as ECMAScript regular expressions.
If true, a regex search will be performed within comments according to the
specified patterns in order to disable/enable processing.
)__"
};

Option<iarf_e> utf8_bom = {
  "utf8_bom",
  R"__(
Add or remove the UTF-8 BOM (recommend 'remove').
)__"
};

Option<bool> utf8_byte = {
  "utf8_byte",
  R"__(
If the file contains bytes with values between 128 and 255, but is not
UTF-8, then output as UTF-8.
)__"
};

Option<bool> utf8_force = {
  "utf8_force",
  R"__(
Force the output encoding to UTF-8.
)__"
};

Option<iarf_e> sp_arith = {
  "sp_arith",
  R"__(
Add or remove space around non-assignment symbolic operators ('+', '/', '%',
'<<', and so forth).
)__"
};

Option<iarf_e> sp_arith_additive = {
  "sp_arith_additive",
  R"__(
Add or remove space around arithmetic operators '+' and '-'.

Overrides sp_arith.
)__"
};

Option<iarf_e> sp_assign = {
  "sp_assign",
  R"__(
Add or remove space around assignment operator '=', '+=', etc.
)__"
};

Option<iarf_e> sp_cpp_lambda_assign = {
  "sp_cpp_lambda_assign",
  R"__(
Add or remove space around '=' in C++11 lambda capture specifications.

Overrides sp_assign.
)__"
};

Option<iarf_e> sp_cpp_lambda_square_paren = {
  "sp_cpp_lambda_square_paren",
  R"__(
Add or remove space after the capture specification of a C++11 lambda when
an argument list is present, as in '[] <here> (int x){ ... }'.
)__"
};

Option<iarf_e> sp_cpp_lambda_square_brace = {
  "sp_cpp_lambda_square_brace",
  R"__(
Add or remove space after the capture specification of a C++11 lambda with
no argument list is present, as in '[] <here> { ... }'.
)__"
};

Option<iarf_e> sp_cpp_lambda_argument_list_empty = {
  "sp_cpp_lambda_argument_list_empty",
  R"__(
Add or remove space after the opening parenthesis and before the closing
parenthesis of a argument list of a C++11 lambda, as in
'[]( <here> ){ ... }'
with an empty list.
)__"
};

Option<iarf_e> sp_cpp_lambda_argument_list = {
  "sp_cpp_lambda_argument_list",
  R"__(
Add or remove space after the opening parenthesis and before the closing
parenthesis of a argument list of a C++11 lambda, as in
'[]( <here> int x <here> ){ ... }'.
)__"
};

Option<iarf_e> sp_cpp_lambda_paren_brace = {
  "sp_cpp_lambda_paren_brace",
  R"__(
Add or remove space after the argument list of a C++11 lambda, as in
'[](int x) <here> { ... }'.
)__"
};

Option<iarf_e> sp_cpp_lambda_fparen = {
  "sp_cpp_lambda_fparen",
  R"__(
Add or remove space between a lambda body and its call operator of an
immediately invoked lambda, as in '[]( ... ){ ... } <here> ( ... )'.
)__"
};

Option<iarf_e> sp_assign_default = {
  "sp_assign_default",
  R"__(
Add or remove space around assignment operator '=' in a prototype.

If set to ignore, use sp_assign.
)__"
};

Option<iarf_e> sp_before_assign = {
  "sp_before_assign",
  R"__(
Add or remove space before assignment operator '=', '+=', etc.

Overrides sp_assign.
)__"
};

Option<iarf_e> sp_after_assign = {
  "sp_after_assign",
  R"__(
Add or remove space after assignment operator '=', '+=', etc.

Overrides sp_assign.
)__"
};

Option<iarf_e> sp_enum_brace = {
  "sp_enum_brace",
  R"__(
Add or remove space in 'enum {'.
)__",
  IARF_ADD
};

Option<iarf_e> sp_enum_paren = {
  "sp_enum_paren",
  R"__(
Add or remove space in 'NS_ENUM ('.
)__"
};

Option<iarf_e> sp_enum_assign = {
  "sp_enum_assign",
  R"__(
Add or remove space around assignment '=' in enum.
)__"
};

Option<iarf_e> sp_enum_before_assign = {
  "sp_enum_before_assign",
  R"__(
Add or remove space before assignment '=' in enum.

Overrides sp_enum_assign.
)__"
};

Option<iarf_e> sp_enum_after_assign = {
  "sp_enum_after_assign",
  R"__(
Add or remove space after assignment '=' in enum.

Overrides sp_enum_assign.
)__"
};

Option<iarf_e> sp_enum_colon = {
  "sp_enum_colon",
  R"__(
Add or remove space around assignment ':' in enum.
)__"
};

Option<iarf_e> sp_pp_concat = {
  "sp_pp_concat",
  R"__(
Add or remove space around preprocessor '##' concatenation operator.
)__",
  IARF_ADD
};

Option<iarf_e> sp_pp_stringify = {
  "sp_pp_stringify",
  R"__(
Add or remove space after preprocessor '#' stringify operator.
Also affects the '#@' charizing operator.
)__"
};

Option<iarf_e> sp_before_pp_stringify = {
  "sp_before_pp_stringify",
  R"__(
Add or remove space before preprocessor '#' stringify operator
as in '#define x(y) L#y'.
)__"
};

Option<iarf_e> sp_bool = {
  "sp_bool",
  R"__(
Add or remove space around boolean operators '&&' and '||'.
)__"
};

Option<iarf_e> sp_compare = {
  "sp_compare",
  R"__(
Add or remove space around compare operator '<', '>', '==', etc.
)__"
};

Option<iarf_e> sp_inside_paren = {
  "sp_inside_paren",
  R"__(
Add or remove space inside '(' and ')'.
)__"
};

Option<iarf_e> sp_paren_paren = {
  "sp_paren_paren",
  R"__(
Add or remove space between nested parentheses, i.e. '((' vs. ') )'.
)__"
};

Option<iarf_e> sp_cparen_oparen = {
  "sp_cparen_oparen",
  R"__(
Add or remove space between back-to-back parentheses, i.e. ')(' vs. ') ('.
)__"
};

Option<iarf_e> sp_paren_brace = {
  "sp_paren_brace",
  R"__(
Add or remove space between ')' and '{'.
)__"
};

Option<iarf_e> sp_brace_brace = {
  "sp_brace_brace",
  R"__(
Add or remove space between nested braces, i.e. '{{' vs. '{ {'.
)__"
};

Option<iarf_e> sp_before_ptr_star = {
  "sp_before_ptr_star",
  R"__(
Add or remove space before pointer star '*'.
)__"
};

Option<iarf_e> sp_before_unnamed_ptr_star = {
  "sp_before_unnamed_ptr_star",
  R"__(
Add or remove space before pointer star '*' that isn't followed by a
variable name. If set to ignore, sp_before_ptr_star is used instead.
)__"
};

Option<iarf_e> sp_before_qualifier_ptr_star = {
  "sp_before_qualifier_ptr_star",
  R"__(
Add or remove space before pointer star '*' that is followed by a qualifier.
If set to ignore, sp_before_unnamed_ptr_star is used instead.
)__"
};

Option<iarf_e> sp_before_operator_ptr_star = {
  "sp_before_operator_ptr_star",
  R"__(
Add or remove space before pointer star '*' that is followed by 'operator' keyword.
If set to ignore, sp_before_unnamed_ptr_star is used instead.
)__"
};

Option<iarf_e> sp_before_scope_ptr_star = {
  "sp_before_scope_ptr_star",
  R"__(
Add or remove space before pointer star '*' that is followed by
a class scope (as in 'int *MyClass::method()') or namespace scope
(as in 'int *my_ns::func()').
If set to ignore, sp_before_unnamed_ptr_star is used instead.
)__"
};

Option<iarf_e> sp_before_global_scope_ptr_star = {
  "sp_before_global_scope_ptr_star",
  R"__(
Add or remove space before pointer star '*' that is followed by '::',
as in 'int *::func()'.
If set to ignore, sp_before_unnamed_ptr_star is used instead.
)__"
};

Option<iarf_e> sp_qualifier_unnamed_ptr_star = {
  "sp_qualifier_unnamed_ptr_star",
  R"__(
Add or remove space between a qualifier and a pointer star '*' that isn't
followed by a variable name, as in '(char const *)'. If set to ignore,
sp_before_ptr_star is used instead.
)__"
};

Option<iarf_e> sp_between_ptr_star = {
  "sp_between_ptr_star",
  R"__(
Add or remove space between pointer stars '*', as in 'int ***a;'.
)__"
};

Option<iarf_e> sp_between_ptr_ref = {
  "sp_between_ptr_ref",
  R"__(
Add or remove space between pointer star '*' and reference '&', as in 'int *& a;'.
)__"
};

Option<iarf_e> sp_after_ptr_star = {
  "sp_after_ptr_star",
  R"__(
Add or remove space after pointer star '*', if followed by a word.

Overrides sp_type_func.
)__"
};

Option<iarf_e> sp_after_ptr_block_caret = {
  "sp_after_ptr_block_caret",
  R"__(
Add or remove space after pointer caret '^', if followed by a word.
)__"
};

Option<iarf_e> sp_after_ptr_star_qualifier = {
  "sp_after_ptr_star_qualifier",
  R"__(
Add or remove space after pointer star '*', if followed by a qualifier.
)__"
};

Option<iarf_e> sp_after_ptr_star_func = {
  "sp_after_ptr_star_func",
  R"__(
Add or remove space after a pointer star '*', if followed by a function
prototype or function definition.

Overrides sp_after_ptr_star and sp_type_func.
)__"
};

Option<iarf_e> sp_after_ptr_star_trailing = {
  "sp_after_ptr_star_trailing",
  R"__(
Add or remove space after a pointer star '*' in the trailing return of a
function prototype or function definition.
)__"
};

Option<iarf_e> sp_ptr_star_func_var = {
  "sp_ptr_star_func_var",
  R"__(
Add or remove space between the pointer star '*' and the name of the variable
in a function pointer definition.
)__"
};

Option<iarf_e> sp_ptr_star_func_type = {
  "sp_ptr_star_func_type",
  R"__(
Add or remove space between the pointer star '*' and the name of the type
in a function pointer type definition.
)__"
};

Option<iarf_e> sp_ptr_star_paren = {
  "sp_ptr_star_paren",
  R"__(
Add or remove space after a pointer star '*', if followed by an open
parenthesis, as in 'void* (*)()'.
)__"
};

Option<iarf_e> sp_before_ptr_star_func = {
  "sp_before_ptr_star_func",
  R"__(
Add or remove space before a pointer star '*', if followed by a function
prototype or function definition. If set to ignore, sp_before_ptr_star is
used instead.
)__"
};

Option<iarf_e> sp_qualifier_ptr_star_func = {
  "sp_qualifier_ptr_star_func",
  R"__(
Add or remove space between a qualifier and a pointer star '*' followed by
the name of the function in a function prototype or definition, as in
'char const *foo()`. If set to ignore, sp_before_ptr_star is used instead.
)__"
};

Option<iarf_e> sp_before_ptr_star_trailing = {
  "sp_before_ptr_star_trailing",
  R"__(
Add or remove space before a pointer star '*' in the trailing return of a
function prototype or function definition.
)__"
};

Option<iarf_e> sp_qualifier_ptr_star_trailing = {
  "sp_qualifier_ptr_star_trailing",
  R"__(
Add or remove space between a qualifier and a pointer star '*' in the
trailing return of a function prototype or function definition, as in
'auto foo() -> char const *'.
)__"
};

Option<iarf_e> sp_before_byref = {
  "sp_before_byref",
  R"__(
Add or remove space before a reference sign '&'.
)__"
};

Option<iarf_e> sp_before_unnamed_byref = {
  "sp_before_unnamed_byref",
  R"__(
Add or remove space before a reference sign '&' that isn't followed by a
variable name. If set to ignore, sp_before_byref is used instead.
)__"
};

Option<iarf_e> sp_after_byref = {
  "sp_after_byref",
  R"__(
Add or remove space after reference sign '&', if followed by a word.

Overrides sp_type_func.
)__"
};

Option<iarf_e> sp_after_byref_func = {
  "sp_after_byref_func",
  R"__(
Add or remove space after a reference sign '&', if followed by a function
prototype or function definition.

Overrides sp_after_byref and sp_type_func.
)__"
};

Option<iarf_e> sp_before_byref_func = {
  "sp_before_byref_func",
  R"__(
Add or remove space before a reference sign '&', if followed by a function
prototype or function definition.
)__"
};

Option<iarf_e> sp_byref_paren = {
  "sp_byref_paren",
  R"__(
Add or remove space after a reference sign '&', if followed by an open
parenthesis, as in 'char& (*)()'.
)__"
};

Option<iarf_e> sp_after_type = {
  "sp_after_type",
  R"__(
Add or remove space between type and word. In cases where total removal of
whitespace would be a syntax error, a value of 'remove' is treated the same
as 'force'.

This also affects some other instances of space following a type that are
not covered by other options; for example, between the return type and
parenthesis of a function type template argument, between the type and
parenthesis of an array parameter, or between 'decltype(...)' and the
following word.
)__",
  IARF_FORCE
};

Option<iarf_e> sp_after_decltype = {
  "sp_after_decltype",
  R"__(
Add or remove space between 'decltype(...)' and word,
brace or function call.
)__"
};

Option<iarf_e> sp_before_template_paren = {
  "sp_before_template_paren",
  R"__(
(D) Add or remove space before the parenthesis in the D constructs
'template Foo(' and 'class Foo('.
)__"
};

Option<iarf_e> sp_template_angle = {
  "sp_template_angle",
  R"__(
Add or remove space between 'template' and '<'.
If set to ignore, sp_before_angle is used.
)__"
};

Option<iarf_e> sp_before_angle = {
  "sp_before_angle",
  R"__(
Add or remove space before '<'.
)__"
};

Option<iarf_e> sp_inside_angle = {
  "sp_inside_angle",
  R"__(
Add or remove space inside '<' and '>'.
)__"
};

Option<iarf_e> sp_inside_angle_empty = {
  "sp_inside_angle_empty",
  R"__(
Add or remove space inside '<>'.
if empty.
)__"
};

Option<iarf_e> sp_angle_colon = {
  "sp_angle_colon",
  R"__(
Add or remove space between '>' and ':'.
)__"
};

Option<iarf_e> sp_after_angle = {
  "sp_after_angle",
  R"__(
Add or remove space after '>'.
)__"
};

Option<iarf_e> sp_angle_paren = {
  "sp_angle_paren",
  R"__(
Add or remove space between '>' and '(' as found in 'new List<byte>(foo);'.
)__"
};

Option<iarf_e> sp_angle_paren_empty = {
  "sp_angle_paren_empty",
  R"__(
Add or remove space between '>' and '()' as found in 'new List<byte>();'.
)__"
};

Option<iarf_e> sp_angle_word = {
  "sp_angle_word",
  R"__(
Add or remove space between '>' and a word as in 'List<byte> m;' or
'template <typename T> static ...'.
)__"
};

Option<iarf_e> sp_angle_shift = {
  "sp_angle_shift",
  R"__(
Add or remove space between '>' and '>' in '>>' (template stuff).
)__",
  IARF_ADD
};

Option<bool> sp_permit_cpp11_shift = {
  "sp_permit_cpp11_shift",
  R"__(
(C++11) Permit removal of the space between '>>' in 'foo<bar<int> >'. Note
that sp_angle_shift cannot remove the space without this option.
)__"
};

Option<iarf_e> sp_before_sparen = {
  "sp_before_sparen",
  R"__(
Add or remove space before '(' of control statements ('if', 'for', 'switch',
'while', etc.).
)__"
};

Option<iarf_e> sp_inside_sparen = {
  "sp_inside_sparen",
  R"__(
Add or remove space inside '(' and ')' of control statements other than
'for'.
)__"
};

Option<iarf_e> sp_inside_sparen_open = {
  "sp_inside_sparen_open",
  R"__(
Add or remove space after '(' of control statements other than 'for'.

Overrides sp_inside_sparen.
)__"
};

Option<iarf_e> sp_inside_sparen_close = {
  "sp_inside_sparen_close",
  R"__(
Add or remove space before ')' of control statements other than 'for'.

Overrides sp_inside_sparen.
)__"
};

Option<iarf_e> sp_inside_for = {
  "sp_inside_for",
  R"__(
Add or remove space inside '(' and ')' of 'for' statements.
)__"
};

Option<iarf_e> sp_inside_for_open = {
  "sp_inside_for_open",
  R"__(
Add or remove space after '(' of 'for' statements.

Overrides sp_inside_for.
)__"
};

Option<iarf_e> sp_inside_for_close = {
  "sp_inside_for_close",
  R"__(
Add or remove space before ')' of 'for' statements.

Overrides sp_inside_for.
)__"
};

Option<iarf_e> sp_sparen_paren = {
  "sp_sparen_paren",
  R"__(
Add or remove space between '((' or '))' of control statements.
)__"
};

Option<iarf_e> sp_after_sparen = {
  "sp_after_sparen",
  R"__(
Add or remove space after ')' of control statements.
)__"
};

Option<iarf_e> sp_sparen_brace = {
  "sp_sparen_brace",
  R"__(
Add or remove space between ')' and '{' of control statements.
)__"
};

Option<iarf_e> sp_do_brace_open = {
  "sp_do_brace_open",
  R"__(
Add or remove space between 'do' and '{'.
)__"
};

Option<iarf_e> sp_brace_close_while = {
  "sp_brace_close_while",
  R"__(
Add or remove space between '}' and 'while'.
)__"
};

Option<iarf_e> sp_while_paren_open = {
  "sp_while_paren_open",
  R"__(
Add or remove space between 'while' and '('. Overrides sp_before_sparen.
)__"
};

Option<iarf_e> sp_invariant_paren = {
  "sp_invariant_paren",
  R"__(
(D) Add or remove space between 'invariant' and '('.
)__"
};

Option<iarf_e> sp_after_invariant_paren = {
  "sp_after_invariant_paren",
  R"__(
(D) Add or remove space after the ')' in 'invariant (C) c'.
)__"
};

Option<iarf_e> sp_special_semi = {
  "sp_special_semi",
  R"__(
Add or remove space before empty statement ';' on 'if', 'for' and 'while'.
examples:
  if (b) <here> ;
  for (a=1; a<10; a++) <here> ;
  while (*p++ = ' ') <here> ;
)__"
};

Option<iarf_e> sp_before_semi = {
  "sp_before_semi",
  R"__(
Add or remove space before ';'.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_before_semi_for = {
  "sp_before_semi_for",
  R"__(
Add or remove space before ';' in non-empty 'for' statements.
)__"
};

Option<iarf_e> sp_before_semi_for_empty = {
  "sp_before_semi_for_empty",
  R"__(
Add or remove space before a semicolon of an empty left part of a for
statement, as in 'for ( <here> ; ; )'.
)__"
};

Option<iarf_e> sp_between_semi_for_empty = {
  "sp_between_semi_for_empty",
  R"__(
Add or remove space between the semicolons of an empty middle part of a for
statement, as in 'for ( ; <here> ; )'.
)__"
};

Option<iarf_e> sp_after_semi = {
  "sp_after_semi",
  R"__(
Add or remove space after ';', except when followed by a comment.
)__",
  IARF_ADD
};

Option<iarf_e> sp_after_semi_for = {
  "sp_after_semi_for",
  R"__(
Add or remove space after ';' in non-empty 'for' statements.
)__",
  IARF_FORCE
};

Option<iarf_e> sp_after_semi_for_empty = {
  "sp_after_semi_for_empty",
  R"__(
Add or remove space after the final semicolon of an empty part of a for
statement, as in 'for ( ; ; <here> )'.
)__"
};

Option<iarf_e> sp_before_square = {
  "sp_before_square",
  R"__(
Add or remove space before '[' (except '[]').
)__"
};

Option<iarf_e> sp_before_vardef_square = {
  "sp_before_vardef_square",
  R"__(
Add or remove space before '[' for a variable definition.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_before_square_asm_block = {
  "sp_before_square_asm_block",
  R"__(
Add or remove space before '[' for asm block.
)__"
};

Option<iarf_e> sp_before_squares = {
  "sp_before_squares",
  R"__(
Add or remove space before '[]'.
)__"
};

Option<iarf_e> sp_cpp_before_struct_binding_after_byref = {
  "sp_cpp_before_struct_binding_after_byref",
  R"__(
Add or remove space before C++17 structured bindings
after byref.
)__"
};

Option<iarf_e> sp_cpp_before_struct_binding = {
  "sp_cpp_before_struct_binding",
  R"__(
Add or remove space before C++17 structured bindings.
)__"
};

Option<iarf_e> sp_inside_square = {
  "sp_inside_square",
  R"__(
Add or remove space inside a non-empty '[' and ']'.
)__"
};

Option<iarf_e> sp_inside_square_empty = {
  "sp_inside_square_empty",
  R"__(
Add or remove space inside '[]'.
if empty.
)__"
};

Option<iarf_e> sp_inside_square_oc_array = {
  "sp_inside_square_oc_array",
  R"__(
(OC) Add or remove space inside a non-empty Objective-C boxed array '@[' and
']'. If set to ignore, sp_inside_square is used.
)__"
};

Option<iarf_e> sp_after_comma = {
  "sp_after_comma",
  R"__(
Add or remove space after ',', i.e. 'a,b' vs. 'a, b'.
)__"
};

Option<iarf_e> sp_before_comma = {
  "sp_before_comma",
  R"__(
Add or remove space before ',', i.e. 'a,b' vs. 'a ,b'.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_after_mdatype_commas = {
  "sp_after_mdatype_commas",
  R"__(
(C#, Vala) Add or remove space between ',' and ']' in multidimensional array type
like 'int[,,]'.
)__"
};

Option<iarf_e> sp_before_mdatype_commas = {
  "sp_before_mdatype_commas",
  R"__(
(C#, Vala) Add or remove space between '[' and ',' in multidimensional array type
like 'int[,,]'.
)__"
};

Option<iarf_e> sp_between_mdatype_commas = {
  "sp_between_mdatype_commas",
  R"__(
(C#, Vala) Add or remove space between ',' in multidimensional array type
like 'int[,,]'.
)__"
};

Option<iarf_e> sp_paren_comma = {
  "sp_paren_comma",
  R"__(
Add or remove space between an open parenthesis and comma,
i.e. '(,' vs. '( ,'.
)__",
  IARF_FORCE
};

Option<iarf_e> sp_type_colon = {
  "sp_type_colon",
  R"__(
Add or remove space between a type and ':'.
)__"
};

Option<iarf_e> sp_after_ellipsis = {
  "sp_after_ellipsis",
  R"__(
Add or remove space after the variadic '...' when preceded by a
non-punctuator.
The value REMOVE will be overridden with FORCE
)__"
};

Option<iarf_e> sp_before_ellipsis = {
  "sp_before_ellipsis",
  R"__(
Add or remove space before the variadic '...' when preceded by a
non-punctuator.
The value REMOVE will be overridden with FORCE
)__"
};

Option<iarf_e> sp_type_ellipsis = {
  "sp_type_ellipsis",
  R"__(
Add or remove space between a type and '...'.
)__"
};

Option<iarf_e> sp_ptr_type_ellipsis = {
  "sp_ptr_type_ellipsis",
  R"__(
Add or remove space between a '*' and '...'.
)__"
};

Option<iarf_e> sp_paren_ellipsis = {
  "sp_paren_ellipsis",
  R"__(
Add or remove space between ')' and '...'.
)__"
};

Option<iarf_e> sp_byref_ellipsis = {
  "sp_byref_ellipsis",
  R"__(
Add or remove space between '&&' and '...'.
)__"
};

Option<iarf_e> sp_paren_qualifier = {
  "sp_paren_qualifier",
  R"__(
Add or remove space between ')' and a qualifier such as 'const'.
)__"
};

Option<iarf_e> sp_paren_noexcept = {
  "sp_paren_noexcept",
  R"__(
Add or remove space between ')' and 'noexcept'.
)__"
};

Option<iarf_e> sp_after_class_colon = {
  "sp_after_class_colon",
  R"__(
Add or remove space after class ':'.
)__"
};

Option<iarf_e> sp_before_class_colon = {
  "sp_before_class_colon",
  R"__(
Add or remove space before class ':'.
)__"
};

Option<iarf_e> sp_after_constr_colon = {
  "sp_after_constr_colon",
  R"__(
Add or remove space after class constructor ':'.
)__",
  IARF_ADD
};

Option<iarf_e> sp_before_constr_colon = {
  "sp_before_constr_colon",
  R"__(
Add or remove space before class constructor ':'.
)__",
  IARF_ADD
};

Option<iarf_e> sp_before_case_colon = {
  "sp_before_case_colon",
  R"__(
Add or remove space before case ':'.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_after_operator = {
  "sp_after_operator",
  R"__(
Add or remove space between 'operator' and operator sign.
)__"
};

Option<iarf_e> sp_after_operator_sym = {
  "sp_after_operator_sym",
  R"__(
Add or remove space between the operator symbol and the open parenthesis, as
in 'operator ++('.
)__"
};

Option<iarf_e> sp_after_operator_sym_empty = {
  "sp_after_operator_sym_empty",
  R"__(
Overrides sp_after_operator_sym when the operator has no arguments, as in
'operator *()'.
)__"
};

Option<iarf_e> sp_after_cast = {
  "sp_after_cast",
  R"__(
Add or remove space after C/D cast, i.e. 'cast(int)a' vs. 'cast(int) a' or
'(int)a' vs. '(int) a'.
)__"
};

Option<iarf_e> sp_inside_paren_cast = {
  "sp_inside_paren_cast",
  R"__(
Add or remove spaces inside cast parentheses.
)__"
};

Option<iarf_e> sp_cpp_cast_paren = {
  "sp_cpp_cast_paren",
  R"__(
Add or remove space between the type and open parenthesis in a C++ cast,
i.e. 'int(exp)' vs. 'int (exp)'.
)__"
};

Option<iarf_e> sp_sizeof_paren = {
  "sp_sizeof_paren",
  R"__(
Add or remove space between 'sizeof' and '('.
)__"
};

Option<iarf_e> sp_sizeof_ellipsis = {
  "sp_sizeof_ellipsis",
  R"__(
Add or remove space between 'sizeof' and '...'.
)__"
};

Option<iarf_e> sp_sizeof_ellipsis_paren = {
  "sp_sizeof_ellipsis_paren",
  R"__(
Add or remove space between 'sizeof...' and '('.
)__"
};

Option<iarf_e> sp_ellipsis_parameter_pack = {
  "sp_ellipsis_parameter_pack",
  R"__(
Add or remove space between '...' and a parameter pack.
)__"
};

Option<iarf_e> sp_parameter_pack_ellipsis = {
  "sp_parameter_pack_ellipsis",
  R"__(
Add or remove space between a parameter pack and '...'.
)__"
};

Option<iarf_e> sp_decltype_paren = {
  "sp_decltype_paren",
  R"__(
Add or remove space between 'decltype' and '('.
)__"
};

Option<iarf_e> sp_after_tag = {
  "sp_after_tag",
  R"__(
(Pawn) Add or remove space after the tag keyword.
)__"
};

Option<iarf_e> sp_inside_braces_enum = {
  "sp_inside_braces_enum",
  R"__(
Add or remove space inside enum '{' and '}'.
)__"
};

Option<iarf_e> sp_inside_braces_struct = {
  "sp_inside_braces_struct",
  R"__(
Add or remove space inside struct/union '{' and '}'.
)__"
};

Option<iarf_e> sp_inside_braces_oc_dict = {
  "sp_inside_braces_oc_dict",
  R"__(
(OC) Add or remove space inside Objective-C boxed dictionary '{' and '}'
)__"
};

Option<iarf_e> sp_after_type_brace_init_lst_open = {
  "sp_after_type_brace_init_lst_open",
  R"__(
Add or remove space after open brace in an unnamed temporary
direct-list-initialization
if statement is a brace_init_lst
works only if sp_brace_brace is set to ignore.
)__"
};

Option<iarf_e> sp_before_type_brace_init_lst_close = {
  "sp_before_type_brace_init_lst_close",
  R"__(
Add or remove space before close brace in an unnamed temporary
direct-list-initialization
if statement is a brace_init_lst
works only if sp_brace_brace is set to ignore.
)__"
};

Option<iarf_e> sp_inside_type_brace_init_lst = {
  "sp_inside_type_brace_init_lst",
  R"__(
Add or remove space inside an unnamed temporary direct-list-initialization
if statement is a brace_init_lst
works only if sp_brace_brace is set to ignore
works only if sp_before_type_brace_init_lst_close is set to ignore.
)__"
};

Option<iarf_e> sp_inside_braces = {
  "sp_inside_braces",
  R"__(
Add or remove space inside '{' and '}'.
)__"
};

Option<iarf_e> sp_inside_braces_empty = {
  "sp_inside_braces_empty",
  R"__(
Add or remove space inside '{}'.
if empty.
)__"
};

Option<iarf_e> sp_trailing_return = {
  "sp_trailing_return",
  R"__(
Add or remove space around trailing return operator '->'.
)__"
};

Option<iarf_e> sp_type_func = {
  "sp_type_func",
  R"__(
Add or remove space between return type and function name. A minimum of 1
is forced except for pointer return types.
)__"
};

Option<iarf_e> sp_type_brace_init_lst = {
  "sp_type_brace_init_lst",
  R"__(
Add or remove space between type and open brace of an unnamed temporary
direct-list-initialization.
)__"
};

Option<iarf_e> sp_func_proto_paren = {
  "sp_func_proto_paren",
  R"__(
Add or remove space between function name and '(' on function declaration.
)__"
};

Option<iarf_e> sp_func_proto_paren_empty = {
  "sp_func_proto_paren_empty",
  R"__(
Add or remove space between function name and '()' on function declaration
if empty.
)__"
};

Option<iarf_e> sp_func_type_paren = {
  "sp_func_type_paren",
  R"__(
Add or remove space between function name and '(' with a typedef specifier.
)__"
};

Option<iarf_e> sp_func_def_paren = {
  "sp_func_def_paren",
  R"__(
Add or remove space between alias name and '(' of a non-pointer function type typedef.
)__"
};

Option<iarf_e> sp_func_def_paren_empty = {
  "sp_func_def_paren_empty",
  R"__(
Add or remove space between function name and '()' on function definition
if empty.
)__"
};

Option<iarf_e> sp_inside_fparens = {
  "sp_inside_fparens",
  R"__(
Add or remove space inside empty function '()'.
Overrides sp_after_angle unless use_sp_after_angle_always is set to true.
)__"
};

Option<iarf_e> sp_inside_fparen = {
  "sp_inside_fparen",
  R"__(
Add or remove space inside function '(' and ')'.
)__"
};

Option<iarf_e> sp_func_call_user_inside_rparen = {
  "sp_func_call_user_inside_rparen",
  R"__(
Add or remove space inside user functor '(' and ')'.
)__"
};

Option<iarf_e> sp_inside_rparens = {
  "sp_inside_rparens",
  R"__(
Add or remove space inside empty functor '()'.
Overrides sp_after_angle unless use_sp_after_angle_always is set to true.
)__"
};

Option<iarf_e> sp_inside_rparen = {
  "sp_inside_rparen",
  R"__(
Add or remove space inside functor '(' and ')'.
)__"
};

Option<iarf_e> sp_inside_tparen = {
  "sp_inside_tparen",
  R"__(
Add or remove space inside the first parentheses in a function type, as in
'void (*x)(...)'.
)__"
};

Option<iarf_e> sp_after_tparen_close = {
  "sp_after_tparen_close",
  R"__(
Add or remove space between the ')' and '(' in a function type, as in
'void (*x)(...)'.
)__"
};

Option<iarf_e> sp_square_fparen = {
  "sp_square_fparen",
  R"__(
Add or remove space between ']' and '(' when part of a function call.
)__"
};

Option<iarf_e> sp_fparen_brace = {
  "sp_fparen_brace",
  R"__(
Add or remove space between ')' and '{' of function.
)__"
};

Option<iarf_e> sp_fparen_brace_initializer = {
  "sp_fparen_brace_initializer",
  R"__(
Add or remove space between ')' and '{' of a function call in object
initialization.

Overrides sp_fparen_brace.
)__"
};

Option<iarf_e> sp_fparen_dbrace = {
  "sp_fparen_dbrace",
  R"__(
(Java) Add or remove space between ')' and '{{' of double brace initializer.
)__"
};

Option<iarf_e> sp_func_call_paren = {
  "sp_func_call_paren",
  R"__(
Add or remove space between function name and '(' on function calls.
)__"
};

Option<iarf_e> sp_func_call_paren_empty = {
  "sp_func_call_paren_empty",
  R"__(
Add or remove space between function name and '()' on function calls without
parameters. If set to ignore (the default), sp_func_call_paren is used.
)__"
};

Option<iarf_e> sp_func_call_user_paren = {
  "sp_func_call_user_paren",
  R"__(
Add or remove space between the user function name and '(' on function
calls. You need to set a keyword to be a user function in the config file,
like:
  set func_call_user tr _ i18n
)__"
};

Option<iarf_e> sp_func_call_user_inside_fparen = {
  "sp_func_call_user_inside_fparen",
  R"__(
Add or remove space inside user function '(' and ')'.
)__"
};

Option<iarf_e> sp_func_call_user_paren_paren = {
  "sp_func_call_user_paren_paren",
  R"__(
Add or remove space between nested parentheses with user functions,
i.e. '((' vs. '( ('.
)__"
};

Option<iarf_e> sp_func_class_paren = {
  "sp_func_class_paren",
  R"__(
Add or remove space between a constructor/destructor and the open
parenthesis.
)__"
};

Option<iarf_e> sp_func_class_paren_empty = {
  "sp_func_class_paren_empty",
  R"__(
Add or remove space between a constructor without parameters or destructor
and '()'.
)__"
};

Option<iarf_e> sp_return = {
  "sp_return",
  R"__(
Add or remove space after 'return'.
)__",
  IARF_FORCE
};

Option<iarf_e> sp_return_paren = {
  "sp_return_paren",
  R"__(
Add or remove space between 'return' and '('.
)__"
};

Option<iarf_e> sp_return_brace = {
  "sp_return_brace",
  R"__(
Add or remove space between 'return' and '{'.
)__"
};

Option<iarf_e> sp_attribute_paren = {
  "sp_attribute_paren",
  R"__(
Add or remove space between '__attribute__' and '('.
)__"
};

Option<iarf_e> sp_defined_paren = {
  "sp_defined_paren",
  R"__(
Add or remove space between 'defined' and '(' in '#if defined (FOO)'.
)__"
};

Option<iarf_e> sp_throw_paren = {
  "sp_throw_paren",
  R"__(
Add or remove space between 'throw' and '(' in 'throw (something)'.
)__"
};

Option<iarf_e> sp_after_throw = {
  "sp_after_throw",
  R"__(
Add or remove space between 'throw' and anything other than '(' as in
'@throw [...];'.
)__"
};

Option<iarf_e> sp_catch_paren = {
  "sp_catch_paren",
  R"__(
Add or remove space between 'catch' and '(' in 'catch (something) { }'.
If set to ignore, sp_before_sparen is used.
)__"
};

Option<iarf_e> sp_oc_catch_paren = {
  "sp_oc_catch_paren",
  R"__(
(OC) Add or remove space between '@catch' and '('
in '@catch (something) { }'. If set to ignore, sp_catch_paren is used.
)__"
};

Option<iarf_e> sp_before_oc_proto_list = {
  "sp_before_oc_proto_list",
  R"__(
(OC) Add or remove space before Objective-C protocol list
as in '@protocol Protocol<here><Protocol_A>' or '@interface MyClass : NSObject<here><MyProtocol>'.
)__"
};

Option<iarf_e> sp_oc_classname_paren = {
  "sp_oc_classname_paren",
  R"__(
(OC) Add or remove space between class name and '('
in '@interface className(categoryName)<ProtocolName>:BaseClass'
)__"
};

Option<iarf_e> sp_version_paren = {
  "sp_version_paren",
  R"__(
(D) Add or remove space between 'version' and '('
in 'version (something) { }'. If set to ignore, sp_before_sparen is used.
)__"
};

Option<iarf_e> sp_scope_paren = {
  "sp_scope_paren",
  R"__(
(D) Add or remove space between 'scope' and '('
in 'scope (something) { }'. If set to ignore, sp_before_sparen is used.
)__"
};

Option<iarf_e> sp_super_paren = {
  "sp_super_paren",
  R"__(
Add or remove space between 'super' and '(' in 'super (something)'.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_this_paren = {
  "sp_this_paren",
  R"__(
Add or remove space between 'this' and '(' in 'this (something)'.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_macro = {
  "sp_macro",
  R"__(
Add or remove space between a macro name and its definition.
)__"
};

Option<iarf_e> sp_macro_func = {
  "sp_macro_func",
  R"__(
Add or remove space between a macro function ')' and its definition.
)__"
};

Option<iarf_e> sp_else_brace = {
  "sp_else_brace",
  R"__(
Add or remove space between 'else' and '{' if on the same line.
)__"
};

Option<iarf_e> sp_brace_else = {
  "sp_brace_else",
  R"__(
Add or remove space between '}' and 'else' if on the same line.
)__"
};

Option<iarf_e> sp_brace_typedef = {
  "sp_brace_typedef",
  R"__(
Add or remove space between '}' and the name of a typedef on the same line.
)__"
};

Option<iarf_e> sp_catch_brace = {
  "sp_catch_brace",
  R"__(
Add or remove space before the '{' of a 'catch' statement, if the '{' and
'catch' are on the same line, as in 'catch (decl) <here> {'.
)__"
};

Option<iarf_e> sp_oc_catch_brace = {
  "sp_oc_catch_brace",
  R"__(
(OC) Add or remove space before the '{' of a '@catch' statement, if the '{'
and '@catch' are on the same line, as in '@catch (decl) <here> {'.
If set to ignore, sp_catch_brace is used.
)__"
};

Option<iarf_e> sp_brace_catch = {
  "sp_brace_catch",
  R"__(
Add or remove space between '}' and 'catch' if on the same line.
)__"
};

Option<iarf_e> sp_oc_brace_catch = {
  "sp_oc_brace_catch",
  R"__(
(OC) Add or remove space between '}' and '@catch' if on the same line.
If set to ignore, sp_brace_catch is used.
)__"
};

Option<iarf_e> sp_finally_brace = {
  "sp_finally_brace",
  R"__(
Add or remove space between 'finally' and '{' if on the same line.
)__"
};

Option<iarf_e> sp_brace_finally = {
  "sp_brace_finally",
  R"__(
Add or remove space between '}' and 'finally' if on the same line.
)__"
};

Option<iarf_e> sp_try_brace = {
  "sp_try_brace",
  R"__(
Add or remove space between 'try' and '{' if on the same line.
)__"
};

Option<iarf_e> sp_getset_brace = {
  "sp_getset_brace",
  R"__(
Add or remove space between get/set and '{' if on the same line.
)__"
};

Option<iarf_e> sp_word_brace_init_lst = {
  "sp_word_brace_init_lst",
  R"__(
Add or remove space between a variable and '{' for C++ uniform
initialization.
)__"
};

Option<iarf_e> sp_word_brace_ns = {
  "sp_word_brace_ns",
  R"__(
Add or remove space between a variable and '{' for a namespace.
)__",
  IARF_ADD
};

Option<iarf_e> sp_before_dc = {
  "sp_before_dc",
  R"__(
Add or remove space before the '::' operator.
)__"
};

Option<iarf_e> sp_after_dc = {
  "sp_after_dc",
  R"__(
Add or remove space after the '::' operator.
)__"
};

Option<iarf_e> sp_d_array_colon = {
  "sp_d_array_colon",
  R"__(
(D) Add or remove around the D named array initializer ':' operator.
)__"
};

Option<iarf_e> sp_not = {
  "sp_not",
  R"__(
Add or remove space after the '!' (not) unary operator.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_not_not = {
  "sp_not_not",
  R"__(
Add or remove space between two '!' (not) unary operators.
If set to ignore, sp_not will be used.
)__",
  IARF_IGNORE
};

Option<iarf_e> sp_inv = {
  "sp_inv",
  R"__(
Add or remove space after the '~' (invert) unary operator.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_addr = {
  "sp_addr",
  R"__(
Add or remove space after the '&' (address-of) unary operator. This does not
affect the spacing after a '&' that is part of a type.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_member = {
  "sp_member",
  R"__(
Add or remove space around the '.' or '->' operators.
also the c-sharp null-conditional operator '?.'
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_deref = {
  "sp_deref",
  R"__(
Add or remove space after the '*' (dereference) unary operator. This does
not affect the spacing after a '*' that is part of a type.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_sign = {
  "sp_sign",
  R"__(
Add or remove space after '+' or '-', as in 'x = -5' or 'y = +7'.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_incdec = {
  "sp_incdec",
  R"__(
Add or remove space between '++' and '--' the word to which it is being
applied, as in '(--x)' or 'y++;'.
)__",
  IARF_REMOVE
};

Option<iarf_e> sp_before_nl_cont = {
  "sp_before_nl_cont",
  R"__(
Add or remove space before a backslash-newline at the end of a line.
)__",
  IARF_ADD
};

Option<iarf_e> sp_after_oc_scope = {
  "sp_after_oc_scope",
  R"__(
(OC) Add or remove space after the scope '+' or '-', as in '-(void) foo;'
or '+(int) bar;'.
)__"
};

Option<iarf_e> sp_after_oc_colon = {
  "sp_after_oc_colon",
  R"__(
(OC) Add or remove space after the colon in message specs,
i.e. '-(int) f:(int) x;' vs. '-(int) f: (int) x;'.
)__"
};

Option<iarf_e> sp_before_oc_colon = {
  "sp_before_oc_colon",
  R"__(
(OC) Add or remove space before the colon in message specs,
i.e. '-(int) f: (int) x;' vs. '-(int) f : (int) x;'.
)__"
};

Option<iarf_e> sp_after_oc_dict_colon = {
  "sp_after_oc_dict_colon",
  R"__(
(OC) Add or remove space after the colon in immutable dictionary expression
'NSDictionary *test = @{@"foo" :@"bar"};'.
)__"
};

Option<iarf_e> sp_before_oc_dict_colon = {
  "sp_before_oc_dict_colon",
  R"__(
(OC) Add or remove space before the colon in immutable dictionary expression
'NSDictionary *test = @{@"foo" :@"bar"};'.
)__"
};

Option<iarf_e> sp_after_send_oc_colon = {
  "sp_after_send_oc_colon",
  R"__(
(OC) Add or remove space after the colon in message specs,
i.e. '[object setValue:1];' vs. '[object setValue: 1];'.
)__"
};

Option<iarf_e> sp_before_send_oc_colon = {
  "sp_before_send_oc_colon",
  R"__(
(OC) Add or remove space before the colon in message specs,
i.e. '[object setValue:1];' vs. '[object setValue :1];'.
)__"
};

Option<iarf_e> sp_after_oc_type = {
  "sp_after_oc_type",
  R"__(
(OC) Add or remove space after the (type) in message specs,
i.e. '-(int)f: (int) x;' vs. '-(int)f: (int)x;'.
)__"
};

Option<iarf_e> sp_after_oc_return_type = {
  "sp_after_oc_return_type",
  R"__(
(OC) Add or remove space after the first (type) in message specs,
i.e. '-(int) f:(int)x;' vs. '-(int)f:(int)x;'.
)__"
};

Option<iarf_e> sp_after_oc_at_sel = {
  "sp_after_oc_at_sel",
  R"__(
(OC) Add or remove space between '@selector' and '(',
i.e. '@selector(msgName)' vs. '@selector (msgName)'.
Also applies to '@protocol()' constructs.
)__"
};

Option<iarf_e> sp_after_oc_at_sel_parens = {
  "sp_after_oc_at_sel_parens",
  R"__(
(OC) Add or remove space between '@selector(x)' and the following word,
i.e. '@selector(foo) a:' vs. '@selector(foo)a:'.
)__"
};

Option<iarf_e> sp_inside_oc_at_sel_parens = {
  "sp_inside_oc_at_sel_parens",
  R"__(
(OC) Add or remove space inside '@selector' parentheses,
i.e. '@selector(foo)' vs. '@selector( foo )'.
Also applies to '@protocol()' constructs.
)__"
};

Option<iarf_e> sp_before_oc_block_caret = {
  "sp_before_oc_block_caret",
  R"__(
(OC) Add or remove space before a block pointer caret,
i.e. '^int (int arg){...}' vs. ' ^int (int arg){...}'.
)__"
};

Option<iarf_e> sp_after_oc_block_caret = {
  "sp_after_oc_block_caret",
  R"__(
(OC) Add or remove space after a block pointer caret,
i.e. '^int (int arg){...}' vs. '^ int (int arg){...}'.
)__"
};

Option<iarf_e> sp_after_oc_msg_receiver = {
  "sp_after_oc_msg_receiver",
  R"__(
(OC) Add or remove space between the receiver and selector in a message,
as in '[receiver selector ...]'.
)__"
};

Option<iarf_e> sp_after_oc_property = {
  "sp_after_oc_property",
  R"__(
(OC) Add or remove space after '@property'.
)__"
};

Option<iarf_e> sp_after_oc_synchronized = {
  "sp_after_oc_synchronized",
  R"__(
(OC) Add or remove space between '@synchronized' and the open parenthesis,
i.e. '@synchronized(foo)' vs. '@synchronized (foo)'.
)__"
};

Option<iarf_e> sp_cond_colon = {
  "sp_cond_colon",
  R"__(
Add or remove space around the ':' in 'b ? t : f'.
)__"
};

Option<iarf_e> sp_cond_colon_before = {
  "sp_cond_colon_before",
  R"__(
Add or remove space before the ':' in 'b ? t : f'.

Overrides sp_cond_colon.
)__"
};

Option<iarf_e> sp_cond_colon_after = {
  "sp_cond_colon_after",
  R"__(
Add or remove space after the ':' in 'b ? t : f'.

Overrides sp_cond_colon.
)__"
};

Option<iarf_e> sp_cond_question = {
  "sp_cond_question",
  R"__(
Add or remove space around the '?' in 'b ? t : f'.
)__"
};

Option<iarf_e> sp_cond_question_before = {
  "sp_cond_question_before",
  R"__(
Add or remove space before the '?' in 'b ? t : f'.

Overrides sp_cond_question.
)__"
};

Option<iarf_e> sp_cond_question_after = {
  "sp_cond_question_after",
  R"__(
Add or remove space after the '?' in 'b ? t : f'.

Overrides sp_cond_question.
)__"
};

Option<iarf_e> sp_cond_ternary_short = {
  "sp_cond_ternary_short",
  R"__(
In the abbreviated ternary form '(a ?: b)', add or remove space between '?'
and ':'.

Overrides all other sp_cond_* options.
)__"
};

Option<iarf_e> sp_case_label = {
  "sp_case_label",
  R"__(
Fix the spacing between 'case' and the label. Only 'ignore' and 'force' make
sense here.
)__"
};

Option<iarf_e> sp_range = {
  "sp_range",
  R"__(
(D) Add or remove space around the D '..' operator.
)__"
};

Option<iarf_e> sp_after_for_colon = {
  "sp_after_for_colon",
  R"__(
Add or remove space after ':' in a Java/C++11 range-based 'for',
as in 'for (Type var : <here> expr)'.
)__"
};

Option<iarf_e> sp_before_for_colon = {
  "sp_before_for_colon",
  R"__(
Add or remove space before ':' in a Java/C++11 range-based 'for',
as in 'for (Type var <here> : expr)'.
)__"
};

Option<iarf_e> sp_extern_paren = {
  "sp_extern_paren",
  R"__(
(D) Add or remove space between 'extern' and '(' as in 'extern <here> (C)'.
)__"
};

Option<iarf_e> sp_cmt_cpp_start = {
  "sp_cmt_cpp_start",
  R"__(
Add or remove space after the opening of a C++ comment, as in '// <here> A'.
)__"
};

Option<bool> sp_cmt_cpp_pvs = {
  "sp_cmt_cpp_pvs",
  R"__(
remove space after the '//' and the pvs command '-V1234',
only works with sp_cmt_cpp_start set to add or force.
)__"
};

Option<bool> sp_cmt_cpp_lint = {
  "sp_cmt_cpp_lint",
  R"__(
remove space after the '//' and the command 'lint',
only works with sp_cmt_cpp_start set to add or force.
)__"
};

Option<iarf_e> sp_cmt_cpp_region = {
  "sp_cmt_cpp_region",
  R"__(
Add or remove space in a C++ region marker comment, as in '// <here> BEGIN'.
A region marker is defined as a comment which is not preceded by other text
(i.e. the comment is the first non-whitespace on the line), and which starts
with either 'BEGIN' or 'END'.

Overrides sp_cmt_cpp_start.
)__"
};

Option<bool> sp_cmt_cpp_doxygen = {
  "sp_cmt_cpp_doxygen",
  R"__(
If true, space added with sp_cmt_cpp_start will be added after Doxygen
sequences like '///', '///<', '//!' and '//!<'.
)__"
};

Option<bool> sp_cmt_cpp_qttr = {
  "sp_cmt_cpp_qttr",
  R"__(
If true, space added with sp_cmt_cpp_start will be added after Qt translator
or meta-data comments like '//:', '//=', and '//~'.
)__"
};

Option<iarf_e> sp_endif_cmt = {
  "sp_endif_cmt",
  R"__(
Add or remove space between #else or #endif and a trailing comment.
)__"
};

Option<iarf_e> sp_after_new = {
  "sp_after_new",
  R"__(
Add or remove space after 'new', 'delete' and 'delete[]'.
)__"
};

Option<iarf_e> sp_between_new_paren = {
  "sp_between_new_paren",
  R"__(
Add or remove space between 'new' and '(' in 'new()'.
)__"
};

Option<iarf_e> sp_after_newop_paren = {
  "sp_after_newop_paren",
  R"__(
Add or remove space between ')' and type in 'new(foo) BAR'.
)__"
};

Option<iarf_e> sp_inside_newop_paren = {
  "sp_inside_newop_paren",
  R"__(
Add or remove space inside parentheses of the new operator
as in 'new(foo) BAR'.
)__"
};

Option<iarf_e> sp_inside_newop_paren_open = {
  "sp_inside_newop_paren_open",
  R"__(
Add or remove space after the open parenthesis of the new operator,
as in 'new(foo) BAR'.

Overrides sp_inside_newop_paren.
)__"
};

Option<iarf_e> sp_inside_newop_paren_close = {
  "sp_inside_newop_paren_close",
  R"__(
Add or remove space before the close parenthesis of the new operator,
as in 'new(foo) BAR'.

Overrides sp_inside_newop_paren.
)__"
};

Option<iarf_e> sp_before_tr_cmt = {
  "sp_before_tr_cmt",
  R"__(
Add or remove space before a trailing comment.
)__"
};

BoundedOption<unsigned, 0, 16> sp_num_before_tr_cmt = {
  "sp_num_before_tr_cmt",
  R"__(
Number of spaces before a trailing comment.
)__"
};

Option<iarf_e> sp_before_emb_cmt = {
  "sp_before_emb_cmt",
  R"__(
Add or remove space before an embedded comment.
)__",
  IARF_FORCE
};

BoundedOption<unsigned, 0, 16> sp_num_before_emb_cmt = {
  "sp_num_before_emb_cmt",
  R"__(
Number of spaces before an embedded comment.
)__",
  1
};

Option<iarf_e> sp_after_emb_cmt = {
  "sp_after_emb_cmt",
  R"__(
Add or remove space after an embedded comment.
)__",
  IARF_FORCE
};

BoundedOption<unsigned, 0, 16> sp_num_after_emb_cmt = {
  "sp_num_after_emb_cmt",
  R"__(
Number of spaces after an embedded comment.
)__",
  1
};

Option<bool> sp_emb_cmt_priority = {
  "sp_emb_cmt_priority",
  R"__(
Embedded comment spacing options have higher priority (== override)
than other spacing options (comma, parenthesis, braces, ...)
)__",
  false
};

Option<iarf_e> sp_annotation_paren = {
  "sp_annotation_paren",
  R"__(
(Java) Add or remove space between an annotation and the open parenthesis.
)__"
};

Option<bool> sp_skip_vbrace_tokens = {
  "sp_skip_vbrace_tokens",
  R"__(
If true, vbrace tokens are dropped to the previous token and skipped.
)__"
};

Option<iarf_e> sp_after_noexcept = {
  "sp_after_noexcept",
  R"__(
Add or remove space after 'noexcept'.
)__"
};

Option<iarf_e> sp_vala_after_translation = {
  "sp_vala_after_translation",
  R"__(
Add or remove space after '_'.
)__"
};

Option<iarf_e> sp_before_bit_colon = {
  "sp_before_bit_colon",
  R"__(
Add or remove space before a bit colon ':'.
)__"
};

Option<iarf_e> sp_after_bit_colon = {
  "sp_after_bit_colon",
  R"__(
Add or remove space after a bit colon ':'.
)__"
};

Option<bool> force_tab_after_define = {
  "force_tab_after_define",
  R"__(
If true, a <TAB> is inserted after #define.
)__"
};

Option<iarf_e> sp_string_string = {
  "sp_string_string",
  R"__(
Add or remove space between two strings.
)__"
};

Option<iarf_e> sp_struct_type = {
  "sp_struct_type",
  R"__(
Add or remove space 'struct' and a type.
)__"
};

BoundedOption<unsigned, 0, 16> indent_columns = {
  "indent_columns",
  R"__(
The number of columns to indent per level. Usually 2, 3, 4, or 8.
)__",
  8
};

Option<bool> indent_ignore_first_continue = {
  "indent_ignore_first_continue",
  R"__(
Whether to ignore indent for the first continuation line. Subsequent
continuation lines will still be indented to match the first.
)__"
};

BoundedOption<signed, -16, 16> indent_continue = {
  "indent_continue",
  R"__(
The continuation indent. If non-zero, this overrides the indent of '(', '['
and '=' continuation indents. Negative values are OK; negative value is
absolute and not increased for each '(' or '[' level.

For FreeBSD, this is set to 4.
Requires indent_ignore_first_continue=false.
)__"
};

BoundedOption<unsigned, 0, 16> indent_continue_class_head = {
  "indent_continue_class_head",
  R"__(
The continuation indent, only for class header line(s). If non-zero, this
overrides the indent of 'class' continuation indents.
Requires indent_ignore_first_continue=false.
)__"
};

Option<bool> indent_single_newlines = {
  "indent_single_newlines",
  R"__(
Whether to indent empty lines (i.e. lines which contain only spaces before
the newline character).
)__"
};

BoundedOption<unsigned, 0, 16> indent_param = {
  "indent_param",
  R"__(
The continuation indent for func_*_param if they are true. If non-zero, this
overrides the indent.
)__"
};

BoundedOption<unsigned, 0, 2> indent_with_tabs = {
  "indent_with_tabs",
  R"__(
How to use tabs when indenting code.

0: Spaces only
1: Indent with tabs to brace level, align with spaces (default)
2: Indent and align with tabs, using spaces when not on a tabstop
)__",
  1
};

Option<bool> indent_cmt_with_tabs = {
  "indent_cmt_with_tabs",
  R"__(
Whether to indent comments that are not at a brace level with tabs on a
tabstop. Requires indent_with_tabs=2. If false, will use spaces.
)__"
};

Option<bool> indent_align_string = {
  "indent_align_string",
  R"__(
Whether to indent strings broken by '\' so that they line up.
)__"
};

BoundedOption<unsigned, 0, 16> indent_xml_string = {
  "indent_xml_string",
  R"__(
The number of spaces to indent multi-line XML strings.
Requires indent_align_string=true.
)__"
};

BoundedOption<unsigned, 0, 16> indent_brace = {
  "indent_brace",
  R"__(
Spaces to indent '{' from level.
)__"
};

Option<bool> indent_braces = {
  "indent_braces",
  R"__(
Whether braces are indented to the body level.
)__"
};

Option<bool> indent_braces_no_func = {
  "indent_braces_no_func",
  R"__(
Whether to disable indenting function braces if indent_braces=true.
)__"
};

Option<bool> indent_braces_no_class = {
  "indent_braces_no_class",
  R"__(
Whether to disable indenting class braces if indent_braces=true.
)__"
};

Option<bool> indent_braces_no_struct = {
  "indent_braces_no_struct",
  R"__(
Whether to disable indenting struct braces if indent_braces=true.
)__"
};

Option<bool> indent_brace_parent = {
  "indent_brace_parent",
  R"__(
Whether to indent based on the size of the brace parent,
i.e. 'if' => 3 spaces, 'for' => 4 spaces, etc.
)__"
};

Option<bool> indent_paren_open_brace = {
  "indent_paren_open_brace",
  R"__(
Whether to indent based on the open parenthesis instead of the open brace
in '({\n'.
)__"
};

Option<bool> indent_cs_delegate_brace = {
  "indent_cs_delegate_brace",
  R"__(
(C#) Whether to indent the brace of a C# delegate by another level.
)__"
};

Option<bool> indent_cs_delegate_body = {
  "indent_cs_delegate_body",
  R"__(
(C#) Whether to indent a C# delegate (to handle delegates with no brace) by
another level.
)__"
};

Option<bool> indent_namespace = {
  "indent_namespace",
  R"__(
Whether to indent the body of a 'namespace'.
)__"
};

Option<bool> indent_namespace_single_indent = {
  "indent_namespace_single_indent",
  R"__(
Whether to indent only the first namespace, and not any nested namespaces.
Requires indent_namespace=true.
)__"
};

BoundedOption<unsigned, 0, 16> indent_namespace_level = {
  "indent_namespace_level",
  R"__(
The number of spaces to indent a namespace block.
If set to zero, use the value indent_columns
)__"
};

BoundedOption<unsigned, 0, 255> indent_namespace_limit = {
  "indent_namespace_limit",
  R"__(
If the body of the namespace is longer than this number, it won't be
indented. Requires indent_namespace=true. 0 means no limit.
)__"
};

Option<bool> indent_namespace_inner_only = {
  "indent_namespace_inner_only",
  R"__(
Whether to indent only in inner namespaces (nested in other namespaces).
Requires indent_namespace=true.
)__"
};

Option<bool> indent_extern = {
  "indent_extern",
  R"__(
Whether the 'extern "C"' body is indented.
)__"
};

Option<bool> indent_class = {
  "indent_class",
  R"__(
Whether the 'class' body is indented.
)__"
};

Option<bool> indent_ignore_before_class_colon = {
  "indent_ignore_before_class_colon",
  R"__(
Whether to ignore indent for the leading base class colon.
)__"
};

BoundedOption<signed, -16, 16> indent_before_class_colon = {
  "indent_before_class_colon",
  R"__(
Additional indent before the leading base class colon.
Negative values decrease indent down to the first column.
Requires indent_ignore_before_class_colon=false and a newline break before
the colon (see pos_class_colon and nl_class_colon)
)__"
};

Option<bool> indent_class_colon = {
  "indent_class_colon",
  R"__(
Whether to indent the stuff after a leading base class colon.
)__"
};

Option<bool> indent_class_on_colon = {
  "indent_class_on_colon",
  R"__(
Whether to indent based on a class colon instead of the stuff after the
colon. Requires indent_class_colon=true.
)__"
};

Option<bool> indent_ignore_before_constr_colon = {
  "indent_ignore_before_constr_colon",
  R"__(
Whether to ignore indent for a leading class initializer colon.
)__"
};

Option<bool> indent_constr_colon = {
  "indent_constr_colon",
  R"__(
Whether to indent the stuff after a leading class initializer colon.
)__"
};

BoundedOption<unsigned, 0, 16> indent_ctor_init_leading = {
  "indent_ctor_init_leading",
  R"__(
Virtual indent from the ':' for leading member initializers.
)__",
  2
};

BoundedOption<unsigned, 0, 16> indent_ctor_init_following = {
  "indent_ctor_init_following",
  R"__(
Virtual indent from the ':' for following member initializers.
)__",
  2
};

BoundedOption<signed, -16, 16> indent_ctor_init = {
  "indent_ctor_init",
  R"__(
Additional indent for constructor initializer list.
Negative values decrease indent down to the first column.
)__"
};

Option<bool> indent_else_if = {
  "indent_else_if",
  R"__(
Whether to indent 'if' following 'else' as a new block under the 'else'.
If false, 'else\nif' is treated as 'else if' for indenting purposes.
)__"
};

BoundedOption<signed, -16, 16> indent_var_def_blk = {
  "indent_var_def_blk",
  R"__(
Amount to indent variable declarations after a open brace.

 <0: Relative
>=0: Absolute
)__"
};

Option<bool> indent_var_def_cont = {
  "indent_var_def_cont",
  R"__(
Whether to indent continued variable declarations instead of aligning.
)__"
};

BoundedOption<signed, -1, 1> indent_shift = {
  "indent_shift",
  R"__(
How to indent continued shift expressions ('<<' and '>>').
Set align_left_shift=false when using this.
 0: Align shift operators instead of indenting them (default)
 1: Indent by one level
-1: Preserve original indentation
)__"
};

Option<bool> indent_func_def_force_col1 = {
  "indent_func_def_force_col1",
  R"__(
Whether to force indentation of function definitions to start in column 1.
)__"
};

Option<bool> indent_func_call_param = {
  "indent_func_call_param",
  R"__(
Whether to indent continued function call parameters one indent level,
rather than aligning parameters under the open parenthesis.
)__"
};

Option<bool> indent_func_def_param = {
  "indent_func_def_param",
  R"__(
Whether to indent continued function definition parameters one indent level,
rather than aligning parameters under the open parenthesis.
)__"
};

BoundedOption<unsigned, 0, 160> indent_func_def_param_paren_pos_threshold = {
  "indent_func_def_param_paren_pos_threshold",
  R"__(
for function definitions, only if indent_func_def_param is false
Allows to align params when appropriate and indent them when not
behave as if it was true if paren position is more than this value
if paren position is more than the option value
)__"
};

Option<bool> indent_func_proto_param = {
  "indent_func_proto_param",
  R"__(
Whether to indent continued function call prototype one indent level,
rather than aligning parameters under the open parenthesis.
)__"
};

Option<bool> indent_func_class_param = {
  "indent_func_class_param",
  R"__(
Whether to indent continued function call declaration one indent level,
rather than aligning parameters under the open parenthesis.
)__"
};

Option<bool> indent_func_ctor_var_param = {
  "indent_func_ctor_var_param",
  R"__(
Whether to indent continued class variable constructors one indent level,
rather than aligning parameters under the open parenthesis.
)__"
};

Option<bool> indent_template_param = {
  "indent_template_param",
  R"__(
Whether to indent continued template parameter list one indent level,
rather than aligning parameters under the open parenthesis.
)__"
};

Option<bool> indent_func_param_double = {
  "indent_func_param_double",
  R"__(
Double the indent for indent_func_xxx_param options.
Use both values of the options indent_columns and indent_param.
)__"
};

BoundedOption<unsigned, 0, 69> indent_func_const = {
  "indent_func_const",
  R"__(
Indentation column for standalone 'const' qualifier on a function
prototype.
)__"
};

BoundedOption<unsigned, 0, 41> indent_func_throw = {
  "indent_func_throw",
  R"__(
Indentation column for standalone 'throw' qualifier on a function
prototype.
)__"
};

Option<bool> indent_macro_brace = {
  "indent_macro_brace",
  R"__(
How to indent within a macro followed by a brace on the same line
This allows reducing the indent in macros that have (for example)
`do { ... } while (0)` blocks bracketing them.

true:  add an indent for the brace on the same line as the macro
false: do not add an indent for the brace on the same line as the macro
)__",
  true
};

BoundedOption<unsigned, 0, 16> indent_member = {
  "indent_member",
  R"__(
The number of spaces to indent a continued '->' or '.'.
Usually set to 0, 1, or indent_columns.
)__"
};

Option<bool> indent_member_single = {
  "indent_member_single",
  R"__(
Whether lines broken at '.' or '->' should be indented by a single indent.
The indent_member option will not be effective if this is set to true.
)__"
};

BoundedOption<unsigned, 0, 16> indent_single_line_comments_before = {
  "indent_single_line_comments_before",
  R"__(
Spaces to indent single line ('//') comments on lines before code.
)__"
};

BoundedOption<unsigned, 0, 16> indent_single_line_comments_after = {
  "indent_single_line_comments_after",
  R"__(
Spaces to indent single line ('//') comments on lines after code.
)__"
};

BoundedOption<signed, -16, 16> indent_sparen_extra = {
  "indent_sparen_extra",
  R"__(
When opening a paren for a control statement (if, for, while, etc), increase
the indent level by this value. Negative values decrease the indent level.
)__"
};

Option<bool> indent_relative_single_line_comments = {
  "indent_relative_single_line_comments",
  R"__(
Whether to indent trailing single line ('//') comments relative to the code
instead of trying to keep the same absolute column.
)__"
};

BoundedOption<unsigned, 0, 16> indent_switch_case = {
  "indent_switch_case",
  R"__(
Spaces to indent 'case' from 'switch'. Usually 0 or indent_columns.
It might be wise to choose the same value for the option indent_case_brace.
)__"
};

BoundedOption<unsigned, 0, 16> indent_switch_body = {
  "indent_switch_body",
  R"__(
Spaces to indent the body of a 'switch' before any 'case'.
Usually the same as indent_columns or indent_switch_case.
)__"
};

Option<bool> indent_ignore_case_brace = {
  "indent_ignore_case_brace",
  R"__(
Whether to ignore indent for '{' following 'case'.
)__"
};

BoundedOption<signed, -16, 16> indent_case_brace = {
  "indent_case_brace",
  R"__(
Spaces to indent '{' from 'case'. By default, the brace will appear under
the 'c' in case. Usually set to 0 or indent_columns. Negative values are OK.
It might be wise to choose the same value for the option indent_switch_case.
)__"
};

Option<bool> indent_switch_break_with_case = {
  "indent_switch_break_with_case",
  R"__(
indent 'break' with 'case' from 'switch'.
)__"
};

Option<bool> indent_switch_pp = {
  "indent_switch_pp",
  R"__(
Whether to indent preprocessor statements inside of switch statements.
)__",
  true
};

BoundedOption<unsigned, 0, 16> indent_case_shift = {
  "indent_case_shift",
  R"__(
Spaces to shift the 'case' line, without affecting any other lines.
Usually 0.
)__"
};

Option<bool> indent_case_comment = {
  "indent_case_comment",
  R"__(
Whether to align comments before 'case' with the 'case'.
)__",
  true
};

Option<bool> indent_comment = {
  "indent_comment",
  R"__(
Whether to indent comments not found in first column.
)__",
  true
};

Option<bool> indent_col1_comment = {
  "indent_col1_comment",
  R"__(
Whether to indent comments found in first column.
)__"
};

Option<bool> indent_col1_multi_string_literal = {
  "indent_col1_multi_string_literal",
  R"__(
Whether to indent multi string literal in first column.
)__"
};

BoundedOption<unsigned, 0, 16> indent_comment_align_thresh = {
  "indent_comment_align_thresh",
  R"__(
Align comments on adjacent lines that are this many columns apart or less.
)__",
  3
};

Option<bool> indent_ignore_label = {
  "indent_ignore_label",
  R"__(
Whether to ignore indent for goto labels.
)__"
};

BoundedOption<signed, -16, 16> indent_label = {
  "indent_label",
  R"__(
How to indent goto labels. Requires indent_ignore_label=false.

 >0: Absolute column where 1 is the leftmost column
<=0: Subtract from brace indent
)__",
  1
};

BoundedOption<signed, -16, 16> indent_access_spec = {
  "indent_access_spec",
  R"__(
How to indent access specifiers that are followed by a
colon.

 >0: Absolute column where 1 is the leftmost column
<=0: Subtract from brace indent
)__",
  1
};

Option<bool> indent_access_spec_body = {
  "indent_access_spec_body",
  R"__(
Whether to indent the code after an access specifier by one level.
If true, this option forces 'indent_access_spec=0'.
)__"
};

Option<bool> indent_paren_nl = {
  "indent_paren_nl",
  R"__(
If an open parenthesis is followed by a newline, whether to indent the next
line so that it lines up after the open parenthesis (not recommended).
)__"
};

BoundedOption<signed, -1, 2> indent_paren_close = {
  "indent_paren_close",
  R"__(
How to indent a close parenthesis after a newline.

 0: Indent to body level (default)
 1: Align under the open parenthesis
 2: Indent to the brace level
-1: Preserve original indentation
)__"
};

Option<bool> indent_paren_after_func_def = {
  "indent_paren_after_func_def",
  R"__(
Whether to indent the open parenthesis of a function definition,
if the parenthesis is on its own line.
)__"
};

Option<bool> indent_paren_after_func_decl = {
  "indent_paren_after_func_decl",
  R"__(
Whether to indent the open parenthesis of a function declaration,
if the parenthesis is on its own line.
)__"
};

Option<bool> indent_paren_after_func_call = {
  "indent_paren_after_func_call",
  R"__(
Whether to indent the open parenthesis of a function call,
if the parenthesis is on its own line.
)__"
};

BoundedOption<signed, -1, 1> indent_comma_brace = {
  "indent_comma_brace",
  R"__(
How to indent a comma when inside braces.
 0: Indent by one level (default)
 1: Align under the open brace
-1: Preserve original indentation
)__"
};

BoundedOption<signed, -1, 1> indent_comma_paren = {
  "indent_comma_paren",
  R"__(
How to indent a comma when inside parentheses.
 0: Indent by one level (default)
 1: Align under the open parenthesis
-1: Preserve original indentation
)__"
};

BoundedOption<signed, -1, 1> indent_bool_paren = {
  "indent_bool_paren",
  R"__(
How to indent a Boolean operator when inside parentheses.
 0: Indent by one level (default)
 1: Align under the open parenthesis
-1: Preserve original indentation
)__"
};

Option<bool> indent_ignore_bool = {
  "indent_ignore_bool",
  R"__(
Whether to ignore the indentation of a Boolean operator when outside
parentheses.
)__"
};

Option<bool> indent_bool_nested_all = {
  "indent_bool_nested_all",
  R"__(
Whether to indent lines that are nested in boolean expression one more level for each nesting
)__",
  false
};

Option<bool> indent_ignore_arith = {
  "indent_ignore_arith",
  R"__(
Whether to ignore the indentation of an arithmetic operator.
)__"
};

Option<bool> indent_semicolon_for_paren = {
  "indent_semicolon_for_paren",
  R"__(
Whether to indent a semicolon when inside a for parenthesis.
If true, aligns under the open for parenthesis.
)__"
};

Option<bool> indent_ignore_semicolon = {
  "indent_ignore_semicolon",
  R"__(
Whether to ignore the indentation of a semicolon outside of a 'for'
statement.
)__"
};

Option<bool> indent_first_bool_expr = {
  "indent_first_bool_expr",
  R"__(
Whether to align the first expression to following ones
if indent_bool_paren=1.
)__"
};

Option<bool> indent_first_for_expr = {
  "indent_first_for_expr",
  R"__(
Whether to align the first expression to following ones
if indent_semicolon_for_paren=true.
)__"
};

Option<bool> indent_square_nl = {
  "indent_square_nl",
  R"__(
If an open square is followed by a newline, whether to indent the next line
so that it lines up after the open square (not recommended).
)__"
};

Option<bool> indent_preserve_sql = {
  "indent_preserve_sql",
  R"__(
(ESQL/C) Whether to preserve the relative indent of 'EXEC SQL' bodies.
)__"
};

Option<bool> indent_ignore_assign = {
  "indent_ignore_assign",
  R"__(
Whether to ignore the indentation of an assignment operator.
)__"
};

Option<bool> indent_align_assign = {
  "indent_align_assign",
  R"__(
Whether to align continued statements at the '='. If false or if the '=' is
followed by a newline, the next line is indent one tab.
)__",
  true
};

Option<bool> indent_off_after_assign = {
  "indent_off_after_assign",
  R"__(
If true, the indentation of the chunks after a '=' sequence will be set at
LHS token indentation column before '='.
)__"
};

Option<bool> indent_align_paren = {
  "indent_align_paren",
  R"__(
Whether to align continued statements at the '('. If false or the '(' is
followed by a newline, the next line indent is one tab.
)__",
  true
};

Option<bool> indent_oc_inside_msg_sel = {
  "indent_oc_inside_msg_sel",
  R"__(
(OC) Whether to indent Objective-C code inside message selectors.
)__"
};

Option<bool> indent_oc_block = {
  "indent_oc_block",
  R"__(
(OC) Whether to indent Objective-C blocks at brace level instead of usual
rules.
)__"
};

BoundedOption<unsigned, 0, 16> indent_oc_block_msg = {
  "indent_oc_block_msg",
  R"__(
(OC) Indent for Objective-C blocks in a message relative to the parameter
name.

=0: Use indent_oc_block rules
>0: Use specified number of spaces to indent
)__"
};

BoundedOption<unsigned, 0, 5000> indent_oc_msg_colon = {
  "indent_oc_msg_colon",
  R"__(
(OC) Minimum indent for subsequent parameters
)__"
};

Option<bool> indent_oc_msg_prioritize_first_colon = {
  "indent_oc_msg_prioritize_first_colon",
  R"__(
(OC) Whether to prioritize aligning with initial colon (and stripping spaces
from lines, if necessary).
)__",
  true
};

Option<bool> indent_oc_block_msg_xcode_style = {
  "indent_oc_block_msg_xcode_style",
  R"__(
(OC) Whether to indent blocks the way that Xcode does by default
(from the keyword if the parameter is on its own line; otherwise, from the
previous indentation level). Requires indent_oc_block_msg=true.
)__"
};

Option<bool> indent_oc_block_msg_from_keyword = {
  "indent_oc_block_msg_from_keyword",
  R"__(
(OC) Whether to indent blocks from where the brace is, relative to a
message keyword. Requires indent_oc_block_msg=true.
)__"
};

Option<bool> indent_oc_block_msg_from_colon = {
  "indent_oc_block_msg_from_colon",
  R"__(
(OC) Whether to indent blocks from where the brace is, relative to a message
colon. Requires indent_oc_block_msg=true.
)__"
};

Option<bool> indent_oc_block_msg_from_caret = {
  "indent_oc_block_msg_from_caret",
  R"__(
(OC) Whether to indent blocks from where the block caret is.
Requires indent_oc_block_msg=true.
)__"
};

Option<bool> indent_oc_block_msg_from_brace = {
  "indent_oc_block_msg_from_brace",
  R"__(
(OC) Whether to indent blocks from where the brace caret is.
Requires indent_oc_block_msg=true.
)__"
};

BoundedOption<unsigned, 0, 16> indent_min_vbrace_open = {
  "indent_min_vbrace_open",
  R"__(
When indenting after virtual brace open and newline add further spaces to
reach this minimum indent.
)__"
};

Option<bool> indent_vbrace_open_on_tabstop = {
  "indent_vbrace_open_on_tabstop",
  R"__(
Whether to add further spaces after regular indent to reach next tabstop
when indenting after virtual brace open and newline.
)__"
};

Option<bool> indent_token_after_brace = {
  "indent_token_after_brace",
  R"__(
How to indent after a brace followed by another token (not a newline).
true:  indent all contained lines to match the token
false: indent all contained lines to match the brace
)__",
  true
};

Option<bool> indent_cpp_lambda_body = {
  "indent_cpp_lambda_body",
  R"__(
Whether to indent the body of a C++11 lambda.
)__"
};

Option<bool> indent_compound_literal_return = {
  "indent_compound_literal_return",
  R"__(
How to indent compound literals that are being returned.
true: add both the indent from return & the compound literal open brace
      (i.e. 2 indent levels)
false: only indent 1 level, don't add the indent for the open brace, only
       add the indent for the return.
)__",
  true
};

Option<bool> indent_using_block = {
  "indent_using_block",
  R"__(
(C#) Whether to indent a 'using' block if no braces are used.
)__",
  true
};

BoundedOption<unsigned, 0, 2> indent_ternary_operator = {
  "indent_ternary_operator",
  R"__(
How to indent the continuation of ternary operator.

0: Off (default)
1: When the `if_false` is a continuation, indent it under the `if_true` branch
2: When the `:` is a continuation, indent it under `?`
)__"
};

Option<bool> indent_inside_ternary_operator = {
  "indent_inside_ternary_operator",
  R"__(
Whether to indent the statements inside ternary operator.
)__"
};

Option<bool> indent_off_after_return = {
  "indent_off_after_return",
  R"__(
If true, the indentation of the chunks after a `return` sequence will be set at return indentation column.
)__"
};

Option<bool> indent_off_after_return_new = {
  "indent_off_after_return_new",
  R"__(
If true, the indentation of the chunks after a `return new` sequence will be set at return indentation column.
)__"
};

Option<bool> indent_single_after_return = {
  "indent_single_after_return",
  R"__(
If true, the tokens after return are indented with regular single indentation. By default (false) the indentation is after the return token.
)__"
};

Option<bool> indent_ignore_asm_block = {
  "indent_ignore_asm_block",
  R"__(
Whether to ignore indent and alignment for 'asm' blocks (i.e. assume they
have their own indentation).
)__"
};

Option<bool> donot_indent_func_def_close_paren = {
  "donot_indent_func_def_close_paren",
  R"__(
Don't indent the close parenthesis of a function definition,
if the parenthesis is on its own line.
)__"
};

Option<bool> nl_collapse_empty_body = {
  "nl_collapse_empty_body",
  R"__(
Whether to collapse empty blocks between '{' and '}' except for functions.
Use nl_collapse_empty_body_functions to specify how empty function braces
should be formatted.
)__"
};

Option<bool> nl_collapse_empty_body_functions = {
  "nl_collapse_empty_body_functions",
  R"__(
Whether to collapse empty blocks between '{' and '}' for functions only.
If true, overrides nl_inside_empty_func.
)__"
};

Option<bool> nl_assign_leave_one_liners = {
  "nl_assign_leave_one_liners",
  R"__(
Don't split one-line braced assignments, as in 'foo_t f = { 1, 2 };'.
)__"
};

Option<bool> nl_class_leave_one_liners = {
  "nl_class_leave_one_liners",
  R"__(
Don't split one-line braced statements inside a 'class xx { }' body.
)__"
};

Option<bool> nl_enum_leave_one_liners = {
  "nl_enum_leave_one_liners",
  R"__(
Don't split one-line enums, as in 'enum foo { BAR = 15 };'
)__"
};

Option<bool> nl_getset_leave_one_liners = {
  "nl_getset_leave_one_liners",
  R"__(
Don't split one-line get or set functions.
)__"
};

Option<bool> nl_cs_property_leave_one_liners = {
  "nl_cs_property_leave_one_liners",
  R"__(
(C#) Don't split one-line property get or set functions.
)__"
};

Option<bool> nl_func_leave_one_liners = {
  "nl_func_leave_one_liners",
  R"__(
Don't split one-line function definitions, as in 'int foo() { return 0; }'.
might modify nl_func_type_name
)__"
};

Option<bool> nl_cpp_lambda_leave_one_liners = {
  "nl_cpp_lambda_leave_one_liners",
  R"__(
Don't split one-line C++11 lambdas, as in '[]() { return 0; }'.
)__"
};

Option<bool> nl_if_leave_one_liners = {
  "nl_if_leave_one_liners",
  R"__(
Don't split one-line if/else statements, as in 'if(...) b++;'.
)__"
};

Option<bool> nl_while_leave_one_liners = {
  "nl_while_leave_one_liners",
  R"__(
Don't split one-line while statements, as in 'while(...) b++;'.
)__"
};

Option<bool> nl_do_leave_one_liners = {
  "nl_do_leave_one_liners",
  R"__(
Don't split one-line do statements, as in 'do { b++; } while(...);'.
)__"
};

Option<bool> nl_for_leave_one_liners = {
  "nl_for_leave_one_liners",
  R"__(
Don't split one-line for statements, as in 'for(...) b++;'.
)__"
};

Option<bool> nl_oc_msg_leave_one_liner = {
  "nl_oc_msg_leave_one_liner",
  R"__(
(OC) Don't split one-line Objective-C messages.
)__"
};

Option<iarf_e> nl_oc_mdef_brace = {
  "nl_oc_mdef_brace",
  R"__(
(OC) Add or remove newline between method declaration and '{'.
)__"
};

Option<iarf_e> nl_oc_block_brace = {
  "nl_oc_block_brace",
  R"__(
(OC) Add or remove newline between Objective-C block signature and '{'.
)__"
};

Option<iarf_e> nl_oc_before_interface = {
  "nl_oc_before_interface",
  R"__(
(OC) Add or remove blank line before '@interface' statement.
)__"
};

Option<iarf_e> nl_oc_before_implementation = {
  "nl_oc_before_implementation",
  R"__(
(OC) Add or remove blank line before '@implementation' statement.
)__"
};

Option<iarf_e> nl_oc_before_end = {
  "nl_oc_before_end",
  R"__(
(OC) Add or remove blank line before '@end' statement.
)__"
};

Option<iarf_e> nl_oc_interface_brace = {
  "nl_oc_interface_brace",
  R"__(
(OC) Add or remove newline between '@interface' and '{'.
)__"
};

Option<iarf_e> nl_oc_implementation_brace = {
  "nl_oc_implementation_brace",
  R"__(
(OC) Add or remove newline between '@implementation' and '{'.
)__"
};

Option<iarf_e> nl_start_of_file = {
  "nl_start_of_file",
  R"__(
Add or remove newlines at the start of the file.
)__"
};

BoundedOption<unsigned, 0, 16> nl_start_of_file_min = {
  "nl_start_of_file_min",
  R"__(
The minimum number of newlines at the start of the file (only used if
nl_start_of_file is 'add' or 'force').
)__"
};

Option<iarf_e> nl_end_of_file = {
  "nl_end_of_file",
  R"__(
Add or remove newline at the end of the file.
)__"
};

BoundedOption<unsigned, 0, 16> nl_end_of_file_min = {
  "nl_end_of_file_min",
  R"__(
The minimum number of newlines at the end of the file (only used if
nl_end_of_file is 'add' or 'force').
)__"
};

Option<iarf_e> nl_assign_brace = {
  "nl_assign_brace",
  R"__(
Add or remove newline between '=' and '{'.
)__"
};

Option<iarf_e> nl_assign_square = {
  "nl_assign_square",
  R"__(
(D) Add or remove newline between '=' and '['.
)__"
};

Option<iarf_e> nl_tsquare_brace = {
  "nl_tsquare_brace",
  R"__(
Add or remove newline between '[]' and '{'.
)__"
};

Option<iarf_e> nl_after_square_assign = {
  "nl_after_square_assign",
  R"__(
(D) Add or remove newline after '= ['. Will also affect the newline before
the ']'.
)__"
};

Option<iarf_e> nl_fcall_brace = {
  "nl_fcall_brace",
  R"__(
Add or remove newline between a function call's ')' and '{', as in
'list_for_each(item, &list) { }'.
)__"
};

Option<iarf_e> nl_enum_brace = {
  "nl_enum_brace",
  R"__(
Add or remove newline between 'enum' and '{'.
)__"
};

Option<iarf_e> nl_enum_class = {
  "nl_enum_class",
  R"__(
Add or remove newline between 'enum' and 'class'.
)__"
};

Option<iarf_e> nl_enum_class_identifier = {
  "nl_enum_class_identifier",
  R"__(
Add or remove newline between 'enum class' and the identifier.
)__"
};

Option<iarf_e> nl_enum_identifier_colon = {
  "nl_enum_identifier_colon",
  R"__(
Add or remove newline between 'enum class' type and ':'.
)__"
};

Option<iarf_e> nl_enum_colon_type = {
  "nl_enum_colon_type",
  R"__(
Add or remove newline between 'enum class identifier :' and type.
)__"
};

Option<iarf_e> nl_struct_brace = {
  "nl_struct_brace",
  R"__(
Add or remove newline between 'struct and '{'.
)__"
};

Option<iarf_e> nl_union_brace = {
  "nl_union_brace",
  R"__(
Add or remove newline between 'union' and '{'.
)__"
};

Option<iarf_e> nl_if_brace = {
  "nl_if_brace",
  R"__(
Add or remove newline between 'if' and '{'.
)__"
};

Option<iarf_e> nl_brace_else = {
  "nl_brace_else",
  R"__(
Add or remove newline between '}' and 'else'.
)__"
};

Option<iarf_e> nl_elseif_brace = {
  "nl_elseif_brace",
  R"__(
Add or remove newline between 'else if' and '{'. If set to ignore,
nl_if_brace is used instead.
)__"
};

Option<iarf_e> nl_else_brace = {
  "nl_else_brace",
  R"__(
Add or remove newline between 'else' and '{'.
)__"
};

Option<iarf_e> nl_else_if = {
  "nl_else_if",
  R"__(
Add or remove newline between 'else' and 'if'.
)__"
};

Option<iarf_e> nl_before_opening_brace_func_class_def = {
  "nl_before_opening_brace_func_class_def",
  R"__(
Add or remove newline before '{' opening brace
)__"
};

Option<iarf_e> nl_before_if_closing_paren = {
  "nl_before_if_closing_paren",
  R"__(
Add or remove newline before 'if'/'else if' closing parenthesis.
)__"
};

Option<iarf_e> nl_brace_finally = {
  "nl_brace_finally",
  R"__(
Add or remove newline between '}' and 'finally'.
)__"
};

Option<iarf_e> nl_finally_brace = {
  "nl_finally_brace",
  R"__(
Add or remove newline between 'finally' and '{'.
)__"
};

Option<iarf_e> nl_try_brace = {
  "nl_try_brace",
  R"__(
Add or remove newline between 'try' and '{'.
)__"
};

Option<iarf_e> nl_getset_brace = {
  "nl_getset_brace",
  R"__(
Add or remove newline between get/set and '{'.
)__"
};

Option<iarf_e> nl_for_brace = {
  "nl_for_brace",
  R"__(
Add or remove newline between 'for' and '{'.
)__"
};

Option<iarf_e> nl_catch_brace = {
  "nl_catch_brace",
  R"__(
Add or remove newline before the '{' of a 'catch' statement, as in
'catch (decl) <here> {'.
)__"
};

Option<iarf_e> nl_oc_catch_brace = {
  "nl_oc_catch_brace",
  R"__(
(OC) Add or remove newline before the '{' of a '@catch' statement, as in
'@catch (decl) <here> {'. If set to ignore, nl_catch_brace is used.
)__"
};

Option<iarf_e> nl_brace_catch = {
  "nl_brace_catch",
  R"__(
Add or remove newline between '}' and 'catch'.
)__"
};

Option<iarf_e> nl_oc_brace_catch = {
  "nl_oc_brace_catch",
  R"__(
(OC) Add or remove newline between '}' and '@catch'. If set to ignore,
nl_brace_catch is used.
)__"
};

Option<iarf_e> nl_brace_square = {
  "nl_brace_square",
  R"__(
Add or remove newline between '}' and ']'.
)__"
};

Option<iarf_e> nl_brace_fparen = {
  "nl_brace_fparen",
  R"__(
Add or remove newline between '}' and ')' in a function invocation.
)__"
};

Option<iarf_e> nl_while_brace = {
  "nl_while_brace",
  R"__(
Add or remove newline between 'while' and '{'.
)__"
};

Option<iarf_e> nl_scope_brace = {
  "nl_scope_brace",
  R"__(
(D) Add or remove newline between 'scope (x)' and '{'.
)__"
};

Option<iarf_e> nl_unittest_brace = {
  "nl_unittest_brace",
  R"__(
(D) Add or remove newline between 'unittest' and '{'.
)__"
};

Option<iarf_e> nl_version_brace = {
  "nl_version_brace",
  R"__(
(D) Add or remove newline between 'version (x)' and '{'.
)__"
};

Option<iarf_e> nl_using_brace = {
  "nl_using_brace",
  R"__(
(C#) Add or remove newline between 'using' and '{'.
)__"
};

Option<iarf_e> nl_brace_brace = {
  "nl_brace_brace",
  R"__(
Add or remove newline between two open or close braces. Due to general
newline/brace handling, REMOVE may not work.
)__"
};

Option<iarf_e> nl_do_brace = {
  "nl_do_brace",
  R"__(
Add or remove newline between 'do' and '{'.
)__"
};

Option<iarf_e> nl_brace_while = {
  "nl_brace_while",
  R"__(
Add or remove newline between '}' and 'while' of 'do' statement.
)__"
};

Option<iarf_e> nl_switch_brace = {
  "nl_switch_brace",
  R"__(
Add or remove newline between 'switch' and '{'.
)__"
};

Option<iarf_e> nl_synchronized_brace = {
  "nl_synchronized_brace",
  R"__(
Add or remove newline between 'synchronized' and '{'.
)__"
};

Option<bool> nl_multi_line_cond = {
  "nl_multi_line_cond",
  R"__(
Add a newline between ')' and '{' if the ')' is on a different line than the
if/for/etc.

Overrides nl_for_brace, nl_if_brace, nl_switch_brace, nl_while_switch and
nl_catch_brace.
)__"
};

Option<iarf_e> nl_multi_line_sparen_open = {
  "nl_multi_line_sparen_open",
  R"__(
Add a newline after '(' if an if/for/while/switch condition spans multiple
lines
)__"
};

Option<iarf_e> nl_multi_line_sparen_close = {
  "nl_multi_line_sparen_close",
  R"__(
Add a newline before ')' if an if/for/while/switch condition spans multiple
lines. Overrides nl_before_if_closing_paren if both are specified.
)__"
};

Option<bool> nl_multi_line_define = {
  "nl_multi_line_define",
  R"__(
Force a newline in a define after the macro name for multi-line defines.
)__"
};

Option<bool> nl_before_case = {
  "nl_before_case",
  R"__(
Whether to add a newline before 'case', and a blank line before a 'case'
statement that follows a ';' or '}'.
)__"
};

Option<bool> nl_after_case = {
  "nl_after_case",
  R"__(
Whether to add a newline after a 'case' statement.
)__"
};

Option<iarf_e> nl_case_colon_brace = {
  "nl_case_colon_brace",
  R"__(
Add or remove newline between a case ':' and '{'.

Overrides nl_after_case.
)__"
};

Option<iarf_e> nl_before_throw = {
  "nl_before_throw",
  R"__(
Add or remove newline between ')' and 'throw'.
)__"
};

Option<iarf_e> nl_namespace_brace = {
  "nl_namespace_brace",
  R"__(
Add or remove newline between 'namespace' and '{'.
)__"
};

Option<iarf_e> nl_template_class = {
  "nl_template_class",
  R"__(
Add or remove newline after 'template<...>' of a template class.
)__"
};

Option<iarf_e> nl_template_class_decl = {
  "nl_template_class_decl",
  R"__(
Add or remove newline after 'template<...>' of a template class declaration.

Overrides nl_template_class.
)__"
};

Option<iarf_e> nl_template_class_decl_special = {
  "nl_template_class_decl_special",
  R"__(
Add or remove newline after 'template<>' of a specialized class declaration.

Overrides nl_template_class_decl.
)__"
};

Option<iarf_e> nl_template_class_def = {
  "nl_template_class_def",
  R"__(
Add or remove newline after 'template<...>' of a template class definition.

Overrides nl_template_class.
)__"
};

Option<iarf_e> nl_template_class_def_special = {
  "nl_template_class_def_special",
  R"__(
Add or remove newline after 'template<>' of a specialized class definition.

Overrides nl_template_class_def.
)__"
};

Option<iarf_e> nl_template_func = {
  "nl_template_func",
  R"__(
Add or remove newline after 'template<...>' of a template function.
)__"
};

Option<iarf_e> nl_template_func_decl = {
  "nl_template_func_decl",
  R"__(
Add or remove newline after 'template<...>' of a template function
declaration.

Overrides nl_template_func.
)__"
};

Option<iarf_e> nl_template_func_decl_special = {
  "nl_template_func_decl_special",
  R"__(
Add or remove newline after 'template<>' of a specialized function
declaration.

Overrides nl_template_func_decl.
)__"
};

Option<iarf_e> nl_template_func_def = {
  "nl_template_func_def",
  R"__(
Add or remove newline after 'template<...>' of a template function
definition.

Overrides nl_template_func.
)__"
};

Option<iarf_e> nl_template_func_def_special = {
  "nl_template_func_def_special",
  R"__(
Add or remove newline after 'template<>' of a specialized function
definition.

Overrides nl_template_func_def.
)__"
};

Option<iarf_e> nl_template_var = {
  "nl_template_var",
  R"__(
Add or remove newline after 'template<...>' of a template variable.
)__"
};

Option<iarf_e> nl_template_using = {
  "nl_template_using",
  R"__(
Add or remove newline between 'template<...>' and 'using' of a templated
type alias.
)__"
};

Option<iarf_e> nl_class_brace = {
  "nl_class_brace",
  R"__(
Add or remove newline between 'class' and '{'.
)__"
};

Option<iarf_e> nl_class_init_args = {
  "nl_class_init_args",
  R"__(
Add or remove newline before or after (depending on pos_class_comma,
may not be IGNORE) each',' in the base class list.
)__"
};

Option<iarf_e> nl_constr_init_args = {
  "nl_constr_init_args",
  R"__(
Add or remove newline after each ',' in the constructor member
initialization. Related to nl_constr_colon, pos_constr_colon and
pos_constr_comma.
)__"
};

Option<iarf_e> nl_enum_own_lines = {
  "nl_enum_own_lines",
  R"__(
Add or remove newline before first element, after comma, and after last
element, in 'enum'.
)__"
};

Option<iarf_e> nl_func_type_name = {
  "nl_func_type_name",
  R"__(
Add or remove newline between return type and function name in a function
definition.
might be modified by nl_func_leave_one_liners
)__"
};

Option<iarf_e> nl_func_type_name_class = {
  "nl_func_type_name_class",
  R"__(
Add or remove newline between return type and function name inside a class
definition. If set to ignore, nl_func_type_name or nl_func_proto_type_name
is used instead.
)__"
};

Option<iarf_e> nl_func_class_scope = {
  "nl_func_class_scope",
  R"__(
Add or remove newline between class specification and '::'
in 'void A::f() { }'. Only appears in separate member implementation (does
not appear with in-line implementation).
)__"
};

Option<iarf_e> nl_func_scope_name = {
  "nl_func_scope_name",
  R"__(
Add or remove newline between function scope and name, as in
'void A :: <here> f() { }'.
)__"
};

Option<iarf_e> nl_func_proto_type_name = {
  "nl_func_proto_type_name",
  R"__(
Add or remove newline between return type and function name in a prototype.
)__"
};

Option<iarf_e> nl_func_paren = {
  "nl_func_paren",
  R"__(
Add or remove newline between a function name and the opening '(' in the
declaration.
)__"
};

Option<iarf_e> nl_func_paren_empty = {
  "nl_func_paren_empty",
  R"__(
Overrides nl_func_paren for functions with no parameters.
)__"
};

Option<iarf_e> nl_func_def_paren = {
  "nl_func_def_paren",
  R"__(
Add or remove newline between a function name and the opening '(' in the
definition.
)__"
};

Option<iarf_e> nl_func_def_paren_empty = {
  "nl_func_def_paren_empty",
  R"__(
Overrides nl_func_def_paren for functions with no parameters.
)__"
};

Option<iarf_e> nl_func_call_paren = {
  "nl_func_call_paren",
  R"__(
Add or remove newline between a function name and the opening '(' in the
call.
)__"
};

Option<iarf_e> nl_func_call_paren_empty = {
  "nl_func_call_paren_empty",
  R"__(
Overrides nl_func_call_paren for functions with no parameters.
)__"
};

Option<iarf_e> nl_func_decl_start = {
  "nl_func_decl_start",
  R"__(
Add or remove newline after '(' in a function declaration.
)__"
};

Option<iarf_e> nl_func_def_start = {
  "nl_func_def_start",
  R"__(
Add or remove newline after '(' in a function definition.
)__"
};

Option<iarf_e> nl_func_decl_start_single = {
  "nl_func_decl_start_single",
  R"__(
Overrides nl_func_decl_start when there is only one parameter.
)__"
};

Option<iarf_e> nl_func_def_start_single = {
  "nl_func_def_start_single",
  R"__(
Overrides nl_func_def_start when there is only one parameter.
)__"
};

Option<bool> nl_func_decl_start_multi_line = {
  "nl_func_decl_start_multi_line",
  R"__(
Whether to add a newline after '(' in a function declaration if '(' and ')'
are in different lines. If false, nl_func_decl_start is used instead.
)__"
};

Option<bool> nl_func_def_start_multi_line = {
  "nl_func_def_start_multi_line",
  R"__(
Whether to add a newline after '(' in a function definition if '(' and ')'
are in different lines. If false, nl_func_def_start is used instead.
)__"
};

Option<iarf_e> nl_func_decl_args = {
  "nl_func_decl_args",
  R"__(
Add or remove newline after each ',' in a function declaration.
)__"
};

Option<iarf_e> nl_func_def_args = {
  "nl_func_def_args",
  R"__(
Add or remove newline after each ',' in a function definition.
)__"
};

Option<iarf_e> nl_func_call_args = {
  "nl_func_call_args",
  R"__(
Add or remove newline after each ',' in a function call.
)__"
};

Option<bool> nl_func_decl_args_multi_line = {
  "nl_func_decl_args_multi_line",
  R"__(
Whether to add a newline after each ',' in a function declaration if '('
and ')' are in different lines. If false, nl_func_decl_args is used instead.
)__"
};

Option<bool> nl_func_def_args_multi_line = {
  "nl_func_def_args_multi_line",
  R"__(
Whether to add a newline after each ',' in a function definition if '('
and ')' are in different lines. If false, nl_func_def_args is used instead.
)__"
};

Option<iarf_e> nl_func_decl_end = {
  "nl_func_decl_end",
  R"__(
Add or remove newline before the ')' in a function declaration.
)__"
};

Option<iarf_e> nl_func_def_end = {
  "nl_func_def_end",
  R"__(
Add or remove newline before the ')' in a function definition.
)__"
};

Option<iarf_e> nl_func_decl_end_single = {
  "nl_func_decl_end_single",
  R"__(
Overrides nl_func_decl_end when there is only one parameter.
)__"
};

Option<iarf_e> nl_func_def_end_single = {
  "nl_func_def_end_single",
  R"__(
Overrides nl_func_def_end when there is only one parameter.
)__"
};

Option<bool> nl_func_decl_end_multi_line = {
  "nl_func_decl_end_multi_line",
  R"__(
Whether to add a newline before ')' in a function declaration if '(' and ')'
are in different lines. If false, nl_func_decl_end is used instead.
)__"
};

Option<bool> nl_func_def_end_multi_line = {
  "nl_func_def_end_multi_line",
  R"__(
Whether to add a newline before ')' in a function definition if '(' and ')'
are in different lines. If false, nl_func_def_end is used instead.
)__"
};

Option<iarf_e> nl_func_decl_empty = {
  "nl_func_decl_empty",
  R"__(
Add or remove newline between '()' in a function declaration.
)__"
};

Option<iarf_e> nl_func_def_empty = {
  "nl_func_def_empty",
  R"__(
Add or remove newline between '()' in a function definition.
)__"
};

Option<iarf_e> nl_func_call_empty = {
  "nl_func_call_empty",
  R"__(
Add or remove newline between '()' in a function call.
)__"
};

Option<iarf_e> nl_func_call_start = {
  "nl_func_call_start",
  R"__(
Whether to add a newline after '(' in a function call,
has preference over nl_func_call_start_multi_line.
)__"
};

Option<iarf_e> nl_func_call_end = {
  "nl_func_call_end",
  R"__(
Whether to add a newline before ')' in a function call.
)__"
};

Option<bool> nl_func_call_start_multi_line = {
  "nl_func_call_start_multi_line",
  R"__(
Whether to add a newline after '(' in a function call if '(' and ')' are in
different lines.
)__"
};

Option<bool> nl_func_call_args_multi_line = {
  "nl_func_call_args_multi_line",
  R"__(
Whether to add a newline after each ',' in a function call if '(' and ')'
are in different lines.
)__"
};

Option<bool> nl_func_call_end_multi_line = {
  "nl_func_call_end_multi_line",
  R"__(
Whether to add a newline before ')' in a function call if '(' and ')' are in
different lines.
)__"
};

Option<bool> nl_func_call_args_multi_line_ignore_closures = {
  "nl_func_call_args_multi_line_ignore_closures",
  R"__(
Whether to respect nl_func_call_XXX option in case of closure args.
)__"
};

Option<bool> nl_template_start = {
  "nl_template_start",
  R"__(
Whether to add a newline after '<' of a template parameter list.
)__"
};

Option<bool> nl_template_args = {
  "nl_template_args",
  R"__(
Whether to add a newline after each ',' in a template parameter list.
)__"
};

Option<bool> nl_template_end = {
  "nl_template_end",
  R"__(
Whether to add a newline before '>' of a template parameter list.
)__"
};

Option<bool> nl_oc_msg_args = {
  "nl_oc_msg_args",
  R"__(
(OC) Whether to put each Objective-C message parameter on a separate line.
See nl_oc_msg_leave_one_liner.
)__"
};

BoundedOption<unsigned, 0, 16> nl_oc_msg_args_min_params = {
  "nl_oc_msg_args_min_params",
  R"__(
(OC) Minimum number of Objective-C message parameters before applying nl_oc_msg_args.
)__"
};

BoundedOption<unsigned, 0, 10000> nl_oc_msg_args_max_code_width = {
  "nl_oc_msg_args_max_code_width",
  R"__(
(OC) Max code width of Objective-C message before applying nl_oc_msg_args.
)__"
};

Option<bool> nl_oc_msg_args_finish_multi_line = {
  "nl_oc_msg_args_finish_multi_line",
  R"__(
(OC) Whether to apply nl_oc_msg_args if some of the parameters are already
on new lines. Overrides nl_oc_msg_args_min_params and nl_oc_msg_args_max_code_width.
)__"
};

Option<iarf_e> nl_fdef_brace = {
  "nl_fdef_brace",
  R"__(
Add or remove newline between function signature and '{'.
)__"
};

Option<iarf_e> nl_fdef_brace_cond = {
  "nl_fdef_brace_cond",
  R"__(
Add or remove newline between function signature and '{',
if signature ends with ')'. Overrides nl_fdef_brace.
)__"
};

Option<iarf_e> nl_cpp_ldef_brace = {
  "nl_cpp_ldef_brace",
  R"__(
Add or remove newline between C++11 lambda signature and '{'.
)__"
};

Option<iarf_e> nl_return_expr = {
  "nl_return_expr",
  R"__(
Add or remove newline between 'return' and the return expression.
)__"
};

Option<iarf_e> nl_throw_expr = {
  "nl_throw_expr",
  R"__(
Add or remove newline between 'throw' and the throw expression.
)__"
};

Option<bool> nl_after_semicolon = {
  "nl_after_semicolon",
  R"__(
Whether to add a newline after semicolons, except in 'for' statements.
)__"
};

Option<iarf_e> nl_paren_dbrace_open = {
  "nl_paren_dbrace_open",
  R"__(
(Java) Add or remove newline between the ')' and '{{' of the double brace
initializer.
)__"
};

Option<iarf_e> nl_type_brace_init_lst = {
  "nl_type_brace_init_lst",
  R"__(
Whether to add a newline after the type in an unnamed temporary
direct-list-initialization, better:
before a direct-list-initialization.
)__"
};

Option<iarf_e> nl_type_brace_init_lst_open = {
  "nl_type_brace_init_lst_open",
  R"__(
Whether to add a newline after the open brace in an unnamed temporary
direct-list-initialization.
)__"
};

Option<iarf_e> nl_type_brace_init_lst_close = {
  "nl_type_brace_init_lst_close",
  R"__(
Whether to add a newline before the close brace in an unnamed temporary
direct-list-initialization.
)__"
};

Option<bool> nl_before_brace_open = {
  "nl_before_brace_open",
  R"__(
Whether to add a newline before '{'.
)__"
};

Option<bool> nl_after_brace_open = {
  "nl_after_brace_open",
  R"__(
Whether to add a newline after '{'.
)__"
};

Option<bool> nl_after_brace_open_cmt = {
  "nl_after_brace_open_cmt",
  R"__(
Whether to add a newline between the open brace and a trailing single-line
comment. Requires nl_after_brace_open=true.
)__"
};

Option<bool> nl_after_vbrace_open = {
  "nl_after_vbrace_open",
  R"__(
Whether to add a newline after a virtual brace open with a non-empty body.
These occur in un-braced if/while/do/for statement bodies.
)__"
};

Option<bool> nl_after_vbrace_open_empty = {
  "nl_after_vbrace_open_empty",
  R"__(
Whether to add a newline after a virtual brace open with an empty body.
These occur in un-braced if/while/do/for statement bodies.
)__"
};

Option<bool> nl_after_brace_close = {
  "nl_after_brace_close",
  R"__(
Whether to add a newline after '}'. Does not apply if followed by a
necessary ';'.
)__"
};

Option<bool> nl_after_vbrace_close = {
  "nl_after_vbrace_close",
  R"__(
Whether to add a newline after a virtual brace close,
as in 'if (foo) a++; <here> return;'.
)__"
};

Option<iarf_e> nl_brace_struct_var = {
  "nl_brace_struct_var",
  R"__(
Add or remove newline between the close brace and identifier,
as in 'struct { int a; } <here> b;'. Affects enumerations, unions and
structures. If set to ignore, uses nl_after_brace_close.
)__"
};

Option<bool> nl_bool_expr_hierarchical = {
  "nl_bool_expr_hierarchical",
  R"__(
Whether to add a newline before/after each '&&' or `||` on the same
nesting level in a boolean expression if boolean expression will not
fit on a line. code_width needs to be positive and pos_bool needs
to be 'lead' or 'trail' for this option to have any effect.
)__",
  false
};

Option<bool> nl_define_macro = {
  "nl_define_macro",
  R"__(
Whether to alter newlines in '#define' macros.
)__"
};

Option<bool> nl_squeeze_paren_close = {
  "nl_squeeze_paren_close",
  R"__(
Whether to alter newlines between consecutive parenthesis closes. The number
of closing parentheses in a line will depend on respective open parenthesis
lines.
)__"
};

Option<bool> nl_squeeze_ifdef = {
  "nl_squeeze_ifdef",
  R"__(
Whether to remove blanks after '#ifxx' and '#elxx', or before '#elxx' and
'#endif'. Does not affect top-level #ifdefs.
)__"
};

Option<bool> nl_squeeze_ifdef_top_level = {
  "nl_squeeze_ifdef_top_level",
  R"__(
Makes the nl_squeeze_ifdef option affect the top-level #ifdefs as well.
)__"
};

Option<iarf_e> nl_before_if = {
  "nl_before_if",
  R"__(
Add or remove blank line before 'if'.
)__"
};

Option<iarf_e> nl_after_if = {
  "nl_after_if",
  R"__(
Add or remove blank line after 'if' statement. Add/Force work only if the
next token is not a closing brace.
)__"
};

Option<iarf_e> nl_before_for = {
  "nl_before_for",
  R"__(
Add or remove blank line before 'for'.
)__"
};

Option<iarf_e> nl_after_for = {
  "nl_after_for",
  R"__(
Add or remove blank line after 'for' statement.
)__"
};

Option<iarf_e> nl_before_while = {
  "nl_before_while",
  R"__(
Add or remove blank line before 'while'.
)__"
};

Option<iarf_e> nl_after_while = {
  "nl_after_while",
  R"__(
Add or remove blank line after 'while' statement.
)__"
};

Option<iarf_e> nl_before_switch = {
  "nl_before_switch",
  R"__(
Add or remove blank line before 'switch'.
)__"
};

Option<iarf_e> nl_after_switch = {
  "nl_after_switch",
  R"__(
Add or remove blank line after 'switch' statement.
)__"
};

Option<iarf_e> nl_before_synchronized = {
  "nl_before_synchronized",
  R"__(
Add or remove blank line before 'synchronized'.
)__"
};

Option<iarf_e> nl_after_synchronized = {
  "nl_after_synchronized",
  R"__(
Add or remove blank line after 'synchronized' statement.
)__"
};

Option<iarf_e> nl_before_do = {
  "nl_before_do",
  R"__(
Add or remove blank line before 'do'.
)__"
};

Option<iarf_e> nl_after_do = {
  "nl_after_do",
  R"__(
Add or remove blank line after 'do/while' statement.
)__"
};

Option<bool> nl_before_ignore_after_case = {
  "nl_before_ignore_after_case",
  R"__(
Ignore nl_before_{if,for,switch,do,synchronized} if the control
statement is immediately after a case statement.
if nl_before_{if,for,switch,do} is set to remove, this option
does nothing.
)__"
};

Option<bool> nl_before_return = {
  "nl_before_return",
  R"__(
Whether to put a blank line before 'return' statements, unless after an open
brace.
)__"
};

Option<bool> nl_after_return = {
  "nl_after_return",
  R"__(
Whether to put a blank line after 'return' statements, unless followed by a
close brace.
)__"
};

Option<iarf_e> nl_before_member = {
  "nl_before_member",
  R"__(
Whether to put a blank line before a member '.' or '->' operators.
)__"
};

Option<iarf_e> nl_after_member = {
  "nl_after_member",
  R"__(
(Java) Whether to put a blank line after a member '.' or '->' operators.
)__"
};

Option<bool> nl_ds_struct_enum_cmt = {
  "nl_ds_struct_enum_cmt",
  R"__(
Whether to double-space commented-entries in 'struct'/'union'/'enum'.
)__"
};

Option<bool> nl_ds_struct_enum_close_brace = {
  "nl_ds_struct_enum_close_brace",
  R"__(
Whether to force a newline before '}' of a 'struct'/'union'/'enum'.
(Lower priority than eat_blanks_before_close_brace.)
)__"
};

Option<iarf_e> nl_class_colon = {
  "nl_class_colon",
  R"__(
Add or remove newline before or after (depending on pos_class_colon) a class
colon, as in 'class Foo <here> : <or here> public Bar'.
)__"
};

Option<iarf_e> nl_constr_colon = {
  "nl_constr_colon",
  R"__(
Add or remove newline around a class constructor colon. The exact position
depends on nl_constr_init_args, pos_constr_colon and pos_constr_comma.
)__"
};

Option<bool> nl_namespace_two_to_one_liner = {
  "nl_namespace_two_to_one_liner",
  R"__(
Whether to collapse a two-line namespace, like 'namespace foo\n{ decl; }'
into a single line. If true, prevents other brace newline rules from turning
such code into four lines. If true, it also preserves one-liner namespaces.
)__"
};

Option<bool> nl_create_if_one_liner = {
  "nl_create_if_one_liner",
  R"__(
Whether to remove a newline in simple unbraced if statements, turning them
into one-liners, as in 'if(b)\n i++;' => 'if(b) i++;'.
)__"
};

Option<bool> nl_create_for_one_liner = {
  "nl_create_for_one_liner",
  R"__(
Whether to remove a newline in simple unbraced for statements, turning them
into one-liners, as in 'for (...)\n stmt;' => 'for (...) stmt;'.
)__"
};

Option<bool> nl_create_while_one_liner = {
  "nl_create_while_one_liner",
  R"__(
Whether to remove a newline in simple unbraced while statements, turning
them into one-liners, as in 'while (expr)\n stmt;' => 'while (expr) stmt;'.
)__"
};

Option<bool> nl_create_func_def_one_liner = {
  "nl_create_func_def_one_liner",
  R"__(
Whether to collapse a function definition whose body (not counting braces)
is only one line so that the entire definition (prototype, braces, body) is
a single line.
)__"
};

Option<bool> nl_create_list_one_liner = {
  "nl_create_list_one_liner",
  R"__(
Whether to split one-line simple list definitions into three lines by
adding newlines, as in 'int a[12] = { <here> 0 <here> };'.
)__"
};

Option<bool> nl_split_if_one_liner = {
  "nl_split_if_one_liner",
  R"__(
Whether to split one-line simple unbraced if statements into two lines by
adding a newline, as in 'if(b) <here> i++;'.
)__"
};

Option<bool> nl_split_for_one_liner = {
  "nl_split_for_one_liner",
  R"__(
Whether to split one-line simple unbraced for statements into two lines by
adding a newline, as in 'for (...) <here> stmt;'.
)__"
};

Option<bool> nl_split_while_one_liner = {
  "nl_split_while_one_liner",
  R"__(
Whether to split one-line simple unbraced while statements into two lines by
adding a newline, as in 'while (expr) <here> stmt;'.
)__"
};

Option<bool> donot_add_nl_before_cpp_comment = {
  "donot_add_nl_before_cpp_comment",
  R"__(
Don't add a newline before a cpp-comment in a parameter list of a function
call.
)__"
};

BoundedOption<unsigned, 0, 16> nl_max = {
  "nl_max",
  R"__(
The maximum number of consecutive newlines (3 = 2 blank lines).
)__"
};

BoundedOption<unsigned, 0, 16> nl_max_blank_in_func = {
  "nl_max_blank_in_func",
  R"__(
The maximum number of consecutive newlines in a function.
)__"
};

BoundedOption<unsigned, 0, 16> nl_inside_empty_func = {
  "nl_inside_empty_func",
  R"__(
The number of newlines inside an empty function body.
This option overrides eat_blanks_after_open_brace and
eat_blanks_before_close_brace, but is ignored when
nl_collapse_empty_body_functions=true
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_func_body_proto = {
  "nl_before_func_body_proto",
  R"__(
The number of newlines before a function prototype.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_func_body_def = {
  "nl_before_func_body_def",
  R"__(
The number of newlines before a multi-line function definition. Where
applicable, this option is overridden with eat_blanks_after_open_brace=true
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_func_class_proto = {
  "nl_before_func_class_proto",
  R"__(
The number of newlines before a class constructor/destructor prototype.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_func_class_def = {
  "nl_before_func_class_def",
  R"__(
The number of newlines before a class constructor/destructor definition.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_func_proto = {
  "nl_after_func_proto",
  R"__(
The number of newlines after a function prototype.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_func_proto_group = {
  "nl_after_func_proto_group",
  R"__(
The number of newlines after a function prototype, if not followed by
another function prototype.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_func_class_proto = {
  "nl_after_func_class_proto",
  R"__(
The number of newlines after a class constructor/destructor prototype.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_func_class_proto_group = {
  "nl_after_func_class_proto_group",
  R"__(
The number of newlines after a class constructor/destructor prototype,
if not followed by another constructor/destructor prototype.
)__"
};

Option<bool> nl_class_leave_one_liner_groups = {
  "nl_class_leave_one_liner_groups",
  R"__(
Whether one-line method definitions inside a class body should be treated
as if they were prototypes for the purposes of adding newlines.

Requires nl_class_leave_one_liners=true. Overrides nl_before_func_body_def
and nl_before_func_class_def for one-liners.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_func_body = {
  "nl_after_func_body",
  R"__(
The number of newlines after '}' of a multi-line function body.

Overrides nl_min_after_func_body and nl_max_after_func_body.
)__"
};

BoundedOption<unsigned, 0, 16> nl_min_after_func_body = {
  "nl_min_after_func_body",
  R"__(
The minimum number of newlines after '}' of a multi-line function body.

Only works when nl_after_func_body is 0.
)__"
};

BoundedOption<unsigned, 0, 16> nl_max_after_func_body = {
  "nl_max_after_func_body",
  R"__(
The maximum number of newlines after '}' of a multi-line function body.

Only works when nl_after_func_body is 0.
Takes precedence over nl_min_after_func_body.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_func_body_class = {
  "nl_after_func_body_class",
  R"__(
The number of newlines after '}' of a multi-line function body in a class
declaration. Also affects class constructors/destructors.

Overrides nl_after_func_body.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_func_body_one_liner = {
  "nl_after_func_body_one_liner",
  R"__(
The number of newlines after '}' of a single line function body. Also
affects class constructors/destructors.

Overrides nl_after_func_body and nl_after_func_body_class.
)__"
};

BoundedOption<unsigned, 0, 16> nl_typedef_blk_start = {
  "nl_typedef_blk_start",
  R"__(
The number of newlines before a block of typedefs. If nl_after_access_spec
is non-zero, that option takes precedence.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_typedef_blk_end = {
  "nl_typedef_blk_end",
  R"__(
The number of newlines after a block of typedefs.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_typedef_blk_in = {
  "nl_typedef_blk_in",
  R"__(
The maximum number of consecutive newlines within a block of typedefs.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_var_def_blk_end_func_top = {
  "nl_var_def_blk_end_func_top",
  R"__(
The minimum number of blank lines after a block of variable definitions
at the top of a function body. If any preprocessor directives appear
between the opening brace of the function and the variable block, then
it is considered as not at the top of the function.Newlines are added
before trailing preprocessor directives, if any exist.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_var_def_blk_start = {
  "nl_var_def_blk_start",
  R"__(
The minimum number of empty newlines before a block of variable definitions
not at the top of a function body. If nl_after_access_spec is non-zero,
that option takes precedence. Newlines are not added at the top of the
file or just after an opening brace. Newlines are added above any
preprocessor directives before the block.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_var_def_blk_end = {
  "nl_var_def_blk_end",
  R"__(
The minimum number of empty newlines after a block of variable definitions
not at the top of a function body. Newlines are not added if the block
is at the bottom of the file or just before a preprocessor directive.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_var_def_blk_in = {
  "nl_var_def_blk_in",
  R"__(
The maximum number of consecutive newlines within a block of variable
definitions.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_block_comment = {
  "nl_before_block_comment",
  R"__(
The minimum number of newlines before a multi-line comment.
Doesn't apply if after a brace open or another multi-line comment.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_c_comment = {
  "nl_before_c_comment",
  R"__(
The minimum number of newlines before a single-line C comment.
Doesn't apply if after a brace open or other single-line C comments.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_cpp_comment = {
  "nl_before_cpp_comment",
  R"__(
The minimum number of newlines before a CPP comment.
Doesn't apply if after a brace open or other CPP comments.
)__"
};

Option<bool> nl_after_multiline_comment = {
  "nl_after_multiline_comment",
  R"__(
Whether to force a newline after a multi-line comment.
)__"
};

Option<bool> nl_after_label_colon = {
  "nl_after_label_colon",
  R"__(
Whether to force a newline after a label's colon.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_struct = {
  "nl_before_struct",
  R"__(
The number of newlines before a struct definition.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_struct = {
  "nl_after_struct",
  R"__(
The number of newlines after '}' or ';' of a struct/enum/union definition.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_class = {
  "nl_before_class",
  R"__(
The number of newlines before a class definition.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_class = {
  "nl_after_class",
  R"__(
The number of newlines after '}' or ';' of a class definition.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_namespace = {
  "nl_before_namespace",
  R"__(
The number of newlines before a namespace.
)__"
};

BoundedOption<unsigned, 0, 16> nl_inside_namespace = {
  "nl_inside_namespace",
  R"__(
The number of newlines after '{' of a namespace. This also adds newlines
before the matching '}'.

0: Apply eat_blanks_after_open_brace or eat_blanks_before_close_brace if
    applicable, otherwise no change.

Overrides eat_blanks_after_open_brace and eat_blanks_before_close_brace.
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_namespace = {
  "nl_after_namespace",
  R"__(
The number of newlines after '}' of a namespace.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_access_spec = {
  "nl_before_access_spec",
  R"__(
The number of newlines before an access specifier label. This also includes
the Qt-specific 'signals:' and 'slots:'. Will not change the newline count
if after a brace open.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_access_spec = {
  "nl_after_access_spec",
  R"__(
The number of newlines after an access specifier label. This also includes
the Qt-specific 'signals:' and 'slots:'. Will not change the newline count
if after a brace open.

0: No change (default).

Overrides nl_typedef_blk_start and nl_var_def_blk_start.
)__"
};

BoundedOption<unsigned, 0, 16> nl_comment_func_def = {
  "nl_comment_func_def",
  R"__(
The number of newlines between a function definition and the function
comment, as in '/* comment */ <here> void foo() {...}'.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_try_catch_finally = {
  "nl_after_try_catch_finally",
  R"__(
The number of newlines after a try-catch-finally block that isn't followed
by a brace close.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_around_cs_property = {
  "nl_around_cs_property",
  R"__(
(C#) The number of newlines before and after a property, indexer or event
declaration.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_between_get_set = {
  "nl_between_get_set",
  R"__(
(C#) The number of newlines between the get/set/add/remove handlers.

0: No change (default).
)__"
};

Option<iarf_e> nl_property_brace = {
  "nl_property_brace",
  R"__(
(C#) Add or remove newline between property and the '{'.
)__"
};

Option<bool> eat_blanks_after_open_brace = {
  "eat_blanks_after_open_brace",
  R"__(
Whether to remove blank lines after '{'.
)__"
};

Option<bool> eat_blanks_before_close_brace = {
  "eat_blanks_before_close_brace",
  R"__(
Whether to remove blank lines before '}'.
)__"
};

BoundedOption<unsigned, 0, 2> nl_remove_extra_newlines = {
  "nl_remove_extra_newlines",
  R"__(
How aggressively to remove extra newlines not in preprocessor.

0: No change (default)
1: Remove most newlines not handled by other config
2: Remove all newlines and reformat completely by config
)__"
};

Option<iarf_e> nl_after_annotation = {
  "nl_after_annotation",
  R"__(
(Java) Add or remove newline after an annotation statement. Only affects
annotations that are after a newline.
)__"
};

Option<iarf_e> nl_between_annotation = {
  "nl_between_annotation",
  R"__(
(Java) Add or remove newline between two annotations.
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_whole_file_ifdef = {
  "nl_before_whole_file_ifdef",
  R"__(
The number of newlines before a whole-file #ifdef.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_whole_file_ifdef = {
  "nl_after_whole_file_ifdef",
  R"__(
The number of newlines after a whole-file #ifdef.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_before_whole_file_endif = {
  "nl_before_whole_file_endif",
  R"__(
The number of newlines before a whole-file #endif.

0: No change (default).
)__"
};

BoundedOption<unsigned, 0, 16> nl_after_whole_file_endif = {
  "nl_after_whole_file_endif",
  R"__(
The number of newlines after a whole-file #endif.

0: No change (default).
)__"
};

Option<token_pos_e> pos_arith = {
  "pos_arith",
  R"__(
The position of arithmetic operators in wrapped expressions.
)__"
};

Option<token_pos_e> pos_assign = {
  "pos_assign",
  R"__(
The position of assignment in wrapped expressions. Do not affect '='
followed by '{'.
)__"
};

Option<token_pos_e> pos_bool = {
  "pos_bool",
  R"__(
The position of Boolean operators in wrapped expressions.
)__"
};

Option<token_pos_e> pos_compare = {
  "pos_compare",
  R"__(
The position of comparison operators in wrapped expressions.
)__"
};

Option<token_pos_e> pos_conditional = {
  "pos_conditional",
  R"__(
The position of conditional operators, as in the '?' and ':' of
'expr ? stmt : stmt', in wrapped expressions.
)__"
};

Option<token_pos_e> pos_comma = {
  "pos_comma",
  R"__(
The position of the comma in wrapped expressions.
)__"
};

Option<token_pos_e> pos_enum_comma = {
  "pos_enum_comma",
  R"__(
The position of the comma in enum entries.
)__"
};

Option<token_pos_e> pos_class_comma = {
  "pos_class_comma",
  R"__(
The position of the comma in the base class list if there is more than one
line. Affects nl_class_init_args.
)__"
};

Option<token_pos_e> pos_constr_comma = {
  "pos_constr_comma",
  R"__(
The position of the comma in the constructor initialization list.
Related to nl_constr_colon, nl_constr_init_args and pos_constr_colon.
)__"
};

Option<token_pos_e> pos_class_colon = {
  "pos_class_colon",
  R"__(
The position of trailing/leading class colon, between class and base class
list. Affects nl_class_colon.
)__"
};

Option<token_pos_e> pos_constr_colon = {
  "pos_constr_colon",
  R"__(
The position of colons between constructor and member initialization.
Related to nl_constr_colon, nl_constr_init_args and pos_constr_comma.
)__"
};

Option<token_pos_e> pos_shift = {
  "pos_shift",
  R"__(
The position of shift operators in wrapped expressions.
)__"
};

BoundedOption<unsigned, 0, 10000> code_width = {
  "code_width",
  R"__(
Try to limit code width to N columns.
)__"
};

Option<bool> ls_for_split_full = {
  "ls_for_split_full",
  R"__(
Whether to fully split long 'for' statements at semi-colons.
)__"
};

Option<bool> ls_func_split_full = {
  "ls_func_split_full",
  R"__(
Whether to fully split long function prototypes/calls at commas.
The option ls_code_width has priority over the option ls_func_split_full.
)__"
};

Option<bool> ls_code_width = {
  "ls_code_width",
  R"__(
Whether to split lines as close to code_width as possible and ignore some
groupings.
The option ls_code_width has priority over the option ls_func_split_full.
)__"
};

Option<bool> align_keep_tabs = {
  "align_keep_tabs",
  R"__(
Whether to keep non-indenting tabs.
)__"
};

Option<bool> align_with_tabs = {
  "align_with_tabs",
  R"__(
Whether to use tabs for aligning.
)__"
};

Option<bool> align_on_tabstop = {
  "align_on_tabstop",
  R"__(
Whether to bump out to the next tab when aligning.
)__"
};

Option<bool> align_number_right = {
  "align_number_right",
  R"__(
Whether to right-align numbers.
)__"
};

Option<bool> align_keep_extra_space = {
  "align_keep_extra_space",
  R"__(
Whether to keep whitespace not required for alignment.
)__"
};

Option<bool> align_func_params = {
  "align_func_params",
  R"__(
Whether to align variable definitions in prototypes and functions.
)__"
};

BoundedOption<unsigned, 0, 16> align_func_params_span = {
  "align_func_params_span",
  R"__(
The span for aligning parameter definitions in function on parameter name.

0: Don't align (default).
)__"
};

BoundedOption<signed, -1000, 5000> align_func_params_thresh = {
  "align_func_params_thresh",
  R"__(
The threshold for aligning function parameter definitions.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_func_params_gap = {
  "align_func_params_gap",
  R"__(
The gap for aligning function parameter definitions.
)__"
};

BoundedOption<unsigned, 0, 16> align_constr_value_span = {
  "align_constr_value_span",
  R"__(
The span for aligning constructor value.

0: Don't align (default).
)__"
};

BoundedOption<signed, -1000, 5000> align_constr_value_thresh = {
  "align_constr_value_thresh",
  R"__(
The threshold for aligning constructor value.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_constr_value_gap = {
  "align_constr_value_gap",
  R"__(
The gap for aligning constructor value.
)__"
};

Option<bool> align_same_func_call_params = {
  "align_same_func_call_params",
  R"__(
Whether to align parameters in single-line functions that have the same
name. The function names must already be aligned with each other.
)__"
};

BoundedOption<unsigned, 0, 5000> align_same_func_call_params_span = {
  "align_same_func_call_params_span",
  R"__(
The span for aligning function-call parameters for single line functions.

0: Don't align (default).
)__"
};

BoundedOption<signed, -1000, 5000> align_same_func_call_params_thresh = {
  "align_same_func_call_params_thresh",
  R"__(
The threshold for aligning function-call parameters for single line
functions.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

BoundedOption<unsigned, 0, 5000> align_var_def_span = {
  "align_var_def_span",
  R"__(
The span for aligning variable definitions.

0: Don't align (default).
)__"
};

BoundedOption<unsigned, 0, 2> align_var_def_star_style = {
  "align_var_def_star_style",
  R"__(
How to consider (or treat) the '*' in the alignment of variable definitions.

0: Part of the type     'void *   foo;' (default)
1: Part of the variable 'void     *foo;'
2: Dangling             'void    *foo;'
Dangling: the '*' will not be taken into account when aligning.
)__"
};

BoundedOption<unsigned, 0, 2> align_var_def_amp_style = {
  "align_var_def_amp_style",
  R"__(
How to consider (or treat) the '&' in the alignment of variable definitions.

0: Part of the type     'long &   foo;' (default)
1: Part of the variable 'long     &foo;'
2: Dangling             'long    &foo;'
Dangling: the '&' will not be taken into account when aligning.
)__"
};

BoundedOption<signed, -1000, 5000> align_var_def_thresh = {
  "align_var_def_thresh",
  R"__(
The threshold for aligning variable definitions.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_var_def_gap = {
  "align_var_def_gap",
  R"__(
The gap for aligning variable definitions.
)__"
};

Option<bool> align_var_def_colon = {
  "align_var_def_colon",
  R"__(
Whether to align the colon in struct bit fields.
)__"
};

BoundedOption<unsigned, 0, 16> align_var_def_colon_gap = {
  "align_var_def_colon_gap",
  R"__(
The gap for aligning the colon in struct bit fields.
)__"
};

Option<bool> align_var_def_attribute = {
  "align_var_def_attribute",
  R"__(
Whether to align any attribute after the variable name.
)__"
};

Option<bool> align_var_def_inline = {
  "align_var_def_inline",
  R"__(
Whether to align inline struct/enum/union variable definitions.
)__"
};

BoundedOption<unsigned, 0, 5000> align_assign_span = {
  "align_assign_span",
  R"__(
The span for aligning on '=' in assignments.

0: Don't align (default).
)__"
};

BoundedOption<unsigned, 0, 5000> align_assign_func_proto_span = {
  "align_assign_func_proto_span",
  R"__(
The span for aligning on '=' in function prototype modifier.

0: Don't align (default).
)__"
};

BoundedOption<signed, -1000, 5000> align_assign_thresh = {
  "align_assign_thresh",
  R"__(
The threshold for aligning on '=' in assignments.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

Option<bool> align_assign_on_multi_var_defs = {
  "align_assign_on_multi_var_defs",
  R"__(
Whether to align on the left most assignment when multiple
definitions are found on the same line.
Depends on 'align_assign_span' and 'align_assign_thresh' settings.
)__"
};

BoundedOption<unsigned, 0, 5000> align_braced_init_list_span = {
  "align_braced_init_list_span",
  R"__(
The span for aligning on '{' in braced init list.

0: Don't align (default).
)__"
};

BoundedOption<signed, -1000, 5000> align_braced_init_list_thresh = {
  "align_braced_init_list_thresh",
  R"__(
The threshold for aligning on '{' in braced init list.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

BoundedOption<unsigned, 0, 2> align_assign_decl_func = {
  "align_assign_decl_func",
  R"__(
How to apply align_assign_span to function declaration "assignments", i.e.
'virtual void foo() = 0' or '~foo() = {default|delete}'.

0: Align with other assignments (default)
1: Align with each other, ignoring regular assignments
2: Don't align
)__"
};

BoundedOption<unsigned, 0, 5000> align_enum_equ_span = {
  "align_enum_equ_span",
  R"__(
The span for aligning on '=' in enums.

0: Don't align (default).
)__"
};

BoundedOption<signed, -1000, 5000> align_enum_equ_thresh = {
  "align_enum_equ_thresh",
  R"__(
The threshold for aligning on '=' in enums.
Use a negative number for absolute thresholds.

0: no limit (default).
)__"
};

BoundedOption<unsigned, 0, 5000> align_var_class_span = {
  "align_var_class_span",
  R"__(
The span for aligning class member definitions.

0: Don't align (default).
)__"
};

BoundedOption<signed, -1000, 5000> align_var_class_thresh = {
  "align_var_class_thresh",
  R"__(
The threshold for aligning class member definitions.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_var_class_gap = {
  "align_var_class_gap",
  R"__(
The gap for aligning class member definitions.
)__"
};

BoundedOption<unsigned, 0, 5000> align_var_struct_span = {
  "align_var_struct_span",
  R"__(
The span for aligning struct/union member definitions.

0: Don't align (default).
)__"
};

BoundedOption<signed, -1000, 5000> align_var_struct_thresh = {
  "align_var_struct_thresh",
  R"__(
The threshold for aligning struct/union member definitions.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_var_struct_gap = {
  "align_var_struct_gap",
  R"__(
The gap for aligning struct/union member definitions.
)__"
};

BoundedOption<unsigned, 0, 5000> align_struct_init_span = {
  "align_struct_init_span",
  R"__(
The span for aligning struct initializer values.

0: Don't align (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_typedef_span = {
  "align_typedef_span",
  R"__(
The span for aligning single-line typedefs.

0: Don't align (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_typedef_gap = {
  "align_typedef_gap",
  R"__(
The minimum space between the type and the synonym of a typedef.
)__"
};

BoundedOption<unsigned, 0, 2> align_typedef_func = {
  "align_typedef_func",
  R"__(
How to align typedef'd functions with other typedefs.

0: Don't mix them at all (default)
1: Align the open parenthesis with the types
2: Align the function type name with the other type names
)__"
};

BoundedOption<unsigned, 0, 2> align_typedef_star_style = {
  "align_typedef_star_style",
  R"__(
How to consider (or treat) the '*' in the alignment of typedefs.

0: Part of the typedef type, 'typedef int * pint;' (default)
1: Part of type name:        'typedef int   *pint;'
2: Dangling:                 'typedef int  *pint;'
Dangling: the '*' will not be taken into account when aligning.
)__"
};

BoundedOption<unsigned, 0, 2> align_typedef_amp_style = {
  "align_typedef_amp_style",
  R"__(
How to consider (or treat) the '&' in the alignment of typedefs.

0: Part of the typedef type, 'typedef int & intref;' (default)
1: Part of type name:        'typedef int   &intref;'
2: Dangling:                 'typedef int  &intref;'
Dangling: the '&' will not be taken into account when aligning.
)__"
};

BoundedOption<unsigned, 0, 5000> align_right_cmt_span = {
  "align_right_cmt_span",
  R"__(
The span for aligning comments that end lines.

0: Don't align (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_right_cmt_gap = {
  "align_right_cmt_gap",
  R"__(
Minimum number of columns between preceding text and a trailing comment in
order for the comment to qualify for being aligned. Must be non-zero to have
an effect.
)__"
};

Option<bool> align_right_cmt_mix = {
  "align_right_cmt_mix",
  R"__(
If aligning comments, whether to mix with comments after '}' and #endif with
less than three spaces before the comment.
)__"
};

Option<bool> align_right_cmt_same_level = {
  "align_right_cmt_same_level",
  R"__(
Whether to only align trailing comments that are at the same brace level.
)__"
};

BoundedOption<unsigned, 0, 200> align_right_cmt_at_col = {
  "align_right_cmt_at_col",
  R"__(
Minimum column at which to align trailing comments. Comments which are
aligned beyond this column, but which can be aligned in a lesser column,
may be "pulled in".

0: Ignore (default).
)__"
};

BoundedOption<unsigned, 0, 5000> align_func_proto_span = {
  "align_func_proto_span",
  R"__(
The span for aligning function prototypes.

0: Don't align (default).
)__"
};

Option<bool> align_func_proto_span_ignore_cont_lines = {
  "align_func_proto_span_ignore_cont_lines",
  R"__(
Whether to ignore continuation lines when evaluating the number of
new lines for the function prototype alignment's span.

false: continuation lines are part of the newlines count
true:  continuation lines are not counted
)__",
  false
};

BoundedOption<unsigned, 0, 2> align_func_proto_star_style = {
  "align_func_proto_star_style",
  R"__(
How to consider (or treat) the '*' in the alignment of function prototypes.

0: Part of the type     'void *   foo();' (default)
1: Part of the function 'void     *foo();'
2: Dangling             'void    *foo();'
Dangling: the '*' will not be taken into account when aligning.
)__"
};

BoundedOption<unsigned, 0, 2> align_func_proto_amp_style = {
  "align_func_proto_amp_style",
  R"__(
How to consider (or treat) the '&' in the alignment of function prototypes.

0: Part of the type     'long &   foo();' (default)
1: Part of the function 'long     &foo();'
2: Dangling             'long    &foo();'
Dangling: the '&' will not be taken into account when aligning.
)__"
};

BoundedOption<signed, -1000, 5000> align_func_proto_thresh = {
  "align_func_proto_thresh",
  R"__(
The threshold for aligning function prototypes.
Use a negative number for absolute thresholds.

0: No limit (default).
)__"
};

BoundedOption<unsigned, 0, 16> align_func_proto_gap = {
  "align_func_proto_gap",
  R"__(
Minimum gap between the return type and the function name.
)__"
};

Option<bool> align_on_operator = {
  "align_on_operator",
  R"__(
Whether to align function prototypes on the 'operator' keyword instead of
what follows.
)__"
};

Option<bool> align_mix_var_proto = {
  "align_mix_var_proto",
  R"__(
Whether to mix aligning prototype and variable declarations. If true,
align_var_def_XXX options are used instead of align_func_proto_XXX options.
)__"
};

Option<bool> align_single_line_func = {
  "align_single_line_func",
  R"__(
Whether to align single-line functions with function prototypes.
Uses align_func_proto_span.
)__"
};

Option<bool> align_single_line_brace = {
  "align_single_line_brace",
  R"__(
Whether to align the open brace of single-line functions.
Requires align_single_line_func=true. Uses align_func_proto_span.
)__"
};

BoundedOption<unsigned, 0, 16> align_single_line_brace_gap = {
  "align_single_line_brace_gap",
  R"__(
Gap for align_single_line_brace.
)__"
};

BoundedOption<unsigned, 0, 5000> align_oc_msg_spec_span = {
  "align_oc_msg_spec_span",
  R"__(
(OC) The span for aligning Objective-C message specifications.

0: Don't align (default).
)__"
};

BoundedOption<unsigned, 0, 3> align_nl_cont = {
  "align_nl_cont",
  R"__(
Whether and how to align backslashes that split a macro onto multiple lines.
This will not work right if the macro contains a multi-line comment.

0: Do nothing (default)
1: Align the backslashes in the column at the end of the longest line
2: Align with the backslash that is farthest to the left, or, if that
   backslash is farther left than the end of the longest line, at the end of
   the longest line
3: Align with the backslash that is farthest to the right
)__"
};

BoundedOption<unsigned, 0, 16> align_nl_cont_spaces = {
  "align_nl_cont_spaces",
  R"__(
The minimum number of spaces between the end of a line and its continuation
backslash. Requires align_nl_cont.
)__",
  1
};

Option<bool> align_pp_define_together = {
  "align_pp_define_together",
  R"__(
Whether to align macro functions and variables together.
)__"
};

BoundedOption<unsigned, 0, 5000> align_pp_define_span = {
  "align_pp_define_span",
  R"__(
The span for aligning on '#define' bodies.

=0: Don't align (default)
>0: Number of lines (including comments) between blocks
)__"
};

BoundedOption<unsigned, 0, 16> align_pp_define_gap = {
  "align_pp_define_gap",
  R"__(
The minimum space between label and value of a preprocessor define.
)__"
};

Option<bool> align_left_shift = {
  "align_left_shift",
  R"__(
Whether to align lines that start with '<<' with previous '<<'.
)__",
  true
};

Option<bool> align_eigen_comma_init = {
  "align_eigen_comma_init",
  R"__(
Whether to align comma-separated statements following '<<' (as used to
initialize Eigen matrices).
)__"
};

Option<bool> align_asm_colon = {
  "align_asm_colon",
  R"__(
Whether to align text after 'asm volatile ()' colons.
)__"
};

BoundedOption<unsigned, 0, 5000> align_oc_msg_colon_span = {
  "align_oc_msg_colon_span",
  R"__(
(OC) Span for aligning parameters in an Objective-C message call
on the ':'.

0: Don't align.
)__"
};

Option<bool> align_oc_msg_colon_first = {
  "align_oc_msg_colon_first",
  R"__(
(OC) Whether to always align with the first parameter, even if it is too
short.
)__"
};

Option<bool> align_oc_decl_colon = {
  "align_oc_decl_colon",
  R"__(
(OC) Whether to align parameters in an Objective-C '+' or '-' declaration
on the ':'.
)__"
};

Option<bool> align_oc_msg_colon_xcode_like = {
  "align_oc_msg_colon_xcode_like",
  R"__(
(OC) Whether to not align parameters in an Objectve-C message call if first
colon is not on next line of the message call (the same way Xcode does
alignment)
)__"
};

BoundedOption<unsigned, 0, 256> cmt_width = {
  "cmt_width",
  R"__(
Try to wrap comments at N columns.
)__"
};

BoundedOption<unsigned, 0, 2> cmt_reflow_mode = {
  "cmt_reflow_mode",
  R"__(
How to reflow comments.

0: No reflowing (apart from the line wrapping due to cmt_width) (default)
1: No touching at all
2: Full reflow (enable cmt_indent_multi for indent with line wrapping due to cmt_width)
)__"
};

Option<string> cmt_reflow_fold_regex_file = {
  "cmt_reflow_fold_regex_file",
  R"__(
Path to a file that contains regular expressions describing patterns for
which the end of one line and the beginning of the next will be folded into
the same sentence or paragraph during full comment reflow. The regular
expressions are described using ECMAScript syntax. The syntax for this
specification is as follows, where "..." indicates the custom regular
expression and "n" indicates the nth end_of_prev_line_regex and
beg_of_next_line_regex regular expression pair:

end_of_prev_line_regex[1] = "...$"
beg_of_next_line_regex[1] = "^..."
end_of_prev_line_regex[2] = "...$"
beg_of_next_line_regex[2] = "^..."
            .
            .
            .
end_of_prev_line_regex[n] = "...$"
beg_of_next_line_regex[n] = "^..."

Note that use of this option overrides the default reflow fold regular
expressions, which are internally defined as follows:

end_of_prev_line_regex[1] = "[\w,\]\)]$"
beg_of_next_line_regex[1] = "^[\w,\[\(]"
end_of_prev_line_regex[2] = "\.$"
beg_of_next_line_regex[2] = "^[A-Z]"
)__"
};

Option<bool> cmt_reflow_indent_to_paragraph_start = {
  "cmt_reflow_indent_to_paragraph_start",
  R"__(
Whether to indent wrapped lines to the start of the encompassing paragraph
during full comment reflow (cmt_reflow_mode = 2). Overrides the value
specified by cmt_sp_after_star_cont.

Note that cmt_align_doxygen_javadoc_tags overrides this option for
paragraphs associated with javadoc tags
)__"
};

Option<bool> cmt_convert_tab_to_spaces = {
  "cmt_convert_tab_to_spaces",
  R"__(
Whether to convert all tabs to spaces in comments. If false, tabs in
comments are left alone, unless used for indenting.
)__"
};

Option<bool> cmt_indent_multi = {
  "cmt_indent_multi",
  R"__(
Whether to apply changes to multi-line comments, including cmt_width,
keyword substitution and leading chars.
)__",
  true
};

Option<bool> cmt_align_doxygen_javadoc_tags = {
  "cmt_align_doxygen_javadoc_tags",
  R"__(
Whether to align doxygen javadoc-style tags ('@param', '@return', etc.)
and corresponding fields such that groups of consecutive block tags,
parameter names, and descriptions align with one another. Overrides that
which is specified by the cmt_sp_after_star_cont. If cmt_width > 0, it may
be necessary to enable cmt_indent_multi and set cmt_reflow_mode = 2
in order to achieve the desired alignment for line-wrapping.
)__"
};

BoundedOption<unsigned, 0, 16> cmt_sp_before_doxygen_javadoc_tags = {
  "cmt_sp_before_doxygen_javadoc_tags",
  R"__(
The number of spaces to insert after the star and before doxygen
javadoc-style tags (@param, @return, etc). Requires enabling
cmt_align_doxygen_javadoc_tags. Overrides that which is specified by the
cmt_sp_after_star_cont.
)__",
  1
};

Option<bool> cmt_trailing_single_line_c_to_cpp = {
  "cmt_trailing_single_line_c_to_cpp",
  R"__(
Whether to change trailing, single-line c-comments into cpp-comments.
)__"
};

Option<bool> cmt_c_group = {
  "cmt_c_group",
  R"__(
Whether to group c-comments that look like they are in a block.
)__"
};

Option<bool> cmt_c_nl_start = {
  "cmt_c_nl_start",
  R"__(
Whether to put an empty '/*' on the first line of the combined c-comment.
)__"
};

Option<bool> cmt_c_nl_end = {
  "cmt_c_nl_end",
  R"__(
Whether to add a newline before the closing '*/' of the combined c-comment.
)__"
};

Option<bool> cmt_cpp_to_c = {
  "cmt_cpp_to_c",
  R"__(
Whether to change cpp-comments into c-comments.
)__"
};

Option<bool> cmt_cpp_group = {
  "cmt_cpp_group",
  R"__(
Whether to group cpp-comments that look like they are in a block. Only
meaningful if cmt_cpp_to_c=true.
)__"
};

Option<bool> cmt_cpp_nl_start = {
  "cmt_cpp_nl_start",
  R"__(
Whether to put an empty '/*' on the first line of the combined cpp-comment
when converting to a c-comment.

Requires cmt_cpp_to_c=true and cmt_cpp_group=true.
)__"
};

Option<bool> cmt_cpp_nl_end = {
  "cmt_cpp_nl_end",
  R"__(
Whether to add a newline before the closing '*/' of the combined cpp-comment
when converting to a c-comment.

Requires cmt_cpp_to_c=true and cmt_cpp_group=true.
)__"
};

Option<bool> cmt_star_cont = {
  "cmt_star_cont",
  R"__(
Whether to put a star on subsequent comment lines.
)__"
};

BoundedOption<unsigned, 0, 16> cmt_sp_before_star_cont = {
  "cmt_sp_before_star_cont",
  R"__(
The number of spaces to insert at the start of subsequent comment lines.
)__"
};

BoundedOption<unsigned, 0, 16> cmt_sp_after_star_cont = {
  "cmt_sp_after_star_cont",
  R"__(
The number of spaces to insert after the star on subsequent comment lines.
)__"
};

Option<bool> cmt_multi_check_last = {
  "cmt_multi_check_last",
  R"__(
For multi-line comments with a '*' lead, remove leading spaces if the first
and last lines of the comment are the same length.
)__",
  true
};

BoundedOption<unsigned, 1, 20> cmt_multi_first_len_minimum = {
  "cmt_multi_first_len_minimum",
  R"__(
For multi-line comments with a '*' lead, remove leading spaces if the first
and last lines of the comment are the same length AND if the length is
bigger as the first_len minimum.
)__",
  4
};

Option<string> cmt_insert_file_header = {
  "cmt_insert_file_header",
  R"__(
Path to a file that contains text to insert at the beginning of a file if
the file doesn't start with a C/C++ comment. If the inserted text contains
'$(filename)', that will be replaced with the current file's name.
)__"
};

Option<string> cmt_insert_file_footer = {
  "cmt_insert_file_footer",
  R"__(
Path to a file that contains text to insert at the end of a file if the
file doesn't end with a C/C++ comment. If the inserted text contains
'$(filename)', that will be replaced with the current file's name.
)__"
};

Option<string> cmt_insert_func_header = {
  "cmt_insert_func_header",
  R"__(
Path to a file that contains text to insert before a function definition if
the function isn't preceded by a C/C++ comment. If the inserted text
contains '$(function)', '$(javaparam)' or '$(fclass)', these will be
replaced with, respectively, the name of the function, the javadoc '@param'
and '@return' stuff, or the name of the class to which the member function
belongs.
)__"
};

Option<string> cmt_insert_class_header = {
  "cmt_insert_class_header",
  R"__(
Path to a file that contains text to insert before a class if the class
isn't preceded by a C/C++ comment. If the inserted text contains '$(class)',
that will be replaced with the class name.
)__"
};

Option<string> cmt_insert_oc_msg_header = {
  "cmt_insert_oc_msg_header",
  R"__(
Path to a file that contains text to insert before an Objective-C message
specification, if the method isn't preceded by a C/C++ comment. If the
inserted text contains '$(message)' or '$(javaparam)', these will be
replaced with, respectively, the name of the function, or the javadoc
'@param' and '@return' stuff.
)__"
};

Option<bool> cmt_insert_before_preproc = {
  "cmt_insert_before_preproc",
  R"__(
Whether a comment should be inserted if a preprocessor is encountered when
stepping backwards from a function name.

Applies to cmt_insert_oc_msg_header, cmt_insert_func_header and
cmt_insert_class_header.
)__"
};

Option<bool> cmt_insert_before_inlines = {
  "cmt_insert_before_inlines",
  R"__(
Whether a comment should be inserted if a function is declared inline to a
class definition.

Applies to cmt_insert_func_header.
)__",
  true
};

Option<bool> cmt_insert_before_ctor_dtor = {
  "cmt_insert_before_ctor_dtor",
  R"__(
Whether a comment should be inserted if the function is a class constructor
or destructor.

Applies to cmt_insert_func_header.
)__"
};

Option<iarf_e> mod_full_brace_do = {
  "mod_full_brace_do",
  R"__(
Add or remove braces on a single-line 'do' statement.
)__"
};

Option<iarf_e> mod_full_brace_for = {
  "mod_full_brace_for",
  R"__(
Add or remove braces on a single-line 'for' statement.
)__"
};

Option<iarf_e> mod_full_brace_function = {
  "mod_full_brace_function",
  R"__(
(Pawn) Add or remove braces on a single-line function definition.
)__"
};

Option<iarf_e> mod_full_brace_if = {
  "mod_full_brace_if",
  R"__(
Add or remove braces on a single-line 'if' statement. Braces will not be
removed if the braced statement contains an 'else'.
)__"
};

BoundedOption<unsigned, 0, 3> mod_full_brace_if_chain = {
  "mod_full_brace_if_chain",
  R"__(
Whether to enforce that all blocks of an 'if'/'else if'/'else' chain either
have, or do not have, braces. Overrides mod_full_brace_if.

0: Don't override mod_full_brace_if
1: Add braces to all blocks if any block needs braces and remove braces if
   they can be removed from all blocks
2: Add braces to all blocks if any block already has braces, regardless of
   whether it needs them
3: Add braces to all blocks if any block needs braces and remove braces if
   they can be removed from all blocks, except if all blocks have braces
   despite none needing them
)__"
};

Option<bool> mod_full_brace_if_chain_only = {
  "mod_full_brace_if_chain_only",
  R"__(
Whether to add braces to all blocks of an 'if'/'else if'/'else' chain.
If true, mod_full_brace_if_chain will only remove braces from an 'if' that
does not have an 'else if' or 'else'.
)__"
};

Option<iarf_e> mod_full_brace_while = {
  "mod_full_brace_while",
  R"__(
Add or remove braces on single-line 'while' statement.
)__"
};

Option<iarf_e> mod_full_brace_using = {
  "mod_full_brace_using",
  R"__(
Add or remove braces on single-line 'using ()' statement.
)__"
};

BoundedOption<unsigned, 0, 5000> mod_full_brace_nl = {
  "mod_full_brace_nl",
  R"__(
Don't remove braces around statements that span N newlines
)__"
};

Option<bool> mod_full_brace_nl_block_rem_mlcond = {
  "mod_full_brace_nl_block_rem_mlcond",
  R"__(
Whether to prevent removal of braces from 'if'/'for'/'while'/etc. blocks
which span multiple lines.

Affects:
  mod_full_brace_for
  mod_full_brace_if
  mod_full_brace_if_chain
  mod_full_brace_if_chain_only
  mod_full_brace_while
  mod_full_brace_using

Does not affect:
  mod_full_brace_do
  mod_full_brace_function
)__"
};

Option<iarf_e> mod_paren_on_return = {
  "mod_paren_on_return",
  R"__(
Add or remove unnecessary parentheses on 'return' statement.
)__"
};

Option<iarf_e> mod_paren_on_throw = {
  "mod_paren_on_throw",
  R"__(
Add or remove unnecessary parentheses on 'throw' statement.
)__"
};

Option<bool> mod_pawn_semicolon = {
  "mod_pawn_semicolon",
  R"__(
(Pawn) Whether to change optional semicolons to real semicolons.
)__"
};

Option<bool> mod_full_paren_if_bool = {
  "mod_full_paren_if_bool",
  R"__(
Whether to fully parenthesize Boolean expressions in 'while' and 'if'
statement, as in 'if (a && b > c)' => 'if (a && (b > c))'.
)__"
};

Option<bool> mod_full_paren_assign_bool = {
  "mod_full_paren_assign_bool",
  R"__(
Whether to fully parenthesize Boolean expressions after '='
statement, as in 'x = a && b > c;' => 'x = (a && (b > c));'.
)__"
};

Option<bool> mod_full_paren_return_bool = {
  "mod_full_paren_return_bool",
  R"__(
Whether to fully parenthesize Boolean expressions after '='
statement, as in 'return  a && b > c;' => 'return (a && (b > c));'.
)__"
};

Option<bool> mod_remove_extra_semicolon = {
  "mod_remove_extra_semicolon",
  R"__(
Whether to remove superfluous semicolons.
)__"
};

Option<bool> mod_remove_duplicate_include = {
  "mod_remove_duplicate_include",
  R"__(
Whether to remove duplicate include.
)__"
};

Option<bool> mod_add_force_c_closebrace_comment = {
  "mod_add_force_c_closebrace_comment",
  R"__(
the following options (mod_XX_closebrace_comment) use different comment,
depending of the setting of the next option.
false: Use the c comment (default)
true : Use the cpp comment
)__"
};

BoundedOption<unsigned, 0, 255> mod_add_long_function_closebrace_comment = {
  "mod_add_long_function_closebrace_comment",
  R"__(
If a function body exceeds the specified number of newlines and doesn't have
a comment after the close brace, a comment will be added.
)__"
};

BoundedOption<unsigned, 0, 255> mod_add_long_namespace_closebrace_comment = {
  "mod_add_long_namespace_closebrace_comment",
  R"__(
If a namespace body exceeds the specified number of newlines and doesn't
have a comment after the close brace, a comment will be added.
)__"
};

BoundedOption<unsigned, 0, 255> mod_add_long_class_closebrace_comment = {
  "mod_add_long_class_closebrace_comment",
  R"__(
If a class body exceeds the specified number of newlines and doesn't have a
comment after the close brace, a comment will be added.
)__"
};

BoundedOption<unsigned, 0, 255> mod_add_long_switch_closebrace_comment = {
  "mod_add_long_switch_closebrace_comment",
  R"__(
If a switch body exceeds the specified number of newlines and doesn't have a
comment after the close brace, a comment will be added.
)__"
};

BoundedOption<unsigned, 0, 255> mod_add_long_ifdef_endif_comment = {
  "mod_add_long_ifdef_endif_comment",
  R"__(
If an #ifdef body exceeds the specified number of newlines and doesn't have
a comment after the #endif, a comment will be added.
)__"
};

BoundedOption<unsigned, 0, 255> mod_add_long_ifdef_else_comment = {
  "mod_add_long_ifdef_else_comment",
  R"__(
If an #ifdef or #else body exceeds the specified number of newlines and
doesn't have a comment after the #else, a comment will be added.
)__"
};

Option<bool> mod_sort_case_sensitive = {
  "mod_sort_case_sensitive",
  R"__(
Whether to take care of the case by the mod_sort_xx options.
)__"
};

Option<bool> mod_sort_import = {
  "mod_sort_import",
  R"__(
Whether to sort consecutive single-line 'import' statements.
)__"
};

Option<bool> mod_sort_using = {
  "mod_sort_using",
  R"__(
(C#) Whether to sort consecutive single-line 'using' statements.
)__"
};

Option<bool> mod_sort_include = {
  "mod_sort_include",
  R"__(
Whether to sort consecutive single-line '#include' statements (C/C++) and
'#import' statements (Objective-C). Be aware that this has the potential to
break your code if your includes/imports have ordering dependencies.
)__"
};

Option<bool> mod_sort_incl_import_prioritize_filename = {
  "mod_sort_incl_import_prioritize_filename",
  R"__(
Whether to prioritize '#include' and '#import' statements that contain
filename without extension when sorting is enabled.
)__"
};

Option<bool> mod_sort_incl_import_prioritize_extensionless = {
  "mod_sort_incl_import_prioritize_extensionless",
  R"__(
Whether to prioritize '#include' and '#import' statements that does not
contain extensions when sorting is enabled.
)__"
};

Option<bool> mod_sort_incl_import_prioritize_angle_over_quotes = {
  "mod_sort_incl_import_prioritize_angle_over_quotes",
  R"__(
Whether to prioritize '#include' and '#import' statements that contain
angle over quotes when sorting is enabled.
)__"
};

Option<bool> mod_sort_incl_import_ignore_extension = {
  "mod_sort_incl_import_ignore_extension",
  R"__(
Whether to ignore file extension in '#include' and '#import' statements
for sorting comparison.
)__"
};

Option<bool> mod_sort_incl_import_grouping_enabled = {
  "mod_sort_incl_import_grouping_enabled",
  R"__(
Whether to group '#include' and '#import' statements when sorting is enabled.
)__"
};

Option<bool> mod_move_case_break = {
  "mod_move_case_break",
  R"__(
Whether to move a 'break' that appears after a fully braced 'case' before
the close brace, as in 'case X: { ... } break;' => 'case X: { ... break; }'.
)__"
};

Option<bool> mod_move_case_return = {
  "mod_move_case_return",
  R"__(
Whether to move a 'return' that appears after a fully braced 'case' before
the close brace, as in 'case X: { ... } return;' => 'case X: { ... return; }'.
)__"
};

Option<iarf_e> mod_case_brace = {
  "mod_case_brace",
  R"__(
Add or remove braces around a fully braced case statement. Will only remove
braces if there are no variable declarations in the block.
)__"
};

Option<bool> mod_remove_empty_return = {
  "mod_remove_empty_return",
  R"__(
Whether to remove a void 'return;' that appears as the last statement in a
function.
)__"
};

Option<iarf_e> mod_enum_last_comma = {
  "mod_enum_last_comma",
  R"__(
Add or remove the comma after the last value of an enumeration.
)__"
};

BoundedOption<unsigned, 0, 5> mod_infinite_loop = {
  "mod_infinite_loop",
  R"__(
Syntax to use for infinite loops.

0: Leave syntax alone (default)
1: Rewrite as `for(;;)`
2: Rewrite as `while(true)`
3: Rewrite as `do`...`while(true);`
4: Rewrite as `while(1)`
5: Rewrite as `do`...`while(1);`

Infinite loops that do not already match one of these syntaxes are ignored.
Other options that affect loop formatting will be applied after transforming
the syntax.
)__"
};

Option<iarf_e> mod_int_short = {
  "mod_int_short",
  R"__(
Add or remove the 'int' keyword in 'int short'.
)__"
};

Option<iarf_e> mod_short_int = {
  "mod_short_int",
  R"__(
Add or remove the 'int' keyword in 'short int'.
)__"
};

Option<iarf_e> mod_int_long = {
  "mod_int_long",
  R"__(
Add or remove the 'int' keyword in 'int long'.
)__"
};

Option<iarf_e> mod_long_int = {
  "mod_long_int",
  R"__(
Add or remove the 'int' keyword in 'long int'.
)__"
};

Option<iarf_e> mod_int_signed = {
  "mod_int_signed",
  R"__(
Add or remove the 'int' keyword in 'int signed'.
)__"
};

Option<iarf_e> mod_signed_int = {
  "mod_signed_int",
  R"__(
Add or remove the 'int' keyword in 'signed int'.
)__"
};

Option<iarf_e> mod_int_unsigned = {
  "mod_int_unsigned",
  R"__(
Add or remove the 'int' keyword in 'int unsigned'.
)__"
};

Option<iarf_e> mod_unsigned_int = {
  "mod_unsigned_int",
  R"__(
Add or remove the 'int' keyword in 'unsigned int'.
)__"
};

Option<bool> mod_int_prefer_int_on_left = {
  "mod_int_prefer_int_on_left",
  R"__(
If there is a situation where mod_int_* and mod_*_int would result in
multiple int keywords, whether to keep the rightmost int (the default) or the
leftmost int.
)__"
};

Option<bool> mod_sort_oc_properties = {
  "mod_sort_oc_properties",
  R"__(
(OC) Whether to organize the properties. If true, properties will be
rearranged according to the mod_sort_oc_property_*_weight factors.
)__"
};

Option<signed> mod_sort_oc_property_class_weight = {
  "mod_sort_oc_property_class_weight",
  R"__(
(OC) Weight of a class property modifier.
)__"
};

Option<signed> mod_sort_oc_property_thread_safe_weight = {
  "mod_sort_oc_property_thread_safe_weight",
  R"__(
(OC) Weight of 'atomic' and 'nonatomic'.
)__"
};

Option<signed> mod_sort_oc_property_readwrite_weight = {
  "mod_sort_oc_property_readwrite_weight",
  R"__(
(OC) Weight of 'readwrite' when organizing properties.
)__"
};

Option<signed> mod_sort_oc_property_reference_weight = {
  "mod_sort_oc_property_reference_weight",
  R"__(
(OC) Weight of a reference type specifier ('retain', 'copy', 'assign',
'weak', 'strong') when organizing properties.
)__"
};

Option<signed> mod_sort_oc_property_getter_weight = {
  "mod_sort_oc_property_getter_weight",
  R"__(
(OC) Weight of getter type ('getter=') when organizing properties.
)__"
};

Option<signed> mod_sort_oc_property_setter_weight = {
  "mod_sort_oc_property_setter_weight",
  R"__(
(OC) Weight of setter type ('setter=') when organizing properties.
)__"
};

Option<signed> mod_sort_oc_property_nullability_weight = {
  "mod_sort_oc_property_nullability_weight",
  R"__(
(OC) Weight of nullability type ('nullable', 'nonnull', 'null_unspecified',
'null_resettable') when organizing properties.
)__"
};

BoundedOption<signed, -1, 2> pp_indent_with_tabs = {
  "pp_indent_with_tabs",
  R"__(
How to use tabs when indenting preprocessor code.

-1: Use 'indent_with_tabs' setting (default)
 0: Spaces only
 1: Indent with tabs to brace level, align with spaces
 2: Indent and align with tabs, using spaces when not on a tabstop
)__",
  -1
};

Option<iarf_e> pp_indent = {
  "pp_indent",
  R"__(
Add or remove indentation of preprocessor directives inside #if blocks
at brace level 0 (file-level).
)__"
};

Option<bool> pp_indent_at_level = {
  "pp_indent_at_level",
  R"__(
Whether to indent #if/#else/#endif at the brace level. If false, these are
indented from column 1.
)__"
};

Option<bool> pp_indent_at_level0 = {
  "pp_indent_at_level0",
  R"__(
Whether to indent #if/#else/#endif at the parenthesis level if the brace
level is 0. If false, these are indented from column 1.
)__"
};

BoundedOption<unsigned, 0, 16> pp_indent_count = {
  "pp_indent_count",
  R"__(
Specifies the number of columns to indent preprocessors per level
at brace level 0 (file-level). If pp_indent_at_level=false, also specifies
the number of columns to indent preprocessors per level
at brace level > 0 (function-level).
)__",
  1
};

Option<iarf_e> pp_space_after = {
  "pp_space_after",
  R"__(
Add or remove space after # based on pp level of #if blocks.
)__"
};

BoundedOption<unsigned, 0, 16> pp_space_count = {
  "pp_space_count",
  R"__(
Sets the number of spaces per level added with pp_space_after.
)__"
};

BoundedOption<signed, -16, 16> pp_indent_region = {
  "pp_indent_region",
  R"__(
The indent for '#region' and '#endregion' in C# and '#pragma region' in
C/C++. Negative values decrease indent down to the first column.
)__"
};

Option<bool> pp_region_indent_code = {
  "pp_region_indent_code",
  R"__(
Whether to indent the code between #region and #endregion.
)__"
};

BoundedOption<signed, -16, 16> pp_indent_if = {
  "pp_indent_if",
  R"__(
If pp_indent_at_level=true, sets the indent for #if, #else and #endif when
not at file-level. Negative values decrease indent down to the first column.

=0: Indent preprocessors using output_tab_size
>0: Column at which all preprocessors will be indented
)__"
};

Option<bool> pp_if_indent_code = {
  "pp_if_indent_code",
  R"__(
Whether to indent the code between #if, #else and #endif.
)__"
};

Option<bool> pp_indent_in_guard = {
  "pp_indent_in_guard",
  R"__(
Whether to indent the body of an #if that encompasses all the code in the file.
)__"
};

Option<bool> pp_define_at_level = {
  "pp_define_at_level",
  R"__(
Whether to indent '#define' at the brace level. If false, these are
indented from column 1.
)__"
};

Option<bool> pp_include_at_level = {
  "pp_include_at_level",
  R"__(
Whether to indent '#include' at the brace level.
)__"
};

Option<bool> pp_ignore_define_body = {
  "pp_ignore_define_body",
  R"__(
Whether to ignore the '#define' body while formatting.
)__"
};

BoundedOption<signed, -32, 32> pp_multiline_define_body_indent = {
  "pp_multiline_define_body_indent",
  R"__(
An offset value that controls the indentation of the body of a multiline #define.
'body' refers to all the lines of a multiline #define except the first line.
Requires 'pp_ignore_define_body = false'.

 <0: Absolute column: the body indentation starts off at the specified column
     (ex. -3 ==> the body is indented starting from column 3)
>=0: Relative to the column of the '#' of '#define'
     (ex.  3 ==> the body is indented starting 3 columns at the right of '#')
)__",
  8
};

Option<bool> pp_indent_case = {
  "pp_indent_case",
  R"__(
Whether to indent case statements between #if, #else, and #endif.
Only applies to the indent of the preprocessor that the case statements
directly inside of.
)__",
  true
};

Option<bool> pp_indent_func_def = {
  "pp_indent_func_def",
  R"__(
Whether to indent whole function definitions between #if, #else, and #endif.
Only applies to the indent of the preprocessor that the function definition
is directly inside of.
)__",
  true
};

Option<bool> pp_indent_extern = {
  "pp_indent_extern",
  R"__(
Whether to indent extern C blocks between #if, #else, and #endif.
Only applies to the indent of the preprocessor that the extern block is
directly inside of.
)__",
  true
};

BoundedOption<signed, -1, 1> pp_indent_brace = {
  "pp_indent_brace",
  R"__(
How to indent braces directly inside #if, #else, and #endif.
Requires pp_if_indent_code=true and only applies to the indent of the
preprocessor that the braces are directly inside of.
 0: No extra indent
 1: Indent by one level
-1: Preserve original indentation
)__",
  1
};

BoundedOption<unsigned, 0, 2> pp_unbalanced_if_action = {
  "pp_unbalanced_if_action",
  R"__(
Action to perform when unbalanced #if and #else blocks are found.
0: do nothing
1: print a warning message
2: terminate the program with an error (EX_SOFTWARE)

The action will be triggered in the following cases:
- if an #ifdef block ends on a different indent level than
  where it started from. Example:

   #ifdef TEST
     int i;
     {
       int j;
   #endif

- an #elif/#else block ends on a different indent level than
  the corresponding #ifdef block. Example:

   #ifdef TEST
       int i;
   #else
       }
     int j;
   #endif
)__",
  0
};

Option<string> include_category_0 = {
  "include_category_0",
  R"__(
The regex for include category with priority 0.
)__"
};

Option<string> include_category_1 = {
  "include_category_1",
  R"__(
The regex for include category with priority 1.
)__"
};

Option<string> include_category_2 = {
  "include_category_2",
  R"__(
The regex for include category with priority 2.
)__"
};

Option<bool> use_indent_func_call_param = {
  "use_indent_func_call_param",
  R"__(
true:  indent_func_call_param will be used (default)
false: indent_func_call_param will NOT be used
)__",
  true
};

Option<bool> use_indent_continue_only_once = {
  "use_indent_continue_only_once",
  R"__(
The value of the indentation for a continuation line is calculated
differently if the statement is:
- a declaration: your case with QString fileName ...
- an assignment: your case with pSettings = new QSettings( ...

At the second case the indentation value might be used twice:
- at the assignment
- at the function call (if present)

To prevent the double use of the indentation value, use this option with the
value 'true'.

true:  indent_continue will be used only once
false: indent_continue will be used every time (default)

Requires indent_ignore_first_continue=false.
)__"
};

Option<bool> indent_cpp_lambda_only_once = {
  "indent_cpp_lambda_only_once",
  R"__(
The indentation can be:
- after the assignment, at the '[' character
- at the beginning of the lambda body

true:  indentation will be at the beginning of the lambda body
false: indentation will be after the assignment (default)
)__"
};

Option<bool> use_sp_after_angle_always = {
  "use_sp_after_angle_always",
  R"__(
Whether sp_after_angle takes precedence over sp_inside_fparen. This was the
historic behavior, but is probably not the desired behavior, so this is off
by default.
)__"
};

Option<bool> use_options_overriding_for_qt_macros = {
  "use_options_overriding_for_qt_macros",
  R"__(
Whether to apply special formatting for Qt SIGNAL/SLOT macros. Essentially,
this tries to format these so that they match Qt's normalized form (i.e. the
result of QMetaObject::normalizedSignature), which can slightly improve the
performance of the QObject::connect call, rather than how they would
otherwise be formatted.

See options_for_QT.cpp for details.
)__",
  true
};

Option<bool> use_form_feed_no_more_as_whitespace_character = {
  "use_form_feed_no_more_as_whitespace_character",
  R"__(
If true: the form feed character is removed from the list of whitespace
characters. See https://en.cppreference.com/w/cpp/string/byte/isspace.
)__"
};

BoundedOption<unsigned, 1, 3> warn_level_tabs_found_in_verbatim_string_literals = {
  "warn_level_tabs_found_in_verbatim_string_literals",
  R"__(
(C#) Warning is given if doing tab-to-\t replacement and we have found one
in a C# verbatim string literal.
)__",
  LWARN
};

Option<signed> debug_max_number_of_loops = {
  "debug_max_number_of_loops",
  R"__(
Limit the number of loops.
Used by uncrustify.cpp to exit from infinite loop.
0: no limit.
)__"
};

Option<signed> debug_line_number_to_protocol = {
  "debug_line_number_to_protocol",
  R"__(
Set the number of the line to protocol;
Used in the function prot_the_line if the 2. parameter is zero.
0: nothing protocol.
)__"
};

Option<signed> debug_timeout = {
  "debug_timeout",
  R"__(
Set the number of second(s) before terminating formatting the current file,
0: no timeout.
only for linux
)__"
};

BoundedOption<unsigned, 0, 960> debug_truncate = {
  "debug_truncate",
  R"__(
Set the number of characters to be printed if the text is too long,
0: do not truncate.
)__"
};

Option<bool> debug_sort_the_tracks = {
  "debug_sort_the_tracks",
  R"__(
sort (or not) the tracking info.
)__",
  true
};

Option<bool> debug_decode_the_flags = {
  "debug_decode_the_flags",
  R"__(
decode (or not) the flags as a new line.
only if the -p option is set.
)__"
};

Option<bool> debug_use_the_exit_function_pop = {
  "debug_use_the_exit_function_pop",
  R"__(
use (or not) the exit(EX_SOFTWARE) function.
)__",
  true
};

Option<bool> debug_print_version = {
  "debug_print_version",
  R"__(
print (or not) the version in the file defined at the command option -o.
)__"
};

Option<bool> set_numbering_for_html_output = {
  "set_numbering_for_html_output",
  R"__(
insert the number of the line at the beginning of each line
)__"
};

} // namespace options

//END declarations of option object instances

///////////////////////////////////////////////////////////////////////////////

//-----------------------------------------------------------------------------
void register_options(void)
{

  begin_option_group(R"__(
General options
)__");

  register_option(&options::newlines);
  register_option(&options::input_tab_size);
  register_option(&options::output_tab_size);
  register_option(&options::string_escape_char);
  register_option(&options::string_escape_char2);
  register_option(&options::string_replace_tab_chars);
  register_option(&options::tok_split_gte);
  register_option(&options::disable_processing_nl_cont);
  register_option(&options::disable_processing_cmt);
  register_option(&options::enable_processing_cmt);
  register_option(&options::enable_digraphs);
  register_option(&options::processing_cmt_as_regex);
  register_option(&options::utf8_bom);
  register_option(&options::utf8_byte);
  register_option(&options::utf8_force);

  begin_option_group(R"__(
Spacing options
)__");

  register_option(&options::sp_arith);
  register_option(&options::sp_arith_additive);
  register_option(&options::sp_assign);
  register_option(&options::sp_cpp_lambda_assign);
  register_option(&options::sp_cpp_lambda_square_paren);
  register_option(&options::sp_cpp_lambda_square_brace);
  register_option(&options::sp_cpp_lambda_argument_list_empty);
  register_option(&options::sp_cpp_lambda_argument_list);
  register_option(&options::sp_cpp_lambda_paren_brace);
  register_option(&options::sp_cpp_lambda_fparen);
  register_option(&options::sp_assign_default);
  register_option(&options::sp_before_assign);
  register_option(&options::sp_after_assign);
  register_option(&options::sp_enum_brace);
  register_option(&options::sp_enum_paren);
  register_option(&options::sp_enum_assign);
  register_option(&options::sp_enum_before_assign);
  register_option(&options::sp_enum_after_assign);
  register_option(&options::sp_enum_colon);
  register_option(&options::sp_pp_concat);
  register_option(&options::sp_pp_stringify);
  register_option(&options::sp_before_pp_stringify);
  register_option(&options::sp_bool);
  register_option(&options::sp_compare);
  register_option(&options::sp_inside_paren);
  register_option(&options::sp_paren_paren);
  register_option(&options::sp_cparen_oparen);
  register_option(&options::sp_paren_brace);
  register_option(&options::sp_brace_brace);
  register_option(&options::sp_before_ptr_star);
  register_option(&options::sp_before_unnamed_ptr_star);
  register_option(&options::sp_before_qualifier_ptr_star);
  register_option(&options::sp_before_operator_ptr_star);
  register_option(&options::sp_before_scope_ptr_star);
  register_option(&options::sp_before_global_scope_ptr_star);
  register_option(&options::sp_qualifier_unnamed_ptr_star);
  register_option(&options::sp_between_ptr_star);
  register_option(&options::sp_between_ptr_ref);
  register_option(&options::sp_after_ptr_star);
  register_option(&options::sp_after_ptr_block_caret);
  register_option(&options::sp_after_ptr_star_qualifier);
  register_option(&options::sp_after_ptr_star_func);
  register_option(&options::sp_after_ptr_star_trailing);
  register_option(&options::sp_ptr_star_func_var);
  register_option(&options::sp_ptr_star_func_type);
  register_option(&options::sp_ptr_star_paren);
  register_option(&options::sp_before_ptr_star_func);
  register_option(&options::sp_qualifier_ptr_star_func);
  register_option(&options::sp_before_ptr_star_trailing);
  register_option(&options::sp_qualifier_ptr_star_trailing);
  register_option(&options::sp_before_byref);
  register_option(&options::sp_before_unnamed_byref);
  register_option(&options::sp_after_byref);
  register_option(&options::sp_after_byref_func);
  register_option(&options::sp_before_byref_func);
  register_option(&options::sp_byref_paren);
  register_option(&options::sp_after_type);
  register_option(&options::sp_after_decltype);
  register_option(&options::sp_before_template_paren);
  register_option(&options::sp_template_angle);
  register_option(&options::sp_before_angle);
  register_option(&options::sp_inside_angle);
  register_option(&options::sp_inside_angle_empty);
  register_option(&options::sp_angle_colon);
  register_option(&options::sp_after_angle);
  register_option(&options::sp_angle_paren);
  register_option(&options::sp_angle_paren_empty);
  register_option(&options::sp_angle_word);
  register_option(&options::sp_angle_shift);
  register_option(&options::sp_permit_cpp11_shift);
  register_option(&options::sp_before_sparen);
  register_option(&options::sp_inside_sparen);
  register_option(&options::sp_inside_sparen_open);
  register_option(&options::sp_inside_sparen_close);
  register_option(&options::sp_inside_for);
  register_option(&options::sp_inside_for_open);
  register_option(&options::sp_inside_for_close);
  register_option(&options::sp_sparen_paren);
  register_option(&options::sp_after_sparen);
  register_option(&options::sp_sparen_brace);
  register_option(&options::sp_do_brace_open);
  register_option(&options::sp_brace_close_while);
  register_option(&options::sp_while_paren_open);
  register_option(&options::sp_invariant_paren);
  register_option(&options::sp_after_invariant_paren);
  register_option(&options::sp_special_semi);
  register_option(&options::sp_before_semi);
  register_option(&options::sp_before_semi_for);
  register_option(&options::sp_before_semi_for_empty);
  register_option(&options::sp_between_semi_for_empty);
  register_option(&options::sp_after_semi);
  register_option(&options::sp_after_semi_for);
  register_option(&options::sp_after_semi_for_empty);
  register_option(&options::sp_before_square);
  register_option(&options::sp_before_vardef_square);
  register_option(&options::sp_before_square_asm_block);
  register_option(&options::sp_before_squares);
  register_option(&options::sp_cpp_before_struct_binding_after_byref);
  register_option(&options::sp_cpp_before_struct_binding);
  register_option(&options::sp_inside_square);
  register_option(&options::sp_inside_square_empty);
  register_option(&options::sp_inside_square_oc_array);
  register_option(&options::sp_after_comma);
  register_option(&options::sp_before_comma);
  register_option(&options::sp_after_mdatype_commas);
  register_option(&options::sp_before_mdatype_commas);
  register_option(&options::sp_between_mdatype_commas);
  register_option(&options::sp_paren_comma);
  register_option(&options::sp_type_colon);
  register_option(&options::sp_after_ellipsis);
  register_option(&options::sp_before_ellipsis);
  register_option(&options::sp_type_ellipsis);
  register_option(&options::sp_ptr_type_ellipsis);
  register_option(&options::sp_paren_ellipsis);
  register_option(&options::sp_byref_ellipsis);
  register_option(&options::sp_paren_qualifier);
  register_option(&options::sp_paren_noexcept);
  register_option(&options::sp_after_class_colon);
  register_option(&options::sp_before_class_colon);
  register_option(&options::sp_after_constr_colon);
  register_option(&options::sp_before_constr_colon);
  register_option(&options::sp_before_case_colon);
  register_option(&options::sp_after_operator);
  register_option(&options::sp_after_operator_sym);
  register_option(&options::sp_after_operator_sym_empty);
  register_option(&options::sp_after_cast);
  register_option(&options::sp_inside_paren_cast);
  register_option(&options::sp_cpp_cast_paren);
  register_option(&options::sp_sizeof_paren);
  register_option(&options::sp_sizeof_ellipsis);
  register_option(&options::sp_sizeof_ellipsis_paren);
  register_option(&options::sp_ellipsis_parameter_pack);
  register_option(&options::sp_parameter_pack_ellipsis);
  register_option(&options::sp_decltype_paren);
  register_option(&options::sp_after_tag);
  register_option(&options::sp_inside_braces_enum);
  register_option(&options::sp_inside_braces_struct);
  register_option(&options::sp_inside_braces_oc_dict);
  register_option(&options::sp_after_type_brace_init_lst_open);
  register_option(&options::sp_before_type_brace_init_lst_close);
  register_option(&options::sp_inside_type_brace_init_lst);
  register_option(&options::sp_inside_braces);
  register_option(&options::sp_inside_braces_empty);
  register_option(&options::sp_trailing_return);
  register_option(&options::sp_type_func);
  register_option(&options::sp_type_brace_init_lst);
  register_option(&options::sp_func_proto_paren);
  register_option(&options::sp_func_proto_paren_empty);
  register_option(&options::sp_func_type_paren);
  register_option(&options::sp_func_def_paren);
  register_option(&options::sp_func_def_paren_empty);
  register_option(&options::sp_inside_fparens);
  register_option(&options::sp_inside_fparen);
  register_option(&options::sp_func_call_user_inside_rparen);
  register_option(&options::sp_inside_rparens);
  register_option(&options::sp_inside_rparen);
  register_option(&options::sp_inside_tparen);
  register_option(&options::sp_after_tparen_close);
  register_option(&options::sp_square_fparen);
  register_option(&options::sp_fparen_brace);
  register_option(&options::sp_fparen_brace_initializer);
  register_option(&options::sp_fparen_dbrace);
  register_option(&options::sp_func_call_paren);
  register_option(&options::sp_func_call_paren_empty);
  register_option(&options::sp_func_call_user_paren);
  register_option(&options::sp_func_call_user_inside_fparen);
  register_option(&options::sp_func_call_user_paren_paren);
  register_option(&options::sp_func_class_paren);
  register_option(&options::sp_func_class_paren_empty);
  register_option(&options::sp_return);
  register_option(&options::sp_return_paren);
  register_option(&options::sp_return_brace);
  register_option(&options::sp_attribute_paren);
  register_option(&options::sp_defined_paren);
  register_option(&options::sp_throw_paren);
  register_option(&options::sp_after_throw);
  register_option(&options::sp_catch_paren);
  register_option(&options::sp_oc_catch_paren);
  register_option(&options::sp_before_oc_proto_list);
  register_option(&options::sp_oc_classname_paren);
  register_option(&options::sp_version_paren);
  register_option(&options::sp_scope_paren);
  register_option(&options::sp_super_paren);
  register_option(&options::sp_this_paren);
  register_option(&options::sp_macro);
  register_option(&options::sp_macro_func);
  register_option(&options::sp_else_brace);
  register_option(&options::sp_brace_else);
  register_option(&options::sp_brace_typedef);
  register_option(&options::sp_catch_brace);
  register_option(&options::sp_oc_catch_brace);
  register_option(&options::sp_brace_catch);
  register_option(&options::sp_oc_brace_catch);
  register_option(&options::sp_finally_brace);
  register_option(&options::sp_brace_finally);
  register_option(&options::sp_try_brace);
  register_option(&options::sp_getset_brace);
  register_option(&options::sp_word_brace_init_lst);
  register_option(&options::sp_word_brace_ns);
  register_option(&options::sp_before_dc);
  register_option(&options::sp_after_dc);
  register_option(&options::sp_d_array_colon);
  register_option(&options::sp_not);
  register_option(&options::sp_not_not);
  register_option(&options::sp_inv);
  register_option(&options::sp_addr);
  register_option(&options::sp_member);
  register_option(&options::sp_deref);
  register_option(&options::sp_sign);
  register_option(&options::sp_incdec);
  register_option(&options::sp_before_nl_cont);
  register_option(&options::sp_after_oc_scope);
  register_option(&options::sp_after_oc_colon);
  register_option(&options::sp_before_oc_colon);
  register_option(&options::sp_after_oc_dict_colon);
  register_option(&options::sp_before_oc_dict_colon);
  register_option(&options::sp_after_send_oc_colon);
  register_option(&options::sp_before_send_oc_colon);
  register_option(&options::sp_after_oc_type);
  register_option(&options::sp_after_oc_return_type);
  register_option(&options::sp_after_oc_at_sel);
  register_option(&options::sp_after_oc_at_sel_parens);
  register_option(&options::sp_inside_oc_at_sel_parens);
  register_option(&options::sp_before_oc_block_caret);
  register_option(&options::sp_after_oc_block_caret);
  register_option(&options::sp_after_oc_msg_receiver);
  register_option(&options::sp_after_oc_property);
  register_option(&options::sp_after_oc_synchronized);
  register_option(&options::sp_cond_colon);
  register_option(&options::sp_cond_colon_before);
  register_option(&options::sp_cond_colon_after);
  register_option(&options::sp_cond_question);
  register_option(&options::sp_cond_question_before);
  register_option(&options::sp_cond_question_after);
  register_option(&options::sp_cond_ternary_short);
  register_option(&options::sp_case_label);
  register_option(&options::sp_range);
  register_option(&options::sp_after_for_colon);
  register_option(&options::sp_before_for_colon);
  register_option(&options::sp_extern_paren);
  register_option(&options::sp_cmt_cpp_start);
  register_option(&options::sp_cmt_cpp_pvs);
  register_option(&options::sp_cmt_cpp_lint);
  register_option(&options::sp_cmt_cpp_region);
  register_option(&options::sp_cmt_cpp_doxygen);
  register_option(&options::sp_cmt_cpp_qttr);
  register_option(&options::sp_endif_cmt);
  register_option(&options::sp_after_new);
  register_option(&options::sp_between_new_paren);
  register_option(&options::sp_after_newop_paren);
  register_option(&options::sp_inside_newop_paren);
  register_option(&options::sp_inside_newop_paren_open);
  register_option(&options::sp_inside_newop_paren_close);
  register_option(&options::sp_before_tr_cmt);
  register_option(&options::sp_num_before_tr_cmt);
  register_option(&options::sp_before_emb_cmt);
  register_option(&options::sp_num_before_emb_cmt);
  register_option(&options::sp_after_emb_cmt);
  register_option(&options::sp_num_after_emb_cmt);
  register_option(&options::sp_emb_cmt_priority);
  register_option(&options::sp_annotation_paren);
  register_option(&options::sp_skip_vbrace_tokens);
  register_option(&options::sp_after_noexcept);
  register_option(&options::sp_vala_after_translation);
  register_option(&options::sp_before_bit_colon);
  register_option(&options::sp_after_bit_colon);
  register_option(&options::force_tab_after_define);
  register_option(&options::sp_string_string);
  register_option(&options::sp_struct_type);

  begin_option_group(R"__(
Indenting options
)__");

  register_option(&options::indent_columns);
  register_option(&options::indent_ignore_first_continue);
  register_option(&options::indent_continue);
  register_option(&options::indent_continue_class_head);
  register_option(&options::indent_single_newlines);
  register_option(&options::indent_param);
  register_option(&options::indent_with_tabs);
  register_option(&options::indent_cmt_with_tabs);
  register_option(&options::indent_align_string);
  register_option(&options::indent_xml_string);
  register_option(&options::indent_brace);
  register_option(&options::indent_braces);
  register_option(&options::indent_braces_no_func);
  register_option(&options::indent_braces_no_class);
  register_option(&options::indent_braces_no_struct);
  register_option(&options::indent_brace_parent);
  register_option(&options::indent_paren_open_brace);
  register_option(&options::indent_cs_delegate_brace);
  register_option(&options::indent_cs_delegate_body);
  register_option(&options::indent_namespace);
  register_option(&options::indent_namespace_single_indent);
  register_option(&options::indent_namespace_level);
  register_option(&options::indent_namespace_limit);
  register_option(&options::indent_namespace_inner_only);
  register_option(&options::indent_extern);
  register_option(&options::indent_class);
  register_option(&options::indent_ignore_before_class_colon);
  register_option(&options::indent_before_class_colon);
  register_option(&options::indent_class_colon);
  register_option(&options::indent_class_on_colon);
  register_option(&options::indent_ignore_before_constr_colon);
  register_option(&options::indent_constr_colon);
  register_option(&options::indent_ctor_init_leading);
  register_option(&options::indent_ctor_init_following);
  register_option(&options::indent_ctor_init);
  register_option(&options::indent_else_if);
  register_option(&options::indent_var_def_blk);
  register_option(&options::indent_var_def_cont);
  register_option(&options::indent_shift);
  register_option(&options::indent_func_def_force_col1);
  register_option(&options::indent_func_call_param);
  register_option(&options::indent_func_def_param);
  register_option(&options::indent_func_def_param_paren_pos_threshold);
  register_option(&options::indent_func_proto_param);
  register_option(&options::indent_func_class_param);
  register_option(&options::indent_func_ctor_var_param);
  register_option(&options::indent_template_param);
  register_option(&options::indent_func_param_double);
  register_option(&options::indent_func_const);
  register_option(&options::indent_func_throw);
  register_option(&options::indent_macro_brace);
  register_option(&options::indent_member);
  register_option(&options::indent_member_single);
  register_option(&options::indent_single_line_comments_before);
  register_option(&options::indent_single_line_comments_after);
  register_option(&options::indent_sparen_extra);
  register_option(&options::indent_relative_single_line_comments);
  register_option(&options::indent_switch_case);
  register_option(&options::indent_switch_body);
  register_option(&options::indent_ignore_case_brace);
  register_option(&options::indent_case_brace);
  register_option(&options::indent_switch_break_with_case);
  register_option(&options::indent_switch_pp);
  register_option(&options::indent_case_shift);
  register_option(&options::indent_case_comment);
  register_option(&options::indent_comment);
  register_option(&options::indent_col1_comment);
  register_option(&options::indent_col1_multi_string_literal);
  register_option(&options::indent_comment_align_thresh);
  register_option(&options::indent_ignore_label);
  register_option(&options::indent_label);
  register_option(&options::indent_access_spec);
  register_option(&options::indent_access_spec_body);
  register_option(&options::indent_paren_nl);
  register_option(&options::indent_paren_close);
  register_option(&options::indent_paren_after_func_def);
  register_option(&options::indent_paren_after_func_decl);
  register_option(&options::indent_paren_after_func_call);
  register_option(&options::indent_comma_brace);
  register_option(&options::indent_comma_paren);
  register_option(&options::indent_bool_paren);
  register_option(&options::indent_ignore_bool);
  register_option(&options::indent_bool_nested_all);
  register_option(&options::indent_ignore_arith);
  register_option(&options::indent_semicolon_for_paren);
  register_option(&options::indent_ignore_semicolon);
  register_option(&options::indent_first_bool_expr);
  register_option(&options::indent_first_for_expr);
  register_option(&options::indent_square_nl);
  register_option(&options::indent_preserve_sql);
  register_option(&options::indent_ignore_assign);
  register_option(&options::indent_align_assign);
  register_option(&options::indent_off_after_assign);
  register_option(&options::indent_align_paren);
  register_option(&options::indent_oc_inside_msg_sel);
  register_option(&options::indent_oc_block);
  register_option(&options::indent_oc_block_msg);
  register_option(&options::indent_oc_msg_colon);
  register_option(&options::indent_oc_msg_prioritize_first_colon);
  register_option(&options::indent_oc_block_msg_xcode_style);
  register_option(&options::indent_oc_block_msg_from_keyword);
  register_option(&options::indent_oc_block_msg_from_colon);
  register_option(&options::indent_oc_block_msg_from_caret);
  register_option(&options::indent_oc_block_msg_from_brace);
  register_option(&options::indent_min_vbrace_open);
  register_option(&options::indent_vbrace_open_on_tabstop);
  register_option(&options::indent_token_after_brace);
  register_option(&options::indent_cpp_lambda_body);
  register_option(&options::indent_compound_literal_return);
  register_option(&options::indent_using_block);
  register_option(&options::indent_ternary_operator);
  register_option(&options::indent_inside_ternary_operator);
  register_option(&options::indent_off_after_return);
  register_option(&options::indent_off_after_return_new);
  register_option(&options::indent_single_after_return);
  register_option(&options::indent_ignore_asm_block);
  register_option(&options::donot_indent_func_def_close_paren);

  begin_option_group(R"__(
Newline adding and removing options
)__");

  register_option(&options::nl_collapse_empty_body);
  register_option(&options::nl_collapse_empty_body_functions);
  register_option(&options::nl_assign_leave_one_liners);
  register_option(&options::nl_class_leave_one_liners);
  register_option(&options::nl_enum_leave_one_liners);
  register_option(&options::nl_getset_leave_one_liners);
  register_option(&options::nl_cs_property_leave_one_liners);
  register_option(&options::nl_func_leave_one_liners);
  register_option(&options::nl_cpp_lambda_leave_one_liners);
  register_option(&options::nl_if_leave_one_liners);
  register_option(&options::nl_while_leave_one_liners);
  register_option(&options::nl_do_leave_one_liners);
  register_option(&options::nl_for_leave_one_liners);
  register_option(&options::nl_oc_msg_leave_one_liner);
  register_option(&options::nl_oc_mdef_brace);
  register_option(&options::nl_oc_block_brace);
  register_option(&options::nl_oc_before_interface);
  register_option(&options::nl_oc_before_implementation);
  register_option(&options::nl_oc_before_end);
  register_option(&options::nl_oc_interface_brace);
  register_option(&options::nl_oc_implementation_brace);
  register_option(&options::nl_start_of_file);
  register_option(&options::nl_start_of_file_min);
  register_option(&options::nl_end_of_file);
  register_option(&options::nl_end_of_file_min);
  register_option(&options::nl_assign_brace);
  register_option(&options::nl_assign_square);
  register_option(&options::nl_tsquare_brace);
  register_option(&options::nl_after_square_assign);
  register_option(&options::nl_fcall_brace);
  register_option(&options::nl_enum_brace);
  register_option(&options::nl_enum_class);
  register_option(&options::nl_enum_class_identifier);
  register_option(&options::nl_enum_identifier_colon);
  register_option(&options::nl_enum_colon_type);
  register_option(&options::nl_struct_brace);
  register_option(&options::nl_union_brace);
  register_option(&options::nl_if_brace);
  register_option(&options::nl_brace_else);
  register_option(&options::nl_elseif_brace);
  register_option(&options::nl_else_brace);
  register_option(&options::nl_else_if);
  register_option(&options::nl_before_opening_brace_func_class_def);
  register_option(&options::nl_before_if_closing_paren);
  register_option(&options::nl_brace_finally);
  register_option(&options::nl_finally_brace);
  register_option(&options::nl_try_brace);
  register_option(&options::nl_getset_brace);
  register_option(&options::nl_for_brace);
  register_option(&options::nl_catch_brace);
  register_option(&options::nl_oc_catch_brace);
  register_option(&options::nl_brace_catch);
  register_option(&options::nl_oc_brace_catch);
  register_option(&options::nl_brace_square);
  register_option(&options::nl_brace_fparen);
  register_option(&options::nl_while_brace);
  register_option(&options::nl_scope_brace);
  register_option(&options::nl_unittest_brace);
  register_option(&options::nl_version_brace);
  register_option(&options::nl_using_brace);
  register_option(&options::nl_brace_brace);
  register_option(&options::nl_do_brace);
  register_option(&options::nl_brace_while);
  register_option(&options::nl_switch_brace);
  register_option(&options::nl_synchronized_brace);
  register_option(&options::nl_multi_line_cond);
  register_option(&options::nl_multi_line_sparen_open);
  register_option(&options::nl_multi_line_sparen_close);
  register_option(&options::nl_multi_line_define);
  register_option(&options::nl_before_case);
  register_option(&options::nl_after_case);
  register_option(&options::nl_case_colon_brace);
  register_option(&options::nl_before_throw);
  register_option(&options::nl_namespace_brace);
  register_option(&options::nl_template_class);
  register_option(&options::nl_template_class_decl);
  register_option(&options::nl_template_class_decl_special);
  register_option(&options::nl_template_class_def);
  register_option(&options::nl_template_class_def_special);
  register_option(&options::nl_template_func);
  register_option(&options::nl_template_func_decl);
  register_option(&options::nl_template_func_decl_special);
  register_option(&options::nl_template_func_def);
  register_option(&options::nl_template_func_def_special);
  register_option(&options::nl_template_var);
  register_option(&options::nl_template_using);
  register_option(&options::nl_class_brace);
  register_option(&options::nl_class_init_args);
  register_option(&options::nl_constr_init_args);
  register_option(&options::nl_enum_own_lines);
  register_option(&options::nl_func_type_name);
  register_option(&options::nl_func_type_name_class);
  register_option(&options::nl_func_class_scope);
  register_option(&options::nl_func_scope_name);
  register_option(&options::nl_func_proto_type_name);
  register_option(&options::nl_func_paren);
  register_option(&options::nl_func_paren_empty);
  register_option(&options::nl_func_def_paren);
  register_option(&options::nl_func_def_paren_empty);
  register_option(&options::nl_func_call_paren);
  register_option(&options::nl_func_call_paren_empty);
  register_option(&options::nl_func_decl_start);
  register_option(&options::nl_func_def_start);
  register_option(&options::nl_func_decl_start_single);
  register_option(&options::nl_func_def_start_single);
  register_option(&options::nl_func_decl_start_multi_line);
  register_option(&options::nl_func_def_start_multi_line);
  register_option(&options::nl_func_decl_args);
  register_option(&options::nl_func_def_args);
  register_option(&options::nl_func_call_args);
  register_option(&options::nl_func_decl_args_multi_line);
  register_option(&options::nl_func_def_args_multi_line);
  register_option(&options::nl_func_decl_end);
  register_option(&options::nl_func_def_end);
  register_option(&options::nl_func_decl_end_single);
  register_option(&options::nl_func_def_end_single);
  register_option(&options::nl_func_decl_end_multi_line);
  register_option(&options::nl_func_def_end_multi_line);
  register_option(&options::nl_func_decl_empty);
  register_option(&options::nl_func_def_empty);
  register_option(&options::nl_func_call_empty);
  register_option(&options::nl_func_call_start);
  register_option(&options::nl_func_call_end);
  register_option(&options::nl_func_call_start_multi_line);
  register_option(&options::nl_func_call_args_multi_line);
  register_option(&options::nl_func_call_end_multi_line);
  register_option(&options::nl_func_call_args_multi_line_ignore_closures);
  register_option(&options::nl_template_start);
  register_option(&options::nl_template_args);
  register_option(&options::nl_template_end);
  register_option(&options::nl_oc_msg_args);
  register_option(&options::nl_oc_msg_args_min_params);
  register_option(&options::nl_oc_msg_args_max_code_width);
  register_option(&options::nl_oc_msg_args_finish_multi_line);
  register_option(&options::nl_fdef_brace);
  register_option(&options::nl_fdef_brace_cond);
  register_option(&options::nl_cpp_ldef_brace);
  register_option(&options::nl_return_expr);
  register_option(&options::nl_throw_expr);
  register_option(&options::nl_after_semicolon);
  register_option(&options::nl_paren_dbrace_open);
  register_option(&options::nl_type_brace_init_lst);
  register_option(&options::nl_type_brace_init_lst_open);
  register_option(&options::nl_type_brace_init_lst_close);
  register_option(&options::nl_before_brace_open);
  register_option(&options::nl_after_brace_open);
  register_option(&options::nl_after_brace_open_cmt);
  register_option(&options::nl_after_vbrace_open);
  register_option(&options::nl_after_vbrace_open_empty);
  register_option(&options::nl_after_brace_close);
  register_option(&options::nl_after_vbrace_close);
  register_option(&options::nl_brace_struct_var);
  register_option(&options::nl_bool_expr_hierarchical);
  register_option(&options::nl_define_macro);
  register_option(&options::nl_squeeze_paren_close);
  register_option(&options::nl_squeeze_ifdef);
  register_option(&options::nl_squeeze_ifdef_top_level);
  register_option(&options::nl_before_if);
  register_option(&options::nl_after_if);
  register_option(&options::nl_before_for);
  register_option(&options::nl_after_for);
  register_option(&options::nl_before_while);
  register_option(&options::nl_after_while);
  register_option(&options::nl_before_switch);
  register_option(&options::nl_after_switch);
  register_option(&options::nl_before_synchronized);
  register_option(&options::nl_after_synchronized);
  register_option(&options::nl_before_do);
  register_option(&options::nl_after_do);
  register_option(&options::nl_before_ignore_after_case);
  register_option(&options::nl_before_return);
  register_option(&options::nl_after_return);
  register_option(&options::nl_before_member);
  register_option(&options::nl_after_member);
  register_option(&options::nl_ds_struct_enum_cmt);
  register_option(&options::nl_ds_struct_enum_close_brace);
  register_option(&options::nl_class_colon);
  register_option(&options::nl_constr_colon);
  register_option(&options::nl_namespace_two_to_one_liner);
  register_option(&options::nl_create_if_one_liner);
  register_option(&options::nl_create_for_one_liner);
  register_option(&options::nl_create_while_one_liner);
  register_option(&options::nl_create_func_def_one_liner);
  register_option(&options::nl_create_list_one_liner);
  register_option(&options::nl_split_if_one_liner);
  register_option(&options::nl_split_for_one_liner);
  register_option(&options::nl_split_while_one_liner);
  register_option(&options::donot_add_nl_before_cpp_comment);

  begin_option_group(R"__(
Blank line options
)__");

  register_option(&options::nl_max);
  register_option(&options::nl_max_blank_in_func);
  register_option(&options::nl_inside_empty_func);
  register_option(&options::nl_before_func_body_proto);
  register_option(&options::nl_before_func_body_def);
  register_option(&options::nl_before_func_class_proto);
  register_option(&options::nl_before_func_class_def);
  register_option(&options::nl_after_func_proto);
  register_option(&options::nl_after_func_proto_group);
  register_option(&options::nl_after_func_class_proto);
  register_option(&options::nl_after_func_class_proto_group);
  register_option(&options::nl_class_leave_one_liner_groups);
  register_option(&options::nl_after_func_body);
  register_option(&options::nl_min_after_func_body);
  register_option(&options::nl_max_after_func_body);
  register_option(&options::nl_after_func_body_class);
  register_option(&options::nl_after_func_body_one_liner);
  register_option(&options::nl_typedef_blk_start);
  register_option(&options::nl_typedef_blk_end);
  register_option(&options::nl_typedef_blk_in);
  register_option(&options::nl_var_def_blk_end_func_top);
  register_option(&options::nl_var_def_blk_start);
  register_option(&options::nl_var_def_blk_end);
  register_option(&options::nl_var_def_blk_in);
  register_option(&options::nl_before_block_comment);
  register_option(&options::nl_before_c_comment);
  register_option(&options::nl_before_cpp_comment);
  register_option(&options::nl_after_multiline_comment);
  register_option(&options::nl_after_label_colon);
  register_option(&options::nl_before_struct);
  register_option(&options::nl_after_struct);
  register_option(&options::nl_before_class);
  register_option(&options::nl_after_class);
  register_option(&options::nl_before_namespace);
  register_option(&options::nl_inside_namespace);
  register_option(&options::nl_after_namespace);
  register_option(&options::nl_before_access_spec);
  register_option(&options::nl_after_access_spec);
  register_option(&options::nl_comment_func_def);
  register_option(&options::nl_after_try_catch_finally);
  register_option(&options::nl_around_cs_property);
  register_option(&options::nl_between_get_set);
  register_option(&options::nl_property_brace);
  register_option(&options::eat_blanks_after_open_brace);
  register_option(&options::eat_blanks_before_close_brace);
  register_option(&options::nl_remove_extra_newlines);
  register_option(&options::nl_after_annotation);
  register_option(&options::nl_between_annotation);
  register_option(&options::nl_before_whole_file_ifdef);
  register_option(&options::nl_after_whole_file_ifdef);
  register_option(&options::nl_before_whole_file_endif);
  register_option(&options::nl_after_whole_file_endif);

  begin_option_group(R"__(
Positioning options
)__");

  register_option(&options::pos_arith);
  register_option(&options::pos_assign);
  register_option(&options::pos_bool);
  register_option(&options::pos_compare);
  register_option(&options::pos_conditional);
  register_option(&options::pos_comma);
  register_option(&options::pos_enum_comma);
  register_option(&options::pos_class_comma);
  register_option(&options::pos_constr_comma);
  register_option(&options::pos_class_colon);
  register_option(&options::pos_constr_colon);
  register_option(&options::pos_shift);

  begin_option_group(R"__(
Line splitting options
)__");

  register_option(&options::code_width);
  register_option(&options::ls_for_split_full);
  register_option(&options::ls_func_split_full);
  register_option(&options::ls_code_width);

  begin_option_group(R"__(
Code alignment options (not left column spaces/tabs)
)__");

  register_option(&options::align_keep_tabs);
  register_option(&options::align_with_tabs);
  register_option(&options::align_on_tabstop);
  register_option(&options::align_number_right);
  register_option(&options::align_keep_extra_space);
  register_option(&options::align_func_params);
  register_option(&options::align_func_params_span);
  register_option(&options::align_func_params_thresh);
  register_option(&options::align_func_params_gap);
  register_option(&options::align_constr_value_span);
  register_option(&options::align_constr_value_thresh);
  register_option(&options::align_constr_value_gap);
  register_option(&options::align_same_func_call_params);
  register_option(&options::align_same_func_call_params_span);
  register_option(&options::align_same_func_call_params_thresh);
  register_option(&options::align_var_def_span);
  register_option(&options::align_var_def_star_style);
  register_option(&options::align_var_def_amp_style);
  register_option(&options::align_var_def_thresh);
  register_option(&options::align_var_def_gap);
  register_option(&options::align_var_def_colon);
  register_option(&options::align_var_def_colon_gap);
  register_option(&options::align_var_def_attribute);
  register_option(&options::align_var_def_inline);
  register_option(&options::align_assign_span);
  register_option(&options::align_assign_func_proto_span);
  register_option(&options::align_assign_thresh);
  register_option(&options::align_assign_on_multi_var_defs);
  register_option(&options::align_braced_init_list_span);
  register_option(&options::align_braced_init_list_thresh);
  register_option(&options::align_assign_decl_func);
  register_option(&options::align_enum_equ_span);
  register_option(&options::align_enum_equ_thresh);
  register_option(&options::align_var_class_span);
  register_option(&options::align_var_class_thresh);
  register_option(&options::align_var_class_gap);
  register_option(&options::align_var_struct_span);
  register_option(&options::align_var_struct_thresh);
  register_option(&options::align_var_struct_gap);
  register_option(&options::align_struct_init_span);
  register_option(&options::align_typedef_span);
  register_option(&options::align_typedef_gap);
  register_option(&options::align_typedef_func);
  register_option(&options::align_typedef_star_style);
  register_option(&options::align_typedef_amp_style);
  register_option(&options::align_right_cmt_span);
  register_option(&options::align_right_cmt_gap);
  register_option(&options::align_right_cmt_mix);
  register_option(&options::align_right_cmt_same_level);
  register_option(&options::align_right_cmt_at_col);
  register_option(&options::align_func_proto_span);
  register_option(&options::align_func_proto_span_ignore_cont_lines);
  register_option(&options::align_func_proto_star_style);
  register_option(&options::align_func_proto_amp_style);
  register_option(&options::align_func_proto_thresh);
  register_option(&options::align_func_proto_gap);
  register_option(&options::align_on_operator);
  register_option(&options::align_mix_var_proto);
  register_option(&options::align_single_line_func);
  register_option(&options::align_single_line_brace);
  register_option(&options::align_single_line_brace_gap);
  register_option(&options::align_oc_msg_spec_span);
  register_option(&options::align_nl_cont);
  register_option(&options::align_nl_cont_spaces);
  register_option(&options::align_pp_define_together);
  register_option(&options::align_pp_define_span);
  register_option(&options::align_pp_define_gap);
  register_option(&options::align_left_shift);
  register_option(&options::align_eigen_comma_init);
  register_option(&options::align_asm_colon);
  register_option(&options::align_oc_msg_colon_span);
  register_option(&options::align_oc_msg_colon_first);
  register_option(&options::align_oc_decl_colon);
  register_option(&options::align_oc_msg_colon_xcode_like);

  begin_option_group(R"__(
Comment modification options
)__");

  register_option(&options::cmt_width);
  register_option(&options::cmt_reflow_mode);
  register_option(&options::cmt_reflow_fold_regex_file);
  register_option(&options::cmt_reflow_indent_to_paragraph_start);
  register_option(&options::cmt_convert_tab_to_spaces);
  register_option(&options::cmt_indent_multi);
  register_option(&options::cmt_align_doxygen_javadoc_tags);
  register_option(&options::cmt_sp_before_doxygen_javadoc_tags);
  register_option(&options::cmt_trailing_single_line_c_to_cpp);
  register_option(&options::cmt_c_group);
  register_option(&options::cmt_c_nl_start);
  register_option(&options::cmt_c_nl_end);
  register_option(&options::cmt_cpp_to_c);
  register_option(&options::cmt_cpp_group);
  register_option(&options::cmt_cpp_nl_start);
  register_option(&options::cmt_cpp_nl_end);
  register_option(&options::cmt_star_cont);
  register_option(&options::cmt_sp_before_star_cont);
  register_option(&options::cmt_sp_after_star_cont);
  register_option(&options::cmt_multi_check_last);
  register_option(&options::cmt_multi_first_len_minimum);
  register_option(&options::cmt_insert_file_header);
  register_option(&options::cmt_insert_file_footer);
  register_option(&options::cmt_insert_func_header);
  register_option(&options::cmt_insert_class_header);
  register_option(&options::cmt_insert_oc_msg_header);
  register_option(&options::cmt_insert_before_preproc);
  register_option(&options::cmt_insert_before_inlines);
  register_option(&options::cmt_insert_before_ctor_dtor);

  begin_option_group(R"__(
Code modifying options (non-whitespace)
)__");

  register_option(&options::mod_full_brace_do);
  register_option(&options::mod_full_brace_for);
  register_option(&options::mod_full_brace_function);
  register_option(&options::mod_full_brace_if);
  register_option(&options::mod_full_brace_if_chain);
  register_option(&options::mod_full_brace_if_chain_only);
  register_option(&options::mod_full_brace_while);
  register_option(&options::mod_full_brace_using);
  register_option(&options::mod_full_brace_nl);
  register_option(&options::mod_full_brace_nl_block_rem_mlcond);
  register_option(&options::mod_paren_on_return);
  register_option(&options::mod_paren_on_throw);
  register_option(&options::mod_pawn_semicolon);
  register_option(&options::mod_full_paren_if_bool);
  register_option(&options::mod_full_paren_assign_bool);
  register_option(&options::mod_full_paren_return_bool);
  register_option(&options::mod_remove_extra_semicolon);
  register_option(&options::mod_remove_duplicate_include);
  register_option(&options::mod_add_force_c_closebrace_comment);
  register_option(&options::mod_add_long_function_closebrace_comment);
  register_option(&options::mod_add_long_namespace_closebrace_comment);
  register_option(&options::mod_add_long_class_closebrace_comment);
  register_option(&options::mod_add_long_switch_closebrace_comment);
  register_option(&options::mod_add_long_ifdef_endif_comment);
  register_option(&options::mod_add_long_ifdef_else_comment);
  register_option(&options::mod_sort_case_sensitive);
  register_option(&options::mod_sort_import);
  register_option(&options::mod_sort_using);
  register_option(&options::mod_sort_include);
  register_option(&options::mod_sort_incl_import_prioritize_filename);
  register_option(&options::mod_sort_incl_import_prioritize_extensionless);
  register_option(&options::mod_sort_incl_import_prioritize_angle_over_quotes);
  register_option(&options::mod_sort_incl_import_ignore_extension);
  register_option(&options::mod_sort_incl_import_grouping_enabled);
  register_option(&options::mod_move_case_break);
  register_option(&options::mod_move_case_return);
  register_option(&options::mod_case_brace);
  register_option(&options::mod_remove_empty_return);
  register_option(&options::mod_enum_last_comma);
  register_option(&options::mod_infinite_loop);
  register_option(&options::mod_int_short);
  register_option(&options::mod_short_int);
  register_option(&options::mod_int_long);
  register_option(&options::mod_long_int);
  register_option(&options::mod_int_signed);
  register_option(&options::mod_signed_int);
  register_option(&options::mod_int_unsigned);
  register_option(&options::mod_unsigned_int);
  register_option(&options::mod_int_prefer_int_on_left);
  register_option(&options::mod_sort_oc_properties);
  register_option(&options::mod_sort_oc_property_class_weight);
  register_option(&options::mod_sort_oc_property_thread_safe_weight);
  register_option(&options::mod_sort_oc_property_readwrite_weight);
  register_option(&options::mod_sort_oc_property_reference_weight);
  register_option(&options::mod_sort_oc_property_getter_weight);
  register_option(&options::mod_sort_oc_property_setter_weight);
  register_option(&options::mod_sort_oc_property_nullability_weight);

  begin_option_group(R"__(
Preprocessor options
)__");

  register_option(&options::pp_indent_with_tabs);
  register_option(&options::pp_indent);
  register_option(&options::pp_indent_at_level);
  register_option(&options::pp_indent_at_level0);
  register_option(&options::pp_indent_count);
  register_option(&options::pp_space_after);
  register_option(&options::pp_space_count);
  register_option(&options::pp_indent_region);
  register_option(&options::pp_region_indent_code);
  register_option(&options::pp_indent_if);
  register_option(&options::pp_if_indent_code);
  register_option(&options::pp_indent_in_guard);
  register_option(&options::pp_define_at_level);
  register_option(&options::pp_include_at_level);
  register_option(&options::pp_ignore_define_body);
  register_option(&options::pp_multiline_define_body_indent);
  register_option(&options::pp_indent_case);
  register_option(&options::pp_indent_func_def);
  register_option(&options::pp_indent_extern);
  register_option(&options::pp_indent_brace);
  register_option(&options::pp_unbalanced_if_action);

  begin_option_group(R"__(
Sort includes options
)__");

  register_option(&options::include_category_0);
  register_option(&options::include_category_1);
  register_option(&options::include_category_2);

  begin_option_group(R"__(
Use or Do not Use options
)__");

  register_option(&options::use_indent_func_call_param);
  register_option(&options::use_indent_continue_only_once);
  register_option(&options::indent_cpp_lambda_only_once);
  register_option(&options::use_sp_after_angle_always);
  register_option(&options::use_options_overriding_for_qt_macros);
  register_option(&options::use_form_feed_no_more_as_whitespace_character);

  begin_option_group(R"__(
Warn levels - 1: error, 2: warning (default), 3: note
)__");

  register_option(&options::warn_level_tabs_found_in_verbatim_string_literals);
  register_option(&options::debug_max_number_of_loops);
  register_option(&options::debug_line_number_to_protocol);
  register_option(&options::debug_timeout);
  register_option(&options::debug_truncate);
  register_option(&options::debug_sort_the_tracks);
  register_option(&options::debug_decode_the_flags);
  register_option(&options::debug_use_the_exit_function_pop);
  register_option(&options::debug_print_version);
  register_option(&options::set_numbering_for_html_output);
}

} // namespace uncrustify
