/** @file
 * VirtualBox API class wrapper code for IMouse.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_MOUSE

#include "MouseWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(MouseWrap)

//
// IMouse properties
//

STDMETHODIMP MouseWrap::COMGETTER(AbsoluteSupported)(BOOL *aAbsoluteSupported)
{
    LogRelFlow(("{%p} %s: enter aAbsoluteSupported=%p\n", this, "Mouse::getAbsoluteSupported", aAbsoluteSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAbsoluteSupported);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_ABSOLUTESUPPORTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAbsoluteSupported(aAbsoluteSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_ABSOLUTESUPPORTED_RETURN(this, hrc, 0 /*normal*/,*aAbsoluteSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_ABSOLUTESUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/,*aAbsoluteSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_ABSOLUTESUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aAbsoluteSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAbsoluteSupported=%RTbool hrc=%Rhrc\n", this, "Mouse::getAbsoluteSupported", *aAbsoluteSupported, hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::COMGETTER(RelativeSupported)(BOOL *aRelativeSupported)
{
    LogRelFlow(("{%p} %s: enter aRelativeSupported=%p\n", this, "Mouse::getRelativeSupported", aRelativeSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRelativeSupported);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_RELATIVESUPPORTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRelativeSupported(aRelativeSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_RELATIVESUPPORTED_RETURN(this, hrc, 0 /*normal*/,*aRelativeSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_RELATIVESUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/,*aRelativeSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_RELATIVESUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aRelativeSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRelativeSupported=%RTbool hrc=%Rhrc\n", this, "Mouse::getRelativeSupported", *aRelativeSupported, hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::COMGETTER(TouchScreenSupported)(BOOL *aTouchScreenSupported)
{
    LogRelFlow(("{%p} %s: enter aTouchScreenSupported=%p\n", this, "Mouse::getTouchScreenSupported", aTouchScreenSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTouchScreenSupported);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_TOUCHSCREENSUPPORTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTouchScreenSupported(aTouchScreenSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_TOUCHSCREENSUPPORTED_RETURN(this, hrc, 0 /*normal*/,*aTouchScreenSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_TOUCHSCREENSUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/,*aTouchScreenSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_TOUCHSCREENSUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aTouchScreenSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTouchScreenSupported=%RTbool hrc=%Rhrc\n", this, "Mouse::getTouchScreenSupported", *aTouchScreenSupported, hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::COMGETTER(TouchPadSupported)(BOOL *aTouchPadSupported)
{
    LogRelFlow(("{%p} %s: enter aTouchPadSupported=%p\n", this, "Mouse::getTouchPadSupported", aTouchPadSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTouchPadSupported);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_TOUCHPADSUPPORTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTouchPadSupported(aTouchPadSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_TOUCHPADSUPPORTED_RETURN(this, hrc, 0 /*normal*/,*aTouchPadSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_TOUCHPADSUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/,*aTouchPadSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_TOUCHPADSUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aTouchPadSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTouchPadSupported=%RTbool hrc=%Rhrc\n", this, "Mouse::getTouchPadSupported", *aTouchPadSupported, hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::COMGETTER(NeedsHostCursor)(BOOL *aNeedsHostCursor)
{
    LogRelFlow(("{%p} %s: enter aNeedsHostCursor=%p\n", this, "Mouse::getNeedsHostCursor", aNeedsHostCursor));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNeedsHostCursor);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_NEEDSHOSTCURSOR_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNeedsHostCursor(aNeedsHostCursor);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_NEEDSHOSTCURSOR_RETURN(this, hrc, 0 /*normal*/,*aNeedsHostCursor != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_NEEDSHOSTCURSOR_RETURN(this, hrc, 1 /*hrc exception*/,*aNeedsHostCursor != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_NEEDSHOSTCURSOR_RETURN(this, hrc, 9 /*unhandled exception*/,*aNeedsHostCursor != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNeedsHostCursor=%RTbool hrc=%Rhrc\n", this, "Mouse::getNeedsHostCursor", *aNeedsHostCursor, hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::COMGETTER(PointerShape)(IMousePointerShape **aPointerShape)
{
    LogRelFlow(("{%p} %s: enter aPointerShape=%p\n", this, "Mouse::getPointerShape", aPointerShape));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPointerShape);
        ComTypeOutConverter<IMousePointerShape> TmpPointerShape(aPointerShape);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_POINTERSHAPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPointerShape(TmpPointerShape.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_POINTERSHAPE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpPointerShape.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_POINTERSHAPE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_POINTERSHAPE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPointerShape=%p hrc=%Rhrc\n", this, "Mouse::getPointerShape", *aPointerShape, hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "Mouse::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "Mouse::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::COMGETTER(InternalAndReservedAttribute1IMouse)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MouseWrap::COMGETTER(InternalAndReservedAttribute2IMouse)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MouseWrap::COMGETTER(InternalAndReservedAttribute3IMouse)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP MouseWrap::COMGETTER(InternalAndReservedAttribute4IMouse)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IMouse methods
//

STDMETHODIMP MouseWrap::PutMouseEvent(LONG aDx,
                                      LONG aDy,
                                      LONG aDz,
                                      LONG aDw,
                                      LONG aButtonState)
{
    LogRelFlow(("{%p} %s: enter aDx=%RI32 aDy=%RI32 aDz=%RI32 aDw=%RI32 aButtonState=%RI32\n", this, "Mouse::putMouseEvent", aDx, aDy, aDz, aDw, aButtonState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTMOUSEEVENT_ENTER(this, aDx, aDy, aDz, aDw, aButtonState);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = putMouseEvent(aDx,
                                aDy,
                                aDz,
                                aDw,
                                aButtonState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTMOUSEEVENT_RETURN(this, hrc, 0 /*normal*/, aDx, aDy, aDz, aDw, aButtonState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTMOUSEEVENT_RETURN(this, hrc, 1 /*hrc exception*/, aDx, aDy, aDz, aDw, aButtonState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTMOUSEEVENT_RETURN(this, hrc, 9 /*unhandled exception*/, aDx, aDy, aDz, aDw, aButtonState);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Mouse::putMouseEvent", hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::PutMouseEventAbsolute(LONG aX,
                                              LONG aY,
                                              LONG aDz,
                                              LONG aDw,
                                              LONG aButtonState)
{
    LogRelFlow(("{%p} %s: enter aX=%RI32 aY=%RI32 aDz=%RI32 aDw=%RI32 aButtonState=%RI32\n", this, "Mouse::putMouseEventAbsolute", aX, aY, aDz, aDw, aButtonState));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTMOUSEEVENTABSOLUTE_ENTER(this, aX, aY, aDz, aDw, aButtonState);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = putMouseEventAbsolute(aX,
                                        aY,
                                        aDz,
                                        aDw,
                                        aButtonState);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTMOUSEEVENTABSOLUTE_RETURN(this, hrc, 0 /*normal*/, aX, aY, aDz, aDw, aButtonState);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTMOUSEEVENTABSOLUTE_RETURN(this, hrc, 1 /*hrc exception*/, aX, aY, aDz, aDw, aButtonState);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTMOUSEEVENTABSOLUTE_RETURN(this, hrc, 9 /*unhandled exception*/, aX, aY, aDz, aDw, aButtonState);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Mouse::putMouseEventAbsolute", hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::PutEventMultiTouch(LONG aCount,
                                           ComSafeArrayIn(LONG64, aContacts),
                                           BOOL aIsTouchScreen,
                                           ULONG aScanTime)
{
    LogRelFlow(("{%p} %s: enter aCount=%RI32 aContacts=%zu aIsTouchScreen=%RTbool aScanTime=%RU32\n", this, "Mouse::putEventMultiTouch", aCount, aContacts, aIsTouchScreen, aScanTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        ArrayInConverter<LONG64> TmpContacts(ComSafeArrayInArg(aContacts));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTEVENTMULTITOUCH_ENTER(this, aCount, (uint32_t)TmpContacts.array().size(), NULL /*for now*/, aIsTouchScreen != FALSE, aScanTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = putEventMultiTouch(aCount,
                                     TmpContacts.array(),
                                     aIsTouchScreen != FALSE,
                                     aScanTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTEVENTMULTITOUCH_RETURN(this, hrc, 0 /*normal*/, aCount, (uint32_t)TmpContacts.array().size(), NULL /*for now*/, aIsTouchScreen != FALSE, aScanTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTEVENTMULTITOUCH_RETURN(this, hrc, 1 /*hrc exception*/, aCount, 0, 0, aIsTouchScreen != FALSE, aScanTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTEVENTMULTITOUCH_RETURN(this, hrc, 9 /*unhandled exception*/, aCount, 0, 0, aIsTouchScreen != FALSE, aScanTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Mouse::putEventMultiTouch", hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::PutEventMultiTouchString(LONG aCount,
                                                 IN_BSTR aContacts,
                                                 BOOL aIsTouchScreen,
                                                 ULONG aScanTime)
{
    LogRelFlow(("{%p} %s: enter aCount=%RI32 aContacts=%ls aIsTouchScreen=%RTbool aScanTime=%RU32\n", this, "Mouse::putEventMultiTouchString", aCount, aContacts, aIsTouchScreen, aScanTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        BSTRInConverter TmpContacts(aContacts);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTEVENTMULTITOUCHSTRING_ENTER(this, aCount, TmpContacts.str().c_str(), aIsTouchScreen != FALSE, aScanTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = putEventMultiTouchString(aCount,
                                           TmpContacts.str(),
                                           aIsTouchScreen != FALSE,
                                           aScanTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTEVENTMULTITOUCHSTRING_RETURN(this, hrc, 0 /*normal*/, aCount, TmpContacts.str().c_str(), aIsTouchScreen != FALSE, aScanTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTEVENTMULTITOUCHSTRING_RETURN(this, hrc, 1 /*hrc exception*/, aCount, 0, aIsTouchScreen != FALSE, aScanTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_MOUSE_PUTEVENTMULTITOUCHSTRING_RETURN(this, hrc, 9 /*unhandled exception*/, aCount, 0, aIsTouchScreen != FALSE, aScanTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Mouse::putEventMultiTouchString", hrc));
    return hrc;
}

STDMETHODIMP MouseWrap::InternalAndReservedMethod1IMouse()
{
    return E_NOTIMPL;
}

STDMETHODIMP MouseWrap::InternalAndReservedMethod2IMouse()
{
    return E_NOTIMPL;
}

STDMETHODIMP MouseWrap::InternalAndReservedMethod3IMouse()
{
    return E_NOTIMPL;
}

STDMETHODIMP MouseWrap::InternalAndReservedMethod4IMouse()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(MouseWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(MouseWrap, IMouse)
#endif // VBOX_WITH_XPCOM
