/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedWebDriverBidiDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "WebDriverBidiProtocolObjects.h"



namespace Inspector {

namespace Protocol {

namespace WebDriverBidiHelpers {

static const auto enum_constant_values = std::to_array<ASCIILiteral>({
    "tab"_s,
    "window"_s,
    "none"_s,
    "interactive"_s,
    "complete"_s,
    "alert"_s,
    "beforeunload"_s,
    "confirm"_s,
    "prompt"_s,
    "success"_s,
    "exception"_s,
    "array"_s,
    "date"_s,
    "map"_s,
    "object"_s,
    "set"_s,
    "arraybuffer"_s,
    "error"_s,
    "function"_s,
    "generator"_s,
    "htmlcollection"_s,
    "node"_s,
    "nodelist"_s,
    "promise"_s,
    "proxy"_s,
    "regexp"_s,
    "symbol"_s,
    "typedarray"_s,
    "weakmap"_s,
    "weakset"_s,
    "root"_s,
    "open"_s,
    "all"_s,
    "accept"_s,
    "dismiss"_s,
    "ignore"_s,
    "context"_s,
    "storageKey"_s,
    "None"_s,
    "Lax"_s,
    "Strict"_s,
});

String getEnumConstantValue(int code) {
    return enum_constant_values[code];
}

#if ENABLE(WEBDRIVER_BIDI)
// Enums in the 'BidiBrowsingContext' Domain

template<> std::optional<Protocol::BidiBrowsingContext::CreateType> parseEnumValueFromString<Protocol::BidiBrowsingContext::CreateType>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiBrowsingContext::CreateType::Tab,
        (size_t)Protocol::BidiBrowsingContext::CreateType::Window,
    });
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiBrowsingContext::CreateType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiBrowsingContext::ReadinessState> parseEnumValueFromString<Protocol::BidiBrowsingContext::ReadinessState>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiBrowsingContext::ReadinessState::None,
        (size_t)Protocol::BidiBrowsingContext::ReadinessState::Interactive,
        (size_t)Protocol::BidiBrowsingContext::ReadinessState::Complete,
    });
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiBrowsingContext::ReadinessState)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiBrowsingContext::UserPromptType> parseEnumValueFromString<Protocol::BidiBrowsingContext::UserPromptType>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiBrowsingContext::UserPromptType::Alert,
        (size_t)Protocol::BidiBrowsingContext::UserPromptType::Beforeunload,
        (size_t)Protocol::BidiBrowsingContext::UserPromptType::Confirm,
        (size_t)Protocol::BidiBrowsingContext::UserPromptType::Prompt,
    });
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiBrowsingContext::UserPromptType)constantValues[i];

    return std::nullopt;
}
#endif // ENABLE(WEBDRIVER_BIDI)

#if ENABLE(WEBDRIVER_BIDI)
// Enums in the 'BidiScript' Domain

template<> std::optional<Protocol::BidiScript::EvaluateResultType> parseEnumValueFromString<Protocol::BidiScript::EvaluateResultType>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiScript::EvaluateResultType::Success,
        (size_t)Protocol::BidiScript::EvaluateResultType::Exception,
    });
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiScript::EvaluateResultType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiScript::LocalValueType> parseEnumValueFromString<Protocol::BidiScript::LocalValueType>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiScript::LocalValueType::Array,
        (size_t)Protocol::BidiScript::LocalValueType::Date,
        (size_t)Protocol::BidiScript::LocalValueType::Map,
        (size_t)Protocol::BidiScript::LocalValueType::Object,
        (size_t)Protocol::BidiScript::LocalValueType::Set,
    });
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiScript::LocalValueType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiScript::RemoteValueType> parseEnumValueFromString<Protocol::BidiScript::RemoteValueType>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiScript::RemoteValueType::Array,
        (size_t)Protocol::BidiScript::RemoteValueType::Arraybuffer,
        (size_t)Protocol::BidiScript::RemoteValueType::Date,
        (size_t)Protocol::BidiScript::RemoteValueType::Error,
        (size_t)Protocol::BidiScript::RemoteValueType::Function,
        (size_t)Protocol::BidiScript::RemoteValueType::Generator,
        (size_t)Protocol::BidiScript::RemoteValueType::HTMLcollection,
        (size_t)Protocol::BidiScript::RemoteValueType::Map,
        (size_t)Protocol::BidiScript::RemoteValueType::Node,
        (size_t)Protocol::BidiScript::RemoteValueType::Nodelist,
        (size_t)Protocol::BidiScript::RemoteValueType::Object,
        (size_t)Protocol::BidiScript::RemoteValueType::Promise,
        (size_t)Protocol::BidiScript::RemoteValueType::Proxy,
        (size_t)Protocol::BidiScript::RemoteValueType::Regexp,
        (size_t)Protocol::BidiScript::RemoteValueType::Set,
        (size_t)Protocol::BidiScript::RemoteValueType::Symbol,
        (size_t)Protocol::BidiScript::RemoteValueType::Typedarray,
        (size_t)Protocol::BidiScript::RemoteValueType::Weakmap,
        (size_t)Protocol::BidiScript::RemoteValueType::Weakset,
        (size_t)Protocol::BidiScript::RemoteValueType::Window,
    });
    for (size_t i = 0; i < 20; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiScript::RemoteValueType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiScript::ResultOwnership> parseEnumValueFromString<Protocol::BidiScript::ResultOwnership>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiScript::ResultOwnership::Root,
        (size_t)Protocol::BidiScript::ResultOwnership::None,
    });
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiScript::ResultOwnership)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiScript::SerializationOptions::IncludesShadowTree> parseEnumValueFromString<Protocol::BidiScript::SerializationOptions::IncludesShadowTree>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiScript::SerializationOptions::IncludesShadowTree::None,
        (size_t)Protocol::BidiScript::SerializationOptions::IncludesShadowTree::Open,
        (size_t)Protocol::BidiScript::SerializationOptions::IncludesShadowTree::All,
    });
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiScript::SerializationOptions::IncludesShadowTree)constantValues[i];

    return std::nullopt;
}
#endif // ENABLE(WEBDRIVER_BIDI)

#if ENABLE(WEBDRIVER_BIDI)
// Enums in the 'BidiSession' Domain

template<> std::optional<Protocol::BidiSession::UserPromptHandlerType> parseEnumValueFromString<Protocol::BidiSession::UserPromptHandlerType>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiSession::UserPromptHandlerType::Accept,
        (size_t)Protocol::BidiSession::UserPromptHandlerType::Dismiss,
        (size_t)Protocol::BidiSession::UserPromptHandlerType::Ignore,
    });
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiSession::UserPromptHandlerType)constantValues[i];

    return std::nullopt;
}
#endif // ENABLE(WEBDRIVER_BIDI)

#if ENABLE(WEBDRIVER_BIDI)
// Enums in the 'BidiStorage' Domain

template<> std::optional<Protocol::BidiStorage::PartitionDescriptorType> parseEnumValueFromString<Protocol::BidiStorage::PartitionDescriptorType>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiStorage::PartitionDescriptorType::Context,
        (size_t)Protocol::BidiStorage::PartitionDescriptorType::StorageKey,
    });
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiStorage::PartitionDescriptorType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiStorage::CookieSameSitePolicy> parseEnumValueFromString<Protocol::BidiStorage::CookieSameSitePolicy>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiStorage::CookieSameSitePolicy::None,
        (size_t)Protocol::BidiStorage::CookieSameSitePolicy::Lax,
        (size_t)Protocol::BidiStorage::CookieSameSitePolicy::Strict,
    });
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiStorage::CookieSameSitePolicy)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiStorage::BrowsingContextPartitionDescriptor::Type> parseEnumValueFromString<Protocol::BidiStorage::BrowsingContextPartitionDescriptor::Type>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiStorage::BrowsingContextPartitionDescriptor::Type::Context,
    });
    for (size_t i = 0; i < 1; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiStorage::BrowsingContextPartitionDescriptor::Type)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::BidiStorage::StorageKeyPartitionDescriptor::Type> parseEnumValueFromString<Protocol::BidiStorage::StorageKeyPartitionDescriptor::Type>(const String& protocolString)
{
    static const auto constantValues = std::to_array<size_t>({
        (size_t)Protocol::BidiStorage::StorageKeyPartitionDescriptor::Type::StorageKey,
    });
    for (size_t i = 0; i < 1; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::BidiStorage::StorageKeyPartitionDescriptor::Type)constantValues[i];

    return std::nullopt;
}
#endif // ENABLE(WEBDRIVER_BIDI)

} // namespace WebDriverBidiHelpers

} // namespace Protocol

} // namespace Inspector
