/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBackgroundFetchResult.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(BackgroundFetchResult enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        emptyString(),
        MAKE_STATIC_STRING_IMPL("success"),
        MAKE_STATIC_STRING_IMPL("failure"),
    };
    static_assert(static_cast<size_t>(BackgroundFetchResult::EmptyString) == 0, "BackgroundFetchResult::EmptyString is not 0 as expected");
    static_assert(static_cast<size_t>(BackgroundFetchResult::Success) == 1, "BackgroundFetchResult::Success is not 1 as expected");
    static_assert(static_cast<size_t>(BackgroundFetchResult::Failure) == 2, "BackgroundFetchResult::Failure is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, BackgroundFetchResult enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<BackgroundFetchResult> parseEnumerationFromString<BackgroundFetchResult>(const String& stringValue)
{
    if (stringValue.isEmpty())
        return BackgroundFetchResult::EmptyString;
    static constexpr std::array<std::pair<ComparableASCIILiteral, BackgroundFetchResult>, 2> mappings {
        std::pair<ComparableASCIILiteral, BackgroundFetchResult> { "failure"_s, BackgroundFetchResult::Failure },
        std::pair<ComparableASCIILiteral, BackgroundFetchResult> { "success"_s, BackgroundFetchResult::Success },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<BackgroundFetchResult> parseEnumeration<BackgroundFetchResult>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<BackgroundFetchResult>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<BackgroundFetchResult>()
{
    return "\"\", \"success\", \"failure\""_s;
}

} // namespace WebCore

