/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImportNodeOptions.h"

#include "JSCustomElementRegistry.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ImportNodeOptions>> convertDictionary<ImportNodeOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ImportNodeOptions result;
    JSValue customElementRegistryValue;
    if (isNullOrUndefined)
        customElementRegistryValue = jsUndefined();
    else {
        customElementRegistryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "customElementRegistry"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!customElementRegistryValue.isUndefined()) {
        auto customElementRegistryConversionResult = convert<IDLInterface<CustomElementRegistry>>(lexicalGlobalObject, customElementRegistryValue);
        if (customElementRegistryConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.customElementRegistry = customElementRegistryConversionResult.releaseReturnValue();
    }
    JSValue selfOnlyValue;
    if (isNullOrUndefined)
        selfOnlyValue = jsUndefined();
    else {
        selfOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "selfOnly"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto selfOnlyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, selfOnlyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (selfOnlyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.selfOnly = selfOnlyConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

