/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaQueryListEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<MediaQueryListEvent::Init>> convertDictionary<MediaQueryListEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaQueryListEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue matchesValue;
    if (isNullOrUndefined)
        matchesValue = jsUndefined();
    else {
        matchesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "matches"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto matchesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, matchesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (matchesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.matches = matchesConversionResult.releaseReturnValue();
    JSValue mediaValue;
    if (isNullOrUndefined)
        mediaValue = jsUndefined();
    else {
        mediaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "media"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto mediaConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, mediaValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (mediaConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.media = mediaConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaQueryListEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaQueryListEvent_media);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaQueryListEvent_matches);

class JSMediaQueryListEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaQueryListEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaQueryListEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaQueryListEventPrototype>(vm)) JSMediaQueryListEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaQueryListEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaQueryListEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaQueryListEventPrototype, JSMediaQueryListEventPrototype::Base);

using JSMediaQueryListEventDOMConstructor = JSDOMConstructor<JSMediaQueryListEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSMediaQueryListEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSMediaQueryListEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<MediaQueryListEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = MediaQueryListEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<MediaQueryListEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<MediaQueryListEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSMediaQueryListEventDOMConstructorConstruct, JSMediaQueryListEventDOMConstructor::construct);

template<> const ClassInfo JSMediaQueryListEventDOMConstructor::s_info = { "MediaQueryListEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaQueryListEventDOMConstructor) };

template<> JSValue JSMediaQueryListEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSMediaQueryListEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaQueryListEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaQueryListEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSMediaQueryListEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaQueryListEventConstructor, 0 } },
    HashTableValue { "media"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaQueryListEvent_media, 0 } },
    HashTableValue { "matches"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaQueryListEvent_matches, 0 } },
};

const ClassInfo JSMediaQueryListEventPrototype::s_info = { "MediaQueryListEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaQueryListEventPrototype) };

void JSMediaQueryListEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaQueryListEvent::info(), JSMediaQueryListEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaQueryListEvent::s_info = { "MediaQueryListEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaQueryListEvent) };

JSMediaQueryListEvent::JSMediaQueryListEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaQueryListEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<MediaQueryListEvent> JSMediaQueryListEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, MediaQueryListEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSMediaQueryListEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaQueryListEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMediaQueryListEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaQueryListEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaQueryListEvent>(vm, globalObject);
}

JSValue JSMediaQueryListEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaQueryListEventDOMConstructor, DOMConstructorID::MediaQueryListEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaQueryListEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaQueryListEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaQueryListEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMediaQueryListEvent_mediaGetter(JSGlobalObject& lexicalGlobalObject, JSMediaQueryListEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.media())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaQueryListEvent_media, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaQueryListEvent>::get<jsMediaQueryListEvent_mediaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaQueryListEvent_matchesGetter(JSGlobalObject& lexicalGlobalObject, JSMediaQueryListEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.matches())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaQueryListEvent_matches, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaQueryListEvent>::get<jsMediaQueryListEvent_matchesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSMediaQueryListEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaQueryListEvent, UseCustomHeapCellType::No>(vm, "JSMediaQueryListEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaQueryListEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaQueryListEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaQueryListEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaQueryListEvent = std::forward<decltype(space)>(space); }
    );
}

void JSMediaQueryListEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaQueryListEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaQueryListEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19MediaQueryListEventE[]; }
#endif
template<std::same_as<MediaQueryListEvent> T>
static inline void verifyVTable(MediaQueryListEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaQueryListEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19MediaQueryListEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaQueryListEvent has subclasses. If MediaQueryListEvent has subclasses that get passed
        // to toJS() we currently require MediaQueryListEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaQueryListEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<MediaQueryListEvent>(impl.ptr());
#endif
    return createWrapper<MediaQueryListEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaQueryListEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
