/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SESSION)

#include "JSMediaSession.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaMetadata.h"
#include "JSMediaPositionState.h"
#include "JSMediaSessionAction.h"
#include "JSMediaSessionActionDetails.h"
#include "JSMediaSessionActionHandler.h"
#include "JSMediaSessionPlaybackState.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

#if ENABLE(MEDIA_SESSION_COORDINATOR)
#include "JSMediaSessionCoordinator.h"
#include "JSMediaSessionReadyState.h"
#endif

#if ENABLE(MEDIA_SESSION_PLAYLIST)
#include "JSDOMConvertSequences.h"
#include <JavaScriptCore/JSArray.h>
#endif

#if ENABLE(MEDIA_STREAM)
#include "JSDOMConvertBoolean.h"
#endif

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setActionHandler);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_callActionHandler);
static JSC_DECLARE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setPositionState);
#if ENABLE(MEDIA_STREAM)
static JSC_DECLARE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setMicrophoneActive);
#endif
#if ENABLE(MEDIA_STREAM)
static JSC_DECLARE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setCameraActive);
#endif
#if ENABLE(MEDIA_STREAM)
static JSC_DECLARE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setScreenshareActive);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaSessionConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSession_metadata);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSession_metadata);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSession_playbackState);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSession_playbackState);
#if ENABLE(MEDIA_SESSION_COORDINATOR)
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSession_coordinator);
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSession_readyState);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSession_readyState);
#endif
#if ENABLE(MEDIA_SESSION_PLAYLIST)
static JSC_DECLARE_CUSTOM_GETTER(jsMediaSession_playlist);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaSession_playlist);
#endif

class JSMediaSessionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaSessionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaSessionPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaSessionPrototype>(vm)) JSMediaSessionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaSessionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaSessionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaSessionPrototype, JSMediaSessionPrototype::Base);

using JSMediaSessionDOMConstructor = JSDOMConstructorNotConstructable<JSMediaSession>;

template<> const ClassInfo JSMediaSessionDOMConstructor::s_info = { "MediaSession"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSessionDOMConstructor) };

template<> JSValue JSMediaSessionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaSessionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaSession"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaSession::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 12> JSMediaSessionPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSessionConstructor, 0 } },
    HashTableValue { "metadata"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSession_metadata, setJSMediaSession_metadata } },
    HashTableValue { "playbackState"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSession_playbackState, setJSMediaSession_playbackState } },
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    HashTableValue { "coordinator"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSession_coordinator, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    HashTableValue { "readyState"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSession_readyState, setJSMediaSession_readyState } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_SESSION_PLAYLIST)
    HashTableValue { "playlist"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaSession_playlist, setJSMediaSession_playlist } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "setActionHandler"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSessionPrototypeFunction_setActionHandler, 2 } },
    HashTableValue { "callActionHandler"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSessionPrototypeFunction_callActionHandler, 1 } },
    HashTableValue { "setPositionState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSessionPrototypeFunction_setPositionState, 0 } },
#if ENABLE(MEDIA_STREAM)
    HashTableValue { "setMicrophoneActive"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSessionPrototypeFunction_setMicrophoneActive, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM)
    HashTableValue { "setCameraActive"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSessionPrototypeFunction_setCameraActive, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM)
    HashTableValue { "setScreenshareActive"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaSessionPrototypeFunction_setScreenshareActive, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSMediaSessionPrototype::s_info = { "MediaSession"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSessionPrototype) };

void JSMediaSessionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaSession::info(), JSMediaSessionPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(MEDIA_STREAM)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSessionCaptureToggleAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setMicrophoneActive"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_STREAM)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSessionCaptureToggleAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setCameraActive"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_STREAM)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSessionCaptureToggleAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "setScreenshareActive"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSessionCoordinatorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "coordinator"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSessionCoordinatorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "readyState"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(MEDIA_SESSION_PLAYLIST)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSessionPlaylistEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "playlist"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaSession::s_info = { "MediaSession"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSession) };

JSMediaSession::JSMediaSession(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaSession>&& impl)
    : JSDOMWrapper<MediaSession>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, MediaSession>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSMediaSession::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaSessionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSMediaSessionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaSession::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaSession>(vm, globalObject);
}

JSValue JSMediaSession::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaSessionDOMConstructor, DOMConstructorID::MediaSession>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaSession::destroy(JSC::JSCell* cell)
{
    JSMediaSession* thisObject = static_cast<JSMediaSession*>(cell);
    thisObject->JSMediaSession::~JSMediaSession();
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSessionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaSessionPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaSession::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMediaSession_metadataGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<MediaMetadata>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.metadata())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSession_metadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::get<jsMediaSession_metadataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSession_metadataSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLNullable<IDLInterface<MediaMetadata>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "MediaSession"_s, "metadata"_s, "MediaMetadata"_s); });
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMetadata(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSession_metadata, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::set<setJSMediaSession_metadataSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaSession_playbackStateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<MediaSessionPlaybackState>>(lexicalGlobalObject, throwScope, impl.playbackState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSession_playbackState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::get<jsMediaSession_playbackStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaSession_playbackStateSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<MediaSessionPlaybackState>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaybackState(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSession_playbackState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::set<setJSMediaSession_playbackStateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(MEDIA_SESSION_COORDINATOR)
static inline JSValue jsMediaSession_coordinatorGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaSessionCoordinator>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.coordinator())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSession_coordinator, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::get<jsMediaSession_coordinatorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_SESSION_COORDINATOR)
static inline JSValue jsMediaSession_readyStateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<MediaSessionReadyState>>(lexicalGlobalObject, throwScope, impl.readyState())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSession_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::get<jsMediaSession_readyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_SESSION_COORDINATOR)
static inline bool setJSMediaSession_readyStateSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<MediaSessionReadyState>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setReadyState(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSession_readyState, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::set<setJSMediaSession_readyStateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(MEDIA_SESSION_PLAYLIST)
static inline JSValue jsMediaSession_playlistGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLInterface<MediaMetadata>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.playlist())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaSession_playlist, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::get<jsMediaSession_playlistGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_SESSION_PLAYLIST)
static inline bool setJSMediaSession_playlistSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLFrozenArray<IDLInterface<MediaMetadata>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaylist(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaSession_playlist, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaSession>::set<setJSMediaSession_playlistSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsMediaSessionPrototypeFunction_setActionHandlerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSession>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto actionConversionResult = convert<IDLEnumeration<MediaSessionAction>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "action"_s, "MediaSession"_s, "setActionHandler"_s, expectedEnumerationValues<MediaSessionAction>()); });
    if (actionConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto handlerConversionResult = convert<IDLNullable<IDLCallbackFunction<JSMediaSessionActionHandler>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "handler"_s, "MediaSession"_s, "setActionHandler"_s); });
    if (handlerConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setActionHandler(actionConversionResult.releaseReturnValue(), handlerConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setActionHandler, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSession>::call<jsMediaSessionPrototypeFunction_setActionHandlerBody>(*lexicalGlobalObject, *callFrame, "setActionHandler");
}

static inline JSC::EncodedJSValue jsMediaSessionPrototypeFunction_callActionHandlerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaSession>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto actionDetailsConversionResult = convert<IDLDictionary<MediaSessionActionDetails>>(*lexicalGlobalObject, argument0.value());
    if (actionDetailsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.callActionHandler(actionDetailsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_callActionHandler, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaSession>::call<jsMediaSessionPrototypeFunction_callActionHandlerBody>(*lexicalGlobalObject, *callFrame, "callActionHandler");
}

static inline JSC::EncodedJSValue jsMediaSessionPrototypeFunction_setPositionStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSession>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto stateConversionResult = convertOptionalWithDefault<IDLNullable<IDLDictionary<MediaPositionState>>>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLNullable<IDLDictionary<MediaPositionState>>> { return typename Converter<IDLNullable<IDLDictionary<MediaPositionState>>>::ReturnType { std::nullopt }; });
    if (stateConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setPositionState(stateConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setPositionState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaSession>::call<jsMediaSessionPrototypeFunction_setPositionStateBody>(*lexicalGlobalObject, *callFrame, "setPositionState");
}

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsMediaSessionPrototypeFunction_setMicrophoneActiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaSession>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto activeConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument0.value());
    if (activeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setMicrophoneActive(activeConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setMicrophoneActive, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaSession>::call<jsMediaSessionPrototypeFunction_setMicrophoneActiveBody>(*lexicalGlobalObject, *callFrame, "setMicrophoneActive");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsMediaSessionPrototypeFunction_setCameraActiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaSession>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto activeConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument0.value());
    if (activeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setCameraActive(activeConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setCameraActive, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaSession>::call<jsMediaSessionPrototypeFunction_setCameraActiveBody>(*lexicalGlobalObject, *callFrame, "setCameraActive");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsMediaSessionPrototypeFunction_setScreenshareActiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaSession>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto activeConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument0.value());
    if (activeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.setScreenshareActive(activeConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaSessionPrototypeFunction_setScreenshareActive, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSMediaSession>::call<jsMediaSessionPrototypeFunction_setScreenshareActiveBody>(*lexicalGlobalObject, *callFrame, "setScreenshareActive");
}

#endif

JSC::GCClient::IsoSubspace* JSMediaSession::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaSession, UseCustomHeapCellType::No>(vm, "JSMediaSession"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaSession.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaSession = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaSession.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaSession = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSMediaSession::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSMediaSession*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSMediaSession);

template<typename Visitor>
void JSMediaSession::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSMediaSession*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSMediaSession::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSMediaSession::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSMediaSession::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaSession*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaSessionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsMediaSession = jsCast<JSMediaSession*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsMediaSession->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaSessionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaSession = static_cast<JSMediaSession*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaSession->protectedWrapped().ptr(), jsMediaSession);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaSession@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12MediaSessionE[]; }
#endif
template<std::same_as<MediaSession> T>
static inline void verifyVTable(MediaSession* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaSession@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12MediaSessionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaSession has subclasses. If MediaSession has subclasses that get passed
        // to toJS() we currently require MediaSession you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaSession>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<MediaSession>(impl.ptr());
#endif
    return createWrapper<MediaSession>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaSession& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaSession* JSMediaSession::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaSession*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SESSION)
