/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsCodecState.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(WebCodecsCodecState enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("unconfigured"),
        MAKE_STATIC_STRING_IMPL("configured"),
        MAKE_STATIC_STRING_IMPL("closed"),
    };
    static_assert(static_cast<size_t>(WebCodecsCodecState::Unconfigured) == 0, "WebCodecsCodecState::Unconfigured is not 0 as expected");
    static_assert(static_cast<size_t>(WebCodecsCodecState::Configured) == 1, "WebCodecsCodecState::Configured is not 1 as expected");
    static_assert(static_cast<size_t>(WebCodecsCodecState::Closed) == 2, "WebCodecsCodecState::Closed is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, WebCodecsCodecState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<WebCodecsCodecState> parseEnumerationFromString<WebCodecsCodecState>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, WebCodecsCodecState>, 3> mappings {
        std::pair<ComparableASCIILiteral, WebCodecsCodecState> { "closed"_s, WebCodecsCodecState::Closed },
        std::pair<ComparableASCIILiteral, WebCodecsCodecState> { "configured"_s, WebCodecsCodecState::Configured },
        std::pair<ComparableASCIILiteral, WebCodecsCodecState> { "unconfigured"_s, WebCodecsCodecState::Unconfigured },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<WebCodecsCodecState> parseEnumeration<WebCodecsCodecState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<WebCodecsCodecState>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<WebCodecsCodecState>()
{
    return "\"unconfigured\", \"configured\", \"closed\""_s;
}

} // namespace WebCore


#endif // ENABLE(WEB_CODECS)
