/*
 *  yosys -- Yosys Open SYnthesis Suite
 *
 *  Copyright (C) 2012  Claire Xenia Wolf <claire@yosyshq.com>
 *
 *  Permission to use, copy, modify, and/or distribute this software for any
 *  purpose with or without fee is hereby granted, provided that the above
 *  copyright notice and this permission notice appear in all copies.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 *  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 *  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 *  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 *  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 *  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  This is a generated file and can be overwritten by make
 */

#ifdef WITH_PYTHON
#include "kernel/celltypes.h"
#include "kernel/consteval.h"
#include "kernel/log.h"
#include "kernel/register.h"
#include "kernel/rtlil.h"
#include "kernel/sigtools.h"
#include "kernel/yosys.h"
#include "kernel/cost.h"

#include <boost/python/module.hpp>
#include <boost/python/class.hpp>
#include <boost/python/wrapper.hpp>
#include <boost/python/call.hpp>
#include <boost/python.hpp>
#include <iosfwd> // std::streamsize
#include <iostream>
#include <boost/iostreams/concepts.hpp>	// boost::iostreams::sink
#include <boost/iostreams/stream.hpp>
USING_YOSYS_NAMESPACE

namespace YOSYS_PYTHON {

	[[noreturn]] static void log_python_exception_as_error() {
		PyErr_Print();
		log_error("Python interpreter encountered an exception.\n");
	}

	struct YosysStatics{};

	struct CellType;
	struct CellTypes;
	struct ConstEval;
	struct Pass;
	struct IdString;
	struct Const;
	struct AttrObject;
	struct NamedObject;
	struct Selection;
	struct Monitor;
	struct CaseRule;
	struct SwitchRule;
	struct SyncRule;
	struct Process;
	struct SigChunk;
	struct SigBit;
	struct SigSpec;
	struct Cell;
	struct Wire;
	struct Memory;
	struct Module;
	struct Design;
	struct SigMap;

	// WRAPPED from kernel/celltypes
	struct CellType
	{
		YOSYS_NAMESPACE::CellType* ref_obj;

		YOSYS_NAMESPACE::CellType* get_cpp_obj() const
		{
			return ref_obj;
		}

		static CellType* get_py_obj(YOSYS_NAMESPACE::CellType* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("CellType does not exist.");
			}
			CellType* ret = (CellType*)malloc(sizeof(CellType));
			ret->ref_obj = ref;
			return ret;
		}

		// WRAPPED from "Auto generated default constructor" in kernel/celltypes
		CellType();

		IdString get_var_py_type();

		void set_var_py_type(IdString *rhs);

		boost::python::list get_var_py_inputs();

		void set_var_py_inputs(boost::python::list rhs);

		boost::python::list get_var_py_outputs();

		void set_var_py_outputs(boost::python::list rhs);

		bool get_var_py_is_evaluable();

		void set_var_py_is_evaluable(bool rhs);

		bool get_var_py_is_combinatorial();

		void set_var_py_is_combinatorial(bool rhs);

		bool get_var_py_is_synthesizable();

		void set_var_py_is_synthesizable(bool rhs);

		unsigned int get_hash_py()
		{
			return run_hash(get_cpp_obj()->type);
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const CellType &ref)
	{
		ostr << "CellType at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/celltypes
	struct CellTypes
	{
		YOSYS_NAMESPACE::CellTypes* ref_obj;

		YOSYS_NAMESPACE::CellTypes* get_cpp_obj() const
		{
			return ref_obj;
		}

		static CellTypes* get_py_obj(YOSYS_NAMESPACE::CellTypes* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("CellTypes does not exist.");
			}
			CellTypes* ret = (CellTypes*)malloc(sizeof(CellTypes));
			ret->ref_obj = ref;
			return ret;
		}

		// WRAPPED from "CellTypes()" in kernel/celltypes
		CellTypes();

		// WRAPPED from "CellTypes(RTLIL::Design *design)" in kernel/celltypes
		CellTypes(Design* design);

		boost::python::dict get_var_py_cell_types();

		void set_var_py_cell_types(boost::python::dict rhs);

		// WRAPPED from "void setup(RTLIL::Design *design = NULL)" in kernel/celltypes
		void setup(Design* design);

		// WRAPPED from "void setup_type(RTLIL::IdString type, const pool<RTLIL::IdString> &inputs, const pool<RTLIL::IdString> &outputs, bool is_evaluable = false, bool is_combinatorial = false, bool is_synthesizable = false)" in kernel/celltypes
		void setup_type(IdString* type, const boost::python::list inputs, const boost::python::list outputs);

		// WRAPPED from "void setup_type(RTLIL::IdString type, const pool<RTLIL::IdString> &inputs, const pool<RTLIL::IdString> &outputs, bool is_evaluable = false, bool is_combinatorial = false, bool is_synthesizable = false)" in kernel/celltypes
		void setup_type(IdString* type, const boost::python::list inputs, const boost::python::list outputs, bool is_evaluable);

		// WRAPPED from "void setup_type(RTLIL::IdString type, const pool<RTLIL::IdString> &inputs, const pool<RTLIL::IdString> &outputs, bool is_evaluable = false, bool is_combinatorial = false, bool is_synthesizable = false)" in kernel/celltypes
		void setup_type(IdString* type, const boost::python::list inputs, const boost::python::list outputs, bool is_evaluable, bool is_combinatorial);

		// WRAPPED from "void setup_type(RTLIL::IdString type, const pool<RTLIL::IdString> &inputs, const pool<RTLIL::IdString> &outputs, bool is_evaluable = false, bool is_combinatorial = false, bool is_synthesizable = false)" in kernel/celltypes
		void setup_type(IdString* type, const boost::python::list inputs, const boost::python::list outputs, bool is_evaluable, bool is_combinatorial, bool is_synthesizable);

		// WRAPPED from "void setup_module(RTLIL::Module *module)" in kernel/celltypes
		void setup_module(Module* module);

		// WRAPPED from "void setup_design(RTLIL::Design *design)" in kernel/celltypes
		void setup_design(Design* design);

		// WRAPPED from "void setup_internals()" in kernel/celltypes
		void setup_internals();

		// WRAPPED from "void setup_internals_eval()" in kernel/celltypes
		void setup_internals_eval();

		// WRAPPED from "void setup_internals_ff()" in kernel/celltypes
		void setup_internals_ff();

		// WRAPPED from "void setup_internals_anyinit()" in kernel/celltypes
		void setup_internals_anyinit();

		// WRAPPED from "void setup_internals_mem()" in kernel/celltypes
		void setup_internals_mem();

		// WRAPPED from "void setup_stdcells()" in kernel/celltypes
		void setup_stdcells();

		// WRAPPED from "void setup_stdcells_eval()" in kernel/celltypes
		void setup_stdcells_eval();

		// WRAPPED from "void setup_stdcells_mem()" in kernel/celltypes
		void setup_stdcells_mem();

		// WRAPPED from "void clear()" in kernel/celltypes
		void clear();

		// WRAPPED from "bool cell_known(RTLIL::IdString type) const" in kernel/celltypes
		bool cell_known(IdString* type) const;

		// WRAPPED from "bool cell_output(RTLIL::IdString type, RTLIL::IdString port) const" in kernel/celltypes
		bool cell_output(IdString* type, IdString* port) const;

		// WRAPPED from "bool cell_input(RTLIL::IdString type, RTLIL::IdString port) const" in kernel/celltypes
		bool cell_input(IdString* type, IdString* port) const;

		// WRAPPED from "bool cell_evaluable(RTLIL::IdString type) const" in kernel/celltypes
		bool cell_evaluable(IdString* type) const;

		// WRAPPED from "static RTLIL::Const eval_not(RTLIL::Const v)" in kernel/celltypes
		static Const eval_not(Const* v);

		// WRAPPED from "static RTLIL::Const eval(RTLIL::IdString type, const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len, bool *errp = nullptr)" in kernel/celltypes
		static Const eval(IdString* type, const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len);

		// WRAPPED from "static RTLIL::Const eval(RTLIL::IdString type, const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len, bool *errp = nullptr)" in kernel/celltypes
		static Const eval(IdString* type, const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len, bool errp);

		// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool *errp = nullptr)" in kernel/celltypes
		static Const eval(Cell* cell, const Const* arg1, const Const* arg2);

		// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool *errp = nullptr)" in kernel/celltypes
		static Const eval(Cell* cell, const Const* arg1, const Const* arg2, bool errp);

		// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3, bool *errp = nullptr)" in kernel/celltypes
		static Const eval(Cell* cell, const Const* arg1, const Const* arg2, const Const* arg3);

		// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3, bool *errp = nullptr)" in kernel/celltypes
		static Const eval(Cell* cell, const Const* arg1, const Const* arg2, const Const* arg3, bool errp);

		// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3, const RTLIL::Const &arg4, bool *errp = nullptr)" in kernel/celltypes
		static Const eval(Cell* cell, const Const* arg1, const Const* arg2, const Const* arg3, const Const* arg4);

		// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3, const RTLIL::Const &arg4, bool *errp = nullptr)" in kernel/celltypes
		static Const eval(Cell* cell, const Const* arg1, const Const* arg2, const Const* arg3, const Const* arg4, bool errp);

	};

	std::ostream &operator<<(std::ostream &ostr, const CellTypes &ref)
	{
		ostr << "CellTypes at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/consteval
	struct ConstEval
	{
		YOSYS_NAMESPACE::ConstEval* ref_obj;

		YOSYS_NAMESPACE::ConstEval* get_cpp_obj() const
		{
			return ref_obj;
		}

		static ConstEval* get_py_obj(YOSYS_NAMESPACE::ConstEval* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("ConstEval does not exist.");
			}
			ConstEval* ret = (ConstEval*)malloc(sizeof(ConstEval));
			ret->ref_obj = ref;
			return ret;
		}

		// WRAPPED from "ConstEval(RTLIL::Module *module, RTLIL::State defaultval = RTLIL::State::Sm) : module(module), assign_map(module), defaultval(defaultval)" in kernel/consteval
		ConstEval(Module* module, State defaultval);

		Module get_var_py_module();

		void set_var_py_module(Module *rhs);

		SigMap get_var_py_assign_map();

		void set_var_py_assign_map(SigMap *rhs);

		SigMap get_var_py_values_map();

		void set_var_py_values_map(SigMap *rhs);

		boost::python::list get_var_py_busy();

		void set_var_py_busy(boost::python::list rhs);

		boost::python::list get_var_py_stack();

		void set_var_py_stack(boost::python::list rhs);

		YOSYS_NAMESPACE::RTLIL::State get_var_py_defaultval();

		void set_var_py_defaultval(YOSYS_NAMESPACE::RTLIL::State rhs);

		// WRAPPED from "void clear()" in kernel/consteval
		void clear();

		// WRAPPED from "void push()" in kernel/consteval
		void push();

		// WRAPPED from "void pop()" in kernel/consteval
		void pop();

		// WRAPPED from "void set(RTLIL::SigSpec sig, RTLIL::Const value)" in kernel/consteval
		void set(SigSpec* sig, Const* value);

		// WRAPPED from "void stop(RTLIL::SigSpec sig)" in kernel/consteval
		void stop(SigSpec* sig);

		// WRAPPED from "bool eval(RTLIL::Cell *cell, RTLIL::SigSpec &undef)" in kernel/consteval
		bool eval(Cell* cell, SigSpec* undef);

		// WRAPPED from "bool eval(RTLIL::SigSpec &sig, RTLIL::SigSpec &undef, RTLIL::Cell *busy_cell = NULL)" in kernel/consteval
		bool eval(SigSpec* sig, SigSpec* undef, Cell* busy_cell);

		// WRAPPED from "bool eval(RTLIL::SigSpec &sig)" in kernel/consteval
		bool eval(SigSpec* sig);

	};

	std::ostream &operator<<(std::ostream &ostr, const ConstEval &ref)
	{
		ostr << "ConstEval at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/register
	struct Pass : public YOSYS_NAMESPACE::Pass
	{

		YOSYS_NAMESPACE::Pass* get_cpp_obj() const
		{
			return (YOSYS_NAMESPACE::Pass*)this;
		}

		static Pass* get_py_obj(YOSYS_NAMESPACE::Pass* ref)
		{
			return (Pass*)ref;
		}

		// WRAPPED from "Pass(std::string name, std::string short_help = "** document me **");" in kernel/register
		Pass(string name, string short_help) : YOSYS_NAMESPACE::Pass(name, short_help){}

		string get_var_py_pass_name();

		void set_var_py_pass_name(string rhs);

		string get_var_py_short_help();

		void set_var_py_short_help(string rhs);

		int get_var_py_call_counter();

		void set_var_py_call_counter(int rhs);

		Pass get_var_py_next_queued_pass();

		void set_var_py_next_queued_pass(Pass *rhs);

		// WRAPPED from "virtual void help();" in kernel/register
		virtual void py_help(){}
		virtual void help() override;

		// WRAPPED from "virtual void clear_flags();" in kernel/register
		virtual void py_clear_flags(){}
		virtual void clear_flags() override;

		// WRAPPED from "virtual void execute(std::vector<std::string> args, RTLIL::Design *design) = 0;" in kernel/register
		virtual void py_execute(boost::python::list args, Design* design)
		{
			(void)args;
			(void)design;
		}

		virtual void execute(std::vector<string> args, YOSYS_NAMESPACE::RTLIL::Design *design) override;

		// WRAPPED from "void experimental() {" in kernel/register
		void experimental();

		// WRAPPED from "void cmd_log_args(const std::vector<std::string> &args);" in kernel/register
		void cmd_log_args(const boost::python::list args);

		// WRAPPED from "void cmd_error(const std::vector<std::string> &args, size_t argidx, std::string msg);" in kernel/register
		void cmd_error(const boost::python::list args, size_t argidx, string msg);

		// WRAPPED from "void extra_args(std::vector<std::string> args, size_t argidx, RTLIL::Design *design, bool select = true);" in kernel/register
		void extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design(boost::python::list args, size_t argidx, Design* design);

		// WRAPPED from "void extra_args(std::vector<std::string> args, size_t argidx, RTLIL::Design *design, bool select = true);" in kernel/register
		void extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design__bool(boost::python::list args, size_t argidx, Design* design, bool select);

		// WRAPPED from "static void call(RTLIL::Design *design, std::string command);" in kernel/register
		static void call__YOSYS_NAMESPACE_RTLIL_Design__string(Design* design, string command);

		// WRAPPED from "static void call(RTLIL::Design *design, std::vector<std::string> args);" in kernel/register
		static void call__YOSYS_NAMESPACE_RTLIL_Design__std_vector_string_(Design* design, boost::python::list args);

		// WRAPPED from "static void call_on_selection(RTLIL::Design *design, const RTLIL::Selection &selection, std::string command);" in kernel/register
		static void call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__string(Design* design, const Selection* selection, string command);

		// WRAPPED from "static void call_on_selection(RTLIL::Design *design, const RTLIL::Selection &selection, std::vector<std::string> args);" in kernel/register
		static void call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__std_vector_string_(Design* design, const Selection* selection, boost::python::list args);

		// WRAPPED from "static void call_on_module(RTLIL::Design *design, RTLIL::Module *module, std::string command);" in kernel/register
		static void call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__string(Design* design, Module* module, string command);

		// WRAPPED from "static void call_on_module(RTLIL::Design *design, RTLIL::Module *module, std::vector<std::string> args);" in kernel/register
		static void call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__std_vector_string_(Design* design, Module* module, boost::python::list args);

		// WRAPPED from "static void init_register();" in kernel/register
		static void init_register();

		// WRAPPED from "static void done_register();" in kernel/register
		static void done_register();

		// WRAPPED from "virtual void on_register();" in kernel/register
		virtual void py_on_register(){}
		virtual void on_register() override;

		// WRAPPED from "virtual void on_shutdown();" in kernel/register
		virtual void py_on_shutdown(){}
		virtual void on_shutdown() override;

		// WRAPPED from "virtual bool replace_existing_pass() const { return false; }" in kernel/register
		virtual bool py_replace_existing_pass()
		{
			return false;
		}

		virtual bool replace_existing_pass() const override;

	};

	struct PassWrap : Pass, boost::python::wrapper<Pass>
	{
		// WRAPPED from "Pass(std::string name, std::string short_help = "** document me **");" in kernel/register
		PassWrap(string name, string short_help) : Pass(name, short_help){}


		void py_help()
		{
			if (boost::python::override py_help = this->get_override("py_help")) {
				try {
					py_help();
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Pass::py_help();
			}
		}

		void default_py_help()
		{
			this->Pass::py_help();
		}

		void py_clear_flags()
		{
			if (boost::python::override py_clear_flags = this->get_override("py_clear_flags")) {
				try {
					py_clear_flags();
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Pass::py_clear_flags();
			}
		}

		void default_py_clear_flags()
		{
			this->Pass::py_clear_flags();
		}

		void py_execute(boost::python::list args, Design* design)
		{
			if (boost::python::override py_execute = this->get_override("py_execute")) {
				try {
					py_execute(args, design);
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Pass::py_execute(args, design);
			}
		}

		void default_py_execute(boost::python::list args, Design* design)
		{
			this->Pass::py_execute(args, design);
		}

		void py_on_register()
		{
			if (boost::python::override py_on_register = this->get_override("py_on_register")) {
				try {
					py_on_register();
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Pass::py_on_register();
			}
		}

		void default_py_on_register()
		{
			this->Pass::py_on_register();
		}

		void py_on_shutdown()
		{
			if (boost::python::override py_on_shutdown = this->get_override("py_on_shutdown")) {
				try {
					py_on_shutdown();
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Pass::py_on_shutdown();
			}
		}

		void default_py_on_shutdown()
		{
			this->Pass::py_on_shutdown();
		}

		bool py_replace_existing_pass()
		{
			if (boost::python::override py_replace_existing_pass = this->get_override("py_replace_existing_pass")) {
				try {
					return py_replace_existing_pass();
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				return Pass::py_replace_existing_pass();
			}
		}

		bool default_py_replace_existing_pass()
		{
			return this->Pass::py_replace_existing_pass();
		}
	};
	std::ostream &operator<<(std::ostream &ostr, const Pass &ref)
	{
		ostr << "Pass at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct IdString
	{
		YOSYS_NAMESPACE::RTLIL::IdString* ref_obj;

		YOSYS_NAMESPACE::RTLIL::IdString* get_cpp_obj() const
		{
			return ref_obj;
		}

		static IdString* get_py_obj(YOSYS_NAMESPACE::RTLIL::IdString* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("IdString does not exist.");
			}
			IdString* ret = (IdString*)malloc(sizeof(IdString));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::IdString(*ref);
			return ret;
		}

		static IdString* get_py_obj(YOSYS_NAMESPACE::RTLIL::IdString ref)
		{
			IdString* ret = (IdString*)malloc(sizeof(IdString));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::IdString(ref);
			return ret;
		}

		// WRAPPED from "inline IdString() : index_(0) { }" in kernel/rtlil
		IdString();

		// WRAPPED from "inline IdString(const char_p str) : index_(get_reference(str)) { }" in kernel/rtlil
		IdString(const char * str);

		// WRAPPED from "inline IdString(const IdString &str) : index_(get_reference(str.index_)) { }" in kernel/rtlil
		IdString(const IdString* str);

		// WRAPPED from "inline IdString(IdString &&str) : index_(str.index_) { str.index_ = 0; }" in kernel/rtlil
		IdString(IdString* str);

		// WRAPPED from "inline IdString(const std::string &str) : index_(get_reference(str.c_str())) { }" in kernel/rtlil
		IdString(const string str);

		int get_var_py_index_();

		void set_var_py_index_(int rhs);

		// WRAPPED from "static inline void xtrace_db_dump()" in kernel/rtlil
		static void xtrace_db_dump();

		// WRAPPED from "static inline void checkpoint()" in kernel/rtlil
		static void checkpoint();

		// WRAPPED from "static inline int get_reference(int idx)" in kernel/rtlil
		static int get_reference(int idx);

		// WRAPPED from "static int get_reference(const char_p p)" in kernel/rtlil
		static int get_reference(const char * p);

		// WRAPPED from "static inline void put_reference(int idx)" in kernel/rtlil
		static void put_reference(int idx);

		// WRAPPED from "static inline void free_reference(int idx)" in kernel/rtlil
		static void free_reference(int idx);

		// WRAPPED from "inline const char_p c_str() const {" in kernel/rtlil
		const char * c_str() const;

		// WRAPPED from "inline std::string str() const {" in kernel/rtlil
		string str() const;

		// WRAPPED from "inline bool operator<(const IdString &rhs) const {" in kernel/rtlil
		bool operator<(const IdString* rhs) const;

		// WRAPPED from "inline bool operator==(const IdString &rhs) const { return index_ == rhs.index_; }" in kernel/rtlil
		bool operator==(const IdString* rhs) const;

		// WRAPPED from "inline bool operator!=(const IdString &rhs) const { return index_ != rhs.index_; }" in kernel/rtlil
		bool operator!=(const IdString* rhs) const;

		// WRAPPED from "bool operator==(const std::string &rhs) const { return c_str() == rhs; }" in kernel/rtlil
		bool operator==(const string rhs) const;

		// WRAPPED from "bool operator!=(const std::string &rhs) const { return c_str() != rhs; }" in kernel/rtlil
		bool operator!=(const string rhs) const;

		// WRAPPED from "bool operator==(const char_p rhs) const { return strcmp(c_str(), rhs) == 0; }" in kernel/rtlil
		bool operator==(const char * rhs) const;

		// WRAPPED from "bool operator!=(const char_p rhs) const { return strcmp(c_str(), rhs) != 0; }" in kernel/rtlil
		bool operator!=(const char * rhs) const;

		// WRAPPED from "std::string substr(size_t pos = 0, size_t len = std::string::npos) const {" in kernel/rtlil
		string substr() const;

		// WRAPPED from "std::string substr(size_t pos = 0, size_t len = std::string::npos) const {" in kernel/rtlil
		string substr(size_t pos) const;

		// WRAPPED from "std::string substr(size_t pos = 0, size_t len = std::string::npos) const {" in kernel/rtlil
		string substr(size_t pos, size_t len) const;

		// WRAPPED from "int compare(size_t pos, size_t len, const char_p s) const {" in kernel/rtlil
		int compare(size_t pos, size_t len, const char * s) const;

		// WRAPPED from "bool begins_with(const char_p prefix) const {" in kernel/rtlil
		bool begins_with(const char * prefix) const;

		// WRAPPED from "bool ends_with(const char_p suffix) const {" in kernel/rtlil
		bool ends_with(const char * suffix) const;

		// WRAPPED from "bool contains(const char_p str) const {" in kernel/rtlil
		bool contains(const char * str) const;

		// WRAPPED from "size_t size() const {" in kernel/rtlil
		size_t size() const;

		// WRAPPED from "bool empty() const {" in kernel/rtlil
		bool empty() const;

		// WRAPPED from "void clear() {" in kernel/rtlil
		void clear();

		// WRAPPED from "bool in(const IdString &rhs) const { return *this == rhs; }" in kernel/rtlil
		bool in_(const IdString* rhs) const;

		// WRAPPED from "bool in(const char_p rhs) const { return *this == rhs; }" in kernel/rtlil
		bool in_(const char * rhs) const;

		// WRAPPED from "bool in(const std::string &rhs) const { return *this == rhs; }" in kernel/rtlil
		bool in_(const string rhs) const;

		// WRAPPED from "inline bool in(const pool<IdString> &rhs) const;" in kernel/rtlil
		bool in_(const boost::python::list rhs);

		// WRAPPED from "bool isPublic() const { return begins_with("\\"); }" in kernel/rtlil
		bool isPublic() const;

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const IdString &ref)
	{
		ostr << "IdString \"" << ref.get_cpp_obj()->str() << "\"";
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Const
	{
		YOSYS_NAMESPACE::RTLIL::Const* ref_obj;

		YOSYS_NAMESPACE::RTLIL::Const* get_cpp_obj() const
		{
			return ref_obj;
		}

		static Const* get_py_obj(YOSYS_NAMESPACE::RTLIL::Const* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("Const does not exist.");
			}
			Const* ret = (Const*)malloc(sizeof(Const));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::Const(*ref);
			return ret;
		}

		static Const* get_py_obj(YOSYS_NAMESPACE::RTLIL::Const ref)
		{
			Const* ret = (Const*)malloc(sizeof(Const));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::Const(ref);
			return ret;
		}

		// WRAPPED from "Const() : flags(RTLIL::CONST_FLAG_NONE), tag(backing_tag::bits), bits_(std::vector<RTLIL::State>()) {}" in kernel/rtlil
		Const();

		// WRAPPED from "Const(const std::string &str);" in kernel/rtlil
		Const(const string str);

		// WRAPPED from "Const(RTLIL::State bit, int width = 1);" in kernel/rtlil
		Const(State bit, int width);

		// WRAPPED from "Const(const std::vector<RTLIL::State> &bits) : flags(RTLIL::CONST_FLAG_NONE), tag(backing_tag::bits), bits_(bits) {}" in kernel/rtlil
		Const(const boost::python::list bits);

		// WRAPPED from "Const(const RTLIL::Const &other);" in kernel/rtlil
		Const(const Const* other);

		// WRAPPED from "Const(RTLIL::Const &&other);" in kernel/rtlil
		Const(Const* other);

		short int get_var_py_flags();

		void set_var_py_flags(short int rhs);

		// WRAPPED from "bool operator <(const RTLIL::Const &other) const;" in kernel/rtlil
		bool operator<(const Const* other);

		// WRAPPED from "bool operator ==(const RTLIL::Const &other) const;" in kernel/rtlil
		bool operator==(const Const* other);

		// WRAPPED from "bool operator !=(const RTLIL::Const &other) const;" in kernel/rtlil
		bool operator!=(const Const* other);

		// WRAPPED from "std::vector<RTLIL::State>& bits();" in kernel/rtlil
		boost::python::list bits();

		// WRAPPED from "bool as_bool() const;" in kernel/rtlil
		bool as_bool();

		// WRAPPED from "int as_int(bool is_signed = false) const;" in kernel/rtlil
		int as_int();

		// WRAPPED from "int as_int(bool is_signed = false) const;" in kernel/rtlil
		int as_int(bool is_signed);

		// WRAPPED from "bool convertible_to_int(bool is_signed = false) const;" in kernel/rtlil
		bool convertible_to_int();

		// WRAPPED from "bool convertible_to_int(bool is_signed = false) const;" in kernel/rtlil
		bool convertible_to_int(bool is_signed);

		// WRAPPED from "int as_int_saturating(bool is_signed = false) const;" in kernel/rtlil
		int as_int_saturating();

		// WRAPPED from "int as_int_saturating(bool is_signed = false) const;" in kernel/rtlil
		int as_int_saturating(bool is_signed);

		// WRAPPED from "std::string as_string(const char_p any = "-") const;" in kernel/rtlil
		string as_string(const char * any);

		// WRAPPED from "static Const from_string(const std::string &str);" in kernel/rtlil
		static Const from_string(const string str);

		// WRAPPED from "std::vector<RTLIL::State> to_bits() const;" in kernel/rtlil
		boost::python::list to_bits();

		// WRAPPED from "std::string decode_string() const;" in kernel/rtlil
		string decode_string();

		// WRAPPED from "int size() const;" in kernel/rtlil
		int size();

		// WRAPPED from "bool empty() const;" in kernel/rtlil
		bool empty();

		// WRAPPED from "void bitvectorize() const;" in kernel/rtlil
		void bitvectorize();

		// WRAPPED from "void append(const RTLIL::Const &other);" in kernel/rtlil
		void append(const Const* other);

		// WRAPPED from "State back() const {" in kernel/rtlil
		YOSYS_NAMESPACE::RTLIL::State back() const;

		// WRAPPED from "State front() const {" in kernel/rtlil
		YOSYS_NAMESPACE::RTLIL::State front() const;

		// WRAPPED from "State at(size_t i) const {" in kernel/rtlil
		YOSYS_NAMESPACE::RTLIL::State at(size_t i) const;

		// WRAPPED from "bool is_fully_zero() const;" in kernel/rtlil
		bool is_fully_zero();

		// WRAPPED from "bool is_fully_ones() const;" in kernel/rtlil
		bool is_fully_ones();

		// WRAPPED from "bool is_fully_def() const;" in kernel/rtlil
		bool is_fully_def();

		// WRAPPED from "bool is_fully_undef() const;" in kernel/rtlil
		bool is_fully_undef();

		// WRAPPED from "bool is_fully_undef_x_only() const;" in kernel/rtlil
		bool is_fully_undef_x_only();

		// WRAPPED from "bool is_onehot(int *pos = nullptr) const;" in kernel/rtlil
		bool is_onehot();

		// WRAPPED from "bool is_onehot(int *pos = nullptr) const;" in kernel/rtlil
		bool is_onehot(int pos);

		// WRAPPED from "RTLIL::Const extract(int offset, int len = 1, RTLIL::State padding = RTLIL::State::S0) const;" in kernel/rtlil
		Const extract(int offset);

		// WRAPPED from "RTLIL::Const extract(int offset, int len = 1, RTLIL::State padding = RTLIL::State::S0) const;" in kernel/rtlil
		Const extract(int offset, int len);

		// WRAPPED from "RTLIL::Const extract(int offset, int len = 1, RTLIL::State padding = RTLIL::State::S0) const;" in kernel/rtlil
		Const extract(int offset, int len, State padding);

		// WRAPPED from "int get_min_size(bool is_signed) const;" in kernel/rtlil
		int get_min_size(bool is_signed);

		// WRAPPED from "void compress(bool is_signed = false);" in kernel/rtlil
		void compress();

		// WRAPPED from "void compress(bool is_signed = false);" in kernel/rtlil
		void compress(bool is_signed);

		// WRAPPED from "void extu(int width) {" in kernel/rtlil
		void extu(int width);

		// WRAPPED from "void exts(int width) {" in kernel/rtlil
		void exts(int width);

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const Const &ref)
	{
		ostr << "Const \"" << ref.get_cpp_obj()->as_string() << "\"";
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct AttrObject
	{
		YOSYS_NAMESPACE::RTLIL::AttrObject* ref_obj;

		YOSYS_NAMESPACE::RTLIL::AttrObject* get_cpp_obj() const
		{
			return ref_obj;
		}

		static AttrObject* get_py_obj(YOSYS_NAMESPACE::RTLIL::AttrObject* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("AttrObject does not exist.");
			}
			AttrObject* ret = (AttrObject*)malloc(sizeof(AttrObject));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::AttrObject(*ref);
			return ret;
		}

		static AttrObject* get_py_obj(YOSYS_NAMESPACE::RTLIL::AttrObject ref)
		{
			AttrObject* ret = (AttrObject*)malloc(sizeof(AttrObject));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::AttrObject(ref);
			return ret;
		}

		// WRAPPED from "Auto generated default constructor" in kernel/rtlil
		AttrObject();

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

	};

	std::ostream &operator<<(std::ostream &ostr, const AttrObject &ref)
	{
		ostr << "AttrObject at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct NamedObject
	{
		YOSYS_NAMESPACE::RTLIL::NamedObject* ref_obj;

		YOSYS_NAMESPACE::RTLIL::NamedObject* get_cpp_obj() const
		{
			return ref_obj;
		}

		static NamedObject* get_py_obj(YOSYS_NAMESPACE::RTLIL::NamedObject* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("NamedObject does not exist.");
			}
			NamedObject* ret = (NamedObject*)malloc(sizeof(NamedObject));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::NamedObject(*ref);
			return ret;
		}

		static NamedObject* get_py_obj(YOSYS_NAMESPACE::RTLIL::NamedObject ref)
		{
			NamedObject* ret = (NamedObject*)malloc(sizeof(NamedObject));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::NamedObject(ref);
			return ret;
		}

		// WRAPPED from "Auto generated default constructor" in kernel/rtlil
		NamedObject();

		virtual ~NamedObject() { };
		IdString get_var_py_name();

		void set_var_py_name(IdString *rhs);

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

	};

	std::ostream &operator<<(std::ostream &ostr, const NamedObject &ref)
	{
		ostr << "NamedObject at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Selection
	{
		YOSYS_NAMESPACE::RTLIL::Selection* ref_obj;

		YOSYS_NAMESPACE::RTLIL::Selection* get_cpp_obj() const
		{
			return ref_obj;
		}

		static Selection* get_py_obj(YOSYS_NAMESPACE::RTLIL::Selection* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("Selection does not exist.");
			}
			Selection* ret = (Selection*)malloc(sizeof(Selection));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::Selection(*ref);
			return ret;
		}

		static Selection* get_py_obj(YOSYS_NAMESPACE::RTLIL::Selection ref)
		{
			Selection* ret = (Selection*)malloc(sizeof(Selection));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::Selection(ref);
			return ret;
		}

		// WRAPPED from "Selection( bool full = true, bool boxes = false, RTLIL::Design *design = nullptr ) :" in kernel/rtlil
		Selection(bool full, bool boxes, Design* design);

		bool get_var_py_selects_boxes();

		void set_var_py_selects_boxes(bool rhs);

		bool get_var_py_complete_selection();

		void set_var_py_complete_selection(bool rhs);

		bool get_var_py_full_selection();

		void set_var_py_full_selection(bool rhs);

		boost::python::list get_var_py_selected_modules();

		void set_var_py_selected_modules(boost::python::list rhs);

		boost::python::dict get_var_py_selected_members();

		void set_var_py_selected_members(boost::python::dict rhs);

		Design get_var_py_current_design();

		void set_var_py_current_design(Design *rhs);

		// WRAPPED from "bool boxed_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
		bool boxed_module(const IdString* mod_name);

		// WRAPPED from "bool selected_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
		bool selected_module(const IdString* mod_name);

		// WRAPPED from "bool selected_whole_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
		bool selected_whole_module(const IdString* mod_name);

		// WRAPPED from "bool selected_member(const RTLIL::IdString &mod_name, const RTLIL::IdString &memb_name) const;" in kernel/rtlil
		bool selected_member(const IdString* mod_name, const IdString* memb_name);

		// WRAPPED from "void optimize(RTLIL::Design *design);" in kernel/rtlil
		void optimize(Design* design);

		// WRAPPED from "bool selects_all() const {" in kernel/rtlil
		bool selects_all() const;

		// WRAPPED from "bool empty() const {" in kernel/rtlil
		bool empty() const;

		// WRAPPED from "void clear();" in kernel/rtlil
		void clear();

		// WRAPPED from "static Selection EmptySelection(RTLIL::Design *design = nullptr) { return Selection(false, false, design); };" in kernel/rtlil
		static Selection EmptySelection();

		// WRAPPED from "static Selection EmptySelection(RTLIL::Design *design = nullptr) { return Selection(false, false, design); };" in kernel/rtlil
		static Selection EmptySelection(Design* design);

		// WRAPPED from "static Selection FullSelection(RTLIL::Design *design = nullptr) { return Selection(true, false, design); };" in kernel/rtlil
		static Selection FullSelection();

		// WRAPPED from "static Selection FullSelection(RTLIL::Design *design = nullptr) { return Selection(true, false, design); };" in kernel/rtlil
		static Selection FullSelection(Design* design);

		// WRAPPED from "static Selection CompleteSelection(RTLIL::Design *design = nullptr) { return Selection(true, true, design); };" in kernel/rtlil
		static Selection CompleteSelection();

		// WRAPPED from "static Selection CompleteSelection(RTLIL::Design *design = nullptr) { return Selection(true, true, design); };" in kernel/rtlil
		static Selection CompleteSelection(Design* design);

	};

	std::ostream &operator<<(std::ostream &ostr, const Selection &ref)
	{
		ostr << "Selection at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Monitor : public YOSYS_NAMESPACE::RTLIL::Monitor
	{

		YOSYS_NAMESPACE::RTLIL::Monitor* get_cpp_obj() const
		{
			return (YOSYS_NAMESPACE::RTLIL::Monitor*)this;
		}

		static Monitor* get_py_obj(YOSYS_NAMESPACE::RTLIL::Monitor* ref)
		{
			return (Monitor*)ref;
		}

		// WRAPPED from "Monitor() { static unsigned int hashidx_count = 123456789;" in kernel/rtlil
		Monitor(){}
		// WRAPPED from "virtual void notify_module_add(RTLIL::Module*) { }" in kernel/rtlil
		virtual void py_notify_module_add(Module* gen_varname_0)
		{
			(void)gen_varname_0;
		}

		virtual void notify_module_add(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_0) override;

		// WRAPPED from "virtual void notify_module_del(RTLIL::Module*) { }" in kernel/rtlil
		virtual void py_notify_module_del(Module* gen_varname_1)
		{
			(void)gen_varname_1;
		}

		virtual void notify_module_del(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_1) override;

		// WRAPPED from "virtual void notify_connect(RTLIL::Cell*, const RTLIL::IdString&, const RTLIL::SigSpec&, const RTLIL::SigSpec&) { }" in kernel/rtlil
		virtual void py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec(Cell* gen_varname_2, const IdString* gen_varname_3, const SigSpec* gen_varname_4, const SigSpec* gen_varname_5)
		{
			(void)gen_varname_2;
			(void)gen_varname_3;
			(void)gen_varname_4;
			(void)gen_varname_5;
		}

		virtual void notify_connect(YOSYS_NAMESPACE::RTLIL::Cell *gen_varname_2, const YOSYS_NAMESPACE::RTLIL::IdString &gen_varname_3, const YOSYS_NAMESPACE::RTLIL::SigSpec &gen_varname_4, const YOSYS_NAMESPACE::RTLIL::SigSpec &gen_varname_5) override;

		// WRAPPED from "virtual void notify_connect(RTLIL::Module*, const RTLIL::SigSig&) { }" in kernel/rtlil
		virtual void py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_(Module* gen_varname_6, const boost::python::tuple gen_varname_7)
		{
			(void)gen_varname_6;
			(void)gen_varname_7;
		}

		virtual void notify_connect(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_6, const std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec> &gen_varname_7) override;

		// WRAPPED from "virtual void notify_connect(RTLIL::Module*, const std::vector<RTLIL::SigSig>&) { }" in kernel/rtlil
		virtual void py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__(Module* gen_varname_8, const boost::python::list gen_varname_9)
		{
			(void)gen_varname_8;
			(void)gen_varname_9;
		}

		virtual void notify_connect(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_8, const std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> &gen_varname_9) override;

		// WRAPPED from "virtual void notify_blackout(RTLIL::Module*) { }" in kernel/rtlil
		virtual void py_notify_blackout(Module* gen_varname_10)
		{
			(void)gen_varname_10;
		}

		virtual void notify_blackout(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_10) override;

	};

	struct MonitorWrap : Monitor, boost::python::wrapper<Monitor>
	{
		// WRAPPED from "Monitor() { static unsigned int hashidx_count = 123456789;" in kernel/rtlil
		MonitorWrap(){}

		void py_notify_module_add(Module* gen_varname_0)
		{
			if (boost::python::override py_notify_module_add = this->get_override("py_notify_module_add")) {
				try {
					py_notify_module_add(gen_varname_0);
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Monitor::py_notify_module_add(gen_varname_0);
			}
		}

		void default_py_notify_module_add(Module* gen_varname_0)
		{
			this->Monitor::py_notify_module_add(gen_varname_0);
		}

		void py_notify_module_del(Module* gen_varname_1)
		{
			if (boost::python::override py_notify_module_del = this->get_override("py_notify_module_del")) {
				try {
					py_notify_module_del(gen_varname_1);
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Monitor::py_notify_module_del(gen_varname_1);
			}
		}

		void default_py_notify_module_del(Module* gen_varname_1)
		{
			this->Monitor::py_notify_module_del(gen_varname_1);
		}

		void py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec(Cell* gen_varname_2, const IdString* gen_varname_3, const SigSpec* gen_varname_4, const SigSpec* gen_varname_5)
		{
			if (boost::python::override py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec = this->get_override("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec")) {
				try {
					py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec(gen_varname_2, gen_varname_3, gen_varname_4, gen_varname_5);
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec(gen_varname_2, gen_varname_3, gen_varname_4, gen_varname_5);
			}
		}

		void default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec(Cell* gen_varname_2, const IdString* gen_varname_3, const SigSpec* gen_varname_4, const SigSpec* gen_varname_5)
		{
			this->Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec(gen_varname_2, gen_varname_3, gen_varname_4, gen_varname_5);
		}

		void py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_(Module* gen_varname_6, const boost::python::tuple gen_varname_7)
		{
			if (boost::python::override py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_ = this->get_override("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_")) {
				try {
					py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_(gen_varname_6, gen_varname_7);
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_(gen_varname_6, gen_varname_7);
			}
		}

		void default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_(Module* gen_varname_6, const boost::python::tuple gen_varname_7)
		{
			this->Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_(gen_varname_6, gen_varname_7);
		}

		void py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__(Module* gen_varname_8, const boost::python::list gen_varname_9)
		{
			if (boost::python::override py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__ = this->get_override("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__")) {
				try {
					py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__(gen_varname_8, gen_varname_9);
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__(gen_varname_8, gen_varname_9);
			}
		}

		void default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__(Module* gen_varname_8, const boost::python::list gen_varname_9)
		{
			this->Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__(gen_varname_8, gen_varname_9);
		}

		void py_notify_blackout(Module* gen_varname_10)
		{
			if (boost::python::override py_notify_blackout = this->get_override("py_notify_blackout")) {
				try {
					py_notify_blackout(gen_varname_10);
				} catch (boost::python::error_already_set &) {
					log_python_exception_as_error();
				}
			} else {
				Monitor::py_notify_blackout(gen_varname_10);
			}
		}

		void default_py_notify_blackout(Module* gen_varname_10)
		{
			this->Monitor::py_notify_blackout(gen_varname_10);
		}
	};
	std::ostream &operator<<(std::ostream &ostr, const Monitor &ref)
	{
		ostr << "Monitor at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct CaseRule
	{
		YOSYS_NAMESPACE::RTLIL::CaseRule* ref_obj;

		YOSYS_NAMESPACE::RTLIL::CaseRule* get_cpp_obj() const
		{
			return ref_obj;
		}

		static CaseRule* get_py_obj(YOSYS_NAMESPACE::RTLIL::CaseRule* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("CaseRule does not exist.");
			}
			CaseRule* ret = (CaseRule*)malloc(sizeof(CaseRule));
			ret->ref_obj = ref->clone();
			return ret;
		}

		static CaseRule* get_py_obj(YOSYS_NAMESPACE::RTLIL::CaseRule ref)
		{
			CaseRule* ret = (CaseRule*)malloc(sizeof(CaseRule));
			ret->ref_obj = ref.clone();
			return ret;
		}

		// WRAPPED from "Auto generated default constructor" in kernel/rtlil
		CaseRule();

		virtual ~CaseRule() { };
		boost::python::list get_var_py_compare();

		void set_var_py_compare(boost::python::list rhs);

		boost::python::list get_var_py_actions();

		void set_var_py_actions(boost::python::list rhs);

		boost::python::list get_var_py_switches();

		void set_var_py_switches(boost::python::list rhs);

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "bool empty() const;" in kernel/rtlil
		bool empty();

		// WRAPPED from "RTLIL::CaseRule *clone() const;" in kernel/rtlil
		CaseRule clone();

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

	};

	std::ostream &operator<<(std::ostream &ostr, const CaseRule &ref)
	{
		ostr << "CaseRule at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct SwitchRule
	{
		YOSYS_NAMESPACE::RTLIL::SwitchRule* ref_obj;

		YOSYS_NAMESPACE::RTLIL::SwitchRule* get_cpp_obj() const
		{
			return ref_obj;
		}

		static SwitchRule* get_py_obj(YOSYS_NAMESPACE::RTLIL::SwitchRule* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("SwitchRule does not exist.");
			}
			SwitchRule* ret = (SwitchRule*)malloc(sizeof(SwitchRule));
			ret->ref_obj = ref->clone();
			return ret;
		}

		static SwitchRule* get_py_obj(YOSYS_NAMESPACE::RTLIL::SwitchRule ref)
		{
			SwitchRule* ret = (SwitchRule*)malloc(sizeof(SwitchRule));
			ret->ref_obj = ref.clone();
			return ret;
		}

		// WRAPPED from "Auto generated default constructor" in kernel/rtlil
		SwitchRule();

		virtual ~SwitchRule() { };
		SigSpec get_var_py_signal();

		void set_var_py_signal(SigSpec *rhs);

		boost::python::list get_var_py_cases();

		void set_var_py_cases(boost::python::list rhs);

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "bool empty() const;" in kernel/rtlil
		bool empty();

		// WRAPPED from "RTLIL::SwitchRule *clone() const;" in kernel/rtlil
		SwitchRule clone();

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

	};

	std::ostream &operator<<(std::ostream &ostr, const SwitchRule &ref)
	{
		ostr << "SwitchRule at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct SyncRule
	{
		YOSYS_NAMESPACE::RTLIL::SyncRule* ref_obj;

		YOSYS_NAMESPACE::RTLIL::SyncRule* get_cpp_obj() const
		{
			return ref_obj;
		}

		static SyncRule* get_py_obj(YOSYS_NAMESPACE::RTLIL::SyncRule* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("SyncRule does not exist.");
			}
			SyncRule* ret = (SyncRule*)malloc(sizeof(SyncRule));
			ret->ref_obj = ref->clone();
			return ret;
		}

		static SyncRule* get_py_obj(YOSYS_NAMESPACE::RTLIL::SyncRule ref)
		{
			SyncRule* ret = (SyncRule*)malloc(sizeof(SyncRule));
			ret->ref_obj = ref.clone();
			return ret;
		}

		// WRAPPED from "Auto generated default constructor" in kernel/rtlil
		SyncRule();

		YOSYS_NAMESPACE::RTLIL::SyncType get_var_py_type();

		void set_var_py_type(YOSYS_NAMESPACE::RTLIL::SyncType rhs);

		SigSpec get_var_py_signal();

		void set_var_py_signal(SigSpec *rhs);

		boost::python::list get_var_py_actions();

		void set_var_py_actions(boost::python::list rhs);

		// WRAPPED from "RTLIL::SyncRule *clone() const;" in kernel/rtlil
		SyncRule clone();

	};

	std::ostream &operator<<(std::ostream &ostr, const SyncRule &ref)
	{
		ostr << "SyncRule at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Process
	{
		YOSYS_NAMESPACE::RTLIL::Process* ref_obj;

		YOSYS_NAMESPACE::RTLIL::Process* get_cpp_obj() const
		{
			return ref_obj;
		}

		static Process* get_py_obj(YOSYS_NAMESPACE::RTLIL::Process* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("Process does not exist.");
			}
			Process* ret = (Process*)malloc(sizeof(Process));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::Process(*ref);
			return ret;
		}

		static Process* get_py_obj(YOSYS_NAMESPACE::RTLIL::Process ref)
		{
			Process* ret = (Process*)malloc(sizeof(Process));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::Process(ref);
			return ret;
		}

		virtual ~Process() { };
		Module get_var_py_module();

		void set_var_py_module(Module *rhs);

		CaseRule get_var_py_root_case();

		void set_var_py_root_case(CaseRule *rhs);

		boost::python::list get_var_py_syncs();

		void set_var_py_syncs(boost::python::list rhs);

		IdString get_var_py_name();

		void set_var_py_name(IdString *rhs);

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "RTLIL::Process *clone() const;" in kernel/rtlil
		Process clone();

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

		unsigned int get_hash_py()
		{
			return run_hash(get_cpp_obj()->name);
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const Process &ref)
	{
		ostr << "Process \"" << ref.get_cpp_obj()->name.c_str() << "\"";
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct SigChunk
	{
		YOSYS_NAMESPACE::RTLIL::SigChunk* ref_obj;

		YOSYS_NAMESPACE::RTLIL::SigChunk* get_cpp_obj() const
		{
			return ref_obj;
		}

		static SigChunk* get_py_obj(YOSYS_NAMESPACE::RTLIL::SigChunk* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("SigChunk does not exist.");
			}
			SigChunk* ret = (SigChunk*)malloc(sizeof(SigChunk));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(*ref);
			return ret;
		}

		static SigChunk* get_py_obj(YOSYS_NAMESPACE::RTLIL::SigChunk ref)
		{
			SigChunk* ret = (SigChunk*)malloc(sizeof(SigChunk));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(ref);
			return ret;
		}

		// WRAPPED from "SigChunk() : wire(nullptr), width(0), offset(0) {}" in kernel/rtlil
		SigChunk();

		// WRAPPED from "SigChunk(const RTLIL::Const &value) : wire(nullptr), data(value.to_bits()), width(GetSize(data)), offset(0) {}" in kernel/rtlil
		SigChunk(const Const* value);

		// WRAPPED from "SigChunk(RTLIL::Const &&value) : wire(nullptr), data(value.to_bits()), width(GetSize(data)), offset(0) {}" in kernel/rtlil
		SigChunk(Const* value);

		// WRAPPED from "SigChunk(RTLIL::Wire *wire) : wire(wire), width(GetSize(wire)), offset(0) {}" in kernel/rtlil
		SigChunk(Wire* wire);

		// WRAPPED from "SigChunk(RTLIL::Wire *wire, int offset, int width = 1) : wire(wire), width(width), offset(offset) {}" in kernel/rtlil
		SigChunk(Wire* wire, int offset, int width);

		// WRAPPED from "SigChunk(const std::string &str) : SigChunk(RTLIL::Const(str)) {}" in kernel/rtlil
		SigChunk(const string str);

		// WRAPPED from "SigChunk(int val, int width = 32) : SigChunk(RTLIL::Const(val, width)) {}" in kernel/rtlil
		SigChunk(int val, int width);

		// WRAPPED from "SigChunk(RTLIL::State bit, int width = 1) : SigChunk(RTLIL::Const(bit, width)) {}" in kernel/rtlil
		SigChunk(State bit, int width);

		// WRAPPED from "SigChunk(const RTLIL::SigBit &bit);" in kernel/rtlil
		SigChunk(const SigBit* bit);

		Wire get_var_py_wire();

		void set_var_py_wire(Wire *rhs);

		boost::python::list get_var_py_data();

		void set_var_py_data(boost::python::list rhs);

		int get_var_py_width();

		void set_var_py_width(int rhs);

		int get_var_py_offset();

		void set_var_py_offset(int rhs);

		// WRAPPED from "RTLIL::SigChunk extract(int offset, int length) const;" in kernel/rtlil
		SigChunk extract(int offset, int length);

		// WRAPPED from "inline int size() const { return width; }" in kernel/rtlil
		int size() const;

		// WRAPPED from "inline bool is_wire() const { return wire != NULL; }" in kernel/rtlil
		bool is_wire() const;

		// WRAPPED from "bool operator <(const RTLIL::SigChunk &other) const;" in kernel/rtlil
		bool operator<(const SigChunk* other);

		// WRAPPED from "bool operator ==(const RTLIL::SigChunk &other) const;" in kernel/rtlil
		bool operator==(const SigChunk* other);

		// WRAPPED from "bool operator !=(const RTLIL::SigChunk &other) const;" in kernel/rtlil
		bool operator!=(const SigChunk* other);

	};

	std::ostream &operator<<(std::ostream &ostr, const SigChunk &ref)
	{
		ostr << "SigChunk at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct SigBit
	{
		YOSYS_NAMESPACE::RTLIL::SigBit* ref_obj;

		YOSYS_NAMESPACE::RTLIL::SigBit* get_cpp_obj() const
		{
			return ref_obj;
		}

		static SigBit* get_py_obj(YOSYS_NAMESPACE::RTLIL::SigBit* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("SigBit does not exist.");
			}
			SigBit* ret = (SigBit*)malloc(sizeof(SigBit));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(*ref);
			return ret;
		}

		static SigBit* get_py_obj(YOSYS_NAMESPACE::RTLIL::SigBit ref)
		{
			SigBit* ret = (SigBit*)malloc(sizeof(SigBit));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(ref);
			return ret;
		}

		// WRAPPED from "SigBit();" in kernel/rtlil
		SigBit();

		// WRAPPED from "SigBit(RTLIL::State bit);" in kernel/rtlil
		SigBit(State bit);

		// WRAPPED from "SigBit(RTLIL::Wire *wire);" in kernel/rtlil
		SigBit(Wire* wire);

		// WRAPPED from "SigBit(RTLIL::Wire *wire, int offset);" in kernel/rtlil
		SigBit(Wire* wire, int offset);

		// WRAPPED from "SigBit(const RTLIL::SigChunk &chunk);" in kernel/rtlil
		SigBit(const SigChunk* chunk);

		// WRAPPED from "SigBit(const RTLIL::SigChunk &chunk, int index);" in kernel/rtlil
		SigBit(const SigChunk* chunk, int index);

		// WRAPPED from "SigBit(const RTLIL::SigSpec &sig);" in kernel/rtlil
		SigBit(const SigSpec* sig);

		// WRAPPED from "SigBit(const RTLIL::SigBit &sigbit) = default;" in kernel/rtlil
		SigBit(const SigBit* sigbit);

		Wire get_var_py_wire();

		void set_var_py_wire(Wire *rhs);

		YOSYS_NAMESPACE::RTLIL::State get_var_py_data();

		void set_var_py_data(YOSYS_NAMESPACE::RTLIL::State rhs);

		int get_var_py_offset();

		void set_var_py_offset(int rhs);

		// WRAPPED from "inline bool is_wire() const { return wire != NULL; }" in kernel/rtlil
		bool is_wire() const;

		// WRAPPED from "bool operator <(const RTLIL::SigBit &other) const;" in kernel/rtlil
		bool operator<(const SigBit* other);

		// WRAPPED from "bool operator ==(const RTLIL::SigBit &other) const;" in kernel/rtlil
		bool operator==(const SigBit* other);

		// WRAPPED from "bool operator !=(const RTLIL::SigBit &other) const;" in kernel/rtlil
		bool operator!=(const SigBit* other);

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const SigBit &ref)
	{
		ostr << "SigBit at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct SigSpec
	{
		YOSYS_NAMESPACE::RTLIL::SigSpec* ref_obj;

		YOSYS_NAMESPACE::RTLIL::SigSpec* get_cpp_obj() const
		{
			return ref_obj;
		}

		static SigSpec* get_py_obj(YOSYS_NAMESPACE::RTLIL::SigSpec* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("SigSpec does not exist.");
			}
			SigSpec* ret = (SigSpec*)malloc(sizeof(SigSpec));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(*ref);
			return ret;
		}

		static SigSpec* get_py_obj(YOSYS_NAMESPACE::RTLIL::SigSpec ref)
		{
			SigSpec* ret = (SigSpec*)malloc(sizeof(SigSpec));
			ret->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(ref);
			return ret;
		}

		// WRAPPED from "SigSpec() : width_(0), hash_(0) {}" in kernel/rtlil
		SigSpec();

		// WRAPPED from "SigSpec(const RTLIL::Const &value);" in kernel/rtlil
		SigSpec(const Const* value);

		// WRAPPED from "SigSpec(RTLIL::Const &&value);" in kernel/rtlil
		SigSpec(Const* value);

		// WRAPPED from "SigSpec(const RTLIL::SigChunk &chunk);" in kernel/rtlil
		SigSpec(const SigChunk* chunk);

		// WRAPPED from "SigSpec(RTLIL::SigChunk &&chunk);" in kernel/rtlil
		SigSpec(SigChunk* chunk);

		// WRAPPED from "SigSpec(RTLIL::Wire *wire);" in kernel/rtlil
		SigSpec(Wire* wire);

		// WRAPPED from "SigSpec(RTLIL::Wire *wire, int offset, int width = 1);" in kernel/rtlil
		SigSpec(Wire* wire, int offset, int width);

		// WRAPPED from "SigSpec(const std::string &str);" in kernel/rtlil
		SigSpec(const string str);

		// WRAPPED from "SigSpec(int val, int width = 32);" in kernel/rtlil
		SigSpec(int val, int width);

		// WRAPPED from "SigSpec(RTLIL::State bit, int width = 1);" in kernel/rtlil
		SigSpec(State bit, int width);

		// WRAPPED from "SigSpec(const RTLIL::SigBit &bit, int width = 1);" in kernel/rtlil
		SigSpec(const SigBit* bit, int width);

		// WRAPPED from "SigSpec(const std::vector<RTLIL::SigChunk> &chunks);" in kernel/rtlil
		SigSpec(const boost::python::list chunks);

		// WRAPPED from "inline const std::vector<RTLIL::SigChunk> &chunks() const { pack(); return chunks_; }" in kernel/rtlil
		boost::python::list chunks() const;

		// WRAPPED from "inline const std::vector<RTLIL::SigBit> &bits() const { inline_unpack(); return bits_; }" in kernel/rtlil
		boost::python::list bits() const;

		// WRAPPED from "inline int size() const { return width_; }" in kernel/rtlil
		int size() const;

		// WRAPPED from "inline bool empty() const { return width_ == 0; }" in kernel/rtlil
		bool empty() const;

		// WRAPPED from "void sort();" in kernel/rtlil
		void sort();

		// WRAPPED from "void sort_and_unify();" in kernel/rtlil
		void sort_and_unify();

		// WRAPPED from "void replace(const RTLIL::SigSpec &pattern, const RTLIL::SigSpec &with);" in kernel/rtlil
		void replace(const SigSpec* pattern, const SigSpec* with);

		// WRAPPED from "void replace(const RTLIL::SigSpec &pattern, const RTLIL::SigSpec &with, RTLIL::SigSpec *other) const;" in kernel/rtlil
		void replace(const SigSpec* pattern, const SigSpec* with, SigSpec* other);

		// WRAPPED from "void replace(int offset, const RTLIL::SigSpec &with);" in kernel/rtlil
		void replace(int offset, const SigSpec* with);

		// WRAPPED from "void remove(const RTLIL::SigSpec &pattern);" in kernel/rtlil
		void remove(const SigSpec* pattern);

		// WRAPPED from "void remove(const RTLIL::SigSpec &pattern, RTLIL::SigSpec *other) const;" in kernel/rtlil
		void remove(const SigSpec* pattern, SigSpec* other);

		// WRAPPED from "void remove2(const RTLIL::SigSpec &pattern, RTLIL::SigSpec *other);" in kernel/rtlil
		void remove2(const SigSpec* pattern, SigSpec* other);

		// WRAPPED from "void remove(const pool<RTLIL::SigBit> &pattern);" in kernel/rtlil
		void remove(const boost::python::list pattern);

		// WRAPPED from "void remove(const pool<RTLIL::SigBit> &pattern, RTLIL::SigSpec *other) const;" in kernel/rtlil
		void remove(const boost::python::list pattern, SigSpec* other);

		// WRAPPED from "void remove2(const pool<RTLIL::SigBit> &pattern, RTLIL::SigSpec *other);" in kernel/rtlil
		void remove2__pool_YOSYS_NAMESPACE_RTLIL_SigBit___YOSYS_NAMESPACE_RTLIL_SigSpec(const boost::python::list pattern, SigSpec* other);

		// WRAPPED from "void remove2(const std::set<RTLIL::SigBit> &pattern, RTLIL::SigSpec *other);" in kernel/rtlil
		void remove2__std_set_YOSYS_NAMESPACE_RTLIL_SigBit___YOSYS_NAMESPACE_RTLIL_SigSpec(const boost::python::list pattern, SigSpec* other);

		// WRAPPED from "void remove2(const pool<RTLIL::Wire*> &pattern, RTLIL::SigSpec *other);" in kernel/rtlil
		void remove2__pool_YOSYS_NAMESPACE_RTLIL_Wire___YOSYS_NAMESPACE_RTLIL_SigSpec(const boost::python::list pattern, SigSpec* other);

		// WRAPPED from "void remove(int offset, int length = 1);" in kernel/rtlil
		void remove(int offset);

		// WRAPPED from "void remove(int offset, int length = 1);" in kernel/rtlil
		void remove(int offset, int length);

		// WRAPPED from "void remove_const();" in kernel/rtlil
		void remove_const();

		// WRAPPED from "RTLIL::SigSpec extract(const RTLIL::SigSpec &pattern, const RTLIL::SigSpec *other = NULL) const;" in kernel/rtlil
		SigSpec extract(const SigSpec* pattern, const SigSpec* other);

		// WRAPPED from "RTLIL::SigSpec extract(const pool<RTLIL::SigBit> &pattern, const RTLIL::SigSpec *other = NULL) const;" in kernel/rtlil
		SigSpec extract(const boost::python::list pattern, const SigSpec* other);

		// WRAPPED from "RTLIL::SigSpec extract(int offset, int length = 1) const;" in kernel/rtlil
		SigSpec extract(int offset);

		// WRAPPED from "RTLIL::SigSpec extract(int offset, int length = 1) const;" in kernel/rtlil
		SigSpec extract(int offset, int length);

		// WRAPPED from "RTLIL::SigSpec extract_end(int offset) const { return extract(offset, width_ - offset); }" in kernel/rtlil
		SigSpec extract_end(int offset) const;

		// WRAPPED from "RTLIL::SigBit lsb() const { log_assert(width_); return(*this)[0]; };" in kernel/rtlil
		SigBit lsb() const;

		// WRAPPED from "RTLIL::SigBit msb() const { log_assert(width_); return(*this)[width_ - 1]; };" in kernel/rtlil
		SigBit msb() const;

		// WRAPPED from "void append(const RTLIL::SigSpec &signal);" in kernel/rtlil
		void append(const SigSpec* signal);

		// WRAPPED from "inline void append(Wire *wire) { append(RTLIL::SigSpec(wire)); }" in kernel/rtlil
		void append(Wire* wire);

		// WRAPPED from "inline void append(const RTLIL::SigChunk &chunk) { append(RTLIL::SigSpec(chunk)); }" in kernel/rtlil
		void append(const SigChunk* chunk);

		// WRAPPED from "inline void append(const RTLIL::Const &const_) { append(RTLIL::SigSpec(const_)); }" in kernel/rtlil
		void append(const Const* const_);

		// WRAPPED from "void append(const RTLIL::SigBit &bit);" in kernel/rtlil
		void append(const SigBit* bit);

		// WRAPPED from "inline void append(RTLIL::State state) { append(RTLIL::SigBit(state)); }" in kernel/rtlil
		void append(State state);

		// WRAPPED from "inline void append(bool bool_) { append(RTLIL::SigBit(bool_)); }" in kernel/rtlil
		void append(bool bool_);

		// WRAPPED from "void extend_u0(int width, bool is_signed = false);" in kernel/rtlil
		void extend_u0(int width);

		// WRAPPED from "void extend_u0(int width, bool is_signed = false);" in kernel/rtlil
		void extend_u0(int width, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec repeat(int num) const;" in kernel/rtlil
		SigSpec repeat(int num);

		// WRAPPED from "void reverse() { inline_unpack(); std::reverse(bits_.begin(), bits_.end()); }" in kernel/rtlil
		void reverse();

		// WRAPPED from "bool operator <(const RTLIL::SigSpec &other) const;" in kernel/rtlil
		bool operator<(const SigSpec* other);

		// WRAPPED from "bool operator ==(const RTLIL::SigSpec &other) const;" in kernel/rtlil
		bool operator==(const SigSpec* other);

		// WRAPPED from "inline bool operator !=(const RTLIL::SigSpec &other) const { return !(*this == other); }" in kernel/rtlil
		bool operator!=(const SigSpec* other) const;

		// WRAPPED from "bool is_wire() const;" in kernel/rtlil
		bool is_wire();

		// WRAPPED from "bool is_chunk() const;" in kernel/rtlil
		bool is_chunk();

		// WRAPPED from "inline bool is_bit() const { return width_ == 1; }" in kernel/rtlil
		bool is_bit() const;

		// WRAPPED from "bool is_fully_const() const;" in kernel/rtlil
		bool is_fully_const();

		// WRAPPED from "bool is_fully_zero() const;" in kernel/rtlil
		bool is_fully_zero();

		// WRAPPED from "bool is_fully_ones() const;" in kernel/rtlil
		bool is_fully_ones();

		// WRAPPED from "bool is_fully_def() const;" in kernel/rtlil
		bool is_fully_def();

		// WRAPPED from "bool is_fully_undef() const;" in kernel/rtlil
		bool is_fully_undef();

		// WRAPPED from "bool has_const() const;" in kernel/rtlil
		bool has_const();

		// WRAPPED from "bool has_marked_bits() const;" in kernel/rtlil
		bool has_marked_bits();

		// WRAPPED from "bool is_onehot(int *pos = nullptr) const;" in kernel/rtlil
		bool is_onehot();

		// WRAPPED from "bool is_onehot(int *pos = nullptr) const;" in kernel/rtlil
		bool is_onehot(int pos);

		// WRAPPED from "bool as_bool() const;" in kernel/rtlil
		bool as_bool();

		// WRAPPED from "int as_int(bool is_signed = false) const;" in kernel/rtlil
		int as_int();

		// WRAPPED from "int as_int(bool is_signed = false) const;" in kernel/rtlil
		int as_int(bool is_signed);

		// WRAPPED from "bool convertible_to_int(bool is_signed = false) const;" in kernel/rtlil
		bool convertible_to_int();

		// WRAPPED from "bool convertible_to_int(bool is_signed = false) const;" in kernel/rtlil
		bool convertible_to_int(bool is_signed);

		// WRAPPED from "int as_int_saturating(bool is_signed = false) const;" in kernel/rtlil
		int as_int_saturating();

		// WRAPPED from "int as_int_saturating(bool is_signed = false) const;" in kernel/rtlil
		int as_int_saturating(bool is_signed);

		// WRAPPED from "std::string as_string() const;" in kernel/rtlil
		string as_string();

		// WRAPPED from "RTLIL::Const as_const() const;" in kernel/rtlil
		Const as_const();

		// WRAPPED from "RTLIL::Wire *as_wire() const;" in kernel/rtlil
		Wire as_wire();

		// WRAPPED from "RTLIL::SigChunk as_chunk() const;" in kernel/rtlil
		SigChunk as_chunk();

		// WRAPPED from "RTLIL::SigBit as_bit() const;" in kernel/rtlil
		SigBit as_bit();

		// WRAPPED from "bool match(const char_p pattern) const;" in kernel/rtlil
		bool match(const char * pattern);

		// WRAPPED from "std::set<RTLIL::SigBit> to_sigbit_set() const;" in kernel/rtlil
		boost::python::list to_sigbit_set();

		// WRAPPED from "pool<RTLIL::SigBit> to_sigbit_pool() const;" in kernel/rtlil
		boost::python::list to_sigbit_pool();

		// WRAPPED from "std::vector<RTLIL::SigBit> to_sigbit_vector() const;" in kernel/rtlil
		boost::python::list to_sigbit_vector();

		// WRAPPED from "std::map<RTLIL::SigBit, RTLIL::SigBit> to_sigbit_map(const RTLIL::SigSpec &other) const;" in kernel/rtlil
		boost::python::dict to_sigbit_map(const SigSpec* other);

		// WRAPPED from "dict<RTLIL::SigBit, RTLIL::SigBit> to_sigbit_dict(const RTLIL::SigSpec &other) const;" in kernel/rtlil
		boost::python::dict to_sigbit_dict(const SigSpec* other);

		// WRAPPED from "static bool parse(RTLIL::SigSpec &sig, RTLIL::Module *module, std::string str);" in kernel/rtlil
		static bool parse(SigSpec* sig, Module* module, string str);

		// WRAPPED from "static bool parse_sel(RTLIL::SigSpec &sig, RTLIL::Design *design, RTLIL::Module *module, std::string str);" in kernel/rtlil
		static bool parse_sel(SigSpec* sig, Design* design, Module* module, string str);

		// WRAPPED from "static bool parse_rhs(const RTLIL::SigSpec &lhs, RTLIL::SigSpec &sig, RTLIL::Module *module, std::string str);" in kernel/rtlil
		static bool parse_rhs(const SigSpec* lhs, SigSpec* sig, Module* module, string str);

		// WRAPPED from "const RTLIL::SigBit &at(int offset, const RTLIL::SigBit &defval) { return offset < width_ ?(*this)[offset] : defval; }" in kernel/rtlil
		SigBit at(int offset, const SigBit* defval);

		// WRAPPED from "void check(Module *mod = nullptr) const;" in kernel/rtlil
		void check();

		// WRAPPED from "void check(Module *mod = nullptr) const;" in kernel/rtlil
		void check(Module* mod);

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const SigSpec &ref)
	{
		ostr << "SigSpec at " << ref.get_cpp_obj();
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Cell
	{
		YOSYS_NAMESPACE::RTLIL::Cell* ref_obj;
		unsigned int hashidx_;

		YOSYS_NAMESPACE::RTLIL::Cell* get_cpp_obj() const
		{
			YOSYS_NAMESPACE::RTLIL::Cell* ret = YOSYS_NAMESPACE::RTLIL::Cell::get_all_cells()->at(this->hashidx_);
			if(ret != NULL && ret == this->ref_obj)
				return ret;
			throw std::runtime_error("Cell's c++ object does not exist anymore.");
			return NULL;
		}

		static Cell* get_py_obj(YOSYS_NAMESPACE::RTLIL::Cell* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("Cell does not exist.");
			}
			Cell* ret = (Cell*)malloc(sizeof(Cell));
			ret->ref_obj = ref;
			ret->hashidx_ = ret->ref_obj->hashidx_;
			return ret;
		}

		virtual ~Cell() { };
		Module get_var_py_module();

		void set_var_py_module(Module *rhs);

		IdString get_var_py_type();

		void set_var_py_type(IdString *rhs);

		boost::python::dict get_var_py_connections_();

		void set_var_py_connections_(boost::python::dict rhs);

		boost::python::dict get_var_py_parameters();

		void set_var_py_parameters(boost::python::dict rhs);

		IdString get_var_py_name();

		void set_var_py_name(IdString *rhs);

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "bool hasPort(const RTLIL::IdString &portname) const;" in kernel/rtlil
		bool hasPort(const IdString* portname);

		// WRAPPED from "void unsetPort(const RTLIL::IdString &portname);" in kernel/rtlil
		void unsetPort(const IdString* portname);

		// WRAPPED from "void setPort(const RTLIL::IdString &portname, RTLIL::SigSpec signal);" in kernel/rtlil
		void setPort(const IdString* portname, SigSpec* signal);

		// WRAPPED from "const RTLIL::SigSpec &getPort(const RTLIL::IdString &portname) const;" in kernel/rtlil
		SigSpec getPort(const IdString* portname);

		// WRAPPED from "const dict<RTLIL::IdString, RTLIL::SigSpec> &connections() const;" in kernel/rtlil
		boost::python::dict connections();

		// WRAPPED from "bool known() const;" in kernel/rtlil
		bool known();

		// WRAPPED from "bool input(const RTLIL::IdString &portname) const;" in kernel/rtlil
		bool input(const IdString* portname);

		// WRAPPED from "bool output(const RTLIL::IdString &portname) const;" in kernel/rtlil
		bool output(const IdString* portname);

		// WRAPPED from "bool hasParam(const RTLIL::IdString &paramname) const;" in kernel/rtlil
		bool hasParam(const IdString* paramname);

		// WRAPPED from "void unsetParam(const RTLIL::IdString &paramname);" in kernel/rtlil
		void unsetParam(const IdString* paramname);

		// WRAPPED from "void setParam(const RTLIL::IdString &paramname, RTLIL::Const value);" in kernel/rtlil
		void setParam(const IdString* paramname, Const* value);

		// WRAPPED from "const RTLIL::Const &getParam(const RTLIL::IdString &paramname) const;" in kernel/rtlil
		Const getParam(const IdString* paramname);

		// WRAPPED from "void sort();" in kernel/rtlil
		void sort();

		// WRAPPED from "void check();" in kernel/rtlil
		void check();

		// WRAPPED from "void fixup_parameters(bool set_a_signed = false, bool set_b_signed = false);" in kernel/rtlil
		void fixup_parameters();

		// WRAPPED from "void fixup_parameters(bool set_a_signed = false, bool set_b_signed = false);" in kernel/rtlil
		void fixup_parameters(bool set_a_signed);

		// WRAPPED from "void fixup_parameters(bool set_a_signed = false, bool set_b_signed = false);" in kernel/rtlil
		void fixup_parameters(bool set_a_signed, bool set_b_signed);

		// WRAPPED from "bool has_keep_attr() const {" in kernel/rtlil
		bool has_keep_attr() const;

		// WRAPPED from "static std::map<unsigned int, RTLIL::Cell*> *get_all_cells(void);" in kernel/rtlil
		static boost::python::dict get_all_cells(void );

		// WRAPPED from "bool has_memid() const;" in kernel/rtlil
		bool has_memid();

		// WRAPPED from "bool is_mem_cell() const;" in kernel/rtlil
		bool is_mem_cell();

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const Cell &ref)
	{
		ostr << "Cell \"" << ref.get_cpp_obj()->name.c_str() << "\"";
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Wire
	{
		YOSYS_NAMESPACE::RTLIL::Wire* ref_obj;
		unsigned int hashidx_;

		YOSYS_NAMESPACE::RTLIL::Wire* get_cpp_obj() const
		{
			YOSYS_NAMESPACE::RTLIL::Wire* ret = YOSYS_NAMESPACE::RTLIL::Wire::get_all_wires()->at(this->hashidx_);
			if(ret != NULL && ret == this->ref_obj)
				return ret;
			throw std::runtime_error("Wire's c++ object does not exist anymore.");
			return NULL;
		}

		static Wire* get_py_obj(YOSYS_NAMESPACE::RTLIL::Wire* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("Wire does not exist.");
			}
			Wire* ret = (Wire*)malloc(sizeof(Wire));
			ret->ref_obj = ref;
			ret->hashidx_ = ret->ref_obj->hashidx_;
			return ret;
		}

		virtual ~Wire() { };
		Module get_var_py_module();

		void set_var_py_module(Module *rhs);

		int get_var_py_width();

		void set_var_py_width(int rhs);

		int get_var_py_start_offset();

		void set_var_py_start_offset(int rhs);

		int get_var_py_port_id();

		void set_var_py_port_id(int rhs);

		bool get_var_py_port_input();

		void set_var_py_port_input(bool rhs);

		bool get_var_py_port_output();

		void set_var_py_port_output(bool rhs);

		bool get_var_py_upto();

		void set_var_py_upto(bool rhs);

		bool get_var_py_is_signed();

		void set_var_py_is_signed(bool rhs);

		IdString get_var_py_name();

		void set_var_py_name(IdString *rhs);

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "RTLIL::Cell *driverCell() const { log_assert(driverCell_); return driverCell_; };" in kernel/rtlil
		Cell driverCell() const;

		// WRAPPED from "RTLIL::IdString driverPort() const { log_assert(driverCell_); return driverPort_; };" in kernel/rtlil
		IdString driverPort() const;

		// WRAPPED from "int from_hdl_index(int hdl_index) {" in kernel/rtlil
		int from_hdl_index(int hdl_index);

		// WRAPPED from "int to_hdl_index(int rtlil_index) {" in kernel/rtlil
		int to_hdl_index(int rtlil_index);

		// WRAPPED from "static std::map<unsigned int, RTLIL::Wire*> *get_all_wires(void);" in kernel/rtlil
		static boost::python::dict get_all_wires(void );

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const Wire &ref)
	{
		ostr << "Wire \"" << ref.get_cpp_obj()->name.c_str() << "\"";
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Memory
	{
		YOSYS_NAMESPACE::RTLIL::Memory* ref_obj;
		unsigned int hashidx_;

		YOSYS_NAMESPACE::RTLIL::Memory* get_cpp_obj() const
		{
			YOSYS_NAMESPACE::RTLIL::Memory* ret = YOSYS_NAMESPACE::RTLIL::Memory::get_all_memorys()->at(this->hashidx_);
			if(ret != NULL && ret == this->ref_obj)
				return ret;
			throw std::runtime_error("Memory's c++ object does not exist anymore.");
			return NULL;
		}

		static Memory* get_py_obj(YOSYS_NAMESPACE::RTLIL::Memory* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("Memory does not exist.");
			}
			Memory* ret = (Memory*)malloc(sizeof(Memory));
			ret->ref_obj = ref;
			ret->hashidx_ = ret->ref_obj->hashidx_;
			return ret;
		}

		// WRAPPED from "Memory();" in kernel/rtlil
		Memory();

		virtual ~Memory() { };
		int get_var_py_width();

		void set_var_py_width(int rhs);

		int get_var_py_start_offset();

		void set_var_py_start_offset(int rhs);

		int get_var_py_size();

		void set_var_py_size(int rhs);

		IdString get_var_py_name();

		void set_var_py_name(IdString *rhs);

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "static std::map<unsigned int, RTLIL::Memory*> *get_all_memorys(void);" in kernel/rtlil
		static boost::python::dict get_all_memorys(void );

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const Memory &ref)
	{
		ostr << "Memory \"" << ref.get_cpp_obj()->name.c_str() << "\"";
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Module
	{
		YOSYS_NAMESPACE::RTLIL::Module* ref_obj;
		unsigned int hashidx_;

		YOSYS_NAMESPACE::RTLIL::Module* get_cpp_obj() const
		{
			YOSYS_NAMESPACE::RTLIL::Module* ret = YOSYS_NAMESPACE::RTLIL::Module::get_all_modules()->at(this->hashidx_);
			if(ret != NULL && ret == this->ref_obj)
				return ret;
			throw std::runtime_error("Module's c++ object does not exist anymore.");
			return NULL;
		}

		static Module* get_py_obj(YOSYS_NAMESPACE::RTLIL::Module* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("Module does not exist.");
			}
			Module* ret = (Module*)malloc(sizeof(Module));
			ret->ref_obj = ref;
			ret->hashidx_ = ret->ref_obj->hashidx_;
			return ret;
		}

		// WRAPPED from "Module();" in kernel/rtlil
		Module();

		virtual ~Module() { };
		Design get_var_py_design();

		void set_var_py_design(Design *rhs);

		boost::python::list get_var_py_monitors();

		void set_var_py_monitors(boost::python::list rhs);

		int get_var_py_refcount_wires_();

		void set_var_py_refcount_wires_(int rhs);

		int get_var_py_refcount_cells_();

		void set_var_py_refcount_cells_(int rhs);

		boost::python::dict get_var_py_wires_();

		void set_var_py_wires_(boost::python::dict rhs);

		boost::python::dict get_var_py_cells_();

		void set_var_py_cells_(boost::python::dict rhs);

		boost::python::list get_var_py_connections_();

		void set_var_py_connections_(boost::python::list rhs);

		boost::python::list get_var_py_avail_parameters();

		void set_var_py_avail_parameters(boost::python::list rhs);

		boost::python::dict get_var_py_parameter_default_values();

		void set_var_py_parameter_default_values(boost::python::dict rhs);

		boost::python::dict get_var_py_memories();

		void set_var_py_memories(boost::python::dict rhs);

		boost::python::dict get_var_py_processes();

		void set_var_py_processes(boost::python::dict rhs);

		boost::python::list get_var_py_ports();

		void set_var_py_ports(boost::python::list rhs);

		IdString get_var_py_name();

		void set_var_py_name(IdString *rhs);

		boost::python::dict get_var_py_attributes();

		void set_var_py_attributes(boost::python::dict rhs);

		// WRAPPED from "virtual size_t count_id(const RTLIL::IdString& id);" in kernel/rtlil
		size_t count_id(const IdString* id);

		// WRAPPED from "virtual bool reprocess_if_necessary(RTLIL::Design *design);" in kernel/rtlil
		bool reprocess_if_necessary(Design* design);

		// WRAPPED from "virtual void sort();" in kernel/rtlil
		void sort();

		// WRAPPED from "virtual void check();" in kernel/rtlil
		void check();

		// WRAPPED from "virtual void optimize();" in kernel/rtlil
		void optimize();

		// WRAPPED from "virtual void makeblackbox();" in kernel/rtlil
		void makeblackbox();

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute() const;

		// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
		bool get_blackbox_attribute(bool ignore_wb) const;

		// WRAPPED from "void connect(const RTLIL::SigSig &conn);" in kernel/rtlil
		void connect(const boost::python::tuple conn);

		// WRAPPED from "void connect(const RTLIL::SigSpec &lhs, const RTLIL::SigSpec &rhs);" in kernel/rtlil
		void connect(const SigSpec* lhs, const SigSpec* rhs);

		// WRAPPED from "void new_connections(const std::vector<RTLIL::SigSig> &new_conn);" in kernel/rtlil
		void new_connections(const boost::python::list new_conn);

		// WRAPPED from "const std::vector<RTLIL::SigSig> &connections() const;" in kernel/rtlil
		boost::python::list connections();

		// WRAPPED from "void fixup_ports();" in kernel/rtlil
		void fixup_ports();

		// WRAPPED from "void bufNormalize();" in kernel/rtlil
		void bufNormalize();

		// WRAPPED from "void cloneInto(RTLIL::Module *new_mod) const;" in kernel/rtlil
		void cloneInto(Module* new_mod);

		// WRAPPED from "virtual RTLIL::Module *clone() const;" in kernel/rtlil
		Module clone();

		// WRAPPED from "bool has_memories() const;" in kernel/rtlil
		bool has_memories();

		// WRAPPED from "bool has_processes() const;" in kernel/rtlil
		bool has_processes();

		// WRAPPED from "bool has_memories_warn() const;" in kernel/rtlil
		bool has_memories_warn();

		// WRAPPED from "bool has_processes_warn() const;" in kernel/rtlil
		bool has_processes_warn();

		// WRAPPED from "bool is_selected() const;" in kernel/rtlil
		bool is_selected();

		// WRAPPED from "bool is_selected_whole() const;" in kernel/rtlil
		bool is_selected_whole();

		// WRAPPED from "std::vector<RTLIL::Wire*> selected_wires() const;" in kernel/rtlil
		boost::python::list selected_wires();

		// WRAPPED from "std::vector<RTLIL::Cell*> selected_cells() const;" in kernel/rtlil
		boost::python::list selected_cells();

		// WRAPPED from "std::vector<RTLIL::Memory*> selected_memories() const;" in kernel/rtlil
		boost::python::list selected_memories();

		// WRAPPED from "std::vector<RTLIL::Process*> selected_processes() const;" in kernel/rtlil
		boost::python::list selected_processes();

		// WRAPPED from "std::vector<RTLIL::NamedObject*> selected_members() const;" in kernel/rtlil
		boost::python::list selected_members();

		// WRAPPED from "RTLIL::Wire* wire(const RTLIL::IdString &id) {" in kernel/rtlil
		Wire wire(const IdString* id);

		// WRAPPED from "RTLIL::Cell* cell(const RTLIL::IdString &id) {" in kernel/rtlil
		Cell cell(const IdString* id);

		// WRAPPED from "RTLIL::ObjRange<RTLIL::Wire*> wires() { return RTLIL::ObjRange<RTLIL::Wire*>(&wires_, &refcount_wires_); }" in kernel/rtlil
		boost::python::list wires();

		// WRAPPED from "RTLIL::ObjRange<RTLIL::Cell*> cells() { return RTLIL::ObjRange<RTLIL::Cell*>(&cells_, &refcount_cells_); }" in kernel/rtlil
		boost::python::list cells();

		// WRAPPED from "void remove(const pool<RTLIL::Wire*> &wires);" in kernel/rtlil
		void remove(const boost::python::list wires);

		// WRAPPED from "void remove(RTLIL::Cell *cell);" in kernel/rtlil
		void remove(Cell* cell);

		// WRAPPED from "void remove(RTLIL::Process *process);" in kernel/rtlil
		void remove(Process* process);

		// WRAPPED from "void rename(RTLIL::Wire *wire, RTLIL::IdString new_name);" in kernel/rtlil
		void rename(Wire* wire, IdString* new_name);

		// WRAPPED from "void rename(RTLIL::Cell *cell, RTLIL::IdString new_name);" in kernel/rtlil
		void rename(Cell* cell, IdString* new_name);

		// WRAPPED from "void rename(RTLIL::IdString old_name, RTLIL::IdString new_name);" in kernel/rtlil
		void rename(IdString* old_name, IdString* new_name);

		// WRAPPED from "void swap_names(RTLIL::Wire *w1, RTLIL::Wire *w2);" in kernel/rtlil
		void swap_names(Wire* w1, Wire* w2);

		// WRAPPED from "void swap_names(RTLIL::Cell *c1, RTLIL::Cell *c2);" in kernel/rtlil
		void swap_names(Cell* c1, Cell* c2);

		// WRAPPED from "RTLIL::IdString uniquify(RTLIL::IdString name);" in kernel/rtlil
		IdString uniquify(IdString* name);

		// WRAPPED from "RTLIL::IdString uniquify(RTLIL::IdString name, int &index);" in kernel/rtlil
		IdString uniquify(IdString* name, int index);

		// WRAPPED from "RTLIL::Wire *addWire(RTLIL::IdString name, int width = 1);" in kernel/rtlil
		Wire addWire(IdString* name);

		// WRAPPED from "RTLIL::Wire *addWire(RTLIL::IdString name, int width = 1);" in kernel/rtlil
		Wire addWire(IdString* name, int width);

		// WRAPPED from "RTLIL::Wire *addWire(RTLIL::IdString name, const RTLIL::Wire *other);" in kernel/rtlil
		Wire addWire(IdString* name, const Wire* other);

		// WRAPPED from "RTLIL::Cell *addCell(RTLIL::IdString name, RTLIL::IdString type);" in kernel/rtlil
		Cell addCell(IdString* name, IdString* type);

		// WRAPPED from "RTLIL::Cell *addCell(RTLIL::IdString name, const RTLIL::Cell *other);" in kernel/rtlil
		Cell addCell(IdString* name, const Cell* other);

		// WRAPPED from "RTLIL::Memory *addMemory(RTLIL::IdString name, const RTLIL::Memory *other);" in kernel/rtlil
		Memory addMemory(IdString* name, const Memory* other);

		// WRAPPED from "RTLIL::Process *addProcess(RTLIL::IdString name);" in kernel/rtlil
		Process addProcess(IdString* name);

		// WRAPPED from "RTLIL::Process *addProcess(RTLIL::IdString name, const RTLIL::Process *other);" in kernel/rtlil
		Process addProcess(IdString* name, const Process* other);

		// WRAPPED from "RTLIL::Cell* addNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addPos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addPos(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addPos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addPos(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addPos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addPos(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addBuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addBuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addBuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addBuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addBuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addBuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addNeg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNeg(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addNeg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNeg(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addNeg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNeg(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceBool(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceBool(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addReduceBool(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addShl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addShl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addShl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addShr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addShr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addShr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addSshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addSshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addSshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addSshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addSshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addSshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addShift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addShift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addShift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addShiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addShiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addShiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addShiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addLt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addLt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addLt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addLe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addLe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addLe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addEq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addEq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addEq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addEq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addEq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addEq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addNe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addNe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addNe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addEqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addEqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addEqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addEqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addEqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addEqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addNex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addNex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addNex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addNex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addGe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addGe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addGe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addGe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addGe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addGe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addGt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addGt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addGt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addGt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addGt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addGt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addAdd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addAdd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addAdd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addAdd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addAdd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addAdd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addSub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addSub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addSub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addSub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addMul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addMul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addMul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addMul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addMul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addMul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addDiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addDiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addDiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addDiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addDiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addDiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addMod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addMod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addMod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addMod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addMod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addMod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addDivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addDivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addDivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addDivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addDivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addDivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addPow(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool a_signed = false, bool b_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addPow(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addPow(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool a_signed = false, bool b_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addPow(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool a_signed);

		// WRAPPED from "RTLIL::Cell* addPow(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool a_signed = false, bool b_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addPow(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool a_signed, bool b_signed);

		// WRAPPED from "RTLIL::Cell* addPow(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool a_signed = false, bool b_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addPow(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool a_signed, bool b_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addFa(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_c, const RTLIL::SigSpec &sig_x, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addFa(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_c, const SigSpec* sig_x, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addFa(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_c, const RTLIL::SigSpec &sig_x, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addFa(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_c, const SigSpec* sig_x, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addLogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addLogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addLogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addLogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addLogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addLogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addLogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addLogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed);

		// WRAPPED from "RTLIL::Cell* addLogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		Cell addLogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src);

		// WRAPPED from "RTLIL::Cell* addMux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addMux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addMux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addMux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addPmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addPmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addPmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addPmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addBmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addBmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addBmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addBmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addDemux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addDemux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addDemux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addDemux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addBweqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addBweqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addBweqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addBweqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addBwmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addBwmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addBwmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addBwmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addSlice(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, RTLIL::Const offset, const std::string &src = "");" in kernel/rtlil
		Cell addSlice(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, Const* offset);

		// WRAPPED from "RTLIL::Cell* addSlice(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, RTLIL::Const offset, const std::string &src = "");" in kernel/rtlil
		Cell addSlice(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, Const* offset, const string src);

		// WRAPPED from "RTLIL::Cell* addConcat(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addConcat(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addConcat(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addConcat(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addLut(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, RTLIL::Const lut, const std::string &src = "");" in kernel/rtlil
		Cell addLut(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, Const* lut);

		// WRAPPED from "RTLIL::Cell* addLut(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, RTLIL::Const lut, const std::string &src = "");" in kernel/rtlil
		Cell addLut(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, Const* lut, const string src);

		// WRAPPED from "RTLIL::Cell* addTribuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addTribuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addTribuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addTribuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addAssert(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addAssert(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en);

		// WRAPPED from "RTLIL::Cell* addAssert(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addAssert(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src);

		// WRAPPED from "RTLIL::Cell* addAssume(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addAssume(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en);

		// WRAPPED from "RTLIL::Cell* addAssume(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addAssume(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src);

		// WRAPPED from "RTLIL::Cell* addLive(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addLive(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en);

		// WRAPPED from "RTLIL::Cell* addLive(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addLive(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src);

		// WRAPPED from "RTLIL::Cell* addFair(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addFair(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en);

		// WRAPPED from "RTLIL::Cell* addFair(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addFair(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src);

		// WRAPPED from "RTLIL::Cell* addCover(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addCover(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en);

		// WRAPPED from "RTLIL::Cell* addCover(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
		Cell addCover(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src);

		// WRAPPED from "RTLIL::Cell* addEquiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addEquiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addEquiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addEquiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addSr(RTLIL::IdString name, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, const RTLIL::SigSpec &sig_q, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSr(IdString* name, const SigSpec* sig_set, const SigSpec* sig_clr, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addSr(RTLIL::IdString name, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, const RTLIL::SigSpec &sig_q, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSr(IdString* name, const SigSpec* sig_set, const SigSpec* sig_clr, const SigSpec* sig_q, bool set_polarity);

		// WRAPPED from "RTLIL::Cell* addSr(RTLIL::IdString name, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, const RTLIL::SigSpec &sig_q, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSr(IdString* name, const SigSpec* sig_set, const SigSpec* sig_clr, const SigSpec* sig_q, bool set_polarity, bool clr_polarity);

		// WRAPPED from "RTLIL::Cell* addSr(RTLIL::IdString name, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, const RTLIL::SigSpec &sig_q, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSr(IdString* name, const SigSpec* sig_set, const SigSpec* sig_clr, const SigSpec* sig_q, bool set_polarity, bool clr_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addFf(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
		Cell addFf(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addFf(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
		Cell addFf(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q, const string src);

		// WRAPPED from "RTLIL::Cell* addDff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addDff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addDffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addDffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addDffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool set_polarity);

		// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool set_polarity, bool clr_polarity);

		// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool set_polarity, bool clr_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, bool set_polarity);

		// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, bool set_polarity, bool clr_polarity);

		// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, bool set_polarity, bool clr_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addAdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value);

		// WRAPPED from "RTLIL::Cell* addAdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addAdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool arst_polarity);

		// WRAPPED from "RTLIL::Cell* addAdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool arst_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value);

		// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool en_polarity, bool arst_polarity);

		// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool en_polarity, bool arst_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addAldff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad);

		// WRAPPED from "RTLIL::Cell* addAldff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addAldff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool aload_polarity);

		// WRAPPED from "RTLIL::Cell* addAldff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool aload_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad);

		// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool en_polarity, bool aload_polarity);

		// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool en_polarity, bool aload_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addSdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value);

		// WRAPPED from "RTLIL::Cell* addSdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addSdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool srst_polarity);

		// WRAPPED from "RTLIL::Cell* addSdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool srst_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value);

		// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity, bool srst_polarity);

		// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity, bool srst_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value);

		// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity, bool srst_polarity);

		// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity, bool srst_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addDlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addDlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addAdlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value);

		// WRAPPED from "RTLIL::Cell* addAdlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addAdlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool en_polarity, bool arst_polarity);

		// WRAPPED from "RTLIL::Cell* addAdlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addAdlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool en_polarity, bool arst_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, bool set_polarity);

		// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, bool set_polarity, bool clr_polarity);

		// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, bool set_polarity, bool clr_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addBufGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addBufGate(IdString* name, const SigBit* sig_a, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addBufGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addBufGate(IdString* name, const SigBit* sig_a, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addNotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addNotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addNotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addNotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addAndGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addAndGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addAndGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addAndGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addNandGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addNandGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addNandGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addNandGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addOrGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addOrGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addOrGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addOrGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addNorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addNorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addNorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addNorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addXorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addXorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addXorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addXorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addXnorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addXnorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addXnorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addXnorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addAndnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addAndnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addAndnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addAndnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addOrnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addOrnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addOrnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addOrnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addMuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addMuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addMuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addMuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addNmuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addNmuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addNmuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addNmuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addAoi3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addAoi3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addAoi3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addAoi3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addOai3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addOai3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addOai3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addOai3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addAoi4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addAoi4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addAoi4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addAoi4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addOai4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addOai4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const SigBit* sig_y);

		// WRAPPED from "RTLIL::Cell* addOai4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addOai4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const SigBit* sig_y, const string src);

		// WRAPPED from "RTLIL::Cell* addFfGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
		Cell addFfGate(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addFfGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
		Cell addFfGate(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q, const string src);

		// WRAPPED from "RTLIL::Cell* addDffGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDffGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addDffGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addDffeGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffeGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDffeGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffeGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity);

		// WRAPPED from "RTLIL::Cell* addDffeGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffeGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addDffeGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDffeGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addDlatchGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatchGate(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addDlatchGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatchGate(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity);

		// WRAPPED from "RTLIL::Cell* addDlatchGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
		Cell addDlatchGate(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, const string src);

		// WRAPPED from "RTLIL::Cell* addAnyinit(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
		Cell addAnyinit(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q);

		// WRAPPED from "RTLIL::Cell* addAnyinit(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
		Cell addAnyinit(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q, const string src);

		// WRAPPED from "RTLIL::SigSpec Not(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Not(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec Not(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Not(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Not(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Not(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Pos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Pos(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec Pos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Pos(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Pos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Pos(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Buf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Buf(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec Buf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Buf(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Buf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Buf(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Neg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Neg(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec Neg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Neg(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Neg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Neg(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec And(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec And(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec And(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec And(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec And(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec And(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Or(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Or(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Or(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Or(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Or(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Or(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Xor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Xor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Xor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Xor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Xor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Xor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Xnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Xnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Xnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Xnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Xnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Xnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec ReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceAnd(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec ReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceAnd(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec ReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceAnd(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec ReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceOr(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec ReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceOr(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec ReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceOr(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec ReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceXor(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec ReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceXor(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec ReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceXor(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec ReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceXnor(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec ReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceXnor(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec ReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceXnor(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec ReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceBool(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec ReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceBool(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec ReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ReduceBool(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Shl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Shl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Shl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Shr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Shr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Shr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Sshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Sshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Sshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Sshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Sshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Sshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Shift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Shift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Shift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Shiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Shiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Shiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Shiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Lt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Lt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Lt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Lt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Lt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Lt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Le(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Le(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Le(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Le(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Le(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Le(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Eq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Eq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Eq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Eq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Eq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Eq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Ne(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Ne(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Ne(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Ne(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Ne(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Ne(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Eqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Eqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Eqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Eqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Eqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Eqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Nex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Nex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Nex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Nex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Nex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Nex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Ge(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Ge(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Ge(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Ge(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Ge(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Ge(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Gt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Gt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Gt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Gt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Gt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Gt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Add(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Add(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Add(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Add(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Add(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Add(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Sub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Sub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Sub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Sub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Mul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Mul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Mul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Mul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Mul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Mul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Div(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Div(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Div(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Div(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Div(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Div(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Mod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Mod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Mod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Mod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec Mod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec Mod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec DivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec DivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec DivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec DivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec DivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec DivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec ModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec ModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec ModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec ModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec LogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicNot(IdString* name, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec LogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicNot(IdString* name, const SigSpec* sig_a, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec LogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicNot(IdString* name, const SigSpec* sig_a, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec LogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec LogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec LogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec LogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec LogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed);

		// WRAPPED from "RTLIL::SigSpec LogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
		SigSpec LogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src);

		// WRAPPED from "RTLIL::SigSpec Mux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Mux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s);

		// WRAPPED from "RTLIL::SigSpec Mux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Mux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const string src);

		// WRAPPED from "RTLIL::SigSpec Pmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Pmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s);

		// WRAPPED from "RTLIL::SigSpec Pmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Pmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const string src);

		// WRAPPED from "RTLIL::SigSpec Bmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Bmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s);

		// WRAPPED from "RTLIL::SigSpec Bmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Bmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const string src);

		// WRAPPED from "RTLIL::SigSpec Demux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Demux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s);

		// WRAPPED from "RTLIL::SigSpec Demux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Demux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const string src);

		// WRAPPED from "RTLIL::SigSpec Bweqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const std::string &src = "");" in kernel/rtlil
		SigSpec Bweqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b);

		// WRAPPED from "RTLIL::SigSpec Bweqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const std::string &src = "");" in kernel/rtlil
		SigSpec Bweqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const string src);

		// WRAPPED from "RTLIL::SigSpec Bwmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Bwmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s);

		// WRAPPED from "RTLIL::SigSpec Bwmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
		SigSpec Bwmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const string src);

		// WRAPPED from "RTLIL::SigBit BufGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const std::string &src = "");" in kernel/rtlil
		SigBit BufGate(IdString* name, const SigBit* sig_a);

		// WRAPPED from "RTLIL::SigBit BufGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const std::string &src = "");" in kernel/rtlil
		SigBit BufGate(IdString* name, const SigBit* sig_a, const string src);

		// WRAPPED from "RTLIL::SigBit NotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const std::string &src = "");" in kernel/rtlil
		SigBit NotGate(IdString* name, const SigBit* sig_a);

		// WRAPPED from "RTLIL::SigBit NotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const std::string &src = "");" in kernel/rtlil
		SigBit NotGate(IdString* name, const SigBit* sig_a, const string src);

		// WRAPPED from "RTLIL::SigBit AndGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit AndGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b);

		// WRAPPED from "RTLIL::SigBit AndGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit AndGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src);

		// WRAPPED from "RTLIL::SigBit NandGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit NandGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b);

		// WRAPPED from "RTLIL::SigBit NandGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit NandGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src);

		// WRAPPED from "RTLIL::SigBit OrGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit OrGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b);

		// WRAPPED from "RTLIL::SigBit OrGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit OrGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src);

		// WRAPPED from "RTLIL::SigBit NorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit NorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b);

		// WRAPPED from "RTLIL::SigBit NorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit NorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src);

		// WRAPPED from "RTLIL::SigBit XorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit XorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b);

		// WRAPPED from "RTLIL::SigBit XorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit XorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src);

		// WRAPPED from "RTLIL::SigBit XnorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit XnorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b);

		// WRAPPED from "RTLIL::SigBit XnorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit XnorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src);

		// WRAPPED from "RTLIL::SigBit AndnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit AndnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b);

		// WRAPPED from "RTLIL::SigBit AndnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit AndnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src);

		// WRAPPED from "RTLIL::SigBit OrnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit OrnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b);

		// WRAPPED from "RTLIL::SigBit OrnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
		SigBit OrnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src);

		// WRAPPED from "RTLIL::SigBit MuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const std::string &src = "");" in kernel/rtlil
		SigBit MuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s);

		// WRAPPED from "RTLIL::SigBit MuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const std::string &src = "");" in kernel/rtlil
		SigBit MuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const string src);

		// WRAPPED from "RTLIL::SigBit NmuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const std::string &src = "");" in kernel/rtlil
		SigBit NmuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s);

		// WRAPPED from "RTLIL::SigBit NmuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const std::string &src = "");" in kernel/rtlil
		SigBit NmuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const string src);

		// WRAPPED from "RTLIL::SigBit Aoi3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const std::string &src = "");" in kernel/rtlil
		SigBit Aoi3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c);

		// WRAPPED from "RTLIL::SigBit Aoi3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const std::string &src = "");" in kernel/rtlil
		SigBit Aoi3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const string src);

		// WRAPPED from "RTLIL::SigBit Oai3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const std::string &src = "");" in kernel/rtlil
		SigBit Oai3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c);

		// WRAPPED from "RTLIL::SigBit Oai3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const std::string &src = "");" in kernel/rtlil
		SigBit Oai3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const string src);

		// WRAPPED from "RTLIL::SigBit Aoi4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const std::string &src = "");" in kernel/rtlil
		SigBit Aoi4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d);

		// WRAPPED from "RTLIL::SigBit Aoi4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const std::string &src = "");" in kernel/rtlil
		SigBit Aoi4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const string src);

		// WRAPPED from "RTLIL::SigBit Oai4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const std::string &src = "");" in kernel/rtlil
		SigBit Oai4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d);

		// WRAPPED from "RTLIL::SigBit Oai4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const std::string &src = "");" in kernel/rtlil
		SigBit Oai4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const string src);

		// WRAPPED from "RTLIL::SigSpec Anyconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Anyconst(IdString* name);

		// WRAPPED from "RTLIL::SigSpec Anyconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Anyconst(IdString* name, int width);

		// WRAPPED from "RTLIL::SigSpec Anyconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Anyconst(IdString* name, int width, const string src);

		// WRAPPED from "RTLIL::SigSpec Anyseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Anyseq(IdString* name);

		// WRAPPED from "RTLIL::SigSpec Anyseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Anyseq(IdString* name, int width);

		// WRAPPED from "RTLIL::SigSpec Anyseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Anyseq(IdString* name, int width, const string src);

		// WRAPPED from "RTLIL::SigSpec Allconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Allconst(IdString* name);

		// WRAPPED from "RTLIL::SigSpec Allconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Allconst(IdString* name, int width);

		// WRAPPED from "RTLIL::SigSpec Allconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Allconst(IdString* name, int width, const string src);

		// WRAPPED from "RTLIL::SigSpec Allseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Allseq(IdString* name);

		// WRAPPED from "RTLIL::SigSpec Allseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Allseq(IdString* name, int width);

		// WRAPPED from "RTLIL::SigSpec Allseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
		SigSpec Allseq(IdString* name, int width, const string src);

		// WRAPPED from "RTLIL::SigSpec Initstate(RTLIL::IdString name, const std::string &src = "");" in kernel/rtlil
		SigSpec Initstate(IdString* name);

		// WRAPPED from "RTLIL::SigSpec Initstate(RTLIL::IdString name, const std::string &src = "");" in kernel/rtlil
		SigSpec Initstate(IdString* name, const string src);

		// WRAPPED from "RTLIL::SigSpec SetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const std::string &src = "");" in kernel/rtlil
		SigSpec SetTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c);

		// WRAPPED from "RTLIL::SigSpec SetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const std::string &src = "");" in kernel/rtlil
		SigSpec SetTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c, const string src);

		// WRAPPED from "RTLIL::Cell* addSetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addSetTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c, const SigSpec* sig_y);

		// WRAPPED from "RTLIL::Cell* addSetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
		Cell addSetTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c, const SigSpec* sig_y, const string src);

		// WRAPPED from "RTLIL::SigSpec GetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const std::string &src = "");" in kernel/rtlil
		SigSpec GetTag(IdString* name, const string tag, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec GetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const std::string &src = "");" in kernel/rtlil
		SigSpec GetTag(IdString* name, const string tag, const SigSpec* sig_a, const string src);

		// WRAPPED from "RTLIL::Cell* addOverwriteTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const std::string &src = "");" in kernel/rtlil
		Cell addOverwriteTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c);

		// WRAPPED from "RTLIL::Cell* addOverwriteTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const std::string &src = "");" in kernel/rtlil
		Cell addOverwriteTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c, const string src);

		// WRAPPED from "RTLIL::SigSpec OriginalTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const std::string &src = "");" in kernel/rtlil
		SigSpec OriginalTag(IdString* name, const string tag, const SigSpec* sig_a);

		// WRAPPED from "RTLIL::SigSpec OriginalTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const std::string &src = "");" in kernel/rtlil
		SigSpec OriginalTag(IdString* name, const string tag, const SigSpec* sig_a, const string src);

		// WRAPPED from "RTLIL::SigSpec FutureFF(RTLIL::IdString name, const RTLIL::SigSpec &sig_e, const std::string &src = "");" in kernel/rtlil
		SigSpec FutureFF(IdString* name, const SigSpec* sig_e);

		// WRAPPED from "RTLIL::SigSpec FutureFF(RTLIL::IdString name, const RTLIL::SigSpec &sig_e, const std::string &src = "");" in kernel/rtlil
		SigSpec FutureFF(IdString* name, const SigSpec* sig_e, const string src);

		// WRAPPED from "static std::map<unsigned int, RTLIL::Module*> *get_all_modules(void);" in kernel/rtlil
		static boost::python::dict get_all_modules(void );

		// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool has_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id);

		// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
		void set_bool_attribute(const IdString* id, bool value);

		// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		bool get_bool_attribute(const IdString* id);

		// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
		void set_string_attribute(const IdString* id, string value);

		// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		string get_string_attribute(const IdString* id);

		// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void set_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
		void add_strpool_attribute(const IdString* id, const boost::python::list data);

		// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
		boost::python::list get_strpool_attribute(const IdString* id);

		// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
		void set_src_attribute(const string src);

		// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
		string get_src_attribute() const;

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const Module &ref)
	{
		ostr << "Module \"" << ref.get_cpp_obj()->name.c_str() << "\"";
		return ostr;
	}

	// WRAPPED from kernel/rtlil
	struct Design
	{
		YOSYS_NAMESPACE::RTLIL::Design* ref_obj;
		unsigned int hashidx_;

		YOSYS_NAMESPACE::RTLIL::Design* get_cpp_obj() const
		{
			YOSYS_NAMESPACE::RTLIL::Design* ret = YOSYS_NAMESPACE::RTLIL::Design::get_all_designs()->at(this->hashidx_);
			if(ret != NULL && ret == this->ref_obj)
				return ret;
			throw std::runtime_error("Design's c++ object does not exist anymore.");
			return NULL;
		}

		static Design* get_py_obj(YOSYS_NAMESPACE::RTLIL::Design* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("Design does not exist.");
			}
			Design* ret = (Design*)malloc(sizeof(Design));
			ret->ref_obj = ref;
			ret->hashidx_ = ret->ref_obj->hashidx_;
			return ret;
		}

		// WRAPPED from "Design();" in kernel/rtlil
		Design();

		boost::python::list get_var_py_monitors();

		void set_var_py_monitors(boost::python::list rhs);

		boost::python::dict get_var_py_scratchpad();

		void set_var_py_scratchpad(boost::python::dict rhs);

		int get_var_py_refcount_modules_();

		void set_var_py_refcount_modules_(int rhs);

		boost::python::dict get_var_py_modules_();

		void set_var_py_modules_(boost::python::dict rhs);

		boost::python::list get_var_py_selection_stack();

		void set_var_py_selection_stack(boost::python::list rhs);

		boost::python::dict get_var_py_selection_vars();

		void set_var_py_selection_vars(boost::python::dict rhs);

		string get_var_py_selected_active_module();

		void set_var_py_selected_active_module(string rhs);

		// WRAPPED from "void bufNormalize(bool enable=true);" in kernel/rtlil
		void bufNormalize();

		// WRAPPED from "void bufNormalize(bool enable=true);" in kernel/rtlil
		void bufNormalize(bool enable);

		// WRAPPED from "RTLIL::ObjRange<RTLIL::Module*> modules();" in kernel/rtlil
		boost::python::list modules();

		// WRAPPED from "RTLIL::Module *module(const RTLIL::IdString &name);" in kernel/rtlil
		Module module(const IdString* name);

		// WRAPPED from "RTLIL::Module *top_module() const;" in kernel/rtlil
		Module top_module();

		// WRAPPED from "bool has(const RTLIL::IdString &id) const {" in kernel/rtlil
		bool has(const IdString* id) const;

		// WRAPPED from "void add(RTLIL::Module *module);" in kernel/rtlil
		void add(Module* module);

		// WRAPPED from "RTLIL::Module *addModule(RTLIL::IdString name);" in kernel/rtlil
		Module addModule(IdString* name);

		// WRAPPED from "void remove(RTLIL::Module *module);" in kernel/rtlil
		void remove(Module* module);

		// WRAPPED from "void rename(RTLIL::Module *module, RTLIL::IdString new_name);" in kernel/rtlil
		void rename(Module* module, IdString* new_name);

		// WRAPPED from "void scratchpad_unset(const std::string &varname);" in kernel/rtlil
		void scratchpad_unset(const string varname);

		// WRAPPED from "void scratchpad_set_int(const std::string &varname, int value);" in kernel/rtlil
		void scratchpad_set_int(const string varname, int value);

		// WRAPPED from "void scratchpad_set_bool(const std::string &varname, bool value);" in kernel/rtlil
		void scratchpad_set_bool(const string varname, bool value);

		// WRAPPED from "void scratchpad_set_string(const std::string &varname, std::string value);" in kernel/rtlil
		void scratchpad_set_string(const string varname, string value);

		// WRAPPED from "int scratchpad_get_int(const std::string &varname, int default_value = 0) const;" in kernel/rtlil
		int scratchpad_get_int(const string varname);

		// WRAPPED from "int scratchpad_get_int(const std::string &varname, int default_value = 0) const;" in kernel/rtlil
		int scratchpad_get_int(const string varname, int default_value);

		// WRAPPED from "bool scratchpad_get_bool(const std::string &varname, bool default_value = false) const;" in kernel/rtlil
		bool scratchpad_get_bool(const string varname);

		// WRAPPED from "bool scratchpad_get_bool(const std::string &varname, bool default_value = false) const;" in kernel/rtlil
		bool scratchpad_get_bool(const string varname, bool default_value);

		// WRAPPED from "std::string scratchpad_get_string(const std::string &varname, const std::string &default_value = std::string()) const;" in kernel/rtlil
		string scratchpad_get_string(const string varname);

		// WRAPPED from "std::string scratchpad_get_string(const std::string &varname, const std::string &default_value = std::string()) const;" in kernel/rtlil
		string scratchpad_get_string(const string varname, const string default_value);

		// WRAPPED from "void sort();" in kernel/rtlil
		void sort();

		// WRAPPED from "void check();" in kernel/rtlil
		void check();

		// WRAPPED from "void optimize();" in kernel/rtlil
		void optimize();

		// WRAPPED from "bool selected_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
		bool selected_module(const IdString* mod_name);

		// WRAPPED from "bool selected_whole_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
		bool selected_whole_module(const IdString* mod_name);

		// WRAPPED from "bool selected_member(const RTLIL::IdString &mod_name, const RTLIL::IdString &memb_name) const;" in kernel/rtlil
		bool selected_member(const IdString* mod_name, const IdString* memb_name);

		// WRAPPED from "bool selected_module(RTLIL::Module *mod) const;" in kernel/rtlil
		bool selected_module(Module* mod);

		// WRAPPED from "bool selected_whole_module(RTLIL::Module *mod) const;" in kernel/rtlil
		bool selected_whole_module(Module* mod);

		// WRAPPED from "void push_selection(RTLIL::Selection sel);" in kernel/rtlil
		void push_selection(Selection* sel);

		// WRAPPED from "void push_empty_selection();" in kernel/rtlil
		void push_empty_selection();

		// WRAPPED from "void push_full_selection();" in kernel/rtlil
		void push_full_selection();

		// WRAPPED from "void push_complete_selection();" in kernel/rtlil
		void push_complete_selection();

		// WRAPPED from "void pop_selection();" in kernel/rtlil
		void pop_selection();

		// WRAPPED from "RTLIL::Selection &selection() {" in kernel/rtlil
		Selection selection();

		// WRAPPED from "bool full_selection() const {" in kernel/rtlil
		bool full_selection() const;

		// WRAPPED from "std::vector<RTLIL::Module*> all_selected_modules() const { return selected_modules(SELECT_ALL, SB_ALL); }" in kernel/rtlil
		boost::python::list all_selected_modules() const;

		// WRAPPED from "std::vector<RTLIL::Module*> selected_unboxed_modules() const { return selected_modules(SELECT_ALL, SB_UNBOXED_ONLY); }" in kernel/rtlil
		boost::python::list selected_unboxed_modules() const;

		// WRAPPED from "std::vector<RTLIL::Module*> selected_unboxed_modules_warn() const { return selected_modules(SELECT_ALL, SB_UNBOXED_WARN); }" in kernel/rtlil
		boost::python::list selected_unboxed_modules_warn() const;

		// WRAPPED from "std::vector<RTLIL::Module*> selected_whole_modules() const { return selected_modules(SELECT_WHOLE_ONLY, SB_UNBOXED_WARN); }" in kernel/rtlil
		boost::python::list selected_whole_modules() const;

		// WRAPPED from "std::vector<RTLIL::Module*> all_selected_whole_modules() const { return selected_modules(SELECT_WHOLE_ONLY, SB_ALL); }" in kernel/rtlil
		boost::python::list all_selected_whole_modules() const;

		// WRAPPED from "std::vector<RTLIL::Module*> selected_unboxed_whole_modules() const { return selected_modules(SELECT_WHOLE_ONLY, SB_UNBOXED_ONLY); }" in kernel/rtlil
		boost::python::list selected_unboxed_whole_modules() const;

		// WRAPPED from "std::vector<RTLIL::Module*> selected_unboxed_whole_modules_warn() const { return selected_modules(SELECT_WHOLE_WARN, SB_UNBOXED_WARN); }" in kernel/rtlil
		boost::python::list selected_unboxed_whole_modules_warn() const;

		// WRAPPED from "static std::map<unsigned int, RTLIL::Design*> *get_all_designs(void);" in kernel/rtlil
		static boost::python::dict get_all_designs(void );

		unsigned int get_hash_py()
		{
			return run_hash(*(get_cpp_obj()));
		}
	};

	std::ostream &operator<<(std::ostream &ostr, const Design &ref)
	{
		ostr << "Design \"" << ref.get_cpp_obj()->hashidx_ << "\"";
		return ostr;
	}

	// WRAPPED from kernel/sigtools
	struct SigMap
	{
		YOSYS_NAMESPACE::SigMap* ref_obj;

		YOSYS_NAMESPACE::SigMap* get_cpp_obj() const
		{
			return ref_obj;
		}

		static SigMap* get_py_obj(YOSYS_NAMESPACE::SigMap* ref)
		{
			if(ref == nullptr){
				throw std::runtime_error("SigMap does not exist.");
			}
			SigMap* ret = (SigMap*)malloc(sizeof(SigMap));
			ret->ref_obj = ref;
			return ret;
		}

		// WRAPPED from "SigMap(RTLIL::Module *module = NULL)" in kernel/sigtools
		SigMap(Module* module);

		// WRAPPED from "void swap(SigMap &other)" in kernel/sigtools
		void swap(SigMap* other);

		// WRAPPED from "void clear()" in kernel/sigtools
		void clear();

		// WRAPPED from "void set(RTLIL::Module *module)" in kernel/sigtools
		void set(Module* module);

		// WRAPPED from "void add(const RTLIL::SigSpec& from, const RTLIL::SigSpec& to)" in kernel/sigtools
		void add(const SigSpec* from, const SigSpec* to);

		// WRAPPED from "void add(const RTLIL::SigBit &bit)" in kernel/sigtools
		void add(const SigBit* bit);

		// WRAPPED from "void add(const RTLIL::SigSpec &sig)" in kernel/sigtools
		void add(const SigSpec* sig);

		// WRAPPED from "inline void add(Wire *wire) { return add(RTLIL::SigSpec(wire)); }" in kernel/sigtools
		void add(Wire* wire);

		// WRAPPED from "void apply(RTLIL::SigBit &bit) const" in kernel/sigtools
		void apply(SigBit* bit) const;

		// WRAPPED from "void apply(RTLIL::SigSpec &sig) const" in kernel/sigtools
		void apply(SigSpec* sig) const;

		// WRAPPED from "RTLIL::SigBit operator()(RTLIL::SigBit bit) const" in kernel/sigtools
		SigBit operator()(SigBit* bit) const;

		// WRAPPED from "RTLIL::SigSpec operator()(RTLIL::SigSpec sig) const" in kernel/sigtools
		SigSpec operator()(SigSpec* sig) const;

		// WRAPPED from "RTLIL::SigSpec operator()(RTLIL::Wire *wire) const" in kernel/sigtools
		SigSpec operator()(Wire* wire) const;

		// WRAPPED from "RTLIL::SigSpec allbits() const" in kernel/sigtools
		SigSpec allbits() const;

	};

	std::ostream &operator<<(std::ostream &ostr, const SigMap &ref)
	{
		ostr << "SigMap at " << ref.get_cpp_obj();
		return ostr;
	}


	// WRAPPED from "Auto generated default constructor" in kernel/celltypes
	CellType::CellType()
	{
		this->ref_obj = new YOSYS_NAMESPACE::CellType();
	}

	IdString CellType::get_var_py_type()
	{
		IdString* ret_ = IdString::get_py_obj(&this->get_cpp_obj()->type);
		return *ret_;
	}

	void CellType::set_var_py_type(IdString *rhs)
	{
		this->get_cpp_obj()->type = *rhs->get_cpp_obj();
	}

	boost::python::list CellType::get_var_py_inputs()
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> ret_ = this->get_cpp_obj()->inputs;
		boost::python::list ret____tmp;
		for(auto tmp_0 : ret_)
		{
			ret____tmp.append(*IdString::get_py_obj(&tmp_0));
		}
		return ret____tmp;
	}

	void CellType::set_var_py_inputs(boost::python::list rhs)
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> rhs___tmp;
		for(int cntr_1 = 0; cntr_1 < len(rhs); cntr_1++)
		{
			IdString* tmp_2 = boost::python::extract<IdString*>(rhs[cntr_1]);
			rhs___tmp.insert(*tmp_2->get_cpp_obj());
		}
		this->get_cpp_obj()->inputs = rhs___tmp;
	}

	boost::python::list CellType::get_var_py_outputs()
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> ret_ = this->get_cpp_obj()->outputs;
		boost::python::list ret____tmp;
		for(auto tmp_3 : ret_)
		{
			ret____tmp.append(*IdString::get_py_obj(&tmp_3));
		}
		return ret____tmp;
	}

	void CellType::set_var_py_outputs(boost::python::list rhs)
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> rhs___tmp;
		for(int cntr_4 = 0; cntr_4 < len(rhs); cntr_4++)
		{
			IdString* tmp_5 = boost::python::extract<IdString*>(rhs[cntr_4]);
			rhs___tmp.insert(*tmp_5->get_cpp_obj());
		}
		this->get_cpp_obj()->outputs = rhs___tmp;
	}

	bool CellType::get_var_py_is_evaluable()
	{
		bool ret_ = this->get_cpp_obj()->is_evaluable;
		return ret_;
	}

	void CellType::set_var_py_is_evaluable(bool rhs)
	{
		this->get_cpp_obj()->is_evaluable = rhs;
	}

	bool CellType::get_var_py_is_combinatorial()
	{
		bool ret_ = this->get_cpp_obj()->is_combinatorial;
		return ret_;
	}

	void CellType::set_var_py_is_combinatorial(bool rhs)
	{
		this->get_cpp_obj()->is_combinatorial = rhs;
	}

	bool CellType::get_var_py_is_synthesizable()
	{
		bool ret_ = this->get_cpp_obj()->is_synthesizable;
		return ret_;
	}

	void CellType::set_var_py_is_synthesizable(bool rhs)
	{
		this->get_cpp_obj()->is_synthesizable = rhs;
	}

	// WRAPPED from "CellTypes()" in kernel/celltypes
	CellTypes::CellTypes()
	{
		this->ref_obj = new YOSYS_NAMESPACE::CellTypes();
	}

	// WRAPPED from "CellTypes(RTLIL::Design *design)" in kernel/celltypes
	CellTypes::CellTypes(Design* design)
	{
		this->ref_obj = new YOSYS_NAMESPACE::CellTypes(design->get_cpp_obj());
	}

	boost::python::dict CellTypes::get_var_py_cell_types()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::CellType> ret_ = this->get_cpp_obj()->cell_types;
		boost::python::dict ret____tmp;
		for(auto tmp_6 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_6.first)] = *CellType::get_py_obj(&tmp_6.second);
		}
		return ret____tmp;
	}

	void CellTypes::set_var_py_cell_types(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::CellType> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_7 = 0; cntr_7 < len(rhs_keylist); cntr_7++)
		{
			IdString* key_tmp_8 = boost::python::extract<IdString*>(rhs_keylist[ cntr_7 ]);
			CellType* val_tmp_8 = boost::python::extract<CellType*>(rhs[rhs_keylist[ cntr_7 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::CellType>(*key_tmp_8->get_cpp_obj(), *val_tmp_8->get_cpp_obj()));

		}
		this->get_cpp_obj()->cell_types = rhs___tmp;
	}

	// WRAPPED from "void setup(RTLIL::Design *design = NULL)" in kernel/celltypes
	void CellTypes::setup(Design* design)
	{
		this->get_cpp_obj()->setup(design->get_cpp_obj());
	}

	// WRAPPED from "void setup_type(RTLIL::IdString type, const pool<RTLIL::IdString> &inputs, const pool<RTLIL::IdString> &outputs, bool is_evaluable = false, bool is_combinatorial = false, bool is_synthesizable = false)" in kernel/celltypes
	void CellTypes::setup_type(IdString* type, const boost::python::list inputs, const boost::python::list outputs)
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> inputs___tmp;
		for(int cntr_9 = 0; cntr_9 < len(inputs); cntr_9++)
		{
			IdString* tmp_10 = boost::python::extract<IdString*>(inputs[cntr_9]);
			inputs___tmp.insert(*tmp_10->get_cpp_obj());
		}
		pool<YOSYS_NAMESPACE::RTLIL::IdString> outputs___tmp;
		for(int cntr_11 = 0; cntr_11 < len(outputs); cntr_11++)
		{
			IdString* tmp_12 = boost::python::extract<IdString*>(outputs[cntr_11]);
			outputs___tmp.insert(*tmp_12->get_cpp_obj());
		}
		this->get_cpp_obj()->setup_type(*type->get_cpp_obj(), inputs___tmp, outputs___tmp);
	}

	// WRAPPED from "void setup_type(RTLIL::IdString type, const pool<RTLIL::IdString> &inputs, const pool<RTLIL::IdString> &outputs, bool is_evaluable = false, bool is_combinatorial = false, bool is_synthesizable = false)" in kernel/celltypes
	void CellTypes::setup_type(IdString* type, const boost::python::list inputs, const boost::python::list outputs, bool is_evaluable)
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> inputs___tmp;
		for(int cntr_13 = 0; cntr_13 < len(inputs); cntr_13++)
		{
			IdString* tmp_14 = boost::python::extract<IdString*>(inputs[cntr_13]);
			inputs___tmp.insert(*tmp_14->get_cpp_obj());
		}
		pool<YOSYS_NAMESPACE::RTLIL::IdString> outputs___tmp;
		for(int cntr_15 = 0; cntr_15 < len(outputs); cntr_15++)
		{
			IdString* tmp_16 = boost::python::extract<IdString*>(outputs[cntr_15]);
			outputs___tmp.insert(*tmp_16->get_cpp_obj());
		}
		this->get_cpp_obj()->setup_type(*type->get_cpp_obj(), inputs___tmp, outputs___tmp, is_evaluable);
	}

	// WRAPPED from "void setup_type(RTLIL::IdString type, const pool<RTLIL::IdString> &inputs, const pool<RTLIL::IdString> &outputs, bool is_evaluable = false, bool is_combinatorial = false, bool is_synthesizable = false)" in kernel/celltypes
	void CellTypes::setup_type(IdString* type, const boost::python::list inputs, const boost::python::list outputs, bool is_evaluable, bool is_combinatorial)
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> inputs___tmp;
		for(int cntr_17 = 0; cntr_17 < len(inputs); cntr_17++)
		{
			IdString* tmp_18 = boost::python::extract<IdString*>(inputs[cntr_17]);
			inputs___tmp.insert(*tmp_18->get_cpp_obj());
		}
		pool<YOSYS_NAMESPACE::RTLIL::IdString> outputs___tmp;
		for(int cntr_19 = 0; cntr_19 < len(outputs); cntr_19++)
		{
			IdString* tmp_20 = boost::python::extract<IdString*>(outputs[cntr_19]);
			outputs___tmp.insert(*tmp_20->get_cpp_obj());
		}
		this->get_cpp_obj()->setup_type(*type->get_cpp_obj(), inputs___tmp, outputs___tmp, is_evaluable, is_combinatorial);
	}

	// WRAPPED from "void setup_type(RTLIL::IdString type, const pool<RTLIL::IdString> &inputs, const pool<RTLIL::IdString> &outputs, bool is_evaluable = false, bool is_combinatorial = false, bool is_synthesizable = false)" in kernel/celltypes
	void CellTypes::setup_type(IdString* type, const boost::python::list inputs, const boost::python::list outputs, bool is_evaluable, bool is_combinatorial, bool is_synthesizable)
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> inputs___tmp;
		for(int cntr_21 = 0; cntr_21 < len(inputs); cntr_21++)
		{
			IdString* tmp_22 = boost::python::extract<IdString*>(inputs[cntr_21]);
			inputs___tmp.insert(*tmp_22->get_cpp_obj());
		}
		pool<YOSYS_NAMESPACE::RTLIL::IdString> outputs___tmp;
		for(int cntr_23 = 0; cntr_23 < len(outputs); cntr_23++)
		{
			IdString* tmp_24 = boost::python::extract<IdString*>(outputs[cntr_23]);
			outputs___tmp.insert(*tmp_24->get_cpp_obj());
		}
		this->get_cpp_obj()->setup_type(*type->get_cpp_obj(), inputs___tmp, outputs___tmp, is_evaluable, is_combinatorial, is_synthesizable);
	}

	// WRAPPED from "void setup_module(RTLIL::Module *module)" in kernel/celltypes
	void CellTypes::setup_module(Module* module)
	{
		this->get_cpp_obj()->setup_module(module->get_cpp_obj());
	}

	// WRAPPED from "void setup_design(RTLIL::Design *design)" in kernel/celltypes
	void CellTypes::setup_design(Design* design)
	{
		this->get_cpp_obj()->setup_design(design->get_cpp_obj());
	}

	// WRAPPED from "void setup_internals()" in kernel/celltypes
	void CellTypes::setup_internals()
	{
		this->get_cpp_obj()->setup_internals();
	}

	// WRAPPED from "void setup_internals_eval()" in kernel/celltypes
	void CellTypes::setup_internals_eval()
	{
		this->get_cpp_obj()->setup_internals_eval();
	}

	// WRAPPED from "void setup_internals_ff()" in kernel/celltypes
	void CellTypes::setup_internals_ff()
	{
		this->get_cpp_obj()->setup_internals_ff();
	}

	// WRAPPED from "void setup_internals_anyinit()" in kernel/celltypes
	void CellTypes::setup_internals_anyinit()
	{
		this->get_cpp_obj()->setup_internals_anyinit();
	}

	// WRAPPED from "void setup_internals_mem()" in kernel/celltypes
	void CellTypes::setup_internals_mem()
	{
		this->get_cpp_obj()->setup_internals_mem();
	}

	// WRAPPED from "void setup_stdcells()" in kernel/celltypes
	void CellTypes::setup_stdcells()
	{
		this->get_cpp_obj()->setup_stdcells();
	}

	// WRAPPED from "void setup_stdcells_eval()" in kernel/celltypes
	void CellTypes::setup_stdcells_eval()
	{
		this->get_cpp_obj()->setup_stdcells_eval();
	}

	// WRAPPED from "void setup_stdcells_mem()" in kernel/celltypes
	void CellTypes::setup_stdcells_mem()
	{
		this->get_cpp_obj()->setup_stdcells_mem();
	}

	// WRAPPED from "void clear()" in kernel/celltypes
	void CellTypes::clear()
	{
		this->get_cpp_obj()->clear();
	}

	// WRAPPED from "bool cell_known(RTLIL::IdString type) const" in kernel/celltypes
	bool CellTypes::cell_known(IdString* type) const
	{
		bool ret_ = this->get_cpp_obj()->cell_known(*type->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool cell_output(RTLIL::IdString type, RTLIL::IdString port) const" in kernel/celltypes
	bool CellTypes::cell_output(IdString* type, IdString* port) const
	{
		bool ret_ = this->get_cpp_obj()->cell_output(*type->get_cpp_obj(), *port->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool cell_input(RTLIL::IdString type, RTLIL::IdString port) const" in kernel/celltypes
	bool CellTypes::cell_input(IdString* type, IdString* port) const
	{
		bool ret_ = this->get_cpp_obj()->cell_input(*type->get_cpp_obj(), *port->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool cell_evaluable(RTLIL::IdString type) const" in kernel/celltypes
	bool CellTypes::cell_evaluable(IdString* type) const
	{
		bool ret_ = this->get_cpp_obj()->cell_evaluable(*type->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "static RTLIL::Const eval_not(RTLIL::Const v)" in kernel/celltypes
	Const CellTypes::eval_not(Const* v)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval_not(*v->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "static RTLIL::Const eval(RTLIL::IdString type, const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len, bool *errp = nullptr)" in kernel/celltypes
	Const CellTypes::eval(IdString* type, const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval(*type->get_cpp_obj(), *arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "static RTLIL::Const eval(RTLIL::IdString type, const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len, bool *errp = nullptr)" in kernel/celltypes
	Const CellTypes::eval(IdString* type, const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len, bool errp)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval(*type->get_cpp_obj(), *arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len, &errp));
		return *ret_;
	}

	// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool *errp = nullptr)" in kernel/celltypes
	Const CellTypes::eval(Cell* cell, const Const* arg1, const Const* arg2)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval(cell->get_cpp_obj(), *arg1->get_cpp_obj(), *arg2->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool *errp = nullptr)" in kernel/celltypes
	Const CellTypes::eval(Cell* cell, const Const* arg1, const Const* arg2, bool errp)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval(cell->get_cpp_obj(), *arg1->get_cpp_obj(), *arg2->get_cpp_obj(), &errp));
		return *ret_;
	}

	// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3, bool *errp = nullptr)" in kernel/celltypes
	Const CellTypes::eval(Cell* cell, const Const* arg1, const Const* arg2, const Const* arg3)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval(cell->get_cpp_obj(), *arg1->get_cpp_obj(), *arg2->get_cpp_obj(), *arg3->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3, bool *errp = nullptr)" in kernel/celltypes
	Const CellTypes::eval(Cell* cell, const Const* arg1, const Const* arg2, const Const* arg3, bool errp)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval(cell->get_cpp_obj(), *arg1->get_cpp_obj(), *arg2->get_cpp_obj(), *arg3->get_cpp_obj(), &errp));
		return *ret_;
	}

	// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3, const RTLIL::Const &arg4, bool *errp = nullptr)" in kernel/celltypes
	Const CellTypes::eval(Cell* cell, const Const* arg1, const Const* arg2, const Const* arg3, const Const* arg4)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval(cell->get_cpp_obj(), *arg1->get_cpp_obj(), *arg2->get_cpp_obj(), *arg3->get_cpp_obj(), *arg4->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "static RTLIL::Const eval(RTLIL::Cell *cell, const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3, const RTLIL::Const &arg4, bool *errp = nullptr)" in kernel/celltypes
	Const CellTypes::eval(Cell* cell, const Const* arg1, const Const* arg2, const Const* arg3, const Const* arg4, bool errp)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::CellTypes::eval(cell->get_cpp_obj(), *arg1->get_cpp_obj(), *arg2->get_cpp_obj(), *arg3->get_cpp_obj(), *arg4->get_cpp_obj(), &errp));
		return *ret_;
	}

	// WRAPPED from "ConstEval(RTLIL::Module *module, RTLIL::State defaultval = RTLIL::State::Sm) : module(module), assign_map(module), defaultval(defaultval)" in kernel/consteval
	ConstEval::ConstEval(Module* module, State defaultval)
	{
		this->ref_obj = new YOSYS_NAMESPACE::ConstEval(module->get_cpp_obj(), defaultval);
	}

	Module ConstEval::get_var_py_module()
	{
		if(this->get_cpp_obj()->module == NULL)
			throw std::runtime_error("Member \"module\" is NULL");
		Module* ret_ = Module::get_py_obj(this->get_cpp_obj()->module);
		return *ret_;
	}

	void ConstEval::set_var_py_module(Module *rhs)
	{
		this->get_cpp_obj()->module = rhs->get_cpp_obj();
	}

	SigMap ConstEval::get_var_py_assign_map()
	{
		SigMap* ret_ = SigMap::get_py_obj(&this->get_cpp_obj()->assign_map);
		return *ret_;
	}

	void ConstEval::set_var_py_assign_map(SigMap *rhs)
	{
		this->get_cpp_obj()->assign_map = *rhs->get_cpp_obj();
	}

	SigMap ConstEval::get_var_py_values_map()
	{
		SigMap* ret_ = SigMap::get_py_obj(&this->get_cpp_obj()->values_map);
		return *ret_;
	}

	void ConstEval::set_var_py_values_map(SigMap *rhs)
	{
		this->get_cpp_obj()->values_map = *rhs->get_cpp_obj();
	}

	boost::python::list ConstEval::get_var_py_busy()
	{
		std::set<YOSYS_NAMESPACE::RTLIL::Cell*> ret_ = this->get_cpp_obj()->busy;
		boost::python::list ret____tmp;
		for(auto tmp_25 : ret_)
		{
			ret____tmp.append(Cell::get_py_obj(tmp_25));
		}
		return ret____tmp;
	}

	void ConstEval::set_var_py_busy(boost::python::list rhs)
	{
		std::set<YOSYS_NAMESPACE::RTLIL::Cell*> rhs___tmp;
		for(int cntr_26 = 0; cntr_26 < len(rhs); cntr_26++)
		{
			Cell* tmp_27 = boost::python::extract<Cell*>(rhs[cntr_26]);
			rhs___tmp.insert(tmp_27->get_cpp_obj());
		}
		this->get_cpp_obj()->busy = rhs___tmp;
	}

	boost::python::list ConstEval::get_var_py_stack()
	{
		std::vector<YOSYS_NAMESPACE::SigMap> ret_ = this->get_cpp_obj()->stack;
		boost::python::list ret____tmp;
		for(auto tmp_28 : ret_)
		{
			ret____tmp.append(*SigMap::get_py_obj(&tmp_28));
		}
		return ret____tmp;
	}

	void ConstEval::set_var_py_stack(boost::python::list rhs)
	{
		std::vector<YOSYS_NAMESPACE::SigMap> rhs___tmp;
		for(int cntr_29 = 0; cntr_29 < len(rhs); cntr_29++)
		{
			SigMap* tmp_30 = boost::python::extract<SigMap*>(rhs[cntr_29]);
			rhs___tmp.push_back(*tmp_30->get_cpp_obj());
		}
		this->get_cpp_obj()->stack = rhs___tmp;
	}

	YOSYS_NAMESPACE::RTLIL::State ConstEval::get_var_py_defaultval()
	{
		YOSYS_NAMESPACE::RTLIL::State ret_ = this->get_cpp_obj()->defaultval;
		return ret_;
	}

	void ConstEval::set_var_py_defaultval(YOSYS_NAMESPACE::RTLIL::State rhs)
	{
		this->get_cpp_obj()->defaultval = rhs;
	}

	// WRAPPED from "void clear()" in kernel/consteval
	void ConstEval::clear()
	{
		this->get_cpp_obj()->clear();
	}

	// WRAPPED from "void push()" in kernel/consteval
	void ConstEval::push()
	{
		this->get_cpp_obj()->push();
	}

	// WRAPPED from "void pop()" in kernel/consteval
	void ConstEval::pop()
	{
		this->get_cpp_obj()->pop();
	}

	// WRAPPED from "void set(RTLIL::SigSpec sig, RTLIL::Const value)" in kernel/consteval
	void ConstEval::set(SigSpec* sig, Const* value)
	{
		this->get_cpp_obj()->set(*sig->get_cpp_obj(), *value->get_cpp_obj());
	}

	// WRAPPED from "void stop(RTLIL::SigSpec sig)" in kernel/consteval
	void ConstEval::stop(SigSpec* sig)
	{
		this->get_cpp_obj()->stop(*sig->get_cpp_obj());
	}

	// WRAPPED from "bool eval(RTLIL::Cell *cell, RTLIL::SigSpec &undef)" in kernel/consteval
	bool ConstEval::eval(Cell* cell, SigSpec* undef)
	{
		bool ret_ = this->get_cpp_obj()->eval(cell->get_cpp_obj(), *undef->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool eval(RTLIL::SigSpec &sig, RTLIL::SigSpec &undef, RTLIL::Cell *busy_cell = NULL)" in kernel/consteval
	bool ConstEval::eval(SigSpec* sig, SigSpec* undef, Cell* busy_cell)
	{
		bool ret_ = this->get_cpp_obj()->eval(*sig->get_cpp_obj(), *undef->get_cpp_obj(), busy_cell->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool eval(RTLIL::SigSpec &sig)" in kernel/consteval
	bool ConstEval::eval(SigSpec* sig)
	{
		bool ret_ = this->get_cpp_obj()->eval(*sig->get_cpp_obj());
		return ret_;
	}

	string Pass::get_var_py_pass_name()
	{
		string ret_ = this->get_cpp_obj()->pass_name;
		return ret_;
	}

	void Pass::set_var_py_pass_name(string rhs)
	{
		this->get_cpp_obj()->pass_name = rhs;
	}

	string Pass::get_var_py_short_help()
	{
		string ret_ = this->get_cpp_obj()->short_help;
		return ret_;
	}

	void Pass::set_var_py_short_help(string rhs)
	{
		this->get_cpp_obj()->short_help = rhs;
	}

	int Pass::get_var_py_call_counter()
	{
		int ret_ = this->get_cpp_obj()->call_counter;
		return ret_;
	}

	void Pass::set_var_py_call_counter(int rhs)
	{
		this->get_cpp_obj()->call_counter = rhs;
	}

	Pass Pass::get_var_py_next_queued_pass()
	{
		if(this->get_cpp_obj()->next_queued_pass == NULL)
			throw std::runtime_error("Member \"next_queued_pass\" is NULL");
		Pass* ret_ = Pass::get_py_obj(this->get_cpp_obj()->next_queued_pass);
		return *ret_;
	}

	void Pass::set_var_py_next_queued_pass(Pass *rhs)
	{
		this->get_cpp_obj()->next_queued_pass = rhs->get_cpp_obj();
	}

	// WRAPPED from "virtual void help();" in kernel/register
	void Pass::help()
	{
		const_cast<Pass*>(this)->py_help();
	}

	// WRAPPED from "virtual void clear_flags();" in kernel/register
	void Pass::clear_flags()
	{
		const_cast<Pass*>(this)->py_clear_flags();
	}

	// WRAPPED from "virtual void execute(std::vector<std::string> args, RTLIL::Design *design) = 0;" in kernel/register
	void Pass::execute(std::vector<string> args, YOSYS_NAMESPACE::RTLIL::Design *design)
	{
		boost::python::list args___tmp;
		for(auto tmp_31 : args)
		{
			args___tmp.append(tmp_31);
		}
		const_cast<Pass*>(this)->py_execute(args___tmp, Design::get_py_obj(design));
	}

	// WRAPPED from "void experimental() {" in kernel/register
	void Pass::experimental()
	{
		this->get_cpp_obj()->experimental();
	}

	// WRAPPED from "void cmd_log_args(const std::vector<std::string> &args);" in kernel/register
	void Pass::cmd_log_args(const boost::python::list args)
	{
		std::vector<string> args___tmp;
		for(int cntr_32 = 0; cntr_32 < len(args); cntr_32++)
		{
			string tmp_33 = boost::python::extract<string>(args[cntr_32]);
			args___tmp.push_back(tmp_33);
		}
		this->get_cpp_obj()->cmd_log_args(args___tmp);
	}

	// WRAPPED from "void cmd_error(const std::vector<std::string> &args, size_t argidx, std::string msg);" in kernel/register
	void Pass::cmd_error(const boost::python::list args, size_t argidx, string msg)
	{
		std::vector<string> args___tmp;
		for(int cntr_34 = 0; cntr_34 < len(args); cntr_34++)
		{
			string tmp_35 = boost::python::extract<string>(args[cntr_34]);
			args___tmp.push_back(tmp_35);
		}
		this->get_cpp_obj()->cmd_error(args___tmp, argidx, msg);
	}

	// WRAPPED from "void extra_args(std::vector<std::string> args, size_t argidx, RTLIL::Design *design, bool select = true);" in kernel/register
	void Pass::extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design(boost::python::list args, size_t argidx, Design* design)
	{
		std::vector<string> args___tmp;
		for(int cntr_36 = 0; cntr_36 < len(args); cntr_36++)
		{
			string tmp_37 = boost::python::extract<string>(args[cntr_36]);
			args___tmp.push_back(tmp_37);
		}
		this->get_cpp_obj()->extra_args(args___tmp, argidx, design->get_cpp_obj());
	}

	// WRAPPED from "void extra_args(std::vector<std::string> args, size_t argidx, RTLIL::Design *design, bool select = true);" in kernel/register
	void Pass::extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design__bool(boost::python::list args, size_t argidx, Design* design, bool select)
	{
		std::vector<string> args___tmp;
		for(int cntr_38 = 0; cntr_38 < len(args); cntr_38++)
		{
			string tmp_39 = boost::python::extract<string>(args[cntr_38]);
			args___tmp.push_back(tmp_39);
		}
		this->get_cpp_obj()->extra_args(args___tmp, argidx, design->get_cpp_obj(), select);
	}

	// WRAPPED from "static void call(RTLIL::Design *design, std::string command);" in kernel/register
	void Pass::call__YOSYS_NAMESPACE_RTLIL_Design__string(Design* design, string command)
	{
		YOSYS_NAMESPACE::Pass::call(design->get_cpp_obj(), command);
	}

	// WRAPPED from "static void call(RTLIL::Design *design, std::vector<std::string> args);" in kernel/register
	void Pass::call__YOSYS_NAMESPACE_RTLIL_Design__std_vector_string_(Design* design, boost::python::list args)
	{
		std::vector<string> args___tmp;
		for(int cntr_40 = 0; cntr_40 < len(args); cntr_40++)
		{
			string tmp_41 = boost::python::extract<string>(args[cntr_40]);
			args___tmp.push_back(tmp_41);
		}
		YOSYS_NAMESPACE::Pass::call(design->get_cpp_obj(), args___tmp);
	}

	// WRAPPED from "static void call_on_selection(RTLIL::Design *design, const RTLIL::Selection &selection, std::string command);" in kernel/register
	void Pass::call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__string(Design* design, const Selection* selection, string command)
	{
		YOSYS_NAMESPACE::Pass::call_on_selection(design->get_cpp_obj(), *selection->get_cpp_obj(), command);
	}

	// WRAPPED from "static void call_on_selection(RTLIL::Design *design, const RTLIL::Selection &selection, std::vector<std::string> args);" in kernel/register
	void Pass::call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__std_vector_string_(Design* design, const Selection* selection, boost::python::list args)
	{
		std::vector<string> args___tmp;
		for(int cntr_42 = 0; cntr_42 < len(args); cntr_42++)
		{
			string tmp_43 = boost::python::extract<string>(args[cntr_42]);
			args___tmp.push_back(tmp_43);
		}
		YOSYS_NAMESPACE::Pass::call_on_selection(design->get_cpp_obj(), *selection->get_cpp_obj(), args___tmp);
	}

	// WRAPPED from "static void call_on_module(RTLIL::Design *design, RTLIL::Module *module, std::string command);" in kernel/register
	void Pass::call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__string(Design* design, Module* module, string command)
	{
		YOSYS_NAMESPACE::Pass::call_on_module(design->get_cpp_obj(), module->get_cpp_obj(), command);
	}

	// WRAPPED from "static void call_on_module(RTLIL::Design *design, RTLIL::Module *module, std::vector<std::string> args);" in kernel/register
	void Pass::call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__std_vector_string_(Design* design, Module* module, boost::python::list args)
	{
		std::vector<string> args___tmp;
		for(int cntr_44 = 0; cntr_44 < len(args); cntr_44++)
		{
			string tmp_45 = boost::python::extract<string>(args[cntr_44]);
			args___tmp.push_back(tmp_45);
		}
		YOSYS_NAMESPACE::Pass::call_on_module(design->get_cpp_obj(), module->get_cpp_obj(), args___tmp);
	}

	// WRAPPED from "static void init_register();" in kernel/register
	void Pass::init_register()
	{
		YOSYS_NAMESPACE::Pass::init_register();
	}

	// WRAPPED from "static void done_register();" in kernel/register
	void Pass::done_register()
	{
		YOSYS_NAMESPACE::Pass::done_register();
	}

	// WRAPPED from "virtual void on_register();" in kernel/register
	void Pass::on_register()
	{
		const_cast<Pass*>(this)->py_on_register();
	}

	// WRAPPED from "virtual void on_shutdown();" in kernel/register
	void Pass::on_shutdown()
	{
		const_cast<Pass*>(this)->py_on_shutdown();
	}

	// WRAPPED from "virtual bool replace_existing_pass() const { return false; }" in kernel/register
	bool Pass::replace_existing_pass() const
	{
		return const_cast<Pass*>(this)->py_replace_existing_pass();
	}

	// WRAPPED from "inline IdString() : index_(0) { }" in kernel/rtlil
	IdString::IdString()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::IdString();
	}

	// WRAPPED from "inline IdString(const char_p str) : index_(get_reference(str)) { }" in kernel/rtlil
	IdString::IdString(const char * str)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::IdString(str);
	}

	// WRAPPED from "inline IdString(const IdString &str) : index_(get_reference(str.index_)) { }" in kernel/rtlil
	IdString::IdString(const IdString* str)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::IdString(*str->get_cpp_obj());
	}

	// WRAPPED from "inline IdString(IdString &&str) : index_(str.index_) { str.index_ = 0; }" in kernel/rtlil
	IdString::IdString(IdString* str)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::IdString(*str->get_cpp_obj());
	}

	// WRAPPED from "inline IdString(const std::string &str) : index_(get_reference(str.c_str())) { }" in kernel/rtlil
	IdString::IdString(const string str)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::IdString(str);
	}

	int IdString::get_var_py_index_()
	{
		int ret_ = this->get_cpp_obj()->index_;
		return ret_;
	}

	void IdString::set_var_py_index_(int rhs)
	{
		this->get_cpp_obj()->index_ = rhs;
	}

	// WRAPPED from "static inline void xtrace_db_dump()" in kernel/rtlil
	void IdString::xtrace_db_dump()
	{
		YOSYS_NAMESPACE::RTLIL::IdString::xtrace_db_dump();
	}

	// WRAPPED from "static inline void checkpoint()" in kernel/rtlil
	void IdString::checkpoint()
	{
		YOSYS_NAMESPACE::RTLIL::IdString::checkpoint();
	}

	// WRAPPED from "static inline int get_reference(int idx)" in kernel/rtlil
	int IdString::get_reference(int idx)
	{
		int ret_ = YOSYS_NAMESPACE::RTLIL::IdString::get_reference(idx);
		return ret_;
	}

	// WRAPPED from "static int get_reference(const char_p p)" in kernel/rtlil
	int IdString::get_reference(const char * p)
	{
		int ret_ = YOSYS_NAMESPACE::RTLIL::IdString::get_reference(p);
		return ret_;
	}

	// WRAPPED from "static inline void put_reference(int idx)" in kernel/rtlil
	void IdString::put_reference(int idx)
	{
		YOSYS_NAMESPACE::RTLIL::IdString::put_reference(idx);
	}

	// WRAPPED from "static inline void free_reference(int idx)" in kernel/rtlil
	void IdString::free_reference(int idx)
	{
		YOSYS_NAMESPACE::RTLIL::IdString::free_reference(idx);
	}

	// WRAPPED from "inline const char_p c_str() const {" in kernel/rtlil
	const char * IdString::c_str() const
	{
		const char * ret_ = this->get_cpp_obj()->c_str();
		return ret_;
	}

	// WRAPPED from "inline std::string str() const {" in kernel/rtlil
	string IdString::str() const
	{
		string ret_ = this->get_cpp_obj()->str();
		return ret_;
	}

	// WRAPPED from "inline bool operator<(const IdString &rhs) const {" in kernel/rtlil
	bool IdString::operator<(const IdString* rhs) const
	{
		bool ret_ = this->get_cpp_obj()->operator<(*rhs->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "inline bool operator==(const IdString &rhs) const { return index_ == rhs.index_; }" in kernel/rtlil
	bool IdString::operator==(const IdString* rhs) const
	{
		bool ret_ = this->get_cpp_obj()->operator==(*rhs->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "inline bool operator!=(const IdString &rhs) const { return index_ != rhs.index_; }" in kernel/rtlil
	bool IdString::operator!=(const IdString* rhs) const
	{
		bool ret_ = this->get_cpp_obj()->operator!=(*rhs->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool operator==(const std::string &rhs) const { return c_str() == rhs; }" in kernel/rtlil
	bool IdString::operator==(const string rhs) const
	{
		bool ret_ = this->get_cpp_obj()->operator==(rhs);
		return ret_;
	}

	// WRAPPED from "bool operator!=(const std::string &rhs) const { return c_str() != rhs; }" in kernel/rtlil
	bool IdString::operator!=(const string rhs) const
	{
		bool ret_ = this->get_cpp_obj()->operator!=(rhs);
		return ret_;
	}

	// WRAPPED from "bool operator==(const char_p rhs) const { return strcmp(c_str(), rhs) == 0; }" in kernel/rtlil
	bool IdString::operator==(const char * rhs) const
	{
		bool ret_ = this->get_cpp_obj()->operator==(rhs);
		return ret_;
	}

	// WRAPPED from "bool operator!=(const char_p rhs) const { return strcmp(c_str(), rhs) != 0; }" in kernel/rtlil
	bool IdString::operator!=(const char * rhs) const
	{
		bool ret_ = this->get_cpp_obj()->operator!=(rhs);
		return ret_;
	}

	// WRAPPED from "std::string substr(size_t pos = 0, size_t len = std::string::npos) const {" in kernel/rtlil
	string IdString::substr() const
	{
		string ret_ = this->get_cpp_obj()->substr();
		return ret_;
	}

	// WRAPPED from "std::string substr(size_t pos = 0, size_t len = std::string::npos) const {" in kernel/rtlil
	string IdString::substr(size_t pos) const
	{
		string ret_ = this->get_cpp_obj()->substr(pos);
		return ret_;
	}

	// WRAPPED from "std::string substr(size_t pos = 0, size_t len = std::string::npos) const {" in kernel/rtlil
	string IdString::substr(size_t pos, size_t len) const
	{
		string ret_ = this->get_cpp_obj()->substr(pos, len);
		return ret_;
	}

	// WRAPPED from "int compare(size_t pos, size_t len, const char_p s) const {" in kernel/rtlil
	int IdString::compare(size_t pos, size_t len, const char * s) const
	{
		int ret_ = this->get_cpp_obj()->compare(pos, len, s);
		return ret_;
	}

	// WRAPPED from "bool begins_with(const char_p prefix) const {" in kernel/rtlil
	bool IdString::begins_with(const char * prefix) const
	{
		bool ret_ = this->get_cpp_obj()->begins_with(prefix);
		return ret_;
	}

	// WRAPPED from "bool ends_with(const char_p suffix) const {" in kernel/rtlil
	bool IdString::ends_with(const char * suffix) const
	{
		bool ret_ = this->get_cpp_obj()->ends_with(suffix);
		return ret_;
	}

	// WRAPPED from "bool contains(const char_p str) const {" in kernel/rtlil
	bool IdString::contains(const char * str) const
	{
		bool ret_ = this->get_cpp_obj()->contains(str);
		return ret_;
	}

	// WRAPPED from "size_t size() const {" in kernel/rtlil
	size_t IdString::size() const
	{
		size_t ret_ = this->get_cpp_obj()->size();
		return ret_;
	}

	// WRAPPED from "bool empty() const {" in kernel/rtlil
	bool IdString::empty() const
	{
		bool ret_ = this->get_cpp_obj()->empty();
		return ret_;
	}

	// WRAPPED from "void clear() {" in kernel/rtlil
	void IdString::clear()
	{
		this->get_cpp_obj()->clear();
	}

	// WRAPPED from "bool in(const IdString &rhs) const { return *this == rhs; }" in kernel/rtlil
	bool IdString::in_(const IdString* rhs) const
	{
		bool ret_ = this->get_cpp_obj()->in(*rhs->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool in(const char_p rhs) const { return *this == rhs; }" in kernel/rtlil
	bool IdString::in_(const char * rhs) const
	{
		bool ret_ = this->get_cpp_obj()->in(rhs);
		return ret_;
	}

	// WRAPPED from "bool in(const std::string &rhs) const { return *this == rhs; }" in kernel/rtlil
	bool IdString::in_(const string rhs) const
	{
		bool ret_ = this->get_cpp_obj()->in(rhs);
		return ret_;
	}

	// WRAPPED from "inline bool in(const pool<IdString> &rhs) const;" in kernel/rtlil
	bool IdString::in_(const boost::python::list rhs)
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> rhs___tmp;
		for(int cntr_46 = 0; cntr_46 < len(rhs); cntr_46++)
		{
			IdString* tmp_47 = boost::python::extract<IdString*>(rhs[cntr_46]);
			rhs___tmp.insert(*tmp_47->get_cpp_obj());
		}
		bool ret_ = this->get_cpp_obj()->in(rhs___tmp);
		return ret_;
	}

	// WRAPPED from "bool isPublic() const { return begins_with("\\"); }" in kernel/rtlil
	bool IdString::isPublic() const
	{
		bool ret_ = this->get_cpp_obj()->isPublic();
		return ret_;
	}

	// WRAPPED from "Const() : flags(RTLIL::CONST_FLAG_NONE), tag(backing_tag::bits), bits_(std::vector<RTLIL::State>()) {}" in kernel/rtlil
	Const::Const()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Const();
	}

	// WRAPPED from "Const(const std::string &str);" in kernel/rtlil
	Const::Const(const string str)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Const(str);
	}

	// WRAPPED from "Const(RTLIL::State bit, int width = 1);" in kernel/rtlil
	Const::Const(State bit, int width)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Const(bit, width);
	}

	// WRAPPED from "Const(const std::vector<RTLIL::State> &bits) : flags(RTLIL::CONST_FLAG_NONE), tag(backing_tag::bits), bits_(bits) {}" in kernel/rtlil
	Const::Const(const boost::python::list bits)
	{
		std::vector<State> bits___tmp;
		for(int cntr_48 = 0; cntr_48 < len(bits); cntr_48++)
		{
			State tmp_49 = boost::python::extract<State>(bits[cntr_48]);
			bits___tmp.push_back(tmp_49);
		}
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Const(bits___tmp);
	}

	// WRAPPED from "Const(const RTLIL::Const &other);" in kernel/rtlil
	Const::Const(const Const* other)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Const(*other->get_cpp_obj());
	}

	// WRAPPED from "Const(RTLIL::Const &&other);" in kernel/rtlil
	Const::Const(Const* other)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Const(*other->get_cpp_obj());
	}

	short int Const::get_var_py_flags()
	{
		short int ret_ = this->get_cpp_obj()->flags;
		return ret_;
	}

	void Const::set_var_py_flags(short int rhs)
	{
		this->get_cpp_obj()->flags = rhs;
	}

	// WRAPPED from "bool operator <(const RTLIL::Const &other) const;" in kernel/rtlil
	bool Const::operator<(const Const* other)
	{
		bool ret_ = this->get_cpp_obj()->operator<(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool operator ==(const RTLIL::Const &other) const;" in kernel/rtlil
	bool Const::operator==(const Const* other)
	{
		bool ret_ = this->get_cpp_obj()->operator==(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool operator !=(const RTLIL::Const &other) const;" in kernel/rtlil
	bool Const::operator!=(const Const* other)
	{
		bool ret_ = this->get_cpp_obj()->operator!=(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "std::vector<RTLIL::State>& bits();" in kernel/rtlil
	boost::python::list Const::bits()
	{
		std::vector<State> ret_ = this->get_cpp_obj()->bits();
		boost::python::list ret____tmp;
		for(auto tmp_50 : ret_)
		{
			ret____tmp.append(tmp_50);
		}
		return ret____tmp;
	}

	// WRAPPED from "bool as_bool() const;" in kernel/rtlil
	bool Const::as_bool()
	{
		bool ret_ = this->get_cpp_obj()->as_bool();
		return ret_;
	}

	// WRAPPED from "int as_int(bool is_signed = false) const;" in kernel/rtlil
	int Const::as_int()
	{
		int ret_ = this->get_cpp_obj()->as_int();
		return ret_;
	}

	// WRAPPED from "int as_int(bool is_signed = false) const;" in kernel/rtlil
	int Const::as_int(bool is_signed)
	{
		int ret_ = this->get_cpp_obj()->as_int(is_signed);
		return ret_;
	}

	// WRAPPED from "bool convertible_to_int(bool is_signed = false) const;" in kernel/rtlil
	bool Const::convertible_to_int()
	{
		bool ret_ = this->get_cpp_obj()->convertible_to_int();
		return ret_;
	}

	// WRAPPED from "bool convertible_to_int(bool is_signed = false) const;" in kernel/rtlil
	bool Const::convertible_to_int(bool is_signed)
	{
		bool ret_ = this->get_cpp_obj()->convertible_to_int(is_signed);
		return ret_;
	}

	// WRAPPED from "int as_int_saturating(bool is_signed = false) const;" in kernel/rtlil
	int Const::as_int_saturating()
	{
		int ret_ = this->get_cpp_obj()->as_int_saturating();
		return ret_;
	}

	// WRAPPED from "int as_int_saturating(bool is_signed = false) const;" in kernel/rtlil
	int Const::as_int_saturating(bool is_signed)
	{
		int ret_ = this->get_cpp_obj()->as_int_saturating(is_signed);
		return ret_;
	}

	// WRAPPED from "std::string as_string(const char_p any = "-") const;" in kernel/rtlil
	string Const::as_string(const char * any)
	{
		string ret_ = this->get_cpp_obj()->as_string(any);
		return ret_;
	}

	// WRAPPED from "static Const from_string(const std::string &str);" in kernel/rtlil
	Const Const::from_string(const string str)
	{
		Const* ret_ = Const::get_py_obj(YOSYS_NAMESPACE::RTLIL::Const::from_string(str));
		return *ret_;
	}

	// WRAPPED from "std::vector<RTLIL::State> to_bits() const;" in kernel/rtlil
	boost::python::list Const::to_bits()
	{
		std::vector<State> ret_ = this->get_cpp_obj()->to_bits();
		boost::python::list ret____tmp;
		for(auto tmp_51 : ret_)
		{
			ret____tmp.append(tmp_51);
		}
		return ret____tmp;
	}

	// WRAPPED from "std::string decode_string() const;" in kernel/rtlil
	string Const::decode_string()
	{
		string ret_ = this->get_cpp_obj()->decode_string();
		return ret_;
	}

	// WRAPPED from "int size() const;" in kernel/rtlil
	int Const::size()
	{
		int ret_ = this->get_cpp_obj()->size();
		return ret_;
	}

	// WRAPPED from "bool empty() const;" in kernel/rtlil
	bool Const::empty()
	{
		bool ret_ = this->get_cpp_obj()->empty();
		return ret_;
	}

	// WRAPPED from "void bitvectorize() const;" in kernel/rtlil
	void Const::bitvectorize()
	{
		this->get_cpp_obj()->bitvectorize();
	}

	// WRAPPED from "void append(const RTLIL::Const &other);" in kernel/rtlil
	void Const::append(const Const* other)
	{
		this->get_cpp_obj()->append(*other->get_cpp_obj());
	}

	// WRAPPED from "State back() const {" in kernel/rtlil
	YOSYS_NAMESPACE::RTLIL::State Const::back() const
	{
		YOSYS_NAMESPACE::RTLIL::State ret_ = this->get_cpp_obj()->back();
		return ret_;
	}

	// WRAPPED from "State front() const {" in kernel/rtlil
	YOSYS_NAMESPACE::RTLIL::State Const::front() const
	{
		YOSYS_NAMESPACE::RTLIL::State ret_ = this->get_cpp_obj()->front();
		return ret_;
	}

	// WRAPPED from "State at(size_t i) const {" in kernel/rtlil
	YOSYS_NAMESPACE::RTLIL::State Const::at(size_t i) const
	{
		YOSYS_NAMESPACE::RTLIL::State ret_ = this->get_cpp_obj()->at(i);
		return ret_;
	}

	// WRAPPED from "bool is_fully_zero() const;" in kernel/rtlil
	bool Const::is_fully_zero()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_zero();
		return ret_;
	}

	// WRAPPED from "bool is_fully_ones() const;" in kernel/rtlil
	bool Const::is_fully_ones()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_ones();
		return ret_;
	}

	// WRAPPED from "bool is_fully_def() const;" in kernel/rtlil
	bool Const::is_fully_def()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_def();
		return ret_;
	}

	// WRAPPED from "bool is_fully_undef() const;" in kernel/rtlil
	bool Const::is_fully_undef()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_undef();
		return ret_;
	}

	// WRAPPED from "bool is_fully_undef_x_only() const;" in kernel/rtlil
	bool Const::is_fully_undef_x_only()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_undef_x_only();
		return ret_;
	}

	// WRAPPED from "bool is_onehot(int *pos = nullptr) const;" in kernel/rtlil
	bool Const::is_onehot()
	{
		bool ret_ = this->get_cpp_obj()->is_onehot();
		return ret_;
	}

	// WRAPPED from "bool is_onehot(int *pos = nullptr) const;" in kernel/rtlil
	bool Const::is_onehot(int pos)
	{
		bool ret_ = this->get_cpp_obj()->is_onehot(&pos);
		return ret_;
	}

	// WRAPPED from "RTLIL::Const extract(int offset, int len = 1, RTLIL::State padding = RTLIL::State::S0) const;" in kernel/rtlil
	Const Const::extract(int offset)
	{
		Const* ret_ = Const::get_py_obj(this->get_cpp_obj()->extract(offset));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const extract(int offset, int len = 1, RTLIL::State padding = RTLIL::State::S0) const;" in kernel/rtlil
	Const Const::extract(int offset, int len)
	{
		Const* ret_ = Const::get_py_obj(this->get_cpp_obj()->extract(offset, len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const extract(int offset, int len = 1, RTLIL::State padding = RTLIL::State::S0) const;" in kernel/rtlil
	Const Const::extract(int offset, int len, State padding)
	{
		Const* ret_ = Const::get_py_obj(this->get_cpp_obj()->extract(offset, len, padding));
		return *ret_;
	}

	// WRAPPED from "int get_min_size(bool is_signed) const;" in kernel/rtlil
	int Const::get_min_size(bool is_signed)
	{
		int ret_ = this->get_cpp_obj()->get_min_size(is_signed);
		return ret_;
	}

	// WRAPPED from "void compress(bool is_signed = false);" in kernel/rtlil
	void Const::compress()
	{
		this->get_cpp_obj()->compress();
	}

	// WRAPPED from "void compress(bool is_signed = false);" in kernel/rtlil
	void Const::compress(bool is_signed)
	{
		this->get_cpp_obj()->compress(is_signed);
	}

	// WRAPPED from "void extu(int width) {" in kernel/rtlil
	void Const::extu(int width)
	{
		this->get_cpp_obj()->extu(width);
	}

	// WRAPPED from "void exts(int width) {" in kernel/rtlil
	void Const::exts(int width)
	{
		this->get_cpp_obj()->exts(width);
	}

	// WRAPPED from "Auto generated default constructor" in kernel/rtlil
	AttrObject::AttrObject()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::AttrObject();
	}

	boost::python::dict AttrObject::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_52 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_52.first)] = *Const::get_py_obj(&tmp_52.second);
		}
		return ret____tmp;
	}

	void AttrObject::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_53 = 0; cntr_53 < len(rhs_keylist); cntr_53++)
		{
			IdString* key_tmp_54 = boost::python::extract<IdString*>(rhs_keylist[ cntr_53 ]);
			Const* val_tmp_54 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_53 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_54->get_cpp_obj(), *val_tmp_54->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool AttrObject::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void AttrObject::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void AttrObject::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool AttrObject::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool AttrObject::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool AttrObject::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void AttrObject::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string AttrObject::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void AttrObject::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_55 = 0; cntr_55 < len(data); cntr_55++)
		{
			string tmp_56 = boost::python::extract<string>(data[cntr_55]);
			data___tmp.insert(tmp_56);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void AttrObject::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_57 = 0; cntr_57 < len(data); cntr_57++)
		{
			string tmp_58 = boost::python::extract<string>(data[cntr_57]);
			data___tmp.insert(tmp_58);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list AttrObject::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_59 : ret_)
		{
			ret____tmp.append(tmp_59);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void AttrObject::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string AttrObject::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	// WRAPPED from "Auto generated default constructor" in kernel/rtlil
	NamedObject::NamedObject()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::NamedObject();
	}

	IdString NamedObject::get_var_py_name()
	{
		IdString* ret_ = IdString::get_py_obj(&this->get_cpp_obj()->name);
		return *ret_;
	}

	void NamedObject::set_var_py_name(IdString *rhs)
	{
		this->get_cpp_obj()->name = *rhs->get_cpp_obj();
	}

	boost::python::dict NamedObject::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_60 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_60.first)] = *Const::get_py_obj(&tmp_60.second);
		}
		return ret____tmp;
	}

	void NamedObject::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_61 = 0; cntr_61 < len(rhs_keylist); cntr_61++)
		{
			IdString* key_tmp_62 = boost::python::extract<IdString*>(rhs_keylist[ cntr_61 ]);
			Const* val_tmp_62 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_61 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_62->get_cpp_obj(), *val_tmp_62->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool NamedObject::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void NamedObject::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void NamedObject::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool NamedObject::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool NamedObject::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool NamedObject::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void NamedObject::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string NamedObject::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void NamedObject::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_63 = 0; cntr_63 < len(data); cntr_63++)
		{
			string tmp_64 = boost::python::extract<string>(data[cntr_63]);
			data___tmp.insert(tmp_64);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void NamedObject::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_65 = 0; cntr_65 < len(data); cntr_65++)
		{
			string tmp_66 = boost::python::extract<string>(data[cntr_65]);
			data___tmp.insert(tmp_66);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list NamedObject::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_67 : ret_)
		{
			ret____tmp.append(tmp_67);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void NamedObject::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string NamedObject::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	// WRAPPED from "Selection( bool full = true, bool boxes = false, RTLIL::Design *design = nullptr ) :" in kernel/rtlil
	Selection::Selection(bool full, bool boxes, Design* design)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Selection(full, boxes, design->get_cpp_obj());
	}

	bool Selection::get_var_py_selects_boxes()
	{
		bool ret_ = this->get_cpp_obj()->selects_boxes;
		return ret_;
	}

	void Selection::set_var_py_selects_boxes(bool rhs)
	{
		this->get_cpp_obj()->selects_boxes = rhs;
	}

	bool Selection::get_var_py_complete_selection()
	{
		bool ret_ = this->get_cpp_obj()->complete_selection;
		return ret_;
	}

	void Selection::set_var_py_complete_selection(bool rhs)
	{
		this->get_cpp_obj()->complete_selection = rhs;
	}

	bool Selection::get_var_py_full_selection()
	{
		bool ret_ = this->get_cpp_obj()->full_selection;
		return ret_;
	}

	void Selection::set_var_py_full_selection(bool rhs)
	{
		this->get_cpp_obj()->full_selection = rhs;
	}

	boost::python::list Selection::get_var_py_selected_modules()
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> ret_ = this->get_cpp_obj()->selected_modules;
		boost::python::list ret____tmp;
		for(auto tmp_68 : ret_)
		{
			ret____tmp.append(*IdString::get_py_obj(&tmp_68));
		}
		return ret____tmp;
	}

	void Selection::set_var_py_selected_modules(boost::python::list rhs)
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> rhs___tmp;
		for(int cntr_69 = 0; cntr_69 < len(rhs); cntr_69++)
		{
			IdString* tmp_70 = boost::python::extract<IdString*>(rhs[cntr_69]);
			rhs___tmp.insert(*tmp_70->get_cpp_obj());
		}
		this->get_cpp_obj()->selected_modules = rhs___tmp;
	}

	boost::python::dict Selection::get_var_py_selected_members()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, pool<YOSYS_NAMESPACE::RTLIL::IdString>> ret_ = this->get_cpp_obj()->selected_members;
		boost::python::dict ret____tmp;
		for(auto tmp_71 : ret_)
		{
			auto tmp_71_second = tmp_71.second;
			boost::python::list tmp_71_second___tmp;
			for(auto tmp_72 : tmp_71_second)
			{
				tmp_71_second___tmp.append(*IdString::get_py_obj(&tmp_72));
			}
			ret____tmp[IdString::get_py_obj(tmp_71.first)] = tmp_71_second___tmp;
		}
		return ret____tmp;
	}

	void Selection::set_var_py_selected_members(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, pool<YOSYS_NAMESPACE::RTLIL::IdString>> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_73 = 0; cntr_73 < len(rhs_keylist); cntr_73++)
		{
			IdString* key_tmp_74 = boost::python::extract<IdString*>(rhs_keylist[ cntr_73 ]);
			boost::python::list val_tmp_74 = boost::python::extract<boost::python::list>(rhs[rhs_keylist[ cntr_73 ]]);
			pool<YOSYS_NAMESPACE::RTLIL::IdString> val_tmp_74___tmp;
			for(int cntr_75 = 0; cntr_75 < len(val_tmp_74); cntr_75++)
			{
				IdString* tmp_76 = boost::python::extract<IdString*>(val_tmp_74[cntr_75]);
				val_tmp_74___tmp.insert(*tmp_76->get_cpp_obj());
			}
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, pool<YOSYS_NAMESPACE::RTLIL::IdString>>(*key_tmp_74->get_cpp_obj(), val_tmp_74___tmp));

		}
		this->get_cpp_obj()->selected_members = rhs___tmp;
	}

	Design Selection::get_var_py_current_design()
	{
		if(this->get_cpp_obj()->current_design == NULL)
			throw std::runtime_error("Member \"current_design\" is NULL");
		Design* ret_ = Design::get_py_obj(this->get_cpp_obj()->current_design);
		return *ret_;
	}

	void Selection::set_var_py_current_design(Design *rhs)
	{
		this->get_cpp_obj()->current_design = rhs->get_cpp_obj();
	}

	// WRAPPED from "bool boxed_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
	bool Selection::boxed_module(const IdString* mod_name)
	{
		bool ret_ = this->get_cpp_obj()->boxed_module(*mod_name->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool selected_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
	bool Selection::selected_module(const IdString* mod_name)
	{
		bool ret_ = this->get_cpp_obj()->selected_module(*mod_name->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool selected_whole_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
	bool Selection::selected_whole_module(const IdString* mod_name)
	{
		bool ret_ = this->get_cpp_obj()->selected_whole_module(*mod_name->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool selected_member(const RTLIL::IdString &mod_name, const RTLIL::IdString &memb_name) const;" in kernel/rtlil
	bool Selection::selected_member(const IdString* mod_name, const IdString* memb_name)
	{
		bool ret_ = this->get_cpp_obj()->selected_member(*mod_name->get_cpp_obj(), *memb_name->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void optimize(RTLIL::Design *design);" in kernel/rtlil
	void Selection::optimize(Design* design)
	{
		this->get_cpp_obj()->optimize(design->get_cpp_obj());
	}

	// WRAPPED from "bool selects_all() const {" in kernel/rtlil
	bool Selection::selects_all() const
	{
		bool ret_ = this->get_cpp_obj()->selects_all();
		return ret_;
	}

	// WRAPPED from "bool empty() const {" in kernel/rtlil
	bool Selection::empty() const
	{
		bool ret_ = this->get_cpp_obj()->empty();
		return ret_;
	}

	// WRAPPED from "void clear();" in kernel/rtlil
	void Selection::clear()
	{
		this->get_cpp_obj()->clear();
	}

	// WRAPPED from "static Selection EmptySelection(RTLIL::Design *design = nullptr) { return Selection(false, false, design); };" in kernel/rtlil
	Selection Selection::EmptySelection()
	{
		Selection* ret_ = Selection::get_py_obj(YOSYS_NAMESPACE::RTLIL::Selection::EmptySelection());
		return *ret_;
	}

	// WRAPPED from "static Selection EmptySelection(RTLIL::Design *design = nullptr) { return Selection(false, false, design); };" in kernel/rtlil
	Selection Selection::EmptySelection(Design* design)
	{
		Selection* ret_ = Selection::get_py_obj(YOSYS_NAMESPACE::RTLIL::Selection::EmptySelection(design->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "static Selection FullSelection(RTLIL::Design *design = nullptr) { return Selection(true, false, design); };" in kernel/rtlil
	Selection Selection::FullSelection()
	{
		Selection* ret_ = Selection::get_py_obj(YOSYS_NAMESPACE::RTLIL::Selection::FullSelection());
		return *ret_;
	}

	// WRAPPED from "static Selection FullSelection(RTLIL::Design *design = nullptr) { return Selection(true, false, design); };" in kernel/rtlil
	Selection Selection::FullSelection(Design* design)
	{
		Selection* ret_ = Selection::get_py_obj(YOSYS_NAMESPACE::RTLIL::Selection::FullSelection(design->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "static Selection CompleteSelection(RTLIL::Design *design = nullptr) { return Selection(true, true, design); };" in kernel/rtlil
	Selection Selection::CompleteSelection()
	{
		Selection* ret_ = Selection::get_py_obj(YOSYS_NAMESPACE::RTLIL::Selection::CompleteSelection());
		return *ret_;
	}

	// WRAPPED from "static Selection CompleteSelection(RTLIL::Design *design = nullptr) { return Selection(true, true, design); };" in kernel/rtlil
	Selection Selection::CompleteSelection(Design* design)
	{
		Selection* ret_ = Selection::get_py_obj(YOSYS_NAMESPACE::RTLIL::Selection::CompleteSelection(design->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "virtual void notify_module_add(RTLIL::Module*) { }" in kernel/rtlil
	void Monitor::notify_module_add(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_0)
	{
		const_cast<Monitor*>(this)->py_notify_module_add(Module::get_py_obj(gen_varname_0));
	}

	// WRAPPED from "virtual void notify_module_del(RTLIL::Module*) { }" in kernel/rtlil
	void Monitor::notify_module_del(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_1)
	{
		const_cast<Monitor*>(this)->py_notify_module_del(Module::get_py_obj(gen_varname_1));
	}

	// WRAPPED from "virtual void notify_connect(RTLIL::Cell*, const RTLIL::IdString&, const RTLIL::SigSpec&, const RTLIL::SigSpec&) { }" in kernel/rtlil
	void Monitor::notify_connect(YOSYS_NAMESPACE::RTLIL::Cell *gen_varname_2, const YOSYS_NAMESPACE::RTLIL::IdString &gen_varname_3, const YOSYS_NAMESPACE::RTLIL::SigSpec &gen_varname_4, const YOSYS_NAMESPACE::RTLIL::SigSpec &gen_varname_5)
	{
		const_cast<Monitor*>(this)->py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec(Cell::get_py_obj(gen_varname_2), IdString::get_py_obj(gen_varname_3), SigSpec::get_py_obj(gen_varname_4), SigSpec::get_py_obj(gen_varname_5));
	}

	// WRAPPED from "virtual void notify_connect(RTLIL::Module*, const RTLIL::SigSig&) { }" in kernel/rtlil
	void Monitor::notify_connect(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_6, const std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec> &gen_varname_7)
	{
		boost::python::tuple gen_varname_7___tmp = boost::python::make_tuple(SigSpec::get_py_obj(gen_varname_7.first), SigSpec::get_py_obj(gen_varname_7.second));
		const_cast<Monitor*>(this)->py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_(Module::get_py_obj(gen_varname_6), gen_varname_7___tmp);
	}

	// WRAPPED from "virtual void notify_connect(RTLIL::Module*, const std::vector<RTLIL::SigSig>&) { }" in kernel/rtlil
	void Monitor::notify_connect(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_8, const std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> &gen_varname_9)
	{
		boost::python::list gen_varname_9___tmp;
		for(auto tmp_77 : gen_varname_9)
		{
			boost::python::tuple tmp_77___tmp = boost::python::make_tuple(SigSpec::get_py_obj(tmp_77.first), SigSpec::get_py_obj(tmp_77.second));
			gen_varname_9___tmp.append(tmp_77___tmp);
		}
		const_cast<Monitor*>(this)->py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__(Module::get_py_obj(gen_varname_8), gen_varname_9___tmp);
	}

	// WRAPPED from "virtual void notify_blackout(RTLIL::Module*) { }" in kernel/rtlil
	void Monitor::notify_blackout(YOSYS_NAMESPACE::RTLIL::Module *gen_varname_10)
	{
		const_cast<Monitor*>(this)->py_notify_blackout(Module::get_py_obj(gen_varname_10));
	}

	// WRAPPED from "Auto generated default constructor" in kernel/rtlil
	CaseRule::CaseRule()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::CaseRule();
	}

	boost::python::list CaseRule::get_var_py_compare()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SigSpec> ret_ = this->get_cpp_obj()->compare;
		boost::python::list ret____tmp;
		for(auto tmp_78 : ret_)
		{
			ret____tmp.append(*SigSpec::get_py_obj(&tmp_78));
		}
		return ret____tmp;
	}

	void CaseRule::set_var_py_compare(boost::python::list rhs)
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SigSpec> rhs___tmp;
		for(int cntr_79 = 0; cntr_79 < len(rhs); cntr_79++)
		{
			SigSpec* tmp_80 = boost::python::extract<SigSpec*>(rhs[cntr_79]);
			rhs___tmp.push_back(*tmp_80->get_cpp_obj());
		}
		this->get_cpp_obj()->compare = rhs___tmp;
	}

	boost::python::list CaseRule::get_var_py_actions()
	{
		std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> ret_ = this->get_cpp_obj()->actions;
		boost::python::list ret____tmp;
		for(auto tmp_81 : ret_)
		{
			boost::python::tuple tmp_81___tmp = boost::python::make_tuple(SigSpec::get_py_obj(tmp_81.first), SigSpec::get_py_obj(tmp_81.second));
			ret____tmp.append(tmp_81___tmp);
		}
		return ret____tmp;
	}

	void CaseRule::set_var_py_actions(boost::python::list rhs)
	{
		std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> rhs___tmp;
		for(int cntr_82 = 0; cntr_82 < len(rhs); cntr_82++)
		{
			boost::python::tuple tmp_83 = boost::python::extract<boost::python::tuple>(rhs[cntr_82]);
			SigSpec tmp_83___tmp_0 = boost::python::extract<SigSpec>(tmp_83[0]);
			SigSpec tmp_83___tmp_1 = boost::python::extract<SigSpec>(tmp_83[1]);
			std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec> tmp_83___tmp(tmp_83___tmp_0.get_cpp_obj(), tmp_83___tmp_1.get_cpp_obj());
			rhs___tmp.push_back(tmp_83___tmp);
		}
		this->get_cpp_obj()->actions = rhs___tmp;
	}

	boost::python::list CaseRule::get_var_py_switches()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SwitchRule*> ret_ = this->get_cpp_obj()->switches;
		boost::python::list ret____tmp;
		for(auto tmp_84 : ret_)
		{
			ret____tmp.append(SwitchRule::get_py_obj(tmp_84));
		}
		return ret____tmp;
	}

	void CaseRule::set_var_py_switches(boost::python::list rhs)
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SwitchRule*> rhs___tmp;
		for(int cntr_85 = 0; cntr_85 < len(rhs); cntr_85++)
		{
			SwitchRule* tmp_86 = boost::python::extract<SwitchRule*>(rhs[cntr_85]);
			rhs___tmp.push_back(tmp_86->get_cpp_obj());
		}
		this->get_cpp_obj()->switches = rhs___tmp;
	}

	boost::python::dict CaseRule::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_87 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_87.first)] = *Const::get_py_obj(&tmp_87.second);
		}
		return ret____tmp;
	}

	void CaseRule::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_88 = 0; cntr_88 < len(rhs_keylist); cntr_88++)
		{
			IdString* key_tmp_89 = boost::python::extract<IdString*>(rhs_keylist[ cntr_88 ]);
			Const* val_tmp_89 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_88 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_89->get_cpp_obj(), *val_tmp_89->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "bool empty() const;" in kernel/rtlil
	bool CaseRule::empty()
	{
		bool ret_ = this->get_cpp_obj()->empty();
		return ret_;
	}

	// WRAPPED from "RTLIL::CaseRule *clone() const;" in kernel/rtlil
	CaseRule CaseRule::clone()
	{
		CaseRule* ret_ = CaseRule::get_py_obj(this->get_cpp_obj()->clone());
		return *ret_;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool CaseRule::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void CaseRule::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void CaseRule::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool CaseRule::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool CaseRule::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool CaseRule::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void CaseRule::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string CaseRule::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void CaseRule::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_90 = 0; cntr_90 < len(data); cntr_90++)
		{
			string tmp_91 = boost::python::extract<string>(data[cntr_90]);
			data___tmp.insert(tmp_91);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void CaseRule::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_92 = 0; cntr_92 < len(data); cntr_92++)
		{
			string tmp_93 = boost::python::extract<string>(data[cntr_92]);
			data___tmp.insert(tmp_93);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list CaseRule::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_94 : ret_)
		{
			ret____tmp.append(tmp_94);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void CaseRule::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string CaseRule::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	// WRAPPED from "Auto generated default constructor" in kernel/rtlil
	SwitchRule::SwitchRule()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SwitchRule();
	}

	SigSpec SwitchRule::get_var_py_signal()
	{
		SigSpec* ret_ = SigSpec::get_py_obj(&this->get_cpp_obj()->signal);
		return *ret_;
	}

	void SwitchRule::set_var_py_signal(SigSpec *rhs)
	{
		this->get_cpp_obj()->signal = *rhs->get_cpp_obj();
	}

	boost::python::list SwitchRule::get_var_py_cases()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::CaseRule*> ret_ = this->get_cpp_obj()->cases;
		boost::python::list ret____tmp;
		for(auto tmp_95 : ret_)
		{
			ret____tmp.append(CaseRule::get_py_obj(tmp_95));
		}
		return ret____tmp;
	}

	void SwitchRule::set_var_py_cases(boost::python::list rhs)
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::CaseRule*> rhs___tmp;
		for(int cntr_96 = 0; cntr_96 < len(rhs); cntr_96++)
		{
			CaseRule* tmp_97 = boost::python::extract<CaseRule*>(rhs[cntr_96]);
			rhs___tmp.push_back(tmp_97->get_cpp_obj());
		}
		this->get_cpp_obj()->cases = rhs___tmp;
	}

	boost::python::dict SwitchRule::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_98 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_98.first)] = *Const::get_py_obj(&tmp_98.second);
		}
		return ret____tmp;
	}

	void SwitchRule::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_99 = 0; cntr_99 < len(rhs_keylist); cntr_99++)
		{
			IdString* key_tmp_100 = boost::python::extract<IdString*>(rhs_keylist[ cntr_99 ]);
			Const* val_tmp_100 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_99 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_100->get_cpp_obj(), *val_tmp_100->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "bool empty() const;" in kernel/rtlil
	bool SwitchRule::empty()
	{
		bool ret_ = this->get_cpp_obj()->empty();
		return ret_;
	}

	// WRAPPED from "RTLIL::SwitchRule *clone() const;" in kernel/rtlil
	SwitchRule SwitchRule::clone()
	{
		SwitchRule* ret_ = SwitchRule::get_py_obj(this->get_cpp_obj()->clone());
		return *ret_;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool SwitchRule::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void SwitchRule::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void SwitchRule::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool SwitchRule::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool SwitchRule::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool SwitchRule::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void SwitchRule::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string SwitchRule::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void SwitchRule::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_101 = 0; cntr_101 < len(data); cntr_101++)
		{
			string tmp_102 = boost::python::extract<string>(data[cntr_101]);
			data___tmp.insert(tmp_102);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void SwitchRule::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_103 = 0; cntr_103 < len(data); cntr_103++)
		{
			string tmp_104 = boost::python::extract<string>(data[cntr_103]);
			data___tmp.insert(tmp_104);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list SwitchRule::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_105 : ret_)
		{
			ret____tmp.append(tmp_105);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void SwitchRule::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string SwitchRule::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	// WRAPPED from "Auto generated default constructor" in kernel/rtlil
	SyncRule::SyncRule()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SyncRule();
	}

	YOSYS_NAMESPACE::RTLIL::SyncType SyncRule::get_var_py_type()
	{
		YOSYS_NAMESPACE::RTLIL::SyncType ret_ = this->get_cpp_obj()->type;
		return ret_;
	}

	void SyncRule::set_var_py_type(YOSYS_NAMESPACE::RTLIL::SyncType rhs)
	{
		this->get_cpp_obj()->type = rhs;
	}

	SigSpec SyncRule::get_var_py_signal()
	{
		SigSpec* ret_ = SigSpec::get_py_obj(&this->get_cpp_obj()->signal);
		return *ret_;
	}

	void SyncRule::set_var_py_signal(SigSpec *rhs)
	{
		this->get_cpp_obj()->signal = *rhs->get_cpp_obj();
	}

	boost::python::list SyncRule::get_var_py_actions()
	{
		std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> ret_ = this->get_cpp_obj()->actions;
		boost::python::list ret____tmp;
		for(auto tmp_106 : ret_)
		{
			boost::python::tuple tmp_106___tmp = boost::python::make_tuple(SigSpec::get_py_obj(tmp_106.first), SigSpec::get_py_obj(tmp_106.second));
			ret____tmp.append(tmp_106___tmp);
		}
		return ret____tmp;
	}

	void SyncRule::set_var_py_actions(boost::python::list rhs)
	{
		std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> rhs___tmp;
		for(int cntr_107 = 0; cntr_107 < len(rhs); cntr_107++)
		{
			boost::python::tuple tmp_108 = boost::python::extract<boost::python::tuple>(rhs[cntr_107]);
			SigSpec tmp_108___tmp_0 = boost::python::extract<SigSpec>(tmp_108[0]);
			SigSpec tmp_108___tmp_1 = boost::python::extract<SigSpec>(tmp_108[1]);
			std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec> tmp_108___tmp(tmp_108___tmp_0.get_cpp_obj(), tmp_108___tmp_1.get_cpp_obj());
			rhs___tmp.push_back(tmp_108___tmp);
		}
		this->get_cpp_obj()->actions = rhs___tmp;
	}

	// WRAPPED from "RTLIL::SyncRule *clone() const;" in kernel/rtlil
	SyncRule SyncRule::clone()
	{
		SyncRule* ret_ = SyncRule::get_py_obj(this->get_cpp_obj()->clone());
		return *ret_;
	}

	Module Process::get_var_py_module()
	{
		if(this->get_cpp_obj()->module == NULL)
			throw std::runtime_error("Member \"module\" is NULL");
		Module* ret_ = Module::get_py_obj(this->get_cpp_obj()->module);
		return *ret_;
	}

	void Process::set_var_py_module(Module *rhs)
	{
		this->get_cpp_obj()->module = rhs->get_cpp_obj();
	}

	CaseRule Process::get_var_py_root_case()
	{
		CaseRule* ret_ = CaseRule::get_py_obj(&this->get_cpp_obj()->root_case);
		return *ret_;
	}

	void Process::set_var_py_root_case(CaseRule *rhs)
	{
		this->get_cpp_obj()->root_case = *rhs->get_cpp_obj();
	}

	boost::python::list Process::get_var_py_syncs()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SyncRule*> ret_ = this->get_cpp_obj()->syncs;
		boost::python::list ret____tmp;
		for(auto tmp_109 : ret_)
		{
			ret____tmp.append(SyncRule::get_py_obj(tmp_109));
		}
		return ret____tmp;
	}

	void Process::set_var_py_syncs(boost::python::list rhs)
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SyncRule*> rhs___tmp;
		for(int cntr_110 = 0; cntr_110 < len(rhs); cntr_110++)
		{
			SyncRule* tmp_111 = boost::python::extract<SyncRule*>(rhs[cntr_110]);
			rhs___tmp.push_back(tmp_111->get_cpp_obj());
		}
		this->get_cpp_obj()->syncs = rhs___tmp;
	}

	IdString Process::get_var_py_name()
	{
		IdString* ret_ = IdString::get_py_obj(&this->get_cpp_obj()->name);
		return *ret_;
	}

	void Process::set_var_py_name(IdString *rhs)
	{
		this->get_cpp_obj()->name = *rhs->get_cpp_obj();
	}

	boost::python::dict Process::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_112 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_112.first)] = *Const::get_py_obj(&tmp_112.second);
		}
		return ret____tmp;
	}

	void Process::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_113 = 0; cntr_113 < len(rhs_keylist); cntr_113++)
		{
			IdString* key_tmp_114 = boost::python::extract<IdString*>(rhs_keylist[ cntr_113 ]);
			Const* val_tmp_114 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_113 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_114->get_cpp_obj(), *val_tmp_114->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "RTLIL::Process *clone() const;" in kernel/rtlil
	Process Process::clone()
	{
		Process* ret_ = Process::get_py_obj(this->get_cpp_obj()->clone());
		return *ret_;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Process::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Process::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Process::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Process::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Process::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Process::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void Process::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string Process::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Process::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_115 = 0; cntr_115 < len(data); cntr_115++)
		{
			string tmp_116 = boost::python::extract<string>(data[cntr_115]);
			data___tmp.insert(tmp_116);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Process::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_117 = 0; cntr_117 < len(data); cntr_117++)
		{
			string tmp_118 = boost::python::extract<string>(data[cntr_117]);
			data___tmp.insert(tmp_118);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list Process::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_119 : ret_)
		{
			ret____tmp.append(tmp_119);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void Process::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string Process::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	// WRAPPED from "SigChunk() : wire(nullptr), width(0), offset(0) {}" in kernel/rtlil
	SigChunk::SigChunk()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk();
	}

	// WRAPPED from "SigChunk(const RTLIL::Const &value) : wire(nullptr), data(value.to_bits()), width(GetSize(data)), offset(0) {}" in kernel/rtlil
	SigChunk::SigChunk(const Const* value)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(*value->get_cpp_obj());
	}

	// WRAPPED from "SigChunk(RTLIL::Const &&value) : wire(nullptr), data(value.to_bits()), width(GetSize(data)), offset(0) {}" in kernel/rtlil
	SigChunk::SigChunk(Const* value)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(*value->get_cpp_obj());
	}

	// WRAPPED from "SigChunk(RTLIL::Wire *wire) : wire(wire), width(GetSize(wire)), offset(0) {}" in kernel/rtlil
	SigChunk::SigChunk(Wire* wire)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(wire->get_cpp_obj());
	}

	// WRAPPED from "SigChunk(RTLIL::Wire *wire, int offset, int width = 1) : wire(wire), width(width), offset(offset) {}" in kernel/rtlil
	SigChunk::SigChunk(Wire* wire, int offset, int width)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(wire->get_cpp_obj(), offset, width);
	}

	// WRAPPED from "SigChunk(const std::string &str) : SigChunk(RTLIL::Const(str)) {}" in kernel/rtlil
	SigChunk::SigChunk(const string str)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(str);
	}

	// WRAPPED from "SigChunk(int val, int width = 32) : SigChunk(RTLIL::Const(val, width)) {}" in kernel/rtlil
	SigChunk::SigChunk(int val, int width)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(val, width);
	}

	// WRAPPED from "SigChunk(RTLIL::State bit, int width = 1) : SigChunk(RTLIL::Const(bit, width)) {}" in kernel/rtlil
	SigChunk::SigChunk(State bit, int width)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(bit, width);
	}

	// WRAPPED from "SigChunk(const RTLIL::SigBit &bit);" in kernel/rtlil
	SigChunk::SigChunk(const SigBit* bit)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigChunk(*bit->get_cpp_obj());
	}

	Wire SigChunk::get_var_py_wire()
	{
		if(this->get_cpp_obj()->wire == NULL)
			throw std::runtime_error("Member \"wire\" is NULL");
		Wire* ret_ = Wire::get_py_obj(this->get_cpp_obj()->wire);
		return *ret_;
	}

	void SigChunk::set_var_py_wire(Wire *rhs)
	{
		this->get_cpp_obj()->wire = rhs->get_cpp_obj();
	}

	boost::python::list SigChunk::get_var_py_data()
	{
		std::vector<State> ret_ = this->get_cpp_obj()->data;
		boost::python::list ret____tmp;
		for(auto tmp_120 : ret_)
		{
			ret____tmp.append(tmp_120);
		}
		return ret____tmp;
	}

	void SigChunk::set_var_py_data(boost::python::list rhs)
	{
		std::vector<State> rhs___tmp;
		for(int cntr_121 = 0; cntr_121 < len(rhs); cntr_121++)
		{
			State tmp_122 = boost::python::extract<State>(rhs[cntr_121]);
			rhs___tmp.push_back(tmp_122);
		}
		this->get_cpp_obj()->data = rhs___tmp;
	}

	int SigChunk::get_var_py_width()
	{
		int ret_ = this->get_cpp_obj()->width;
		return ret_;
	}

	void SigChunk::set_var_py_width(int rhs)
	{
		this->get_cpp_obj()->width = rhs;
	}

	int SigChunk::get_var_py_offset()
	{
		int ret_ = this->get_cpp_obj()->offset;
		return ret_;
	}

	void SigChunk::set_var_py_offset(int rhs)
	{
		this->get_cpp_obj()->offset = rhs;
	}

	// WRAPPED from "RTLIL::SigChunk extract(int offset, int length) const;" in kernel/rtlil
	SigChunk SigChunk::extract(int offset, int length)
	{
		SigChunk* ret_ = SigChunk::get_py_obj(this->get_cpp_obj()->extract(offset, length));
		return *ret_;
	}

	// WRAPPED from "inline int size() const { return width; }" in kernel/rtlil
	int SigChunk::size() const
	{
		int ret_ = this->get_cpp_obj()->size();
		return ret_;
	}

	// WRAPPED from "inline bool is_wire() const { return wire != NULL; }" in kernel/rtlil
	bool SigChunk::is_wire() const
	{
		bool ret_ = this->get_cpp_obj()->is_wire();
		return ret_;
	}

	// WRAPPED from "bool operator <(const RTLIL::SigChunk &other) const;" in kernel/rtlil
	bool SigChunk::operator<(const SigChunk* other)
	{
		bool ret_ = this->get_cpp_obj()->operator<(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool operator ==(const RTLIL::SigChunk &other) const;" in kernel/rtlil
	bool SigChunk::operator==(const SigChunk* other)
	{
		bool ret_ = this->get_cpp_obj()->operator==(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool operator !=(const RTLIL::SigChunk &other) const;" in kernel/rtlil
	bool SigChunk::operator!=(const SigChunk* other)
	{
		bool ret_ = this->get_cpp_obj()->operator!=(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "SigBit();" in kernel/rtlil
	SigBit::SigBit()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit();
	}

	// WRAPPED from "SigBit(RTLIL::State bit);" in kernel/rtlil
	SigBit::SigBit(State bit)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(bit);
	}

	// WRAPPED from "SigBit(RTLIL::Wire *wire);" in kernel/rtlil
	SigBit::SigBit(Wire* wire)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(wire->get_cpp_obj());
	}

	// WRAPPED from "SigBit(RTLIL::Wire *wire, int offset);" in kernel/rtlil
	SigBit::SigBit(Wire* wire, int offset)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(wire->get_cpp_obj(), offset);
	}

	// WRAPPED from "SigBit(const RTLIL::SigChunk &chunk);" in kernel/rtlil
	SigBit::SigBit(const SigChunk* chunk)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(*chunk->get_cpp_obj());
	}

	// WRAPPED from "SigBit(const RTLIL::SigChunk &chunk, int index);" in kernel/rtlil
	SigBit::SigBit(const SigChunk* chunk, int index)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(*chunk->get_cpp_obj(), index);
	}

	// WRAPPED from "SigBit(const RTLIL::SigSpec &sig);" in kernel/rtlil
	SigBit::SigBit(const SigSpec* sig)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(*sig->get_cpp_obj());
	}

	// WRAPPED from "SigBit(const RTLIL::SigBit &sigbit) = default;" in kernel/rtlil
	SigBit::SigBit(const SigBit* sigbit)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigBit(*sigbit->get_cpp_obj());
	}

	Wire SigBit::get_var_py_wire()
	{
		if(this->get_cpp_obj()->wire == NULL)
			throw std::runtime_error("Member \"wire\" is NULL");
		Wire* ret_ = Wire::get_py_obj(this->get_cpp_obj()->wire);
		return *ret_;
	}

	void SigBit::set_var_py_wire(Wire *rhs)
	{
		this->get_cpp_obj()->wire = rhs->get_cpp_obj();
	}

	YOSYS_NAMESPACE::RTLIL::State SigBit::get_var_py_data()
	{
		YOSYS_NAMESPACE::RTLIL::State ret_ = this->get_cpp_obj()->data;
		return ret_;
	}

	void SigBit::set_var_py_data(YOSYS_NAMESPACE::RTLIL::State rhs)
	{
		this->get_cpp_obj()->data = rhs;
	}

	int SigBit::get_var_py_offset()
	{
		int ret_ = this->get_cpp_obj()->offset;
		return ret_;
	}

	void SigBit::set_var_py_offset(int rhs)
	{
		this->get_cpp_obj()->offset = rhs;
	}

	// WRAPPED from "inline bool is_wire() const { return wire != NULL; }" in kernel/rtlil
	bool SigBit::is_wire() const
	{
		bool ret_ = this->get_cpp_obj()->is_wire();
		return ret_;
	}

	// WRAPPED from "bool operator <(const RTLIL::SigBit &other) const;" in kernel/rtlil
	bool SigBit::operator<(const SigBit* other)
	{
		bool ret_ = this->get_cpp_obj()->operator<(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool operator ==(const RTLIL::SigBit &other) const;" in kernel/rtlil
	bool SigBit::operator==(const SigBit* other)
	{
		bool ret_ = this->get_cpp_obj()->operator==(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool operator !=(const RTLIL::SigBit &other) const;" in kernel/rtlil
	bool SigBit::operator!=(const SigBit* other)
	{
		bool ret_ = this->get_cpp_obj()->operator!=(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "SigSpec() : width_(0), hash_(0) {}" in kernel/rtlil
	SigSpec::SigSpec()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec();
	}

	// WRAPPED from "SigSpec(const RTLIL::Const &value);" in kernel/rtlil
	SigSpec::SigSpec(const Const* value)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(*value->get_cpp_obj());
	}

	// WRAPPED from "SigSpec(RTLIL::Const &&value);" in kernel/rtlil
	SigSpec::SigSpec(Const* value)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(*value->get_cpp_obj());
	}

	// WRAPPED from "SigSpec(const RTLIL::SigChunk &chunk);" in kernel/rtlil
	SigSpec::SigSpec(const SigChunk* chunk)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(*chunk->get_cpp_obj());
	}

	// WRAPPED from "SigSpec(RTLIL::SigChunk &&chunk);" in kernel/rtlil
	SigSpec::SigSpec(SigChunk* chunk)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(*chunk->get_cpp_obj());
	}

	// WRAPPED from "SigSpec(RTLIL::Wire *wire);" in kernel/rtlil
	SigSpec::SigSpec(Wire* wire)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(wire->get_cpp_obj());
	}

	// WRAPPED from "SigSpec(RTLIL::Wire *wire, int offset, int width = 1);" in kernel/rtlil
	SigSpec::SigSpec(Wire* wire, int offset, int width)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(wire->get_cpp_obj(), offset, width);
	}

	// WRAPPED from "SigSpec(const std::string &str);" in kernel/rtlil
	SigSpec::SigSpec(const string str)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(str);
	}

	// WRAPPED from "SigSpec(int val, int width = 32);" in kernel/rtlil
	SigSpec::SigSpec(int val, int width)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(val, width);
	}

	// WRAPPED from "SigSpec(RTLIL::State bit, int width = 1);" in kernel/rtlil
	SigSpec::SigSpec(State bit, int width)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(bit, width);
	}

	// WRAPPED from "SigSpec(const RTLIL::SigBit &bit, int width = 1);" in kernel/rtlil
	SigSpec::SigSpec(const SigBit* bit, int width)
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(*bit->get_cpp_obj(), width);
	}

	// WRAPPED from "SigSpec(const std::vector<RTLIL::SigChunk> &chunks);" in kernel/rtlil
	SigSpec::SigSpec(const boost::python::list chunks)
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SigChunk> chunks___tmp;
		for(int cntr_123 = 0; cntr_123 < len(chunks); cntr_123++)
		{
			SigChunk* tmp_124 = boost::python::extract<SigChunk*>(chunks[cntr_123]);
			chunks___tmp.push_back(*tmp_124->get_cpp_obj());
		}
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::SigSpec(chunks___tmp);
	}

	// WRAPPED from "inline const std::vector<RTLIL::SigChunk> &chunks() const { pack(); return chunks_; }" in kernel/rtlil
	boost::python::list SigSpec::chunks() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SigChunk> ret_ = this->get_cpp_obj()->chunks();
		boost::python::list ret____tmp;
		for(auto tmp_125 : ret_)
		{
			ret____tmp.append(*SigChunk::get_py_obj(&tmp_125));
		}
		return ret____tmp;
	}

	// WRAPPED from "inline const std::vector<RTLIL::SigBit> &bits() const { inline_unpack(); return bits_; }" in kernel/rtlil
	boost::python::list SigSpec::bits() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SigBit> ret_ = this->get_cpp_obj()->bits();
		boost::python::list ret____tmp;
		for(auto tmp_126 : ret_)
		{
			ret____tmp.append(*SigBit::get_py_obj(&tmp_126));
		}
		return ret____tmp;
	}

	// WRAPPED from "inline int size() const { return width_; }" in kernel/rtlil
	int SigSpec::size() const
	{
		int ret_ = this->get_cpp_obj()->size();
		return ret_;
	}

	// WRAPPED from "inline bool empty() const { return width_ == 0; }" in kernel/rtlil
	bool SigSpec::empty() const
	{
		bool ret_ = this->get_cpp_obj()->empty();
		return ret_;
	}

	// WRAPPED from "void sort();" in kernel/rtlil
	void SigSpec::sort()
	{
		this->get_cpp_obj()->sort();
	}

	// WRAPPED from "void sort_and_unify();" in kernel/rtlil
	void SigSpec::sort_and_unify()
	{
		this->get_cpp_obj()->sort_and_unify();
	}

	// WRAPPED from "void replace(const RTLIL::SigSpec &pattern, const RTLIL::SigSpec &with);" in kernel/rtlil
	void SigSpec::replace(const SigSpec* pattern, const SigSpec* with)
	{
		this->get_cpp_obj()->replace(*pattern->get_cpp_obj(), *with->get_cpp_obj());
	}

	// WRAPPED from "void replace(const RTLIL::SigSpec &pattern, const RTLIL::SigSpec &with, RTLIL::SigSpec *other) const;" in kernel/rtlil
	void SigSpec::replace(const SigSpec* pattern, const SigSpec* with, SigSpec* other)
	{
		this->get_cpp_obj()->replace(*pattern->get_cpp_obj(), *with->get_cpp_obj(), other->get_cpp_obj());
	}

	// WRAPPED from "void replace(int offset, const RTLIL::SigSpec &with);" in kernel/rtlil
	void SigSpec::replace(int offset, const SigSpec* with)
	{
		this->get_cpp_obj()->replace(offset, *with->get_cpp_obj());
	}

	// WRAPPED from "void remove(const RTLIL::SigSpec &pattern);" in kernel/rtlil
	void SigSpec::remove(const SigSpec* pattern)
	{
		this->get_cpp_obj()->remove(*pattern->get_cpp_obj());
	}

	// WRAPPED from "void remove(const RTLIL::SigSpec &pattern, RTLIL::SigSpec *other) const;" in kernel/rtlil
	void SigSpec::remove(const SigSpec* pattern, SigSpec* other)
	{
		this->get_cpp_obj()->remove(*pattern->get_cpp_obj(), other->get_cpp_obj());
	}

	// WRAPPED from "void remove2(const RTLIL::SigSpec &pattern, RTLIL::SigSpec *other);" in kernel/rtlil
	void SigSpec::remove2(const SigSpec* pattern, SigSpec* other)
	{
		this->get_cpp_obj()->remove2(*pattern->get_cpp_obj(), other->get_cpp_obj());
	}

	// WRAPPED from "void remove(const pool<RTLIL::SigBit> &pattern);" in kernel/rtlil
	void SigSpec::remove(const boost::python::list pattern)
	{
		pool<YOSYS_NAMESPACE::RTLIL::SigBit> pattern___tmp;
		for(int cntr_127 = 0; cntr_127 < len(pattern); cntr_127++)
		{
			SigBit* tmp_128 = boost::python::extract<SigBit*>(pattern[cntr_127]);
			pattern___tmp.insert(*tmp_128->get_cpp_obj());
		}
		this->get_cpp_obj()->remove(pattern___tmp);
	}

	// WRAPPED from "void remove(const pool<RTLIL::SigBit> &pattern, RTLIL::SigSpec *other) const;" in kernel/rtlil
	void SigSpec::remove(const boost::python::list pattern, SigSpec* other)
	{
		pool<YOSYS_NAMESPACE::RTLIL::SigBit> pattern___tmp;
		for(int cntr_129 = 0; cntr_129 < len(pattern); cntr_129++)
		{
			SigBit* tmp_130 = boost::python::extract<SigBit*>(pattern[cntr_129]);
			pattern___tmp.insert(*tmp_130->get_cpp_obj());
		}
		this->get_cpp_obj()->remove(pattern___tmp, other->get_cpp_obj());
	}

	// WRAPPED from "void remove2(const pool<RTLIL::SigBit> &pattern, RTLIL::SigSpec *other);" in kernel/rtlil
	void SigSpec::remove2__pool_YOSYS_NAMESPACE_RTLIL_SigBit___YOSYS_NAMESPACE_RTLIL_SigSpec(const boost::python::list pattern, SigSpec* other)
	{
		pool<YOSYS_NAMESPACE::RTLIL::SigBit> pattern___tmp;
		for(int cntr_131 = 0; cntr_131 < len(pattern); cntr_131++)
		{
			SigBit* tmp_132 = boost::python::extract<SigBit*>(pattern[cntr_131]);
			pattern___tmp.insert(*tmp_132->get_cpp_obj());
		}
		this->get_cpp_obj()->remove2(pattern___tmp, other->get_cpp_obj());
	}

	// WRAPPED from "void remove2(const std::set<RTLIL::SigBit> &pattern, RTLIL::SigSpec *other);" in kernel/rtlil
	void SigSpec::remove2__std_set_YOSYS_NAMESPACE_RTLIL_SigBit___YOSYS_NAMESPACE_RTLIL_SigSpec(const boost::python::list pattern, SigSpec* other)
	{
		std::set<YOSYS_NAMESPACE::RTLIL::SigBit> pattern___tmp;
		for(int cntr_133 = 0; cntr_133 < len(pattern); cntr_133++)
		{
			SigBit* tmp_134 = boost::python::extract<SigBit*>(pattern[cntr_133]);
			pattern___tmp.insert(*tmp_134->get_cpp_obj());
		}
		this->get_cpp_obj()->remove2(pattern___tmp, other->get_cpp_obj());
	}

	// WRAPPED from "void remove2(const pool<RTLIL::Wire*> &pattern, RTLIL::SigSpec *other);" in kernel/rtlil
	void SigSpec::remove2__pool_YOSYS_NAMESPACE_RTLIL_Wire___YOSYS_NAMESPACE_RTLIL_SigSpec(const boost::python::list pattern, SigSpec* other)
	{
		pool<YOSYS_NAMESPACE::RTLIL::Wire*> pattern___tmp;
		for(int cntr_135 = 0; cntr_135 < len(pattern); cntr_135++)
		{
			Wire* tmp_136 = boost::python::extract<Wire*>(pattern[cntr_135]);
			pattern___tmp.insert(tmp_136->get_cpp_obj());
		}
		this->get_cpp_obj()->remove2(pattern___tmp, other->get_cpp_obj());
	}

	// WRAPPED from "void remove(int offset, int length = 1);" in kernel/rtlil
	void SigSpec::remove(int offset)
	{
		this->get_cpp_obj()->remove(offset);
	}

	// WRAPPED from "void remove(int offset, int length = 1);" in kernel/rtlil
	void SigSpec::remove(int offset, int length)
	{
		this->get_cpp_obj()->remove(offset, length);
	}

	// WRAPPED from "void remove_const();" in kernel/rtlil
	void SigSpec::remove_const()
	{
		this->get_cpp_obj()->remove_const();
	}

	// WRAPPED from "RTLIL::SigSpec extract(const RTLIL::SigSpec &pattern, const RTLIL::SigSpec *other = NULL) const;" in kernel/rtlil
	SigSpec SigSpec::extract(const SigSpec* pattern, const SigSpec* other)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->extract(*pattern->get_cpp_obj(), other->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec extract(const pool<RTLIL::SigBit> &pattern, const RTLIL::SigSpec *other = NULL) const;" in kernel/rtlil
	SigSpec SigSpec::extract(const boost::python::list pattern, const SigSpec* other)
	{
		pool<YOSYS_NAMESPACE::RTLIL::SigBit> pattern___tmp;
		for(int cntr_137 = 0; cntr_137 < len(pattern); cntr_137++)
		{
			SigBit* tmp_138 = boost::python::extract<SigBit*>(pattern[cntr_137]);
			pattern___tmp.insert(*tmp_138->get_cpp_obj());
		}
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->extract(pattern___tmp, other->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec extract(int offset, int length = 1) const;" in kernel/rtlil
	SigSpec SigSpec::extract(int offset)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->extract(offset));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec extract(int offset, int length = 1) const;" in kernel/rtlil
	SigSpec SigSpec::extract(int offset, int length)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->extract(offset, length));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec extract_end(int offset) const { return extract(offset, width_ - offset); }" in kernel/rtlil
	SigSpec SigSpec::extract_end(int offset) const
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->extract_end(offset));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit lsb() const { log_assert(width_); return(*this)[0]; };" in kernel/rtlil
	SigBit SigSpec::lsb() const
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->lsb());
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit msb() const { log_assert(width_); return(*this)[width_ - 1]; };" in kernel/rtlil
	SigBit SigSpec::msb() const
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->msb());
		return *ret_;
	}

	// WRAPPED from "void append(const RTLIL::SigSpec &signal);" in kernel/rtlil
	void SigSpec::append(const SigSpec* signal)
	{
		this->get_cpp_obj()->append(*signal->get_cpp_obj());
	}

	// WRAPPED from "inline void append(Wire *wire) { append(RTLIL::SigSpec(wire)); }" in kernel/rtlil
	void SigSpec::append(Wire* wire)
	{
		this->get_cpp_obj()->append(wire->get_cpp_obj());
	}

	// WRAPPED from "inline void append(const RTLIL::SigChunk &chunk) { append(RTLIL::SigSpec(chunk)); }" in kernel/rtlil
	void SigSpec::append(const SigChunk* chunk)
	{
		this->get_cpp_obj()->append(*chunk->get_cpp_obj());
	}

	// WRAPPED from "inline void append(const RTLIL::Const &const_) { append(RTLIL::SigSpec(const_)); }" in kernel/rtlil
	void SigSpec::append(const Const* const_)
	{
		this->get_cpp_obj()->append(*const_->get_cpp_obj());
	}

	// WRAPPED from "void append(const RTLIL::SigBit &bit);" in kernel/rtlil
	void SigSpec::append(const SigBit* bit)
	{
		this->get_cpp_obj()->append(*bit->get_cpp_obj());
	}

	// WRAPPED from "inline void append(RTLIL::State state) { append(RTLIL::SigBit(state)); }" in kernel/rtlil
	void SigSpec::append(State state)
	{
		this->get_cpp_obj()->append(state);
	}

	// WRAPPED from "inline void append(bool bool_) { append(RTLIL::SigBit(bool_)); }" in kernel/rtlil
	void SigSpec::append(bool bool_)
	{
		this->get_cpp_obj()->append(bool_);
	}

	// WRAPPED from "void extend_u0(int width, bool is_signed = false);" in kernel/rtlil
	void SigSpec::extend_u0(int width)
	{
		this->get_cpp_obj()->extend_u0(width);
	}

	// WRAPPED from "void extend_u0(int width, bool is_signed = false);" in kernel/rtlil
	void SigSpec::extend_u0(int width, bool is_signed)
	{
		this->get_cpp_obj()->extend_u0(width, is_signed);
	}

	// WRAPPED from "RTLIL::SigSpec repeat(int num) const;" in kernel/rtlil
	SigSpec SigSpec::repeat(int num)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->repeat(num));
		return *ret_;
	}

	// WRAPPED from "void reverse() { inline_unpack(); std::reverse(bits_.begin(), bits_.end()); }" in kernel/rtlil
	void SigSpec::reverse()
	{
		this->get_cpp_obj()->reverse();
	}

	// WRAPPED from "bool operator <(const RTLIL::SigSpec &other) const;" in kernel/rtlil
	bool SigSpec::operator<(const SigSpec* other)
	{
		bool ret_ = this->get_cpp_obj()->operator<(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool operator ==(const RTLIL::SigSpec &other) const;" in kernel/rtlil
	bool SigSpec::operator==(const SigSpec* other)
	{
		bool ret_ = this->get_cpp_obj()->operator==(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "inline bool operator !=(const RTLIL::SigSpec &other) const { return !(*this == other); }" in kernel/rtlil
	bool SigSpec::operator!=(const SigSpec* other) const
	{
		bool ret_ = this->get_cpp_obj()->operator!=(*other->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool is_wire() const;" in kernel/rtlil
	bool SigSpec::is_wire()
	{
		bool ret_ = this->get_cpp_obj()->is_wire();
		return ret_;
	}

	// WRAPPED from "bool is_chunk() const;" in kernel/rtlil
	bool SigSpec::is_chunk()
	{
		bool ret_ = this->get_cpp_obj()->is_chunk();
		return ret_;
	}

	// WRAPPED from "inline bool is_bit() const { return width_ == 1; }" in kernel/rtlil
	bool SigSpec::is_bit() const
	{
		bool ret_ = this->get_cpp_obj()->is_bit();
		return ret_;
	}

	// WRAPPED from "bool is_fully_const() const;" in kernel/rtlil
	bool SigSpec::is_fully_const()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_const();
		return ret_;
	}

	// WRAPPED from "bool is_fully_zero() const;" in kernel/rtlil
	bool SigSpec::is_fully_zero()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_zero();
		return ret_;
	}

	// WRAPPED from "bool is_fully_ones() const;" in kernel/rtlil
	bool SigSpec::is_fully_ones()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_ones();
		return ret_;
	}

	// WRAPPED from "bool is_fully_def() const;" in kernel/rtlil
	bool SigSpec::is_fully_def()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_def();
		return ret_;
	}

	// WRAPPED from "bool is_fully_undef() const;" in kernel/rtlil
	bool SigSpec::is_fully_undef()
	{
		bool ret_ = this->get_cpp_obj()->is_fully_undef();
		return ret_;
	}

	// WRAPPED from "bool has_const() const;" in kernel/rtlil
	bool SigSpec::has_const()
	{
		bool ret_ = this->get_cpp_obj()->has_const();
		return ret_;
	}

	// WRAPPED from "bool has_marked_bits() const;" in kernel/rtlil
	bool SigSpec::has_marked_bits()
	{
		bool ret_ = this->get_cpp_obj()->has_marked_bits();
		return ret_;
	}

	// WRAPPED from "bool is_onehot(int *pos = nullptr) const;" in kernel/rtlil
	bool SigSpec::is_onehot()
	{
		bool ret_ = this->get_cpp_obj()->is_onehot();
		return ret_;
	}

	// WRAPPED from "bool is_onehot(int *pos = nullptr) const;" in kernel/rtlil
	bool SigSpec::is_onehot(int pos)
	{
		bool ret_ = this->get_cpp_obj()->is_onehot(&pos);
		return ret_;
	}

	// WRAPPED from "bool as_bool() const;" in kernel/rtlil
	bool SigSpec::as_bool()
	{
		bool ret_ = this->get_cpp_obj()->as_bool();
		return ret_;
	}

	// WRAPPED from "int as_int(bool is_signed = false) const;" in kernel/rtlil
	int SigSpec::as_int()
	{
		int ret_ = this->get_cpp_obj()->as_int();
		return ret_;
	}

	// WRAPPED from "int as_int(bool is_signed = false) const;" in kernel/rtlil
	int SigSpec::as_int(bool is_signed)
	{
		int ret_ = this->get_cpp_obj()->as_int(is_signed);
		return ret_;
	}

	// WRAPPED from "bool convertible_to_int(bool is_signed = false) const;" in kernel/rtlil
	bool SigSpec::convertible_to_int()
	{
		bool ret_ = this->get_cpp_obj()->convertible_to_int();
		return ret_;
	}

	// WRAPPED from "bool convertible_to_int(bool is_signed = false) const;" in kernel/rtlil
	bool SigSpec::convertible_to_int(bool is_signed)
	{
		bool ret_ = this->get_cpp_obj()->convertible_to_int(is_signed);
		return ret_;
	}

	// WRAPPED from "int as_int_saturating(bool is_signed = false) const;" in kernel/rtlil
	int SigSpec::as_int_saturating()
	{
		int ret_ = this->get_cpp_obj()->as_int_saturating();
		return ret_;
	}

	// WRAPPED from "int as_int_saturating(bool is_signed = false) const;" in kernel/rtlil
	int SigSpec::as_int_saturating(bool is_signed)
	{
		int ret_ = this->get_cpp_obj()->as_int_saturating(is_signed);
		return ret_;
	}

	// WRAPPED from "std::string as_string() const;" in kernel/rtlil
	string SigSpec::as_string()
	{
		string ret_ = this->get_cpp_obj()->as_string();
		return ret_;
	}

	// WRAPPED from "RTLIL::Const as_const() const;" in kernel/rtlil
	Const SigSpec::as_const()
	{
		Const* ret_ = Const::get_py_obj(this->get_cpp_obj()->as_const());
		return *ret_;
	}

	// WRAPPED from "RTLIL::Wire *as_wire() const;" in kernel/rtlil
	Wire SigSpec::as_wire()
	{
		Wire* ret_ = Wire::get_py_obj(this->get_cpp_obj()->as_wire());
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigChunk as_chunk() const;" in kernel/rtlil
	SigChunk SigSpec::as_chunk()
	{
		SigChunk* ret_ = SigChunk::get_py_obj(this->get_cpp_obj()->as_chunk());
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit as_bit() const;" in kernel/rtlil
	SigBit SigSpec::as_bit()
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->as_bit());
		return *ret_;
	}

	// WRAPPED from "bool match(const char_p pattern) const;" in kernel/rtlil
	bool SigSpec::match(const char * pattern)
	{
		bool ret_ = this->get_cpp_obj()->match(pattern);
		return ret_;
	}

	// WRAPPED from "std::set<RTLIL::SigBit> to_sigbit_set() const;" in kernel/rtlil
	boost::python::list SigSpec::to_sigbit_set()
	{
		std::set<YOSYS_NAMESPACE::RTLIL::SigBit> ret_ = this->get_cpp_obj()->to_sigbit_set();
		boost::python::list ret____tmp;
		for(auto tmp_139 : ret_)
		{
			ret____tmp.append(*SigBit::get_py_obj(&tmp_139));
		}
		return ret____tmp;
	}

	// WRAPPED from "pool<RTLIL::SigBit> to_sigbit_pool() const;" in kernel/rtlil
	boost::python::list SigSpec::to_sigbit_pool()
	{
		pool<YOSYS_NAMESPACE::RTLIL::SigBit> ret_ = this->get_cpp_obj()->to_sigbit_pool();
		boost::python::list ret____tmp;
		for(auto tmp_140 : ret_)
		{
			ret____tmp.append(*SigBit::get_py_obj(&tmp_140));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::SigBit> to_sigbit_vector() const;" in kernel/rtlil
	boost::python::list SigSpec::to_sigbit_vector()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::SigBit> ret_ = this->get_cpp_obj()->to_sigbit_vector();
		boost::python::list ret____tmp;
		for(auto tmp_141 : ret_)
		{
			ret____tmp.append(*SigBit::get_py_obj(&tmp_141));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::map<RTLIL::SigBit, RTLIL::SigBit> to_sigbit_map(const RTLIL::SigSpec &other) const;" in kernel/rtlil
	boost::python::dict SigSpec::to_sigbit_map(const SigSpec* other)
	{
		std::map<YOSYS_NAMESPACE::RTLIL::SigBit, YOSYS_NAMESPACE::RTLIL::SigBit> ret_ = this->get_cpp_obj()->to_sigbit_map(*other->get_cpp_obj());
		boost::python::dict ret____tmp;
		for(auto tmp_142 : ret_)
		{
			ret____tmp[SigBit::get_py_obj(tmp_142.first)] = *SigBit::get_py_obj(&tmp_142.second);
		}
		return ret____tmp;
	}

	// WRAPPED from "dict<RTLIL::SigBit, RTLIL::SigBit> to_sigbit_dict(const RTLIL::SigSpec &other) const;" in kernel/rtlil
	boost::python::dict SigSpec::to_sigbit_dict(const SigSpec* other)
	{
		dict<YOSYS_NAMESPACE::RTLIL::SigBit, YOSYS_NAMESPACE::RTLIL::SigBit> ret_ = this->get_cpp_obj()->to_sigbit_dict(*other->get_cpp_obj());
		boost::python::dict ret____tmp;
		for(auto tmp_143 : ret_)
		{
			ret____tmp[SigBit::get_py_obj(tmp_143.first)] = *SigBit::get_py_obj(&tmp_143.second);
		}
		return ret____tmp;
	}

	// WRAPPED from "static bool parse(RTLIL::SigSpec &sig, RTLIL::Module *module, std::string str);" in kernel/rtlil
	bool SigSpec::parse(SigSpec* sig, Module* module, string str)
	{
		bool ret_ = YOSYS_NAMESPACE::RTLIL::SigSpec::parse(*sig->get_cpp_obj(), module->get_cpp_obj(), str);
		return ret_;
	}

	// WRAPPED from "static bool parse_sel(RTLIL::SigSpec &sig, RTLIL::Design *design, RTLIL::Module *module, std::string str);" in kernel/rtlil
	bool SigSpec::parse_sel(SigSpec* sig, Design* design, Module* module, string str)
	{
		bool ret_ = YOSYS_NAMESPACE::RTLIL::SigSpec::parse_sel(*sig->get_cpp_obj(), design->get_cpp_obj(), module->get_cpp_obj(), str);
		return ret_;
	}

	// WRAPPED from "static bool parse_rhs(const RTLIL::SigSpec &lhs, RTLIL::SigSpec &sig, RTLIL::Module *module, std::string str);" in kernel/rtlil
	bool SigSpec::parse_rhs(const SigSpec* lhs, SigSpec* sig, Module* module, string str)
	{
		bool ret_ = YOSYS_NAMESPACE::RTLIL::SigSpec::parse_rhs(*lhs->get_cpp_obj(), *sig->get_cpp_obj(), module->get_cpp_obj(), str);
		return ret_;
	}

	// WRAPPED from "const RTLIL::SigBit &at(int offset, const RTLIL::SigBit &defval) { return offset < width_ ?(*this)[offset] : defval; }" in kernel/rtlil
	SigBit SigSpec::at(int offset, const SigBit* defval)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->at(offset, *defval->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "void check(Module *mod = nullptr) const;" in kernel/rtlil
	void SigSpec::check()
	{
		this->get_cpp_obj()->check();
	}

	// WRAPPED from "void check(Module *mod = nullptr) const;" in kernel/rtlil
	void SigSpec::check(Module* mod)
	{
		this->get_cpp_obj()->check(mod->get_cpp_obj());
	}

	Module Cell::get_var_py_module()
	{
		if(this->get_cpp_obj()->module == NULL)
			throw std::runtime_error("Member \"module\" is NULL");
		Module* ret_ = Module::get_py_obj(this->get_cpp_obj()->module);
		return *ret_;
	}

	void Cell::set_var_py_module(Module *rhs)
	{
		this->get_cpp_obj()->module = rhs->get_cpp_obj();
	}

	IdString Cell::get_var_py_type()
	{
		IdString* ret_ = IdString::get_py_obj(&this->get_cpp_obj()->type);
		return *ret_;
	}

	void Cell::set_var_py_type(IdString *rhs)
	{
		this->get_cpp_obj()->type = *rhs->get_cpp_obj();
	}

	boost::python::dict Cell::get_var_py_connections_()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::SigSpec> ret_ = this->get_cpp_obj()->connections_;
		boost::python::dict ret____tmp;
		for(auto tmp_144 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_144.first)] = *SigSpec::get_py_obj(&tmp_144.second);
		}
		return ret____tmp;
	}

	void Cell::set_var_py_connections_(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::SigSpec> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_145 = 0; cntr_145 < len(rhs_keylist); cntr_145++)
		{
			IdString* key_tmp_146 = boost::python::extract<IdString*>(rhs_keylist[ cntr_145 ]);
			SigSpec* val_tmp_146 = boost::python::extract<SigSpec*>(rhs[rhs_keylist[ cntr_145 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::SigSpec>(*key_tmp_146->get_cpp_obj(), *val_tmp_146->get_cpp_obj()));

		}
		this->get_cpp_obj()->connections_ = rhs___tmp;
	}

	boost::python::dict Cell::get_var_py_parameters()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->parameters;
		boost::python::dict ret____tmp;
		for(auto tmp_147 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_147.first)] = *Const::get_py_obj(&tmp_147.second);
		}
		return ret____tmp;
	}

	void Cell::set_var_py_parameters(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_148 = 0; cntr_148 < len(rhs_keylist); cntr_148++)
		{
			IdString* key_tmp_149 = boost::python::extract<IdString*>(rhs_keylist[ cntr_148 ]);
			Const* val_tmp_149 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_148 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_149->get_cpp_obj(), *val_tmp_149->get_cpp_obj()));

		}
		this->get_cpp_obj()->parameters = rhs___tmp;
	}

	IdString Cell::get_var_py_name()
	{
		IdString* ret_ = IdString::get_py_obj(&this->get_cpp_obj()->name);
		return *ret_;
	}

	void Cell::set_var_py_name(IdString *rhs)
	{
		this->get_cpp_obj()->name = *rhs->get_cpp_obj();
	}

	boost::python::dict Cell::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_150 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_150.first)] = *Const::get_py_obj(&tmp_150.second);
		}
		return ret____tmp;
	}

	void Cell::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_151 = 0; cntr_151 < len(rhs_keylist); cntr_151++)
		{
			IdString* key_tmp_152 = boost::python::extract<IdString*>(rhs_keylist[ cntr_151 ]);
			Const* val_tmp_152 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_151 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_152->get_cpp_obj(), *val_tmp_152->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "bool hasPort(const RTLIL::IdString &portname) const;" in kernel/rtlil
	bool Cell::hasPort(const IdString* portname)
	{
		bool ret_ = this->get_cpp_obj()->hasPort(*portname->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void unsetPort(const RTLIL::IdString &portname);" in kernel/rtlil
	void Cell::unsetPort(const IdString* portname)
	{
		this->get_cpp_obj()->unsetPort(*portname->get_cpp_obj());
	}

	// WRAPPED from "void setPort(const RTLIL::IdString &portname, RTLIL::SigSpec signal);" in kernel/rtlil
	void Cell::setPort(const IdString* portname, SigSpec* signal)
	{
		this->get_cpp_obj()->setPort(*portname->get_cpp_obj(), *signal->get_cpp_obj());
	}

	// WRAPPED from "const RTLIL::SigSpec &getPort(const RTLIL::IdString &portname) const;" in kernel/rtlil
	SigSpec Cell::getPort(const IdString* portname)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->getPort(*portname->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "const dict<RTLIL::IdString, RTLIL::SigSpec> &connections() const;" in kernel/rtlil
	boost::python::dict Cell::connections()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::SigSpec> ret_ = this->get_cpp_obj()->connections();
		boost::python::dict ret____tmp;
		for(auto tmp_153 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_153.first)] = *SigSpec::get_py_obj(&tmp_153.second);
		}
		return ret____tmp;
	}

	// WRAPPED from "bool known() const;" in kernel/rtlil
	bool Cell::known()
	{
		bool ret_ = this->get_cpp_obj()->known();
		return ret_;
	}

	// WRAPPED from "bool input(const RTLIL::IdString &portname) const;" in kernel/rtlil
	bool Cell::input(const IdString* portname)
	{
		bool ret_ = this->get_cpp_obj()->input(*portname->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool output(const RTLIL::IdString &portname) const;" in kernel/rtlil
	bool Cell::output(const IdString* portname)
	{
		bool ret_ = this->get_cpp_obj()->output(*portname->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool hasParam(const RTLIL::IdString &paramname) const;" in kernel/rtlil
	bool Cell::hasParam(const IdString* paramname)
	{
		bool ret_ = this->get_cpp_obj()->hasParam(*paramname->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void unsetParam(const RTLIL::IdString &paramname);" in kernel/rtlil
	void Cell::unsetParam(const IdString* paramname)
	{
		this->get_cpp_obj()->unsetParam(*paramname->get_cpp_obj());
	}

	// WRAPPED from "void setParam(const RTLIL::IdString &paramname, RTLIL::Const value);" in kernel/rtlil
	void Cell::setParam(const IdString* paramname, Const* value)
	{
		this->get_cpp_obj()->setParam(*paramname->get_cpp_obj(), *value->get_cpp_obj());
	}

	// WRAPPED from "const RTLIL::Const &getParam(const RTLIL::IdString &paramname) const;" in kernel/rtlil
	Const Cell::getParam(const IdString* paramname)
	{
		Const* ret_ = Const::get_py_obj(this->get_cpp_obj()->getParam(*paramname->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "void sort();" in kernel/rtlil
	void Cell::sort()
	{
		this->get_cpp_obj()->sort();
	}

	// WRAPPED from "void check();" in kernel/rtlil
	void Cell::check()
	{
		this->get_cpp_obj()->check();
	}

	// WRAPPED from "void fixup_parameters(bool set_a_signed = false, bool set_b_signed = false);" in kernel/rtlil
	void Cell::fixup_parameters()
	{
		this->get_cpp_obj()->fixup_parameters();
	}

	// WRAPPED from "void fixup_parameters(bool set_a_signed = false, bool set_b_signed = false);" in kernel/rtlil
	void Cell::fixup_parameters(bool set_a_signed)
	{
		this->get_cpp_obj()->fixup_parameters(set_a_signed);
	}

	// WRAPPED from "void fixup_parameters(bool set_a_signed = false, bool set_b_signed = false);" in kernel/rtlil
	void Cell::fixup_parameters(bool set_a_signed, bool set_b_signed)
	{
		this->get_cpp_obj()->fixup_parameters(set_a_signed, set_b_signed);
	}

	// WRAPPED from "bool has_keep_attr() const {" in kernel/rtlil
	bool Cell::has_keep_attr() const
	{
		bool ret_ = this->get_cpp_obj()->has_keep_attr();
		return ret_;
	}

	// WRAPPED from "static std::map<unsigned int, RTLIL::Cell*> *get_all_cells(void);" in kernel/rtlil
	boost::python::dict Cell::get_all_cells(void )
	{
		std::map<unsigned int, YOSYS_NAMESPACE::RTLIL::Cell*>* ret_ = YOSYS_NAMESPACE::RTLIL::Cell::get_all_cells();
		boost::python::dict ret____tmp;
		for(auto tmp_154 : *ret_)
		{
			ret____tmp[tmp_154.first] = Cell::get_py_obj(tmp_154.second);
		}
		return ret____tmp;
	}

	// WRAPPED from "bool has_memid() const;" in kernel/rtlil
	bool Cell::has_memid()
	{
		bool ret_ = this->get_cpp_obj()->has_memid();
		return ret_;
	}

	// WRAPPED from "bool is_mem_cell() const;" in kernel/rtlil
	bool Cell::is_mem_cell()
	{
		bool ret_ = this->get_cpp_obj()->is_mem_cell();
		return ret_;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Cell::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Cell::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Cell::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Cell::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Cell::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Cell::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void Cell::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string Cell::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Cell::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_155 = 0; cntr_155 < len(data); cntr_155++)
		{
			string tmp_156 = boost::python::extract<string>(data[cntr_155]);
			data___tmp.insert(tmp_156);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Cell::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_157 = 0; cntr_157 < len(data); cntr_157++)
		{
			string tmp_158 = boost::python::extract<string>(data[cntr_157]);
			data___tmp.insert(tmp_158);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list Cell::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_159 : ret_)
		{
			ret____tmp.append(tmp_159);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void Cell::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string Cell::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	Module Wire::get_var_py_module()
	{
		if(this->get_cpp_obj()->module == NULL)
			throw std::runtime_error("Member \"module\" is NULL");
		Module* ret_ = Module::get_py_obj(this->get_cpp_obj()->module);
		return *ret_;
	}

	void Wire::set_var_py_module(Module *rhs)
	{
		this->get_cpp_obj()->module = rhs->get_cpp_obj();
	}

	int Wire::get_var_py_width()
	{
		int ret_ = this->get_cpp_obj()->width;
		return ret_;
	}

	void Wire::set_var_py_width(int rhs)
	{
		this->get_cpp_obj()->width = rhs;
	}

	int Wire::get_var_py_start_offset()
	{
		int ret_ = this->get_cpp_obj()->start_offset;
		return ret_;
	}

	void Wire::set_var_py_start_offset(int rhs)
	{
		this->get_cpp_obj()->start_offset = rhs;
	}

	int Wire::get_var_py_port_id()
	{
		int ret_ = this->get_cpp_obj()->port_id;
		return ret_;
	}

	void Wire::set_var_py_port_id(int rhs)
	{
		this->get_cpp_obj()->port_id = rhs;
	}

	bool Wire::get_var_py_port_input()
	{
		bool ret_ = this->get_cpp_obj()->port_input;
		return ret_;
	}

	void Wire::set_var_py_port_input(bool rhs)
	{
		this->get_cpp_obj()->port_input = rhs;
	}

	bool Wire::get_var_py_port_output()
	{
		bool ret_ = this->get_cpp_obj()->port_output;
		return ret_;
	}

	void Wire::set_var_py_port_output(bool rhs)
	{
		this->get_cpp_obj()->port_output = rhs;
	}

	bool Wire::get_var_py_upto()
	{
		bool ret_ = this->get_cpp_obj()->upto;
		return ret_;
	}

	void Wire::set_var_py_upto(bool rhs)
	{
		this->get_cpp_obj()->upto = rhs;
	}

	bool Wire::get_var_py_is_signed()
	{
		bool ret_ = this->get_cpp_obj()->is_signed;
		return ret_;
	}

	void Wire::set_var_py_is_signed(bool rhs)
	{
		this->get_cpp_obj()->is_signed = rhs;
	}

	IdString Wire::get_var_py_name()
	{
		IdString* ret_ = IdString::get_py_obj(&this->get_cpp_obj()->name);
		return *ret_;
	}

	void Wire::set_var_py_name(IdString *rhs)
	{
		this->get_cpp_obj()->name = *rhs->get_cpp_obj();
	}

	boost::python::dict Wire::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_160 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_160.first)] = *Const::get_py_obj(&tmp_160.second);
		}
		return ret____tmp;
	}

	void Wire::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_161 = 0; cntr_161 < len(rhs_keylist); cntr_161++)
		{
			IdString* key_tmp_162 = boost::python::extract<IdString*>(rhs_keylist[ cntr_161 ]);
			Const* val_tmp_162 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_161 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_162->get_cpp_obj(), *val_tmp_162->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "RTLIL::Cell *driverCell() const { log_assert(driverCell_); return driverCell_; };" in kernel/rtlil
	Cell Wire::driverCell() const
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->driverCell());
		return *ret_;
	}

	// WRAPPED from "RTLIL::IdString driverPort() const { log_assert(driverCell_); return driverPort_; };" in kernel/rtlil
	IdString Wire::driverPort() const
	{
		IdString* ret_ = IdString::get_py_obj(this->get_cpp_obj()->driverPort());
		return *ret_;
	}

	// WRAPPED from "int from_hdl_index(int hdl_index) {" in kernel/rtlil
	int Wire::from_hdl_index(int hdl_index)
	{
		int ret_ = this->get_cpp_obj()->from_hdl_index(hdl_index);
		return ret_;
	}

	// WRAPPED from "int to_hdl_index(int rtlil_index) {" in kernel/rtlil
	int Wire::to_hdl_index(int rtlil_index)
	{
		int ret_ = this->get_cpp_obj()->to_hdl_index(rtlil_index);
		return ret_;
	}

	// WRAPPED from "static std::map<unsigned int, RTLIL::Wire*> *get_all_wires(void);" in kernel/rtlil
	boost::python::dict Wire::get_all_wires(void )
	{
		std::map<unsigned int, YOSYS_NAMESPACE::RTLIL::Wire*>* ret_ = YOSYS_NAMESPACE::RTLIL::Wire::get_all_wires();
		boost::python::dict ret____tmp;
		for(auto tmp_163 : *ret_)
		{
			ret____tmp[tmp_163.first] = Wire::get_py_obj(tmp_163.second);
		}
		return ret____tmp;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Wire::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Wire::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Wire::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Wire::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Wire::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Wire::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void Wire::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string Wire::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Wire::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_164 = 0; cntr_164 < len(data); cntr_164++)
		{
			string tmp_165 = boost::python::extract<string>(data[cntr_164]);
			data___tmp.insert(tmp_165);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Wire::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_166 = 0; cntr_166 < len(data); cntr_166++)
		{
			string tmp_167 = boost::python::extract<string>(data[cntr_166]);
			data___tmp.insert(tmp_167);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list Wire::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_168 : ret_)
		{
			ret____tmp.append(tmp_168);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void Wire::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string Wire::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	// WRAPPED from "Memory();" in kernel/rtlil
	Memory::Memory()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Memory();
		this->hashidx_ = this->ref_obj->hashidx_;
	}

	int Memory::get_var_py_width()
	{
		int ret_ = this->get_cpp_obj()->width;
		return ret_;
	}

	void Memory::set_var_py_width(int rhs)
	{
		this->get_cpp_obj()->width = rhs;
	}

	int Memory::get_var_py_start_offset()
	{
		int ret_ = this->get_cpp_obj()->start_offset;
		return ret_;
	}

	void Memory::set_var_py_start_offset(int rhs)
	{
		this->get_cpp_obj()->start_offset = rhs;
	}

	int Memory::get_var_py_size()
	{
		int ret_ = this->get_cpp_obj()->size;
		return ret_;
	}

	void Memory::set_var_py_size(int rhs)
	{
		this->get_cpp_obj()->size = rhs;
	}

	IdString Memory::get_var_py_name()
	{
		IdString* ret_ = IdString::get_py_obj(&this->get_cpp_obj()->name);
		return *ret_;
	}

	void Memory::set_var_py_name(IdString *rhs)
	{
		this->get_cpp_obj()->name = *rhs->get_cpp_obj();
	}

	boost::python::dict Memory::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_169 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_169.first)] = *Const::get_py_obj(&tmp_169.second);
		}
		return ret____tmp;
	}

	void Memory::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_170 = 0; cntr_170 < len(rhs_keylist); cntr_170++)
		{
			IdString* key_tmp_171 = boost::python::extract<IdString*>(rhs_keylist[ cntr_170 ]);
			Const* val_tmp_171 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_170 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_171->get_cpp_obj(), *val_tmp_171->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "static std::map<unsigned int, RTLIL::Memory*> *get_all_memorys(void);" in kernel/rtlil
	boost::python::dict Memory::get_all_memorys(void )
	{
		std::map<unsigned int, YOSYS_NAMESPACE::RTLIL::Memory*>* ret_ = YOSYS_NAMESPACE::RTLIL::Memory::get_all_memorys();
		boost::python::dict ret____tmp;
		for(auto tmp_172 : *ret_)
		{
			ret____tmp[tmp_172.first] = Memory::get_py_obj(tmp_172.second);
		}
		return ret____tmp;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Memory::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Memory::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Memory::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Memory::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Memory::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Memory::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void Memory::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string Memory::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Memory::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_173 = 0; cntr_173 < len(data); cntr_173++)
		{
			string tmp_174 = boost::python::extract<string>(data[cntr_173]);
			data___tmp.insert(tmp_174);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Memory::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_175 = 0; cntr_175 < len(data); cntr_175++)
		{
			string tmp_176 = boost::python::extract<string>(data[cntr_175]);
			data___tmp.insert(tmp_176);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list Memory::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_177 : ret_)
		{
			ret____tmp.append(tmp_177);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void Memory::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string Memory::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	// WRAPPED from "Module();" in kernel/rtlil
	Module::Module()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Module();
		this->hashidx_ = this->ref_obj->hashidx_;
	}

	Design Module::get_var_py_design()
	{
		if(this->get_cpp_obj()->design == NULL)
			throw std::runtime_error("Member \"design\" is NULL");
		Design* ret_ = Design::get_py_obj(this->get_cpp_obj()->design);
		return *ret_;
	}

	void Module::set_var_py_design(Design *rhs)
	{
		this->get_cpp_obj()->design = rhs->get_cpp_obj();
	}

	boost::python::list Module::get_var_py_monitors()
	{
		pool<YOSYS_NAMESPACE::RTLIL::Monitor*> ret_ = this->get_cpp_obj()->monitors;
		boost::python::list ret____tmp;
		for(auto tmp_178 : ret_)
		{
			ret____tmp.append(Monitor::get_py_obj(tmp_178));
		}
		return ret____tmp;
	}

	void Module::set_var_py_monitors(boost::python::list rhs)
	{
		pool<YOSYS_NAMESPACE::RTLIL::Monitor*> rhs___tmp;
		for(int cntr_179 = 0; cntr_179 < len(rhs); cntr_179++)
		{
			Monitor* tmp_180 = boost::python::extract<Monitor*>(rhs[cntr_179]);
			rhs___tmp.insert(tmp_180->get_cpp_obj());
		}
		this->get_cpp_obj()->monitors = rhs___tmp;
	}

	int Module::get_var_py_refcount_wires_()
	{
		int ret_ = this->get_cpp_obj()->refcount_wires_;
		return ret_;
	}

	void Module::set_var_py_refcount_wires_(int rhs)
	{
		this->get_cpp_obj()->refcount_wires_ = rhs;
	}

	int Module::get_var_py_refcount_cells_()
	{
		int ret_ = this->get_cpp_obj()->refcount_cells_;
		return ret_;
	}

	void Module::set_var_py_refcount_cells_(int rhs)
	{
		this->get_cpp_obj()->refcount_cells_ = rhs;
	}

	boost::python::dict Module::get_var_py_wires_()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Wire*> ret_ = this->get_cpp_obj()->wires_;
		boost::python::dict ret____tmp;
		for(auto tmp_181 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_181.first)] = Wire::get_py_obj(tmp_181.second);
		}
		return ret____tmp;
	}

	void Module::set_var_py_wires_(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Wire*> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_182 = 0; cntr_182 < len(rhs_keylist); cntr_182++)
		{
			IdString* key_tmp_183 = boost::python::extract<IdString*>(rhs_keylist[ cntr_182 ]);
			Wire* val_tmp_183 = boost::python::extract<Wire*>(rhs[rhs_keylist[ cntr_182 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Wire*>(*key_tmp_183->get_cpp_obj(), val_tmp_183->get_cpp_obj()));

		}
		this->get_cpp_obj()->wires_ = rhs___tmp;
	}

	boost::python::dict Module::get_var_py_cells_()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Cell*> ret_ = this->get_cpp_obj()->cells_;
		boost::python::dict ret____tmp;
		for(auto tmp_184 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_184.first)] = Cell::get_py_obj(tmp_184.second);
		}
		return ret____tmp;
	}

	void Module::set_var_py_cells_(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Cell*> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_185 = 0; cntr_185 < len(rhs_keylist); cntr_185++)
		{
			IdString* key_tmp_186 = boost::python::extract<IdString*>(rhs_keylist[ cntr_185 ]);
			Cell* val_tmp_186 = boost::python::extract<Cell*>(rhs[rhs_keylist[ cntr_185 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Cell*>(*key_tmp_186->get_cpp_obj(), val_tmp_186->get_cpp_obj()));

		}
		this->get_cpp_obj()->cells_ = rhs___tmp;
	}

	boost::python::list Module::get_var_py_connections_()
	{
		std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> ret_ = this->get_cpp_obj()->connections_;
		boost::python::list ret____tmp;
		for(auto tmp_187 : ret_)
		{
			boost::python::tuple tmp_187___tmp = boost::python::make_tuple(SigSpec::get_py_obj(tmp_187.first), SigSpec::get_py_obj(tmp_187.second));
			ret____tmp.append(tmp_187___tmp);
		}
		return ret____tmp;
	}

	void Module::set_var_py_connections_(boost::python::list rhs)
	{
		std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> rhs___tmp;
		for(int cntr_188 = 0; cntr_188 < len(rhs); cntr_188++)
		{
			boost::python::tuple tmp_189 = boost::python::extract<boost::python::tuple>(rhs[cntr_188]);
			SigSpec tmp_189___tmp_0 = boost::python::extract<SigSpec>(tmp_189[0]);
			SigSpec tmp_189___tmp_1 = boost::python::extract<SigSpec>(tmp_189[1]);
			std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec> tmp_189___tmp(tmp_189___tmp_0.get_cpp_obj(), tmp_189___tmp_1.get_cpp_obj());
			rhs___tmp.push_back(tmp_189___tmp);
		}
		this->get_cpp_obj()->connections_ = rhs___tmp;
	}

	boost::python::list Module::get_var_py_avail_parameters()
	{
		idict<YOSYS_NAMESPACE::RTLIL::IdString> ret_ = this->get_cpp_obj()->avail_parameters;
		boost::python::list ret____tmp;
		for(auto tmp_190 : ret_)
		{
			ret____tmp.append(*IdString::get_py_obj(&tmp_190));
		}
		return ret____tmp;
	}

	void Module::set_var_py_avail_parameters(boost::python::list rhs)
	{
		idict<YOSYS_NAMESPACE::RTLIL::IdString> rhs___tmp;
		for(int cntr_191 = 0; cntr_191 < len(rhs); cntr_191++)
		{
			IdString* tmp_192 = boost::python::extract<IdString*>(rhs[cntr_191]);
			rhs___tmp(*tmp_192->get_cpp_obj());
		}
		this->get_cpp_obj()->avail_parameters = rhs___tmp;
	}

	boost::python::dict Module::get_var_py_parameter_default_values()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->parameter_default_values;
		boost::python::dict ret____tmp;
		for(auto tmp_193 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_193.first)] = *Const::get_py_obj(&tmp_193.second);
		}
		return ret____tmp;
	}

	void Module::set_var_py_parameter_default_values(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_194 = 0; cntr_194 < len(rhs_keylist); cntr_194++)
		{
			IdString* key_tmp_195 = boost::python::extract<IdString*>(rhs_keylist[ cntr_194 ]);
			Const* val_tmp_195 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_194 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_195->get_cpp_obj(), *val_tmp_195->get_cpp_obj()));

		}
		this->get_cpp_obj()->parameter_default_values = rhs___tmp;
	}

	boost::python::dict Module::get_var_py_memories()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Memory*> ret_ = this->get_cpp_obj()->memories;
		boost::python::dict ret____tmp;
		for(auto tmp_196 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_196.first)] = Memory::get_py_obj(tmp_196.second);
		}
		return ret____tmp;
	}

	void Module::set_var_py_memories(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Memory*> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_197 = 0; cntr_197 < len(rhs_keylist); cntr_197++)
		{
			IdString* key_tmp_198 = boost::python::extract<IdString*>(rhs_keylist[ cntr_197 ]);
			Memory* val_tmp_198 = boost::python::extract<Memory*>(rhs[rhs_keylist[ cntr_197 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Memory*>(*key_tmp_198->get_cpp_obj(), val_tmp_198->get_cpp_obj()));

		}
		this->get_cpp_obj()->memories = rhs___tmp;
	}

	boost::python::dict Module::get_var_py_processes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Process*> ret_ = this->get_cpp_obj()->processes;
		boost::python::dict ret____tmp;
		for(auto tmp_199 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_199.first)] = Process::get_py_obj(tmp_199.second);
		}
		return ret____tmp;
	}

	void Module::set_var_py_processes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Process*> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_200 = 0; cntr_200 < len(rhs_keylist); cntr_200++)
		{
			IdString* key_tmp_201 = boost::python::extract<IdString*>(rhs_keylist[ cntr_200 ]);
			Process* val_tmp_201 = boost::python::extract<Process*>(rhs[rhs_keylist[ cntr_200 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Process*>(*key_tmp_201->get_cpp_obj(), val_tmp_201->get_cpp_obj()));

		}
		this->get_cpp_obj()->processes = rhs___tmp;
	}

	boost::python::list Module::get_var_py_ports()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::IdString> ret_ = this->get_cpp_obj()->ports;
		boost::python::list ret____tmp;
		for(auto tmp_202 : ret_)
		{
			ret____tmp.append(*IdString::get_py_obj(&tmp_202));
		}
		return ret____tmp;
	}

	void Module::set_var_py_ports(boost::python::list rhs)
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::IdString> rhs___tmp;
		for(int cntr_203 = 0; cntr_203 < len(rhs); cntr_203++)
		{
			IdString* tmp_204 = boost::python::extract<IdString*>(rhs[cntr_203]);
			rhs___tmp.push_back(*tmp_204->get_cpp_obj());
		}
		this->get_cpp_obj()->ports = rhs___tmp;
	}

	IdString Module::get_var_py_name()
	{
		IdString* ret_ = IdString::get_py_obj(&this->get_cpp_obj()->name);
		return *ret_;
	}

	void Module::set_var_py_name(IdString *rhs)
	{
		this->get_cpp_obj()->name = *rhs->get_cpp_obj();
	}

	boost::python::dict Module::get_var_py_attributes()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> ret_ = this->get_cpp_obj()->attributes;
		boost::python::dict ret____tmp;
		for(auto tmp_205 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_205.first)] = *Const::get_py_obj(&tmp_205.second);
		}
		return ret____tmp;
	}

	void Module::set_var_py_attributes(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_206 = 0; cntr_206 < len(rhs_keylist); cntr_206++)
		{
			IdString* key_tmp_207 = boost::python::extract<IdString*>(rhs_keylist[ cntr_206 ]);
			Const* val_tmp_207 = boost::python::extract<Const*>(rhs[rhs_keylist[ cntr_206 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Const>(*key_tmp_207->get_cpp_obj(), *val_tmp_207->get_cpp_obj()));

		}
		this->get_cpp_obj()->attributes = rhs___tmp;
	}

	// WRAPPED from "virtual size_t count_id(const RTLIL::IdString& id);" in kernel/rtlil
	size_t Module::count_id(const IdString* id)
	{
		size_t ret_ = this->get_cpp_obj()->count_id(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "virtual bool reprocess_if_necessary(RTLIL::Design *design);" in kernel/rtlil
	bool Module::reprocess_if_necessary(Design* design)
	{
		bool ret_ = this->get_cpp_obj()->reprocess_if_necessary(design->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "virtual void sort();" in kernel/rtlil
	void Module::sort()
	{
		this->get_cpp_obj()->sort();
	}

	// WRAPPED from "virtual void check();" in kernel/rtlil
	void Module::check()
	{
		this->get_cpp_obj()->check();
	}

	// WRAPPED from "virtual void optimize();" in kernel/rtlil
	void Module::optimize()
	{
		this->get_cpp_obj()->optimize();
	}

	// WRAPPED from "virtual void makeblackbox();" in kernel/rtlil
	void Module::makeblackbox()
	{
		this->get_cpp_obj()->makeblackbox();
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Module::get_blackbox_attribute() const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute();
		return ret_;
	}

	// WRAPPED from "bool get_blackbox_attribute(bool ignore_wb=false) const {" in kernel/rtlil
	bool Module::get_blackbox_attribute(bool ignore_wb) const
	{
		bool ret_ = this->get_cpp_obj()->get_blackbox_attribute(ignore_wb);
		return ret_;
	}

	// WRAPPED from "void connect(const RTLIL::SigSig &conn);" in kernel/rtlil
	void Module::connect(const boost::python::tuple conn)
	{
		SigSpec conn___tmp_0 = boost::python::extract<SigSpec>(conn[0]);
		SigSpec conn___tmp_1 = boost::python::extract<SigSpec>(conn[1]);
		std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec> conn___tmp(conn___tmp_0.get_cpp_obj(), conn___tmp_1.get_cpp_obj());
		this->get_cpp_obj()->connect(conn___tmp);
	}

	// WRAPPED from "void connect(const RTLIL::SigSpec &lhs, const RTLIL::SigSpec &rhs);" in kernel/rtlil
	void Module::connect(const SigSpec* lhs, const SigSpec* rhs)
	{
		this->get_cpp_obj()->connect(*lhs->get_cpp_obj(), *rhs->get_cpp_obj());
	}

	// WRAPPED from "void new_connections(const std::vector<RTLIL::SigSig> &new_conn);" in kernel/rtlil
	void Module::new_connections(const boost::python::list new_conn)
	{
		std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> new_conn___tmp;
		for(int cntr_208 = 0; cntr_208 < len(new_conn); cntr_208++)
		{
			boost::python::tuple tmp_209 = boost::python::extract<boost::python::tuple>(new_conn[cntr_208]);
			SigSpec tmp_209___tmp_0 = boost::python::extract<SigSpec>(tmp_209[0]);
			SigSpec tmp_209___tmp_1 = boost::python::extract<SigSpec>(tmp_209[1]);
			std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec> tmp_209___tmp(tmp_209___tmp_0.get_cpp_obj(), tmp_209___tmp_1.get_cpp_obj());
			new_conn___tmp.push_back(tmp_209___tmp);
		}
		this->get_cpp_obj()->new_connections(new_conn___tmp);
	}

	// WRAPPED from "const std::vector<RTLIL::SigSig> &connections() const;" in kernel/rtlil
	boost::python::list Module::connections()
	{
		std::vector<std::pair<YOSYS_NAMESPACE::RTLIL::SigSpec, YOSYS_NAMESPACE::RTLIL::SigSpec>> ret_ = this->get_cpp_obj()->connections();
		boost::python::list ret____tmp;
		for(auto tmp_210 : ret_)
		{
			boost::python::tuple tmp_210___tmp = boost::python::make_tuple(SigSpec::get_py_obj(tmp_210.first), SigSpec::get_py_obj(tmp_210.second));
			ret____tmp.append(tmp_210___tmp);
		}
		return ret____tmp;
	}

	// WRAPPED from "void fixup_ports();" in kernel/rtlil
	void Module::fixup_ports()
	{
		this->get_cpp_obj()->fixup_ports();
	}

	// WRAPPED from "void bufNormalize();" in kernel/rtlil
	void Module::bufNormalize()
	{
		this->get_cpp_obj()->bufNormalize();
	}

	// WRAPPED from "void cloneInto(RTLIL::Module *new_mod) const;" in kernel/rtlil
	void Module::cloneInto(Module* new_mod)
	{
		this->get_cpp_obj()->cloneInto(new_mod->get_cpp_obj());
	}

	// WRAPPED from "virtual RTLIL::Module *clone() const;" in kernel/rtlil
	Module Module::clone()
	{
		Module* ret_ = Module::get_py_obj(this->get_cpp_obj()->clone());
		return *ret_;
	}

	// WRAPPED from "bool has_memories() const;" in kernel/rtlil
	bool Module::has_memories()
	{
		bool ret_ = this->get_cpp_obj()->has_memories();
		return ret_;
	}

	// WRAPPED from "bool has_processes() const;" in kernel/rtlil
	bool Module::has_processes()
	{
		bool ret_ = this->get_cpp_obj()->has_processes();
		return ret_;
	}

	// WRAPPED from "bool has_memories_warn() const;" in kernel/rtlil
	bool Module::has_memories_warn()
	{
		bool ret_ = this->get_cpp_obj()->has_memories_warn();
		return ret_;
	}

	// WRAPPED from "bool has_processes_warn() const;" in kernel/rtlil
	bool Module::has_processes_warn()
	{
		bool ret_ = this->get_cpp_obj()->has_processes_warn();
		return ret_;
	}

	// WRAPPED from "bool is_selected() const;" in kernel/rtlil
	bool Module::is_selected()
	{
		bool ret_ = this->get_cpp_obj()->is_selected();
		return ret_;
	}

	// WRAPPED from "bool is_selected_whole() const;" in kernel/rtlil
	bool Module::is_selected_whole()
	{
		bool ret_ = this->get_cpp_obj()->is_selected_whole();
		return ret_;
	}

	// WRAPPED from "std::vector<RTLIL::Wire*> selected_wires() const;" in kernel/rtlil
	boost::python::list Module::selected_wires()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Wire*> ret_ = this->get_cpp_obj()->selected_wires();
		boost::python::list ret____tmp;
		for(auto tmp_211 : ret_)
		{
			ret____tmp.append(Wire::get_py_obj(tmp_211));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Cell*> selected_cells() const;" in kernel/rtlil
	boost::python::list Module::selected_cells()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Cell*> ret_ = this->get_cpp_obj()->selected_cells();
		boost::python::list ret____tmp;
		for(auto tmp_212 : ret_)
		{
			ret____tmp.append(Cell::get_py_obj(tmp_212));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Memory*> selected_memories() const;" in kernel/rtlil
	boost::python::list Module::selected_memories()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Memory*> ret_ = this->get_cpp_obj()->selected_memories();
		boost::python::list ret____tmp;
		for(auto tmp_213 : ret_)
		{
			ret____tmp.append(Memory::get_py_obj(tmp_213));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Process*> selected_processes() const;" in kernel/rtlil
	boost::python::list Module::selected_processes()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Process*> ret_ = this->get_cpp_obj()->selected_processes();
		boost::python::list ret____tmp;
		for(auto tmp_214 : ret_)
		{
			ret____tmp.append(Process::get_py_obj(tmp_214));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::NamedObject*> selected_members() const;" in kernel/rtlil
	boost::python::list Module::selected_members()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::NamedObject*> ret_ = this->get_cpp_obj()->selected_members();
		boost::python::list ret____tmp;
		for(auto tmp_215 : ret_)
		{
			ret____tmp.append(NamedObject::get_py_obj(tmp_215));
		}
		return ret____tmp;
	}

	// WRAPPED from "RTLIL::Wire* wire(const RTLIL::IdString &id) {" in kernel/rtlil
	Wire Module::wire(const IdString* id)
	{
		Wire* ret_ = Wire::get_py_obj(this->get_cpp_obj()->wire(*id->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* cell(const RTLIL::IdString &id) {" in kernel/rtlil
	Cell Module::cell(const IdString* id)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->cell(*id->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::ObjRange<RTLIL::Wire*> wires() { return RTLIL::ObjRange<RTLIL::Wire*>(&wires_, &refcount_wires_); }" in kernel/rtlil
	boost::python::list Module::wires()
	{
		RTLIL::ObjRange<YOSYS_NAMESPACE::RTLIL::Wire*> ret_ = this->get_cpp_obj()->wires();
		boost::python::list ret____tmp;
		for(auto tmp_216 : ret_)
		{
			ret____tmp.append(Wire::get_py_obj(tmp_216));
		}
		return ret____tmp;
	}

	// WRAPPED from "RTLIL::ObjRange<RTLIL::Cell*> cells() { return RTLIL::ObjRange<RTLIL::Cell*>(&cells_, &refcount_cells_); }" in kernel/rtlil
	boost::python::list Module::cells()
	{
		RTLIL::ObjRange<YOSYS_NAMESPACE::RTLIL::Cell*> ret_ = this->get_cpp_obj()->cells();
		boost::python::list ret____tmp;
		for(auto tmp_217 : ret_)
		{
			ret____tmp.append(Cell::get_py_obj(tmp_217));
		}
		return ret____tmp;
	}

	// WRAPPED from "void remove(const pool<RTLIL::Wire*> &wires);" in kernel/rtlil
	void Module::remove(const boost::python::list wires)
	{
		pool<YOSYS_NAMESPACE::RTLIL::Wire*> wires___tmp;
		for(int cntr_218 = 0; cntr_218 < len(wires); cntr_218++)
		{
			Wire* tmp_219 = boost::python::extract<Wire*>(wires[cntr_218]);
			wires___tmp.insert(tmp_219->get_cpp_obj());
		}
		this->get_cpp_obj()->remove(wires___tmp);
	}

	// WRAPPED from "void remove(RTLIL::Cell *cell);" in kernel/rtlil
	void Module::remove(Cell* cell)
	{
		this->get_cpp_obj()->remove(cell->get_cpp_obj());
	}

	// WRAPPED from "void remove(RTLIL::Process *process);" in kernel/rtlil
	void Module::remove(Process* process)
	{
		this->get_cpp_obj()->remove(process->get_cpp_obj());
	}

	// WRAPPED from "void rename(RTLIL::Wire *wire, RTLIL::IdString new_name);" in kernel/rtlil
	void Module::rename(Wire* wire, IdString* new_name)
	{
		this->get_cpp_obj()->rename(wire->get_cpp_obj(), *new_name->get_cpp_obj());
	}

	// WRAPPED from "void rename(RTLIL::Cell *cell, RTLIL::IdString new_name);" in kernel/rtlil
	void Module::rename(Cell* cell, IdString* new_name)
	{
		this->get_cpp_obj()->rename(cell->get_cpp_obj(), *new_name->get_cpp_obj());
	}

	// WRAPPED from "void rename(RTLIL::IdString old_name, RTLIL::IdString new_name);" in kernel/rtlil
	void Module::rename(IdString* old_name, IdString* new_name)
	{
		this->get_cpp_obj()->rename(*old_name->get_cpp_obj(), *new_name->get_cpp_obj());
	}

	// WRAPPED from "void swap_names(RTLIL::Wire *w1, RTLIL::Wire *w2);" in kernel/rtlil
	void Module::swap_names(Wire* w1, Wire* w2)
	{
		this->get_cpp_obj()->swap_names(w1->get_cpp_obj(), w2->get_cpp_obj());
	}

	// WRAPPED from "void swap_names(RTLIL::Cell *c1, RTLIL::Cell *c2);" in kernel/rtlil
	void Module::swap_names(Cell* c1, Cell* c2)
	{
		this->get_cpp_obj()->swap_names(c1->get_cpp_obj(), c2->get_cpp_obj());
	}

	// WRAPPED from "RTLIL::IdString uniquify(RTLIL::IdString name);" in kernel/rtlil
	IdString Module::uniquify(IdString* name)
	{
		IdString* ret_ = IdString::get_py_obj(this->get_cpp_obj()->uniquify(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::IdString uniquify(RTLIL::IdString name, int &index);" in kernel/rtlil
	IdString Module::uniquify(IdString* name, int index)
	{
		IdString* ret_ = IdString::get_py_obj(this->get_cpp_obj()->uniquify(*name->get_cpp_obj(), index));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Wire *addWire(RTLIL::IdString name, int width = 1);" in kernel/rtlil
	Wire Module::addWire(IdString* name)
	{
		Wire* ret_ = Wire::get_py_obj(this->get_cpp_obj()->addWire(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Wire *addWire(RTLIL::IdString name, int width = 1);" in kernel/rtlil
	Wire Module::addWire(IdString* name, int width)
	{
		Wire* ret_ = Wire::get_py_obj(this->get_cpp_obj()->addWire(*name->get_cpp_obj(), width));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Wire *addWire(RTLIL::IdString name, const RTLIL::Wire *other);" in kernel/rtlil
	Wire Module::addWire(IdString* name, const Wire* other)
	{
		Wire* ret_ = Wire::get_py_obj(this->get_cpp_obj()->addWire(*name->get_cpp_obj(), other->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell *addCell(RTLIL::IdString name, RTLIL::IdString type);" in kernel/rtlil
	Cell Module::addCell(IdString* name, IdString* type)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addCell(*name->get_cpp_obj(), *type->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell *addCell(RTLIL::IdString name, const RTLIL::Cell *other);" in kernel/rtlil
	Cell Module::addCell(IdString* name, const Cell* other)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addCell(*name->get_cpp_obj(), other->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Memory *addMemory(RTLIL::IdString name, const RTLIL::Memory *other);" in kernel/rtlil
	Memory Module::addMemory(IdString* name, const Memory* other)
	{
		Memory* ret_ = Memory::get_py_obj(this->get_cpp_obj()->addMemory(*name->get_cpp_obj(), other->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Process *addProcess(RTLIL::IdString name);" in kernel/rtlil
	Process Module::addProcess(IdString* name)
	{
		Process* ret_ = Process::get_py_obj(this->get_cpp_obj()->addProcess(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Process *addProcess(RTLIL::IdString name, const RTLIL::Process *other);" in kernel/rtlil
	Process Module::addProcess(IdString* name, const Process* other)
	{
		Process* ret_ = Process::get_py_obj(this->get_cpp_obj()->addProcess(*name->get_cpp_obj(), other->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPos(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPos(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPos(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPos(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPos(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPos(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBuf(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBuf(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBuf(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNeg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNeg(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNeg(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNeg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNeg(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNeg(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNeg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNeg(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNeg(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceXor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceXnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceBool(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceBool(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceBool(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceBool(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addReduceBool(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addReduceBool(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSshl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSshl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSshl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSshr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSshr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSshr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShift(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShift(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShift(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShiftx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShiftx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addShiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addShiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addShiftx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addEq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addEq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addEq(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addEq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addEq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addEq(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addEq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addEq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addEq(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addEqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addEqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addEqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addEqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addEqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addEqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addEqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addEqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addEqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNex(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNex(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNex(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addGe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addGe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addGe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addGe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addGe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addGe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addGe(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addGe(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addGe(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addGt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addGt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addGt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addGt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addGt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addGt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addGt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addGt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addGt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSub(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSub(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSub(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMul(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMul(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMul(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDiv(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDiv(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDiv(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMod(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMod(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMod(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDivFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDivFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDivFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addModFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addModFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addModFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPow(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool a_signed = false, bool b_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPow(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPow(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPow(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool a_signed = false, bool b_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPow(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool a_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPow(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), a_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPow(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool a_signed = false, bool b_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPow(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool a_signed, bool b_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPow(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), a_signed, b_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPow(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool a_signed = false, bool b_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPow(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool a_signed, bool b_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPow(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), a_signed, b_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addFa(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_c, const RTLIL::SigSpec &sig_x, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addFa(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_c, const SigSpec* sig_x, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addFa(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_x->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addFa(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_c, const RTLIL::SigSpec &sig_x, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addFa(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_c, const SigSpec* sig_x, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addFa(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_x->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicNot(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, bool is_signed, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLogicOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addPmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addPmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addPmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDemux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDemux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDemux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDemux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDemux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDemux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBweqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBweqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBweqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBweqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBweqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBweqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBwmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBwmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBwmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBwmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBwmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBwmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSlice(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, RTLIL::Const offset, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSlice(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, Const* offset)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSlice(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), *offset->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSlice(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, RTLIL::Const offset, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSlice(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, Const* offset, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSlice(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), *offset->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addConcat(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addConcat(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addConcat(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addConcat(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addConcat(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addConcat(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLut(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, RTLIL::Const lut, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLut(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, Const* lut)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLut(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), *lut->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLut(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_y, RTLIL::Const lut, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLut(IdString* name, const SigSpec* sig_a, const SigSpec* sig_y, Const* lut, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLut(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), *lut->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addTribuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addTribuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addTribuf(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addTribuf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addTribuf(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addTribuf(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAssert(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAssert(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAssert(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAssert(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAssert(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAssert(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAssume(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAssume(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAssume(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAssume(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAssume(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAssume(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLive(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLive(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLive(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addLive(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addLive(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addLive(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addFair(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addFair(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addFair(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addFair(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addFair(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addFair(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addCover(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addCover(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addCover(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addCover(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_en, const std::string &src = "");" in kernel/rtlil
	Cell Module::addCover(IdString* name, const SigSpec* sig_a, const SigSpec* sig_en, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addCover(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_en->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addEquiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addEquiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addEquiv(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addEquiv(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addEquiv(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addEquiv(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSr(RTLIL::IdString name, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, const RTLIL::SigSpec &sig_q, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSr(IdString* name, const SigSpec* sig_set, const SigSpec* sig_clr, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSr(*name->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSr(RTLIL::IdString name, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, const RTLIL::SigSpec &sig_q, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSr(IdString* name, const SigSpec* sig_set, const SigSpec* sig_clr, const SigSpec* sig_q, bool set_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSr(*name->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_q->get_cpp_obj(), set_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSr(RTLIL::IdString name, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, const RTLIL::SigSpec &sig_q, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSr(IdString* name, const SigSpec* sig_set, const SigSpec* sig_clr, const SigSpec* sig_q, bool set_polarity, bool clr_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSr(*name->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_q->get_cpp_obj(), set_polarity, clr_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSr(RTLIL::IdString name, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, const RTLIL::SigSpec &sig_q, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSr(IdString* name, const SigSpec* sig_set, const SigSpec* sig_clr, const SigSpec* sig_q, bool set_polarity, bool clr_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSr(*name->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_q->get_cpp_obj(), set_polarity, clr_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addFf(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
	Cell Module::addFf(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addFf(*name->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addFf(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
	Cell Module::addFf(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addFf(*name->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, en_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsr(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsr(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool set_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsr(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, set_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool set_polarity, bool clr_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsr(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, set_polarity, clr_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsr(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool set_polarity, bool clr_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsr(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, set_polarity, clr_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsre(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsre(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsre(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, bool set_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsre(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, en_polarity, set_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, bool set_polarity, bool clr_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsre(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, en_polarity, set_polarity, clr_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffsre(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffsre(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, bool set_polarity, bool clr_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffsre(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, en_polarity, set_polarity, clr_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool arst_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), clk_polarity, arst_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool arst_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), clk_polarity, arst_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), clk_polarity, en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool en_polarity, bool arst_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), clk_polarity, en_polarity, arst_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool clk_polarity = true, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool clk_polarity, bool en_polarity, bool arst_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), clk_polarity, en_polarity, arst_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool aload_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj(), clk_polarity, aload_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool aload_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj(), clk_polarity, aload_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj(), clk_polarity, en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool en_polarity, bool aload_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj(), clk_polarity, en_polarity, aload_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAldffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_aload, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const RTLIL::SigSpec &sig_ad, bool clk_polarity = true, bool en_polarity = true, bool aload_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAldffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_aload, const SigSpec* sig_d, const SigSpec* sig_q, const SigSpec* sig_ad, bool clk_polarity, bool en_polarity, bool aload_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAldffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_aload->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *sig_ad->get_cpp_obj(), clk_polarity, en_polarity, aload_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool srst_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity, srst_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdff(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdff(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool srst_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdff(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity, srst_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity, en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity, bool srst_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity, en_polarity, srst_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffe(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffe(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity, bool srst_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffe(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity, en_polarity, srst_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffce(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffce(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffce(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity, en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity, bool srst_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffce(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity, en_polarity, srst_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSdffce(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_srst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const srst_value, bool clk_polarity = true, bool en_polarity = true, bool srst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSdffce(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_srst, const SigSpec* sig_d, const SigSpec* sig_q, Const* srst_value, bool clk_polarity, bool en_polarity, bool srst_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSdffce(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_srst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *srst_value->get_cpp_obj(), clk_polarity, en_polarity, srst_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatch(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatch(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatch(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), en_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdlatch(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdlatch(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool en_polarity, bool arst_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdlatch(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), en_polarity, arst_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAdlatch(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_arst, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, RTLIL::Const arst_value, bool en_polarity = true, bool arst_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAdlatch(IdString* name, const SigSpec* sig_en, const SigSpec* sig_arst, const SigSpec* sig_d, const SigSpec* sig_q, Const* arst_value, bool en_polarity, bool arst_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAdlatch(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_arst->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), *arst_value->get_cpp_obj(), en_polarity, arst_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatchsr(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatchsr(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, bool set_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatchsr(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), en_polarity, set_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, bool set_polarity, bool clr_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatchsr(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), en_polarity, set_polarity, clr_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatchsr(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_set, const RTLIL::SigSpec &sig_clr, RTLIL::SigSpec sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, bool set_polarity = true, bool clr_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatchsr(IdString* name, const SigSpec* sig_en, const SigSpec* sig_set, const SigSpec* sig_clr, SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, bool set_polarity, bool clr_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatchsr(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_set->get_cpp_obj(), *sig_clr->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), en_polarity, set_polarity, clr_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBufGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBufGate(IdString* name, const SigBit* sig_a, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBufGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addBufGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addBufGate(IdString* name, const SigBit* sig_a, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addBufGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAndGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAndGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAndGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAndGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAndGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAndGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNandGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNandGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNandGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNandGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNandGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNandGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOrGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOrGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOrGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOrGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOrGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOrGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXnorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXnorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXnorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addXnorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addXnorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addXnorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAndnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAndnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAndnotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAndnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAndnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAndnotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOrnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOrnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOrnotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOrnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOrnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOrnotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMuxGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addMuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addMuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addMuxGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNmuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNmuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNmuxGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addNmuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addNmuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addNmuxGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAoi3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAoi3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAoi3Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAoi3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAoi3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAoi3Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOai3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOai3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOai3Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOai3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOai3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOai3Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAoi4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAoi4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAoi4Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAoi4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAoi4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAoi4Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOai4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOai4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const SigBit* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOai4Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOai4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const RTLIL::SigBit &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOai4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const SigBit* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOai4Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addFfGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
	Cell Module::addFfGate(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addFfGate(*name->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addFfGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
	Cell Module::addFfGate(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addFfGate(*name->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffGate(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffGate(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffGate(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffeGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffeGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffeGate(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffeGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffeGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffeGate(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffeGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffeGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffeGate(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDffeGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_clk, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool clk_polarity = true, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDffeGate(IdString* name, const SigSpec* sig_clk, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool clk_polarity, bool en_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDffeGate(*name->get_cpp_obj(), *sig_clk->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), clk_polarity, en_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatchGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatchGate(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatchGate(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatchGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatchGate(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatchGate(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), en_polarity));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addDlatchGate(RTLIL::IdString name, const RTLIL::SigSpec &sig_en, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, bool en_polarity = true, const std::string &src = "");" in kernel/rtlil
	Cell Module::addDlatchGate(IdString* name, const SigSpec* sig_en, const SigSpec* sig_d, const SigSpec* sig_q, bool en_polarity, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addDlatchGate(*name->get_cpp_obj(), *sig_en->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), en_polarity, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAnyinit(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAnyinit(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAnyinit(*name->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addAnyinit(RTLIL::IdString name, const RTLIL::SigSpec &sig_d, const RTLIL::SigSpec &sig_q, const std::string &src = "");" in kernel/rtlil
	Cell Module::addAnyinit(IdString* name, const SigSpec* sig_d, const SigSpec* sig_q, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addAnyinit(*name->get_cpp_obj(), *sig_d->get_cpp_obj(), *sig_q->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Not(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Not(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Not(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Not(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Not(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Not(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Not(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Not(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Not(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Pos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Pos(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Pos(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Pos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Pos(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Pos(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Pos(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Pos(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Pos(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Buf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Buf(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Buf(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Buf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Buf(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Buf(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Buf(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Buf(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Buf(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Neg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Neg(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Neg(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Neg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Neg(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Neg(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Neg(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Neg(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Neg(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec And(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::And(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->And(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec And(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::And(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->And(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec And(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::And(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->And(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Or(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Or(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Or(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Or(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Or(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Or(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Or(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Or(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Or(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Xor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Xor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Xor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Xor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Xor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Xor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Xor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Xor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Xor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Xnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Xnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Xnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Xnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Xnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Xnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Xnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Xnor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Xnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceAnd(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceAnd(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceAnd(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceOr(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceOr(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceOr(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceXor(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceXor(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceXor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceXor(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceXor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceXnor(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceXnor(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceXnor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceXnor(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceXnor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceBool(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceBool(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceBool(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceBool(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ReduceBool(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ReduceBool(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ReduceBool(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sshl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sshl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sshl(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sshl(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sshl(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sshr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sshr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sshr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sshr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sshr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shift(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shift(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shift(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shift(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shift(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shiftx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shiftx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Shiftx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Shiftx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Shiftx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Lt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Lt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Lt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Lt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Lt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Lt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Lt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Lt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Lt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Le(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Le(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Le(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Le(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Le(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Le(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Le(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Le(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Le(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Eq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Eq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Eq(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Eq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Eq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Eq(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Eq(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Eq(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Eq(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Ne(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Ne(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Ne(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Ne(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Ne(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Ne(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Ne(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Ne(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Ne(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Eqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Eqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Eqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Eqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Eqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Eqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Eqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Eqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Eqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Nex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Nex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Nex(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Nex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Nex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Nex(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Nex(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Nex(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Nex(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Ge(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Ge(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Ge(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Ge(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Ge(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Ge(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Ge(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Ge(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Ge(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Gt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Gt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Gt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Gt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Gt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Gt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Gt(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Gt(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Gt(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Add(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Add(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Add(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Add(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Add(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Add(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Add(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Add(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Add(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sub(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sub(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Sub(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Sub(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Sub(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Mul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Mul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Mul(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Mul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Mul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Mul(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Mul(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Mul(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Mul(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Div(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Div(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Div(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Div(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Div(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Div(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Div(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Div(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Div(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Mod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Mod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Mod(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Mod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Mod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Mod(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Mod(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Mod(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Mod(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec DivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::DivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->DivFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec DivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::DivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->DivFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec DivFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::DivFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->DivFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ModFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ModFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec ModFloor(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::ModFloor(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->ModFloor(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicNot(IdString* name, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicNot(IdString* name, const SigSpec* sig_a, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicNot(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicNot(IdString* name, const SigSpec* sig_a, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicNot(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicAnd(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicAnd(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicAnd(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec LogicOr(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, bool is_signed = false, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::LogicOr(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, bool is_signed, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->LogicOr(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), is_signed, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Mux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Mux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Mux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Mux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Mux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Mux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Pmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Pmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Pmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Pmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Pmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Pmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Bmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Bmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Bmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Bmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Bmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Bmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Demux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Demux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Demux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Demux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Demux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_s, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Demux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Bweqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Bweqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Bweqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Bweqx(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Bweqx(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Bweqx(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Bwmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Bwmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Bwmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Bwmux(RTLIL::IdString name, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_b, const RTLIL::SigSpec &sig_s, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Bwmux(IdString* name, const SigSpec* sig_a, const SigSpec* sig_b, const SigSpec* sig_s, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Bwmux(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit BufGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const std::string &src = "");" in kernel/rtlil
	SigBit Module::BufGate(IdString* name, const SigBit* sig_a)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->BufGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit BufGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const std::string &src = "");" in kernel/rtlil
	SigBit Module::BufGate(IdString* name, const SigBit* sig_a, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->BufGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit NotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const std::string &src = "");" in kernel/rtlil
	SigBit Module::NotGate(IdString* name, const SigBit* sig_a)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->NotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit NotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const std::string &src = "");" in kernel/rtlil
	SigBit Module::NotGate(IdString* name, const SigBit* sig_a, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->NotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit AndGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::AndGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->AndGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit AndGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::AndGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->AndGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit NandGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::NandGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->NandGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit NandGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::NandGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->NandGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit OrGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::OrGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->OrGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit OrGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::OrGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->OrGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit NorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::NorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->NorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit NorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::NorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->NorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit XorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::XorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->XorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit XorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::XorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->XorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit XnorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::XnorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->XnorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit XnorGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::XnorGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->XnorGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit AndnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::AndnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->AndnotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit AndnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::AndnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->AndnotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit OrnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::OrnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->OrnotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit OrnotGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const std::string &src = "");" in kernel/rtlil
	SigBit Module::OrnotGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->OrnotGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit MuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const std::string &src = "");" in kernel/rtlil
	SigBit Module::MuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->MuxGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit MuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const std::string &src = "");" in kernel/rtlil
	SigBit Module::MuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->MuxGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit NmuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const std::string &src = "");" in kernel/rtlil
	SigBit Module::NmuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->NmuxGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit NmuxGate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_s, const std::string &src = "");" in kernel/rtlil
	SigBit Module::NmuxGate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_s, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->NmuxGate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_s->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit Aoi3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const std::string &src = "");" in kernel/rtlil
	SigBit Module::Aoi3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->Aoi3Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit Aoi3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const std::string &src = "");" in kernel/rtlil
	SigBit Module::Aoi3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->Aoi3Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit Oai3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const std::string &src = "");" in kernel/rtlil
	SigBit Module::Oai3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->Oai3Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit Oai3Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const std::string &src = "");" in kernel/rtlil
	SigBit Module::Oai3Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->Oai3Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit Aoi4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const std::string &src = "");" in kernel/rtlil
	SigBit Module::Aoi4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->Aoi4Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_d->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit Aoi4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const std::string &src = "");" in kernel/rtlil
	SigBit Module::Aoi4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->Aoi4Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_d->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit Oai4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const std::string &src = "");" in kernel/rtlil
	SigBit Module::Oai4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->Oai4Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_d->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigBit Oai4Gate(RTLIL::IdString name, const RTLIL::SigBit &sig_a, const RTLIL::SigBit &sig_b, const RTLIL::SigBit &sig_c, const RTLIL::SigBit &sig_d, const std::string &src = "");" in kernel/rtlil
	SigBit Module::Oai4Gate(IdString* name, const SigBit* sig_a, const SigBit* sig_b, const SigBit* sig_c, const SigBit* sig_d, const string src)
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->Oai4Gate(*name->get_cpp_obj(), *sig_a->get_cpp_obj(), *sig_b->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_d->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Anyconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Anyconst(IdString* name)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Anyconst(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Anyconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Anyconst(IdString* name, int width)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Anyconst(*name->get_cpp_obj(), width));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Anyconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Anyconst(IdString* name, int width, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Anyconst(*name->get_cpp_obj(), width, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Anyseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Anyseq(IdString* name)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Anyseq(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Anyseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Anyseq(IdString* name, int width)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Anyseq(*name->get_cpp_obj(), width));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Anyseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Anyseq(IdString* name, int width, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Anyseq(*name->get_cpp_obj(), width, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Allconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Allconst(IdString* name)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Allconst(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Allconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Allconst(IdString* name, int width)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Allconst(*name->get_cpp_obj(), width));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Allconst(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Allconst(IdString* name, int width, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Allconst(*name->get_cpp_obj(), width, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Allseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Allseq(IdString* name)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Allseq(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Allseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Allseq(IdString* name, int width)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Allseq(*name->get_cpp_obj(), width));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Allseq(RTLIL::IdString name, int width = 1, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Allseq(IdString* name, int width, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Allseq(*name->get_cpp_obj(), width, src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Initstate(RTLIL::IdString name, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Initstate(IdString* name)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Initstate(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec Initstate(RTLIL::IdString name, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::Initstate(IdString* name, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->Initstate(*name->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec SetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::SetTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->SetTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_c->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec SetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::SetTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->SetTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_c->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSetTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c, const SigSpec* sig_y)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSetTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_y->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addSetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const RTLIL::SigSpec &sig_y, const std::string &src = "");" in kernel/rtlil
	Cell Module::addSetTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c, const SigSpec* sig_y, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addSetTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_c->get_cpp_obj(), *sig_y->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec GetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::GetTag(IdString* name, const string tag, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->GetTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec GetTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::GetTag(IdString* name, const string tag, const SigSpec* sig_a, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->GetTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOverwriteTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOverwriteTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOverwriteTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_c->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Cell* addOverwriteTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const RTLIL::SigSpec &sig_s, const RTLIL::SigSpec &sig_c, const std::string &src = "");" in kernel/rtlil
	Cell Module::addOverwriteTag(IdString* name, const string tag, const SigSpec* sig_a, const SigSpec* sig_s, const SigSpec* sig_c, const string src)
	{
		Cell* ret_ = Cell::get_py_obj(this->get_cpp_obj()->addOverwriteTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj(), *sig_s->get_cpp_obj(), *sig_c->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec OriginalTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::OriginalTag(IdString* name, const string tag, const SigSpec* sig_a)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->OriginalTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec OriginalTag(RTLIL::IdString name, const std::string &tag, const RTLIL::SigSpec &sig_a, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::OriginalTag(IdString* name, const string tag, const SigSpec* sig_a, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->OriginalTag(*name->get_cpp_obj(), tag, *sig_a->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec FutureFF(RTLIL::IdString name, const RTLIL::SigSpec &sig_e, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::FutureFF(IdString* name, const SigSpec* sig_e)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->FutureFF(*name->get_cpp_obj(), *sig_e->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec FutureFF(RTLIL::IdString name, const RTLIL::SigSpec &sig_e, const std::string &src = "");" in kernel/rtlil
	SigSpec Module::FutureFF(IdString* name, const SigSpec* sig_e, const string src)
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->FutureFF(*name->get_cpp_obj(), *sig_e->get_cpp_obj(), src));
		return *ret_;
	}

	// WRAPPED from "static std::map<unsigned int, RTLIL::Module*> *get_all_modules(void);" in kernel/rtlil
	boost::python::dict Module::get_all_modules(void )
	{
		std::map<unsigned int, YOSYS_NAMESPACE::RTLIL::Module*>* ret_ = YOSYS_NAMESPACE::RTLIL::Module::get_all_modules();
		boost::python::dict ret____tmp;
		for(auto tmp_220 : *ret_)
		{
			ret____tmp[tmp_220.first] = Module::get_py_obj(tmp_220.second);
		}
		return ret____tmp;
	}

	// WRAPPED from "bool has_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Module::has_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->has_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Module::set_bool_attribute(const IdString* id)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj());
	}

	// WRAPPED from "void set_bool_attribute(const RTLIL::IdString &id, bool value=true);" in kernel/rtlil
	void Module::set_bool_attribute(const IdString* id, bool value)
	{
		this->get_cpp_obj()->set_bool_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "bool get_bool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	bool Module::get_bool_attribute(const IdString* id)
	{
		bool ret_ = this->get_cpp_obj()->get_bool_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_string_attribute(const RTLIL::IdString& id, string value);" in kernel/rtlil
	void Module::set_string_attribute(const IdString* id, string value)
	{
		this->get_cpp_obj()->set_string_attribute(*id->get_cpp_obj(), value);
	}

	// WRAPPED from "string get_string_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	string Module::get_string_attribute(const IdString* id)
	{
		string ret_ = this->get_cpp_obj()->get_string_attribute(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void set_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Module::set_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_221 = 0; cntr_221 < len(data); cntr_221++)
		{
			string tmp_222 = boost::python::extract<string>(data[cntr_221]);
			data___tmp.insert(tmp_222);
		}
		this->get_cpp_obj()->set_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "void add_strpool_attribute(const RTLIL::IdString& id, const pool<string> &data);" in kernel/rtlil
	void Module::add_strpool_attribute(const IdString* id, const boost::python::list data)
	{
		pool<string> data___tmp;
		for(int cntr_223 = 0; cntr_223 < len(data); cntr_223++)
		{
			string tmp_224 = boost::python::extract<string>(data[cntr_223]);
			data___tmp.insert(tmp_224);
		}
		this->get_cpp_obj()->add_strpool_attribute(*id->get_cpp_obj(), data___tmp);
	}

	// WRAPPED from "pool<string> get_strpool_attribute(const RTLIL::IdString &id) const;" in kernel/rtlil
	boost::python::list Module::get_strpool_attribute(const IdString* id)
	{
		pool<string> ret_ = this->get_cpp_obj()->get_strpool_attribute(*id->get_cpp_obj());
		boost::python::list ret____tmp;
		for(auto tmp_225 : ret_)
		{
			ret____tmp.append(tmp_225);
		}
		return ret____tmp;
	}

	// WRAPPED from "void set_src_attribute(const std::string &src) {" in kernel/rtlil
	void Module::set_src_attribute(const string src)
	{
		this->get_cpp_obj()->set_src_attribute(src);
	}

	// WRAPPED from "std::string get_src_attribute() const {" in kernel/rtlil
	string Module::get_src_attribute() const
	{
		string ret_ = this->get_cpp_obj()->get_src_attribute();
		return ret_;
	}

	// WRAPPED from "Design();" in kernel/rtlil
	Design::Design()
	{
		this->ref_obj = new YOSYS_NAMESPACE::RTLIL::Design();
		this->hashidx_ = this->ref_obj->hashidx_;
	}

	boost::python::list Design::get_var_py_monitors()
	{
		pool<YOSYS_NAMESPACE::RTLIL::Monitor*> ret_ = this->get_cpp_obj()->monitors;
		boost::python::list ret____tmp;
		for(auto tmp_226 : ret_)
		{
			ret____tmp.append(Monitor::get_py_obj(tmp_226));
		}
		return ret____tmp;
	}

	void Design::set_var_py_monitors(boost::python::list rhs)
	{
		pool<YOSYS_NAMESPACE::RTLIL::Monitor*> rhs___tmp;
		for(int cntr_227 = 0; cntr_227 < len(rhs); cntr_227++)
		{
			Monitor* tmp_228 = boost::python::extract<Monitor*>(rhs[cntr_227]);
			rhs___tmp.insert(tmp_228->get_cpp_obj());
		}
		this->get_cpp_obj()->monitors = rhs___tmp;
	}

	boost::python::dict Design::get_var_py_scratchpad()
	{
		dict<string, string> ret_ = this->get_cpp_obj()->scratchpad;
		boost::python::dict ret____tmp;
		for(auto tmp_229 : ret_)
		{
			ret____tmp[tmp_229.first] = tmp_229.second;
		}
		return ret____tmp;
	}

	void Design::set_var_py_scratchpad(boost::python::dict rhs)
	{
		dict<string, string> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_230 = 0; cntr_230 < len(rhs_keylist); cntr_230++)
		{
			string key_tmp_231 = boost::python::extract<string>(rhs_keylist[ cntr_230 ]);
			string val_tmp_231 = boost::python::extract<string>(rhs[rhs_keylist[ cntr_230 ]]);
			rhs___tmp.insert(std::pair<string, string>(key_tmp_231, val_tmp_231));

		}
		this->get_cpp_obj()->scratchpad = rhs___tmp;
	}

	int Design::get_var_py_refcount_modules_()
	{
		int ret_ = this->get_cpp_obj()->refcount_modules_;
		return ret_;
	}

	void Design::set_var_py_refcount_modules_(int rhs)
	{
		this->get_cpp_obj()->refcount_modules_ = rhs;
	}

	boost::python::dict Design::get_var_py_modules_()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->modules_;
		boost::python::dict ret____tmp;
		for(auto tmp_232 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_232.first)] = Module::get_py_obj(tmp_232.second);
		}
		return ret____tmp;
	}

	void Design::set_var_py_modules_(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Module*> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_233 = 0; cntr_233 < len(rhs_keylist); cntr_233++)
		{
			IdString* key_tmp_234 = boost::python::extract<IdString*>(rhs_keylist[ cntr_233 ]);
			Module* val_tmp_234 = boost::python::extract<Module*>(rhs[rhs_keylist[ cntr_233 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Module*>(*key_tmp_234->get_cpp_obj(), val_tmp_234->get_cpp_obj()));

		}
		this->get_cpp_obj()->modules_ = rhs___tmp;
	}

	boost::python::list Design::get_var_py_selection_stack()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Selection> ret_ = this->get_cpp_obj()->selection_stack;
		boost::python::list ret____tmp;
		for(auto tmp_235 : ret_)
		{
			ret____tmp.append(*Selection::get_py_obj(&tmp_235));
		}
		return ret____tmp;
	}

	void Design::set_var_py_selection_stack(boost::python::list rhs)
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Selection> rhs___tmp;
		for(int cntr_236 = 0; cntr_236 < len(rhs); cntr_236++)
		{
			Selection* tmp_237 = boost::python::extract<Selection*>(rhs[cntr_236]);
			rhs___tmp.push_back(*tmp_237->get_cpp_obj());
		}
		this->get_cpp_obj()->selection_stack = rhs___tmp;
	}

	boost::python::dict Design::get_var_py_selection_vars()
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Selection> ret_ = this->get_cpp_obj()->selection_vars;
		boost::python::dict ret____tmp;
		for(auto tmp_238 : ret_)
		{
			ret____tmp[IdString::get_py_obj(tmp_238.first)] = *Selection::get_py_obj(&tmp_238.second);
		}
		return ret____tmp;
	}

	void Design::set_var_py_selection_vars(boost::python::dict rhs)
	{
		dict<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Selection> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_239 = 0; cntr_239 < len(rhs_keylist); cntr_239++)
		{
			IdString* key_tmp_240 = boost::python::extract<IdString*>(rhs_keylist[ cntr_239 ]);
			Selection* val_tmp_240 = boost::python::extract<Selection*>(rhs[rhs_keylist[ cntr_239 ]]);
			rhs___tmp.insert(std::pair<YOSYS_NAMESPACE::RTLIL::IdString, YOSYS_NAMESPACE::RTLIL::Selection>(*key_tmp_240->get_cpp_obj(), *val_tmp_240->get_cpp_obj()));

		}
		this->get_cpp_obj()->selection_vars = rhs___tmp;
	}

	string Design::get_var_py_selected_active_module()
	{
		string ret_ = this->get_cpp_obj()->selected_active_module;
		return ret_;
	}

	void Design::set_var_py_selected_active_module(string rhs)
	{
		this->get_cpp_obj()->selected_active_module = rhs;
	}

	// WRAPPED from "void bufNormalize(bool enable=true);" in kernel/rtlil
	void Design::bufNormalize()
	{
		this->get_cpp_obj()->bufNormalize();
	}

	// WRAPPED from "void bufNormalize(bool enable=true);" in kernel/rtlil
	void Design::bufNormalize(bool enable)
	{
		this->get_cpp_obj()->bufNormalize(enable);
	}

	// WRAPPED from "RTLIL::ObjRange<RTLIL::Module*> modules();" in kernel/rtlil
	boost::python::list Design::modules()
	{
		RTLIL::ObjRange<YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->modules();
		boost::python::list ret____tmp;
		for(auto tmp_241 : ret_)
		{
			ret____tmp.append(Module::get_py_obj(tmp_241));
		}
		return ret____tmp;
	}

	// WRAPPED from "RTLIL::Module *module(const RTLIL::IdString &name);" in kernel/rtlil
	Module Design::module(const IdString* name)
	{
		Module* ret_ = Module::get_py_obj(this->get_cpp_obj()->module(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Module *top_module() const;" in kernel/rtlil
	Module Design::top_module()
	{
		Module* ret_ = Module::get_py_obj(this->get_cpp_obj()->top_module());
		return *ret_;
	}

	// WRAPPED from "bool has(const RTLIL::IdString &id) const {" in kernel/rtlil
	bool Design::has(const IdString* id) const
	{
		bool ret_ = this->get_cpp_obj()->has(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void add(RTLIL::Module *module);" in kernel/rtlil
	void Design::add(Module* module)
	{
		this->get_cpp_obj()->add(module->get_cpp_obj());
	}

	// WRAPPED from "RTLIL::Module *addModule(RTLIL::IdString name);" in kernel/rtlil
	Module Design::addModule(IdString* name)
	{
		Module* ret_ = Module::get_py_obj(this->get_cpp_obj()->addModule(*name->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "void remove(RTLIL::Module *module);" in kernel/rtlil
	void Design::remove(Module* module)
	{
		this->get_cpp_obj()->remove(module->get_cpp_obj());
	}

	// WRAPPED from "void rename(RTLIL::Module *module, RTLIL::IdString new_name);" in kernel/rtlil
	void Design::rename(Module* module, IdString* new_name)
	{
		this->get_cpp_obj()->rename(module->get_cpp_obj(), *new_name->get_cpp_obj());
	}

	// WRAPPED from "void scratchpad_unset(const std::string &varname);" in kernel/rtlil
	void Design::scratchpad_unset(const string varname)
	{
		this->get_cpp_obj()->scratchpad_unset(varname);
	}

	// WRAPPED from "void scratchpad_set_int(const std::string &varname, int value);" in kernel/rtlil
	void Design::scratchpad_set_int(const string varname, int value)
	{
		this->get_cpp_obj()->scratchpad_set_int(varname, value);
	}

	// WRAPPED from "void scratchpad_set_bool(const std::string &varname, bool value);" in kernel/rtlil
	void Design::scratchpad_set_bool(const string varname, bool value)
	{
		this->get_cpp_obj()->scratchpad_set_bool(varname, value);
	}

	// WRAPPED from "void scratchpad_set_string(const std::string &varname, std::string value);" in kernel/rtlil
	void Design::scratchpad_set_string(const string varname, string value)
	{
		this->get_cpp_obj()->scratchpad_set_string(varname, value);
	}

	// WRAPPED from "int scratchpad_get_int(const std::string &varname, int default_value = 0) const;" in kernel/rtlil
	int Design::scratchpad_get_int(const string varname)
	{
		int ret_ = this->get_cpp_obj()->scratchpad_get_int(varname);
		return ret_;
	}

	// WRAPPED from "int scratchpad_get_int(const std::string &varname, int default_value = 0) const;" in kernel/rtlil
	int Design::scratchpad_get_int(const string varname, int default_value)
	{
		int ret_ = this->get_cpp_obj()->scratchpad_get_int(varname, default_value);
		return ret_;
	}

	// WRAPPED from "bool scratchpad_get_bool(const std::string &varname, bool default_value = false) const;" in kernel/rtlil
	bool Design::scratchpad_get_bool(const string varname)
	{
		bool ret_ = this->get_cpp_obj()->scratchpad_get_bool(varname);
		return ret_;
	}

	// WRAPPED from "bool scratchpad_get_bool(const std::string &varname, bool default_value = false) const;" in kernel/rtlil
	bool Design::scratchpad_get_bool(const string varname, bool default_value)
	{
		bool ret_ = this->get_cpp_obj()->scratchpad_get_bool(varname, default_value);
		return ret_;
	}

	// WRAPPED from "std::string scratchpad_get_string(const std::string &varname, const std::string &default_value = std::string()) const;" in kernel/rtlil
	string Design::scratchpad_get_string(const string varname)
	{
		string ret_ = this->get_cpp_obj()->scratchpad_get_string(varname);
		return ret_;
	}

	// WRAPPED from "std::string scratchpad_get_string(const std::string &varname, const std::string &default_value = std::string()) const;" in kernel/rtlil
	string Design::scratchpad_get_string(const string varname, const string default_value)
	{
		string ret_ = this->get_cpp_obj()->scratchpad_get_string(varname, default_value);
		return ret_;
	}

	// WRAPPED from "void sort();" in kernel/rtlil
	void Design::sort()
	{
		this->get_cpp_obj()->sort();
	}

	// WRAPPED from "void check();" in kernel/rtlil
	void Design::check()
	{
		this->get_cpp_obj()->check();
	}

	// WRAPPED from "void optimize();" in kernel/rtlil
	void Design::optimize()
	{
		this->get_cpp_obj()->optimize();
	}

	// WRAPPED from "bool selected_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
	bool Design::selected_module(const IdString* mod_name)
	{
		bool ret_ = this->get_cpp_obj()->selected_module(*mod_name->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool selected_whole_module(const RTLIL::IdString &mod_name) const;" in kernel/rtlil
	bool Design::selected_whole_module(const IdString* mod_name)
	{
		bool ret_ = this->get_cpp_obj()->selected_whole_module(*mod_name->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool selected_member(const RTLIL::IdString &mod_name, const RTLIL::IdString &memb_name) const;" in kernel/rtlil
	bool Design::selected_member(const IdString* mod_name, const IdString* memb_name)
	{
		bool ret_ = this->get_cpp_obj()->selected_member(*mod_name->get_cpp_obj(), *memb_name->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool selected_module(RTLIL::Module *mod) const;" in kernel/rtlil
	bool Design::selected_module(Module* mod)
	{
		bool ret_ = this->get_cpp_obj()->selected_module(mod->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool selected_whole_module(RTLIL::Module *mod) const;" in kernel/rtlil
	bool Design::selected_whole_module(Module* mod)
	{
		bool ret_ = this->get_cpp_obj()->selected_whole_module(mod->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void push_selection(RTLIL::Selection sel);" in kernel/rtlil
	void Design::push_selection(Selection* sel)
	{
		this->get_cpp_obj()->push_selection(*sel->get_cpp_obj());
	}

	// WRAPPED from "void push_empty_selection();" in kernel/rtlil
	void Design::push_empty_selection()
	{
		this->get_cpp_obj()->push_empty_selection();
	}

	// WRAPPED from "void push_full_selection();" in kernel/rtlil
	void Design::push_full_selection()
	{
		this->get_cpp_obj()->push_full_selection();
	}

	// WRAPPED from "void push_complete_selection();" in kernel/rtlil
	void Design::push_complete_selection()
	{
		this->get_cpp_obj()->push_complete_selection();
	}

	// WRAPPED from "void pop_selection();" in kernel/rtlil
	void Design::pop_selection()
	{
		this->get_cpp_obj()->pop_selection();
	}

	// WRAPPED from "RTLIL::Selection &selection() {" in kernel/rtlil
	Selection Design::selection()
	{
		Selection* ret_ = Selection::get_py_obj(this->get_cpp_obj()->selection());
		return *ret_;
	}

	// WRAPPED from "bool full_selection() const {" in kernel/rtlil
	bool Design::full_selection() const
	{
		bool ret_ = this->get_cpp_obj()->full_selection();
		return ret_;
	}

	// WRAPPED from "std::vector<RTLIL::Module*> all_selected_modules() const { return selected_modules(SELECT_ALL, SB_ALL); }" in kernel/rtlil
	boost::python::list Design::all_selected_modules() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->all_selected_modules();
		boost::python::list ret____tmp;
		for(auto tmp_242 : ret_)
		{
			ret____tmp.append(Module::get_py_obj(tmp_242));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Module*> selected_unboxed_modules() const { return selected_modules(SELECT_ALL, SB_UNBOXED_ONLY); }" in kernel/rtlil
	boost::python::list Design::selected_unboxed_modules() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->selected_unboxed_modules();
		boost::python::list ret____tmp;
		for(auto tmp_243 : ret_)
		{
			ret____tmp.append(Module::get_py_obj(tmp_243));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Module*> selected_unboxed_modules_warn() const { return selected_modules(SELECT_ALL, SB_UNBOXED_WARN); }" in kernel/rtlil
	boost::python::list Design::selected_unboxed_modules_warn() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->selected_unboxed_modules_warn();
		boost::python::list ret____tmp;
		for(auto tmp_244 : ret_)
		{
			ret____tmp.append(Module::get_py_obj(tmp_244));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Module*> selected_whole_modules() const { return selected_modules(SELECT_WHOLE_ONLY, SB_UNBOXED_WARN); }" in kernel/rtlil
	boost::python::list Design::selected_whole_modules() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->selected_whole_modules();
		boost::python::list ret____tmp;
		for(auto tmp_245 : ret_)
		{
			ret____tmp.append(Module::get_py_obj(tmp_245));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Module*> all_selected_whole_modules() const { return selected_modules(SELECT_WHOLE_ONLY, SB_ALL); }" in kernel/rtlil
	boost::python::list Design::all_selected_whole_modules() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->all_selected_whole_modules();
		boost::python::list ret____tmp;
		for(auto tmp_246 : ret_)
		{
			ret____tmp.append(Module::get_py_obj(tmp_246));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Module*> selected_unboxed_whole_modules() const { return selected_modules(SELECT_WHOLE_ONLY, SB_UNBOXED_ONLY); }" in kernel/rtlil
	boost::python::list Design::selected_unboxed_whole_modules() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->selected_unboxed_whole_modules();
		boost::python::list ret____tmp;
		for(auto tmp_247 : ret_)
		{
			ret____tmp.append(Module::get_py_obj(tmp_247));
		}
		return ret____tmp;
	}

	// WRAPPED from "std::vector<RTLIL::Module*> selected_unboxed_whole_modules_warn() const { return selected_modules(SELECT_WHOLE_WARN, SB_UNBOXED_WARN); }" in kernel/rtlil
	boost::python::list Design::selected_unboxed_whole_modules_warn() const
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Module*> ret_ = this->get_cpp_obj()->selected_unboxed_whole_modules_warn();
		boost::python::list ret____tmp;
		for(auto tmp_248 : ret_)
		{
			ret____tmp.append(Module::get_py_obj(tmp_248));
		}
		return ret____tmp;
	}

	// WRAPPED from "static std::map<unsigned int, RTLIL::Design*> *get_all_designs(void);" in kernel/rtlil
	boost::python::dict Design::get_all_designs(void )
	{
		std::map<unsigned int, YOSYS_NAMESPACE::RTLIL::Design*>* ret_ = YOSYS_NAMESPACE::RTLIL::Design::get_all_designs();
		boost::python::dict ret____tmp;
		for(auto tmp_249 : *ret_)
		{
			ret____tmp[tmp_249.first] = Design::get_py_obj(tmp_249.second);
		}
		return ret____tmp;
	}

	// WRAPPED from "SigMap(RTLIL::Module *module = NULL)" in kernel/sigtools
	SigMap::SigMap(Module* module)
	{
		this->ref_obj = new YOSYS_NAMESPACE::SigMap(module->get_cpp_obj());
	}

	// WRAPPED from "void swap(SigMap &other)" in kernel/sigtools
	void SigMap::swap(SigMap* other)
	{
		this->get_cpp_obj()->swap(*other->get_cpp_obj());
	}

	// WRAPPED from "void clear()" in kernel/sigtools
	void SigMap::clear()
	{
		this->get_cpp_obj()->clear();
	}

	// WRAPPED from "void set(RTLIL::Module *module)" in kernel/sigtools
	void SigMap::set(Module* module)
	{
		this->get_cpp_obj()->set(module->get_cpp_obj());
	}

	// WRAPPED from "void add(const RTLIL::SigSpec& from, const RTLIL::SigSpec& to)" in kernel/sigtools
	void SigMap::add(const SigSpec* from, const SigSpec* to)
	{
		this->get_cpp_obj()->add(*from->get_cpp_obj(), *to->get_cpp_obj());
	}

	// WRAPPED from "void add(const RTLIL::SigBit &bit)" in kernel/sigtools
	void SigMap::add(const SigBit* bit)
	{
		this->get_cpp_obj()->add(*bit->get_cpp_obj());
	}

	// WRAPPED from "void add(const RTLIL::SigSpec &sig)" in kernel/sigtools
	void SigMap::add(const SigSpec* sig)
	{
		this->get_cpp_obj()->add(*sig->get_cpp_obj());
	}

	// WRAPPED from "inline void add(Wire *wire) { return add(RTLIL::SigSpec(wire)); }" in kernel/sigtools
	void SigMap::add(Wire* wire)
	{
		this->get_cpp_obj()->add(wire->get_cpp_obj());
	}

	// WRAPPED from "void apply(RTLIL::SigBit &bit) const" in kernel/sigtools
	void SigMap::apply(SigBit* bit) const
	{
		this->get_cpp_obj()->apply(*bit->get_cpp_obj());
	}

	// WRAPPED from "void apply(RTLIL::SigSpec &sig) const" in kernel/sigtools
	void SigMap::apply(SigSpec* sig) const
	{
		this->get_cpp_obj()->apply(*sig->get_cpp_obj());
	}

	// WRAPPED from "RTLIL::SigBit operator()(RTLIL::SigBit bit) const" in kernel/sigtools
	SigBit SigMap::operator()(SigBit* bit) const
	{
		SigBit* ret_ = SigBit::get_py_obj(this->get_cpp_obj()->operator()(*bit->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec operator()(RTLIL::SigSpec sig) const" in kernel/sigtools
	SigSpec SigMap::operator()(SigSpec* sig) const
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->operator()(*sig->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec operator()(RTLIL::Wire *wire) const" in kernel/sigtools
	SigSpec SigMap::operator()(Wire* wire) const
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->operator()(wire->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::SigSpec allbits() const" in kernel/sigtools
	SigSpec SigMap::allbits() const
	{
		SigSpec* ret_ = SigSpec::get_py_obj(this->get_cpp_obj()->allbits());
		return *ret_;
	}

	// WRAPPED from "void log(const char_p format, ...) YS_ATTRIBUTE(format(printf, 1, 2));" in kernel/log
	void log(const char * format)
	{
		::YOSYS_NAMESPACE::log("%s", format);
	}

	// WRAPPED from "void log_header(RTLIL::Design *design, const char_p format, ...) YS_ATTRIBUTE(format(printf, 2, 3));" in kernel/log
	void log_header(Design* design, const char * format)
	{
		::YOSYS_NAMESPACE::log_header(design->get_cpp_obj(), "%s", format);
	}

	// WRAPPED from "void log_warning(const char_p format, ...) YS_ATTRIBUTE(format(printf, 1, 2));" in kernel/log
	void log_warning(const char * format)
	{
		::YOSYS_NAMESPACE::log_warning("%s", format);
	}

	// WRAPPED from "void log_experimental(const char_p format, ...) YS_ATTRIBUTE(format(printf, 1, 2));" in kernel/log
	void log_experimental(const char * format)
	{
		::YOSYS_NAMESPACE::log_experimental("%s", format);
	}

	// WRAPPED from "void log_file_warning(const std::string &filename, int lineno, const char_p format, ...) YS_ATTRIBUTE(format(printf, 3, 4));" in kernel/log
	void log_file_warning(const string filename, int lineno, const char * format)
	{
		::YOSYS_NAMESPACE::log_file_warning(filename, lineno, "%s", format);
	}

	// WRAPPED from "void log_file_info(const std::string &filename, int lineno, const char_p format, ...) YS_ATTRIBUTE(format(printf, 3, 4));" in kernel/log
	void log_file_info(const string filename, int lineno, const char * format)
	{
		::YOSYS_NAMESPACE::log_file_info(filename, lineno, "%s", format);
	}

	// WRAPPED from "void log_warning_noprefix(const char_p format, ...) YS_ATTRIBUTE(format(printf, 1, 2));" in kernel/log
	void log_warning_noprefix(const char * format)
	{
		::YOSYS_NAMESPACE::log_warning_noprefix("%s", format);
	}

	// WRAPPED from "[[noreturn]] void log_error(const char_p format, ...) YS_ATTRIBUTE(format(printf, 1, 2));" in kernel/log
	void log_error(const char * format)
	{
		::YOSYS_NAMESPACE::log_error("%s", format);
	}

	// WRAPPED from "[[noreturn]] void log_file_error(const string &filename, int lineno, const char_p format, ...) YS_ATTRIBUTE(format(printf, 3, 4));" in kernel/log
	void log_file_error(const string filename, int lineno, const char * format)
	{
		::YOSYS_NAMESPACE::log_file_error(filename, lineno, "%s", format);
	}

	// WRAPPED from "[[noreturn]] void log_cmd_error(const char_p format, ...) YS_ATTRIBUTE(format(printf, 1, 2));" in kernel/log
	void log_cmd_error(const char * format)
	{
		::YOSYS_NAMESPACE::log_cmd_error("%s", format);
	}

	// WRAPPED from "static inline bool ys_debug(int n = 0) { if(log_force_debug) return true; log_debug_suppressed += n; return false; }" in kernel/log
	bool ys_debug()
	{
		bool ret_ = ::YOSYS_NAMESPACE::ys_debug();
		return ret_;
	}

	// WRAPPED from "static inline bool ys_debug(int n = 0) { if(log_force_debug) return true; log_debug_suppressed += n; return false; }" in kernel/log
	bool ys_debug(int n)
	{
		bool ret_ = ::YOSYS_NAMESPACE::ys_debug(n);
		return ret_;
	}

	// WRAPPED from "static inline void log_suppressed() {" in kernel/log
	void log_suppressed()
	{
		::YOSYS_NAMESPACE::log_suppressed();
	}

	// WRAPPED from "void log_spacer();" in kernel/log
	void log_spacer()
	{
		::YOSYS_NAMESPACE::log_spacer();
	}

	// WRAPPED from "void log_push();" in kernel/log
	void log_push()
	{
		::YOSYS_NAMESPACE::log_push();
	}

	// WRAPPED from "void log_pop();" in kernel/log
	void log_pop()
	{
		::YOSYS_NAMESPACE::log_pop();
	}

	// WRAPPED from "void log_backtrace(const char_p prefix, int levels);" in kernel/log
	void log_backtrace(const char * prefix, int levels)
	{
		::YOSYS_NAMESPACE::log_backtrace(prefix, levels);
	}

	// WRAPPED from "void log_reset_stack();" in kernel/log
	void log_reset_stack()
	{
		::YOSYS_NAMESPACE::log_reset_stack();
	}

	// WRAPPED from "void log_flush();" in kernel/log
	void log_flush()
	{
		::YOSYS_NAMESPACE::log_flush();
	}

	// WRAPPED from "void log_check_expected();" in kernel/log
	void log_check_expected()
	{
		::YOSYS_NAMESPACE::log_check_expected();
	}

	// WRAPPED from "const char_p log_signal(const RTLIL::SigSpec &sig, bool autoint = true);" in kernel/log
	const char * log_signal(const SigSpec* sig)
	{
		const char * ret_ = ::YOSYS_NAMESPACE::log_signal(*sig->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "const char_p log_signal(const RTLIL::SigSpec &sig, bool autoint = true);" in kernel/log
	const char * log_signal(const SigSpec* sig, bool autoint)
	{
		const char * ret_ = ::YOSYS_NAMESPACE::log_signal(*sig->get_cpp_obj(), autoint);
		return ret_;
	}

	// WRAPPED from "const char_p log_const(const RTLIL::Const &value, bool autoint = true);" in kernel/log
	const char * log_const(const Const* value)
	{
		const char * ret_ = ::YOSYS_NAMESPACE::log_const(*value->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "const char_p log_const(const RTLIL::Const &value, bool autoint = true);" in kernel/log
	const char * log_const(const Const* value, bool autoint)
	{
		const char * ret_ = ::YOSYS_NAMESPACE::log_const(*value->get_cpp_obj(), autoint);
		return ret_;
	}

	// WRAPPED from "const char_p log_id(const RTLIL::IdString &id);" in kernel/log
	const char * log_id(const IdString* id)
	{
		const char * ret_ = ::YOSYS_NAMESPACE::log_id(*id->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "const char_p log_str(const char_p str);" in kernel/log
	const char * log_str(const char * str)
	{
		const char * ret_ = ::YOSYS_NAMESPACE::log_str(str);
		return ret_;
	}

	// WRAPPED from "void log_module(RTLIL::Module *module, std::string indent = "");" in kernel/log
	void log_module(Module* module)
	{
		::YOSYS_NAMESPACE::log_module(module->get_cpp_obj());
	}

	// WRAPPED from "void log_module(RTLIL::Module *module, std::string indent = "");" in kernel/log
	void log_module(Module* module, string indent)
	{
		::YOSYS_NAMESPACE::log_module(module->get_cpp_obj(), indent);
	}

	// WRAPPED from "void log_cell(RTLIL::Cell *cell, std::string indent = "");" in kernel/log
	void log_cell(Cell* cell)
	{
		::YOSYS_NAMESPACE::log_cell(cell->get_cpp_obj());
	}

	// WRAPPED from "void log_cell(RTLIL::Cell *cell, std::string indent = "");" in kernel/log
	void log_cell(Cell* cell, string indent)
	{
		::YOSYS_NAMESPACE::log_cell(cell->get_cpp_obj(), indent);
	}

	// WRAPPED from "void log_wire(RTLIL::Wire *wire, std::string indent = "");" in kernel/log
	void log_wire(Wire* wire)
	{
		::YOSYS_NAMESPACE::log_wire(wire->get_cpp_obj());
	}

	// WRAPPED from "void log_wire(RTLIL::Wire *wire, std::string indent = "");" in kernel/log
	void log_wire(Wire* wire, string indent)
	{
		::YOSYS_NAMESPACE::log_wire(wire->get_cpp_obj(), indent);
	}

	// WRAPPED from "static inline void log_assert_worker(bool cond, const char_p expr, const char_p file, int line) {" in kernel/log
	void log_assert_worker(bool cond, const char * expr, const char * file, int line)
	{
		::YOSYS_NAMESPACE::log_assert_worker(cond, expr, file, line);
	}

	// WRAPPED from "void cover_extra(std::string parent, std::string id, bool increment = true);" in kernel/log
	void cover_extra(string parent, string id)
	{
		::YOSYS_NAMESPACE::cover_extra(parent, id);
	}

	// WRAPPED from "void cover_extra(std::string parent, std::string id, bool increment = true);" in kernel/log
	void cover_extra(string parent, string id, bool increment)
	{
		::YOSYS_NAMESPACE::cover_extra(parent, id, increment);
	}

	// WRAPPED from "dict<std::string, std::pair<std::string, int>> get_coverage_data();" in kernel/log
	boost::python::dict get_coverage_data()
	{
		dict<string, std::pair<string, int>> ret_ = ::YOSYS_NAMESPACE::get_coverage_data();
		boost::python::dict ret____tmp;
		for(auto tmp_250 : ret_)
		{
			auto tmp_250_second = tmp_250.second;
			boost::python::tuple tmp_250_second___tmp = boost::python::make_tuple(tmp_250_second.first, tmp_250_second.second);
			ret____tmp[tmp_250.first] = tmp_250_second___tmp;
		}
		return ret____tmp;
	}

	// WRAPPED from "static inline std::string cover_list_worker(std::string, std::string last) {" in kernel/log
	string cover_list_worker(string gen_varname_11, string last)
	{
		string ret_ = ::YOSYS_NAMESPACE::cover_list_worker(gen_varname_11, last);
		return ret_;
	}

	// WRAPPED from "static inline void log_dump_val_worker(int v) { log("%d", v); }" in kernel/log
	void log_dump_val_worker(int v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_val_worker(unsigned int v) { log("%u", v); }" in kernel/log
	void log_dump_val_worker(unsigned int v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_val_worker(long int v) { log("%ld", v); }" in kernel/log
	void log_dump_val_worker(long int v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_val_worker(long long int v) { log("%lld", v); }" in kernel/log
	void log_dump_val_worker(long long int v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_val_worker(bool v) { log("%s", v ? "true" : "false"); }" in kernel/log
	void log_dump_val_worker(bool v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_val_worker(double v) { log("%f", v); }" in kernel/log
	void log_dump_val_worker(double v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_val_worker(char_p v) { log("%s", v); }" in kernel/log
	void log_dump_val_worker(char * v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_val_worker(const char_p v) { log("%s", v); }" in kernel/log
	void log_dump_val_worker(const char * v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_val_worker(std::string v) { log("%s", v.c_str()); }" in kernel/log
	void log_dump_val_worker(string v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "static inline void log_dump_args_worker(const char_p p) { YOSYS_NAMESPACE_PREFIX log_assert_worker(*p == 0, "*p == 0", "<stdin>", 353); }" in kernel/log
	void log_dump_args_worker(const char * p)
	{
		::YOSYS_NAMESPACE::log_dump_args_worker(p);
	}

	// WRAPPED from "void log_dump_val_worker(RTLIL::IdString v);" in kernel/log
	void log_dump_val_worker(IdString* v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(*v->get_cpp_obj());
	}

	// WRAPPED from "void log_dump_val_worker(RTLIL::SigSpec v);" in kernel/log
	void log_dump_val_worker(SigSpec* v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(*v->get_cpp_obj());
	}

	// WRAPPED from "void log_dump_val_worker(RTLIL::State v);" in kernel/log
	void log_dump_val_worker(State v)
	{
		::YOSYS_NAMESPACE::log_dump_val_worker(v);
	}

	// WRAPPED from "const pool<IdString> &builtin_ff_cell_types();" in kernel/rtlil
	boost::python::list builtin_ff_cell_types()
	{
		pool<YOSYS_NAMESPACE::RTLIL::IdString> ret_ = ::YOSYS_NAMESPACE::RTLIL::builtin_ff_cell_types();
		boost::python::list ret____tmp;
		for(auto tmp_251 : ret_)
		{
			ret____tmp.append(*IdString::get_py_obj(&tmp_251));
		}
		return ret____tmp;
	}

	// WRAPPED from "static inline std::string escape_id(const std::string &str) {" in kernel/rtlil
	string escape_id(const string str)
	{
		string ret_ = ::YOSYS_NAMESPACE::RTLIL::escape_id(str);
		return ret_;
	}

	// WRAPPED from "static inline std::string unescape_id(const std::string &str) {" in kernel/rtlil
	string unescape_id(const string str)
	{
		string ret_ = ::YOSYS_NAMESPACE::RTLIL::unescape_id(str);
		return ret_;
	}

	// WRAPPED from "static inline std::string unescape_id(const RTLIL::IdString &str) {" in kernel/rtlil
	string unescape_id(const IdString* str)
	{
		string ret_ = ::YOSYS_NAMESPACE::RTLIL::unescape_id(*str->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "static inline const char_p id2cstr(const RTLIL::IdString &str) {" in kernel/rtlil
	const char * id2cstr(const IdString* str)
	{
		const char * ret_ = ::YOSYS_NAMESPACE::RTLIL::id2cstr(*str->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "static inline std::string encode_filename(const std::string &filename)" in kernel/rtlil
	string encode_filename(const string filename)
	{
		string ret_ = ::YOSYS_NAMESPACE::RTLIL::encode_filename(filename);
		return ret_;
	}

	// WRAPPED from "RTLIL::Const const_not(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_not(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_not(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_and(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_and(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_and(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_or(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_or(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_or(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_xor(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_xor(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_xor(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_xnor(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_xnor(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_xnor(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_reduce_and(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_reduce_and(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_reduce_and(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_reduce_or(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_reduce_or(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_reduce_or(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_reduce_xor(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_reduce_xor(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_reduce_xor(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_reduce_xnor(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_reduce_xnor(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_reduce_xnor(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_reduce_bool(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_reduce_bool(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_reduce_bool(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_logic_not(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_logic_not(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_logic_not(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_logic_and(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_logic_and(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_logic_and(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_logic_or(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_logic_or(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_logic_or(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_shl(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_shl(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_shl(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_shr(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_shr(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_shr(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_sshl(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_sshl(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_sshl(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_sshr(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_sshr(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_sshr(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_shift(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_shift(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_shift(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_shiftx(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_shiftx(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_shiftx(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_lt(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_lt(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_lt(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_le(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_le(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_le(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_eq(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_eq(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_eq(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_ne(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_ne(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_ne(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_eqx(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_eqx(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_eqx(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_nex(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_nex(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_nex(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_ge(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_ge(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_ge(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_gt(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_gt(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_gt(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_add(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_add(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_add(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_sub(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_sub(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_sub(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_mul(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_mul(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_mul(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_div(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_div(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_div(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_divfloor(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_divfloor(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_divfloor(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_modfloor(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_modfloor(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_modfloor(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_mod(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_mod(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_mod(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_pow(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_pow(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_pow(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_pos(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_pos(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_pos(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_buf(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_buf(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_buf(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_neg(const RTLIL::Const &arg1, const RTLIL::Const &arg2, bool signed1, bool signed2, int result_len);" in kernel/rtlil
	Const const_neg(const Const* arg1, const Const* arg2, bool signed1, bool signed2, int result_len)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_neg(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), signed1, signed2, result_len));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_mux(const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3);" in kernel/rtlil
	Const const_mux(const Const* arg1, const Const* arg2, const Const* arg3)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_mux(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), *arg3->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_pmux(const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3);" in kernel/rtlil
	Const const_pmux(const Const* arg1, const Const* arg2, const Const* arg3)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_pmux(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), *arg3->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_bmux(const RTLIL::Const &arg1, const RTLIL::Const &arg2);" in kernel/rtlil
	Const const_bmux(const Const* arg1, const Const* arg2)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_bmux(*arg1->get_cpp_obj(), *arg2->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_demux(const RTLIL::Const &arg1, const RTLIL::Const &arg2);" in kernel/rtlil
	Const const_demux(const Const* arg1, const Const* arg2)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_demux(*arg1->get_cpp_obj(), *arg2->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_bweqx(const RTLIL::Const &arg1, const RTLIL::Const &arg2);" in kernel/rtlil
	Const const_bweqx(const Const* arg1, const Const* arg2)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_bweqx(*arg1->get_cpp_obj(), *arg2->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "RTLIL::Const const_bwmux(const RTLIL::Const &arg1, const RTLIL::Const &arg2, const RTLIL::Const &arg3);" in kernel/rtlil
	Const const_bwmux(const Const* arg1, const Const* arg2, const Const* arg3)
	{
		Const* ret_ = Const::get_py_obj(::YOSYS_NAMESPACE::RTLIL::const_bwmux(*arg1->get_cpp_obj(), *arg2->get_cpp_obj(), *arg3->get_cpp_obj()));
		return *ret_;
	}

	// WRAPPED from "inline int GetSize(RTLIL::Wire *wire) {" in kernel/rtlil
	int GetSize(Wire* wire)
	{
		int ret_ = ::YOSYS_NAMESPACE::GetSize(wire->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "void yosys_setup();" in kernel/yosys
	void yosys_setup()
	{
		::YOSYS_NAMESPACE::yosys_setup();
	}

	// WRAPPED from "bool yosys_already_setup();" in kernel/yosys
	bool yosys_already_setup()
	{
		bool ret_ = ::YOSYS_NAMESPACE::yosys_already_setup();
		return ret_;
	}

	// WRAPPED from "void yosys_shutdown();" in kernel/yosys
	void yosys_shutdown()
	{
		::YOSYS_NAMESPACE::yosys_shutdown();
	}

	// WRAPPED from "RTLIL::Design *yosys_get_design();" in kernel/yosys
	Design yosys_get_design()
	{
		Design* ret_ = Design::get_py_obj(::YOSYS_NAMESPACE::yosys_get_design());
		return *ret_;
	}

	// WRAPPED from "std::string proc_self_dirname();" in kernel/yosys
	string proc_self_dirname()
	{
		string ret_ = ::YOSYS_NAMESPACE::proc_self_dirname();
		return ret_;
	}

	// WRAPPED from "std::string proc_share_dirname();" in kernel/yosys
	string proc_share_dirname()
	{
		string ret_ = ::YOSYS_NAMESPACE::proc_share_dirname();
		return ret_;
	}

	// WRAPPED from "std::string proc_program_prefix();" in kernel/yosys
	string proc_program_prefix()
	{
		string ret_ = ::YOSYS_NAMESPACE::proc_program_prefix();
		return ret_;
	}

	// WRAPPED from "const char_p create_prompt(RTLIL::Design *design, int recursion_counter);" in kernel/yosys
	const char * create_prompt(Design* design, int recursion_counter)
	{
		const char * ret_ = ::YOSYS_NAMESPACE::create_prompt(design->get_cpp_obj(), recursion_counter);
		return ret_;
	}

	// WRAPPED from "std::vector<std::string> glob_filename(const std::string &filename_pattern);" in kernel/yosys
	boost::python::list glob_filename(const string filename_pattern)
	{
		std::vector<string> ret_ = ::YOSYS_NAMESPACE::glob_filename(filename_pattern);
		boost::python::list ret____tmp;
		for(auto tmp_252 : ret_)
		{
			ret____tmp.append(tmp_252);
		}
		return ret____tmp;
	}

	// WRAPPED from "void rewrite_filename(std::string &filename);" in kernel/yosys
	void rewrite_filename(string filename)
	{
		::YOSYS_NAMESPACE::rewrite_filename(filename);
	}

	// WRAPPED from "void run_pass(std::string command, RTLIL::Design *design = nullptr);" in kernel/yosys
	void run_pass(string command)
	{
		::YOSYS_NAMESPACE::run_pass(command);
	}

	// WRAPPED from "void run_pass(std::string command, RTLIL::Design *design = nullptr);" in kernel/yosys
	void run_pass(string command, Design* design)
	{
		::YOSYS_NAMESPACE::run_pass(command, design->get_cpp_obj());
	}

	// WRAPPED from "bool run_frontend(std::string filename, std::string command, RTLIL::Design *design = nullptr, std::string *from_to_label = nullptr);" in kernel/yosys
	bool run_frontend(string filename, string command)
	{
		bool ret_ = ::YOSYS_NAMESPACE::run_frontend(filename, command);
		return ret_;
	}

	// WRAPPED from "bool run_frontend(std::string filename, std::string command, RTLIL::Design *design = nullptr, std::string *from_to_label = nullptr);" in kernel/yosys
	bool run_frontend(string filename, string command, Design* design)
	{
		bool ret_ = ::YOSYS_NAMESPACE::run_frontend(filename, command, design->get_cpp_obj());
		return ret_;
	}

	// WRAPPED from "bool run_frontend(std::string filename, std::string command, RTLIL::Design *design = nullptr, std::string *from_to_label = nullptr);" in kernel/yosys
	bool run_frontend(string filename, string command, Design* design, string from_to_label)
	{
		bool ret_ = ::YOSYS_NAMESPACE::run_frontend(filename, command, design->get_cpp_obj(), &from_to_label);
		return ret_;
	}

	// WRAPPED from "void run_backend(std::string filename, std::string command, RTLIL::Design *design = nullptr);" in kernel/yosys
	void run_backend(string filename, string command)
	{
		::YOSYS_NAMESPACE::run_backend(filename, command);
	}

	// WRAPPED from "void run_backend(std::string filename, std::string command, RTLIL::Design *design = nullptr);" in kernel/yosys
	void run_backend(string filename, string command, Design* design)
	{
		::YOSYS_NAMESPACE::run_backend(filename, command, design->get_cpp_obj());
	}

	// WRAPPED from "void shell(RTLIL::Design *design);" in kernel/yosys
	void shell(Design* design)
	{
		::YOSYS_NAMESPACE::shell(design->get_cpp_obj());
	}

	// WRAPPED from "const char_p yosys_maybe_version();" in kernel/yosys
	const char * yosys_maybe_version()
	{
		const char * ret_ = ::YOSYS_NAMESPACE::yosys_maybe_version();
		return ret_;
	}

	// WRAPPED from "void load_plugin(std::string filename, std::vector<std::string> aliases);" in kernel/yosys
	void load_plugin(string filename, boost::python::list aliases)
	{
		std::vector<string> aliases___tmp;
		for(int cntr_253 = 0; cntr_253 < len(aliases); cntr_253++)
		{
			string tmp_254 = boost::python::extract<string>(aliases[cntr_253]);
			aliases___tmp.push_back(tmp_254);
		}
		::YOSYS_NAMESPACE::load_plugin(filename, aliases___tmp);
	}

	CellTypes get_var_py_yosys_celltypes()
	{
		CellTypes* ret_ = CellTypes::get_py_obj(&YOSYS_NAMESPACE::yosys_celltypes);
		return *ret_;
	}

	void set_var_py_yosys_celltypes(CellTypes *rhs)
	{
		YOSYS_NAMESPACE::yosys_celltypes = *rhs->get_cpp_obj();
	}

	boost::python::list get_var_py_log_scratchpads()
	{
		std::vector<string> ret_ = YOSYS_NAMESPACE::log_scratchpads;
		boost::python::list ret____tmp;
		for(auto tmp_255 : ret_)
		{
			ret____tmp.append(tmp_255);
		}
		return ret____tmp;
	}

	void set_var_py_log_scratchpads(boost::python::list rhs)
	{
		std::vector<string> rhs___tmp;
		for(int cntr_256 = 0; cntr_256 < len(rhs); cntr_256++)
		{
			string tmp_257 = boost::python::extract<string>(rhs[cntr_256]);
			rhs___tmp.push_back(tmp_257);
		}
		YOSYS_NAMESPACE::log_scratchpads = rhs___tmp;
	}

	boost::python::dict get_var_py_log_hdump()
	{
		std::map<string, std::set<string>> ret_ = YOSYS_NAMESPACE::log_hdump;
		boost::python::dict ret____tmp;
		for(auto tmp_258 : ret_)
		{
			auto tmp_258_second = tmp_258.second;
			boost::python::list tmp_258_second___tmp;
			for(auto tmp_259 : tmp_258_second)
			{
				tmp_258_second___tmp.append(tmp_259);
			}
			ret____tmp[tmp_258.first] = tmp_258_second___tmp;
		}
		return ret____tmp;
	}

	void set_var_py_log_hdump(boost::python::dict rhs)
	{
		std::map<string, std::set<string>> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_260 = 0; cntr_260 < len(rhs_keylist); cntr_260++)
		{
			string key_tmp_261 = boost::python::extract<string>(rhs_keylist[ cntr_260 ]);
			boost::python::list val_tmp_261 = boost::python::extract<boost::python::list>(rhs[rhs_keylist[ cntr_260 ]]);
			std::set<string> val_tmp_261___tmp;
			for(int cntr_262 = 0; cntr_262 < len(val_tmp_261); cntr_262++)
			{
				string tmp_263 = boost::python::extract<string>(val_tmp_261[cntr_262]);
				val_tmp_261___tmp.insert(tmp_263);
			}
			rhs___tmp.insert(std::pair<string, std::set<string>>(key_tmp_261, val_tmp_261___tmp));

		}
		YOSYS_NAMESPACE::log_hdump = rhs___tmp;
	}

	boost::python::list get_var_py_log_warnings()
	{
		std::set<string> ret_ = YOSYS_NAMESPACE::log_warnings;
		boost::python::list ret____tmp;
		for(auto tmp_264 : ret_)
		{
			ret____tmp.append(tmp_264);
		}
		return ret____tmp;
	}

	void set_var_py_log_warnings(boost::python::list rhs)
	{
		std::set<string> rhs___tmp;
		for(int cntr_265 = 0; cntr_265 < len(rhs); cntr_265++)
		{
			string tmp_266 = boost::python::extract<string>(rhs[cntr_265]);
			rhs___tmp.insert(tmp_266);
		}
		YOSYS_NAMESPACE::log_warnings = rhs___tmp;
	}

	boost::python::list get_var_py_log_experimentals()
	{
		std::set<string> ret_ = YOSYS_NAMESPACE::log_experimentals;
		boost::python::list ret____tmp;
		for(auto tmp_267 : ret_)
		{
			ret____tmp.append(tmp_267);
		}
		return ret____tmp;
	}

	void set_var_py_log_experimentals(boost::python::list rhs)
	{
		std::set<string> rhs___tmp;
		for(int cntr_268 = 0; cntr_268 < len(rhs); cntr_268++)
		{
			string tmp_269 = boost::python::extract<string>(rhs[cntr_268]);
			rhs___tmp.insert(tmp_269);
		}
		YOSYS_NAMESPACE::log_experimentals = rhs___tmp;
	}

	boost::python::list get_var_py_log_experimentals_ignored()
	{
		std::set<string> ret_ = YOSYS_NAMESPACE::log_experimentals_ignored;
		boost::python::list ret____tmp;
		for(auto tmp_270 : ret_)
		{
			ret____tmp.append(tmp_270);
		}
		return ret____tmp;
	}

	void set_var_py_log_experimentals_ignored(boost::python::list rhs)
	{
		std::set<string> rhs___tmp;
		for(int cntr_271 = 0; cntr_271 < len(rhs); cntr_271++)
		{
			string tmp_272 = boost::python::extract<string>(rhs[cntr_271]);
			rhs___tmp.insert(tmp_272);
		}
		YOSYS_NAMESPACE::log_experimentals_ignored = rhs___tmp;
	}

	int get_var_py_log_warnings_count()
	{
		int ret_ = YOSYS_NAMESPACE::log_warnings_count;
		return ret_;
	}

	void set_var_py_log_warnings_count(int rhs)
	{
		YOSYS_NAMESPACE::log_warnings_count = rhs;
	}

	int get_var_py_log_warnings_count_noexpect()
	{
		int ret_ = YOSYS_NAMESPACE::log_warnings_count_noexpect;
		return ret_;
	}

	void set_var_py_log_warnings_count_noexpect(int rhs)
	{
		YOSYS_NAMESPACE::log_warnings_count_noexpect = rhs;
	}

	bool get_var_py_log_expect_no_warnings()
	{
		bool ret_ = YOSYS_NAMESPACE::log_expect_no_warnings;
		return ret_;
	}

	void set_var_py_log_expect_no_warnings(bool rhs)
	{
		YOSYS_NAMESPACE::log_expect_no_warnings = rhs;
	}

	bool get_var_py_log_hdump_all()
	{
		bool ret_ = YOSYS_NAMESPACE::log_hdump_all;
		return ret_;
	}

	void set_var_py_log_hdump_all(bool rhs)
	{
		YOSYS_NAMESPACE::log_hdump_all = rhs;
	}

	bool get_var_py_log_time()
	{
		bool ret_ = YOSYS_NAMESPACE::log_time;
		return ret_;
	}

	void set_var_py_log_time(bool rhs)
	{
		YOSYS_NAMESPACE::log_time = rhs;
	}

	bool get_var_py_log_error_stderr()
	{
		bool ret_ = YOSYS_NAMESPACE::log_error_stderr;
		return ret_;
	}

	void set_var_py_log_error_stderr(bool rhs)
	{
		YOSYS_NAMESPACE::log_error_stderr = rhs;
	}

	bool get_var_py_log_cmd_error_throw()
	{
		bool ret_ = YOSYS_NAMESPACE::log_cmd_error_throw;
		return ret_;
	}

	void set_var_py_log_cmd_error_throw(bool rhs)
	{
		YOSYS_NAMESPACE::log_cmd_error_throw = rhs;
	}

	bool get_var_py_log_quiet_warnings()
	{
		bool ret_ = YOSYS_NAMESPACE::log_quiet_warnings;
		return ret_;
	}

	void set_var_py_log_quiet_warnings(bool rhs)
	{
		YOSYS_NAMESPACE::log_quiet_warnings = rhs;
	}

	int get_var_py_log_verbose_level()
	{
		int ret_ = YOSYS_NAMESPACE::log_verbose_level;
		return ret_;
	}

	void set_var_py_log_verbose_level(int rhs)
	{
		YOSYS_NAMESPACE::log_verbose_level = rhs;
	}

	string get_var_py_log_last_error()
	{
		string ret_ = YOSYS_NAMESPACE::log_last_error;
		return ret_;
	}

	void set_var_py_log_last_error(string rhs)
	{
		YOSYS_NAMESPACE::log_last_error = rhs;
	}

	int get_var_py_log_make_debug()
	{
		int ret_ = YOSYS_NAMESPACE::log_make_debug;
		return ret_;
	}

	void set_var_py_log_make_debug(int rhs)
	{
		YOSYS_NAMESPACE::log_make_debug = rhs;
	}

	int get_var_py_log_force_debug()
	{
		int ret_ = YOSYS_NAMESPACE::log_force_debug;
		return ret_;
	}

	void set_var_py_log_force_debug(int rhs)
	{
		YOSYS_NAMESPACE::log_force_debug = rhs;
	}

	int get_var_py_log_debug_suppressed()
	{
		int ret_ = YOSYS_NAMESPACE::log_debug_suppressed;
		return ret_;
	}

	void set_var_py_log_debug_suppressed(int rhs)
	{
		YOSYS_NAMESPACE::log_debug_suppressed = rhs;
	}

	boost::python::dict get_var_py_extra_coverage_data()
	{
		dict<string, std::pair<string, int>> ret_ = YOSYS_NAMESPACE::extra_coverage_data;
		boost::python::dict ret____tmp;
		for(auto tmp_273 : ret_)
		{
			auto tmp_273_second = tmp_273.second;
			boost::python::tuple tmp_273_second___tmp = boost::python::make_tuple(tmp_273_second.first, tmp_273_second.second);
			ret____tmp[tmp_273.first] = tmp_273_second___tmp;
		}
		return ret____tmp;
	}

	void set_var_py_extra_coverage_data(boost::python::dict rhs)
	{
		dict<string, std::pair<string, int>> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_274 = 0; cntr_274 < len(rhs_keylist); cntr_274++)
		{
			string key_tmp_275 = boost::python::extract<string>(rhs_keylist[ cntr_274 ]);
			boost::python::tuple val_tmp_275 = boost::python::extract<boost::python::tuple>(rhs[rhs_keylist[ cntr_274 ]]);
			string val_tmp_275___tmp_0 = boost::python::extract<string>(val_tmp_275[0]);
			int val_tmp_275___tmp_1 = boost::python::extract<int>(val_tmp_275[1]);
			std::pair<string, int> val_tmp_275___tmp(val_tmp_275___tmp_0, val_tmp_275___tmp_1);
			rhs___tmp.insert(std::pair<string, std::pair<string, int>>(key_tmp_275, val_tmp_275___tmp));

		}
		YOSYS_NAMESPACE::extra_coverage_data = rhs___tmp;
	}

	boost::python::dict get_var_py_pass_register()
	{
		std::map<string, YOSYS_NAMESPACE::Pass*> ret_ = YOSYS_NAMESPACE::pass_register;
		boost::python::dict ret____tmp;
		for(auto tmp_276 : ret_)
		{
			ret____tmp[tmp_276.first] = Pass::get_py_obj(tmp_276.second);
		}
		return ret____tmp;
	}

	void set_var_py_pass_register(boost::python::dict rhs)
	{
		std::map<string, YOSYS_NAMESPACE::Pass*> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_277 = 0; cntr_277 < len(rhs_keylist); cntr_277++)
		{
			string key_tmp_278 = boost::python::extract<string>(rhs_keylist[ cntr_277 ]);
			Pass* val_tmp_278 = boost::python::extract<Pass*>(rhs[rhs_keylist[ cntr_277 ]]);
			rhs___tmp.insert(std::pair<string, YOSYS_NAMESPACE::Pass*>(key_tmp_278, val_tmp_278->get_cpp_obj()));

		}
		YOSYS_NAMESPACE::pass_register = rhs___tmp;
	}

	boost::python::dict get_var_py_constpad()
	{
		dict<string, string> ret_ = YOSYS_NAMESPACE::RTLIL::constpad;
		boost::python::dict ret____tmp;
		for(auto tmp_279 : ret_)
		{
			ret____tmp[tmp_279.first] = tmp_279.second;
		}
		return ret____tmp;
	}

	void set_var_py_constpad(boost::python::dict rhs)
	{
		dict<string, string> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_280 = 0; cntr_280 < len(rhs_keylist); cntr_280++)
		{
			string key_tmp_281 = boost::python::extract<string>(rhs_keylist[ cntr_280 ]);
			string val_tmp_281 = boost::python::extract<string>(rhs[rhs_keylist[ cntr_280 ]]);
			rhs___tmp.insert(std::pair<string, string>(key_tmp_281, val_tmp_281));

		}
		YOSYS_NAMESPACE::RTLIL::constpad = rhs___tmp;
	}

	Design get_var_py_yosys_design()
	{
		if(YOSYS_NAMESPACE::yosys_design == NULL)
			throw std::runtime_error("YOSYS_NAMESPACE::yosys_design is NULL");
		Design* ret_ = Design::get_py_obj(YOSYS_NAMESPACE::yosys_design);
		return *ret_;
	}

	void set_var_py_yosys_design(Design *rhs)
	{
		YOSYS_NAMESPACE::yosys_design = rhs->get_cpp_obj();
	}

	boost::python::list get_var_py_yosys_input_files()
	{
		std::set<string> ret_ = YOSYS_NAMESPACE::yosys_input_files;
		boost::python::list ret____tmp;
		for(auto tmp_282 : ret_)
		{
			ret____tmp.append(tmp_282);
		}
		return ret____tmp;
	}

	void set_var_py_yosys_input_files(boost::python::list rhs)
	{
		std::set<string> rhs___tmp;
		for(int cntr_283 = 0; cntr_283 < len(rhs); cntr_283++)
		{
			string tmp_284 = boost::python::extract<string>(rhs[cntr_283]);
			rhs___tmp.insert(tmp_284);
		}
		YOSYS_NAMESPACE::yosys_input_files = rhs___tmp;
	}

	boost::python::list get_var_py_yosys_output_files()
	{
		std::set<string> ret_ = YOSYS_NAMESPACE::yosys_output_files;
		boost::python::list ret____tmp;
		for(auto tmp_285 : ret_)
		{
			ret____tmp.append(tmp_285);
		}
		return ret____tmp;
	}

	void set_var_py_yosys_output_files(boost::python::list rhs)
	{
		std::set<string> rhs___tmp;
		for(int cntr_286 = 0; cntr_286 < len(rhs); cntr_286++)
		{
			string tmp_287 = boost::python::extract<string>(rhs[cntr_286]);
			rhs___tmp.insert(tmp_287);
		}
		YOSYS_NAMESPACE::yosys_output_files = rhs___tmp;
	}

	const char * get_var_py_yosys_version_str()
	{
		const char * ret_ = YOSYS_NAMESPACE::yosys_version_str;
		return ret_;
	}

	boost::python::dict get_var_py_saved_designs()
	{
		std::map<string, YOSYS_NAMESPACE::RTLIL::Design*> ret_ = YOSYS_NAMESPACE::saved_designs;
		boost::python::dict ret____tmp;
		for(auto tmp_288 : ret_)
		{
			ret____tmp[tmp_288.first] = Design::get_py_obj(tmp_288.second);
		}
		return ret____tmp;
	}

	void set_var_py_saved_designs(boost::python::dict rhs)
	{
		std::map<string, YOSYS_NAMESPACE::RTLIL::Design*> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_289 = 0; cntr_289 < len(rhs_keylist); cntr_289++)
		{
			string key_tmp_290 = boost::python::extract<string>(rhs_keylist[ cntr_289 ]);
			Design* val_tmp_290 = boost::python::extract<Design*>(rhs[rhs_keylist[ cntr_289 ]]);
			rhs___tmp.insert(std::pair<string, YOSYS_NAMESPACE::RTLIL::Design*>(key_tmp_290, val_tmp_290->get_cpp_obj()));

		}
		YOSYS_NAMESPACE::saved_designs = rhs___tmp;
	}

	boost::python::list get_var_py_pushed_designs()
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Design*> ret_ = YOSYS_NAMESPACE::pushed_designs;
		boost::python::list ret____tmp;
		for(auto tmp_291 : ret_)
		{
			ret____tmp.append(Design::get_py_obj(tmp_291));
		}
		return ret____tmp;
	}

	void set_var_py_pushed_designs(boost::python::list rhs)
	{
		std::vector<YOSYS_NAMESPACE::RTLIL::Design*> rhs___tmp;
		for(int cntr_292 = 0; cntr_292 < len(rhs); cntr_292++)
		{
			Design* tmp_293 = boost::python::extract<Design*>(rhs[cntr_292]);
			rhs___tmp.push_back(tmp_293->get_cpp_obj());
		}
		YOSYS_NAMESPACE::pushed_designs = rhs___tmp;
	}

	boost::python::dict get_var_py_loaded_plugin_aliases()
	{
		std::map<string, string> ret_ = YOSYS_NAMESPACE::loaded_plugin_aliases;
		boost::python::dict ret____tmp;
		for(auto tmp_294 : ret_)
		{
			ret____tmp[tmp_294.first] = tmp_294.second;
		}
		return ret____tmp;
	}

	void set_var_py_loaded_plugin_aliases(boost::python::dict rhs)
	{
		std::map<string, string> rhs___tmp;
		boost::python::list rhs_keylist = rhs.keys();
		for(int cntr_295 = 0; cntr_295 < len(rhs_keylist); cntr_295++)
		{
			string key_tmp_296 = boost::python::extract<string>(rhs_keylist[ cntr_295 ]);
			string val_tmp_296 = boost::python::extract<string>(rhs[rhs_keylist[ cntr_295 ]]);
			rhs___tmp.insert(std::pair<string, string>(key_tmp_296, val_tmp_296));

		}
		YOSYS_NAMESPACE::loaded_plugin_aliases = rhs___tmp;
	}

	string get_var_py_yosys_share_dirname()
	{
		string ret_ = YOSYS_NAMESPACE::yosys_share_dirname;
		return ret_;
	}

	void set_var_py_yosys_share_dirname(string rhs)
	{
		YOSYS_NAMESPACE::yosys_share_dirname = rhs;
	}

	string get_var_py_yosys_abc_executable()
	{
		string ret_ = YOSYS_NAMESPACE::yosys_abc_executable;
		return ret_;
	}

	void set_var_py_yosys_abc_executable(string rhs)
	{
		YOSYS_NAMESPACE::yosys_abc_executable = rhs;
	}
	struct Initializer
	{
		Initializer() {
			if(!Yosys::yosys_already_setup())
			{
				Yosys::log_streams.push_back(&std::cout);
				Yosys::log_error_stderr = true;
				Yosys::yosys_setup();
			}
		}

		Initializer(Initializer const &) {}

		~Initializer() {
			Yosys::yosys_shutdown();
		}
	};


	/// source: https://stackoverflow.com/questions/26033781/converting-python-io-object-to-stdostream-when-using-boostpython?noredirect=1&lq=1
	/// @brief Type that implements the Boost.IOStream's Sink and Flushable
	///        concept for writing data to Python object that support:
	///          n = object.write(str) # n = None or bytes written
	///          object.flush()        # if flush exists, then it is callable
	class PythonOutputDevice
	{
	public:

		// This class models both the Sink and Flushable concepts.
		struct category
			: boost::iostreams::sink_tag,
				boost::iostreams::flushable_tag
		{};

		explicit
		PythonOutputDevice(boost::python::object object)
			: object_(object)
		{}

	// Sink concept.
	public:

		typedef char char_type;

		std::streamsize write(const char* buffer, std::streamsize buffer_size)
		{
			namespace python = boost::python;
			// Copy the buffer to a python string.
			python::str data(buffer, buffer_size);

			// Invoke write on the python object, passing in the data.	The following
			// is equivalent to:
			//	 n = object_.write(data)
			python::extract<std::streamsize> bytes_written(
				object_.attr("write")(data));

			// Per the Sink concept, return the number of bytes written.	If the
			// Python return value provides a numeric result, then use it.	Otherwise,
			// such as the case of a File object, use the buffer_size.
			return bytes_written.check()
				? bytes_written
				: buffer_size;
		}

	// Flushable concept.
	public:

		bool flush()
		{
			// If flush exists, then call it.
			boost::python::object flush = object_.attr("flush");
			if (!flush.is_none())
			{
				flush();
			}

			// Always return true.	If an error occurs, an exception should be thrown.
				return true;
		}

	private:
		boost::python::object object_;
	};

	/// @brief Use an auxiliary function to adapt the legacy function.
	void log_to_stream(boost::python::object object)
	{
		// Create an ostream that delegates to the python object.
		boost::iostreams::stream<PythonOutputDevice>* output = new boost::iostreams::stream<PythonOutputDevice>(object);
		Yosys::log_streams.insert(Yosys::log_streams.begin(), output);
	};


	BOOST_PYTHON_MODULE(libyosys)
	{
		using namespace boost::python;

		class_<Initializer>("Initializer");
		scope().attr("_hidden") = new Initializer();

		def("log_to_stream", &log_to_stream);

		enum_<YOSYS_NAMESPACE::RTLIL::State>("State")
			.value("S0",YOSYS_NAMESPACE::RTLIL::S0)
			.value("S1",YOSYS_NAMESPACE::RTLIL::S1)
			.value("Sx",YOSYS_NAMESPACE::RTLIL::Sx)
			.value("Sz",YOSYS_NAMESPACE::RTLIL::Sz)
			.value("Sa",YOSYS_NAMESPACE::RTLIL::Sa)
			.value("Sm",YOSYS_NAMESPACE::RTLIL::Sm)
			;

		enum_<YOSYS_NAMESPACE::RTLIL::SyncType>("SyncType")
			.value("ST0",YOSYS_NAMESPACE::RTLIL::ST0)
			.value("ST1",YOSYS_NAMESPACE::RTLIL::ST1)
			.value("STp",YOSYS_NAMESPACE::RTLIL::STp)
			.value("STn",YOSYS_NAMESPACE::RTLIL::STn)
			.value("STe",YOSYS_NAMESPACE::RTLIL::STe)
			.value("STa",YOSYS_NAMESPACE::RTLIL::STa)
			.value("STg",YOSYS_NAMESPACE::RTLIL::STg)
			.value("STi",YOSYS_NAMESPACE::RTLIL::STi)
			;

		enum_<YOSYS_NAMESPACE::RTLIL::ConstFlags>("ConstFlags")
			.value("CONST_FLAG_NONE",YOSYS_NAMESPACE::RTLIL::CONST_FLAG_NONE)
			.value("CONST_FLAG_STRING",YOSYS_NAMESPACE::RTLIL::CONST_FLAG_STRING)
			.value("CONST_FLAG_SIGNED",YOSYS_NAMESPACE::RTLIL::CONST_FLAG_SIGNED)
			.value("CONST_FLAG_REAL",YOSYS_NAMESPACE::RTLIL::CONST_FLAG_REAL)
			;

		class_<CellType>("CellType")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("type", &CellType::get_var_py_type, &CellType::set_var_py_type)
			.add_property("inputs", &CellType::get_var_py_inputs, &CellType::set_var_py_inputs)
			.add_property("outputs", &CellType::get_var_py_outputs, &CellType::set_var_py_outputs)
			.add_property("is_evaluable", &CellType::get_var_py_is_evaluable, &CellType::set_var_py_is_evaluable)
			.add_property("is_combinatorial", &CellType::get_var_py_is_combinatorial, &CellType::set_var_py_is_combinatorial)
			.add_property("is_synthesizable", &CellType::get_var_py_is_synthesizable, &CellType::set_var_py_is_synthesizable)
			.def("__hash__", &CellType::get_hash_py)
			;

		class_<CellTypes>("CellTypes")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<Design* >())
			.add_property("cell_types", &CellTypes::get_var_py_cell_types, &CellTypes::set_var_py_cell_types)
			.def<void (CellTypes::*)(Design* )>("setup", &CellTypes::setup)
			.def<void (CellTypes::*)(IdString* , boost::python::list, boost::python::list)>("setup_type", &CellTypes::setup_type)
			.def<void (CellTypes::*)(IdString* , boost::python::list, boost::python::list, bool)>("setup_type", &CellTypes::setup_type)
			.def<void (CellTypes::*)(IdString* , boost::python::list, boost::python::list, bool, bool)>("setup_type", &CellTypes::setup_type)
			.def<void (CellTypes::*)(IdString* , boost::python::list, boost::python::list, bool, bool, bool)>("setup_type", &CellTypes::setup_type)
			.def<void (CellTypes::*)(Module* )>("setup_module", &CellTypes::setup_module)
			.def<void (CellTypes::*)(Design* )>("setup_design", &CellTypes::setup_design)
			.def<void (CellTypes::*)(void)>("setup_internals", &CellTypes::setup_internals)
			.def<void (CellTypes::*)(void)>("setup_internals_eval", &CellTypes::setup_internals_eval)
			.def<void (CellTypes::*)(void)>("setup_internals_ff", &CellTypes::setup_internals_ff)
			.def<void (CellTypes::*)(void)>("setup_internals_anyinit", &CellTypes::setup_internals_anyinit)
			.def<void (CellTypes::*)(void)>("setup_internals_mem", &CellTypes::setup_internals_mem)
			.def<void (CellTypes::*)(void)>("setup_stdcells", &CellTypes::setup_stdcells)
			.def<void (CellTypes::*)(void)>("setup_stdcells_eval", &CellTypes::setup_stdcells_eval)
			.def<void (CellTypes::*)(void)>("setup_stdcells_mem", &CellTypes::setup_stdcells_mem)
			.def<void (CellTypes::*)(void)>("clear", &CellTypes::clear)
			.def<bool (CellTypes::*)(IdString* ) const>("cell_known", &CellTypes::cell_known)
			.def<bool (CellTypes::*)(IdString* , IdString* ) const>("cell_output", &CellTypes::cell_output)
			.def<bool (CellTypes::*)(IdString* , IdString* ) const>("cell_input", &CellTypes::cell_input)
			.def<bool (CellTypes::*)(IdString* ) const>("cell_evaluable", &CellTypes::cell_evaluable)
			.def<Const (*)(Const* )>("eval_not", &CellTypes::eval_not)
			.def<Const (*)(IdString* , const Const* , const Const* , bool, bool, int)>("eval", &CellTypes::eval)
			.def<Const (*)(IdString* , const Const* , const Const* , bool, bool, int, bool)>("eval", &CellTypes::eval)
			.def<Const (*)(Cell* , const Const* , const Const* )>("eval", &CellTypes::eval)
			.def<Const (*)(Cell* , const Const* , const Const* , bool)>("eval", &CellTypes::eval)
			.def<Const (*)(Cell* , const Const* , const Const* , const Const* )>("eval", &CellTypes::eval)
			.def<Const (*)(Cell* , const Const* , const Const* , const Const* , bool)>("eval", &CellTypes::eval)
			.def<Const (*)(Cell* , const Const* , const Const* , const Const* , const Const* )>("eval", &CellTypes::eval)
			.def<Const (*)(Cell* , const Const* , const Const* , const Const* , const Const* , bool)>("eval", &CellTypes::eval)
			.staticmethod("eval_not")
			.staticmethod("eval")
			;

		class_<ConstEval>("ConstEval", no_init)
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<Module* , State>())
			.add_property("module", &ConstEval::get_var_py_module, &ConstEval::set_var_py_module)
			.add_property("assign_map", &ConstEval::get_var_py_assign_map, &ConstEval::set_var_py_assign_map)
			.add_property("values_map", &ConstEval::get_var_py_values_map, &ConstEval::set_var_py_values_map)
			.add_property("busy", &ConstEval::get_var_py_busy, &ConstEval::set_var_py_busy)
			.add_property("stack", &ConstEval::get_var_py_stack, &ConstEval::set_var_py_stack)
			.add_property("defaultval", &ConstEval::get_var_py_defaultval, &ConstEval::set_var_py_defaultval)
			.def<void (ConstEval::*)(void)>("clear", &ConstEval::clear)
			.def<void (ConstEval::*)(void)>("push", &ConstEval::push)
			.def<void (ConstEval::*)(void)>("pop", &ConstEval::pop)
			.def<void (ConstEval::*)(SigSpec* , Const* )>("set", &ConstEval::set)
			.def<void (ConstEval::*)(SigSpec* )>("stop", &ConstEval::stop)
			.def<bool (ConstEval::*)(Cell* , SigSpec* )>("eval", &ConstEval::eval)
			.def<bool (ConstEval::*)(SigSpec* , SigSpec* , Cell* )>("eval", &ConstEval::eval)
			.def<bool (ConstEval::*)(SigSpec* )>("eval", &ConstEval::eval)
			;

		class_<Pass>("CppPass", no_init)
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<string, string>())
			.add_property("pass_name", &Pass::get_var_py_pass_name, &Pass::set_var_py_pass_name)
			.add_property("short_help", &Pass::get_var_py_short_help, &Pass::set_var_py_short_help)
			.add_property("call_counter", &Pass::get_var_py_call_counter, &Pass::set_var_py_call_counter)
			.add_property("next_queued_pass", &Pass::get_var_py_next_queued_pass, &Pass::set_var_py_next_queued_pass)
			.def<void (Pass::*)(void)>("py_help", &Pass::py_help, &PassWrap::default_py_help)
			.def<void (Pass::*)(void)>("py_clear_flags", &Pass::py_clear_flags, &PassWrap::default_py_clear_flags)
			.def<void (Pass::*)(boost::python::list, Design* )>("py_execute", &Pass::py_execute, &PassWrap::default_py_execute)
			.def<void (Pass::*)(void)>("experimental", &Pass::experimental)
			.def<void (Pass::*)(boost::python::list)>("cmd_log_args", &Pass::cmd_log_args)
			.def<void (Pass::*)(boost::python::list, size_t, string)>("cmd_error", &Pass::cmd_error)
			.def<void (Pass::*)(boost::python::list, size_t, Design* )>("extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design", &Pass::extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design)
			.def<void (Pass::*)(boost::python::list, size_t, Design* , bool)>("extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design__bool", &Pass::extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design__bool)
			.def<void (*)(Design* , string)>("call__YOSYS_NAMESPACE_RTLIL_Design__string", &Pass::call__YOSYS_NAMESPACE_RTLIL_Design__string)
			.def<void (*)(Design* , boost::python::list)>("call__YOSYS_NAMESPACE_RTLIL_Design__std_vector_string_", &Pass::call__YOSYS_NAMESPACE_RTLIL_Design__std_vector_string_)
			.def<void (*)(Design* , const Selection* , string)>("call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__string", &Pass::call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__string)
			.def<void (*)(Design* , const Selection* , boost::python::list)>("call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__std_vector_string_", &Pass::call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__std_vector_string_)
			.def<void (*)(Design* , Module* , string)>("call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__string", &Pass::call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__string)
			.def<void (*)(Design* , Module* , boost::python::list)>("call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__std_vector_string_", &Pass::call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__std_vector_string_)
			.def<void (*)(void)>("init_register", &Pass::init_register)
			.def<void (*)(void)>("done_register", &Pass::done_register)
			.def<void (Pass::*)(void)>("py_on_register", &Pass::py_on_register, &PassWrap::default_py_on_register)
			.def<void (Pass::*)(void)>("py_on_shutdown", &Pass::py_on_shutdown, &PassWrap::default_py_on_shutdown)
			.def<bool (Pass::*)(void)>("py_replace_existing_pass", &Pass::py_replace_existing_pass, &PassWrap::default_py_replace_existing_pass)
			.staticmethod("call__YOSYS_NAMESPACE_RTLIL_Design__string")
			.staticmethod("call__YOSYS_NAMESPACE_RTLIL_Design__std_vector_string_")
			.staticmethod("call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__string")
			.staticmethod("call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__std_vector_string_")
			.staticmethod("call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__string")
			.staticmethod("call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__std_vector_string_")
			.staticmethod("init_register")
			.staticmethod("done_register")
			;

		class_<PassWrap, boost::noncopyable>("Pass", no_init)
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<string, string>())
			.add_property("pass_name", &Pass::get_var_py_pass_name, &Pass::set_var_py_pass_name)
			.add_property("short_help", &Pass::get_var_py_short_help, &Pass::set_var_py_short_help)
			.add_property("call_counter", &Pass::get_var_py_call_counter, &Pass::set_var_py_call_counter)
			.add_property("next_queued_pass", &Pass::get_var_py_next_queued_pass, &Pass::set_var_py_next_queued_pass)
			.def<void (Pass::*)(void)>("py_help", &Pass::py_help, &PassWrap::default_py_help)
			.def<void (Pass::*)(void)>("py_clear_flags", &Pass::py_clear_flags, &PassWrap::default_py_clear_flags)
			.def<void (Pass::*)(boost::python::list, Design* )>("py_execute", &Pass::py_execute, &PassWrap::default_py_execute)
			.def<void (Pass::*)(void)>("experimental", &Pass::experimental)
			.def<void (Pass::*)(boost::python::list)>("cmd_log_args", &Pass::cmd_log_args)
			.def<void (Pass::*)(boost::python::list, size_t, string)>("cmd_error", &Pass::cmd_error)
			.def<void (Pass::*)(boost::python::list, size_t, Design* )>("extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design", &Pass::extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design)
			.def<void (Pass::*)(boost::python::list, size_t, Design* , bool)>("extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design__bool", &Pass::extra_args__std_vector_string___size_t__YOSYS_NAMESPACE_RTLIL_Design__bool)
			.def<void (*)(Design* , string)>("call__YOSYS_NAMESPACE_RTLIL_Design__string", &Pass::call__YOSYS_NAMESPACE_RTLIL_Design__string)
			.def<void (*)(Design* , boost::python::list)>("call__YOSYS_NAMESPACE_RTLIL_Design__std_vector_string_", &Pass::call__YOSYS_NAMESPACE_RTLIL_Design__std_vector_string_)
			.def<void (*)(Design* , const Selection* , string)>("call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__string", &Pass::call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__string)
			.def<void (*)(Design* , const Selection* , boost::python::list)>("call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__std_vector_string_", &Pass::call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__std_vector_string_)
			.def<void (*)(Design* , Module* , string)>("call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__string", &Pass::call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__string)
			.def<void (*)(Design* , Module* , boost::python::list)>("call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__std_vector_string_", &Pass::call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__std_vector_string_)
			.def<void (*)(void)>("init_register", &Pass::init_register)
			.def<void (*)(void)>("done_register", &Pass::done_register)
			.def<void (Pass::*)(void)>("py_on_register", &Pass::py_on_register, &PassWrap::default_py_on_register)
			.def<void (Pass::*)(void)>("py_on_shutdown", &Pass::py_on_shutdown, &PassWrap::default_py_on_shutdown)
			.def<bool (Pass::*)(void)>("py_replace_existing_pass", &Pass::py_replace_existing_pass, &PassWrap::default_py_replace_existing_pass)
			.staticmethod("call__YOSYS_NAMESPACE_RTLIL_Design__string")
			.staticmethod("call__YOSYS_NAMESPACE_RTLIL_Design__std_vector_string_")
			.staticmethod("call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__string")
			.staticmethod("call_on_selection__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Selection__std_vector_string_")
			.staticmethod("call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__string")
			.staticmethod("call_on_module__YOSYS_NAMESPACE_RTLIL_Design__YOSYS_NAMESPACE_RTLIL_Module__std_vector_string_")
			.staticmethod("init_register")
			.staticmethod("done_register")
			;

		class_<IdString>("IdString")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<const char *>())
			.def(init<const IdString* >())
			.def(init<IdString* >())
			.def(init<const string>())
			.add_property("index_", &IdString::get_var_py_index_, &IdString::set_var_py_index_)
			.def<void (*)(void)>("xtrace_db_dump", &IdString::xtrace_db_dump)
			.def<void (*)(void)>("checkpoint", &IdString::checkpoint)
			.def<int (*)(int)>("get_reference", &IdString::get_reference)
			.def<int (*)(const char *)>("get_reference", &IdString::get_reference)
			.def<void (*)(int)>("put_reference", &IdString::put_reference)
			.def<void (*)(int)>("free_reference", &IdString::free_reference)
			.def<const char * (IdString::*)(void) const>("c_str", &IdString::c_str)
			.def<string (IdString::*)(void) const>("str", &IdString::str)
			.def<bool (IdString::*)(const IdString* ) const>("__lt__", &IdString::operator<)
			.def<bool (IdString::*)(const IdString* ) const>("__eq__", &IdString::operator==)
			.def<bool (IdString::*)(const IdString* ) const>("__ne__", &IdString::operator!=)
			.def<bool (IdString::*)(const string) const>("__eq__", &IdString::operator==)
			.def<bool (IdString::*)(const string) const>("__ne__", &IdString::operator!=)
			.def<bool (IdString::*)(const char *) const>("__eq__", &IdString::operator==)
			.def<bool (IdString::*)(const char *) const>("__ne__", &IdString::operator!=)
			.def<string (IdString::*)(void) const>("substr", &IdString::substr)
			.def<string (IdString::*)(size_t) const>("substr", &IdString::substr)
			.def<string (IdString::*)(size_t, size_t) const>("substr", &IdString::substr)
			.def<int (IdString::*)(size_t, size_t, const char *) const>("compare", &IdString::compare)
			.def<bool (IdString::*)(const char *) const>("begins_with", &IdString::begins_with)
			.def<bool (IdString::*)(const char *) const>("ends_with", &IdString::ends_with)
			.def<bool (IdString::*)(const char *) const>("contains", &IdString::contains)
			.def<size_t (IdString::*)(void) const>("size", &IdString::size)
			.def<bool (IdString::*)(void) const>("empty", &IdString::empty)
			.def<void (IdString::*)(void)>("clear", &IdString::clear)
			.def<bool (IdString::*)(const IdString* ) const>("in_", &IdString::in_)
			.def<bool (IdString::*)(const char *) const>("in_", &IdString::in_)
			.def<bool (IdString::*)(const string) const>("in_", &IdString::in_)
			.def<bool (IdString::*)(boost::python::list)>("in_", &IdString::in_)
			.def<bool (IdString::*)(void) const>("isPublic", &IdString::isPublic)
			.staticmethod("xtrace_db_dump")
			.staticmethod("checkpoint")
			.staticmethod("get_reference")
			.staticmethod("put_reference")
			.staticmethod("free_reference")
			.def("__hash__", &IdString::get_hash_py)
			;

		class_<Const>("Const")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<const string>())
			.def(init<State, int>())
			.def(init<boost::python::list>())
			.def(init<const Const* >())
			.def(init<Const* >())
			.add_property("flags", &Const::get_var_py_flags, &Const::set_var_py_flags)
			.def<bool (Const::*)(const Const* )>("__lt__", &Const::operator<)
			.def<bool (Const::*)(const Const* )>("__eq__", &Const::operator==)
			.def<bool (Const::*)(const Const* )>("__ne__", &Const::operator!=)
			.def<boost::python::list (Const::*)(void)>("bits", &Const::bits)
			.def<bool (Const::*)(void)>("as_bool", &Const::as_bool)
			.def<int (Const::*)(void)>("as_int", &Const::as_int)
			.def<int (Const::*)(bool)>("as_int", &Const::as_int)
			.def<bool (Const::*)(void)>("convertible_to_int", &Const::convertible_to_int)
			.def<bool (Const::*)(bool)>("convertible_to_int", &Const::convertible_to_int)
			.def<int (Const::*)(void)>("as_int_saturating", &Const::as_int_saturating)
			.def<int (Const::*)(bool)>("as_int_saturating", &Const::as_int_saturating)
			.def<string (Const::*)(const char *)>("as_string", &Const::as_string)
			.def<Const (*)(const string)>("from_string", &Const::from_string)
			.def<boost::python::list (Const::*)(void)>("to_bits", &Const::to_bits)
			.def<string (Const::*)(void)>("decode_string", &Const::decode_string)
			.def<int (Const::*)(void)>("size", &Const::size)
			.def<bool (Const::*)(void)>("empty", &Const::empty)
			.def<void (Const::*)(void)>("bitvectorize", &Const::bitvectorize)
			.def<void (Const::*)(const Const* )>("append", &Const::append)
			.def<State (Const::*)(void) const>("back", &Const::back)
			.def<State (Const::*)(void) const>("front", &Const::front)
			.def<State (Const::*)(size_t) const>("at", &Const::at)
			.def<bool (Const::*)(void)>("is_fully_zero", &Const::is_fully_zero)
			.def<bool (Const::*)(void)>("is_fully_ones", &Const::is_fully_ones)
			.def<bool (Const::*)(void)>("is_fully_def", &Const::is_fully_def)
			.def<bool (Const::*)(void)>("is_fully_undef", &Const::is_fully_undef)
			.def<bool (Const::*)(void)>("is_fully_undef_x_only", &Const::is_fully_undef_x_only)
			.def<bool (Const::*)(void)>("is_onehot", &Const::is_onehot)
			.def<bool (Const::*)(int)>("is_onehot", &Const::is_onehot)
			.def<Const (Const::*)(int)>("extract", &Const::extract)
			.def<Const (Const::*)(int, int)>("extract", &Const::extract)
			.def<Const (Const::*)(int, int, State)>("extract", &Const::extract)
			.def<int (Const::*)(bool)>("get_min_size", &Const::get_min_size)
			.def<void (Const::*)(void)>("compress", &Const::compress)
			.def<void (Const::*)(bool)>("compress", &Const::compress)
			.def<void (Const::*)(int)>("extu", &Const::extu)
			.def<void (Const::*)(int)>("exts", &Const::exts)
			.staticmethod("from_string")
			.def("__hash__", &Const::get_hash_py)
			;

		class_<AttrObject>("AttrObject")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("attributes", &AttrObject::get_var_py_attributes, &AttrObject::set_var_py_attributes)
			.def<bool (AttrObject::*)(const IdString* )>("has_attribute", &AttrObject::has_attribute)
			.def<void (AttrObject::*)(const IdString* )>("set_bool_attribute", &AttrObject::set_bool_attribute)
			.def<void (AttrObject::*)(const IdString* , bool)>("set_bool_attribute", &AttrObject::set_bool_attribute)
			.def<bool (AttrObject::*)(const IdString* )>("get_bool_attribute", &AttrObject::get_bool_attribute)
			.def<bool (AttrObject::*)(void) const>("get_blackbox_attribute", &AttrObject::get_blackbox_attribute)
			.def<bool (AttrObject::*)(bool) const>("get_blackbox_attribute", &AttrObject::get_blackbox_attribute)
			.def<void (AttrObject::*)(const IdString* , string)>("set_string_attribute", &AttrObject::set_string_attribute)
			.def<string (AttrObject::*)(const IdString* )>("get_string_attribute", &AttrObject::get_string_attribute)
			.def<void (AttrObject::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &AttrObject::set_strpool_attribute)
			.def<void (AttrObject::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &AttrObject::add_strpool_attribute)
			.def<boost::python::list (AttrObject::*)(const IdString* )>("get_strpool_attribute", &AttrObject::get_strpool_attribute)
			.def<void (AttrObject::*)(const string)>("set_src_attribute", &AttrObject::set_src_attribute)
			.def<string (AttrObject::*)(void) const>("get_src_attribute", &AttrObject::get_src_attribute)
			;

		class_<NamedObject, bases<AttrObject>>("NamedObject")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("name", &NamedObject::get_var_py_name, &NamedObject::set_var_py_name)
			.add_property("attributes", &NamedObject::get_var_py_attributes, &NamedObject::set_var_py_attributes)
			.def<bool (NamedObject::*)(const IdString* )>("has_attribute", &NamedObject::has_attribute)
			.def<void (NamedObject::*)(const IdString* )>("set_bool_attribute", &NamedObject::set_bool_attribute)
			.def<void (NamedObject::*)(const IdString* , bool)>("set_bool_attribute", &NamedObject::set_bool_attribute)
			.def<bool (NamedObject::*)(const IdString* )>("get_bool_attribute", &NamedObject::get_bool_attribute)
			.def<bool (NamedObject::*)(void) const>("get_blackbox_attribute", &NamedObject::get_blackbox_attribute)
			.def<bool (NamedObject::*)(bool) const>("get_blackbox_attribute", &NamedObject::get_blackbox_attribute)
			.def<void (NamedObject::*)(const IdString* , string)>("set_string_attribute", &NamedObject::set_string_attribute)
			.def<string (NamedObject::*)(const IdString* )>("get_string_attribute", &NamedObject::get_string_attribute)
			.def<void (NamedObject::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &NamedObject::set_strpool_attribute)
			.def<void (NamedObject::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &NamedObject::add_strpool_attribute)
			.def<boost::python::list (NamedObject::*)(const IdString* )>("get_strpool_attribute", &NamedObject::get_strpool_attribute)
			.def<void (NamedObject::*)(const string)>("set_src_attribute", &NamedObject::set_src_attribute)
			.def<string (NamedObject::*)(void) const>("get_src_attribute", &NamedObject::get_src_attribute)
			;

		class_<Selection>("Selection", no_init)
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<bool, bool, Design* >())
			.add_property("selects_boxes", &Selection::get_var_py_selects_boxes, &Selection::set_var_py_selects_boxes)
			.add_property("complete_selection", &Selection::get_var_py_complete_selection, &Selection::set_var_py_complete_selection)
			.add_property("full_selection", &Selection::get_var_py_full_selection, &Selection::set_var_py_full_selection)
			.add_property("selected_modules", &Selection::get_var_py_selected_modules, &Selection::set_var_py_selected_modules)
			.add_property("selected_members", &Selection::get_var_py_selected_members, &Selection::set_var_py_selected_members)
			.add_property("current_design", &Selection::get_var_py_current_design, &Selection::set_var_py_current_design)
			.def<bool (Selection::*)(const IdString* )>("boxed_module", &Selection::boxed_module)
			.def<bool (Selection::*)(const IdString* )>("selected_module", &Selection::selected_module)
			.def<bool (Selection::*)(const IdString* )>("selected_whole_module", &Selection::selected_whole_module)
			.def<bool (Selection::*)(const IdString* , const IdString* )>("selected_member", &Selection::selected_member)
			.def<void (Selection::*)(Design* )>("optimize", &Selection::optimize)
			.def<bool (Selection::*)(void) const>("selects_all", &Selection::selects_all)
			.def<bool (Selection::*)(void) const>("empty", &Selection::empty)
			.def<void (Selection::*)(void)>("clear", &Selection::clear)
			.def<Selection (*)(void)>("EmptySelection", &Selection::EmptySelection)
			.def<Selection (*)(Design* )>("EmptySelection", &Selection::EmptySelection)
			.def<Selection (*)(void)>("FullSelection", &Selection::FullSelection)
			.def<Selection (*)(Design* )>("FullSelection", &Selection::FullSelection)
			.def<Selection (*)(void)>("CompleteSelection", &Selection::CompleteSelection)
			.def<Selection (*)(Design* )>("CompleteSelection", &Selection::CompleteSelection)
			.staticmethod("EmptySelection")
			.staticmethod("FullSelection")
			.staticmethod("CompleteSelection")
			;

		class_<Monitor>("CppMonitor")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def<void (Monitor::*)(Module* )>("py_notify_module_add", &Monitor::py_notify_module_add, &MonitorWrap::default_py_notify_module_add)
			.def<void (Monitor::*)(Module* )>("py_notify_module_del", &Monitor::py_notify_module_del, &MonitorWrap::default_py_notify_module_del)
			.def<void (Monitor::*)(Cell* , const IdString* , const SigSpec* , const SigSpec* )>("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec", &Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec, &MonitorWrap::default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec)
			.def<void (Monitor::*)(Module* , boost::python::tuple)>("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_", &Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_, &MonitorWrap::default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_)
			.def<void (Monitor::*)(Module* , boost::python::list)>("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__", &Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__, &MonitorWrap::default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__)
			.def<void (Monitor::*)(Module* )>("py_notify_blackout", &Monitor::py_notify_blackout, &MonitorWrap::default_py_notify_blackout)
			;

		class_<MonitorWrap, boost::noncopyable>("Monitor")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def<void (Monitor::*)(Module* )>("py_notify_module_add", &Monitor::py_notify_module_add, &MonitorWrap::default_py_notify_module_add)
			.def<void (Monitor::*)(Module* )>("py_notify_module_del", &Monitor::py_notify_module_del, &MonitorWrap::default_py_notify_module_del)
			.def<void (Monitor::*)(Cell* , const IdString* , const SigSpec* , const SigSpec* )>("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec", &Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec, &MonitorWrap::default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Cell__YOSYS_NAMESPACE_RTLIL_IdString__YOSYS_NAMESPACE_RTLIL_SigSpec__YOSYS_NAMESPACE_RTLIL_SigSpec)
			.def<void (Monitor::*)(Module* , boost::python::tuple)>("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_", &Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_, &MonitorWrap::default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec_)
			.def<void (Monitor::*)(Module* , boost::python::list)>("py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__", &Monitor::py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__, &MonitorWrap::default_py_notify_connect__YOSYS_NAMESPACE_RTLIL_Module__std_vector_std_pair_YOSYS_NAMESPACE_RTLIL_SigSpecYOSYS_NAMESPACE_RTLIL_SigSpec__)
			.def<void (Monitor::*)(Module* )>("py_notify_blackout", &Monitor::py_notify_blackout, &MonitorWrap::default_py_notify_blackout)
			;

		class_<CaseRule, bases<AttrObject>>("CaseRule")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("compare", &CaseRule::get_var_py_compare, &CaseRule::set_var_py_compare)
			.add_property("actions", &CaseRule::get_var_py_actions, &CaseRule::set_var_py_actions)
			.add_property("switches", &CaseRule::get_var_py_switches, &CaseRule::set_var_py_switches)
			.add_property("attributes", &CaseRule::get_var_py_attributes, &CaseRule::set_var_py_attributes)
			.def<bool (CaseRule::*)(void)>("empty", &CaseRule::empty)
			.def<CaseRule (CaseRule::*)(void)>("clone", &CaseRule::clone)
			.def<bool (CaseRule::*)(const IdString* )>("has_attribute", &CaseRule::has_attribute)
			.def<void (CaseRule::*)(const IdString* )>("set_bool_attribute", &CaseRule::set_bool_attribute)
			.def<void (CaseRule::*)(const IdString* , bool)>("set_bool_attribute", &CaseRule::set_bool_attribute)
			.def<bool (CaseRule::*)(const IdString* )>("get_bool_attribute", &CaseRule::get_bool_attribute)
			.def<bool (CaseRule::*)(void) const>("get_blackbox_attribute", &CaseRule::get_blackbox_attribute)
			.def<bool (CaseRule::*)(bool) const>("get_blackbox_attribute", &CaseRule::get_blackbox_attribute)
			.def<void (CaseRule::*)(const IdString* , string)>("set_string_attribute", &CaseRule::set_string_attribute)
			.def<string (CaseRule::*)(const IdString* )>("get_string_attribute", &CaseRule::get_string_attribute)
			.def<void (CaseRule::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &CaseRule::set_strpool_attribute)
			.def<void (CaseRule::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &CaseRule::add_strpool_attribute)
			.def<boost::python::list (CaseRule::*)(const IdString* )>("get_strpool_attribute", &CaseRule::get_strpool_attribute)
			.def<void (CaseRule::*)(const string)>("set_src_attribute", &CaseRule::set_src_attribute)
			.def<string (CaseRule::*)(void) const>("get_src_attribute", &CaseRule::get_src_attribute)
			;

		class_<SwitchRule, bases<AttrObject>>("SwitchRule")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("signal", &SwitchRule::get_var_py_signal, &SwitchRule::set_var_py_signal)
			.add_property("cases", &SwitchRule::get_var_py_cases, &SwitchRule::set_var_py_cases)
			.add_property("attributes", &SwitchRule::get_var_py_attributes, &SwitchRule::set_var_py_attributes)
			.def<bool (SwitchRule::*)(void)>("empty", &SwitchRule::empty)
			.def<SwitchRule (SwitchRule::*)(void)>("clone", &SwitchRule::clone)
			.def<bool (SwitchRule::*)(const IdString* )>("has_attribute", &SwitchRule::has_attribute)
			.def<void (SwitchRule::*)(const IdString* )>("set_bool_attribute", &SwitchRule::set_bool_attribute)
			.def<void (SwitchRule::*)(const IdString* , bool)>("set_bool_attribute", &SwitchRule::set_bool_attribute)
			.def<bool (SwitchRule::*)(const IdString* )>("get_bool_attribute", &SwitchRule::get_bool_attribute)
			.def<bool (SwitchRule::*)(void) const>("get_blackbox_attribute", &SwitchRule::get_blackbox_attribute)
			.def<bool (SwitchRule::*)(bool) const>("get_blackbox_attribute", &SwitchRule::get_blackbox_attribute)
			.def<void (SwitchRule::*)(const IdString* , string)>("set_string_attribute", &SwitchRule::set_string_attribute)
			.def<string (SwitchRule::*)(const IdString* )>("get_string_attribute", &SwitchRule::get_string_attribute)
			.def<void (SwitchRule::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &SwitchRule::set_strpool_attribute)
			.def<void (SwitchRule::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &SwitchRule::add_strpool_attribute)
			.def<boost::python::list (SwitchRule::*)(const IdString* )>("get_strpool_attribute", &SwitchRule::get_strpool_attribute)
			.def<void (SwitchRule::*)(const string)>("set_src_attribute", &SwitchRule::set_src_attribute)
			.def<string (SwitchRule::*)(void) const>("get_src_attribute", &SwitchRule::get_src_attribute)
			;

		class_<SyncRule>("SyncRule")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("type", &SyncRule::get_var_py_type, &SyncRule::set_var_py_type)
			.add_property("signal", &SyncRule::get_var_py_signal, &SyncRule::set_var_py_signal)
			.add_property("actions", &SyncRule::get_var_py_actions, &SyncRule::set_var_py_actions)
			.def<SyncRule (SyncRule::*)(void)>("clone", &SyncRule::clone)
			;

		class_<Process, bases<NamedObject>>("Process", no_init)
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("module", &Process::get_var_py_module, &Process::set_var_py_module)
			.add_property("root_case", &Process::get_var_py_root_case, &Process::set_var_py_root_case)
			.add_property("syncs", &Process::get_var_py_syncs, &Process::set_var_py_syncs)
			.add_property("name", &Process::get_var_py_name, &Process::set_var_py_name)
			.add_property("attributes", &Process::get_var_py_attributes, &Process::set_var_py_attributes)
			.def<Process (Process::*)(void)>("clone", &Process::clone)
			.def<bool (Process::*)(const IdString* )>("has_attribute", &Process::has_attribute)
			.def<void (Process::*)(const IdString* )>("set_bool_attribute", &Process::set_bool_attribute)
			.def<void (Process::*)(const IdString* , bool)>("set_bool_attribute", &Process::set_bool_attribute)
			.def<bool (Process::*)(const IdString* )>("get_bool_attribute", &Process::get_bool_attribute)
			.def<bool (Process::*)(void) const>("get_blackbox_attribute", &Process::get_blackbox_attribute)
			.def<bool (Process::*)(bool) const>("get_blackbox_attribute", &Process::get_blackbox_attribute)
			.def<void (Process::*)(const IdString* , string)>("set_string_attribute", &Process::set_string_attribute)
			.def<string (Process::*)(const IdString* )>("get_string_attribute", &Process::get_string_attribute)
			.def<void (Process::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &Process::set_strpool_attribute)
			.def<void (Process::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &Process::add_strpool_attribute)
			.def<boost::python::list (Process::*)(const IdString* )>("get_strpool_attribute", &Process::get_strpool_attribute)
			.def<void (Process::*)(const string)>("set_src_attribute", &Process::set_src_attribute)
			.def<string (Process::*)(void) const>("get_src_attribute", &Process::get_src_attribute)
			.def("__hash__", &Process::get_hash_py)
			;

		class_<SigChunk>("SigChunk")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<const Const* >())
			.def(init<Const* >())
			.def(init<Wire* >())
			.def(init<Wire* , int, int>())
			.def(init<const string>())
			.def(init<int, int>())
			.def(init<State, int>())
			.def(init<const SigBit* >())
			.add_property("wire", &SigChunk::get_var_py_wire, &SigChunk::set_var_py_wire)
			.add_property("data", &SigChunk::get_var_py_data, &SigChunk::set_var_py_data)
			.add_property("width", &SigChunk::get_var_py_width, &SigChunk::set_var_py_width)
			.add_property("offset", &SigChunk::get_var_py_offset, &SigChunk::set_var_py_offset)
			.def<SigChunk (SigChunk::*)(int, int)>("extract", &SigChunk::extract)
			.def<int (SigChunk::*)(void) const>("size", &SigChunk::size)
			.def<bool (SigChunk::*)(void) const>("is_wire", &SigChunk::is_wire)
			.def<bool (SigChunk::*)(const SigChunk* )>("__lt__", &SigChunk::operator<)
			.def<bool (SigChunk::*)(const SigChunk* )>("__eq__", &SigChunk::operator==)
			.def<bool (SigChunk::*)(const SigChunk* )>("__ne__", &SigChunk::operator!=)
			;

		class_<SigBit>("SigBit")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<State>())
			.def(init<Wire* >())
			.def(init<Wire* , int>())
			.def(init<const SigChunk* >())
			.def(init<const SigChunk* , int>())
			.def(init<const SigSpec* >())
			.def(init<const SigBit* >())
			.add_property("wire", &SigBit::get_var_py_wire, &SigBit::set_var_py_wire)
			.add_property("data", &SigBit::get_var_py_data, &SigBit::set_var_py_data)
			.add_property("offset", &SigBit::get_var_py_offset, &SigBit::set_var_py_offset)
			.def<bool (SigBit::*)(void) const>("is_wire", &SigBit::is_wire)
			.def<bool (SigBit::*)(const SigBit* )>("__lt__", &SigBit::operator<)
			.def<bool (SigBit::*)(const SigBit* )>("__eq__", &SigBit::operator==)
			.def<bool (SigBit::*)(const SigBit* )>("__ne__", &SigBit::operator!=)
			.def("__hash__", &SigBit::get_hash_py)
			;

		class_<SigSpec>("SigSpec")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<const Const* >())
			.def(init<Const* >())
			.def(init<const SigChunk* >())
			.def(init<SigChunk* >())
			.def(init<Wire* >())
			.def(init<Wire* , int, int>())
			.def(init<const string>())
			.def(init<int, int>())
			.def(init<State, int>())
			.def(init<const SigBit* , int>())
			.def(init<boost::python::list>())
			.def<boost::python::list (SigSpec::*)(void) const>("chunks", &SigSpec::chunks)
			.def<boost::python::list (SigSpec::*)(void) const>("bits", &SigSpec::bits)
			.def<int (SigSpec::*)(void) const>("size", &SigSpec::size)
			.def<bool (SigSpec::*)(void) const>("empty", &SigSpec::empty)
			.def<void (SigSpec::*)(void)>("sort", &SigSpec::sort)
			.def<void (SigSpec::*)(void)>("sort_and_unify", &SigSpec::sort_and_unify)
			.def<void (SigSpec::*)(const SigSpec* , const SigSpec* )>("replace", &SigSpec::replace)
			.def<void (SigSpec::*)(const SigSpec* , const SigSpec* , SigSpec* )>("replace", &SigSpec::replace)
			.def<void (SigSpec::*)(int, const SigSpec* )>("replace", &SigSpec::replace)
			.def<void (SigSpec::*)(const SigSpec* )>("remove", &SigSpec::remove)
			.def<void (SigSpec::*)(const SigSpec* , SigSpec* )>("remove", &SigSpec::remove)
			.def<void (SigSpec::*)(const SigSpec* , SigSpec* )>("remove2", &SigSpec::remove2)
			.def<void (SigSpec::*)(boost::python::list)>("remove", &SigSpec::remove)
			.def<void (SigSpec::*)(boost::python::list, SigSpec* )>("remove", &SigSpec::remove)
			.def<void (SigSpec::*)(boost::python::list, SigSpec* )>("remove2__pool_YOSYS_NAMESPACE_RTLIL_SigBit___YOSYS_NAMESPACE_RTLIL_SigSpec", &SigSpec::remove2__pool_YOSYS_NAMESPACE_RTLIL_SigBit___YOSYS_NAMESPACE_RTLIL_SigSpec)
			.def<void (SigSpec::*)(boost::python::list, SigSpec* )>("remove2__std_set_YOSYS_NAMESPACE_RTLIL_SigBit___YOSYS_NAMESPACE_RTLIL_SigSpec", &SigSpec::remove2__std_set_YOSYS_NAMESPACE_RTLIL_SigBit___YOSYS_NAMESPACE_RTLIL_SigSpec)
			.def<void (SigSpec::*)(boost::python::list, SigSpec* )>("remove2__pool_YOSYS_NAMESPACE_RTLIL_Wire___YOSYS_NAMESPACE_RTLIL_SigSpec", &SigSpec::remove2__pool_YOSYS_NAMESPACE_RTLIL_Wire___YOSYS_NAMESPACE_RTLIL_SigSpec)
			.def<void (SigSpec::*)(int)>("remove", &SigSpec::remove)
			.def<void (SigSpec::*)(int, int)>("remove", &SigSpec::remove)
			.def<void (SigSpec::*)(void)>("remove_const", &SigSpec::remove_const)
			.def<SigSpec (SigSpec::*)(const SigSpec* , const SigSpec* )>("extract", &SigSpec::extract)
			.def<SigSpec (SigSpec::*)(boost::python::list, const SigSpec* )>("extract", &SigSpec::extract)
			.def<SigSpec (SigSpec::*)(int)>("extract", &SigSpec::extract)
			.def<SigSpec (SigSpec::*)(int, int)>("extract", &SigSpec::extract)
			.def<SigSpec (SigSpec::*)(int) const>("extract_end", &SigSpec::extract_end)
			.def<SigBit (SigSpec::*)(void) const>("lsb", &SigSpec::lsb)
			.def<SigBit (SigSpec::*)(void) const>("msb", &SigSpec::msb)
			.def<void (SigSpec::*)(const SigSpec* )>("append", &SigSpec::append)
			.def<void (SigSpec::*)(Wire* )>("append", &SigSpec::append)
			.def<void (SigSpec::*)(const SigChunk* )>("append", &SigSpec::append)
			.def<void (SigSpec::*)(const Const* )>("append", &SigSpec::append)
			.def<void (SigSpec::*)(const SigBit* )>("append", &SigSpec::append)
			.def<void (SigSpec::*)(State)>("append", &SigSpec::append)
			.def<void (SigSpec::*)(bool)>("append", &SigSpec::append)
			.def<void (SigSpec::*)(int)>("extend_u0", &SigSpec::extend_u0)
			.def<void (SigSpec::*)(int, bool)>("extend_u0", &SigSpec::extend_u0)
			.def<SigSpec (SigSpec::*)(int)>("repeat", &SigSpec::repeat)
			.def<void (SigSpec::*)(void)>("reverse", &SigSpec::reverse)
			.def<bool (SigSpec::*)(const SigSpec* )>("__lt__", &SigSpec::operator<)
			.def<bool (SigSpec::*)(const SigSpec* )>("__eq__", &SigSpec::operator==)
			.def<bool (SigSpec::*)(const SigSpec* ) const>("__ne__", &SigSpec::operator!=)
			.def<bool (SigSpec::*)(void)>("is_wire", &SigSpec::is_wire)
			.def<bool (SigSpec::*)(void)>("is_chunk", &SigSpec::is_chunk)
			.def<bool (SigSpec::*)(void) const>("is_bit", &SigSpec::is_bit)
			.def<bool (SigSpec::*)(void)>("is_fully_const", &SigSpec::is_fully_const)
			.def<bool (SigSpec::*)(void)>("is_fully_zero", &SigSpec::is_fully_zero)
			.def<bool (SigSpec::*)(void)>("is_fully_ones", &SigSpec::is_fully_ones)
			.def<bool (SigSpec::*)(void)>("is_fully_def", &SigSpec::is_fully_def)
			.def<bool (SigSpec::*)(void)>("is_fully_undef", &SigSpec::is_fully_undef)
			.def<bool (SigSpec::*)(void)>("has_const", &SigSpec::has_const)
			.def<bool (SigSpec::*)(void)>("has_marked_bits", &SigSpec::has_marked_bits)
			.def<bool (SigSpec::*)(void)>("is_onehot", &SigSpec::is_onehot)
			.def<bool (SigSpec::*)(int)>("is_onehot", &SigSpec::is_onehot)
			.def<bool (SigSpec::*)(void)>("as_bool", &SigSpec::as_bool)
			.def<int (SigSpec::*)(void)>("as_int", &SigSpec::as_int)
			.def<int (SigSpec::*)(bool)>("as_int", &SigSpec::as_int)
			.def<bool (SigSpec::*)(void)>("convertible_to_int", &SigSpec::convertible_to_int)
			.def<bool (SigSpec::*)(bool)>("convertible_to_int", &SigSpec::convertible_to_int)
			.def<int (SigSpec::*)(void)>("as_int_saturating", &SigSpec::as_int_saturating)
			.def<int (SigSpec::*)(bool)>("as_int_saturating", &SigSpec::as_int_saturating)
			.def<string (SigSpec::*)(void)>("as_string", &SigSpec::as_string)
			.def<Const (SigSpec::*)(void)>("as_const", &SigSpec::as_const)
			.def<Wire (SigSpec::*)(void)>("as_wire", &SigSpec::as_wire)
			.def<SigChunk (SigSpec::*)(void)>("as_chunk", &SigSpec::as_chunk)
			.def<SigBit (SigSpec::*)(void)>("as_bit", &SigSpec::as_bit)
			.def<bool (SigSpec::*)(const char *)>("match", &SigSpec::match)
			.def<boost::python::list (SigSpec::*)(void)>("to_sigbit_set", &SigSpec::to_sigbit_set)
			.def<boost::python::list (SigSpec::*)(void)>("to_sigbit_pool", &SigSpec::to_sigbit_pool)
			.def<boost::python::list (SigSpec::*)(void)>("to_sigbit_vector", &SigSpec::to_sigbit_vector)
			.def<boost::python::dict (SigSpec::*)(const SigSpec* )>("to_sigbit_map", &SigSpec::to_sigbit_map)
			.def<boost::python::dict (SigSpec::*)(const SigSpec* )>("to_sigbit_dict", &SigSpec::to_sigbit_dict)
			.def<bool (*)(SigSpec* , Module* , string)>("parse", &SigSpec::parse)
			.def<bool (*)(SigSpec* , Design* , Module* , string)>("parse_sel", &SigSpec::parse_sel)
			.def<bool (*)(const SigSpec* , SigSpec* , Module* , string)>("parse_rhs", &SigSpec::parse_rhs)
			.def<SigBit (SigSpec::*)(int, const SigBit* )>("at", &SigSpec::at)
			.def<void (SigSpec::*)(void)>("check", &SigSpec::check)
			.def<void (SigSpec::*)(Module* )>("check", &SigSpec::check)
			.staticmethod("parse")
			.staticmethod("parse_sel")
			.staticmethod("parse_rhs")
			.def("__hash__", &SigSpec::get_hash_py)
			;

		class_<Cell, bases<NamedObject>>("Cell", no_init)
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("module", &Cell::get_var_py_module, &Cell::set_var_py_module)
			.add_property("type", &Cell::get_var_py_type, &Cell::set_var_py_type)
			.add_property("connections_", &Cell::get_var_py_connections_, &Cell::set_var_py_connections_)
			.add_property("parameters", &Cell::get_var_py_parameters, &Cell::set_var_py_parameters)
			.add_property("name", &Cell::get_var_py_name, &Cell::set_var_py_name)
			.add_property("attributes", &Cell::get_var_py_attributes, &Cell::set_var_py_attributes)
			.def<bool (Cell::*)(const IdString* )>("hasPort", &Cell::hasPort)
			.def<void (Cell::*)(const IdString* )>("unsetPort", &Cell::unsetPort)
			.def<void (Cell::*)(const IdString* , SigSpec* )>("setPort", &Cell::setPort)
			.def<SigSpec (Cell::*)(const IdString* )>("getPort", &Cell::getPort)
			.def<boost::python::dict (Cell::*)(void)>("connections", &Cell::connections)
			.def<bool (Cell::*)(void)>("known", &Cell::known)
			.def<bool (Cell::*)(const IdString* )>("input", &Cell::input)
			.def<bool (Cell::*)(const IdString* )>("output", &Cell::output)
			.def<bool (Cell::*)(const IdString* )>("hasParam", &Cell::hasParam)
			.def<void (Cell::*)(const IdString* )>("unsetParam", &Cell::unsetParam)
			.def<void (Cell::*)(const IdString* , Const* )>("setParam", &Cell::setParam)
			.def<Const (Cell::*)(const IdString* )>("getParam", &Cell::getParam)
			.def<void (Cell::*)(void)>("sort", &Cell::sort)
			.def<void (Cell::*)(void)>("check", &Cell::check)
			.def<void (Cell::*)(void)>("fixup_parameters", &Cell::fixup_parameters)
			.def<void (Cell::*)(bool)>("fixup_parameters", &Cell::fixup_parameters)
			.def<void (Cell::*)(bool, bool)>("fixup_parameters", &Cell::fixup_parameters)
			.def<bool (Cell::*)(void) const>("has_keep_attr", &Cell::has_keep_attr)
			.def<boost::python::dict (*)(void)>("get_all_cells", &Cell::get_all_cells)
			.def<bool (Cell::*)(void)>("has_memid", &Cell::has_memid)
			.def<bool (Cell::*)(void)>("is_mem_cell", &Cell::is_mem_cell)
			.def<bool (Cell::*)(const IdString* )>("has_attribute", &Cell::has_attribute)
			.def<void (Cell::*)(const IdString* )>("set_bool_attribute", &Cell::set_bool_attribute)
			.def<void (Cell::*)(const IdString* , bool)>("set_bool_attribute", &Cell::set_bool_attribute)
			.def<bool (Cell::*)(const IdString* )>("get_bool_attribute", &Cell::get_bool_attribute)
			.def<bool (Cell::*)(void) const>("get_blackbox_attribute", &Cell::get_blackbox_attribute)
			.def<bool (Cell::*)(bool) const>("get_blackbox_attribute", &Cell::get_blackbox_attribute)
			.def<void (Cell::*)(const IdString* , string)>("set_string_attribute", &Cell::set_string_attribute)
			.def<string (Cell::*)(const IdString* )>("get_string_attribute", &Cell::get_string_attribute)
			.def<void (Cell::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &Cell::set_strpool_attribute)
			.def<void (Cell::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &Cell::add_strpool_attribute)
			.def<boost::python::list (Cell::*)(const IdString* )>("get_strpool_attribute", &Cell::get_strpool_attribute)
			.def<void (Cell::*)(const string)>("set_src_attribute", &Cell::set_src_attribute)
			.def<string (Cell::*)(void) const>("get_src_attribute", &Cell::get_src_attribute)
			.staticmethod("get_all_cells")
			.def("__hash__", &Cell::get_hash_py)
			;

		class_<Wire, bases<NamedObject>>("Wire", no_init)
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("module", &Wire::get_var_py_module, &Wire::set_var_py_module)
			.add_property("width", &Wire::get_var_py_width, &Wire::set_var_py_width)
			.add_property("start_offset", &Wire::get_var_py_start_offset, &Wire::set_var_py_start_offset)
			.add_property("port_id", &Wire::get_var_py_port_id, &Wire::set_var_py_port_id)
			.add_property("port_input", &Wire::get_var_py_port_input, &Wire::set_var_py_port_input)
			.add_property("port_output", &Wire::get_var_py_port_output, &Wire::set_var_py_port_output)
			.add_property("upto", &Wire::get_var_py_upto, &Wire::set_var_py_upto)
			.add_property("is_signed", &Wire::get_var_py_is_signed, &Wire::set_var_py_is_signed)
			.add_property("name", &Wire::get_var_py_name, &Wire::set_var_py_name)
			.add_property("attributes", &Wire::get_var_py_attributes, &Wire::set_var_py_attributes)
			.def<Cell (Wire::*)(void) const>("driverCell", &Wire::driverCell)
			.def<IdString (Wire::*)(void) const>("driverPort", &Wire::driverPort)
			.def<int (Wire::*)(int)>("from_hdl_index", &Wire::from_hdl_index)
			.def<int (Wire::*)(int)>("to_hdl_index", &Wire::to_hdl_index)
			.def<boost::python::dict (*)(void)>("get_all_wires", &Wire::get_all_wires)
			.def<bool (Wire::*)(const IdString* )>("has_attribute", &Wire::has_attribute)
			.def<void (Wire::*)(const IdString* )>("set_bool_attribute", &Wire::set_bool_attribute)
			.def<void (Wire::*)(const IdString* , bool)>("set_bool_attribute", &Wire::set_bool_attribute)
			.def<bool (Wire::*)(const IdString* )>("get_bool_attribute", &Wire::get_bool_attribute)
			.def<bool (Wire::*)(void) const>("get_blackbox_attribute", &Wire::get_blackbox_attribute)
			.def<bool (Wire::*)(bool) const>("get_blackbox_attribute", &Wire::get_blackbox_attribute)
			.def<void (Wire::*)(const IdString* , string)>("set_string_attribute", &Wire::set_string_attribute)
			.def<string (Wire::*)(const IdString* )>("get_string_attribute", &Wire::get_string_attribute)
			.def<void (Wire::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &Wire::set_strpool_attribute)
			.def<void (Wire::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &Wire::add_strpool_attribute)
			.def<boost::python::list (Wire::*)(const IdString* )>("get_strpool_attribute", &Wire::get_strpool_attribute)
			.def<void (Wire::*)(const string)>("set_src_attribute", &Wire::set_src_attribute)
			.def<string (Wire::*)(void) const>("get_src_attribute", &Wire::get_src_attribute)
			.staticmethod("get_all_wires")
			.def("__hash__", &Wire::get_hash_py)
			;

		class_<Memory, bases<NamedObject>>("Memory")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("width", &Memory::get_var_py_width, &Memory::set_var_py_width)
			.add_property("start_offset", &Memory::get_var_py_start_offset, &Memory::set_var_py_start_offset)
			.add_property("size", &Memory::get_var_py_size, &Memory::set_var_py_size)
			.add_property("name", &Memory::get_var_py_name, &Memory::set_var_py_name)
			.add_property("attributes", &Memory::get_var_py_attributes, &Memory::set_var_py_attributes)
			.def<boost::python::dict (*)(void)>("get_all_memorys", &Memory::get_all_memorys)
			.def<bool (Memory::*)(const IdString* )>("has_attribute", &Memory::has_attribute)
			.def<void (Memory::*)(const IdString* )>("set_bool_attribute", &Memory::set_bool_attribute)
			.def<void (Memory::*)(const IdString* , bool)>("set_bool_attribute", &Memory::set_bool_attribute)
			.def<bool (Memory::*)(const IdString* )>("get_bool_attribute", &Memory::get_bool_attribute)
			.def<bool (Memory::*)(void) const>("get_blackbox_attribute", &Memory::get_blackbox_attribute)
			.def<bool (Memory::*)(bool) const>("get_blackbox_attribute", &Memory::get_blackbox_attribute)
			.def<void (Memory::*)(const IdString* , string)>("set_string_attribute", &Memory::set_string_attribute)
			.def<string (Memory::*)(const IdString* )>("get_string_attribute", &Memory::get_string_attribute)
			.def<void (Memory::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &Memory::set_strpool_attribute)
			.def<void (Memory::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &Memory::add_strpool_attribute)
			.def<boost::python::list (Memory::*)(const IdString* )>("get_strpool_attribute", &Memory::get_strpool_attribute)
			.def<void (Memory::*)(const string)>("set_src_attribute", &Memory::set_src_attribute)
			.def<string (Memory::*)(void) const>("get_src_attribute", &Memory::get_src_attribute)
			.staticmethod("get_all_memorys")
			.def("__hash__", &Memory::get_hash_py)
			;

		class_<Module, bases<NamedObject>>("Module")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("design", &Module::get_var_py_design, &Module::set_var_py_design)
			.add_property("monitors", &Module::get_var_py_monitors, &Module::set_var_py_monitors)
			.add_property("refcount_wires_", &Module::get_var_py_refcount_wires_, &Module::set_var_py_refcount_wires_)
			.add_property("refcount_cells_", &Module::get_var_py_refcount_cells_, &Module::set_var_py_refcount_cells_)
			.add_property("wires_", &Module::get_var_py_wires_, &Module::set_var_py_wires_)
			.add_property("cells_", &Module::get_var_py_cells_, &Module::set_var_py_cells_)
			.add_property("connections_", &Module::get_var_py_connections_, &Module::set_var_py_connections_)
			.add_property("avail_parameters", &Module::get_var_py_avail_parameters, &Module::set_var_py_avail_parameters)
			.add_property("parameter_default_values", &Module::get_var_py_parameter_default_values, &Module::set_var_py_parameter_default_values)
			.add_property("memories", &Module::get_var_py_memories, &Module::set_var_py_memories)
			.add_property("processes", &Module::get_var_py_processes, &Module::set_var_py_processes)
			.add_property("ports", &Module::get_var_py_ports, &Module::set_var_py_ports)
			.add_property("name", &Module::get_var_py_name, &Module::set_var_py_name)
			.add_property("attributes", &Module::get_var_py_attributes, &Module::set_var_py_attributes)
			.def<size_t (Module::*)(const IdString* )>("count_id", &Module::count_id)
			.def<bool (Module::*)(Design* )>("reprocess_if_necessary", &Module::reprocess_if_necessary)
			.def<void (Module::*)(void)>("sort", &Module::sort)
			.def<void (Module::*)(void)>("check", &Module::check)
			.def<void (Module::*)(void)>("optimize", &Module::optimize)
			.def<void (Module::*)(void)>("makeblackbox", &Module::makeblackbox)
			.def<bool (Module::*)(void) const>("get_blackbox_attribute", &Module::get_blackbox_attribute)
			.def<bool (Module::*)(bool) const>("get_blackbox_attribute", &Module::get_blackbox_attribute)
			.def<void (Module::*)(boost::python::tuple)>("connect", &Module::connect)
			.def<void (Module::*)(const SigSpec* , const SigSpec* )>("connect", &Module::connect)
			.def<void (Module::*)(boost::python::list)>("new_connections", &Module::new_connections)
			.def<boost::python::list (Module::*)(void)>("connections", &Module::connections)
			.def<void (Module::*)(void)>("fixup_ports", &Module::fixup_ports)
			.def<void (Module::*)(void)>("bufNormalize", &Module::bufNormalize)
			.def<void (Module::*)(Module* )>("cloneInto", &Module::cloneInto)
			.def<Module (Module::*)(void)>("clone", &Module::clone)
			.def<bool (Module::*)(void)>("has_memories", &Module::has_memories)
			.def<bool (Module::*)(void)>("has_processes", &Module::has_processes)
			.def<bool (Module::*)(void)>("has_memories_warn", &Module::has_memories_warn)
			.def<bool (Module::*)(void)>("has_processes_warn", &Module::has_processes_warn)
			.def<bool (Module::*)(void)>("is_selected", &Module::is_selected)
			.def<bool (Module::*)(void)>("is_selected_whole", &Module::is_selected_whole)
			.def<boost::python::list (Module::*)(void)>("selected_wires", &Module::selected_wires)
			.def<boost::python::list (Module::*)(void)>("selected_cells", &Module::selected_cells)
			.def<boost::python::list (Module::*)(void)>("selected_memories", &Module::selected_memories)
			.def<boost::python::list (Module::*)(void)>("selected_processes", &Module::selected_processes)
			.def<boost::python::list (Module::*)(void)>("selected_members", &Module::selected_members)
			.def<Wire (Module::*)(const IdString* )>("wire", &Module::wire)
			.def<Cell (Module::*)(const IdString* )>("cell", &Module::cell)
			.def<boost::python::list (Module::*)(void)>("wires", &Module::wires)
			.def<boost::python::list (Module::*)(void)>("cells", &Module::cells)
			.def<void (Module::*)(boost::python::list)>("remove", &Module::remove)
			.def<void (Module::*)(Cell* )>("remove", &Module::remove)
			.def<void (Module::*)(Process* )>("remove", &Module::remove)
			.def<void (Module::*)(Wire* , IdString* )>("rename", &Module::rename)
			.def<void (Module::*)(Cell* , IdString* )>("rename", &Module::rename)
			.def<void (Module::*)(IdString* , IdString* )>("rename", &Module::rename)
			.def<void (Module::*)(Wire* , Wire* )>("swap_names", &Module::swap_names)
			.def<void (Module::*)(Cell* , Cell* )>("swap_names", &Module::swap_names)
			.def<IdString (Module::*)(IdString* )>("uniquify", &Module::uniquify)
			.def<IdString (Module::*)(IdString* , int)>("uniquify", &Module::uniquify)
			.def<Wire (Module::*)(IdString* )>("addWire", &Module::addWire)
			.def<Wire (Module::*)(IdString* , int)>("addWire", &Module::addWire)
			.def<Wire (Module::*)(IdString* , const Wire* )>("addWire", &Module::addWire)
			.def<Cell (Module::*)(IdString* , IdString* )>("addCell", &Module::addCell)
			.def<Cell (Module::*)(IdString* , const Cell* )>("addCell", &Module::addCell)
			.def<Memory (Module::*)(IdString* , const Memory* )>("addMemory", &Module::addMemory)
			.def<Process (Module::*)(IdString* )>("addProcess", &Module::addProcess)
			.def<Process (Module::*)(IdString* , const Process* )>("addProcess", &Module::addProcess)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addNot", &Module::addNot)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addNot", &Module::addNot)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addNot", &Module::addNot)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addPos", &Module::addPos)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addPos", &Module::addPos)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addPos", &Module::addPos)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addBuf", &Module::addBuf)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addBuf", &Module::addBuf)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addBuf", &Module::addBuf)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addNeg", &Module::addNeg)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addNeg", &Module::addNeg)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addNeg", &Module::addNeg)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addAnd", &Module::addAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addAnd", &Module::addAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addAnd", &Module::addAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addOr", &Module::addOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addOr", &Module::addOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addOr", &Module::addOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addXor", &Module::addXor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addXor", &Module::addXor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addXor", &Module::addXor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addXnor", &Module::addXnor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addXnor", &Module::addXnor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addXnor", &Module::addXnor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addReduceAnd", &Module::addReduceAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addReduceAnd", &Module::addReduceAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addReduceAnd", &Module::addReduceAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addReduceOr", &Module::addReduceOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addReduceOr", &Module::addReduceOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addReduceOr", &Module::addReduceOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addReduceXor", &Module::addReduceXor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addReduceXor", &Module::addReduceXor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addReduceXor", &Module::addReduceXor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addReduceXnor", &Module::addReduceXnor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addReduceXnor", &Module::addReduceXnor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addReduceXnor", &Module::addReduceXnor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addReduceBool", &Module::addReduceBool)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addReduceBool", &Module::addReduceBool)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addReduceBool", &Module::addReduceBool)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addShl", &Module::addShl)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addShl", &Module::addShl)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addShl", &Module::addShl)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addShr", &Module::addShr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addShr", &Module::addShr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addShr", &Module::addShr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addSshl", &Module::addSshl)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addSshl", &Module::addSshl)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addSshl", &Module::addSshl)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addSshr", &Module::addSshr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addSshr", &Module::addSshr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addSshr", &Module::addSshr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addShift", &Module::addShift)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addShift", &Module::addShift)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addShift", &Module::addShift)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addShiftx", &Module::addShiftx)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addShiftx", &Module::addShiftx)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addShiftx", &Module::addShiftx)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addLt", &Module::addLt)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addLt", &Module::addLt)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addLt", &Module::addLt)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addLe", &Module::addLe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addLe", &Module::addLe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addLe", &Module::addLe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addEq", &Module::addEq)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addEq", &Module::addEq)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addEq", &Module::addEq)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addNe", &Module::addNe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addNe", &Module::addNe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addNe", &Module::addNe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addEqx", &Module::addEqx)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addEqx", &Module::addEqx)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addEqx", &Module::addEqx)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addNex", &Module::addNex)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addNex", &Module::addNex)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addNex", &Module::addNex)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addGe", &Module::addGe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addGe", &Module::addGe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addGe", &Module::addGe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addGt", &Module::addGt)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addGt", &Module::addGt)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addGt", &Module::addGt)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addAdd", &Module::addAdd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addAdd", &Module::addAdd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addAdd", &Module::addAdd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addSub", &Module::addSub)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addSub", &Module::addSub)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addSub", &Module::addSub)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addMul", &Module::addMul)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addMul", &Module::addMul)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addMul", &Module::addMul)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDiv", &Module::addDiv)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addDiv", &Module::addDiv)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addDiv", &Module::addDiv)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addMod", &Module::addMod)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addMod", &Module::addMod)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addMod", &Module::addMod)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDivFloor", &Module::addDivFloor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addDivFloor", &Module::addDivFloor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addDivFloor", &Module::addDivFloor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addModFloor", &Module::addModFloor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addModFloor", &Module::addModFloor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addModFloor", &Module::addModFloor)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addPow", &Module::addPow)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addPow", &Module::addPow)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool)>("addPow", &Module::addPow)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool, const string)>("addPow", &Module::addPow)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addFa", &Module::addFa)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addFa", &Module::addFa)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addLogicNot", &Module::addLogicNot)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("addLogicNot", &Module::addLogicNot)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("addLogicNot", &Module::addLogicNot)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addLogicAnd", &Module::addLogicAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addLogicAnd", &Module::addLogicAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addLogicAnd", &Module::addLogicAnd)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addLogicOr", &Module::addLogicOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addLogicOr", &Module::addLogicOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addLogicOr", &Module::addLogicOr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addMux", &Module::addMux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addMux", &Module::addMux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addPmux", &Module::addPmux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addPmux", &Module::addPmux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addBmux", &Module::addBmux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addBmux", &Module::addBmux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDemux", &Module::addDemux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addDemux", &Module::addDemux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addBweqx", &Module::addBweqx)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addBweqx", &Module::addBweqx)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addBwmux", &Module::addBwmux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addBwmux", &Module::addBwmux)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , Const* )>("addSlice", &Module::addSlice)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , Const* , const string)>("addSlice", &Module::addSlice)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addConcat", &Module::addConcat)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addConcat", &Module::addConcat)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , Const* )>("addLut", &Module::addLut)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , Const* , const string)>("addLut", &Module::addLut)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addTribuf", &Module::addTribuf)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addTribuf", &Module::addTribuf)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addAssert", &Module::addAssert)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("addAssert", &Module::addAssert)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addAssume", &Module::addAssume)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("addAssume", &Module::addAssume)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addLive", &Module::addLive)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("addLive", &Module::addLive)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addFair", &Module::addFair)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("addFair", &Module::addFair)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addCover", &Module::addCover)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("addCover", &Module::addCover)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addEquiv", &Module::addEquiv)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addEquiv", &Module::addEquiv)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addSr", &Module::addSr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addSr", &Module::addSr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool)>("addSr", &Module::addSr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool, const string)>("addSr", &Module::addSr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addFf", &Module::addFf)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("addFf", &Module::addFf)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDff", &Module::addDff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addDff", &Module::addDff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addDff", &Module::addDff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDffe", &Module::addDffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addDffe", &Module::addDffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool)>("addDffe", &Module::addDffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool, const string)>("addDffe", &Module::addDffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* )>("addDffsr", &Module::addDffsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool)>("addDffsr", &Module::addDffsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool)>("addDffsr", &Module::addDffsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool, bool)>("addDffsr", &Module::addDffsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool, bool, const string)>("addDffsr", &Module::addDffsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* )>("addDffsre", &Module::addDffsre)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool)>("addDffsre", &Module::addDffsre)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool)>("addDffsre", &Module::addDffsre)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool, bool)>("addDffsre", &Module::addDffsre)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool, bool, bool)>("addDffsre", &Module::addDffsre)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool, bool, bool, const string)>("addDffsre", &Module::addDffsre)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* )>("addAdff", &Module::addAdff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool)>("addAdff", &Module::addAdff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool)>("addAdff", &Module::addAdff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, const string)>("addAdff", &Module::addAdff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* )>("addAdffe", &Module::addAdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool)>("addAdffe", &Module::addAdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool)>("addAdffe", &Module::addAdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, bool)>("addAdffe", &Module::addAdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, bool, const string)>("addAdffe", &Module::addAdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addAldff", &Module::addAldff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addAldff", &Module::addAldff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool)>("addAldff", &Module::addAldff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool, const string)>("addAldff", &Module::addAldff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addAldffe", &Module::addAldffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addAldffe", &Module::addAldffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool)>("addAldffe", &Module::addAldffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool, bool)>("addAldffe", &Module::addAldffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool, bool, const string)>("addAldffe", &Module::addAldffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* )>("addSdff", &Module::addSdff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool)>("addSdff", &Module::addSdff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool)>("addSdff", &Module::addSdff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, const string)>("addSdff", &Module::addSdff)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* )>("addSdffe", &Module::addSdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool)>("addSdffe", &Module::addSdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool)>("addSdffe", &Module::addSdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, bool)>("addSdffe", &Module::addSdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, bool, const string)>("addSdffe", &Module::addSdffe)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* )>("addSdffce", &Module::addSdffce)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool)>("addSdffce", &Module::addSdffce)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool)>("addSdffce", &Module::addSdffce)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, bool)>("addSdffce", &Module::addSdffce)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, bool, const string)>("addSdffce", &Module::addSdffce)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDlatch", &Module::addDlatch)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addDlatch", &Module::addDlatch)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addDlatch", &Module::addDlatch)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* )>("addAdlatch", &Module::addAdlatch)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool)>("addAdlatch", &Module::addAdlatch)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool)>("addAdlatch", &Module::addAdlatch)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , Const* , bool, bool, const string)>("addAdlatch", &Module::addAdlatch)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* )>("addDlatchsr", &Module::addDlatchsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool)>("addDlatchsr", &Module::addDlatchsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool)>("addDlatchsr", &Module::addDlatchsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool, bool)>("addDlatchsr", &Module::addDlatchsr)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , SigSpec* , const SigSpec* , bool, bool, bool, const string)>("addDlatchsr", &Module::addDlatchsr)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* )>("addBufGate", &Module::addBufGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("addBufGate", &Module::addBufGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* )>("addNotGate", &Module::addNotGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("addNotGate", &Module::addNotGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("addAndGate", &Module::addAndGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("addAndGate", &Module::addAndGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("addNandGate", &Module::addNandGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("addNandGate", &Module::addNandGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("addOrGate", &Module::addOrGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("addOrGate", &Module::addOrGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("addNorGate", &Module::addNorGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("addNorGate", &Module::addNorGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("addXorGate", &Module::addXorGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("addXorGate", &Module::addXorGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("addXnorGate", &Module::addXnorGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("addXnorGate", &Module::addXnorGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("addAndnotGate", &Module::addAndnotGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("addAndnotGate", &Module::addAndnotGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("addOrnotGate", &Module::addOrnotGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("addOrnotGate", &Module::addOrnotGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* )>("addMuxGate", &Module::addMuxGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const string)>("addMuxGate", &Module::addMuxGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* )>("addNmuxGate", &Module::addNmuxGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const string)>("addNmuxGate", &Module::addNmuxGate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* )>("addAoi3Gate", &Module::addAoi3Gate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const string)>("addAoi3Gate", &Module::addAoi3Gate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* )>("addOai3Gate", &Module::addOai3Gate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const string)>("addOai3Gate", &Module::addOai3Gate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const SigBit* )>("addAoi4Gate", &Module::addAoi4Gate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const string)>("addAoi4Gate", &Module::addAoi4Gate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const SigBit* )>("addOai4Gate", &Module::addOai4Gate)
			.def<Cell (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const string)>("addOai4Gate", &Module::addOai4Gate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addFfGate", &Module::addFfGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("addFfGate", &Module::addFfGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDffGate", &Module::addDffGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addDffGate", &Module::addDffGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addDffGate", &Module::addDffGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDffeGate", &Module::addDffeGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addDffeGate", &Module::addDffeGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool)>("addDffeGate", &Module::addDffeGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , bool, bool, const string)>("addDffeGate", &Module::addDffeGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("addDlatchGate", &Module::addDlatchGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool)>("addDlatchGate", &Module::addDlatchGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , bool, const string)>("addDlatchGate", &Module::addDlatchGate)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("addAnyinit", &Module::addAnyinit)
			.def<Cell (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("addAnyinit", &Module::addAnyinit)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("Not", &Module::Not)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("Not", &Module::Not)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("Not", &Module::Not)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("Pos", &Module::Pos)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("Pos", &Module::Pos)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("Pos", &Module::Pos)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("Buf", &Module::Buf)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("Buf", &Module::Buf)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("Buf", &Module::Buf)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("Neg", &Module::Neg)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("Neg", &Module::Neg)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("Neg", &Module::Neg)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("And", &Module::And)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("And", &Module::And)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("And", &Module::And)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Or", &Module::Or)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Or", &Module::Or)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Or", &Module::Or)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Xor", &Module::Xor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Xor", &Module::Xor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Xor", &Module::Xor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Xnor", &Module::Xnor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Xnor", &Module::Xnor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Xnor", &Module::Xnor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("ReduceAnd", &Module::ReduceAnd)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("ReduceAnd", &Module::ReduceAnd)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("ReduceAnd", &Module::ReduceAnd)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("ReduceOr", &Module::ReduceOr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("ReduceOr", &Module::ReduceOr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("ReduceOr", &Module::ReduceOr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("ReduceXor", &Module::ReduceXor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("ReduceXor", &Module::ReduceXor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("ReduceXor", &Module::ReduceXor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("ReduceXnor", &Module::ReduceXnor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("ReduceXnor", &Module::ReduceXnor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("ReduceXnor", &Module::ReduceXnor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("ReduceBool", &Module::ReduceBool)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("ReduceBool", &Module::ReduceBool)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("ReduceBool", &Module::ReduceBool)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Shl", &Module::Shl)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Shl", &Module::Shl)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Shl", &Module::Shl)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Shr", &Module::Shr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Shr", &Module::Shr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Shr", &Module::Shr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Sshl", &Module::Sshl)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Sshl", &Module::Sshl)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Sshl", &Module::Sshl)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Sshr", &Module::Sshr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Sshr", &Module::Sshr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Sshr", &Module::Sshr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Shift", &Module::Shift)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Shift", &Module::Shift)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Shift", &Module::Shift)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Shiftx", &Module::Shiftx)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Shiftx", &Module::Shiftx)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Shiftx", &Module::Shiftx)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Lt", &Module::Lt)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Lt", &Module::Lt)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Lt", &Module::Lt)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Le", &Module::Le)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Le", &Module::Le)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Le", &Module::Le)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Eq", &Module::Eq)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Eq", &Module::Eq)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Eq", &Module::Eq)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Ne", &Module::Ne)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Ne", &Module::Ne)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Ne", &Module::Ne)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Eqx", &Module::Eqx)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Eqx", &Module::Eqx)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Eqx", &Module::Eqx)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Nex", &Module::Nex)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Nex", &Module::Nex)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Nex", &Module::Nex)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Ge", &Module::Ge)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Ge", &Module::Ge)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Ge", &Module::Ge)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Gt", &Module::Gt)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Gt", &Module::Gt)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Gt", &Module::Gt)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Add", &Module::Add)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Add", &Module::Add)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Add", &Module::Add)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Sub", &Module::Sub)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Sub", &Module::Sub)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Sub", &Module::Sub)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Mul", &Module::Mul)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Mul", &Module::Mul)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Mul", &Module::Mul)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Div", &Module::Div)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Div", &Module::Div)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Div", &Module::Div)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Mod", &Module::Mod)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("Mod", &Module::Mod)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("Mod", &Module::Mod)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("DivFloor", &Module::DivFloor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("DivFloor", &Module::DivFloor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("DivFloor", &Module::DivFloor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("ModFloor", &Module::ModFloor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("ModFloor", &Module::ModFloor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("ModFloor", &Module::ModFloor)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("LogicNot", &Module::LogicNot)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool)>("LogicNot", &Module::LogicNot)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , bool, const string)>("LogicNot", &Module::LogicNot)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("LogicAnd", &Module::LogicAnd)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("LogicAnd", &Module::LogicAnd)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("LogicAnd", &Module::LogicAnd)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("LogicOr", &Module::LogicOr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool)>("LogicOr", &Module::LogicOr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , bool, const string)>("LogicOr", &Module::LogicOr)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("Mux", &Module::Mux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("Mux", &Module::Mux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("Pmux", &Module::Pmux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("Pmux", &Module::Pmux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Bmux", &Module::Bmux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("Bmux", &Module::Bmux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Demux", &Module::Demux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("Demux", &Module::Demux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* )>("Bweqx", &Module::Bweqx)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const string)>("Bweqx", &Module::Bweqx)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* )>("Bwmux", &Module::Bwmux)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("Bwmux", &Module::Bwmux)
			.def<SigBit (Module::*)(IdString* , const SigBit* )>("BufGate", &Module::BufGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const string)>("BufGate", &Module::BufGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* )>("NotGate", &Module::NotGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const string)>("NotGate", &Module::NotGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* )>("AndGate", &Module::AndGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("AndGate", &Module::AndGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* )>("NandGate", &Module::NandGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("NandGate", &Module::NandGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* )>("OrGate", &Module::OrGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("OrGate", &Module::OrGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* )>("NorGate", &Module::NorGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("NorGate", &Module::NorGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* )>("XorGate", &Module::XorGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("XorGate", &Module::XorGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* )>("XnorGate", &Module::XnorGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("XnorGate", &Module::XnorGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* )>("AndnotGate", &Module::AndnotGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("AndnotGate", &Module::AndnotGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* )>("OrnotGate", &Module::OrnotGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const string)>("OrnotGate", &Module::OrnotGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("MuxGate", &Module::MuxGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("MuxGate", &Module::MuxGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("NmuxGate", &Module::NmuxGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("NmuxGate", &Module::NmuxGate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("Aoi3Gate", &Module::Aoi3Gate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("Aoi3Gate", &Module::Aoi3Gate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* )>("Oai3Gate", &Module::Oai3Gate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const string)>("Oai3Gate", &Module::Oai3Gate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* )>("Aoi4Gate", &Module::Aoi4Gate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const string)>("Aoi4Gate", &Module::Aoi4Gate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* )>("Oai4Gate", &Module::Oai4Gate)
			.def<SigBit (Module::*)(IdString* , const SigBit* , const SigBit* , const SigBit* , const SigBit* , const string)>("Oai4Gate", &Module::Oai4Gate)
			.def<SigSpec (Module::*)(IdString* )>("Anyconst", &Module::Anyconst)
			.def<SigSpec (Module::*)(IdString* , int)>("Anyconst", &Module::Anyconst)
			.def<SigSpec (Module::*)(IdString* , int, const string)>("Anyconst", &Module::Anyconst)
			.def<SigSpec (Module::*)(IdString* )>("Anyseq", &Module::Anyseq)
			.def<SigSpec (Module::*)(IdString* , int)>("Anyseq", &Module::Anyseq)
			.def<SigSpec (Module::*)(IdString* , int, const string)>("Anyseq", &Module::Anyseq)
			.def<SigSpec (Module::*)(IdString* )>("Allconst", &Module::Allconst)
			.def<SigSpec (Module::*)(IdString* , int)>("Allconst", &Module::Allconst)
			.def<SigSpec (Module::*)(IdString* , int, const string)>("Allconst", &Module::Allconst)
			.def<SigSpec (Module::*)(IdString* )>("Allseq", &Module::Allseq)
			.def<SigSpec (Module::*)(IdString* , int)>("Allseq", &Module::Allseq)
			.def<SigSpec (Module::*)(IdString* , int, const string)>("Allseq", &Module::Allseq)
			.def<SigSpec (Module::*)(IdString* )>("Initstate", &Module::Initstate)
			.def<SigSpec (Module::*)(IdString* , const string)>("Initstate", &Module::Initstate)
			.def<SigSpec (Module::*)(IdString* , const string, const SigSpec* , const SigSpec* , const SigSpec* )>("SetTag", &Module::SetTag)
			.def<SigSpec (Module::*)(IdString* , const string, const SigSpec* , const SigSpec* , const SigSpec* , const string)>("SetTag", &Module::SetTag)
			.def<Cell (Module::*)(IdString* , const string, const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* )>("addSetTag", &Module::addSetTag)
			.def<Cell (Module::*)(IdString* , const string, const SigSpec* , const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addSetTag", &Module::addSetTag)
			.def<SigSpec (Module::*)(IdString* , const string, const SigSpec* )>("GetTag", &Module::GetTag)
			.def<SigSpec (Module::*)(IdString* , const string, const SigSpec* , const string)>("GetTag", &Module::GetTag)
			.def<Cell (Module::*)(IdString* , const string, const SigSpec* , const SigSpec* , const SigSpec* )>("addOverwriteTag", &Module::addOverwriteTag)
			.def<Cell (Module::*)(IdString* , const string, const SigSpec* , const SigSpec* , const SigSpec* , const string)>("addOverwriteTag", &Module::addOverwriteTag)
			.def<SigSpec (Module::*)(IdString* , const string, const SigSpec* )>("OriginalTag", &Module::OriginalTag)
			.def<SigSpec (Module::*)(IdString* , const string, const SigSpec* , const string)>("OriginalTag", &Module::OriginalTag)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* )>("FutureFF", &Module::FutureFF)
			.def<SigSpec (Module::*)(IdString* , const SigSpec* , const string)>("FutureFF", &Module::FutureFF)
			.def<boost::python::dict (*)(void)>("get_all_modules", &Module::get_all_modules)
			.def<bool (Module::*)(const IdString* )>("has_attribute", &Module::has_attribute)
			.def<void (Module::*)(const IdString* )>("set_bool_attribute", &Module::set_bool_attribute)
			.def<void (Module::*)(const IdString* , bool)>("set_bool_attribute", &Module::set_bool_attribute)
			.def<bool (Module::*)(const IdString* )>("get_bool_attribute", &Module::get_bool_attribute)
			.def<void (Module::*)(const IdString* , string)>("set_string_attribute", &Module::set_string_attribute)
			.def<string (Module::*)(const IdString* )>("get_string_attribute", &Module::get_string_attribute)
			.def<void (Module::*)(const IdString* , boost::python::list)>("set_strpool_attribute", &Module::set_strpool_attribute)
			.def<void (Module::*)(const IdString* , boost::python::list)>("add_strpool_attribute", &Module::add_strpool_attribute)
			.def<boost::python::list (Module::*)(const IdString* )>("get_strpool_attribute", &Module::get_strpool_attribute)
			.def<void (Module::*)(const string)>("set_src_attribute", &Module::set_src_attribute)
			.def<string (Module::*)(void) const>("get_src_attribute", &Module::get_src_attribute)
			.staticmethod("get_all_modules")
			.def("__hash__", &Module::get_hash_py)
			;

		class_<Design>("Design")
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.add_property("monitors", &Design::get_var_py_monitors, &Design::set_var_py_monitors)
			.add_property("scratchpad", &Design::get_var_py_scratchpad, &Design::set_var_py_scratchpad)
			.add_property("refcount_modules_", &Design::get_var_py_refcount_modules_, &Design::set_var_py_refcount_modules_)
			.add_property("modules_", &Design::get_var_py_modules_, &Design::set_var_py_modules_)
			.add_property("selection_stack", &Design::get_var_py_selection_stack, &Design::set_var_py_selection_stack)
			.add_property("selection_vars", &Design::get_var_py_selection_vars, &Design::set_var_py_selection_vars)
			.add_property("selected_active_module", &Design::get_var_py_selected_active_module, &Design::set_var_py_selected_active_module)
			.def<void (Design::*)(void)>("bufNormalize", &Design::bufNormalize)
			.def<void (Design::*)(bool)>("bufNormalize", &Design::bufNormalize)
			.def<boost::python::list (Design::*)(void)>("modules", &Design::modules)
			.def<Module (Design::*)(const IdString* )>("module", &Design::module)
			.def<Module (Design::*)(void)>("top_module", &Design::top_module)
			.def<bool (Design::*)(const IdString* ) const>("has", &Design::has)
			.def<void (Design::*)(Module* )>("add", &Design::add)
			.def<Module (Design::*)(IdString* )>("addModule", &Design::addModule)
			.def<void (Design::*)(Module* )>("remove", &Design::remove)
			.def<void (Design::*)(Module* , IdString* )>("rename", &Design::rename)
			.def<void (Design::*)(const string)>("scratchpad_unset", &Design::scratchpad_unset)
			.def<void (Design::*)(const string, int)>("scratchpad_set_int", &Design::scratchpad_set_int)
			.def<void (Design::*)(const string, bool)>("scratchpad_set_bool", &Design::scratchpad_set_bool)
			.def<void (Design::*)(const string, string)>("scratchpad_set_string", &Design::scratchpad_set_string)
			.def<int (Design::*)(const string)>("scratchpad_get_int", &Design::scratchpad_get_int)
			.def<int (Design::*)(const string, int)>("scratchpad_get_int", &Design::scratchpad_get_int)
			.def<bool (Design::*)(const string)>("scratchpad_get_bool", &Design::scratchpad_get_bool)
			.def<bool (Design::*)(const string, bool)>("scratchpad_get_bool", &Design::scratchpad_get_bool)
			.def<string (Design::*)(const string)>("scratchpad_get_string", &Design::scratchpad_get_string)
			.def<string (Design::*)(const string, const string)>("scratchpad_get_string", &Design::scratchpad_get_string)
			.def<void (Design::*)(void)>("sort", &Design::sort)
			.def<void (Design::*)(void)>("check", &Design::check)
			.def<void (Design::*)(void)>("optimize", &Design::optimize)
			.def<bool (Design::*)(const IdString* )>("selected_module", &Design::selected_module)
			.def<bool (Design::*)(const IdString* )>("selected_whole_module", &Design::selected_whole_module)
			.def<bool (Design::*)(const IdString* , const IdString* )>("selected_member", &Design::selected_member)
			.def<bool (Design::*)(Module* )>("selected_module", &Design::selected_module)
			.def<bool (Design::*)(Module* )>("selected_whole_module", &Design::selected_whole_module)
			.def<void (Design::*)(Selection* )>("push_selection", &Design::push_selection)
			.def<void (Design::*)(void)>("push_empty_selection", &Design::push_empty_selection)
			.def<void (Design::*)(void)>("push_full_selection", &Design::push_full_selection)
			.def<void (Design::*)(void)>("push_complete_selection", &Design::push_complete_selection)
			.def<void (Design::*)(void)>("pop_selection", &Design::pop_selection)
			.def<Selection (Design::*)(void)>("selection", &Design::selection)
			.def<bool (Design::*)(void) const>("full_selection", &Design::full_selection)
			.def<boost::python::list (Design::*)(void) const>("all_selected_modules", &Design::all_selected_modules)
			.def<boost::python::list (Design::*)(void) const>("selected_unboxed_modules", &Design::selected_unboxed_modules)
			.def<boost::python::list (Design::*)(void) const>("selected_unboxed_modules_warn", &Design::selected_unboxed_modules_warn)
			.def<boost::python::list (Design::*)(void) const>("selected_whole_modules", &Design::selected_whole_modules)
			.def<boost::python::list (Design::*)(void) const>("all_selected_whole_modules", &Design::all_selected_whole_modules)
			.def<boost::python::list (Design::*)(void) const>("selected_unboxed_whole_modules", &Design::selected_unboxed_whole_modules)
			.def<boost::python::list (Design::*)(void) const>("selected_unboxed_whole_modules_warn", &Design::selected_unboxed_whole_modules_warn)
			.def<boost::python::dict (*)(void)>("get_all_designs", &Design::get_all_designs)
			.staticmethod("get_all_designs")
			.def("__hash__", &Design::get_hash_py)
			;

		class_<SigMap>("SigMap", no_init)
			.def(boost::python::self_ns::str(boost::python::self_ns::self))
			.def(boost::python::self_ns::repr(boost::python::self_ns::self))
			.def(init<Module* >())
			.def<void (SigMap::*)(SigMap* )>("swap", &SigMap::swap)
			.def<void (SigMap::*)(void)>("clear", &SigMap::clear)
			.def<void (SigMap::*)(Module* )>("set", &SigMap::set)
			.def<void (SigMap::*)(const SigSpec* , const SigSpec* )>("add", &SigMap::add)
			.def<void (SigMap::*)(const SigBit* )>("add", &SigMap::add)
			.def<void (SigMap::*)(const SigSpec* )>("add", &SigMap::add)
			.def<void (SigMap::*)(Wire* )>("add", &SigMap::add)
			.def<void (SigMap::*)(SigBit* ) const>("apply", &SigMap::apply)
			.def<void (SigMap::*)(SigSpec* ) const>("apply", &SigMap::apply)
			.def<SigBit (SigMap::*)(SigBit* ) const>("__call__", &SigMap::operator())
			.def<SigSpec (SigMap::*)(SigSpec* ) const>("__call__", &SigMap::operator())
			.def<SigSpec (SigMap::*)(Wire* ) const>("__call__", &SigMap::operator())
			.def<SigSpec (SigMap::*)(void) const>("allbits", &SigMap::allbits)
			;

		def<void (*)(const char *)>("log", YOSYS_PYTHON::log);
		def<void (*)(Design* , const char *)>("log_header", YOSYS_PYTHON::log_header);
		def<void (*)(const char *)>("log_warning", YOSYS_PYTHON::log_warning);
		def<void (*)(const char *)>("log_experimental", YOSYS_PYTHON::log_experimental);
		def<void (*)(const string, int, const char *)>("log_file_warning", YOSYS_PYTHON::log_file_warning);
		def<void (*)(const string, int, const char *)>("log_file_info", YOSYS_PYTHON::log_file_info);
		def<void (*)(const char *)>("log_warning_noprefix", YOSYS_PYTHON::log_warning_noprefix);
		def<void (*)(const char *)>("log_error", YOSYS_PYTHON::log_error);
		def<void (*)(const string, int, const char *)>("log_file_error", YOSYS_PYTHON::log_file_error);
		def<void (*)(const char *)>("log_cmd_error", YOSYS_PYTHON::log_cmd_error);
		def<bool (*)(void)>("ys_debug", YOSYS_PYTHON::ys_debug);
		def<bool (*)(int)>("ys_debug", YOSYS_PYTHON::ys_debug);
		def<void (*)(void)>("log_suppressed", YOSYS_PYTHON::log_suppressed);
		def<void (*)(void)>("log_spacer", YOSYS_PYTHON::log_spacer);
		def<void (*)(void)>("log_push", YOSYS_PYTHON::log_push);
		def<void (*)(void)>("log_pop", YOSYS_PYTHON::log_pop);
		def<void (*)(const char *, int)>("log_backtrace", YOSYS_PYTHON::log_backtrace);
		def<void (*)(void)>("log_reset_stack", YOSYS_PYTHON::log_reset_stack);
		def<void (*)(void)>("log_flush", YOSYS_PYTHON::log_flush);
		def<void (*)(void)>("log_check_expected", YOSYS_PYTHON::log_check_expected);
		def<const char * (*)(const SigSpec* )>("log_signal", YOSYS_PYTHON::log_signal);
		def<const char * (*)(const SigSpec* , bool)>("log_signal", YOSYS_PYTHON::log_signal);
		def<const char * (*)(const Const* )>("log_const", YOSYS_PYTHON::log_const);
		def<const char * (*)(const Const* , bool)>("log_const", YOSYS_PYTHON::log_const);
		def<const char * (*)(const IdString* )>("log_id", YOSYS_PYTHON::log_id);
		def<const char * (*)(const char *)>("log_str", YOSYS_PYTHON::log_str);
		def<void (*)(Module* )>("log_module", YOSYS_PYTHON::log_module);
		def<void (*)(Module* , string)>("log_module", YOSYS_PYTHON::log_module);
		def<void (*)(Cell* )>("log_cell", YOSYS_PYTHON::log_cell);
		def<void (*)(Cell* , string)>("log_cell", YOSYS_PYTHON::log_cell);
		def<void (*)(Wire* )>("log_wire", YOSYS_PYTHON::log_wire);
		def<void (*)(Wire* , string)>("log_wire", YOSYS_PYTHON::log_wire);
		def<void (*)(bool, const char *, const char *, int)>("log_assert_worker", YOSYS_PYTHON::log_assert_worker);
		def<void (*)(string, string)>("cover_extra", YOSYS_PYTHON::cover_extra);
		def<void (*)(string, string, bool)>("cover_extra", YOSYS_PYTHON::cover_extra);
		def<boost::python::dict (*)(void)>("get_coverage_data", YOSYS_PYTHON::get_coverage_data);
		def<string (*)(string, string)>("cover_list_worker", YOSYS_PYTHON::cover_list_worker);
		def<void (*)(int)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(unsigned int)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(long int)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(long long int)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(bool)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(double)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(char *)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(const char *)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(string)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(const char *)>("log_dump_args_worker", YOSYS_PYTHON::log_dump_args_worker);
		def<void (*)(IdString* )>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(SigSpec* )>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<void (*)(State)>("log_dump_val_worker", YOSYS_PYTHON::log_dump_val_worker);
		def<boost::python::list (*)(void)>("builtin_ff_cell_types", YOSYS_PYTHON::builtin_ff_cell_types);
		def<string (*)(const string)>("escape_id", YOSYS_PYTHON::escape_id);
		def<string (*)(const string)>("unescape_id", YOSYS_PYTHON::unescape_id);
		def<string (*)(const IdString* )>("unescape_id", YOSYS_PYTHON::unescape_id);
		def<const char * (*)(const IdString* )>("id2cstr", YOSYS_PYTHON::id2cstr);
		def<string (*)(const string)>("encode_filename", YOSYS_PYTHON::encode_filename);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_not", YOSYS_PYTHON::const_not);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_and", YOSYS_PYTHON::const_and);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_or", YOSYS_PYTHON::const_or);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_xor", YOSYS_PYTHON::const_xor);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_xnor", YOSYS_PYTHON::const_xnor);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_reduce_and", YOSYS_PYTHON::const_reduce_and);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_reduce_or", YOSYS_PYTHON::const_reduce_or);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_reduce_xor", YOSYS_PYTHON::const_reduce_xor);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_reduce_xnor", YOSYS_PYTHON::const_reduce_xnor);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_reduce_bool", YOSYS_PYTHON::const_reduce_bool);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_logic_not", YOSYS_PYTHON::const_logic_not);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_logic_and", YOSYS_PYTHON::const_logic_and);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_logic_or", YOSYS_PYTHON::const_logic_or);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_shl", YOSYS_PYTHON::const_shl);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_shr", YOSYS_PYTHON::const_shr);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_sshl", YOSYS_PYTHON::const_sshl);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_sshr", YOSYS_PYTHON::const_sshr);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_shift", YOSYS_PYTHON::const_shift);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_shiftx", YOSYS_PYTHON::const_shiftx);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_lt", YOSYS_PYTHON::const_lt);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_le", YOSYS_PYTHON::const_le);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_eq", YOSYS_PYTHON::const_eq);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_ne", YOSYS_PYTHON::const_ne);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_eqx", YOSYS_PYTHON::const_eqx);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_nex", YOSYS_PYTHON::const_nex);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_ge", YOSYS_PYTHON::const_ge);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_gt", YOSYS_PYTHON::const_gt);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_add", YOSYS_PYTHON::const_add);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_sub", YOSYS_PYTHON::const_sub);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_mul", YOSYS_PYTHON::const_mul);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_div", YOSYS_PYTHON::const_div);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_divfloor", YOSYS_PYTHON::const_divfloor);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_modfloor", YOSYS_PYTHON::const_modfloor);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_mod", YOSYS_PYTHON::const_mod);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_pow", YOSYS_PYTHON::const_pow);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_pos", YOSYS_PYTHON::const_pos);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_buf", YOSYS_PYTHON::const_buf);
		def<Const (*)(const Const* , const Const* , bool, bool, int)>("const_neg", YOSYS_PYTHON::const_neg);
		def<Const (*)(const Const* , const Const* , const Const* )>("const_mux", YOSYS_PYTHON::const_mux);
		def<Const (*)(const Const* , const Const* , const Const* )>("const_pmux", YOSYS_PYTHON::const_pmux);
		def<Const (*)(const Const* , const Const* )>("const_bmux", YOSYS_PYTHON::const_bmux);
		def<Const (*)(const Const* , const Const* )>("const_demux", YOSYS_PYTHON::const_demux);
		def<Const (*)(const Const* , const Const* )>("const_bweqx", YOSYS_PYTHON::const_bweqx);
		def<Const (*)(const Const* , const Const* , const Const* )>("const_bwmux", YOSYS_PYTHON::const_bwmux);
		def<int (*)(Wire* )>("GetSize", YOSYS_PYTHON::GetSize);
		def<void (*)(void)>("yosys_setup", YOSYS_PYTHON::yosys_setup);
		def<bool (*)(void)>("yosys_already_setup", YOSYS_PYTHON::yosys_already_setup);
		def<void (*)(void)>("yosys_shutdown", YOSYS_PYTHON::yosys_shutdown);
		def<Design (*)(void)>("yosys_get_design", YOSYS_PYTHON::yosys_get_design);
		def<string (*)(void)>("proc_self_dirname", YOSYS_PYTHON::proc_self_dirname);
		def<string (*)(void)>("proc_share_dirname", YOSYS_PYTHON::proc_share_dirname);
		def<string (*)(void)>("proc_program_prefix", YOSYS_PYTHON::proc_program_prefix);
		def<const char * (*)(Design* , int)>("create_prompt", YOSYS_PYTHON::create_prompt);
		def<boost::python::list (*)(const string)>("glob_filename", YOSYS_PYTHON::glob_filename);
		def<void (*)(string)>("rewrite_filename", YOSYS_PYTHON::rewrite_filename);
		def<void (*)(string)>("run_pass", YOSYS_PYTHON::run_pass);
		def<void (*)(string, Design* )>("run_pass", YOSYS_PYTHON::run_pass);
		def<bool (*)(string, string)>("run_frontend", YOSYS_PYTHON::run_frontend);
		def<bool (*)(string, string, Design* )>("run_frontend", YOSYS_PYTHON::run_frontend);
		def<bool (*)(string, string, Design* , string)>("run_frontend", YOSYS_PYTHON::run_frontend);
		def<void (*)(string, string)>("run_backend", YOSYS_PYTHON::run_backend);
		def<void (*)(string, string, Design* )>("run_backend", YOSYS_PYTHON::run_backend);
		def<void (*)(Design* )>("shell", YOSYS_PYTHON::shell);
		def<const char * (*)(void)>("yosys_maybe_version", YOSYS_PYTHON::yosys_maybe_version);
		def<void (*)(string, boost::python::list)>("load_plugin", YOSYS_PYTHON::load_plugin);

		class_<YosysStatics>("Yosys")

			.add_static_property("yosys_celltypes", &YOSYS_PYTHON::get_var_py_yosys_celltypes, &YOSYS_PYTHON::set_var_py_yosys_celltypes)
			.add_static_property("log_scratchpads", &YOSYS_PYTHON::get_var_py_log_scratchpads, &YOSYS_PYTHON::set_var_py_log_scratchpads)
			.add_static_property("log_hdump", &YOSYS_PYTHON::get_var_py_log_hdump, &YOSYS_PYTHON::set_var_py_log_hdump)
			.add_static_property("log_warnings", &YOSYS_PYTHON::get_var_py_log_warnings, &YOSYS_PYTHON::set_var_py_log_warnings)
			.add_static_property("log_experimentals", &YOSYS_PYTHON::get_var_py_log_experimentals, &YOSYS_PYTHON::set_var_py_log_experimentals)
			.add_static_property("log_experimentals_ignored", &YOSYS_PYTHON::get_var_py_log_experimentals_ignored, &YOSYS_PYTHON::set_var_py_log_experimentals_ignored)
			.add_static_property("log_warnings_count", &YOSYS_PYTHON::get_var_py_log_warnings_count, &YOSYS_PYTHON::set_var_py_log_warnings_count)
			.add_static_property("log_warnings_count_noexpect", &YOSYS_PYTHON::get_var_py_log_warnings_count_noexpect, &YOSYS_PYTHON::set_var_py_log_warnings_count_noexpect)
			.add_static_property("log_expect_no_warnings", &YOSYS_PYTHON::get_var_py_log_expect_no_warnings, &YOSYS_PYTHON::set_var_py_log_expect_no_warnings)
			.add_static_property("log_hdump_all", &YOSYS_PYTHON::get_var_py_log_hdump_all, &YOSYS_PYTHON::set_var_py_log_hdump_all)
			.add_static_property("log_time", &YOSYS_PYTHON::get_var_py_log_time, &YOSYS_PYTHON::set_var_py_log_time)
			.add_static_property("log_error_stderr", &YOSYS_PYTHON::get_var_py_log_error_stderr, &YOSYS_PYTHON::set_var_py_log_error_stderr)
			.add_static_property("log_cmd_error_throw", &YOSYS_PYTHON::get_var_py_log_cmd_error_throw, &YOSYS_PYTHON::set_var_py_log_cmd_error_throw)
			.add_static_property("log_quiet_warnings", &YOSYS_PYTHON::get_var_py_log_quiet_warnings, &YOSYS_PYTHON::set_var_py_log_quiet_warnings)
			.add_static_property("log_verbose_level", &YOSYS_PYTHON::get_var_py_log_verbose_level, &YOSYS_PYTHON::set_var_py_log_verbose_level)
			.add_static_property("log_last_error", &YOSYS_PYTHON::get_var_py_log_last_error, &YOSYS_PYTHON::set_var_py_log_last_error)
			.add_static_property("log_make_debug", &YOSYS_PYTHON::get_var_py_log_make_debug, &YOSYS_PYTHON::set_var_py_log_make_debug)
			.add_static_property("log_force_debug", &YOSYS_PYTHON::get_var_py_log_force_debug, &YOSYS_PYTHON::set_var_py_log_force_debug)
			.add_static_property("log_debug_suppressed", &YOSYS_PYTHON::get_var_py_log_debug_suppressed, &YOSYS_PYTHON::set_var_py_log_debug_suppressed)
			.add_static_property("extra_coverage_data", &YOSYS_PYTHON::get_var_py_extra_coverage_data, &YOSYS_PYTHON::set_var_py_extra_coverage_data)
			.add_static_property("pass_register", &YOSYS_PYTHON::get_var_py_pass_register, &YOSYS_PYTHON::set_var_py_pass_register)
			.add_static_property("constpad", &YOSYS_PYTHON::get_var_py_constpad, &YOSYS_PYTHON::set_var_py_constpad)
			.add_static_property("yosys_design", &YOSYS_PYTHON::get_var_py_yosys_design, &YOSYS_PYTHON::set_var_py_yosys_design)
			.add_static_property("yosys_input_files", &YOSYS_PYTHON::get_var_py_yosys_input_files, &YOSYS_PYTHON::set_var_py_yosys_input_files)
			.add_static_property("yosys_output_files", &YOSYS_PYTHON::get_var_py_yosys_output_files, &YOSYS_PYTHON::set_var_py_yosys_output_files)
			.add_static_property("yosys_version_str", &YOSYS_PYTHON::get_var_py_yosys_version_str)
			.add_static_property("saved_designs", &YOSYS_PYTHON::get_var_py_saved_designs, &YOSYS_PYTHON::set_var_py_saved_designs)
			.add_static_property("pushed_designs", &YOSYS_PYTHON::get_var_py_pushed_designs, &YOSYS_PYTHON::set_var_py_pushed_designs)
			.add_static_property("loaded_plugin_aliases", &YOSYS_PYTHON::get_var_py_loaded_plugin_aliases, &YOSYS_PYTHON::set_var_py_loaded_plugin_aliases)
			.add_static_property("yosys_share_dirname", &YOSYS_PYTHON::get_var_py_yosys_share_dirname, &YOSYS_PYTHON::set_var_py_yosys_share_dirname)
			.add_static_property("yosys_abc_executable", &YOSYS_PYTHON::get_var_py_yosys_abc_executable, &YOSYS_PYTHON::set_var_py_yosys_abc_executable)		;

	}
}
#endif