# Some small pregroups



# The lists of small pregroups were generated by
# Chris Jefferson <caj21@st-andrews.ac.uk> and
# Richard Parker.
ANATPH_small_pregroups[1] :=
   [ [ [ 1 ] ] ];

ANATPH_small_pregroups[2] :=
   [ [ [1, 2],
       [2, 1] ] ];

ANATPH_small_pregroups[3] :=
   [ [ [1, 2, 3],
       [2, 1, 0],
       [3, 0, 1] ] ];
# missing: Cyclic group of order 3

ANATPH_small_pregroups[4] :=
 [ [ [1, 2, 3, 4],
     [2, 1, 0, 0],
     [3, 0, 1, 0],
     [4, 0, 0, 1] ],
   [ [1, 2, 3, 4],
     [2, 1, 4, 3],
     [3, 4, 1, 2],
     [4, 3, 2, 1] ],
   [ [1, 2, 3, 4],
     [2, 1, 0, 0],
     [3, 0, 0, 1],
     [4, 0, 1, 0] ],
   [ [1, 2, 3, 4],
     [2, 1, 0, 0],
     [3, 0, 4, 1],
     [4, 0, 1, 3] ],
   [ [1, 2, 3, 4],
     [2, 1, 4, 3],
     [3, 4, 2, 1],
     [4, 3, 1, 2] ] ];

ANATPH_small_pregroups[5] :=
   [ [ [1, 2, 3, 4, 5],
       [2, 1, 0, 0, 0],
       [3, 0, 1, 0, 0],
       [4, 0, 0, 1, 0],
       [5, 0, 0, 0, 1] ],
     [ [1, 2, 3, 4, 5],
       [2, 1, 4, 3, 0],
       [3, 4, 1, 2, 0],
       [4, 3, 2, 1, 0],
       [5, 0, 0, 0, 1]],
     [ [1, 2, 3, 4, 5],
       [2, 1, 0, 0, 0],
       [3, 0, 1, 0, 0],
       [4, 0, 0, 0, 1],
       [5, 0, 0, 1, 0]],
     [ [1, 2, 3, 4, 5],
       [2, 1, 0, 0, 0],
       [3, 0, 1, 0, 0],
       [4, 0, 0, 5, 1],
       [5, 0, 0, 1, 4]],
     [ [1, 2, 3, 4, 5],
       [2, 1, 4, 3, 0],
       [3, 4, 2, 1, 0],
       [4, 3, 1, 2, 0],
       [5, 0, 0, 0, 1]],
     [ [1, 2, 3, 4, 5],
       [2, 0, 1, 0, 0],
       [3, 1, 0, 0, 0],
       [4, 0, 0, 0, 1],
       [5, 0, 0, 1, 0]],
     [ [1, 2, 3, 4, 5],
       [2, 3, 1, 0, 0],
       [3, 1, 2, 0, 0],
       [4, 0, 0, 0, 1],
       [5, 0, 0, 1, 0]],
     [ [1, 2, 3, 4, 5],
       [2, 3, 1, 0, 0],
       [3, 1, 2, 0, 0],
       [4, 0, 0, 5, 1],
       [5, 0, 0, 1, 4]],
     [ [1, 2, 3, 4, 5],
       [2, 3, 4, 5, 1],
       [3, 4, 5, 1, 2],
       [4, 5, 1, 2, 3],
       [5, 1, 2, 3, 4]]];

ANATPH_small_pregroups[6] :=
    [ [ [1,2,3,4,5,6],
        [2,1,0,5,4,0],
        [3,6,0,1,0,0],
        [4,0,1,0,0,2],
        [5,0,2,0,0,1],
        [6,3,0,0,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,5,0,3,0],
        [3,0,0,1,0,2],
        [4,6,1,0,0,0],
        [5,0,0,2,0,1],
        [6,4,0,0,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,0,6,0,4],
        [3,5,0,1,0,0],
        [4,0,1,0,2,0],
        [5,3,0,0,0,1],
        [6,0,2,0,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,5,6,3,4],
        [3,5,0,1,0,2],
        [4,6,1,0,2,0],
        [5,3,0,2,0,1],
        [6,4,2,0,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,6,0,0,3],
        [3,0,0,1,2,0],
        [4,5,1,0,0,0],
        [5,4,0,0,0,1],
        [6,0,0,2,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,6,5,4,3],
        [3,6,0,1,2,0],
        [4,5,1,0,0,2],
        [5,4,2,0,0,1],
        [6,3,0,2,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,5,6,3,4],
        [3,6,1,0,0,2],
        [4,5,0,1,2,0],
        [5,4,2,0,0,1],
        [6,3,0,2,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,0,6,0,4],
        [3,0,1,5,4,0],
        [4,5,6,1,2,3],
        [5,4,0,3,0,1],
        [6,0,4,2,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,0,5,4,0],
        [3,0,1,6,0,4],
        [4,6,5,1,3,2],
        [5,0,4,2,0,1],
        [6,4,0,3,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,6,0,0,3],
        [3,5,1,6,2,4],
        [4,0,5,1,3,0],
        [5,3,4,0,0,1],
        [6,0,2,3,1,0] ],
      [ [1,2,3,4,5,6],
        [2,1,4,3,6,5],
        [3,4,1,2,0,0],
        [4,3,2,1,0,0],
        [5,6,0,0,2,1],
        [6,5,0,0,1,2] ],
      [ [1,2,3,4,5,6],
        [2,1,4,3,0,0],
        [3,4,1,2,6,5],
        [4,3,2,1,0,0],
        [5,0,6,0,3,1],
        [6,0,5,0,1,3] ],
      [ [1,2,3,4,5,6],
        [2,1,4,3,0,0],
        [3,4,1,2,0,0],
        [4,3,2,1,6,5],
        [5,0,0,6,4,1],
        [6,0,0,5,1,4] ],
      [ [1,2,3,4,5,6],
        [2,1,6,5,4,3],
        [3,6,1,0,0,2],
        [4,5,0,1,2,0],
        [5,4,0,2,1,0],
        [6,3,2,0,0,1] ],
      [ [1,2,3,4,5,6],
        [2,1,6,0,0,3],
        [3,6,1,5,4,2],
        [4,0,5,1,3,0],
        [5,0,4,3,1,0],
        [6,3,2,0,0,1] ],
      [ [1,2,3,4,5,6],
        [2,1,5,6,3,4],
        [3,5,1,0,2,0],
        [4,6,0,1,0,2],
        [5,3,2,0,1,0],
        [6,4,0,2,0,1] ],
      [ [1,2,3,4,5,6],
        [2,1,0,6,0,4],
        [3,0,1,5,4,0],
        [4,6,5,1,3,2],
        [5,0,4,3,1,0],
        [6,4,0,2,0,1] ],
      [ [1,2,3,4,5,6],
        [2,1,5,0,3,0],
        [3,5,1,6,2,4],
        [4,0,6,1,0,3],
        [5,3,2,0,1,0],
        [6,0,4,3,0,1] ],
      [ [1,2,3,4,5,6],
        [2,1,0,5,4,0],
        [3,0,1,6,0,4],
        [4,5,6,1,2,3],
        [5,4,0,2,1,0],
        [6,0,4,3,0,1] ],
      [ [1,2,3,4,5,6],
        [2,1,4,3,6,5],
        [3,4,1,2,0,0],
        [4,3,2,1,0,0],
        [5,6,0,0,1,2],
        [6,5,0,0,2,1] ],
      [ [1,2,3,4,5,6],
        [2,1,0,0,6,5],
        [3,0,1,5,4,0],
        [4,0,5,1,3,0],
        [5,6,4,3,1,2],
        [6,5,0,0,2,1] ],
      [ [1,2,3,4,5,6],
        [2,1,0,0,6,5],
        [3,0,1,6,0,4],
        [4,0,6,1,0,3],
        [5,6,0,0,1,2],
        [6,5,4,3,2,1] ],
      [ [1,2,3,4,5,6],
        [2,1,4,3,0,0],
        [3,4,1,2,6,5],
        [4,3,2,1,0,0],
        [5,0,6,0,1,3],
        [6,0,5,0,3,1] ],
      [ [1,2,3,4,5,6],
        [2,1,0,5,4,0],
        [3,0,1,0,6,5],
        [4,5,0,1,2,0],
        [5,4,6,2,1,3],
        [6,0,5,0,3,1] ],
      [ [1,2,3,4,5,6],
        [2,1,0,6,0,4],
        [3,0,1,0,6,5],
        [4,6,0,1,0,2],
        [5,0,6,0,1,3],
        [6,4,5,2,3,1] ],
      [ [1,2,3,4,5,6],
        [2,1,4,3,0,0],
        [3,4,1,2,0,0],
        [4,3,2,1,6,5],
        [5,0,0,6,1,4],
        [6,0,0,5,4,1] ],
      [ [1,2,3,4,5,6],
        [2,1,5,0,3,0],
        [3,5,1,0,2,0],
        [4,0,0,1,6,5],
        [5,3,2,6,1,4],
        [6,0,0,5,4,1] ],
      [ [1,2,3,4,5,6],
        [2,1,6,0,0,3],
        [3,6,1,0,0,2],
        [4,0,0,1,6,5],
        [5,0,0,6,1,4],
        [6,3,2,5,4,1] ]
    ];

ANATPH_small_pregroups[7] :=
    [ [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 0, 0, 0, 0, 0],
        [3, 0, 1, 0, 0, 0, 0],
        [4, 0, 0, 1, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 1, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 1, 2, 0, 0, 0],
        [4, 3, 2, 1, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 1, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 1, 2, 0, 0, 0],
        [4, 3, 2, 1, 0, 0, 0],
        [5, 0, 0, 0, 1, 7, 6],
        [6, 0, 0, 0, 7, 1, 5],
        [7, 0, 0, 0, 6, 5, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 6, 5, 0],
        [3, 4, 1, 2, 0, 0, 0],
        [4, 3, 2, 1, 0, 0, 0],
        [5, 6, 0, 0, 1, 2, 0],
        [6, 5, 0, 0, 2, 1, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 0, 0, 0, 0, 0],
        [3, 0, 1, 0, 0, 0, 0],
        [4, 0, 0, 1, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 0, 0, 0, 0, 0],
        [3, 0, 1, 0, 0, 0, 0],
        [4, 0, 0, 1, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 7, 1],
        [7, 0, 0, 0, 0, 1, 6] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 1, 2, 0, 0, 0],
        [4, 3, 2, 1, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 1, 2, 0, 0, 0],
        [4, 3, 2, 1, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 7, 1],
        [7, 0, 0, 0, 0, 1, 6] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 1, 2, 0, 0, 0],
        [4, 3, 2, 1, 0, 0, 0],
        [5, 0, 0, 0, 1, 7, 6],
        [6, 0, 0, 0, 7, 5, 1],
        [7, 0, 0, 0, 6, 1, 5] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 6, 5, 0],
        [3, 4, 1, 2, 0, 0, 0],
        [4, 3, 2, 1, 0, 0, 0],
        [5, 6, 0, 0, 2, 1, 0],
        [6, 5, 0, 0, 1, 2, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 6, 5, 0],
        [3, 5, 1, 0, 2, 0, 0],
        [4, 6, 2, 0, 1, 0, 0],
        [5, 3, 0, 1, 0, 2, 0],
        [6, 4, 0, 2, 0, 1, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 6, 5, 0],
        [3, 5, 1, 6, 2, 4, 0],
        [4, 6, 2, 5, 1, 3, 0],
        [5, 3, 6, 1, 4, 2, 0],
        [6, 4, 5, 2, 3, 1, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 0, 0, 0, 0, 0],
        [3, 0, 1, 0, 0, 0, 0],
        [4, 0, 0, 0, 1, 0, 0],
        [5, 0, 0, 1, 0, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 0, 0, 0, 0, 0],
        [3, 0, 1, 0, 0, 0, 0],
        [4, 0, 0, 5, 1, 0, 0],
        [5, 0, 0, 1, 4, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 0, 0, 0, 0, 0],
        [3, 0, 1, 0, 0, 0, 0],
        [4, 0, 0, 5, 1, 0, 0],
        [5, 0, 0, 1, 4, 0, 0],
        [6, 0, 0, 0, 0, 7, 1],
        [7, 0, 0, 0, 0, 1, 6] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 0, 0, 0, 0, 0],
        [3, 0, 1, 0, 0, 0, 0],
        [4, 0, 0, 5, 6, 7, 1],
        [5, 0, 0, 6, 7, 1, 4],
        [6, 0, 0, 7, 1, 4, 5],
        [7, 0, 0, 1, 4, 5, 6] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 2, 1, 0, 0, 0],
        [4, 3, 1, 2, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 1, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 2, 1, 0, 0, 0],
        [4, 3, 1, 2, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 2, 1, 0, 0, 0],
        [4, 3, 1, 2, 0, 0, 0],
        [5, 0, 0, 0, 1, 0, 0],
        [6, 0, 0, 0, 0, 7, 1],
        [7, 0, 0, 0, 0, 1, 6] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 4, 2, 1, 0, 0, 0],
        [4, 3, 1, 2, 0, 0, 0],
        [5, 0, 0, 0, 1, 7, 6],
        [6, 0, 0, 0, 7, 5, 1],
        [7, 0, 0, 0, 6, 1, 5] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 6, 5, 0],
        [3, 4, 2, 1, 0, 0, 0],
        [4, 3, 1, 2, 0, 0, 0],
        [5, 6, 0, 0, 2, 1, 0],
        [6, 5, 0, 0, 1, 2, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 0, 0, 0, 1, 2, 0],
        [4, 0, 0, 0, 2, 1, 0],
        [5, 6, 1, 0, 0, 0, 0],
        [6, 5, 0, 1, 0, 0, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 0, 0, 0],
        [3, 0, 0, 0, 1, 2, 4],
        [4, 0, 0, 0, 2, 1, 3],
        [5, 6, 1, 7, 0, 0, 0],
        [6, 5, 7, 1, 0, 0, 0],
        [7, 0, 0, 0, 6, 5, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 6, 5, 0],
        [3, 4, 0, 0, 1, 2, 0],
        [4, 3, 0, 0, 2, 1, 0],
        [5, 6, 1, 2, 0, 0, 0],
        [6, 5, 2, 1, 0, 0, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 1, 4, 3, 6, 5, 0],
        [3, 4, 5, 6, 1, 2, 0],
        [4, 3, 6, 5, 2, 1, 0],
        [5, 6, 1, 2, 3, 4, 0],
        [6, 5, 2, 1, 4, 3, 0],
        [7, 0, 0, 0, 0, 0, 1] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 0, 1, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [4, 0, 0, 0, 1, 0, 0],
        [5, 0, 0, 1, 0, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 3, 1, 0, 0, 0, 0],
        [3, 1, 2, 0, 0, 0, 0],
        [4, 0, 0, 0, 1, 0, 0],
        [5, 0, 0, 1, 0, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 3, 1, 0, 0, 0, 0],
        [3, 1, 2, 0, 0, 0, 0],
        [4, 0, 0, 5, 1, 0, 0],
        [5, 0, 0, 1, 4, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 3, 1, 0, 0, 0, 0],
        [3, 1, 2, 0, 0, 0, 0],
        [4, 0, 0, 5, 1, 0, 0],
        [5, 0, 0, 1, 4, 0, 0],
        [6, 0, 0, 0, 0, 7, 1],
        [7, 0, 0, 0, 0, 1, 6] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 0, 1, 5, 0, 0, 0],
        [3, 1, 0, 0, 4, 0, 0],
        [4, 0, 0, 0, 0, 1, 3],
        [5, 0, 0, 0, 0, 2, 1],
        [6, 0, 7, 1, 0, 0, 0],
        [7, 6, 0, 0, 1, 0, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 3, 1, 0, 0, 0, 0],
        [3, 1, 2, 0, 0, 0, 0],
        [4, 0, 0, 5, 6, 7, 1],
        [5, 0, 0, 6, 7, 1, 4],
        [6, 0, 0, 7, 1, 4, 5],
        [7, 0, 0, 1, 4, 5, 6] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 3, 4, 5, 1, 0, 0],
        [3, 4, 5, 1, 2, 0, 0],
        [4, 5, 1, 2, 3, 0, 0],
        [5, 1, 2, 3, 4, 0, 0],
        [6, 0, 0, 0, 0, 0, 1],
        [7, 0, 0, 0, 0, 1, 0] ],
      [ [1, 2, 3, 4, 5, 6, 7],
        [2, 3, 4, 5, 6, 7, 1],
        [3, 4, 5, 6, 7, 1, 2],
        [4, 5, 6, 7, 1, 2, 3],
        [5, 6, 7, 1, 2, 3, 4],
        [6, 7, 1, 2, 3, 4, 5],
        [7, 1, 2, 3, 4, 5, 6] ]
    ];

InstallGlobalFunction("NrSmallPregroups",
function(n)
    if not IsPosInt(n) then
        Error("n has to be a positive integer");
    fi;

    if IsBound(ANATPH_small_pregroups[n]) then
        return Length(ANATPH_small_pregroups[n]);
    fi;
    return fail;
end);

InstallGlobalFunction("SmallPregroup",
function(n,i)
    local names;
    if not IsPosInt(n) then
        Error("n has to be a positive integer");
    fi;

    if IsPosInt(i) and
       IsBound(ANATPH_small_pregroups[n]) and
       IsBound(ANATPH_small_pregroups[n][i]) then
        names := Concatenation( ["1"]
                              , List([2..n], y -> Concatenation("p", String(y-1))));
        return PregroupByTable(names, ANATPH_small_pregroups[n][i]);
    else
        Error("small pregroup of size ", n, " with index ", i, " not available");
    fi;
end);
