# YangBaxter, chapter 4
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("yangbaxter03.tst");

# doc/_Chapter_Ideals_and_left_ideals.xml:53-64
gap> br := SmallBrace(8,4);
<brace of size 8>
gap> leftideals := LeftIdeals(br);
[ <left ideal in <brace of size 8>, (size 1)>, <left ideal in <brace of size 8>, (size 2)>, 
<left ideal in <brace of size 8>, (size 4)>, 
<left ideal in <brace of size 8>, (size 8)> ]
gap> List(leftideals, x->IsLeftIdeal(br, x));
[ true, true, true, true ]
gap> List(leftideals, IdBrace);
[ [ 1, 1 ], [ 2, 1 ], [ 4, 1 ], [ 8, 4 ] ]

# doc/_Chapter_Ideals_and_left_ideals.xml:84-96
gap> br := SmallBrace(8,4);
<brace of size 8> 
gap> leftideals := LeftIdeals(br);
[ <left ideal in <brace of size 8>, (size 1)>, 
<left ideal in <brace of size 8>, (size 2)>,
<left ideal in <brace of size 8>, (size 4)>, 
<left ideal in <brace of size 8>, (size 8)> ]
gap> List(leftideals, x->IsLeftIdeal(br, x));
[ true, true, true, true ]
gap> List(leftideals, IdBrace);
[ [ 1, 1 ], [ 2, 1 ], [ 4, 1 ], [ 8, 4 ] ]

# doc/_Chapter_Ideals_and_left_ideals.xml:129-136
gap> br := SmallSkewbrace(6,6);;
gap> AsList(br);
[ <()>, <(1,2,3)(4,5,6)>, <(1,3,2)(4,6,5)>, <(1,4)(2,5)(3,6)>, 
  <(1,5,3,4,2,6)>, <(1,6,2,4,3,5)> ]
gap> IdealGeneratedBy(br, [last[2]]);
<ideal in <brace of size 6>, (size 3)>

# doc/_Chapter_Ideals_and_left_ideals.xml:148-153
gap> br := SmallSkewbrace(6,6);;
gap> Ideals(br);;
gap> IntersectionOfTwoIdeals(last[2],last[3]);
<ideal in <brace of size 6>, (size 1)>

# doc/_Chapter_Ideals_and_left_ideals.xml:165-170
gap> br := SmallSkewbrace(6,6);;
gap> Ideals(br);;
gap> SumOfTwoIdeals(last[2],last[3]);
<ideal in <brace of size 6>, (size 6)>

# doc/_Chapter_Ideals_and_left_ideals.xml:191-198
gap> br := SmallSkewbrace(8,20);
<skew brace of size 8>
gap> LeftSeries(br);
[ <skew brace of size 8>, 
<left ideal in <skew brace of size 8>, (size 2)>, 
<left ideal in <skew brace of size 8>, (size 1)> ]

# doc/_Chapter_Ideals_and_left_ideals.xml:212-219
gap> br := SmallSkewbrace(8,20);
<skew brace of size 8>
gap> RightSeries(br);
[ <ideal in <skew brace of size 8>, (size 8)>, 
<ideal in <skew brace of size 8>, (size 2)>, 
<ideal in <skew brace of size 8>, (size 1)> ]

# doc/_Chapter_Ideals_and_left_ideals.xml:233-238
gap> IsLeftNilpotent(SmallBrace(8,18));
true
gap> IsLeftNilpotent(SmallBrace(12,2));
false

# doc/_Chapter_Ideals_and_left_ideals.xml:251-256
gap> IsSimple(SmallSkewbrace(12,22));
true
gap> IsSimple(SmallSkewbrace(12,21));
false

# doc/_Chapter_Ideals_and_left_ideals.xml:270-275
gap> IsRightNilpotent(SmallBrace(8,18));
false
gap> IsRightNilpotent(SmallBrace(12,2));
true

# doc/_Chapter_Ideals_and_left_ideals.xml:301-311
gap> br := SmallBrace(8,18);;
gap> IsLeftNilpotent(br);
true
gap> IsRightNilpotent(br);
false
gap> Length(LeftNilpotentIdeals(br));
3
gap> Length(RightNilpotentIdeals(br));
2

# doc/_Chapter_Ideals_and_left_ideals.xml:327-335
gap> br := SmallBrace(16,145);;
gap> SmoktunowiczSeries(br,4);
[ <brace of size 16>, <brace of size 8>, <brace of size 4>, <brace of size 2>,
  <brace of size 2> ]
gap> SmoktunowiczSeries(br,5);
[ <brace of size 16>, <brace of size 8>, <brace of size 4>, <brace of size 2>,
  <brace of size 2>, <brace of size 1> ]

# doc/_Chapter_Ideals_and_left_ideals.xml:348-355
gap> Socle(SmallSkewbrace(6,2));
<ideal in <skew brace of size 6>, (size 1)>
gap> Socle(SmallBrace(8,20));
<ideal in <brace of size 8>, (size 8)>
gap> Socle(SmallBrace(8,2));
<ideal in <brace of size 8>, (size 4)>

# doc/_Chapter_Ideals_and_left_ideals.xml:368-375
gap> Annihilator(SmallSkewbrace(8,12));
<ideal in <brace of size 8>, (size 2)>
gap> Annihilator(SmallSkewbrace(4,2));
<ideal in <skew brace of size 4>, (size 2)>
gap> Annihilator(SmallSkewbrace(8,14));
<ideal in <brace of size 8>, (size 4)>

# doc/_Chapter_Ideals_and_left_ideals.xml:408-414
gap> br := SmallBrace(8,20);;
gap> SocleSeries(br);
[ <brace of size 8>, <brace of size 1> ]
gap> MultipermutationLevel(br);
2

# doc/_Chapter_Ideals_and_left_ideals.xml:436-443
gap> br := SmallSkewbrace(6,1);;
gap> IsTrivialSkewbrace(br);
true
gap> Fix(br);
[ <()>, <(1,2,3)(4,5,6)>, <(1,3,2)(4,6,5)>, <(1,4)(2,6)(3,5)>,
  <(1,5)(2,4)(3,6)>, <(1,6)(2,5)(3,4)> ]

# doc/_Chapter_Ideals_and_left_ideals.xml:455-459
gap> br := SmallBrace(6,1);;
gap> KernelOfLambda(br);
[ <()>, <(1,2,3)(4,5,6)>, <(1,3,2)(4,6,5)> ]

# doc/_Chapter_Ideals_and_left_ideals.xml:471-478
gap> br := SmallBrace(8,10);;
gap> ideals := Ideals(br);;
gap> Quotient(br, ideals[3]);
<brace of size 4>
gap> br/ideals[3];
<brace of size 4>

# doc/_Chapter_Ideals_and_left_ideals.xml:498-503
gap> IsPrimeBrace(SmallBrace(24,12));
false
gap> IsPrimeBrace(SmallBrace(24,94));
true

# doc/_Chapter_Ideals_and_left_ideals.xml:516-524
gap> br := SmallBrace(24,94);
<brace of size 24>
gap> IsPrimeBrace(br);
true
gap> Ideals(br);;
gap> IsPrimeIdeal(last[2]);
true

# doc/_Chapter_Ideals_and_left_ideals.xml:536-539
gap> Length(PrimeIdeals(SmallBrace(24,94)));
2

# doc/_Chapter_Ideals_and_left_ideals.xml:552-556
gap> br := DirectProductSkewbraces(SmallSkewbrace(12,22),SmallSkewbrace(12,22));;
gap> IsSemiprime(br);
true

# doc/_Chapter_Ideals_and_left_ideals.xml:569-574
gap> SemiprimeIdeals(SmallSkewbrace(12,24));
[ <ideal in <skew brace of size 12>, (size 12)> ]
gap> IsSemiprimeIdeal(last[1]);
true

# doc/_Chapter_Ideals_and_left_ideals.xml:587-592
gap> SemiprimeIdeals(SmallSkewbrace(12,24));
[ <ideal in <skew brace of size 12>, (size 12)> ]
gap> Length(SemiprimeIdeals(SmallSkewbrace(12,22)));
2

# doc/_Chapter_Ideals_and_left_ideals.xml:604-608
gap> br := SmallSkewbrace(6,2);;
gap> BaerRadical(br);
<ideal in <skew brace of size 6>, (size 6)>

# doc/_Chapter_Ideals_and_left_ideals.xml:622-626
gap> br := SmallSkewbrace(6,2);;
gap> IsBaer(br);
true

# doc/_Chapter_Ideals_and_left_ideals.xml:639-643
gap> br := SmallSkewbrace(6,2);;
gap> WedderburnRadical(br);
<ideal in <skew brace of size 6>, (size 3)>

# doc/_Chapter_Ideals_and_left_ideals.xml:657-666
gap> br := SmallSkewbrace(8,20);;
gap> IsSolvable(br);
true
gap> SolvableSeries(br);
[ <skew brace of size 8>, <brace of size 2>, <brace of size 1> ]
gap> br := SmallSkewbrace(12,23);;
gap> IsSolvable(br);
false

#
gap> STOP_TEST("yangbaxter03.tst", 1);
