/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.jta.TransactionManager;
import io.quarkus.narayana.jta.runtime.TransactionScopedNotifier;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import org.jboss.logging.Logger;

public class NotifyingTransactionManager
extends TransactionScopedNotifier
implements jakarta.transaction.TransactionManager,
Serializable {
    private static final long serialVersionUID = 1598L;
    private static final Logger LOG = Logger.getLogger(NotifyingTransactionManager.class);
    private transient TransactionManagerImple delegate = (TransactionManagerImple)TransactionManager.transactionManager();

    NotifyingTransactionManager() {
    }

    public void begin() throws NotSupportedException, SystemException {
        this.delegate.begin();
        this.initialized(this.getTransactionId());
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionScopedNotifier.TransactionId id = this.getTransactionId();
        this.beforeDestroyed(id);
        try {
            this.delegate.commit();
        }
        finally {
            this.destroyed(id);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        TransactionScopedNotifier.TransactionId id = this.getTransactionId();
        try {
            this.beforeDestroyed(id);
        }
        catch (Throwable t) {
            LOG.error((Object)"Failed to fire @BeforeDestroyed(TransactionScoped.class)", t);
        }
        try {
            this.delegate.rollback();
        }
        finally {
            this.destroyed(id);
        }
    }

    public int getStatus() throws SystemException {
        return this.delegate.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.delegate.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.delegate.resume(transaction);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.delegate.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws SystemException {
        return this.delegate.getTimeout();
    }

    public Transaction suspend() throws SystemException {
        return this.delegate.suspend();
    }
}

