/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.history;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.controller.history.AboHistoryController;
import mediathek.controller.history.MVUsedUrl;
import mediathek.gui.history.MVUsedUrlTableFormat;
import mediathek.gui.messages.history.AboHistoryChangedEvent;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class PanelErledigteUrls
extends JPanel {
    private final AboHistoryController workList = Daten.getInstance().getAboHistoryController();
    private final EventList<MVUsedUrl> urlList = new BasicEventList();
    private final AdvancedTableModel<MVUsedUrl> urlTableModel = GlazedListsSwing.eventTableModelWithThreadProxyList(this.urlList, (TableFormat)new MVUsedUrlTableFormat());
    private JLabel jLabelSum;
    protected JTable jTable1;

    public PanelErledigteUrls() {
        this.initComponents();
        this.jTable1.setModel((TableModel)this.urlTableModel);
        this.urlTableModel.addTableModelListener(e -> this.updateRowDisplay());
        this.jTable1.setComponentPopupMenu(this.createContextMenu());
        this.loadData();
        MessageBus.getMessageBus().subscribe((Object)this);
    }

    private JPopupMenu createContextMenu() {
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Eintrag l\u00f6schen");
        item.addActionListener(e -> this.deleteUrl());
        popupMenu.add(item);
        item = new JMenuItem("URL kopieren");
        item.addActionListener(e -> this.copyUrl());
        popupMenu.add(item);
        popupMenu.addPopupMenuListener(new PopupMenuListener(){
            final /* synthetic */ PanelErledigteUrls this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(() -> {
                    Point pt = SwingUtilities.convertPoint(popupMenu, new Point(0, 0), this.this$0.jTable1);
                    int rowAtPoint = this.this$0.jTable1.rowAtPoint(pt);
                    if (rowAtPoint != -1) {
                        this.this$0.jTable1.setRowSelectionInterval(rowAtPoint, rowAtPoint);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        return popupMenu;
    }

    @Handler
    private void handleAboHistoryChangeEvent(AboHistoryChangedEvent e) {
        SwingUtilities.invokeLater(this::loadData);
    }

    private void updateRowDisplay() {
        Object text = "";
        if (this.urlTableModel.getRowCount() > 0) {
            text = "Anzahl: " + this.urlTableModel.getRowCount();
        }
        this.jLabelSum.setText((String)text);
    }

    private void loadData() {
        try {
            this.urlList.getReadWriteLock().writeLock().lock();
            this.urlList.clear();
            this.urlList.addAll(this.workList.getDataList());
        }
        finally {
            this.urlList.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteUrl() {
        int selectedTableRow = this.jTable1.getSelectedRow();
        if (selectedTableRow != -1) {
            try {
                this.urlList.getReadWriteLock().writeLock().lock();
                int modelIndex = this.jTable1.convertRowIndexToModel(selectedTableRow);
                MVUsedUrl obj = (MVUsedUrl)this.urlList.get(modelIndex);
                this.urlList.remove((Object)obj);
                MessageBus.getMessageBus().unsubscribe((Object)this);
                this.workList.removeUrl(obj.getUrl());
                MessageBus.getMessageBus().subscribe((Object)this);
            }
            finally {
                this.urlList.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyUrl() {
        int selectedTableRow = this.jTable1.getSelectedRow();
        if (selectedTableRow != -1) {
            try {
                this.urlList.getReadWriteLock().readLock().lock();
                int modelIndex = this.jTable1.convertRowIndexToModel(selectedTableRow);
                MVUsedUrl obj = (MVUsedUrl)this.urlList.get(modelIndex);
                GuiFunktionen.copyToClipboard(obj.getUrl());
            }
            finally {
                this.urlList.getReadWriteLock().readLock().unlock();
            }
        }
    }

    private void initComponents() {
        this.jLabelSum = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout((LayoutManager)new MigLayout(new LC().insets("5").hideMode(3).gridGap("0", "5"), new AC().grow().fill(), new AC().grow().fill().gap().fill()));
        this.jLabelSum.setHorizontalAlignment(4);
        this.jLabelSum.setText("0");
        this.add((Component)this.jLabelSum, new CC().cell(new int[]{0, 1}).alignX("trailing").growX(0.0f));
        jScrollPane1.setPreferredSize(new Dimension(640, 480));
        jScrollPane1.setMinimumSize(new Dimension(150, 150));
        this.jTable1.setSelectionMode(0);
        jScrollPane1.setViewportView(this.jTable1);
        this.add((Component)jScrollPane1, new CC().cell(new int[]{0, 0}));
    }
}

