/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2OutputVisitor;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2SchemaStatVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleToMySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerSchemaStatVisitor;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class SQLUtils {
    private static final Log LOG = LogFactory.getLog(SQLUtils.class);

    public static String toSQLString(SQLObject sqlObject, String dbType) {
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return SQLUtils.toMySqlString(sqlObject);
        }
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return SQLUtils.toOracleString(sqlObject);
        }
        if ("postgresql".equals(dbType)) {
            return SQLUtils.toPGString(sqlObject);
        }
        if ("db2".equals(dbType)) {
            return SQLUtils.toDB2String(sqlObject);
        }
        if ("odps".equals(dbType)) {
            return SQLUtils.toOdpsString(sqlObject);
        }
        return SQLUtils.toSQLServerString(sqlObject);
    }

    public static String toSQLString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new SQLASTOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static String toOdpsString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new OdpsOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static String toMySqlString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new MySqlOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static SQLExpr toMySqlExpr(String sql) {
        return SQLUtils.toSQLExpr(sql, "mysql");
    }

    public static String formatMySql(String sql) {
        return SQLUtils.format(sql, "mysql");
    }

    public static String formatOracle(String sql) {
        return SQLUtils.format(sql, "oracle");
    }

    public static String formatOdps(String sql) {
        return SQLUtils.format(sql, "odps");
    }

    public static String formatSQLServer(String sql) {
        return SQLUtils.format(sql, "sqlserver");
    }

    public static String toOracleString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new OracleOutputVisitor(out, false));
        String sql = out.toString();
        return sql;
    }

    public static String toPGString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new PGOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static String toDB2String(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new DB2OutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static String toSQLServerString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept(new SQLServerOutputVisitor(out));
        String sql = out.toString();
        return sql;
    }

    public static String formatPGSql(String sql) {
        return SQLUtils.format(sql, "postgresql");
    }

    public static SQLExpr toSQLExpr(String sql, String dbType) {
        SQLExprParser parser = SQLParserUtils.createExprParser(sql, dbType);
        SQLExpr expr = parser.expr();
        if (parser.getLexer().token() != Token.EOF) {
            throw new ParserException("illegal sql expr : " + sql);
        }
        return expr;
    }

    public static SQLSelectOrderByItem toOrderByItem(String sql, String dbType) {
        SQLExprParser parser = SQLParserUtils.createExprParser(sql, dbType);
        SQLSelectOrderByItem orderByItem = parser.parseSelectOrderByItem();
        if (parser.getLexer().token() != Token.EOF) {
            throw new ParserException("illegal sql expr : " + sql);
        }
        return orderByItem;
    }

    public static SQLUpdateSetItem toUpdateSetItem(String sql, String dbType) {
        SQLExprParser parser = SQLParserUtils.createExprParser(sql, dbType);
        SQLUpdateSetItem updateSetItem = parser.parseUpdateSetItem();
        if (parser.getLexer().token() != Token.EOF) {
            throw new ParserException("illegal sql expr : " + sql);
        }
        return updateSetItem;
    }

    public static SQLSelectItem toSelectItem(String sql, String dbType) {
        SQLExprParser parser = SQLParserUtils.createExprParser(sql, dbType);
        SQLSelectItem selectItem = parser.parseSelectItem();
        if (parser.getLexer().token() != Token.EOF) {
            throw new ParserException("illegal sql expr : " + sql);
        }
        return selectItem;
    }

    public static List<SQLStatement> toStatementList(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        return parser.parseStatementList();
    }

    public static SQLExpr toSQLExpr(String sql) {
        return SQLUtils.toSQLExpr(sql, null);
    }

    public static String format(String sql, String dbType) {
        return SQLUtils.format(sql, dbType, null);
    }

    public static String format(String sql, String dbType, List<Object> parameters2) {
        try {
            List<SQLStatement> statementList = SQLUtils.toStatementList(sql, dbType);
            return SQLUtils.toSQLString(statementList, dbType, parameters2);
        }
        catch (ParserException ex) {
            LOG.warn("format error", ex);
            return sql;
        }
    }

    public static String toSQLString(List<SQLStatement> statementList, String dbType) {
        return SQLUtils.toSQLString(statementList, dbType, null);
    }

    public static String toSQLString(List<SQLStatement> statementList, String dbType, List<Object> parameters2) {
        StringBuilder out = new StringBuilder();
        SQLASTOutputVisitor visitor2 = SQLUtils.createFormatOutputVisitor(out, statementList, dbType);
        if (parameters2 != null) {
            visitor2.setParameters(parameters2);
        }
        for (int i = 0; i < statementList.size(); ++i) {
            if (i > 0) {
                out.append(";\n");
            }
            statementList.get(i).accept(visitor2);
        }
        return out.toString();
    }

    public static SQLASTOutputVisitor createFormatOutputVisitor(Appendable out, List<SQLStatement> statementList, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            if (statementList.size() == 1) {
                return new OracleOutputVisitor(out, false);
            }
            return new OracleOutputVisitor(out, true);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlOutputVisitor(out);
        }
        if ("postgresql".equals(dbType)) {
            return new PGOutputVisitor(out);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerOutputVisitor(out);
        }
        if ("db2".equals(dbType)) {
            return new DB2OutputVisitor(out);
        }
        if ("odps".equals(dbType)) {
            return new OdpsOutputVisitor(out);
        }
        return new SQLASTOutputVisitor(out);
    }

    public static SchemaStatVisitor createSchemaStatVisitor(List<SQLStatement> statementList, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            if (statementList.size() == 1) {
                return new OracleSchemaStatVisitor();
            }
            return new OracleSchemaStatVisitor();
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlSchemaStatVisitor();
        }
        if ("postgresql".equals(dbType)) {
            return new PGSchemaStatVisitor();
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerSchemaStatVisitor();
        }
        if ("db2".equals(dbType)) {
            return new DB2SchemaStatVisitor();
        }
        return new SchemaStatVisitor();
    }

    public static List<SQLStatement> parseStatements(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser(sql, dbType);
        List<SQLStatement> stmtList = parser.parseStatementList();
        if (parser.getLexer().token() != Token.EOF) {
            throw new DruidRuntimeException("syntax error : " + sql);
        }
        return stmtList;
    }

    public static String buildToDate(String columnName, String tableAlias, String pattern, String dbType) {
        StringBuilder sql = new StringBuilder();
        if (StringUtils.isEmpty(columnName)) {
            return "";
        }
        if (StringUtils.isEmpty(dbType)) {
            dbType = "mysql";
        }
        String formatMethod = "";
        if ("mysql".equalsIgnoreCase(dbType)) {
            formatMethod = "STR_TO_DATE";
            if (StringUtils.isEmpty(pattern)) {
                pattern = "%Y-%m-%d %H:%i:%s";
            }
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            formatMethod = "TO_DATE";
            if (StringUtils.isEmpty(pattern)) {
                pattern = "yyyy-mm-dd hh24:mi:ss";
            }
        } else {
            return "";
        }
        sql.append(formatMethod).append("(");
        if (!StringUtils.isEmpty(tableAlias)) {
            sql.append(tableAlias).append(".");
        }
        sql.append(columnName).append(",");
        sql.append("'");
        sql.append(pattern);
        sql.append("')");
        return sql.toString();
    }

    public static List<SQLExpr> split(SQLBinaryOpExpr x) {
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        groupList.add(x.getRight());
        SQLExpr left = x.getLeft();
        while (left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == x.getOperator()) {
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            groupList.add(binaryLeft.getRight());
            left = binaryLeft.getLeft();
        }
        groupList.add(left);
        return groupList;
    }

    public static String translateOracleToMySql(String sql) {
        List<SQLStatement> stmtList = SQLUtils.toStatementList(sql, "oracle");
        StringBuilder out = new StringBuilder();
        OracleToMySqlOutputVisitor visitor2 = new OracleToMySqlOutputVisitor(out, false);
        for (int i = 0; i < stmtList.size(); ++i) {
            stmtList.get(i).accept(visitor2);
        }
        String mysqlSql = out.toString();
        return mysqlSql;
    }

    public static String addCondition(String sql, String condition, String dbType) {
        String result2 = SQLUtils.addCondition(sql, condition, SQLBinaryOperator.BooleanAnd, false, dbType);
        return result2;
    }

    public static String addCondition(String sql, String condition, SQLBinaryOperator op, boolean left, String dbType) {
        if (sql == null) {
            throw new IllegalArgumentException("sql is null");
        }
        if (condition == null) {
            return sql;
        }
        if (op == null) {
            op = SQLBinaryOperator.BooleanAnd;
        }
        if (op != SQLBinaryOperator.BooleanAnd && op != SQLBinaryOperator.BooleanOr) {
            throw new IllegalArgumentException("add condition not support : " + (Object)((Object)op));
        }
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() == 0) {
            throw new IllegalArgumentException("not support empty-statement :" + sql);
        }
        if (stmtList.size() > 1) {
            throw new IllegalArgumentException("not support multi-statement :" + sql);
        }
        SQLStatement stmt = stmtList.get(0);
        SQLExpr conditionExpr = SQLUtils.toSQLExpr(condition, dbType);
        SQLUtils.addCondition(stmt, op, conditionExpr, left);
        return SQLUtils.toSQLString(stmt, dbType);
    }

    public static void addCondition(SQLStatement stmt, SQLBinaryOperator op, SQLExpr condition, boolean left) {
        if (stmt instanceof SQLSelectStatement) {
            SQLSelectQuery query = ((SQLSelectStatement)stmt).getSelect().getQuery();
            if (!(query instanceof SQLSelectQueryBlock)) {
                throw new IllegalArgumentException("add condition not support " + stmt.getClass().getName());
            }
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            SQLExpr newCondition = SQLUtils.buildCondition(op, condition, left, queryBlock.getWhere());
            queryBlock.setWhere(newCondition);
            return;
        }
        if (stmt instanceof SQLDeleteStatement) {
            SQLDeleteStatement delete = (SQLDeleteStatement)stmt;
            SQLExpr newCondition = SQLUtils.buildCondition(op, condition, left, delete.getWhere());
            delete.setWhere(newCondition);
            return;
        }
        if (stmt instanceof SQLUpdateStatement) {
            SQLUpdateStatement update = (SQLUpdateStatement)stmt;
            SQLExpr newCondition = SQLUtils.buildCondition(op, condition, left, update.getWhere());
            update.setWhere(newCondition);
            return;
        }
        throw new IllegalArgumentException("add condition not support " + stmt.getClass().getName());
    }

    public static SQLExpr buildCondition(SQLBinaryOperator op, SQLExpr condition, boolean left, SQLExpr where) {
        if (where == null) {
            return condition;
        }
        SQLBinaryOpExpr newCondition = left ? new SQLBinaryOpExpr(condition, op, where) : new SQLBinaryOpExpr(where, op, condition);
        return newCondition;
    }

    public static String addSelectItem(String selectSql, String expr, String alias, String dbType) {
        return SQLUtils.addSelectItem(selectSql, expr, alias, false, dbType);
    }

    public static String addSelectItem(String selectSql, String expr, String alias, boolean first, String dbType) {
        List<SQLStatement> stmtList = SQLUtils.parseStatements(selectSql, dbType);
        if (stmtList.size() == 0) {
            throw new IllegalArgumentException("not support empty-statement :" + selectSql);
        }
        if (stmtList.size() > 1) {
            throw new IllegalArgumentException("not support multi-statement :" + selectSql);
        }
        SQLStatement stmt = stmtList.get(0);
        SQLExpr columnExpr = SQLUtils.toSQLExpr(expr, dbType);
        SQLUtils.addSelectItem(stmt, columnExpr, alias, first);
        return SQLUtils.toSQLString(stmt, dbType);
    }

    public static void addSelectItem(SQLStatement stmt, SQLExpr expr, String alias, boolean first) {
        if (expr == null) {
            return;
        }
        if (stmt instanceof SQLSelectStatement) {
            SQLSelectQuery query = ((SQLSelectStatement)stmt).getSelect().getQuery();
            if (!(query instanceof SQLSelectQueryBlock)) {
                throw new IllegalArgumentException("add condition not support " + stmt.getClass().getName());
            }
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)query;
            SQLUtils.addSelectItem(queryBlock, expr, alias, first);
            return;
        }
        throw new IllegalArgumentException("add selectItem not support " + stmt.getClass().getName());
    }

    public static void addSelectItem(SQLSelectQueryBlock queryBlock, SQLExpr expr, String alias, boolean first) {
        SQLSelectItem selectItem = new SQLSelectItem(expr, alias);
        queryBlock.getSelectList().add(selectItem);
        selectItem.setParent(selectItem);
    }
}

