/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.model.CiphertextHeaders;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CryptoResult<T, K extends MasterKey<K>> {
    private final T result_;
    private final List<K> masterKeys_;
    private final Map<String, String> encryptionContext_;
    private final CiphertextHeaders headers_;

    CryptoResult(T result2, List<K> masterKeys, CiphertextHeaders headers) {
        this.result_ = result2;
        this.masterKeys_ = Collections.unmodifiableList(masterKeys);
        this.headers_ = headers;
        this.encryptionContext_ = this.headers_.getEncryptionContextMap();
    }

    public T getResult() {
        return this.result_;
    }

    public List<K> getMasterKeys() {
        return this.masterKeys_;
    }

    public List<String> getMasterKeyIds() {
        ArrayList<String> result2 = new ArrayList<String>(this.masterKeys_.size());
        for (MasterKey mk : this.masterKeys_) {
            result2.add(mk.getKeyId());
        }
        return result2;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext_;
    }

    public CryptoAlgorithm getCryptoAlgorithm() {
        return this.headers_.getCryptoAlgoId();
    }

    public CiphertextHeaders getHeaders() {
        return this.headers_;
    }
}

