/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.emrserverless.model.transform.CloudWatchLoggingConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudWatchLoggingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enabled;
    private String logGroupName;
    private String logStreamNamePrefix;
    private String encryptionKeyArn;
    private Map<String, List<String>> logTypes;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public CloudWatchLoggingConfiguration withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public CloudWatchLoggingConfiguration withLogGroupName(String logGroupName) {
        this.setLogGroupName(logGroupName);
        return this;
    }

    public void setLogStreamNamePrefix(String logStreamNamePrefix) {
        this.logStreamNamePrefix = logStreamNamePrefix;
    }

    public String getLogStreamNamePrefix() {
        return this.logStreamNamePrefix;
    }

    public CloudWatchLoggingConfiguration withLogStreamNamePrefix(String logStreamNamePrefix) {
        this.setLogStreamNamePrefix(logStreamNamePrefix);
        return this;
    }

    public void setEncryptionKeyArn(String encryptionKeyArn) {
        this.encryptionKeyArn = encryptionKeyArn;
    }

    public String getEncryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public CloudWatchLoggingConfiguration withEncryptionKeyArn(String encryptionKeyArn) {
        this.setEncryptionKeyArn(encryptionKeyArn);
        return this;
    }

    public Map<String, List<String>> getLogTypes() {
        return this.logTypes;
    }

    public void setLogTypes(Map<String, List<String>> logTypes) {
        this.logTypes = logTypes;
    }

    public CloudWatchLoggingConfiguration withLogTypes(Map<String, List<String>> logTypes) {
        this.setLogTypes(logTypes);
        return this;
    }

    public CloudWatchLoggingConfiguration addLogTypesEntry(String key, List<String> value) {
        if (null == this.logTypes) {
            this.logTypes = new HashMap<String, List<String>>();
        }
        if (this.logTypes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.logTypes.put(key, value);
        return this;
    }

    public CloudWatchLoggingConfiguration clearLogTypesEntries() {
        this.logTypes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: ").append(this.getLogGroupName()).append(",");
        }
        if (this.getLogStreamNamePrefix() != null) {
            sb.append("LogStreamNamePrefix: ").append(this.getLogStreamNamePrefix()).append(",");
        }
        if (this.getEncryptionKeyArn() != null) {
            sb.append("EncryptionKeyArn: ").append(this.getEncryptionKeyArn()).append(",");
        }
        if (this.getLogTypes() != null) {
            sb.append("LogTypes: ").append(this.getLogTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingConfiguration)) {
            return false;
        }
        CloudWatchLoggingConfiguration other = (CloudWatchLoggingConfiguration)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getLogStreamNamePrefix() == null ^ this.getLogStreamNamePrefix() == null) {
            return false;
        }
        if (other.getLogStreamNamePrefix() != null && !other.getLogStreamNamePrefix().equals(this.getLogStreamNamePrefix())) {
            return false;
        }
        if (other.getEncryptionKeyArn() == null ^ this.getEncryptionKeyArn() == null) {
            return false;
        }
        if (other.getEncryptionKeyArn() != null && !other.getEncryptionKeyArn().equals(this.getEncryptionKeyArn())) {
            return false;
        }
        if (other.getLogTypes() == null ^ this.getLogTypes() == null) {
            return false;
        }
        return other.getLogTypes() == null || other.getLogTypes().equals(this.getLogTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getLogStreamNamePrefix() == null ? 0 : this.getLogStreamNamePrefix().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getEncryptionKeyArn() == null ? 0 : this.getEncryptionKeyArn().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getLogTypes() == null ? 0 : this.getLogTypes().hashCode());
        return hashCode2;
    }

    public CloudWatchLoggingConfiguration clone() {
        try {
            return (CloudWatchLoggingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLoggingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

