/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.matching;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.DefaultMatcher;
import com.facebook.presto.matching.DefaultPrinter;
import com.facebook.presto.matching.Match;
import com.facebook.presto.matching.Matcher;
import com.facebook.presto.matching.PatternVisitor;
import com.facebook.presto.matching.Property;
import com.facebook.presto.matching.PropertyPattern;
import com.facebook.presto.matching.pattern.CapturePattern;
import com.facebook.presto.matching.pattern.FilterPattern;
import com.facebook.presto.matching.pattern.TypeOfPattern;
import com.facebook.presto.matching.pattern.WithPattern;
import java.util.function.Predicate;
import shaded.com.google.common.base.Predicates;
import shaded.com.google.common.collect.Iterables;

public abstract class Pattern<T> {
    private final Pattern<?> previous;

    public static Pattern<Object> any() {
        return Pattern.typeOf(Object.class);
    }

    public static <T> Pattern<T> typeOf(Class<T> expectedClass) {
        return new TypeOfPattern<T>(expectedClass);
    }

    protected Pattern() {
        this(null);
    }

    protected Pattern(Pattern<?> previous) {
        this.previous = previous;
    }

    public static <F, T extends Iterable<S>, S> PropertyPattern<F, T> empty(Property<F, T> property) {
        return PropertyPattern.upcast(property.matching(Iterables::isEmpty));
    }

    public static <F, T extends Iterable<S>, S> PropertyPattern<F, T> nonEmpty(Property<F, T> property) {
        return PropertyPattern.upcast(property.matching(Predicates.not(Iterables::isEmpty)));
    }

    public Pattern<T> capturedAs(Capture<T> capture) {
        return new CapturePattern<T>(capture, this);
    }

    public Pattern<T> matching(Predicate<? super T> predicate) {
        return new FilterPattern<T>(predicate, this);
    }

    public Pattern<T> with(PropertyPattern<? super T, ?> pattern) {
        return new WithPattern<T>(pattern, this);
    }

    public Pattern<?> previous() {
        return this.previous;
    }

    public abstract Match<T> accept(Matcher var1, Object var2, Captures var3);

    public abstract void accept(PatternVisitor var1);

    public boolean matches(Object object) {
        return DefaultMatcher.DEFAULT_MATCHER.match(this, object).isPresent();
    }

    public String toString() {
        DefaultPrinter printer = new DefaultPrinter();
        this.accept(printer);
        return printer.result();
    }
}

