/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.ranges.Range;
import com.google.uzaygezen.core.ranges.RangeHome;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import shaded.com.google.common.base.Function;
import shaded.com.google.common.base.Objects;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;

public class RangeListFilter<T extends Comparable<T>, V extends Content<V>, R extends Range<T, V>> {
    private static final Logger logger = Logger.getLogger(RangeListFilter.class.getName());
    private final List<R> rangeList;
    private final boolean thresholdExceeded;
    private final Level thresholdExceededLogLevel;
    private final RangeHome<T, V, R> rangeHome;

    public static <T extends Comparable<T>, V extends Content<V>, R extends Range<T, V>> Function<R, RangeListFilter<T, V, R>> creator(final Level thresholdExceededLogLevel, final RangeHome<T, V, R> rangeHome) {
        return new Function<R, RangeListFilter<T, V, R>>(){

            @Override
            public RangeListFilter<T, V, R> apply(R from) {
                return new RangeListFilter(ImmutableList.of(from), false, thresholdExceededLogLevel, rangeHome);
            }
        };
    }

    public RangeListFilter(List<R> rangeList, boolean thresholdExceeded, Level thresholdExceededLogLevel, RangeHome<T, V, R> rangeHome) {
        Preconditions.checkArgument(!rangeList.isEmpty(), "rangeList must not be empty");
        Preconditions.checkArgument(!thresholdExceeded || rangeList.size() == 1, "A list which has exceede the threshold will always have exactly one element");
        this.rangeList = rangeList;
        this.thresholdExceeded = thresholdExceeded;
        this.thresholdExceededLogLevel = Preconditions.checkNotNull(thresholdExceededLogLevel, "thresholdExceededLogLevel");
        this.rangeHome = rangeHome;
    }

    public RangeListFilter<T, V, R> combine(RangeListFilter<T, V, R> higher, int threshold, V gapEstimate) {
        Preconditions.checkArgument(this.rangeList.size() <= threshold);
        Preconditions.checkArgument(higher.rangeList.size() <= threshold);
        int cmp = ((Comparable)((Range)this.rangeList.get(this.rangeList.size() - 1)).getEnd()).compareTo(((Range)higher.rangeList.get(0)).getStart());
        int gapSignum = gapEstimate.isZero() ? 0 : 1;
        Preconditions.checkArgument(cmp < 0 & gapSignum >= 0 || cmp == 0 & gapSignum == 0);
        int concatenatedListSize = this.rangeList.size() + higher.rangeList.size() + gapSignum - 1;
        if (this.thresholdExceeded || higher.thresholdExceeded || concatenatedListSize > threshold) {
            if (concatenatedListSize > threshold & !this.thresholdExceeded & !higher.thresholdExceeded) {
                logger.log(this.thresholdExceededLogLevel, "Exceeded threshold {0} with input sizes {1} and {2} and gapEstimate={3}.", new Object[]{threshold, this.rangeList.size(), higher.rangeList.size(), gapEstimate});
            }
            return new RangeListFilter<T, V, R>(ImmutableList.of(this.rangeHome.of(((Range)this.rangeList.get(0)).getStart(), ((Range)higher.rangeList.get(higher.rangeList.size() - 1)).getEnd())), true, this.thresholdExceededLogLevel, this.rangeHome);
        }
        ArrayList<R> list = new ArrayList<R>(concatenatedListSize);
        if (gapSignum == 0) {
            list.addAll(this.rangeList);
            list.addAll(list.size() - 1, higher.rangeList);
            Range lastLowerFilter = (Range)list.remove(list.size() - 1);
            assert (this.rangeList.get(this.rangeList.size() - 1) == lastLowerFilter);
            list.set(this.rangeList.size() - 1, this.rangeHome.of(lastLowerFilter.getStart(), ((Range)higher.rangeList.get(0)).getEnd()));
        } else {
            list.addAll(this.rangeList);
            list.addAll(higher.rangeList);
        }
        return new RangeListFilter(Collections.unmodifiableList(list), false, this.thresholdExceededLogLevel, this.rangeHome);
    }

    public int hashCode() {
        return Objects.hashCode(this.rangeList, this.thresholdExceeded);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RangeListFilter)) {
            return false;
        }
        RangeListFilter other = (RangeListFilter)o;
        return this.rangeList.equals(other.rangeList) && this.thresholdExceeded == other.thresholdExceeded;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public List<R> getRangeList() {
        return this.rangeList;
    }

    public R getRange() {
        return (R)((Range)this.rangeHome.of(((Range)this.rangeList.get(0)).getStart(), ((Range)this.rangeList.get(this.rangeList.size() - 1)).getEnd()));
    }

    public boolean isThresholdExceeded() {
        return this.thresholdExceeded;
    }
}

