/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.InMemoryRegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class InMemoryRetryRegistry
extends AbstractRegistry<Retry, RetryConfig>
implements RetryRegistry {
    public InMemoryRetryRegistry() {
        this(RetryConfig.ofDefaults());
    }

    public InMemoryRetryRegistry(io.vavr.collection.Map<String, String> tags) {
        this(RetryConfig.ofDefaults(), tags);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs) {
        this(configs, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, RegistryEventConsumer<Retry> registryEventConsumer) {
        this(configs, registryEventConsumer, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, RegistryEventConsumer<Retry> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        this(configs, registryEventConsumers, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()), registryEventConsumers, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers, io.vavr.collection.Map<String, String> tags, RegistryStore<Retry> registryStore) {
        super(configs.getOrDefault("default", RetryConfig.ofDefaults()), registryEventConsumers, Optional.ofNullable(tags).orElse(HashMap.empty()), Optional.ofNullable(registryStore).orElse(new InMemoryRegistryStore()));
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig) {
        this(defaultConfig, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, tags);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, RegistryEventConsumer<Retry> registryEventConsumer) {
        this(defaultConfig, registryEventConsumer, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, RegistryEventConsumer<Retry> registryEventConsumer, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        this(defaultConfig, registryEventConsumers, (io.vavr.collection.Map<String, String>)HashMap.empty());
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, List<RegistryEventConsumer<Retry>> registryEventConsumers, io.vavr.collection.Map<String, String> tags) {
        super(defaultConfig, registryEventConsumers, tags);
    }

    @Override
    public Seq<Retry> getAllRetries() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public Retry retry(String name) {
        return this.retry(name, (RetryConfig)this.getDefaultConfig());
    }

    @Override
    public Retry retry(String name, io.vavr.collection.Map<String, String> tags) {
        return this.retry(name, (RetryConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public Retry retry(String name, RetryConfig config) {
        return this.retry(name, config, HashMap.empty());
    }

    @Override
    public Retry retry(String name, RetryConfig config, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> Retry.of(name, Objects.requireNonNull(config, "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public Retry retry(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return this.retry(name, retryConfigSupplier, HashMap.empty());
    }

    @Override
    public Retry retry(String name, Supplier<RetryConfig> retryConfigSupplier, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> Retry.of(name, (RetryConfig)Objects.requireNonNull(Objects.requireNonNull(retryConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public Retry retry(String name, String configName) {
        return this.retry(name, configName, HashMap.empty());
    }

    @Override
    public Retry retry(String name, String configName, io.vavr.collection.Map<String, String> tags) {
        return this.computeIfAbsent(name, () -> Retry.of(name, (RetryConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName)), this.getAllTags(tags)));
    }
}

