/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableSortedAggregate;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.util.ImmutableIntList;
import org.checkerframework.checker.nullness.qual.Nullable;

class EnumerableSortedAggregateRule
extends ConverterRule {
    public static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableSortedAggregateRule").withRuleFactory(EnumerableSortedAggregateRule::new);

    protected EnumerableSortedAggregateRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public @Nullable RelNode convert(RelNode rel) {
        Aggregate agg = (Aggregate)rel;
        if (!Aggregate.isSimple(agg)) {
            return null;
        }
        RelTraitSet inputTraits = rel.getCluster().traitSet().replace(EnumerableConvention.INSTANCE).replace(RelCollations.of(ImmutableIntList.copyOf(agg.getGroupSet().asList())));
        RelTraitSet selfTraits = inputTraits.replace(RelCollations.of(ImmutableIntList.identity(agg.getGroupSet().cardinality())));
        return new EnumerableSortedAggregate(rel.getCluster(), selfTraits, EnumerableSortedAggregateRule.convert(agg.getInput(), inputTraits), agg.getGroupSet(), agg.getGroupSets(), agg.getAggCallList());
    }
}

