/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.core.TableSpool;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.schema.ModifiableTable;
import org.apache.calcite.util.BuiltInMethod;

public class EnumerableTableSpool
extends TableSpool
implements EnumerableRel {
    private EnumerableTableSpool(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, Spool.Type readType, Spool.Type writeType, RelOptTable table) {
        super(cluster, traitSet, input, readType, writeType, table);
    }

    public static EnumerableTableSpool create(RelNode input, Spool.Type readType, Spool.Type writeType, RelOptTable table) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> mq.collations(input)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> mq.distribution(input));
        return new EnumerableTableSpool(cluster, traitSet, input, readType, writeType, table);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        if (this.readType != Spool.Type.LAZY || this.writeType != Spool.Type.LAZY) {
            throw new UnsupportedOperationException("EnumerableTableSpool supports for the moment only LAZY read and LAZY write");
        }
        BlockBuilder builder = new BlockBuilder();
        RelNode input = this.getInput();
        EnumerableRel.Result inputResult = implementor.visitChild(this, 0, (EnumerableRel)input, pref);
        String tableName = this.table.getQualifiedName().get(this.table.getQualifiedName().size() - 1);
        UnaryExpression tableExp = Expressions.convert_(Expressions.call((Expression)Expressions.call((Expression)implementor.getRootExpression(), BuiltInMethod.DATA_CONTEXT_GET_ROOT_SCHEMA.method, new Expression[0]), BuiltInMethod.SCHEMA_GET_TABLE.method, Expressions.constant(tableName, String.class)), ModifiableTable.class);
        MethodCallExpression collectionExp = Expressions.call((Expression)tableExp, BuiltInMethod.MODIFIABLE_TABLE_GET_MODIFIABLE_COLLECTION.method, new Expression[0]);
        Expression inputExp = builder.append("input", inputResult.block);
        MethodCallExpression spoolExp = Expressions.call(BuiltInMethod.LAZY_COLLECTION_SPOOL.method, collectionExp, inputExp);
        builder.add(spoolExp);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(inputResult.format));
        return implementor.result(physType, builder.toBlock());
    }

    @Override
    protected Spool copy(RelTraitSet traitSet, RelNode input, Spool.Type readType, Spool.Type writeType) {
        return new EnumerableTableSpool(input.getCluster(), traitSet, input, readType, writeType, this.table);
    }
}

