/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j;

import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;

class ModularInteger {
    private final int value;
    private final int modulus;

    ModularInteger(int value, int modulus) {
        Preconditions.checkArgument(value >= 0 && value < modulus);
        this.value = value;
        this.modulus = modulus;
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof ModularInteger && this.value == ((ModularInteger)obj).value && this.modulus == ((ModularInteger)obj).modulus;
    }

    public int hashCode() {
        return this.value + 8191 * this.modulus;
    }

    public int get() {
        return this.value;
    }

    public ModularInteger plus(int operand) {
        if (operand < 0) {
            return this.minus(Math.abs(operand));
        }
        return new ModularInteger((this.value + operand) % this.modulus, this.modulus);
    }

    public ModularInteger minus(int operand) {
        int r;
        assert (operand >= 0);
        for (r = this.value - operand; r < 0; r += this.modulus) {
        }
        return new ModularInteger(r, this.modulus);
    }

    public String toString() {
        return this.value + " mod " + this.modulus;
    }
}

