/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.rules.ImmutableUnionToValuesRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.immutables.value.Value;
import shaded.com.google.common.collect.ImmutableCollection;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableSet;

@Value.Enclosing
public class UnionToValuesRule
extends RelRule<Config>
implements TransformationRule {
    protected UnionToValuesRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Union union = (Union)call.rel(0);
        List<RelNode> relNodeList = union.getInputs();
        RelDataType relDataType = union.getRowType();
        if (!relNodeList.stream().allMatch(relNode -> UnionToValuesRule.isValuesWithSpecifiedDataType(relNode, relDataType))) {
            return;
        }
        ImmutableCollection.Builder<ImmutableList<RexLiteral>> tupleList = UnionToValuesRule.getImmutableListBuilder(union.all, relNodeList);
        Values values2 = (Values)call.builder().values(tupleList.build(), union.getRowType()).build();
        call.transformTo(values2);
    }

    private static ImmutableCollection.Builder<ImmutableList<RexLiteral>> getImmutableListBuilder(Boolean all, List<RelNode> relNodeList) {
        ImmutableCollection.Builder tupleList = all != false ? ImmutableList.builder() : ImmutableSet.builder();
        for (RelNode relNode : relNodeList) {
            Values values2 = (Values)relNode.stripped();
            ImmutableList<ImmutableList<RexLiteral>> immutableLists = values2.getTuples();
            for (ImmutableList immutableList : immutableLists) {
                ImmutableList.Builder tuple = ImmutableList.builder();
                for (RexLiteral rexLiteral : immutableList) {
                    tuple.add(rexLiteral);
                }
                ((ImmutableCollection.Builder)tupleList).add((ImmutableList<RexLiteral>)tuple.build());
            }
        }
        return tupleList;
    }

    private static boolean isValuesWithSpecifiedDataType(RelNode node, RelDataType relDataType) {
        if (node instanceof Values && relDataType.equalsSansFieldNamesAndNullability(node.getRowType())) {
            return true;
        }
        if (node instanceof HepRelVertex || node instanceof RelSubset) {
            return UnionToValuesRule.isValuesWithSpecifiedDataType(node.stripped(), relDataType);
        }
        return false;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableUnionToValuesRule.Config.of().withDescription("UnionToValuesRule").withOperandFor(Union.class);

        @Override
        default public UnionToValuesRule toRule() {
            return new UnionToValuesRule(this);
        }

        default public Config withOperandFor(Class<? extends Union> unionClass) {
            return this.withOperandSupplier(b0 -> b0.operand(unionClass).anyInputs()).as(Config.class);
        }
    }
}

