/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;

public class SqlFilterOperator
extends SqlBinaryOperator {
    public SqlFilterOperator() {
        super("FILTER", SqlKind.FILTER, 20, true, ReturnTypes.ARG0_FORCE_NULLABLE, null, (SqlOperandTypeChecker)OperandTypes.ANY_ANY);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == 2);
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, this.getLeftPrec());
        writer.sep(this.getName());
        writer.sep("(");
        writer.sep("WHERE");
        ((SqlNode)call.operand(1)).unparse(writer, this.getRightPrec(), rightPrec);
        writer.sep(")");
        writer.endList(frame);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope2, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        assert (call.operandCount() == 2);
        SqlValidatorUtil.FlatAggregate flat = SqlValidatorUtil.flatten(call);
        SqlCall aggCall = flat.aggregateCall;
        if (!aggCall.getOperator().isAggregator()) {
            throw validator.newValidationError(aggCall, Static.RESOURCE.filterNonAggregate());
        }
        validator.validateAggregateParams(aggCall, flat.filter, flat.distinctList, flat.orderList, scope2);
        SqlNode filter = Objects.requireNonNull(flat.filter);
        RelDataType type2 = validator.deriveType(scope2, filter);
        if (!SqlTypeUtil.inBooleanFamily(type2)) {
            throw validator.newValidationError(filter, Static.RESOURCE.condMustBeBoolean("FILTER"));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope2, SqlCall call) {
        this.validateOperands(validator, scope2, call);
        SqlValidatorUtil.FlatAggregate flat = SqlValidatorUtil.flatten(call);
        SqlCall aggCall = flat.aggregateCall;
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope2, aggCall){

            @Override
            public int getGroupCount() {
                return 0;
            }
        };
        RelDataType ret = aggCall.getOperator().inferReturnType(opBinding);
        SqlValidatorImpl validator1 = (SqlValidatorImpl)validator;
        validator1.setValidatedNodeType(call, ret);
        validator1.setValidatedNodeType(aggCall, ret);
        if (flat.distinctList != null) {
            validator1.setValidatedNodeType(Objects.requireNonNull(flat.distinctCall), ret);
        }
        if (flat.orderList != null) {
            validator1.setValidatedNodeType(Objects.requireNonNull(flat.orderCall), ret);
        }
        return ret;
    }
}

