/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Objects;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.TimeWithTimeZoneString;
import shaded.com.google.common.base.Preconditions;

public class SqlTimeTzLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimeTzLiteral(TimeWithTimeZoneString t2, int precision, SqlParserPos pos) {
        super(t2, true, SqlTypeName.TIME_TZ, precision, pos);
        Preconditions.checkArgument(this.precision >= 0);
    }

    protected TimeWithTimeZoneString getTime() {
        return (TimeWithTimeZoneString)Objects.requireNonNull(this.value, "value");
    }

    @Override
    public SqlTimeTzLiteral clone(SqlParserPos pos) {
        return new SqlTimeTzLiteral(this.getTime(), this.precision, pos);
    }

    @Override
    public String toString() {
        return "TIME WITH TIME ZONE '" + this.toFormattedString() + "'";
    }

    @Override
    public String toFormattedString() {
        return this.getTime().toString(this.precision);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.getDialect().unparseDateTimeLiteral(writer, this, leftPrec, rightPrec);
    }
}

