/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.CyclicDefinitionException;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public class IdentifierNamespace
extends AbstractNamespace {
    private final SqlIdentifier id;
    private final SqlValidatorScope parentScope;
    public final @Nullable SqlNodeList extendList;
    private @MonotonicNonNull SqlValidatorNamespace resolvedNamespace;
    private @Nullable List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs;

    IdentifierNamespace(SqlValidatorImpl validator, SqlIdentifier id, @Nullable SqlNodeList extendList, @Nullable SqlNode enclosingNode, SqlValidatorScope parentScope) {
        super(validator, enclosingNode);
        this.id = id;
        this.extendList = extendList;
        this.parentScope = Objects.requireNonNull(parentScope, "parentScope");
    }

    IdentifierNamespace(SqlValidatorImpl validator, SqlNode node, @Nullable SqlNode enclosingNode, SqlValidatorScope parentScope) {
        this(validator, (SqlIdentifier)IdentifierNamespace.split((SqlNode)node).left, (SqlNodeList)IdentifierNamespace.split((SqlNode)node).right, enclosingNode, parentScope);
    }

    protected static Pair<SqlIdentifier, @Nullable SqlNodeList> split(SqlNode node) {
        switch (node.getKind()) {
            case EXTEND: {
                SqlCall call = (SqlCall)node;
                Object operand0 = call.operand(0);
                SqlIdentifier identifier = ((SqlNode)operand0).getKind() == SqlKind.TABLE_REF ? (SqlIdentifier)((SqlCall)operand0).operand(0) : (SqlIdentifier)operand0;
                return Pair.of(identifier, call.operand(1));
            }
            case TABLE_REF: {
                SqlCall tableRef = (SqlCall)node;
                return Pair.of(tableRef.operand(0), null);
            }
        }
        return Pair.of((SqlIdentifier)node, null);
    }

    private SqlValidatorNamespace resolveImpl(SqlIdentifier id) {
        SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        List<String> names = SqlIdentifier.toStar(id.names);
        try {
            this.parentScope.resolveTable(names, nameMatcher, SqlValidatorScope.Path.EMPTY, resolved);
        }
        catch (CyclicDefinitionException e) {
            if (e.depth == 1) {
                throw this.validator.newValidationError(id, Static.RESOURCE.cyclicDefinition(id.toString(), SqlIdentifier.getString(e.path)));
            }
            throw new CyclicDefinitionException(e.depth - 1, e.path);
        }
        SqlValidatorScope.Resolve previousResolve = null;
        if (resolved.count() == 1) {
            SqlValidatorScope.Resolve resolve2 = previousResolve = resolved.only();
            if (resolve2.remainingNames.isEmpty()) {
                return resolve2.namespace;
            }
            if (!nameMatcher.isCaseSensitive()) {
                throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFoundWithin(resolve2.remainingNames.get(0), SqlIdentifier.getString(resolve2.path.stepNames())));
            }
        }
        if (nameMatcher.isCaseSensitive()) {
            SqlNameMatcher liberalMatcher = SqlNameMatchers.liberal();
            resolved.clear();
            this.parentScope.resolveTable(names, liberalMatcher, SqlValidatorScope.Path.EMPTY, resolved);
            if (resolved.count() == 1) {
                SqlValidatorScope.Resolve resolve3 = resolved.only();
                if (resolve3.remainingNames.isEmpty() || previousResolve == null) {
                    int i = previousResolve == null ? 0 : previousResolve.path.stepCount();
                    int offset = resolve3.path.stepCount() + resolve3.remainingNames.size() - names.size();
                    List<String> prefix = resolve3.path.stepNames().subList(0, offset + i);
                    String next = resolve3.path.stepNames().get(i + offset);
                    if (prefix.isEmpty()) {
                        throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFoundDidYouMean(names.get(i), next));
                    }
                    throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFoundWithinDidYouMean(names.get(i), SqlIdentifier.getString(prefix), next));
                }
                throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFoundWithin(resolve3.remainingNames.get(0), SqlIdentifier.getString(resolve3.path.stepNames())));
            }
        }
        throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFound(id.getComponent(0).toString()));
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        SqlValidatorTable table;
        this.resolvedNamespace = this.resolveImpl(this.id);
        this.validator.validateNamespace(this.resolvedNamespace, targetRowType);
        if (this.validator.config().identifierExpansion() && (table = this.resolvedNamespace.getTable()) != null) {
            List<String> qualifiedNames = table.getQualifiedName();
            ImmutableList.Builder positions = ImmutableList.builder();
            int offset = qualifiedNames.size() - this.id.names.size();
            for (int i = 0; i < qualifiedNames.size(); ++i) {
                positions.add(offset >= 0 && i >= offset ? this.id.getComponentParserPosition(i - offset) : this.id.getParserPosition());
            }
            this.id.setNames(qualifiedNames, (List<SqlParserPos>)((Object)positions.build()));
        }
        this.mustFilterFields = this.resolvedNamespace.getMustFilterFields();
        RelDataType rowType = this.resolvedNamespace.getRowType();
        if (this.extendList != null) {
            if (!(this.resolvedNamespace instanceof TableNamespace)) {
                throw new RuntimeException("cannot convert");
            }
            this.resolvedNamespace = ((TableNamespace)this.resolvedNamespace).extend(this.extendList);
            rowType = this.resolvedNamespace.getRowType();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RelDataTypeField> fields2 = rowType.getFieldList();
        for (RelDataTypeField field : fields2) {
            String fieldName = field.getName();
            SqlMonotonicity monotonicity = this.resolvedNamespace.getMonotonicity(fieldName);
            if (monotonicity == null || monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
            builder.add(Pair.of(new SqlIdentifier(fieldName, SqlParserPos.ZERO), monotonicity));
        }
        this.monotonicExprs = builder.build();
        return rowType;
    }

    public SqlIdentifier getId() {
        return this.id;
    }

    @Override
    public @Nullable SqlNode getNode() {
        return this.id;
    }

    @Override
    public SqlValidatorNamespace resolve() {
        if (this.resolvedNamespace == null) {
            throw new IllegalStateException("must call validate first");
        }
        return this.resolvedNamespace.resolve();
    }

    @Override
    public @Nullable SqlValidatorTable getTable() {
        return this.resolvedNamespace == null ? null : this.resolve().getTable();
    }

    @Override
    public List<Pair<SqlNode, SqlMonotonicity>> getMonotonicExprs() {
        List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs = this.monotonicExprs;
        return monotonicExprs == null ? ImmutableList.of() : monotonicExprs;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        SqlValidatorTable table = this.getTable();
        if (table == null) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return table.getMonotonicity(columnName);
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        SqlValidatorTable table = this.getTable();
        if (table == null) {
            return modality == SqlModality.RELATION;
        }
        return table.supportsModality(modality);
    }
}

