/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.TryThreadLocal;
import org.apache.calcite.util.format.FormatElement;
import org.apache.commons.lang3.StringUtils;

public enum FormatElementEnum implements FormatElement
{
    CC("cc", "century (2 digits) (the twenty-first century starts on 2001-01-01)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%2d", calendar.get(1) / 100 + 1));
        }
    }
    ,
    D("", "The weekday (Sunday as the first day of the week) as a decimal number (1-7)"){

        @Override
        public void toPattern(StringBuilder sb) throws UnsupportedOperationException {
            this.throwToPatternNotImplemented();
        }

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(7)));
        }
    }
    ,
    DAY("EEEE", "The full weekday name, in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.FULL).toUpperCase(Locale.ROOT));
        }
    }
    ,
    Day("EEEE", "The full weekday name, capitalized"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.FULL));
        }
    }
    ,
    day("EEEE", "The full weekday name, in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.FULL).toLowerCase(Locale.ROOT));
        }
    }
    ,
    DD("dd", "The day of the month as a decimal number (01-31)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(5)));
        }
    }
    ,
    DDD("D", "The day of the year as a decimal number (001-366)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%03d", calendar.get(6)));
        }
    }
    ,
    DY("EEE", "The abbreviated weekday name, in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.SHORT).toUpperCase(Locale.ROOT));
        }
    }
    ,
    Dy("EEE", "The abbreviated weekday name, capitalized"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.SHORT));
        }
    }
    ,
    dy("EEE", "The abbreviated weekday name, in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.SHORT).toLowerCase(Locale.ROOT));
        }
    }
    ,
    E("d", "The day of the month as a decimal number (1-31); single digits are left-padded with space."){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%2d", calendar.get(5)));
        }
    }
    ,
    FF1("S", "Fractional seconds to 1 digit"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sssFormat.format(date).charAt(0));
        }
    }
    ,
    FF2("S", "Fractional seconds to 2 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sssFormat.format(date), 0, 2);
        }
    }
    ,
    FF3("S", "Fractional seconds to 3 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sssFormat.format(date));
        }
    }
    ,
    FF4("S", "Fractional seconds to 4 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad(work.sssFormat.format(date), 4, "0"));
        }
    }
    ,
    FF5("S", "Fractional seconds to 5 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad(work.sssFormat.format(date), 5, "0"));
        }
    }
    ,
    FF6("S", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad(work.sssFormat.format(date), 6, "0"));
        }
    }
    ,
    FF7("S", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad(work.sssFormat.format(date), 7, "0"));
        }
    }
    ,
    FF8("S", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad(work.sssFormat.format(date), 8, "0"));
        }
    }
    ,
    FF9("S", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad(work.sssFormat.format(date), 9, "0"));
        }
    }
    ,
    HH12("h", "The hour (12-hour clock) as a decimal number (01-12)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            int hour = calendar.get(10);
            sb.append(String.format(Locale.ROOT, "%02d", hour == 0 ? 12 : hour));
        }
    }
    ,
    HH24("H", "The hour (24-hour clock) as a decimal number (00-23)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(11)));
        }
    }
    ,
    ID("u", "The weekday (Monday as the first day of the week) as a decimal number (1-7)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            int weekDay = calendar.get(7);
            sb.append(weekDay == 1 ? 7 : weekDay - 1);
        }
    }
    ,
    IW("", "The ISO 8601 week number of the year (Monday as the first day of the week) as a decimal number (01-53). If the week containing January 1 has four or more days in the new year, then it is week 1; otherwise it is week 53 of the previous year, and the next week is week 1."){

        @Override
        public void toPattern(StringBuilder sb) throws UnsupportedOperationException {
            this.throwToPatternNotImplemented();
        }

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().iso8601Calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(3)));
        }
    }
    ,
    IYY("YY", "The ISO 8601 year without century as a decimal number. Each ISO year begins on the Monday before the first Thursday of the Gregorian calendar year."){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().iso8601Calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.getWeekYear() % 100));
        }
    }
    ,
    IYYYY("YYYY", "The ISO 8601 year with century as a decimal number. Each ISO year begins on the Monday before the first Thursday of the Gregorian calendar year."){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().iso8601Calendar;
            calendar.setTime(date);
            sb.append(calendar.getWeekYear());
        }
    }
    ,
    MI("m", "The minute as a decimal number (00-59)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(12)));
        }
    }
    ,
    MM("MM", "The month as a decimal number (01-12)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(2) + 1));
        }
    }
    ,
    MON("MMM", "The abbreviated month name, in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmFormat.format(date).toUpperCase(Locale.ROOT));
        }
    }
    ,
    Mon("MMM", "The abbreviated month name, capitalized"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmFormat.format(date));
        }
    }
    ,
    mon("MMM", "The abbreviated month name, in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmFormat.format(date).toLowerCase(Locale.ROOT));
        }
    }
    ,
    MONTH("MMMM", "The full month name (English), in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmmFormat.format(date).toUpperCase(Locale.ROOT));
        }
    }
    ,
    Month("MMMM", "The full month name (English), capitalized"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmmFormat.format(date));
        }
    }
    ,
    month("MMMM", "The full month name (English), in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmmFormat.format(date).toLowerCase(Locale.ROOT));
        }
    }
    ,
    PM("a", "Meridian indicator without periods"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            String meridian = calendar.get(11) < 12 ? "AM" : "PM";
            sb.append(meridian);
        }
    }
    ,
    Q("", "The quarter as a decimal number (1-4)"){

        @Override
        public void toPattern(StringBuilder sb) throws UnsupportedOperationException {
            this.throwToPatternNotImplemented();
        }

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(2) / 3 + 1));
        }
    }
    ,
    AMPM("", "The time as Meridian Indicator in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(calendar.get(9) == 0 ? "AM" : "PM");
        }
    }
    ,
    AM_PM("", "The time as Meridian Indicator in uppercase with dot"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(calendar.get(9) == 0 ? "A.M." : "P.M.");
        }
    }
    ,
    ampm("", "The time as Meridian Indicator in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(calendar.get(9) == 0 ? "am" : "pm");
        }
    }
    ,
    am_pm("", "The time as Meridian Indicator in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(calendar.get(9) == 0 ? "a.m." : "p.m.");
        }
    }
    ,
    MS("SSS", "The millisecond as a decimal number (000-999)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%03d", calendar.get(14)));
        }
    }
    ,
    SS("s", "The second as a decimal number (00-60)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(13)));
        }
    }
    ,
    SSSSS("s", "The seconds of the day (00000-86400)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            long timeInMillis = calendar.getTimeInMillis();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            long dayStartInMillis = calendar.getTimeInMillis();
            long secondsPassed = (timeInMillis - dayStartInMillis) / 1000L;
            sb.append(String.format(Locale.ROOT, "%05d", secondsPassed));
        }
    }
    ,
    TZR("z", "The time zone name"){

        @Override
        public void format(StringBuilder sb, Date date) {
        }
    }
    ,
    W("W", "The week number of the month (Sunday as the first day of the week) as a decimal number (1-5)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(4)));
        }
    }
    ,
    WW("w", "The week number of the year (Sunday as the first day of the week) as a decimal number (00-53)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(3)));
        }
    }
    ,
    Y("y", "Last digit of year"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            String formattedYear = work.yyFormat.format(date);
            sb.append(formattedYear.substring(formattedYear.length() - 1));
        }
    }
    ,
    YY("yy", "Last 2 digits of year"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.yyFormat.format(date));
        }
    }
    ,
    YYY("yyy", "Last 3 digits of year"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            String formattedYear = work.yyyyFormat.format(date);
            sb.append(formattedYear.substring(formattedYear.length() - 3));
        }
    }
    ,
    YYYY("yyyy", "The year with century as a decimal number"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.yyyyFormat.format(date));
        }
    }
    ,
    pctY("yyyy", "The year with century as a decimal number"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(1)));
        }
    };

    private final String description;
    final String javaFmt;

    private FormatElementEnum(String javaFmt, String description2) {
        this.javaFmt = Objects.requireNonNull(javaFmt, "javaFmt");
        this.description = Objects.requireNonNull(description2, "description");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void toPattern(StringBuilder sb) {
        sb.append(this.javaFmt);
    }

    final void throwToPatternNotImplemented() {
        throw new UnsupportedOperationException("Cannot convert '" + this.name().toUpperCase(Locale.ROOT) + "' FormatElement to Java pattern");
    }

    static class Work {
        private static final TryThreadLocal<Work> THREAD_WORK = TryThreadLocal.withInitial(Work::new);
        final Calendar calendar = new Calendar.Builder().setWeekDefinition(1, 1).setTimeZone(DateTimeUtils.DEFAULT_ZONE).setLocale(Locale.ROOT).build();
        final Calendar iso8601Calendar = new Calendar.Builder().setCalendarType("iso8601").setTimeZone(DateTimeUtils.DEFAULT_ZONE).setLocale(Locale.ROOT).build();
        final DateFormat mmmFormat;
        final DateFormat mmmmFormat;
        final DateFormat sssFormat;
        final DateFormat yyFormat;
        final DateFormat yyyyFormat;

        Work() {
            this.mmmFormat = new SimpleDateFormat(FormatElementEnum.MON.javaFmt, Locale.US);
            this.mmmmFormat = new SimpleDateFormat(FormatElementEnum.MONTH.javaFmt, Locale.US);
            this.sssFormat = new SimpleDateFormat(FormatElementEnum.FF3.javaFmt, Locale.ROOT);
            this.yyFormat = new SimpleDateFormat(FormatElementEnum.YY.javaFmt, Locale.ROOT);
            this.yyyyFormat = new SimpleDateFormat(FormatElementEnum.YYYY.javaFmt, Locale.ROOT);
        }

        static Work get() {
            return THREAD_WORK.get();
        }

        private String getDayFromDate(Date date, TextStyle style) {
            this.calendar.setTime(date);
            LocalDate ld = LocalDate.of(this.calendar.get(1), this.calendar.get(2) + 1, this.calendar.get(5));
            return ld.getDayOfWeek().getDisplayName(style, Locale.ENGLISH);
        }
    }
}

