/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import javax.net.ssl.SSLException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpRequestExecutor {
    public static final Timeout DEFAULT_WAIT_FOR_CONTINUE = Timeout.ofSeconds(3L);
    private final Http1Config http1Config;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final Http1StreamListener streamListener;

    public HttpRequestExecutor(Http1Config http1Config, ConnectionReuseStrategy connReuseStrategy, Http1StreamListener streamListener) {
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connReuseStrategy = connReuseStrategy != null ? connReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = streamListener;
    }

    @Deprecated
    public HttpRequestExecutor(Timeout waitForContinue, ConnectionReuseStrategy connReuseStrategy, Http1StreamListener streamListener) {
        this(Http1Config.custom().setWaitForContinueTimeout(waitForContinue).build(), connReuseStrategy, streamListener);
    }

    public HttpRequestExecutor(ConnectionReuseStrategy connReuseStrategy) {
        this(Http1Config.DEFAULT, connReuseStrategy, null);
    }

    public HttpRequestExecutor() {
        this(Http1Config.DEFAULT, null, null);
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientConnection conn, HttpResponseInformationCallback informationCallback, HttpContext localContext) throws IOException, HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(localContext, "HTTP context");
        HttpCoreContext context = HttpCoreContext.castOrCreate(localContext);
        try {
            context.setSSLSession(conn.getSSLSession());
            context.setEndpointDetails(conn.getEndpointDetails());
            conn.sendRequestHeader(request);
            if (this.streamListener != null) {
                this.streamListener.onRequestHead(conn, request);
            }
            boolean expectContinue = false;
            HttpEntity entity = request.getEntity();
            if (entity != null) {
                Header expect = request.getFirstHeader("Expect");
                boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
                if (!expectContinue) {
                    conn.sendRequestEntity(request);
                }
            }
            conn.flush();
            ClassicHttpResponse response = null;
            while (response == null) {
                int status;
                if (expectContinue) {
                    Timeout timeout2;
                    Timeout timeout3 = timeout2 = this.http1Config.getWaitForContinueTimeout() != null ? this.http1Config.getWaitForContinueTimeout() : DEFAULT_WAIT_FOR_CONTINUE;
                    if (conn.isDataAvailable(timeout2)) {
                        int status2;
                        response = conn.receiveResponseHeader();
                        if (this.streamListener != null) {
                            this.streamListener.onResponseHead(conn, response);
                        }
                        if ((status2 = response.getCode()) == 100) {
                            response = null;
                            conn.sendRequestEntity(request);
                        } else {
                            if (status2 < 200) {
                                if (informationCallback != null) {
                                    informationCallback.execute(response, conn, context);
                                }
                                response = null;
                                continue;
                            }
                            if (status2 >= 400) {
                                conn.terminateRequest(request);
                            } else {
                                conn.sendRequestEntity(request);
                            }
                        }
                    } else {
                        conn.sendRequestEntity(request);
                    }
                    conn.flush();
                    expectContinue = false;
                    continue;
                }
                response = conn.receiveResponseHeader();
                if (this.streamListener != null) {
                    this.streamListener.onResponseHead(conn, response);
                }
                if ((status = response.getCode()) < 100) {
                    throw new ProtocolException("Invalid response: " + new StatusLine(response));
                }
                if (status >= 200) continue;
                if (informationCallback != null && status != 100) {
                    informationCallback.execute(response, conn, context);
                }
                response = null;
            }
            if (MessageSupport.canResponseHaveBody(request.getMethod(), response)) {
                conn.receiveResponseEntity(response);
            }
            return response;
        }
        catch (SSLException | HttpException ex) {
            Closer.closeQuietly(conn);
            throw ex;
        }
        catch (IOException | RuntimeException ex) {
            Closer.close(conn, CloseMode.IMMEDIATE);
            throw ex;
        }
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        return this.execute(request, conn, null, context);
    }

    public void preProcess(ClassicHttpRequest request, HttpProcessor processor, HttpContext localContext) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(localContext, "HTTP context");
        ProtocolVersion transportVersion = request.getVersion();
        if (transportVersion != null && !transportVersion.lessEquals(this.http1Config.getVersion())) {
            throw new UnsupportedHttpVersionException(transportVersion);
        }
        HttpCoreContext context = HttpCoreContext.cast(localContext);
        context.setProtocolVersion(transportVersion != null ? transportVersion : this.http1Config.getVersion());
        context.setRequest(request);
        processor.process(request, (EntityDetails)request.getEntity(), (HttpContext)context);
    }

    public void postProcess(ClassicHttpResponse response, HttpProcessor processor, HttpContext localContext) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(localContext, "HTTP context");
        HttpCoreContext context = HttpCoreContext.cast(localContext);
        ProtocolVersion transportVersion = response.getVersion();
        if (transportVersion != null) {
            if (transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(transportVersion);
            }
            context.setProtocolVersion(transportVersion);
        }
        context.setResponse(response);
        processor.process(response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    public boolean keepAlive(ClassicHttpRequest request, ClassicHttpResponse response, HttpClientConnection connection, HttpContext context) throws IOException {
        boolean keepAlive;
        Args.notNull(connection, "HTTP connection");
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        boolean bl = keepAlive = connection.isConsistent() && this.connReuseStrategy.keepAlive(request, response, context);
        if (this.streamListener != null) {
            this.streamListener.onExchangeComplete(connection, keepAlive);
        }
        return keepAlive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Timeout waitForContinue;
        private ConnectionReuseStrategy connReuseStrategy;
        private Http1StreamListener streamListener;

        private Builder() {
        }

        public Builder withWaitForContinue(Timeout waitForContinue) {
            this.waitForContinue = waitForContinue;
            return this;
        }

        public Builder withConnectionReuseStrategy(ConnectionReuseStrategy connReuseStrategy) {
            this.connReuseStrategy = connReuseStrategy;
            return this;
        }

        public Builder withHttp1StreamListener(Http1StreamListener streamListener) {
            this.streamListener = streamListener;
            return this;
        }

        public HttpRequestExecutor build() {
            return new HttpRequestExecutor(this.waitForContinue, this.connReuseStrategy, this.streamListener);
        }
    }
}

