/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.fips.FipsNativeServices;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.LoaderUtils;
import org.bouncycastle.crypto.fips.NativeLibIdentity;
import org.bouncycastle.crypto.fips.VariantSelector;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;

class NativeLoader {
    private static final Logger LOG = Logger.getLogger(NativeLoader.class.getName());
    public static final String BCFIPS_LIB_CPU_VARIANT = "org.bouncycastle.native.cpu_variant";
    public static final String LIB_INSTALL_DIR = "org.bouncycastle.native.loader.install_dir";
    private static final AtomicBoolean nativeLibsAvailableForSystem = new AtomicBoolean(false);
    private static final AtomicBoolean nativeInstalled = new AtomicBoolean(false);
    private static final AtomicBoolean nativeEnabled = new AtomicBoolean(false);
    private static final AtomicReference<String> nativeStatusMessage = new AtomicReference<String>("Driver load not attempted");
    private static final AtomicReference<String> selectedVariant = new AtomicReference<Object>(null);
    private static final FipsNativeServices nativeServices = new FipsNativeServices();

    NativeLoader() {
    }

    static synchronized boolean isNativeInstalled() {
        return nativeInstalled.get();
    }

    static synchronized boolean isNativeAvailable() {
        return nativeLibsAvailableForSystem.get() && nativeInstalled.get() && nativeEnabled.get();
    }

    static synchronized void setNativeEnabled(boolean bl) {
        nativeEnabled.set(bl);
    }

    static synchronized String getNativeStatusMessage() {
        return nativeStatusMessage.get();
    }

    static synchronized String getSelectedVariant() {
        return selectedVariant.get();
    }

    static String getFile(String string) {
        String string2;
        try {
            InputStream inputStream2 = NativeLoader.class.getResourceAsStream(string);
            string2 = Strings.fromByteArray(Streams.readAll(inputStream2));
            inputStream2.close();
        }
        catch (Exception exception) {
            return null;
        }
        return string2;
    }

    static List<String> loadVariantsDeps(String string, String string2) {
        String string3 = NativeLoader.getFile(string);
        if (string3 == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : string3.split("\n")) {
            String[] stringArray = (string4 = string4.trim()).split(":");
            if (!stringArray[0].trim().equals(string2)) continue;
            arrayList.add(stringArray[1].trim());
        }
        return Collections.unmodifiableList(arrayList);
    }

    static File installLib(String string, String string2, String string3, File file, Set<File> set) throws Exception {
        String string4 = System.mapLibraryName(string);
        List<String> list = NativeLoader.loadVariantsDeps(string3 + "/deps.list", string4);
        for (String string5 : list) {
            set.remove(LoaderUtils.extractFromClasspath(file, string3 + "/" + string5, string5));
        }
        File file2 = LoaderUtils.extractFromClasspath(file, string2 + "/" + string4, string4);
        set.remove(file2);
        return file2;
    }

    static synchronized void loadDriver() {
        Object object;
        Object object2;
        File file;
        String string;
        Object object3;
        String string2 = Properties.getPropertyValue(BCFIPS_LIB_CPU_VARIANT);
        if ("java".equals(string2)) {
            nativeEnabled.set(false);
            nativeInstalled.set(false);
            nativeStatusMessage.set("java support only");
            return;
        }
        String string3 = Strings.toLowerCase(Properties.getPropertyValue("os.arch", ""));
        String string4 = Strings.toLowerCase(Properties.getPropertyValue("os.name", ""));
        String string5 = null;
        String string6 = null;
        if (string4.contains("linux")) {
            string5 = "linux";
        }
        if (string5 == null) {
            nativeStatusMessage.set("OS '" + string4 + "' is not supported.");
            return;
        }
        if (string3.contains("x86") || string3.contains("amd") && string3.contains("64")) {
            string6 = "x86_64";
        }
        if (string6 == null) {
            nativeStatusMessage.set("architecture '" + string3 + "' is not supported");
            return;
        }
        try {
            object3 = Properties.getPropertyValue(LIB_INSTALL_DIR);
            if (object3 != null) {
                string = "BouncyCastle Security Provider (FIPS edition) v2.1.1".substring("BouncyCastle Security Provider (FIPS edition) v2.1.1".lastIndexOf(118) + 1);
                file = LoaderUtils.createVersionedTempDir((String)object3, string);
            } else {
                file = LoaderUtils.createTempDir("bc-fips-jni");
            }
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "temporary file creation failed", exception);
            nativeInstalled.set(false);
            nativeStatusMessage.set("temporary file creation failed: " + exception.getMessage());
            file = null;
        }
        if (file == null) {
            return;
        }
        object3 = new HashSet();
        Collections.addAll(object3, file.listFiles());
        string = String.format("/native/%s/%s", string5, string6);
        String string7 = String.format("/native/%s/%s/probe", string5, string6);
        InputStream inputStream2 = NativeLoader.class.getResourceAsStream(string7 + "/" + System.mapLibraryName("bc-probe"));
        if (inputStream2 == null) {
            String string8 = String.format("platform '%s' and architecture '%s' are not supported", string5, string6);
            LOG.log(Level.FINE, string8);
            nativeStatusMessage.set(string8);
            nativeInstalled.set(false);
            return;
        }
        try {
            inputStream2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string2 != null) {
            selectedVariant.set(string2);
        } else {
            try {
                object2 = NativeLoader.installLib("bc-probe", string7, string, file, (Set<File>)object3);
                AccessController.doPrivileged(new PrivilegedAction<Object>((File)object2){
                    final /* synthetic */ File val$lib;
                    {
                        this.val$lib = file;
                    }

                    @Override
                    public Object run() {
                        System.load(this.val$lib.getAbsolutePath());
                        return new Object();
                    }
                });
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "probe lib failed to load", exception);
                nativeStatusMessage.set("probe lib failed to load " + exception.getMessage());
                nativeInstalled.set(false);
                return;
            }
            try {
                selectedVariant.set(VariantSelector.getBestVariantName());
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINE, "probe lib failed return a variant", throwable);
                nativeStatusMessage.set("probe lib failed return a variant " + throwable.getMessage());
                nativeInstalled.set(false);
                return;
            }
        }
        if (selectedVariant.get().equals("none")) {
            nativeEnabled.set(false);
            nativeInstalled.set(false);
            object2 = "probe returned no suitable CPU features, java support only";
            LOG.log(Level.FINE, (String)object2);
            nativeStatusMessage.set((String)object2);
            return;
        }
        object2 = String.format("/native/%s/%s/%s", string5, string6, selectedVariant);
        try {
            object = NativeLoader.installLib("bc-fips-" + selectedVariant, (String)object2, string, file, (Set<File>)object3);
            if (!object3.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                Object object4 = object3.iterator();
                while (object4.hasNext()) {
                    File file2 = (File)object4.next();
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(file2.getName());
                }
                object4 = String.format("unexpected files in %s: %s", file, stringBuilder);
                LOG.log(Level.FINE, (String)object4);
                nativeStatusMessage.set((String)object4);
                nativeInstalled.set(false);
                return;
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>((File)object){
                final /* synthetic */ File val$lib;
                {
                    this.val$lib = file;
                }

                @Override
                public Object run() {
                    System.load(this.val$lib.getAbsolutePath());
                    return new Object();
                }
            });
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, "native capabilities lib failed to load", exception);
            nativeStatusMessage.set("native capabilities lib failed to load " + exception.getMessage());
            nativeInstalled.set(false);
            return;
        }
        if (!selectedVariant.get().equals(NativeLibIdentity.getLibraryIdent())) {
            object = String.format("loaded native library variant is %s but the requested library variant is %s", NativeLibIdentity.getLibraryIdent(), selectedVariant);
            LOG.fine((String)object);
            nativeStatusMessage.set((String)object);
            nativeInstalled.set(false);
            return;
        }
        nativeLibsAvailableForSystem.set(true);
        nativeStatusMessage.set("successfully loaded");
        LOG.fine("successfully loaded");
        nativeInstalled.set(true);
        nativeEnabled.set(true);
    }

    public static boolean isNativeLibsAvailableForSystem() {
        return nativeLibsAvailableForSystem.get();
    }

    static FipsNativeServices getNativeServices() {
        return nativeServices;
    }

    static boolean hasNativeService(String string) {
        return NativeLoader.isNativeAvailable() && nativeServices.hasService(string);
    }

    private static byte[] takeSHA256Digest(InputStream inputStream2) {
        try {
            int n;
            byte[] byArray = new byte[65535];
            ExtendedDigest extendedDigest = FipsSHS.createBaseDigest(FipsSHS.Algorithm.SHA256);
            while ((n = inputStream2.read(byArray)) >= 0) {
                extendedDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = new byte[extendedDigest.getDigestSize()];
            extendedDigest.doFinal(byArray2, 0);
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public static boolean isNativeEnabled() {
        return nativeEnabled.get();
    }
}

