/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.general.DSAUtils;
import org.bouncycastle.crypto.general.DSTU4145Signer;
import org.bouncycastle.crypto.general.EcGost3410Signer;
import org.bouncycastle.crypto.general.Gost3410Signer;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;
import org.bouncycastle.util.Arrays;

class DSAOutputVerifier<T extends Parameters>
implements OutputVerifier<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;
    private final boolean reverse;

    DSAOutputVerifier(DSA dSA, Digest digest, T t2) {
        this(dSA, digest, t2, false);
    }

    DSAOutputVerifier(DSA dSA, Digest digest, T t2, boolean bl) {
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t2;
        this.reverse = bl;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getVerifyingStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
        try {
            BigInteger[] bigIntegerArray = DSAOutputVerifier.decode(this.dsa, byArray, this.reverse);
            byte[] byArray2 = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(byArray2, 0);
            return this.dsa.verifySignature(byArray2, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (IOException iOException) {
            throw new InvalidSignatureException("Unable to process signature: " + iOException.getMessage(), iOException);
        }
    }

    static BigInteger[] decode(DSA dSA, byte[] byArray, boolean bl) throws IOException {
        BigInteger[] bigIntegerArray = new BigInteger[2];
        if (dSA instanceof EcGost3410Signer || dSA instanceof Gost3410Signer) {
            if (byArray.length != 64 && byArray.length != 128) {
                throw new IOException("malformed signature");
            }
            byte[] byArray2 = new byte[byArray.length / 2];
            byte[] byArray3 = new byte[byArray.length / 2];
            System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
            System.arraycopy(byArray, byArray3.length, byArray2, 0, byArray2.length);
            bigIntegerArray[0] = new BigInteger(1, byArray2);
            bigIntegerArray[1] = new BigInteger(1, byArray3);
        } else if (dSA instanceof DSTU4145Signer) {
            byte[] byArray4 = ((ASN1OctetString)ASN1OctetString.fromByteArray(byArray)).getOctets();
            byte[] byArray5 = new byte[byArray4.length / 2];
            byte[] byArray6 = new byte[byArray4.length / 2];
            if (bl) {
                DSAUtils.reverseBytes(byArray4);
            }
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length / 2);
            System.arraycopy(byArray4, byArray4.length / 2, byArray5, 0, byArray4.length / 2);
            bigIntegerArray = new BigInteger[]{new BigInteger(1, byArray5), new BigInteger(1, byArray6)};
        } else {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
            if (aSN1Sequence.size() != 2) {
                throw new IOException("malformed signature");
            }
            if (!Arrays.areEqual(byArray, aSN1Sequence.getEncoded("DER"))) {
                throw new IOException("malformed signature");
            }
            bigIntegerArray[0] = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).getValue();
            bigIntegerArray[1] = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
        }
        return bigIntegerArray;
    }
}

