/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import java.util.Objects;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.PseudoCylindricalProjection;

public class HammerProjection
extends PseudoCylindricalProjection {
    private double w = 0.5;
    private double m = 1.0;
    private double rm;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        double cosphi = Math.cos(lpphi);
        double d = Math.sqrt(2.0 / (1.0 + cosphi * Math.cos(lplam *= this.w)));
        xy.x = this.m * d * cosphi * Math.sin(lplam);
        xy.y = this.rm * d * Math.sin(lpphi);
        return xy;
    }

    @Override
    public void initialize() {
        double d;
        double d2;
        super.initialize();
        this.w = Math.abs(this.w);
        if (d2 <= 0.0) {
            throw new ProjectionException("-27");
        }
        this.w = 0.5;
        this.m = Math.abs(this.m);
        if (d <= 0.0) {
            throw new ProjectionException("-27");
        }
        this.m = 1.0;
        this.rm = 1.0 / this.m;
        this.m /= this.w;
        this.es = 0.0;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    public void setW(double w) {
        this.w = w;
    }

    public double getW() {
        return this.w;
    }

    public void setM(double m4) {
        this.m = m4;
    }

    public double getM() {
        return this.m;
    }

    @Override
    public String toString() {
        return "Hammer & Eckert-Greifendorff";
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof HammerProjection) {
            HammerProjection p = (HammerProjection)that;
            return this.m == p.m && this.w == p.w && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.m, this.w, super.hashCode());
    }
}

