/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.aggregation.bucketselectorext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.aggregation.bucketselectorext.BucketSelectorExtFilter;
import org.opensearch.commons.alerting.aggregation.bucketselectorext.BucketSelectorIndices;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.script.BucketAggregationSelectorScript;
import org.opensearch.script.Script;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.SingleBucketAggregation;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.pipeline.BucketHelpers;
import org.opensearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.opensearch.search.aggregations.support.AggregationPath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B]\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001dH\u0002R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorExtAggregator;", "Lorg/opensearch/search/aggregations/pipeline/SiblingPipelineAggregator;", "name", "", "bucketsPathsMap", "", "parentBucketPath", "script", "Lorg/opensearch/script/Script;", "gapPolicy", "Lorg/opensearch/search/aggregations/pipeline/BucketHelpers$GapPolicy;", "filter", "Lorg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorExtFilter;", "metadata", "", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Lorg/opensearch/script/Script;Lorg/opensearch/search/aggregations/pipeline/BucketHelpers$GapPolicy;Lorg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorExtFilter;Ljava/util/Map;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "bucketSelectorExtFilter", "doReduce", "Lorg/opensearch/search/aggregations/InternalAggregation;", "aggregations", "Lorg/opensearch/search/aggregations/Aggregations;", "reduceContext", "Lorg/opensearch/search/aggregations/InternalAggregation$ReduceContext;", "isAccepted", "", "obj", "Lorg/opensearch/search/aggregations/bucket/terms/IncludeExclude;", "common-utils"})
@SourceDebugExtension(value={"SMAP\nBucketSelectorExtAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BucketSelectorExtAggregator.kt\norg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorExtAggregator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,138:1\n37#2,2:139\n*S KotlinDebug\n*F\n+ 1 BucketSelectorExtAggregator.kt\norg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorExtAggregator\n*L\n35#1:139,2\n*E\n"})
public final class BucketSelectorExtAggregator
extends SiblingPipelineAggregator {
    @Nullable
    private String name;
    @NotNull
    private Map<String, String> bucketsPathsMap;
    @NotNull
    private String parentBucketPath;
    @NotNull
    private Script script;
    @NotNull
    private BucketHelpers.GapPolicy gapPolicy;
    @Nullable
    private BucketSelectorExtFilter bucketSelectorExtFilter;

    public BucketSelectorExtAggregator(@Nullable String name, @NotNull Map<String, String> bucketsPathsMap, @NotNull String parentBucketPath, @NotNull Script script, @NotNull BucketHelpers.GapPolicy gapPolicy, @Nullable BucketSelectorExtFilter filter, @Nullable Map<String, ? extends Object> metadata2) {
        Intrinsics.checkNotNullParameter(bucketsPathsMap, "bucketsPathsMap");
        Intrinsics.checkNotNullParameter(parentBucketPath, "parentBucketPath");
        Intrinsics.checkNotNullParameter(script, "script");
        Intrinsics.checkNotNullParameter(gapPolicy, "gapPolicy");
        Collection<String> $this$toTypedArray$iv = bucketsPathsMap.values();
        boolean $i$f$toTypedArray = false;
        Collection<String> thisCollection$iv = $this$toTypedArray$iv;
        super(name, thisCollection$iv.toArray(new String[0]), metadata2);
        this.bucketsPathsMap = bucketsPathsMap;
        this.parentBucketPath = parentBucketPath;
        this.script = script;
        this.gapPolicy = gapPolicy;
        this.bucketSelectorExtFilter = filter;
    }

    public BucketSelectorExtAggregator(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter(sin, "sin");
        super(sin.readString(), null, null);
        this.script = new Script(sin);
        BucketHelpers.GapPolicy gapPolicy = BucketHelpers.GapPolicy.readFrom((StreamInput)sin);
        Intrinsics.checkNotNullExpressionValue(gapPolicy, "readFrom(...)");
        this.gapPolicy = gapPolicy;
        Map map = sin.readMap();
        Intrinsics.checkNotNull(map, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        this.bucketsPathsMap = map;
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        this.parentBucketPath = string;
        this.bucketSelectorExtFilter = sin.readBoolean() ? new BucketSelectorExtFilter(sin) : null;
    }

    @NotNull
    public InternalAggregation doReduce(@NotNull Aggregations aggregations, @NotNull InternalAggregation.ReduceContext reduceContext) {
        Intrinsics.checkNotNullParameter(aggregations, "aggregations");
        Intrinsics.checkNotNullParameter(reduceContext, "reduceContext");
        List parentBucketPathList = AggregationPath.parse((String)this.parentBucketPath).getPathElementsAsStringList();
        Aggregations subAggregations = aggregations;
        int n = parentBucketPathList.size() - 1;
        for (int i = 0; i < n; ++i) {
            Intrinsics.checkNotNullExpressionValue(((SingleBucketAggregation)subAggregations.get((String)parentBucketPathList.get(0))).getAggregations(), "getAggregations(...)");
        }
        Intrinsics.checkNotNull(parentBucketPathList);
        Aggregation aggregation = subAggregations.get((String)CollectionsKt.last(parentBucketPathList));
        Intrinsics.checkNotNull(aggregation, "null cannot be cast to non-null type org.opensearch.search.aggregations.InternalMultiBucketAggregation<*, *>");
        InternalMultiBucketAggregation originalAgg = (InternalMultiBucketAggregation)aggregation;
        List buckets = originalAgg.getBuckets();
        BucketAggregationSelectorScript.Factory factory2 = (BucketAggregationSelectorScript.Factory)reduceContext.scriptService().compile(this.script, BucketAggregationSelectorScript.CONTEXT);
        List selectedBucketsIndex = new ArrayList();
        int n2 = buckets.size();
        for (int i = 0; i < n2; ++i) {
            InternalMultiBucketAggregation.InternalBucket bucket = (InternalMultiBucketAggregation.InternalBucket)buckets.get(i);
            if (this.bucketSelectorExtFilter != null) {
                boolean accepted = true;
                BucketSelectorExtFilter bucketSelectorExtFilter = this.bucketSelectorExtFilter;
                Intrinsics.checkNotNull(bucketSelectorExtFilter);
                if (bucketSelectorExtFilter.isCompositeAggregation()) {
                    Intrinsics.checkNotNull(bucket, "null cannot be cast to non-null type org.opensearch.search.aggregations.bucket.composite.InternalComposite.InternalBucket");
                    Map compBucketKeyObj = ((InternalComposite.InternalBucket)bucket).getKey();
                    BucketSelectorExtFilter bucketSelectorExtFilter2 = this.bucketSelectorExtFilter;
                    Intrinsics.checkNotNull(bucketSelectorExtFilter2);
                    HashMap<String, IncludeExclude> hashMap = bucketSelectorExtFilter2.getFiltersMap();
                    for (String sourceKey : compBucketKeyObj.keySet()) {
                        if (hashMap == null) continue;
                        if (hashMap.containsKey(sourceKey)) {
                            Object obj;
                            Object v = obj = compBucketKeyObj.get(sourceKey);
                            Intrinsics.checkNotNull(v);
                            accepted = this.isAccepted(v, hashMap.get(sourceKey));
                            if (accepted) continue;
                        } else {
                            accepted = false;
                        }
                        break;
                    }
                } else {
                    Object object = bucket.getKey();
                    Intrinsics.checkNotNullExpressionValue(object, "getKey(...)");
                    BucketSelectorExtFilter bucketSelectorExtFilter3 = this.bucketSelectorExtFilter;
                    Intrinsics.checkNotNull(bucketSelectorExtFilter3);
                    accepted = this.isAccepted(object, bucketSelectorExtFilter3.getFilters());
                }
                if (!accepted) continue;
            }
            Map vars = new HashMap();
            if (this.script.getParams() != null) {
                Map map = this.script.getParams();
                Intrinsics.checkNotNullExpressionValue(map, "getParams(...)");
                vars.putAll(map);
            }
            for (Map.Entry entry : this.bucketsPathsMap.entrySet()) {
                String varName = (String)entry.getKey();
                String bucketsPath = (String)entry.getValue();
                Double value = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)((MultiBucketsAggregation)originalAgg), (InternalMultiBucketAggregation.InternalBucket)bucket, (String)bucketsPath, (BucketHelpers.GapPolicy)this.gapPolicy);
                Intrinsics.checkNotNull(value);
                vars.put(varName, value);
            }
            BucketAggregationSelectorScript executableScript = factory2.newInstance(vars);
            if (!executableScript.execute()) continue;
            selectedBucketsIndex.add(i);
        }
        return new BucketSelectorIndices(this.name(), this.parentBucketPath, selectedBucketsIndex, originalAgg.getMetadata());
    }

    private final boolean isAccepted(Object obj, IncludeExclude filter) {
        boolean bl;
        Class<?> clazz = obj.getClass();
        if (Intrinsics.areEqual(clazz, String.class)) {
            IncludeExclude includeExclude = filter;
            Intrinsics.checkNotNull(includeExclude);
            IncludeExclude.StringFilter stringFilter = includeExclude.convertToStringFilter(DocValueFormat.RAW);
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.String");
            bl = stringFilter.accept(new BytesRef((CharSequence)((String)obj)));
        } else if (Intrinsics.areEqual(clazz, Long.class) ? true : Intrinsics.areEqual(clazz, Long.TYPE)) {
            IncludeExclude includeExclude = filter;
            Intrinsics.checkNotNull(includeExclude);
            IncludeExclude.LongFilter longFilter = includeExclude.convertToLongFilter(DocValueFormat.RAW);
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Long");
            bl = longFilter.accept(((Long)obj).longValue());
        } else if (Intrinsics.areEqual(clazz, Double.class) ? true : Intrinsics.areEqual(clazz, Double.TYPE)) {
            IncludeExclude includeExclude = filter;
            Intrinsics.checkNotNull(includeExclude);
            IncludeExclude.LongFilter doubleFilter = includeExclude.convertToDoubleFilter();
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Long");
            bl = doubleFilter.accept(((Long)obj).longValue());
        } else {
            throw new IllegalStateException("Object is not comparable. Please use one of String, Long or Double type.");
        }
        return bl;
    }
}

