/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.aggregation.bucketselectorext;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.aggregation.bucketselectorext.BucketSelectorExtAggregationBuilder;
import org.opensearch.commons.alerting.aggregation.bucketselectorext.BucketSelectorIndices;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.aggregations.InternalAggregation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001*BC\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0096\u0002J\u0018\u0010\u001f\u001a\u00020\n2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u001dH\u0014J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0004J\u001e\u0010&\u001a\u00020\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010(\u001a\u00020)H\u0016R\"\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorIndices;", "Lorg/opensearch/search/aggregations/InternalAggregation;", "name", "", "parentBucketPath", "bucketIndices", "", "", "metaData", "", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getBucketIndices", "()Ljava/util/List;", "setBucketIndices", "(Ljava/util/List;)V", "doWriteTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "doXContentBody", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "equals", "", "other", "getProperty", "path", "", "getWriteableName", "hashCode", "mustReduceOnSingleInternalAgg", "otherStatsToXContent", "reduce", "aggregations", "reduceContext", "Lorg/opensearch/search/aggregations/InternalAggregation$ReduceContext;", "Fields", "common-utils"})
public class BucketSelectorIndices
extends InternalAggregation {
    @NotNull
    private String parentBucketPath;
    @NotNull
    private List<Integer> bucketIndices;

    @NotNull
    public final List<Integer> getBucketIndices() {
        return this.bucketIndices;
    }

    public final void setBucketIndices(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.bucketIndices = list;
    }

    public BucketSelectorIndices(@Nullable String name, @NotNull String parentBucketPath, @NotNull List<Integer> bucketIndices, @Nullable Map<String, ? extends Object> metaData) {
        Intrinsics.checkNotNullParameter(parentBucketPath, "parentBucketPath");
        Intrinsics.checkNotNullParameter(bucketIndices, "bucketIndices");
        super(name, metaData);
        this.parentBucketPath = parentBucketPath;
        this.bucketIndices = bucketIndices;
    }

    public BucketSelectorIndices(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter(sin, "sin");
        super(sin);
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
        this.parentBucketPath = string;
        int[] nArray = sin.readIntArray();
        Intrinsics.checkNotNullExpressionValue(nArray, "readIntArray(...)");
        this.bucketIndices = ArraysKt.asList(nArray);
    }

    protected void doWriteTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter(out, "out");
        out.writeString(this.parentBucketPath);
        out.writeIntArray(this.bucketIndices.stream().mapToInt(arg_0 -> BucketSelectorIndices.doWriteTo$lambda$0(doWriteTo.1.INSTANCE, arg_0)).toArray());
    }

    @NotNull
    public String getWriteableName() {
        String string = BucketSelectorExtAggregationBuilder.Companion.getNAME().getPreferredName();
        Intrinsics.checkNotNullExpressionValue(string, "getPreferredName(...)");
        return string;
    }

    @NotNull
    public BucketSelectorIndices reduce(@NotNull List<? extends InternalAggregation> aggregations, @NotNull InternalAggregation.ReduceContext reduceContext) {
        Intrinsics.checkNotNullParameter(aggregations, "aggregations");
        Intrinsics.checkNotNullParameter(reduceContext, "reduceContext");
        throw new UnsupportedOperationException("Not supported");
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    @NotNull
    public Object getProperty(@Nullable List<String> path) {
        throw new UnsupportedOperationException("Not supported");
    }

    @NotNull
    public XContentBuilder doXContentBody(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) throws IOException {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(params, "params");
        builder.field("parent_bucket_path", this.parentBucketPath);
        builder.field("bucket_indices", (Iterable)this.bucketIndices);
        this.otherStatsToXContent(builder);
        return builder;
    }

    @NotNull
    protected final XContentBuilder otherStatsToXContent(@NotNull XContentBuilder builder) throws IOException {
        Intrinsics.checkNotNullParameter(builder, "builder");
        return builder;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.parentBucketPath};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(((Object)((Object)this)).getClass(), other.getClass())) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        BucketSelectorIndices otherCast = (BucketSelectorIndices)((Object)other);
        return Intrinsics.areEqual(this.name, otherCast.name) && Intrinsics.areEqual(this.parentBucketPath, otherCast.parentBucketPath);
    }

    private static final int doWriteTo$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/commons/alerting/aggregation/bucketselectorext/BucketSelectorIndices$Fields;", "", "()V", "BUCKET_INDICES", "", "PARENT_BUCKET_PATH", "common-utils"})
    public static final class Fields {
        @NotNull
        public static final Fields INSTANCE = new Fields();
        @NotNull
        public static final String PARENT_BUCKET_PATH = "parent_bucket_path";
        @NotNull
        public static final String BUCKET_INDICES = "bucket_indices";

        private Fields() {
        }
    }
}

