/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.rest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.function.Factory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.ConfigConstants;
import org.opensearch.commons.rest.TrustStore;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.settings.SecureString;

public class SecureRestClientBuilder {
    private final boolean httpSSLEnabled;
    private final String user;
    private final String passwd;
    private final ArrayList<HttpHost> hosts = new ArrayList();
    private final Path configPath;
    private final Settings settings;
    private int defaultConnectTimeOutMSecs = 5000;
    private int defaultSoTimeoutMSecs = 10000;
    private int defaultConnRequestTimeoutMSecs = 180000;
    private int defaultMaxConnPerRoute = 10;
    private int defaultMaxConnTotal = 30;
    private static final Logger log = LogManager.getLogger(SecureRestClientBuilder.class);

    public SecureRestClientBuilder(String host, int port, boolean httpSSLEnabled, String user, String passWord) {
        if (Strings.isNullOrEmpty((String)user) || Strings.isNullOrEmpty((String)passWord)) {
            throw new IllegalArgumentException("Invalid user or password");
        }
        this.httpSSLEnabled = httpSSLEnabled;
        this.user = user;
        this.passwd = passWord;
        this.settings = Settings.EMPTY;
        this.configPath = null;
        this.hosts.add(new HttpHost(httpSSLEnabled ? "https" : "http", host, port));
    }

    public SecureRestClientBuilder(HttpHost[] httpHosts, boolean httpSSLEnabled, String user, String passWord) {
        if (Strings.isNullOrEmpty((String)user) || Strings.isNullOrEmpty((String)passWord)) {
            throw new IllegalArgumentException("Invalid user or password");
        }
        this.httpSSLEnabled = httpSSLEnabled;
        this.user = user;
        this.passwd = passWord;
        this.settings = Settings.EMPTY;
        this.configPath = null;
        this.hosts.addAll(Arrays.asList(httpHosts));
    }

    public SecureRestClientBuilder(Settings settings, Path configPath) {
        this.httpSSLEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(false));
        this.settings = settings;
        this.configPath = configPath;
        this.user = null;
        this.passwd = null;
        String host = "localhost";
        int port = settings.getAsInt("http.port", Integer.valueOf(9200));
        this.hosts.add(new HttpHost(this.httpSSLEnabled ? "https" : "http", host, port));
    }

    public SecureRestClientBuilder(Settings settings, Path configPath, HttpHost[] httpHosts) {
        this.httpSSLEnabled = settings.getAsBoolean("plugins.security.ssl.http.enabled", Boolean.valueOf(false));
        this.settings = settings;
        this.configPath = configPath;
        this.user = null;
        this.passwd = null;
        this.hosts.addAll(Arrays.asList(httpHosts));
    }

    public RestClient build() throws IOException {
        return this.createRestClientBuilder().build();
    }

    public RestHighLevelClient buildHighlevelClient() throws IOException {
        return new RestHighLevelClient(this.createRestClientBuilder());
    }

    public SecureRestClientBuilder setConnectTimeout(int timeout2) {
        this.defaultConnectTimeOutMSecs = timeout2;
        return this;
    }

    public SecureRestClientBuilder setSocketTimeout(int timeout2) {
        this.defaultSoTimeoutMSecs = timeout2;
        return this;
    }

    public SecureRestClientBuilder setConnectionRequestTimeout(int timeout2) {
        this.defaultConnRequestTimeoutMSecs = timeout2;
        return this;
    }

    public SecureRestClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.defaultMaxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public SecureRestClientBuilder setMaxConnTotal(int maxConnTotal) {
        this.defaultMaxConnTotal = maxConnTotal;
        return this;
    }

    private RestClientBuilder createRestClientBuilder() throws IOException {
        SSLContext sslContext;
        RestClientBuilder builder = RestClient.builder(this.hosts.toArray(new HttpHost[this.hosts.size()]));
        builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            @Override
            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout(Timeout.ofMilliseconds(SecureRestClientBuilder.this.defaultConnectTimeOutMSecs)).setResponseTimeout(Timeout.ofMilliseconds(SecureRestClientBuilder.this.defaultSoTimeoutMSecs)).setConnectionRequestTimeout(Timeout.ofMilliseconds(SecureRestClientBuilder.this.defaultConnRequestTimeoutMSecs));
            }
        });
        try {
            sslContext = this.createSSLContext();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new IOException(ex);
        }
        final CredentialsProvider credentialsProvider = this.createCredsProvider();
        builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){
            final /* synthetic */ SecureRestClientBuilder this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                if (sslContext != null) {
                    TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).setTlsDetailsFactory(new Factory<SSLEngine, TlsDetails>(this){

                        @Override
                        public TlsDetails create(SSLEngine sslEngine) {
                            return new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol());
                        }
                    }).build();
                    PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).setMaxConnPerRoute(this.this$0.defaultMaxConnPerRoute).setMaxConnTotal(this.this$0.defaultMaxConnTotal).build();
                    httpClientBuilder.setConnectionManager(connectionManager);
                }
                if (credentialsProvider != null) {
                    httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
                }
                return httpClientBuilder;
            }
        });
        return builder;
    }

    private SSLContext createSSLContext() throws IOException, GeneralSecurityException {
        SSLContextBuilder builder = new SSLContextBuilder();
        if (this.httpSSLEnabled) {
            String pemFile = this.getTrustPem();
            if (Strings.isNullOrEmpty((String)pemFile)) {
                builder.loadTrustMaterial(null, new TrustSelfSignedStrategy());
            } else {
                String pem = this.resolve(pemFile, this.configPath);
                KeyStore trustStore = new TrustStore(pem).create();
                builder.loadTrustMaterial(trustStore, null);
            }
            KeyStore keyStore = this.getKeyStore();
            if (keyStore != null) {
                builder.loadKeyMaterial(keyStore, this.getKeystorePasswd().toCharArray());
            }
        }
        return builder.build();
    }

    private CredentialsProvider createCredsProvider() {
        if (Strings.isNullOrEmpty((String)this.user) || Strings.isNullOrEmpty((String)this.passwd)) {
            return null;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1), new UsernamePasswordCredentials(this.user, this.passwd.toCharArray()));
        return credentialsProvider;
    }

    private String resolve(String originalFile, Path configPath) {
        String path = null;
        if (originalFile != null && originalFile.length() > 0) {
            path = configPath.resolve(originalFile).toAbsolutePath().toString();
            log.debug("Resolved {} to {} against {}", (Object)originalFile, (Object)path, (Object)configPath.toAbsolutePath().toString());
        }
        if (path == null || path.length() == 0) {
            throw new OpenSearchException("Empty file path for " + originalFile, new Object[0]);
        }
        if (Files.isDirectory(Paths.get(path, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new OpenSearchException("Is a directory: " + path + " Expected a file for " + originalFile, new Object[0]);
        }
        if (!Files.isReadable(Paths.get(path, new String[0]))) {
            throw new OpenSearchException("Unable to read " + path + " (" + String.valueOf(Paths.get(path, new String[0])) + "). Please make sure this files exists and is readable regarding to permissions. Property: " + originalFile, new Object[0]);
        }
        if ("".equals(path)) {
            path = null;
        }
        return path;
    }

    private String getTrustPem() {
        return this.settings.get("plugins.security.ssl.http.pemcert_filepath", null);
    }

    private String getKeystorePasswd() {
        return ((SecureString)ConfigConstants.OPENSEARCH_SECURITY_SSL_HTTP_KEYSTORE_PASSWORD_SETTING.get(this.settings)).toString();
    }

    private KeyStore getKeyStore() throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance("jks");
        String keyStoreFile = this.settings.get("plugins.security.ssl.http.keystore_filepath", null);
        String passwd = ((SecureString)ConfigConstants.OPENSEARCH_SECURITY_SSL_HTTP_KEYSTORE_PASSWORD_SETTING.get(this.settings)).toString();
        if (Strings.isNullOrEmpty((String)keyStoreFile) || Strings.isNullOrEmpty((String)passwd)) {
            return null;
        }
        String keyStorePath = this.resolve(keyStoreFile, this.configPath);
        try (InputStream is = Files.newInputStream(Paths.get(keyStorePath, new String[0]), new OpenOption[0]);){
            keyStore.load(is, passwd.toCharArray());
        }
        return keyStore;
    }
}

