/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.input;

import java.util.Locale;
import java.util.Map;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.input.parameter.MLAlgoParams;
import org.opensearch.ml.common.input.parameter.clustering.KMeansParams;
import org.opensearch.ml.common.input.parameter.rcf.BatchRCFParams;
import org.opensearch.ml.common.input.parameter.rcf.FitRCFParams;

public class InputHelper {
    public static String getAction(Map<String, Object> arguments2) {
        return (String)arguments2.get("action");
    }

    public static FunctionName getFunctionName(Map<String, Object> arguments2) {
        String algo = (String)arguments2.get("algorithm");
        if (algo == null) {
            throw new IllegalArgumentException("The parameter algorithm is required.");
        }
        switch (algo.toLowerCase(Locale.ROOT)) {
            case "kmeans": {
                return FunctionName.KMEANS;
            }
            case "rcf": {
                return arguments2.get("timeField") == null ? FunctionName.BATCH_RCF : FunctionName.FIT_RCF;
            }
        }
        throw new IllegalArgumentException(String.format("unsupported algorithm: %s.", algo));
    }

    public static MLAlgoParams convertArgumentToMLParameter(Map<String, Object> arguments2, FunctionName func) {
        switch (func) {
            case KMEANS: {
                return InputHelper.buildKMeansParameters(arguments2);
            }
            case BATCH_RCF: {
                return InputHelper.buildBatchRCFParameters(arguments2);
            }
            case FIT_RCF: {
                return InputHelper.buildFitRCFParameters(arguments2);
            }
        }
        throw new IllegalArgumentException(String.format("unsupported algorithm: %s.", new Object[]{func}));
    }

    private static MLAlgoParams buildKMeansParameters(Map<String, Object> arguments2) {
        return KMeansParams.builder().centroids((Integer)arguments2.get("centroid")).iterations((Integer)arguments2.get("iteration")).distanceType(arguments2.containsKey("distType") ? KMeansParams.DistanceType.valueOf(((String)arguments2.get("distType")).toUpperCase(Locale.ROOT)) : null).build();
    }

    private static MLAlgoParams buildBatchRCFParameters(Map<String, Object> arguments2) {
        return BatchRCFParams.builder().numberOfTrees((Integer)arguments2.get("numberTrees")).sampleSize((Integer)arguments2.get("sampleSize")).outputAfter((Integer)arguments2.get("outputAfter")).trainingDataSize((Integer)arguments2.get("trainingDataSize")).anomalyScoreThreshold((Double)arguments2.get("anomalyScoreThreshold")).build();
    }

    private static MLAlgoParams buildFitRCFParameters(Map<String, Object> arguments2) {
        return FitRCFParams.builder().numberOfTrees((Integer)arguments2.get("numberTrees")).shingleSize((Integer)arguments2.get("shingleSize")).sampleSize((Integer)arguments2.get("sampleSize")).outputAfter((Integer)arguments2.get("outputAfter")).timeDecay((Double)arguments2.get("timeDecay")).anomalyRate((Double)arguments2.get("anomalyRate")).timeField((String)arguments2.get("timeField")).dateFormat(arguments2.containsKey("dateFormat") ? (String)arguments2.get("dateFormat") : "yyyy-MM-dd HH:mm:ss").timeZone((String)arguments2.get("timeZone")).build();
    }
}

