/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;

public class MLCreateMemoryContainerInput
implements ToXContentObject,
Writeable {
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String MEMORY_CONFIG_FIELD = "configuration";
    private String name;
    private String description;
    private MemoryConfiguration configuration;
    private String tenantId;
    private List<String> backendRoles;

    public MLCreateMemoryContainerInput(String name, String description2, MemoryConfiguration configuration, String tenantId, List<String> backendRoles) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        this.description = description2;
        this.configuration = configuration == null ? MemoryConfiguration.builder().build() : configuration;
        this.tenantId = tenantId;
        this.backendRoles = backendRoles;
    }

    public MLCreateMemoryContainerInput(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readOptionalString();
        this.configuration = in.readBoolean() ? new MemoryConfiguration(in) : null;
        this.tenantId = in.readOptionalString();
        if (in.readBoolean()) {
            this.backendRoles = in.readStringList();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.description);
        if (this.configuration != null) {
            out.writeBoolean(true);
            this.configuration.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.tenantId);
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            out.writeBoolean(true);
            out.writeStringCollection(this.backendRoles);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.name);
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.configuration != null) {
            builder.field(MEMORY_CONFIG_FIELD, (ToXContent)this.configuration);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        if (!CollectionUtils.isEmpty(this.backendRoles)) {
            builder.field("backend_roles", this.backendRoles);
        }
        builder.endObject();
        return builder;
    }

    public static MLCreateMemoryContainerInput parse(XContentParser parser) throws IOException {
        String name = null;
        String description2 = null;
        MemoryConfiguration configuration = null;
        String tenantId = null;
        ArrayList<String> backendRoles = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block14;
                }
                case "description": {
                    description2 = parser.text();
                    continue block14;
                }
                case "configuration": {
                    configuration = MemoryConfiguration.parse(parser);
                    continue block14;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block14;
                }
                case "backend_roles": {
                    backendRoles = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        backendRoles.add(parser.text());
                    }
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return MLCreateMemoryContainerInput.builder().name(name).description(description2).configuration(configuration).tenantId(tenantId).backendRoles(backendRoles).build();
    }

    @Generated
    public static MLCreateMemoryContainerInputBuilder builder() {
        return new MLCreateMemoryContainerInputBuilder();
    }

    @Generated
    public MLCreateMemoryContainerInputBuilder toBuilder() {
        return new MLCreateMemoryContainerInputBuilder().name(this.name).description(this.description).configuration(this.configuration).tenantId(this.tenantId).backendRoles(this.backendRoles);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MemoryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description2) {
        this.description = description2;
    }

    @Generated
    public void setConfiguration(MemoryConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setBackendRoles(List<String> backendRoles) {
        this.backendRoles = backendRoles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLCreateMemoryContainerInput)) {
            return false;
        }
        MLCreateMemoryContainerInput other = (MLCreateMemoryContainerInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        MemoryConfiguration this$configuration = this.getConfiguration();
        MemoryConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        List<String> this$backendRoles = this.getBackendRoles();
        List<String> other$backendRoles = other.getBackendRoles();
        return !(this$backendRoles == null ? other$backendRoles != null : !((Object)this$backendRoles).equals(other$backendRoles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLCreateMemoryContainerInput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $name = this.getName();
        result2 = result2 * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result2 = result2 * 59 + ($description == null ? 43 : $description.hashCode());
        MemoryConfiguration $configuration = this.getConfiguration();
        result2 = result2 * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $tenantId = this.getTenantId();
        result2 = result2 * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        List<String> $backendRoles = this.getBackendRoles();
        result2 = result2 * 59 + ($backendRoles == null ? 43 : ((Object)$backendRoles).hashCode());
        return result2;
    }

    @Generated
    public String toString() {
        return "MLCreateMemoryContainerInput(name=" + this.getName() + ", description=" + this.getDescription() + ", configuration=" + String.valueOf(this.getConfiguration()) + ", tenantId=" + this.getTenantId() + ", backendRoles=" + String.valueOf(this.getBackendRoles()) + ")";
    }

    @Generated
    public static class MLCreateMemoryContainerInputBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private MemoryConfiguration configuration;
        @Generated
        private String tenantId;
        @Generated
        private List<String> backendRoles;

        @Generated
        MLCreateMemoryContainerInputBuilder() {
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder description(String description2) {
            this.description = description2;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder configuration(MemoryConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInputBuilder backendRoles(List<String> backendRoles) {
            this.backendRoles = backendRoles;
            return this;
        }

        @Generated
        public MLCreateMemoryContainerInput build() {
            return new MLCreateMemoryContainerInput(this.name, this.description, this.configuration, this.tenantId, this.backendRoles);
        }

        @Generated
        public String toString() {
            return "MLCreateMemoryContainerInput.MLCreateMemoryContainerInputBuilder(name=" + this.name + ", description=" + this.description + ", configuration=" + String.valueOf(this.configuration) + ", tenantId=" + this.tenantId + ", backendRoles=" + String.valueOf(this.backendRoles) + ")";
        }
    }
}

