/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.binning;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class RangeBucketFunction
extends ImplementorUDF {
    public RangeBucketFunction() {
        super(new RangeBucketImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.VARCHAR_2000;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.NUMERIC_NUMERIC_NUMERIC_NUMERIC_NUMERIC;
    }

    public static class RangeBucketImplementor
    implements NotNullImplementor {
        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression fieldValue = translatedOperands.get(0);
            Expression dataMin = translatedOperands.get(1);
            Expression dataMax = translatedOperands.get(2);
            Expression startParam = translatedOperands.get(3);
            Expression endParam = translatedOperands.get(4);
            return Expressions.call(RangeBucketImplementor.class, "calculateRangeBucket", new Expression[]{Expressions.convert_(fieldValue, Number.class), Expressions.convert_(dataMin, Number.class), Expressions.convert_(dataMax, Number.class), Expressions.convert_(startParam, Number.class), Expressions.convert_(endParam, Number.class)});
        }

        public static String calculateRangeBucket(Number fieldValue, Number dataMin, Number dataMax, Number startParam, Number endParam) {
            double effectiveRange;
            if (fieldValue == null || dataMin == null || dataMax == null) {
                return null;
            }
            double value = fieldValue.doubleValue();
            double dMin = dataMin.doubleValue();
            double dMax = dataMax.doubleValue();
            double effectiveMin = dMin;
            if (startParam != null) {
                double start = startParam.doubleValue();
                effectiveMin = Math.min(start, dMin);
            }
            double effectiveMax = dMax;
            if (endParam != null) {
                double end = endParam.doubleValue();
                effectiveMax = Math.max(end, dMax);
            }
            if ((effectiveRange = effectiveMax - effectiveMin) <= 0.0) {
                return null;
            }
            double width = RangeBucketImplementor.calculateMagnitudeBasedWidth(effectiveRange);
            if (width <= 0.0) {
                return null;
            }
            double firstBinStart = Math.floor(effectiveMin / width) * width;
            double adjustedField = value - firstBinStart;
            double binIndex = Math.floor(adjustedField / width);
            double binStart = binIndex * width + firstBinStart;
            double binEnd = binStart + width;
            return RangeBucketImplementor.formatRange(binStart, binEnd, width);
        }

        private static double calculateMagnitudeBasedWidth(double effectiveRange) {
            double floorLog;
            double log10Range = Math.log10(effectiveRange);
            boolean isExactPowerOf10 = Math.abs(log10Range - (floorLog = Math.floor(log10Range))) < 1.0E-10;
            double adjustedMagnitude = isExactPowerOf10 ? floorLog - 1.0 : floorLog;
            return Math.pow(10.0, adjustedMagnitude);
        }

        private static String formatRange(double binStart, double binEnd, double span) {
            if (RangeBucketImplementor.isIntegerSpan(span) && RangeBucketImplementor.isIntegerValue(binStart) && RangeBucketImplementor.isIntegerValue(binEnd)) {
                return String.format("%d-%d", (long)binStart, (long)binEnd);
            }
            return RangeBucketImplementor.formatFloatingPointRange(binStart, binEnd, span);
        }

        private static boolean isIntegerSpan(double span) {
            return span == Math.floor(span) && !Double.isInfinite(span);
        }

        private static boolean isIntegerValue(double value) {
            return Math.abs(value - (double)Math.round(value)) < 1.0E-10;
        }

        private static String formatFloatingPointRange(double binStart, double binEnd, double span) {
            int decimalPlaces = RangeBucketImplementor.getAppropriateDecimalPlaces(span);
            String format = String.format("%%.%df-%%.%df", decimalPlaces, decimalPlaces);
            return String.format(format, binStart, binEnd);
        }

        private static int getAppropriateDecimalPlaces(double span) {
            if (span >= 1.0) {
                return 1;
            }
            if (span >= 0.1) {
                return 2;
            }
            if (span >= 0.01) {
                return 3;
            }
            return 4;
        }
    }
}

