/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.operator.predicate;

import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.BuiltinFunctionRepository;
import org.opensearch.sql.expression.function.DefaultFunctionResolver;
import org.opensearch.sql.expression.function.FunctionDSL;
import org.opensearch.sql.expression.operator.predicate.UnaryPredicateOperators;
import org.opensearch.sql.utils.OperatorUtils;
import shaded.com.google.common.collect.ImmutableTable;
import shaded.com.google.common.collect.Table;

public final class BinaryPredicateOperators {
    private static final Table<ExprValue, ExprValue, ExprValue> andTable = new ImmutableTable.Builder<ExprValue, ExprValue, ExprValue>().put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_TRUE).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_FALSE).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_FALSE).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_FALSE).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_FALSE).put(ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL).put(ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING).put(ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING).build();
    private static final Table<ExprValue, ExprValue, ExprValue> orTable = new ImmutableTable.Builder<ExprValue, ExprValue, ExprValue>().put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_TRUE).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_TRUE).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_TRUE).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_TRUE).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_FALSE).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING).put(ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL).put(ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_NULL).put(ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING).build();
    private static final Table<ExprValue, ExprValue, ExprValue> xorTable = new ImmutableTable.Builder<ExprValue, ExprValue, ExprValue>().put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_FALSE).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_TRUE).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_TRUE).put(ExprValueUtils.LITERAL_TRUE, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_TRUE).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_FALSE).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL).put(ExprValueUtils.LITERAL_FALSE, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING).put(ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_NULL).put(ExprValueUtils.LITERAL_NULL, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_NULL).put(ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING, ExprValueUtils.LITERAL_MISSING).build();

    public static void register(BuiltinFunctionRepository repository) {
        repository.register(BinaryPredicateOperators.and());
        repository.register(BinaryPredicateOperators.or());
        repository.register(BinaryPredicateOperators.xor());
        repository.register(BinaryPredicateOperators.equal());
        repository.register(BinaryPredicateOperators.notEqual());
        repository.register(BinaryPredicateOperators.less());
        repository.register(BinaryPredicateOperators.lte());
        repository.register(BinaryPredicateOperators.greater());
        repository.register(BinaryPredicateOperators.gte());
        repository.register(BinaryPredicateOperators.like());
        repository.register(BinaryPredicateOperators.notLike());
        repository.register(BinaryPredicateOperators.regexp());
    }

    private static DefaultFunctionResolver and() {
        return FunctionDSL.define(BuiltinFunctionName.AND.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperators.lookupTableFunction(v1, v2, andTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static DefaultFunctionResolver or() {
        return FunctionDSL.define(BuiltinFunctionName.OR.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperators.lookupTableFunction(v1, v2, orTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static DefaultFunctionResolver xor() {
        return FunctionDSL.define(BuiltinFunctionName.XOR.getName(), FunctionDSL.impl((v1, v2) -> BinaryPredicateOperators.lookupTableFunction(v1, v2, xorTable), ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN, ExprCoreType.BOOLEAN));
    }

    private static DefaultFunctionResolver equal() {
        return FunctionDSL.define(BuiltinFunctionName.EQUAL.getName(), ExprCoreType.coreTypes().stream().map(type2 -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.equals(v2))), ExprCoreType.BOOLEAN, type2, type2)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver notEqual() {
        return FunctionDSL.define(BuiltinFunctionName.NOTEQUAL.getName(), ExprCoreType.coreTypes().stream().map(type2 -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(!v1.equals(v2))), ExprCoreType.BOOLEAN, type2, type2)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver less() {
        return FunctionDSL.define(BuiltinFunctionName.LESS.getName(), ExprCoreType.coreTypes().stream().map(type2 -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) < 0)), ExprCoreType.BOOLEAN, type2, type2)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver lte() {
        return FunctionDSL.define(BuiltinFunctionName.LTE.getName(), ExprCoreType.coreTypes().stream().map(type2 -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) <= 0)), ExprCoreType.BOOLEAN, type2, type2)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver greater() {
        return FunctionDSL.define(BuiltinFunctionName.GREATER.getName(), ExprCoreType.coreTypes().stream().map(type2 -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) > 0)), ExprCoreType.BOOLEAN, type2, type2)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver gte() {
        return FunctionDSL.define(BuiltinFunctionName.GTE.getName(), ExprCoreType.coreTypes().stream().map(type2 -> FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> ExprBooleanValue.of(v1.compareTo(v2) >= 0)), ExprCoreType.BOOLEAN, type2, type2)).collect(Collectors.toList()));
    }

    private static DefaultFunctionResolver like() {
        return FunctionDSL.define(BuiltinFunctionName.LIKE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(OperatorUtils::matches), ExprCoreType.BOOLEAN, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver regexp() {
        return FunctionDSL.define(BuiltinFunctionName.REGEXP.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling(OperatorUtils::matchesRegexp), ExprCoreType.INTEGER, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static DefaultFunctionResolver notLike() {
        return FunctionDSL.define(BuiltinFunctionName.NOT_LIKE.getName(), FunctionDSL.impl(FunctionDSL.nullMissingHandling((v1, v2) -> UnaryPredicateOperators.not(OperatorUtils.matches(v1, v2))), ExprCoreType.BOOLEAN, ExprCoreType.STRING, ExprCoreType.STRING));
    }

    private static ExprValue lookupTableFunction(ExprValue arg1, ExprValue arg2, Table<ExprValue, ExprValue, ExprValue> table) {
        if (table.contains(arg1, arg2)) {
            return table.get(arg1, arg2);
        }
        return table.get(arg2, arg1);
    }

    @Generated
    private BinaryPredicateOperators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

