/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.domain;

import com.alibaba.druid.sql.ast.SQLExpr;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.parser.ChildrenType;
import org.opensearch.sql.legacy.parser.NestedType;
import org.opensearch.sql.legacy.utils.StringUtils;
import shaded.com.google.common.collect.BiMap;
import shaded.com.google.common.collect.HashBiMap;

public class Condition
extends Where {
    private String name;
    private final SQLExpr nameExpr;
    private Object value;
    private final SQLExpr valueExpr;
    private OPERATOR OPERATOR = null;
    private Object relationshipType;
    private boolean isNested;
    private String nestedPath;
    private boolean isChildren;
    private String childType;

    public SQLExpr getNameExpr() {
        return this.nameExpr;
    }

    public SQLExpr getValueExpr() {
        return this.valueExpr;
    }

    public Condition(Where.CONN conn, String field, SQLExpr nameExpr, String condition, Object obj, SQLExpr valueExpr) throws SqlParseException {
        this(conn, field, nameExpr, condition, obj, valueExpr, null);
    }

    public Condition(Where.CONN conn, String field, SQLExpr nameExpr, OPERATOR condition, Object obj, SQLExpr valueExpr) throws SqlParseException {
        this(conn, field, nameExpr, condition, obj, valueExpr, null);
    }

    public Condition(Where.CONN conn, String name, SQLExpr nameExpr, String oper, Object value, SQLExpr valueExpr, Object relationshipType) throws SqlParseException {
        super(conn);
        this.name = name;
        this.value = value;
        this.nameExpr = nameExpr;
        this.valueExpr = valueExpr;
        this.relationshipType = relationshipType;
        if (this.relationshipType != null) {
            if (this.relationshipType instanceof NestedType) {
                NestedType nestedType = (NestedType)relationshipType;
                this.isNested = true;
                this.nestedPath = nestedType.path;
                this.isChildren = false;
                this.childType = "";
            } else if (relationshipType instanceof ChildrenType) {
                ChildrenType childrenType = (ChildrenType)relationshipType;
                this.isNested = false;
                this.nestedPath = "";
                this.isChildren = true;
                this.childType = childrenType.childType;
            }
        } else {
            this.isNested = false;
            this.nestedPath = "";
            this.isChildren = false;
            this.childType = "";
        }
        if (!org.opensearch.sql.legacy.domain.Condition$OPERATOR.operStringToOpear.containsKey(oper)) {
            throw new SqlParseException("Unsupported operation: " + oper);
        }
        this.OPERATOR = org.opensearch.sql.legacy.domain.Condition$OPERATOR.operStringToOpear.get(oper);
    }

    public Condition(Where.CONN conn, String name, SQLExpr nameExpr, OPERATOR oper, Object value, SQLExpr valueExpr, Object relationshipType) throws SqlParseException {
        super(conn);
        this.nameExpr = nameExpr;
        this.valueExpr = valueExpr;
        this.name = name;
        this.value = value;
        this.OPERATOR = oper;
        this.relationshipType = relationshipType;
        if (this.relationshipType != null) {
            if (this.relationshipType instanceof NestedType) {
                NestedType nestedType = (NestedType)relationshipType;
                this.isNested = true;
                this.nestedPath = nestedType.path;
                this.isChildren = false;
                this.childType = "";
            } else if (relationshipType instanceof ChildrenType) {
                ChildrenType childrenType = (ChildrenType)relationshipType;
                this.isNested = false;
                this.nestedPath = "";
                this.isChildren = true;
                this.childType = childrenType.childType;
            }
        } else {
            this.isNested = false;
            this.nestedPath = "";
            this.isChildren = false;
            this.childType = "";
        }
    }

    public String getOpertatorSymbol() throws SqlParseException {
        switch (this.OPERATOR.ordinal()) {
            case 0: {
                return "==";
            }
            case 1: {
                return ">";
            }
            case 2: {
                return "<";
            }
            case 3: {
                return ">=";
            }
            case 4: {
                return "<=";
            }
            case 5: {
                return "<>";
            }
            case 9: {
                return "==";
            }
            case 10: {
                return "!=";
            }
        }
        throw new SqlParseException(StringUtils.format("Failed to parse operator [%s]", new Object[]{this.OPERATOR}));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public OPERATOR getOPERATOR() {
        return this.OPERATOR;
    }

    public void setOPERATOR(OPERATOR OPERATOR2) {
        this.OPERATOR = OPERATOR2;
    }

    public Object getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(Object relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public void setNested(boolean isNested) {
        this.isNested = isNested;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public void setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
    }

    public boolean isChildren() {
        return this.isChildren;
    }

    public void setChildren(boolean isChildren) {
        this.isChildren = isChildren;
    }

    public String getChildType() {
        return this.childType;
    }

    public void setChildType(String childType) {
        this.childType = childType;
    }

    public boolean isNestedComplex() {
        return org.opensearch.sql.legacy.domain.Condition$OPERATOR.NESTED_COMPLEX == this.OPERATOR;
    }

    @Override
    public String toString() {
        Object result2 = "";
        if (this.isNested()) {
            result2 = "nested condition ";
            if (this.getNestedPath() != null) {
                result2 = (String)result2 + "on path:" + this.getNestedPath() + " ";
            }
        } else if (this.isChildren()) {
            result2 = "children condition ";
            if (this.getChildType() != null) {
                result2 = (String)result2 + "on child: " + this.getChildType() + " ";
            }
        }
        result2 = this.value instanceof Object[] ? (String)result2 + String.valueOf((Object)this.conn) + " " + this.name + " " + String.valueOf((Object)this.OPERATOR) + " " + Arrays.toString((Object[])this.value) : (String)result2 + String.valueOf((Object)this.conn) + " " + this.name + " " + String.valueOf((Object)this.OPERATOR) + " " + String.valueOf(this.value);
        return result2;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            return new Condition(this.getConn(), this.getName(), this.getNameExpr(), this.getOPERATOR(), this.getValue(), this.getValueExpr(), this.getRelationshipType());
        }
        catch (SqlParseException sqlParseException) {
            return null;
        }
    }

    public static enum OPERATOR {
        EQ,
        GT,
        LT,
        GTE,
        LTE,
        N,
        LIKE,
        NLIKE,
        REGEXP,
        IS,
        ISN,
        IN,
        NIN,
        BETWEEN,
        NBETWEEN,
        GEO_INTERSECTS,
        GEO_BOUNDING_BOX,
        GEO_DISTANCE,
        GEO_POLYGON,
        IN_TERMS,
        TERM,
        IDS_QUERY,
        NESTED_COMPLEX,
        NOT_EXISTS_NESTED_COMPLEX,
        CHILDREN_COMPLEX,
        SCRIPT,
        NIN_TERMS,
        NTERM,
        NREGEXP;

        public static final Map<String, OPERATOR> methodNameToOpear;
        public static final Map<String, OPERATOR> operStringToOpear;
        public static final Map<String, OPERATOR> simpleOperStringToOpear;
        private static final BiMap<OPERATOR, OPERATOR> negatives;
        private static final BiMap<OPERATOR, OPERATOR> simpleReverses;

        public OPERATOR negative() throws SqlParseException {
            OPERATOR negative = (OPERATOR)((Object)negatives.get((Object)this));
            OPERATOR oPERATOR = negative = negative != null ? negative : (OPERATOR)((Object)negatives.inverse().get((Object)this));
            if (negative == null) {
                throw new SqlParseException(StringUtils.format("Negative operator [%s] is not supported.", this.name()));
            }
            return negative;
        }

        public OPERATOR simpleReverse() throws SqlParseException {
            OPERATOR reverse = (OPERATOR)((Object)simpleReverses.get((Object)this));
            OPERATOR oPERATOR = reverse = reverse != null ? reverse : (OPERATOR)((Object)simpleReverses.inverse().get((Object)this));
            if (reverse == null) {
                throw new SqlParseException(StringUtils.format("Simple reverse operator [%s] is not supported.", this.name()));
            }
            return reverse;
        }

        public Boolean isSimpleOperator() {
            return simpleOperStringToOpear.containsValue((Object)this);
        }

        static {
            methodNameToOpear = new HashMap<String, OPERATOR>();
            methodNameToOpear.put("term", TERM);
            methodNameToOpear.put("matchterm", TERM);
            methodNameToOpear.put("match_term", TERM);
            methodNameToOpear.put("terms", IN_TERMS);
            methodNameToOpear.put("in_terms", IN_TERMS);
            methodNameToOpear.put("ids", IDS_QUERY);
            methodNameToOpear.put("ids_query", IDS_QUERY);
            methodNameToOpear.put("regexp", REGEXP);
            methodNameToOpear.put("regexp_query", REGEXP);
            operStringToOpear = new HashMap<String, OPERATOR>();
            operStringToOpear.put("=", EQ);
            operStringToOpear.put(">", GT);
            operStringToOpear.put("<", LT);
            operStringToOpear.put(">=", GTE);
            operStringToOpear.put("<=", LTE);
            operStringToOpear.put("<>", N);
            operStringToOpear.put("LIKE", LIKE);
            operStringToOpear.put("NOT", N);
            operStringToOpear.put("NOT LIKE", NLIKE);
            operStringToOpear.put("IS", IS);
            operStringToOpear.put("IS NOT", ISN);
            operStringToOpear.put("IN", IN);
            operStringToOpear.put("NOT IN", NIN);
            operStringToOpear.put("BETWEEN", BETWEEN);
            operStringToOpear.put("NOT BETWEEN", NBETWEEN);
            operStringToOpear.put("GEO_INTERSECTS", GEO_INTERSECTS);
            operStringToOpear.put("GEO_BOUNDING_BOX", GEO_BOUNDING_BOX);
            operStringToOpear.put("GEO_DISTANCE", GEO_DISTANCE);
            operStringToOpear.put("GEO_POLYGON", GEO_POLYGON);
            operStringToOpear.put("NESTED", NESTED_COMPLEX);
            operStringToOpear.put("CHILDREN", CHILDREN_COMPLEX);
            operStringToOpear.put("SCRIPT", SCRIPT);
            simpleOperStringToOpear = new HashMap<String, OPERATOR>();
            simpleOperStringToOpear.put("=", EQ);
            simpleOperStringToOpear.put(">", GT);
            simpleOperStringToOpear.put("<", LT);
            simpleOperStringToOpear.put(">=", GTE);
            simpleOperStringToOpear.put("<=", LTE);
            simpleOperStringToOpear.put("<>", N);
            negatives = HashBiMap.create(7);
            negatives.put(EQ, N);
            negatives.put(IN_TERMS, NIN_TERMS);
            negatives.put(TERM, NTERM);
            negatives.put(GT, LTE);
            negatives.put(LT, GTE);
            negatives.put(LIKE, NLIKE);
            negatives.put(IS, ISN);
            negatives.put(IN, NIN);
            negatives.put(BETWEEN, NBETWEEN);
            negatives.put(NESTED_COMPLEX, NOT_EXISTS_NESTED_COMPLEX);
            negatives.put(REGEXP, NREGEXP);
            simpleReverses = HashBiMap.create(4);
            simpleReverses.put(EQ, EQ);
            simpleReverses.put(GT, LT);
            simpleReverses.put(GTE, LTE);
            simpleReverses.put(N, N);
        }
    }
}

