/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.document.DocumentField;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.filter.InternalFilter;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.LongTerms;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.opensearch.search.aggregations.metrics.InternalTopHits;
import org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.exception.SqlParseException;

public class SearchResult {
    private List<Map<String, Object>> results;
    private long total;
    double maxScore = 0.0;

    public SearchResult(SearchResponse resp) {
        SearchHits hits = resp.getHits();
        this.total = Optional.ofNullable(hits.getTotalHits()).map(totalHits -> totalHits.value()).orElse(0L);
        this.results = new ArrayList<Map<String, Object>>(hits.getHits().length);
        for (SearchHit searchHit : hits.getHits()) {
            if (searchHit.getSourceAsMap() != null) {
                this.results.add(searchHit.getSourceAsMap());
                continue;
            }
            if (searchHit.getFields() == null) continue;
            Map fields2 = searchHit.getFields();
            this.results.add(this.toFieldsMap(fields2));
        }
    }

    public SearchResult(SearchResponse resp, Select select) throws SqlParseException {
        Aggregations aggs = resp.getAggregations();
        if (aggs.get("filter") != null) {
            InternalFilter inf = (InternalFilter)aggs.get("filter");
            aggs = inf.getAggregations();
        }
        if (aggs.get("group by") != null) {
            InternalTerms terms = (InternalTerms)aggs.get("group by");
            List buckets = terms.getBuckets();
            this.total = buckets.size();
            this.results = new ArrayList<Map<String, Object>>(buckets.size());
            for (Terms.Bucket bucket : buckets) {
                Map<String, Object> aggsMap = this.toAggsMap(bucket.getAggregations().getAsMap());
                aggsMap.put("docCount", bucket.getDocCount());
                this.results.add(aggsMap);
            }
        } else {
            this.results = new ArrayList<Map<String, Object>>(1);
            this.total = 1L;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Aggregation aggregation : aggs) {
                map.put(aggregation.getName(), this.covenValue(aggregation));
            }
            this.results.add(map);
        }
    }

    private Map<String, Object> toFieldsMap(Map<String, DocumentField> fields2) {
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        for (Map.Entry<String, DocumentField> entry : fields2.entrySet()) {
            if (entry.getValue().getValues().size() > 1) {
                result2.put(entry.getKey(), entry.getValue().getValues());
                continue;
            }
            result2.put(entry.getKey(), entry.getValue().getValue());
        }
        return result2;
    }

    private Map<String, Object> toAggsMap(Map<String, Aggregation> fields2) throws SqlParseException {
        HashMap<String, Object> result2 = new HashMap<String, Object>();
        for (Map.Entry<String, Aggregation> entry : fields2.entrySet()) {
            result2.put(entry.getKey(), this.covenValue(entry.getValue()));
        }
        return result2;
    }

    private Object covenValue(Aggregation value) throws SqlParseException {
        if (value instanceof InternalNumericMetricsAggregation.SingleValue) {
            return ((InternalNumericMetricsAggregation.SingleValue)value).value();
        }
        if (value instanceof InternalValueCount) {
            return ((InternalValueCount)value).getValue();
        }
        if (value instanceof InternalTopHits) {
            return value;
        }
        if (value instanceof LongTerms) {
            return value;
        }
        throw new SqlParseException("Unknown aggregation value type: " + value.getClass().getSimpleName());
    }

    public List<Map<String, Object>> getResults() {
        return this.results;
    }

    public void setResults(List<Map<String, Object>> results) {
        this.results = results;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public double getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(double maxScore) {
        this.maxScore = maxScore;
    }
}

