/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchAliasType;
import org.opensearch.sql.opensearch.data.type.OpenSearchBinaryType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDateType;
import org.opensearch.sql.opensearch.data.type.OpenSearchGeoPointType;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import shaded.com.google.common.collect.ImmutableMap;

public class OpenSearchDataType
implements ExprType,
Serializable {
    protected MappingType mappingType;
    protected ExprCoreType exprCoreType;
    private static final Map<String, OpenSearchDataType> instances = new HashMap<String, OpenSearchDataType>();
    Map<String, OpenSearchDataType> properties = ImmutableMap.of();

    public ExprType getExprType() {
        return this.exprCoreType == ExprCoreType.DATE || this.exprCoreType == ExprCoreType.TIMESTAMP || this.exprCoreType == ExprCoreType.TIME || this.exprCoreType == ExprCoreType.UNKNOWN ? this : this.exprCoreType;
    }

    public static Map<String, OpenSearchDataType> parseMapping(Map<String, Object> indexMapping) {
        LinkedHashMap<String, OpenSearchDataType> result2 = new LinkedHashMap<String, OpenSearchDataType>();
        if (indexMapping == null) {
            return result2;
        }
        LinkedHashMap<String, String> aliasMapping = new LinkedHashMap<String, String>();
        indexMapping.forEach((k, v) -> {
            Map innerMap = (Map)v;
            String type2 = innerMap.getOrDefault("type", "object").replace("_", "");
            if (!EnumUtils.isValidEnumIgnoreCase(MappingType.class, type2)) {
                if ("alias".equals(type2)) {
                    aliasMapping.put((String)k, (String)innerMap.get("path"));
                }
                return;
            }
            result2.put((String)k, OpenSearchDataType.of(EnumUtils.getEnumIgnoreCase(MappingType.class, type2), innerMap));
        });
        if (!aliasMapping.isEmpty()) {
            Map<String, OpenSearchDataType> flattenResult = OpenSearchDataType.traverseAndFlatten(result2);
            aliasMapping.forEach((k, v) -> {
                if (!flattenResult.containsKey(v)) {
                    throw new IllegalStateException(String.format("Cannot find the path [%s] for alias type field [%s]", v, k));
                }
                result2.put((String)k, new OpenSearchAliasType((String)v, (OpenSearchDataType)flattenResult.get(v)));
            });
        }
        return result2;
    }

    public static OpenSearchDataType of(MappingType mappingType, Map<String, Object> innerMap) {
        OpenSearchDataType res = instances.getOrDefault(mappingType.toString(), new OpenSearchDataType(mappingType));
        switch (mappingType.ordinal()) {
            case 9: 
            case 10: {
                if (innerMap.isEmpty()) {
                    return res;
                }
                Map<String, OpenSearchDataType> properties2 = OpenSearchDataType.parseMapping(innerMap.getOrDefault("properties", Map.of()));
                OpenSearchDataType objectDataType = res.cloneEmpty();
                objectDataType.properties = properties2;
                return objectDataType;
            }
            case 1: 
            case 2: {
                Map<String, OpenSearchDataType> fields2 = OpenSearchDataType.parseMapping(innerMap.getOrDefault("fields", Map.of()));
                return !fields2.isEmpty() ? OpenSearchTextType.of(fields2) : OpenSearchTextType.of();
            }
            case 5: {
                return OpenSearchGeoPointType.of();
            }
            case 6: {
                return OpenSearchBinaryType.of();
            }
            case 7: 
            case 8: {
                String format = (String)innerMap.getOrDefault("format", "");
                return OpenSearchDateType.of(format);
            }
        }
        return res;
    }

    public static OpenSearchDataType of(MappingType mappingType) {
        return OpenSearchDataType.of(mappingType, Map.of());
    }

    public static OpenSearchDataType of(ExprType type2) {
        if (type2 instanceof OpenSearchDataType) {
            return (OpenSearchDataType)type2;
        }
        OpenSearchDataType res = instances.getOrDefault(type2.toString(), null);
        if (res != null) {
            return res;
        }
        if (OpenSearchDateType.isDateTypeCompatible(type2)) {
            return OpenSearchDateType.of(type2);
        }
        return new OpenSearchDataType((ExprCoreType)type2);
    }

    protected OpenSearchDataType(MappingType mappingType) {
        this.mappingType = mappingType;
        this.exprCoreType = mappingType.getExprCoreType();
    }

    protected OpenSearchDataType(ExprCoreType type2) {
        this.exprCoreType = type2;
    }

    @Override
    public String typeName() {
        if (this.legacyTypeName().equals("TEXT")) {
            return "STRING";
        }
        return this.legacyTypeName();
    }

    @Override
    public String legacyTypeName() {
        if (this.mappingType == null) {
            return this.exprCoreType.typeName();
        }
        if (this.mappingType.toString().equalsIgnoreCase("DATE")) {
            return this.exprCoreType.typeName();
        }
        return this.mappingType.toString().toUpperCase();
    }

    protected OpenSearchDataType cloneEmpty() {
        return this.mappingType == null ? new OpenSearchDataType(this.exprCoreType) : new OpenSearchDataType(this.mappingType);
    }

    public static Map<String, OpenSearchDataType> traverseAndFlatten(Map<String, OpenSearchDataType> tree) {
        final LinkedHashMap<String, OpenSearchDataType> result2 = new LinkedHashMap<String, OpenSearchDataType>();
        BiConsumer<Map<String, OpenSearchDataType>, String> visitLevel = new BiConsumer<Map<String, OpenSearchDataType>, String>(){

            @Override
            public void accept(Map<String, OpenSearchDataType> subtree, String prefix) {
                for (Map.Entry<String, OpenSearchDataType> entry : subtree.entrySet()) {
                    String entryKey = entry.getKey();
                    String nextPrefix = prefix.isEmpty() ? entryKey : String.format("%s.%s", prefix, entryKey);
                    result2.put(nextPrefix, entry.getValue().cloneEmpty());
                    Map<String, OpenSearchDataType> nextSubtree = entry.getValue().getProperties();
                    if (nextSubtree.isEmpty()) continue;
                    this.accept(nextSubtree, nextPrefix);
                }
            }
        };
        visitLevel.accept(tree, "");
        return result2;
    }

    public static OpenSearchDataType resolve(Map<String, OpenSearchDataType> tree, String id) {
        for (Map.Entry<String, OpenSearchDataType> item : tree.entrySet()) {
            if (item.getKey().equals(id)) {
                return item.getValue();
            }
            OpenSearchDataType result2 = OpenSearchDataType.resolve(item.getValue().getProperties(), id);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchDataType)) {
            return false;
        }
        OpenSearchDataType other = (OpenSearchDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExprCoreType this$exprCoreType = this.getExprCoreType();
        ExprCoreType other$exprCoreType = other.getExprCoreType();
        return !(this$exprCoreType == null ? other$exprCoreType != null : !this$exprCoreType.equals(other$exprCoreType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchDataType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        ExprCoreType $exprCoreType = this.getExprCoreType();
        result2 = result2 * 59 + ($exprCoreType == null ? 43 : $exprCoreType.hashCode());
        return result2;
    }

    @Generated
    public MappingType getMappingType() {
        return this.mappingType;
    }

    @Generated
    public ExprCoreType getExprCoreType() {
        return this.exprCoreType;
    }

    @Generated
    public Map<String, OpenSearchDataType> getProperties() {
        return this.properties;
    }

    static {
        EnumUtils.getEnumList(MappingType.class).stream().filter(t2 -> t2 != MappingType.Invalid).forEach(t2 -> instances.put(t2.toString(), OpenSearchDataType.of(t2)));
        EnumUtils.getEnumList(ExprCoreType.class).forEach(t2 -> instances.put(t2.toString(), OpenSearchDataType.of(t2)));
    }

    public static enum MappingType {
        Invalid(null, ExprCoreType.UNKNOWN),
        Text("text", ExprCoreType.UNKNOWN),
        MatchOnlyText("match_only_text", ExprCoreType.UNKNOWN),
        Keyword("keyword", ExprCoreType.STRING),
        Ip("ip", ExprCoreType.IP),
        GeoPoint("geo_point", ExprCoreType.UNKNOWN),
        Binary("binary", ExprCoreType.UNKNOWN),
        Date("date", ExprCoreType.TIMESTAMP),
        DateNanos("date_nanos", ExprCoreType.TIMESTAMP),
        Object("object", ExprCoreType.STRUCT),
        Nested("nested", ExprCoreType.ARRAY),
        Byte("byte", ExprCoreType.BYTE),
        Short("short", ExprCoreType.SHORT),
        Integer("integer", ExprCoreType.INTEGER),
        Long("long", ExprCoreType.LONG),
        Float("float", ExprCoreType.FLOAT),
        HalfFloat("half_float", ExprCoreType.FLOAT),
        ScaledFloat("scaled_float", ExprCoreType.DOUBLE),
        Double("double", ExprCoreType.DOUBLE),
        Boolean("boolean", ExprCoreType.BOOLEAN);

        private final String name;
        private final ExprCoreType exprCoreType;

        private MappingType(String name, ExprCoreType exprCoreType) {
            this.name = name;
            this.exprCoreType = exprCoreType;
        }

        public String toString() {
            return this.name;
        }

        @Generated
        public ExprCoreType getExprCoreType() {
            return this.exprCoreType;
        }
    }
}

