/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.serde;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.externalize.RelEnumTypes;
import org.apache.calcite.rel.externalize.RelJson;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.rex.RexWindowExclusion;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsertKeyword;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.opensearch.sql.calcite.type.AbstractExprRelDataType;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class ExtendedRelJson
extends RelJson {
    private final JsonBuilder jsonBuilder;
    private final RelJson.InputTranslator inputTranslator;
    private final SqlOperatorTable operatorTable;
    private static final ImmutableMap<String, Enum<?>> ENUM_BY_NAME;

    private static void registerEnum(ImmutableMap.Builder<String, Enum<?>> builder, Class<? extends Enum<?>> enumClass) {
        for (Enum<?> enumConstant : enumClass.getEnumConstants()) {
            builder.put(enumConstant.name(), enumConstant);
        }
    }

    private ExtendedRelJson(JsonBuilder jsonBuilder) {
        super(jsonBuilder);
        this.jsonBuilder = jsonBuilder;
        this.inputTranslator = null;
        this.operatorTable = SqlStdOperatorTable.instance();
    }

    private ExtendedRelJson(@Nullable JsonBuilder jsonBuilder, RelJson.InputTranslator inputTranslator, SqlOperatorTable operatorTable) {
        super(jsonBuilder);
        this.jsonBuilder = jsonBuilder;
        this.inputTranslator = Objects.requireNonNull(inputTranslator, "inputTranslator");
        this.operatorTable = Objects.requireNonNull(operatorTable, "operatorTable");
    }

    public static ExtendedRelJson create(JsonBuilder jsonBuilder) {
        return new ExtendedRelJson(jsonBuilder);
    }

    @Override
    public RelJson withInputTranslator(RelJson.InputTranslator inputTranslator) {
        if (inputTranslator == this.inputTranslator) {
            return this;
        }
        return new ExtendedRelJson(this.jsonBuilder, inputTranslator, this.operatorTable);
    }

    @Override
    public RelJson withOperatorTable(SqlOperatorTable operatorTable) {
        if (operatorTable == this.operatorTable) {
            return this;
        }
        return new ExtendedRelJson(this.jsonBuilder, this.inputTranslator, operatorTable);
    }

    @Override
    public @Nullable Object toJson(@Nullable Object value) {
        if (value instanceof RelDataTypeField) {
            return this.toJson((RelDataTypeField)value);
        }
        if (value instanceof RelDataType) {
            return this.toJson((RelDataType)value);
        }
        return super.toJson(value);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Object toJson(RexNode node) {
        switch (node.getKind()) {
            case DYNAMIC_PARAM: {
                Map<String, @Nullable Object> map = this.jsonBuilder().map();
                RexDynamicParam rexDynamicParam = (RexDynamicParam)node;
                RelDataType rdpType = rexDynamicParam.getType();
                map.put("dynamicParam", rexDynamicParam.getIndex());
                map.put("type", this.toJson(rdpType));
                return map;
            }
            case FIELD_ACCESS: {
                Map<String, @Nullable Object> map = this.jsonBuilder().map();
                RexFieldAccess fieldAccess = (RexFieldAccess)node;
                map.put("field", fieldAccess.getField().getName());
                map.put("expr", this.toJson(fieldAccess.getReferenceExpr()));
                return map;
            }
            case LITERAL: {
                RexLiteral literal = (RexLiteral)node;
                Object value = literal.getValue3();
                Map<String, @Nullable Object> map = this.jsonBuilder().map();
                map.put("literal", value instanceof Enum ? RelEnumTypes.fromEnum((Enum)value) : this.toJson(value));
                map.put("type", this.toJson(node.getType()));
                return map;
            }
            case INPUT_REF: {
                @Nullable Map map = (Map)super.toJson(node);
                return map;
            }
            case LOCAL_REF: {
                Map<String, @Nullable Object> map = this.jsonBuilder().map();
                map.put("input", ((RexSlot)node).getIndex());
                map.put("name", ((RexSlot)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
            case CORREL_VARIABLE: {
                Map<String, @Nullable Object> map = this.jsonBuilder().map();
                map.put("correl", ((RexCorrelVariable)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            Map<String, @Nullable Object> map = this.jsonBuilder().map();
            map.put("op", this.toJson(call.getOperator()));
            List<@Nullable Object> list = this.jsonBuilder().list();
            for (RexNode operand : call.getOperands()) {
                list.add(this.toJson(operand));
            }
            map.put("operands", list);
            switch (node.getKind()) {
                case MINUS: 
                case CAST: 
                case SAFE_CAST: {
                    map.put("type", this.toJson(node.getType()));
                    break;
                }
            }
            if (call.getOperator() instanceof SqlFunction && ((SqlFunction)call.getOperator()).getFunctionType().isUserDefined()) {
                SqlOperator op = call.getOperator();
                map.put("class", op.getClass().getName());
                map.put("type", this.toJson(node.getType()));
                map.put("deterministic", op.isDeterministic());
                map.put("dynamic", op.isDynamicFunction());
            }
            if (call instanceof RexOver) {
                RexOver over = (RexOver)call;
                map.put("distinct", over.isDistinct());
                map.put("type", this.toJson(node.getType()));
                map.put("window", this.toJson(over.getWindow()));
            }
            return map;
        }
        throw new UnsupportedOperationException("unknown rex " + String.valueOf(node));
    }

    private Object toJson(RelDataTypeField node) {
        Map map;
        if (node.getType().isStruct()) {
            map = this.jsonBuilder().map();
            map.put("fields", this.toJson(node.getType()));
            map.put("nullable", node.getType().isNullable());
        } else {
            map = (Map)this.toJson(node.getType());
        }
        map.put("name", node.getName());
        return map;
    }

    private Object toJson(RelDataType node) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        if (node.isStruct()) {
            List<@Nullable Object> list = this.jsonBuilder().list();
            for (RelDataTypeField field : node.getFieldList()) {
                list.add(this.toJson(field));
            }
            map.put("fields", list);
            map.put("nullable", node.isNullable());
        } else {
            RelDataType valueType;
            RelDataType keyType;
            if (node instanceof AbstractExprRelDataType) {
                map.put("udt", ((AbstractExprRelDataType)node).getUdt().name());
            }
            map.put("type", node.getSqlTypeName().name());
            map.put("nullable", node.isNullable());
            if (node.getComponentType() != null) {
                map.put("component", this.toJson(node.getComponentType()));
            }
            if ((keyType = node.getKeyType()) != null) {
                map.put("key", this.toJson(keyType));
            }
            if ((valueType = node.getValueType()) != null) {
                map.put("value", this.toJson(valueType));
            }
            if (node.getSqlTypeName().allowsPrec()) {
                map.put("precision", node.getPrecision());
            }
            if (node.getSqlTypeName().allowsScale()) {
                map.put("scale", node.getScale());
            }
        }
        return map;
    }

    private Map<String, @Nullable Object> toJson(SqlOperator operator) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        map.put("name", operator.getName());
        map.put("kind", operator.kind.toString());
        map.put("syntax", operator.getSyntax().toString());
        return map;
    }

    private Object toJson(RexWindow window) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        if (!window.partitionKeys.isEmpty()) {
            map.put("partition", this.toJson(window.partitionKeys));
        }
        if (!window.orderKeys.isEmpty()) {
            map.put("order", this.toJson(window.orderKeys));
        }
        if (window.getLowerBound() != null) {
            if (window.getUpperBound() == null) {
                if (window.isRows()) {
                    map.put("rows-lower", this.toJson(window.getLowerBound()));
                } else {
                    map.put("range-lower", this.toJson(window.getLowerBound()));
                }
            } else if (window.isRows()) {
                map.put("rows-lower", this.toJson(window.getLowerBound()));
                map.put("rows-upper", this.toJson(window.getUpperBound()));
            } else {
                map.put("range-lower", this.toJson(window.getLowerBound()));
                map.put("range-upper", this.toJson(window.getUpperBound()));
            }
        }
        return map;
    }

    @Override
    public RelDataType toType(RelDataTypeFactory typeFactory, Object o) {
        if (o instanceof Map && ((Map)o).containsKey("udt") && typeFactory instanceof OpenSearchTypeFactory) {
            Object udtName = ((Map)o).get("udt");
            OpenSearchTypeFactory.ExprUDT udt = OpenSearchTypeFactory.ExprUDT.valueOf((String)udtName);
            return ((OpenSearchTypeFactory)typeFactory).createUDT(udt);
        }
        return super.toType(typeFactory, o);
    }

    @Override
    public RexNode toRex(RelOptCluster cluster, Object o) {
        RelInputForCluster input = new RelInputForCluster(cluster);
        return this.toRex(input, o);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @PolyNull RexNode toRex(RelInput relInput, @PolyNull Object o) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (o == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            @Nullable Map map = (Map)o;
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            if (map.containsKey("op")) {
                @Nullable Map opMap = (Map)ExtendedRelJson.get(map, "op");
                if (map.containsKey("class")) {
                    opMap.put("class", ExtendedRelJson.get(map, "class"));
                }
                List operands = (List)ExtendedRelJson.get(map, "operands");
                List<RexNode> rexOperands = this.toRexList(relInput, operands);
                Object jsonType = map.get("type");
                Map window = (Map)map.get("window");
                if (window != null) {
                    boolean physical;
                    RexWindowBound upperBound;
                    RexWindowBound lowerBound;
                    SqlAggFunction operator = Objects.requireNonNull(this.toAggregation(opMap), "operator");
                    RelDataType type2 = this.toType(typeFactory, Objects.requireNonNull(jsonType, "jsonType"));
                    ArrayList<RexNode> partitionKeys = new ArrayList();
                    Object partition = window.get("partition");
                    if (partition != null) {
                        partitionKeys = this.toRexList(relInput, (List)partition);
                    }
                    ArrayList<RexFieldCollation> orderKeys = new ArrayList<RexFieldCollation>();
                    if (window.containsKey("order")) {
                        this.addRexFieldCollationList(orderKeys, relInput, (List)window.get("order"));
                    }
                    if (window.get("rows-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("rows-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("rows-upper"));
                        physical = true;
                    } else if (window.get("range-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("range-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("range-upper"));
                        physical = false;
                    } else {
                        lowerBound = null;
                        upperBound = null;
                        physical = false;
                    }
                    RexWindowExclusion exclude = window.get("exclude") != null ? ExtendedRelJson.toRexWindowExclusion((Map)window.get("exclude")) : RexWindowExclusion.EXCLUDE_NO_OTHER;
                    boolean distinct2 = (Boolean)ExtendedRelJson.get(map, "distinct");
                    return rexBuilder.makeOver(type2, operator, rexOperands, partitionKeys, ImmutableList.copyOf(orderKeys), Objects.requireNonNull(lowerBound, "lowerBound"), Objects.requireNonNull(upperBound, "upperBound"), Objects.requireNonNull(exclude, "exclude"), physical, true, false, distinct2, false);
                }
                SqlOperator operator = Objects.requireNonNull(this.toOp(opMap), "operator");
                RelDataType type3 = jsonType != null ? this.toType(typeFactory, jsonType) : rexBuilder.deriveReturnType(operator, rexOperands);
                return rexBuilder.makeCall(type3, operator, rexOperands);
            }
            Integer input = (Integer)map.get("input");
            if (input != null) {
                return this.inputTranslator.translateInput(this, input, map, relInput);
            }
            String field = (String)map.get("field");
            if (field != null) {
                Object jsonExpr = ExtendedRelJson.get(map, "expr");
                RexNode expr = this.toRex(relInput, jsonExpr);
                return rexBuilder.makeFieldAccess(expr, field, true);
            }
            String correl = (String)map.get("correl");
            if (correl != null) {
                Object jsonType = ExtendedRelJson.get(map, "type");
                RelDataType type4 = this.toType(typeFactory, jsonType);
                return rexBuilder.makeCorrel(type4, new CorrelationId(correl));
            }
            if (map.containsKey("literal")) {
                Object literal = map.get("literal");
                if (literal == null) {
                    RelDataType type5 = this.toType(typeFactory, ExtendedRelJson.get(map, "type"));
                    return rexBuilder.makeNullLiteral(type5);
                }
                if (!map.containsKey("type")) {
                    return this.toRex(relInput, literal);
                }
                RelDataType type6 = this.toType(typeFactory, ExtendedRelJson.get(map, "type"));
                if (literal instanceof Map && ((Map)literal).containsKey("rangeSet")) {
                    Sarg sarg = ExtendedRelJson.sargFromJson((Map)literal);
                    return rexBuilder.makeSearchArgumentLiteral(sarg, type6);
                }
                if (type6.getSqlTypeName() == SqlTypeName.SYMBOL) {
                    literal = ExtendedRelJson.toEnum((String)literal);
                }
                return rexBuilder.makeLiteral(literal, type6);
            }
            if (map.containsKey("sargLiteral")) {
                Object sargObject = map.get("sargLiteral");
                if (sargObject == null) {
                    RelDataType type7 = this.toType(typeFactory, ExtendedRelJson.get(map, "type"));
                    return rexBuilder.makeNullLiteral(type7);
                }
                RelDataType type8 = this.toType(typeFactory, ExtendedRelJson.get(map, "type"));
                Sarg sarg = ExtendedRelJson.sargFromJson((Map)sargObject);
                return rexBuilder.makeSearchArgumentLiteral(sarg, type8);
            }
            if (map.containsKey("dynamicParam")) {
                Object dynamicParamObject = Objects.requireNonNull(map.get("dynamicParam"));
                Integer index = (Integer)dynamicParamObject;
                RelDataType type9 = this.toType(typeFactory, ExtendedRelJson.get(map, "type"));
                return rexBuilder.makeDynamicParam(type9, index);
            }
            throw new UnsupportedOperationException("cannot convert to rex " + String.valueOf(o));
        }
        if (o instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)o);
        }
        if (o instanceof String) {
            return rexBuilder.makeLiteral((String)o);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Double || number instanceof Float) {
                return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number.doubleValue()));
            }
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(number.longValue()));
        }
        throw new UnsupportedOperationException("cannot convert to rex " + String.valueOf(o));
    }

    private JsonBuilder jsonBuilder() {
        return Objects.requireNonNull(this.jsonBuilder, "jsonBuilder");
    }

    private static <T> T get(Map<String, ? extends @Nullable Object> map, String key) {
        return (T)Objects.requireNonNull(map.get(key), () -> "entry for key " + key);
    }

    @Nullable SqlOperator toOp(Map<String, ? extends @Nullable Object> map) {
        String name = (String)ExtendedRelJson.get(map, "name");
        String kind = (String)ExtendedRelJson.get(map, "kind");
        String syntax = (String)ExtendedRelJson.get(map, "syntax");
        SqlKind sqlKind = SqlKind.valueOf(kind);
        SqlSyntax sqlSyntax = SqlSyntax.valueOf(syntax);
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        this.operatorTable.lookupOperatorOverloads(new SqlIdentifier(name, SqlParserPos.ZERO), null, sqlSyntax, operators, SqlNameMatchers.liberal());
        for (SqlOperator operator : operators) {
            if (operator.kind != sqlKind) continue;
            return operator;
        }
        String class_ = (String)map.get("class");
        if (class_ != null) {
            return AvaticaUtils.instantiatePlugin(SqlOperator.class, class_);
        }
        throw Static.RESOURCE.noOperator(name, kind, syntax).ex();
    }

    @Nullable SqlAggFunction toAggregation(Map<String, ? extends @Nullable Object> map) {
        return (SqlAggFunction)this.toOp(map);
    }

    private List<RexNode> toRexList(RelInput relInput, List operands) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (Object operand : operands) {
            list.add(this.toRex(relInput, operand));
        }
        return list;
    }

    private void addRexFieldCollationList(List<RexFieldCollation> list, RelInput relInput, @Nullable List<Map<String, Object>> order) {
        if (order == null) {
            return;
        }
        for (Map<String, Object> o : order) {
            RexNode expr = Objects.requireNonNull(this.toRex(relInput, o.get("expr")), "expr");
            HashSet<SqlKind> directions = new HashSet<SqlKind>();
            if (RelFieldCollation.Direction.valueOf((String)ExtendedRelJson.get(o, "direction")) == RelFieldCollation.Direction.DESCENDING) {
                directions.add(SqlKind.DESCENDING);
            }
            if (RelFieldCollation.NullDirection.valueOf((String)ExtendedRelJson.get(o, "null-direction")) == RelFieldCollation.NullDirection.FIRST) {
                directions.add(SqlKind.NULLS_FIRST);
            } else {
                directions.add(SqlKind.NULLS_LAST);
            }
            list.add(new RexFieldCollation(expr, (Set<SqlKind>)directions));
        }
    }

    private static <E extends Enum<E>> E toEnum(String name) {
        return (E)Objects.requireNonNull(ENUM_BY_NAME.get(name), () -> "No enum registered for name: " + name);
    }

    private @Nullable RexWindowBound toRexWindowBound(RelInput relInput, @Nullable Map<String, Object> map) {
        String type2;
        if (map == null) {
            return null;
        }
        switch (type2 = (String)ExtendedRelJson.get(map, "type")) {
            case "CURRENT_ROW": {
                return RexWindowBounds.CURRENT_ROW;
            }
            case "UNBOUNDED_PRECEDING": {
                return RexWindowBounds.UNBOUNDED_PRECEDING;
            }
            case "UNBOUNDED_FOLLOWING": {
                return RexWindowBounds.UNBOUNDED_FOLLOWING;
            }
            case "PRECEDING": {
                return RexWindowBounds.preceding(this.toRex(relInput, ExtendedRelJson.get(map, "offset")));
            }
            case "FOLLOWING": {
                return RexWindowBounds.following(this.toRex(relInput, ExtendedRelJson.get(map, "offset")));
            }
        }
        throw new UnsupportedOperationException("cannot convert " + type2 + " to rex window bound");
    }

    private static @Nullable RexWindowExclusion toRexWindowExclusion(@Nullable Map<String, Object> map) {
        String type2;
        if (map == null) {
            return null;
        }
        switch (type2 = (String)ExtendedRelJson.get(map, "type")) {
            case "CURRENT_ROW": {
                return RexWindowExclusion.EXCLUDE_CURRENT_ROW;
            }
            case "GROUP": {
                return RexWindowExclusion.EXCLUDE_GROUP;
            }
            case "TIES": {
                return RexWindowExclusion.EXCLUDE_TIES;
            }
            case "NO OTHERS": {
                return RexWindowExclusion.EXCLUDE_NO_OTHER;
            }
        }
        throw new UnsupportedOperationException("cannot convert " + type2 + " to rex window exclusion");
    }

    static {
        ImmutableMap.Builder<String, Enum<?>> enumByName = ImmutableMap.builder();
        ExtendedRelJson.registerEnum(enumByName, JoinConditionType.class);
        ExtendedRelJson.registerEnum(enumByName, JoinType.class);
        ExtendedRelJson.registerEnum(enumByName, RexUnknownAs.class);
        ExtendedRelJson.registerEnum(enumByName, SqlExplain.Depth.class);
        ExtendedRelJson.registerEnum(enumByName, SqlExplainFormat.class);
        ExtendedRelJson.registerEnum(enumByName, SqlExplainLevel.class);
        ExtendedRelJson.registerEnum(enumByName, SqlInsertKeyword.class);
        ExtendedRelJson.registerEnum(enumByName, SqlJsonConstructorNullClause.class);
        ExtendedRelJson.registerEnum(enumByName, SqlJsonQueryWrapperBehavior.class);
        ExtendedRelJson.registerEnum(enumByName, SqlJsonValueEmptyOrErrorBehavior.class);
        ExtendedRelJson.registerEnum(enumByName, SqlMatchRecognize.AfterOption.class);
        ExtendedRelJson.registerEnum(enumByName, SqlSelectKeyword.class);
        ExtendedRelJson.registerEnum(enumByName, SqlTrimFunction.Flag.class);
        ExtendedRelJson.registerEnum(enumByName, TimeUnitRange.class);
        ExtendedRelJson.registerEnum(enumByName, TableModify.Operation.class);
        ENUM_BY_NAME = enumByName.build();
    }

    private static class RelInputForCluster
    implements RelInput {
        private final RelOptCluster cluster;

        RelInputForCluster(RelOptCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public RelOptCluster getCluster() {
            return this.cluster;
        }

        @Override
        public RelTraitSet getTraitSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelOptTable getTable(String table) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelNode getInput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<RelNode> getInputs() {
            return ImmutableList.of();
        }

        @Override
        public @Nullable RexNode getExpression(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableBitSet getBitSet(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<ImmutableBitSet> getBitSetList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AggregateCall> getAggregateCalls(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object get(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable String getString(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getFloat(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal getBigDecimal(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <E extends Enum<E>> @Nullable E getEnum(String tag, Class<E> enumClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<RexNode> getExpressionList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<String> getStringList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<Integer> getIntegerList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<List<Integer>> getIntegerListList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelDataType getRowType(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelDataType getRowType(String expressionsTag, String fieldsTag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelCollation getCollation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelDistribution getDistribution() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<ImmutableList<RexLiteral>> getTuples(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getBoolean(String tag, boolean default_) {
            throw new UnsupportedOperationException();
        }
    }
}

