/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.request.system;

import java.io.IOException;
import java.security.AccessController;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.DataSourceSchemaName;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.model.MetricMetadata;
import org.opensearch.sql.prometheus.request.system.PrometheusSystemRequest;

public class PrometheusListMetricsRequest
implements PrometheusSystemRequest {
    private final PrometheusClient prometheusClient;
    private final DataSourceSchemaName dataSourceSchemaName;
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public List<ExprValue> search() {
        return AccessController.doPrivileged(() -> {
            try {
                Map<String, List<MetricMetadata>> result2 = this.prometheusClient.getAllMetrics();
                return result2.keySet().stream().map(x -> {
                    MetricMetadata metricMetadata = (MetricMetadata)((List)result2.get(x)).get(0);
                    return this.row((String)x, metricMetadata.getType(), metricMetadata.getUnit(), metricMetadata.getHelp());
                }).collect(Collectors.toList());
            }
            catch (IOException e) {
                LOG.error("Error while fetching metric list for from prometheus: {}", (Object)e.getMessage());
                throw new RuntimeException(String.format("Error while fetching metric list for from prometheus: %s", e.getMessage()));
            }
        });
    }

    private ExprTupleValue row(String metricName, String tableType, String unit, String help) {
        LinkedHashMap<String, ExprValue> valueMap = new LinkedHashMap<String, ExprValue>();
        valueMap.put("TABLE_CATALOG", ExprValueUtils.stringValue(this.dataSourceSchemaName.getDataSourceName()));
        valueMap.put("TABLE_SCHEMA", ExprValueUtils.stringValue("default"));
        valueMap.put("TABLE_NAME", ExprValueUtils.stringValue(metricName));
        valueMap.put("TABLE_TYPE", ExprValueUtils.stringValue(tableType));
        valueMap.put("UNIT", ExprValueUtils.stringValue(unit));
        valueMap.put("REMARKS", ExprValueUtils.stringValue(help));
        return new ExprTupleValue(valueMap);
    }

    @Generated
    public PrometheusListMetricsRequest(PrometheusClient prometheusClient, DataSourceSchemaName dataSourceSchemaName) {
        this.prometheusClient = prometheusClient;
        this.dataSourceSchemaName = dataSourceSchemaName;
    }
}

