/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.compiler.BytecodeDisassembler;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.Compiler;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.debug.EvalExprEvent;
import org.stringtemplate.v4.debug.EvalTemplateEvent;
import org.stringtemplate.v4.debug.IndentEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.misc.ArrayIterator;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.Interval;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STNoSuchAttributeException;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    public static final int DEFAULT_OPERAND_STACK_SIZE = 100;
    public static final Set<String> predefinedAnonSubtemplateAttributes = new HashSet<String>(){
        {
            this.add("i");
            this.add("i0");
        }
    };
    Object[] operands = new Object[100];
    int sp = -1;
    int nwline = 0;
    STGroup group;
    Locale locale;
    ErrorManager errMgr;
    public static boolean trace = false;
    protected List<String> executeTrace;
    public boolean debug = false;
    protected List<InterpEvent> events;

    public Interpreter(STGroup group, boolean debug) {
        this(group, Locale.getDefault(), group.errMgr, debug);
    }

    public Interpreter(STGroup group, Locale locale, boolean debug) {
        this(group, locale, group.errMgr, debug);
    }

    public Interpreter(STGroup group, ErrorManager errMgr, boolean debug) {
        this(group, Locale.getDefault(), errMgr, debug);
    }

    public Interpreter(STGroup group, Locale locale, ErrorManager errMgr, boolean debug) {
        this.group = group;
        this.locale = locale;
        this.errMgr = errMgr;
        this.debug = debug;
        if (debug) {
            this.events = new ArrayList<InterpEvent>();
            this.executeTrace = new ArrayList<String>();
        }
    }

    public int exec(STWriter out, InstanceScope scope2) {
        ST self = scope2.st;
        if (trace) {
            System.out.println("exec(" + self.getName() + ")");
        }
        try {
            this.setDefaultArguments(out, scope2);
            return this._exec(out, scope2);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            this.errMgr.runTimeError(this, scope2, ErrorType.INTERNAL_ERROR, "internal error: " + sw.toString());
            return 0;
        }
    }

    protected int _exec(STWriter out, InstanceScope scope2) {
        ST self = scope2.st;
        int start = out.index();
        short prevOpcode = 0;
        int n = 0;
        byte[] code = self.impl.instrs;
        int ip = 0;
        while (ip < self.impl.codeSize) {
            if (trace || this.debug) {
                this.trace(scope2, ip);
            }
            short opcode = code[ip];
            scope2.ip = ip++;
            switch (opcode) {
                case 1: {
                    this.load_str(self, ip);
                    ip += 2;
                    break;
                }
                case 2: {
                    Object o;
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    try {
                        o = this.getAttribute(scope2, name);
                        if (o == ST.EMPTY_ATTR) {
                            o = null;
                        }
                    }
                    catch (STNoSuchAttributeException nsae) {
                        this.errMgr.runTimeError(this, scope2, ErrorType.NO_SUCH_ATTRIBUTE, name);
                        o = null;
                    }
                    this.operands[++this.sp] = o;
                    break;
                }
                case 3: {
                    int valueIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = self.locals[valueIndex];
                    if (o == ST.EMPTY_ATTR) {
                        o = null;
                    }
                    this.operands[++this.sp] = o;
                    break;
                }
                case 4: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = this.operands[this.sp--];
                    String name = self.impl.strings[nameIndex];
                    this.operands[++this.sp] = this.getObjectProperty(out, scope2, o, name);
                    break;
                }
                case 5: {
                    Object propName = this.operands[this.sp--];
                    Object o = this.operands[this.sp];
                    this.operands[this.sp] = this.getObjectProperty(out, scope2, o, propName);
                    break;
                }
                case 8: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    int nargs = Interpreter.getShort(code, ip += 2);
                    ip += 2;
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope2, name);
                    this.storeArgs(scope2, nargs, st);
                    this.sp -= nargs;
                    this.operands[++this.sp] = st;
                    break;
                }
                case 9: {
                    int nargs = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = (String)this.operands[this.sp - nargs];
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope2, name);
                    this.storeArgs(scope2, nargs, st);
                    this.sp -= nargs;
                    --this.sp;
                    this.operands[++this.sp] = st;
                    break;
                }
                case 10: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp--];
                    ST st = self.groupThatCreatedThisInstance.getEmbeddedInstanceOf(this, scope2, name);
                    this.storeArgs(scope2, attrs, st);
                    this.operands[++this.sp] = st;
                    break;
                }
                case 11: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    int nargs = Interpreter.getShort(code, ip += 2);
                    ip += 2;
                    this.super_new(scope2, name, nargs);
                    break;
                }
                case 12: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp--];
                    this.super_new(scope2, name, attrs);
                    break;
                }
                case 6: {
                    int optionIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = this.operands[this.sp--];
                    Object[] options = (Object[])this.operands[this.sp];
                    options[optionIndex] = o;
                    break;
                }
                case 7: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    String name = self.impl.strings[nameIndex];
                    ip += 2;
                    Object o = this.operands[this.sp--];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp];
                    attrs.put(name, o);
                    break;
                }
                case 13: {
                    Object o = this.operands[this.sp--];
                    int n1 = this.writeObjectNoOptions(out, scope2, o);
                    n += n1;
                    this.nwline += n1;
                    break;
                }
                case 14: {
                    Object[] options = (Object[])this.operands[this.sp--];
                    Object o = this.operands[this.sp--];
                    int n2 = this.writeObjectWithOptions(out, scope2, o, options);
                    n += n2;
                    this.nwline += n2;
                    break;
                }
                case 15: {
                    ST st = (ST)this.operands[this.sp--];
                    Object o = this.operands[this.sp--];
                    this.map(scope2, o, st);
                    break;
                }
                case 16: {
                    Object o;
                    int nmaps = Interpreter.getShort(code, ip);
                    ip += 2;
                    ArrayList<ST> templates = new ArrayList<ST>();
                    for (int i = nmaps - 1; i >= 0; --i) {
                        templates.add((ST)this.operands[this.sp - i]);
                    }
                    this.sp -= nmaps;
                    if ((o = this.operands[this.sp--]) == null) break;
                    this.rot_map(scope2, o, templates);
                    break;
                }
                case 17: {
                    ST st = (ST)this.operands[this.sp--];
                    int nmaps = Interpreter.getShort(code, ip);
                    ip += 2;
                    ObjectList exprs = new ObjectList();
                    for (int i = nmaps - 1; i >= 0; --i) {
                        exprs.add(this.operands[this.sp - i]);
                    }
                    this.sp -= nmaps;
                    this.operands[++this.sp] = this.zip_map(scope2, exprs, st);
                    break;
                }
                case 18: {
                    ip = Interpreter.getShort(code, ip);
                    break;
                }
                case 19: {
                    int addr = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = this.operands[this.sp--];
                    if (this.testAttributeTrue(o)) break;
                    ip = addr;
                    break;
                }
                case 20: {
                    this.operands[++this.sp] = new Object[Compiler.NUM_OPTIONS];
                    break;
                }
                case 21: {
                    this.operands[++this.sp] = new ArgumentsMap();
                    break;
                }
                case 22: {
                    int nameIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    String name = self.impl.strings[nameIndex];
                    ArgumentsMap attrs = (ArgumentsMap)this.operands[this.sp];
                    this.passthru(scope2, name, attrs);
                    break;
                }
                case 24: {
                    this.operands[++this.sp] = new ObjectList();
                    break;
                }
                case 25: {
                    Object o = this.operands[this.sp--];
                    ObjectList list = (ObjectList)this.operands[this.sp];
                    this.addToList(scope2, list, o);
                    break;
                }
                case 26: {
                    this.operands[this.sp] = this.toString(out, scope2, this.operands[this.sp]);
                    break;
                }
                case 27: {
                    this.operands[this.sp] = this.first(scope2, this.operands[this.sp]);
                    break;
                }
                case 28: {
                    this.operands[this.sp] = this.last(scope2, this.operands[this.sp]);
                    break;
                }
                case 29: {
                    this.operands[this.sp] = this.rest(scope2, this.operands[this.sp]);
                    break;
                }
                case 30: {
                    this.operands[this.sp] = this.trunc(scope2, this.operands[this.sp]);
                    break;
                }
                case 31: {
                    this.operands[this.sp] = this.strip(scope2, this.operands[this.sp]);
                    break;
                }
                case 32: {
                    Object o = this.operands[this.sp--];
                    if (o.getClass() == String.class) {
                        this.operands[++this.sp] = ((String)o).trim();
                        break;
                    }
                    this.errMgr.runTimeError(this, scope2, ErrorType.EXPECTING_STRING, "trim", (Object)o.getClass().getName());
                    this.operands[++this.sp] = o;
                    break;
                }
                case 33: {
                    this.operands[this.sp] = this.length(this.operands[this.sp]);
                    break;
                }
                case 34: {
                    Object o = this.operands[this.sp--];
                    if (o.getClass() == String.class) {
                        this.operands[++this.sp] = ((String)o).length();
                        break;
                    }
                    this.errMgr.runTimeError(this, scope2, ErrorType.EXPECTING_STRING, "strlen", (Object)o.getClass().getName());
                    this.operands[++this.sp] = 0;
                    break;
                }
                case 35: {
                    this.operands[this.sp] = this.reverse(scope2, this.operands[this.sp]);
                    break;
                }
                case 36: {
                    this.operands[this.sp] = !this.testAttributeTrue(this.operands[this.sp]);
                    break;
                }
                case 37: {
                    Object right = this.operands[this.sp--];
                    Object left = this.operands[this.sp--];
                    this.operands[++this.sp] = this.testAttributeTrue(left) || this.testAttributeTrue(right);
                    break;
                }
                case 38: {
                    Object right = this.operands[this.sp--];
                    Object left = this.operands[this.sp--];
                    this.operands[++this.sp] = this.testAttributeTrue(left) && this.testAttributeTrue(right);
                    break;
                }
                case 39: {
                    int strIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    this.indent(out, scope2, strIndex);
                    break;
                }
                case 40: {
                    out.popIndentation();
                    break;
                }
                case 41: {
                    try {
                        if (prevOpcode == 41 || prevOpcode == 39 || this.nwline > 0) {
                            out.write(Misc.newline);
                        }
                        this.nwline = 0;
                    }
                    catch (IOException ioe) {
                        this.errMgr.IOError(self, ErrorType.WRITE_IO_ERROR, ioe);
                    }
                    break;
                }
                case 42: {
                    break;
                }
                case 43: {
                    --this.sp;
                    break;
                }
                case 44: {
                    this.operands[++this.sp] = null;
                    break;
                }
                case 45: {
                    this.operands[++this.sp] = true;
                    break;
                }
                case 46: {
                    this.operands[++this.sp] = false;
                    break;
                }
                case 47: {
                    int strIndex = Interpreter.getShort(code, ip);
                    ip += 2;
                    Object o = self.impl.strings[strIndex];
                    int n1 = this.writeObjectNoOptions(out, scope2, o);
                    n += n1;
                    this.nwline += n1;
                    break;
                }
                default: {
                    this.errMgr.internalError(self, "invalid bytecode @ " + (ip - 1) + ": " + opcode, null);
                    self.impl.dump();
                }
            }
            prevOpcode = opcode;
        }
        if (this.debug) {
            int stop = out.index() - 1;
            EvalTemplateEvent e = new EvalTemplateEvent(scope2, start, stop);
            this.trackDebugEvent(scope2, e);
        }
        return n;
    }

    void load_str(ST self, int ip) {
        int strIndex = Interpreter.getShort(self.impl.instrs, ip);
        ip += 2;
        this.operands[++this.sp] = self.impl.strings[strIndex];
    }

    void super_new(InstanceScope scope2, String name, int nargs) {
        ST self = scope2.st;
        ST st = null;
        CompiledST imported = self.impl.nativeGroup.lookupImportedTemplate(name);
        if (imported == null) {
            this.errMgr.runTimeError(this, scope2, ErrorType.NO_IMPORTED_TEMPLATE, name);
            st = self.groupThatCreatedThisInstance.createStringTemplateInternally(new CompiledST());
        } else {
            st = imported.nativeGroup.getEmbeddedInstanceOf(this, scope2, name);
            st.groupThatCreatedThisInstance = this.group;
        }
        this.storeArgs(scope2, nargs, st);
        this.sp -= nargs;
        this.operands[++this.sp] = st;
    }

    void super_new(InstanceScope scope2, String name, Map<String, Object> attrs) {
        ST self = scope2.st;
        ST st = null;
        CompiledST imported = self.impl.nativeGroup.lookupImportedTemplate(name);
        if (imported == null) {
            this.errMgr.runTimeError(this, scope2, ErrorType.NO_IMPORTED_TEMPLATE, name);
            st = self.groupThatCreatedThisInstance.createStringTemplateInternally(new CompiledST());
        } else {
            st = imported.nativeGroup.createStringTemplateInternally(imported);
            st.groupThatCreatedThisInstance = this.group;
        }
        this.storeArgs(scope2, attrs, st);
        this.operands[++this.sp] = st;
    }

    void passthru(InstanceScope scope2, String templateName, Map<String, Object> attrs) {
        CompiledST c = this.group.lookupTemplate(templateName);
        if (c == null) {
            return;
        }
        if (c.formalArguments == null) {
            return;
        }
        for (FormalArgument arg : c.formalArguments.values()) {
            if (attrs.containsKey(arg.name)) continue;
            try {
                Object o = this.getAttribute(scope2, arg.name);
                if (o == ST.EMPTY_ATTR && arg.defaultValueToken == null) {
                    attrs.put(arg.name, null);
                    continue;
                }
                if (o == ST.EMPTY_ATTR) continue;
                attrs.put(arg.name, o);
            }
            catch (STNoSuchAttributeException nsae) {
                if (arg.defaultValueToken != null) continue;
                this.errMgr.runTimeError(this, scope2, ErrorType.NO_SUCH_ATTRIBUTE_PASS_THROUGH, arg.name);
                attrs.put(arg.name, null);
            }
        }
    }

    void storeArgs(InstanceScope scope2, Map<String, Object> attrs, ST st) {
        if (st.impl.hasFormalArgs) {
            boolean argumentCountMismatch = false;
            Map<String, FormalArgument> formalArguments = st.impl.formalArguments;
            if (formalArguments == null) {
                formalArguments = Collections.emptyMap();
            }
            for (Map.Entry<String, FormalArgument> formalArgument : formalArguments.entrySet()) {
                if (formalArgument.getValue().defaultValueToken != null || formalArgument.getValue().defaultValue != null || attrs != null && attrs.containsKey(formalArgument.getKey())) continue;
                argumentCountMismatch = true;
                break;
            }
            if (attrs != null && attrs.size() > formalArguments.size()) {
                argumentCountMismatch = true;
            }
            if (argumentCountMismatch) {
                int nargs = attrs != null ? attrs.size() : 0;
                int nformalArgs = formalArguments.size();
                this.errMgr.runTimeError(this, scope2, ErrorType.ARGUMENT_COUNT_MISMATCH, nargs, st.impl.name, nformalArgs);
            }
        }
        if (attrs != null) {
            for (Map.Entry<String, Object> argument : attrs.entrySet()) {
                if (!st.impl.hasFormalArgs) {
                    if (st.impl.formalArguments == null || !st.impl.formalArguments.containsKey(argument.getKey())) {
                        try {
                            st.impl = st.impl.clone();
                            st.add(argument.getKey(), argument.getValue());
                        }
                        catch (CloneNotSupportedException ex) {
                            this.errMgr.runTimeError(this, scope2, ErrorType.NO_SUCH_ATTRIBUTE, argument.getKey());
                        }
                        continue;
                    }
                    st.rawSetAttribute(argument.getKey(), argument.getValue());
                    continue;
                }
                if (st.impl.formalArguments == null || !st.impl.formalArguments.containsKey(argument.getKey())) {
                    this.errMgr.runTimeError(this, scope2, ErrorType.NO_SUCH_ATTRIBUTE, argument.getKey());
                    continue;
                }
                st.rawSetAttribute(argument.getKey(), argument.getValue());
            }
        }
    }

    void storeArgs(InstanceScope scope2, int nargs, ST st) {
        if (nargs > 0 && !st.impl.hasFormalArgs && st.impl.formalArguments == null) {
            st.add("it", null);
        }
        int nformalArgs = 0;
        if (st.impl.formalArguments != null) {
            nformalArgs = st.impl.formalArguments.size();
        }
        int firstArg = this.sp - (nargs - 1);
        int numToStore = Math.min(nargs, nformalArgs);
        if (st.impl.isAnonSubtemplate) {
            nformalArgs -= predefinedAnonSubtemplateAttributes.size();
        }
        if (nargs < nformalArgs - st.impl.numberOfArgsWithDefaultValues || nargs > nformalArgs) {
            this.errMgr.runTimeError(this, scope2, ErrorType.ARGUMENT_COUNT_MISMATCH, nargs, st.impl.name, nformalArgs);
        }
        if (st.impl.formalArguments == null) {
            return;
        }
        Iterator<String> argNames = st.impl.formalArguments.keySet().iterator();
        for (int i = 0; i < numToStore; ++i) {
            Object o = this.operands[firstArg + i];
            String argName = argNames.next();
            st.rawSetAttribute(argName, o);
        }
    }

    protected void indent(STWriter out, InstanceScope scope2, int strIndex) {
        String indent = scope2.st.impl.strings[strIndex];
        if (this.debug) {
            int start = out.index();
            IndentEvent e = new IndentEvent(scope2, start, start + indent.length() - 1, this.getExprStartChar(scope2), this.getExprStopChar(scope2));
            this.trackDebugEvent(scope2, e);
        }
        out.pushIndentation(indent);
    }

    protected int writeObjectNoOptions(STWriter out, InstanceScope scope2, Object o) {
        int start = out.index();
        int n = this.writeObject(out, scope2, o, null);
        if (this.debug) {
            EvalExprEvent e = new EvalExprEvent(scope2, start, out.index() - 1, this.getExprStartChar(scope2), this.getExprStopChar(scope2));
            this.trackDebugEvent(scope2, e);
        }
        return n;
    }

    protected int writeObjectWithOptions(STWriter out, InstanceScope scope2, Object o, Object[] options) {
        int start = out.index();
        String[] optionStrings = null;
        if (options != null) {
            optionStrings = new String[options.length];
            for (int i = 0; i < Compiler.NUM_OPTIONS; ++i) {
                optionStrings[i] = this.toString(out, scope2, options[i]);
            }
        }
        if (options != null && options[Option.ANCHOR.ordinal()] != null) {
            out.pushAnchorPoint();
        }
        int n = this.writeObject(out, scope2, o, optionStrings);
        if (options != null && options[Option.ANCHOR.ordinal()] != null) {
            out.popAnchorPoint();
        }
        if (this.debug) {
            EvalExprEvent e = new EvalExprEvent(scope2, start, out.index() - 1, this.getExprStartChar(scope2), this.getExprStopChar(scope2));
            this.trackDebugEvent(scope2, e);
        }
        return n;
    }

    protected int writeObject(STWriter out, InstanceScope scope2, Object o, String[] options) {
        int n = 0;
        if (o == null) {
            if (options != null && options[Option.NULL.ordinal()] != null) {
                o = options[Option.NULL.ordinal()];
            } else {
                return 0;
            }
        }
        if (o instanceof ST) {
            scope2 = new InstanceScope(scope2, (ST)o);
            if (options != null && options[Option.WRAP.ordinal()] != null) {
                try {
                    out.writeWrap(options[Option.WRAP.ordinal()]);
                }
                catch (IOException ioe) {
                    this.errMgr.IOError(scope2.st, ErrorType.WRITE_IO_ERROR, ioe);
                }
            }
            n = this.exec(out, scope2);
        } else {
            o = this.convertAnythingIteratableToIterator(scope2, o);
            try {
                n = o instanceof Iterator ? this.writeIterator(out, scope2, o, options) : this.writePOJO(out, scope2, o, options);
            }
            catch (IOException ioe) {
                this.errMgr.IOError(scope2.st, ErrorType.WRITE_IO_ERROR, ioe, o);
            }
        }
        return n;
    }

    protected int writeIterator(STWriter out, InstanceScope scope2, Object o, String[] options) throws IOException {
        if (o == null) {
            return 0;
        }
        int n = 0;
        Iterator it = (Iterator)o;
        String separator = null;
        if (options != null) {
            separator = options[Option.SEPARATOR.ordinal()];
        }
        boolean seenAValue = false;
        while (it.hasNext()) {
            int nw;
            boolean needSeparator;
            Object iterValue = it.next();
            boolean bl = needSeparator = seenAValue && separator != null && (iterValue != null || options[Option.NULL.ordinal()] != null);
            if (needSeparator) {
                n += out.writeSeparator(separator);
            }
            if ((nw = this.writeObject(out, scope2, iterValue, options)) > 0) {
                seenAValue = true;
            }
            n += nw;
        }
        return n;
    }

    protected int writePOJO(STWriter out, InstanceScope scope2, Object o, String[] options) throws IOException {
        AttributeRenderer r;
        String formatString = null;
        if (options != null) {
            formatString = options[Option.FORMAT.ordinal()];
        }
        String v = (r = scope2.st.impl.nativeGroup.getAttributeRenderer(o.getClass())) != null ? r.toString(o, formatString, this.locale) : o.toString();
        int n = options != null && options[Option.WRAP.ordinal()] != null ? out.write(v, options[Option.WRAP.ordinal()]) : out.write(v);
        return n;
    }

    protected int getExprStartChar(InstanceScope scope2) {
        Interval templateLocation = scope2.st.impl.sourceMap[scope2.ip];
        if (templateLocation != null) {
            return templateLocation.a;
        }
        return -1;
    }

    protected int getExprStopChar(InstanceScope scope2) {
        Interval templateLocation = scope2.st.impl.sourceMap[scope2.ip];
        if (templateLocation != null) {
            return templateLocation.b;
        }
        return -1;
    }

    protected void map(InstanceScope scope2, Object attr, final ST st) {
        this.rot_map(scope2, attr, (List<ST>)new ArrayList<ST>(){
            {
                this.add(st);
            }
        });
    }

    protected void rot_map(InstanceScope scope2, Object attr, List<ST> prototypes) {
        if (attr == null) {
            this.operands[++this.sp] = null;
            return;
        }
        if ((attr = this.convertAnythingIteratableToIterator(scope2, attr)) instanceof Iterator) {
            List<ST> mapped = this.rot_map_iterator(scope2, (Iterator)attr, prototypes);
            this.operands[++this.sp] = mapped;
        } else {
            ST proto = prototypes.get(0);
            ST st = this.group.createStringTemplateInternally(proto);
            if (st != null) {
                this.setFirstArgument(scope2, st, attr);
                if (st.impl.isAnonSubtemplate) {
                    st.rawSetAttribute("i0", 0);
                    st.rawSetAttribute("i", 1);
                }
                this.operands[++this.sp] = st;
            } else {
                this.operands[++this.sp] = null;
            }
        }
    }

    protected List<ST> rot_map_iterator(InstanceScope scope2, Iterator<?> attr, List<ST> prototypes) {
        ArrayList<ST> mapped = new ArrayList<ST>();
        Iterator<?> iter = attr;
        int i0 = 0;
        int i = 1;
        int ti = 0;
        while (iter.hasNext()) {
            Object iterValue = iter.next();
            if (iterValue == null) {
                mapped.add(null);
                continue;
            }
            int templateIndex = ti % prototypes.size();
            ++ti;
            ST proto = prototypes.get(templateIndex);
            ST st = this.group.createStringTemplateInternally(proto);
            this.setFirstArgument(scope2, st, iterValue);
            if (st.impl.isAnonSubtemplate) {
                st.rawSetAttribute("i0", i0);
                st.rawSetAttribute("i", i);
            }
            mapped.add(st);
            ++i0;
            ++i;
        }
        return mapped;
    }

    protected ST.AttributeList zip_map(InstanceScope scope2, List<Object> exprs, ST prototype) {
        if (exprs == null || prototype == null || exprs.size() == 0) {
            return null;
        }
        for (int i = 0; i < exprs.size(); ++i) {
            Object attr = exprs.get(i);
            if (attr == null) continue;
            exprs.set(i, this.convertAnythingToIterator(scope2, attr));
        }
        int numExprs = exprs.size();
        CompiledST code = prototype.impl;
        Map<String, FormalArgument> formalArguments = code.formalArguments;
        if (!code.hasFormalArgs || formalArguments == null) {
            this.errMgr.runTimeError(this, scope2, ErrorType.MISSING_FORMAL_ARGUMENTS);
            return null;
        }
        String[] formalArgumentNames = formalArguments.keySet().toArray(new String[formalArguments.size()]);
        int nformalArgs = formalArgumentNames.length;
        if (prototype.isAnonSubtemplate()) {
            nformalArgs -= predefinedAnonSubtemplateAttributes.size();
        }
        if (nformalArgs != numExprs) {
            int shorterSize;
            this.errMgr.runTimeError(this, scope2, ErrorType.MAP_ARGUMENT_COUNT_MISMATCH, numExprs, (Object)nformalArgs);
            numExprs = shorterSize = Math.min(formalArgumentNames.length, numExprs);
            String[] newFormalArgumentNames = new String[shorterSize];
            System.arraycopy(formalArgumentNames, 0, newFormalArgumentNames, 0, shorterSize);
            formalArgumentNames = newFormalArgumentNames;
        }
        ST.AttributeList results = new ST.AttributeList();
        int i = 0;
        while (true) {
            int numEmpty = 0;
            ST embedded = this.group.createStringTemplateInternally(prototype);
            embedded.rawSetAttribute("i0", i);
            embedded.rawSetAttribute("i", i + 1);
            for (int a = 0; a < numExprs; ++a) {
                Iterator it = (Iterator)exprs.get(a);
                if (it != null && it.hasNext()) {
                    String argName = formalArgumentNames[a];
                    Object iteratedValue = it.next();
                    embedded.rawSetAttribute(argName, iteratedValue);
                    continue;
                }
                ++numEmpty;
            }
            if (numEmpty == numExprs) break;
            results.add(embedded);
            ++i;
        }
        return results;
    }

    protected void setFirstArgument(InstanceScope scope2, ST st, Object attr) {
        if (!st.impl.hasFormalArgs && st.impl.formalArguments == null) {
            st.add("it", attr);
            return;
        }
        if (st.impl.formalArguments == null) {
            this.errMgr.runTimeError(this, scope2, ErrorType.ARGUMENT_COUNT_MISMATCH, 1, st.impl.name, 0);
            return;
        }
        st.locals[0] = attr;
    }

    protected void addToList(InstanceScope scope2, List<Object> list, Object o) {
        if ((o = this.convertAnythingIteratableToIterator(scope2, o)) instanceof Iterator) {
            Iterator it = (Iterator)o;
            while (it.hasNext()) {
                list.add(it.next());
            }
        } else {
            list.add(o);
        }
    }

    public Object first(InstanceScope scope2, Object v) {
        Iterator it;
        if (v == null) {
            return null;
        }
        Object r = v;
        if ((v = this.convertAnythingIteratableToIterator(scope2, v)) instanceof Iterator && (it = (Iterator)v).hasNext()) {
            r = it.next();
        }
        return r;
    }

    public Object last(InstanceScope scope2, Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof List) {
            return ((List)v).get(((List)v).size() - 1);
        }
        if (v.getClass().isArray()) {
            return Array.get(v, Array.getLength(v) - 1);
        }
        Object last = v;
        if ((v = this.convertAnythingIteratableToIterator(scope2, v)) instanceof Iterator) {
            Iterator it = (Iterator)v;
            while (it.hasNext()) {
                last = it.next();
            }
        }
        return last;
    }

    public Object rest(InstanceScope scope2, Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof List) {
            List elems = (List)v;
            if (elems.size() <= 1) {
                return null;
            }
            return elems.subList(1, elems.size());
        }
        if ((v = this.convertAnythingIteratableToIterator(scope2, v)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)v;
            if (!it.hasNext()) {
                return null;
            }
            it.next();
            while (it.hasNext()) {
                Object o = it.next();
                a.add(o);
            }
            return a;
        }
        return null;
    }

    public Object trunc(InstanceScope scope2, Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof List) {
            List elems = (List)v;
            if (elems.size() <= 1) {
                return null;
            }
            return elems.subList(0, elems.size() - 1);
        }
        if ((v = this.convertAnythingIteratableToIterator(scope2, v)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)v;
            while (it.hasNext()) {
                Object o = it.next();
                if (!it.hasNext()) continue;
                a.add(o);
            }
            return a;
        }
        return null;
    }

    public Object strip(InstanceScope scope2, Object v) {
        if (v == null) {
            return null;
        }
        if ((v = this.convertAnythingIteratableToIterator(scope2, v)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)v;
            while (it.hasNext()) {
                Object o = it.next();
                if (o == null) continue;
                a.add(o);
            }
            return a;
        }
        return v;
    }

    public Object reverse(InstanceScope scope2, Object v) {
        if (v == null) {
            return null;
        }
        if ((v = this.convertAnythingIteratableToIterator(scope2, v)) instanceof Iterator) {
            LinkedList a = new LinkedList();
            Iterator it = (Iterator)v;
            while (it.hasNext()) {
                a.add(0, it.next());
            }
            return a;
        }
        return v;
    }

    public Object length(Object v) {
        if (v == null) {
            return 0;
        }
        int i = 1;
        if (v instanceof Map) {
            i = ((Map)v).size();
        } else if (v instanceof Collection) {
            i = ((Collection)v).size();
        } else if (v instanceof Object[]) {
            i = ((Object[])v).length;
        } else if (v.getClass().isArray()) {
            i = Array.getLength(v);
        } else if (v instanceof Iterator) {
            Iterator it = (Iterator)v;
            i = 0;
            while (it.hasNext()) {
                it.next();
                ++i;
            }
        }
        return i;
    }

    protected String toString(STWriter out, InstanceScope scope2, Object value) {
        if (value != null) {
            STWriter stw;
            if (value.getClass() == String.class) {
                return (String)value;
            }
            StringWriter sw = new StringWriter();
            try {
                Class<?> writerClass = out.getClass();
                Constructor<?> ctor = writerClass.getConstructor(Writer.class);
                stw = (STWriter)ctor.newInstance(sw);
            }
            catch (Exception e) {
                stw = new AutoIndentWriter(sw);
                this.errMgr.runTimeError(this, scope2, ErrorType.WRITER_CTOR_ISSUE, out.getClass().getSimpleName());
            }
            if (this.debug && !scope2.earlyEval) {
                scope2 = new InstanceScope(scope2, scope2.st);
                scope2.earlyEval = true;
            }
            this.writeObjectNoOptions(stw, scope2, value);
            return sw.toString();
        }
        return null;
    }

    public Object convertAnythingIteratableToIterator(InstanceScope scope2, Object o) {
        Iterator<Object> iter = null;
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            iter = ((Collection)o).iterator();
        } else if (o instanceof Object[]) {
            iter = Arrays.asList((Object[])o).iterator();
        } else if (o.getClass().isArray()) {
            iter = new ArrayIterator(o);
        } else if (o instanceof Map) {
            iter = scope2.st.groupThatCreatedThisInstance.iterateAcrossValues ? ((Map)o).values().iterator() : ((Map)o).keySet().iterator();
        }
        if (iter == null) {
            return o;
        }
        return iter;
    }

    public Iterator<?> convertAnythingToIterator(InstanceScope scope2, Object o) {
        if ((o = this.convertAnythingIteratableToIterator(scope2, o)) instanceof Iterator) {
            return (Iterator)o;
        }
        ST.AttributeList singleton = new ST.AttributeList(1);
        singleton.add(o);
        return singleton.iterator();
    }

    protected boolean testAttributeTrue(Object a) {
        if (a == null) {
            return false;
        }
        if (a instanceof Boolean) {
            return (Boolean)a;
        }
        if (a instanceof Collection) {
            return ((Collection)a).size() > 0;
        }
        if (a instanceof Map) {
            return ((Map)a).size() > 0;
        }
        if (a instanceof Iterator) {
            return ((Iterator)a).hasNext();
        }
        return true;
    }

    protected Object getObjectProperty(STWriter out, InstanceScope scope2, Object o, Object property) {
        if (o == null) {
            this.errMgr.runTimeError(this, scope2, ErrorType.NO_SUCH_PROPERTY, "null." + property);
            return null;
        }
        try {
            ST self = scope2.st;
            ModelAdaptor adap = self.groupThatCreatedThisInstance.getModelAdaptor(o.getClass());
            return adap.getProperty(this, self, o, property, this.toString(out, scope2, property));
        }
        catch (STNoSuchPropertyException e) {
            this.errMgr.runTimeError(this, scope2, ErrorType.NO_SUCH_PROPERTY, e, (Object)(o.getClass().getName() + "." + property));
            return null;
        }
    }

    public Object getAttribute(InstanceScope scope2, String name) {
        InstanceScope current = scope2;
        while (current != null) {
            ST p = current.st;
            FormalArgument localArg = null;
            if (p.impl.formalArguments != null) {
                localArg = p.impl.formalArguments.get(name);
            }
            if (localArg != null) {
                Object o = p.locals[localArg.index];
                return o;
            }
            current = current.parent;
        }
        ST self = scope2.st;
        STGroup g2 = self.impl.nativeGroup;
        Object o = this.getDictionary(g2, name);
        if (o != null) {
            return o;
        }
        throw new STNoSuchAttributeException(name, scope2);
    }

    public Object getDictionary(STGroup g2, String name) {
        if (g2.isDictionary(name)) {
            return g2.rawGetDictionary(name);
        }
        if (g2.imports != null) {
            for (STGroup sup : g2.imports) {
                Object o = this.getDictionary(sup, name);
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    public void setDefaultArguments(STWriter out, InstanceScope scope2) {
        ST invokedST = scope2.st;
        if (invokedST.impl.formalArguments == null || invokedST.impl.numberOfArgsWithDefaultValues == 0) {
            return;
        }
        for (FormalArgument arg : invokedST.impl.formalArguments.values()) {
            if (invokedST.locals[arg.index] != ST.EMPTY_ATTR || arg.defaultValueToken == null) continue;
            if (arg.defaultValueToken.getType() == 4) {
                CompiledST code = arg.compiledDefaultValue;
                if (code == null) {
                    code = new CompiledST();
                }
                ST defaultArgST = this.group.createStringTemplateInternally(code);
                defaultArgST.groupThatCreatedThisInstance = this.group;
                String defArgTemplate = arg.defaultValueToken.getText();
                if (defArgTemplate.startsWith("{" + this.group.delimiterStartChar + "(") && defArgTemplate.endsWith(")" + this.group.delimiterStopChar + "}")) {
                    invokedST.rawSetAttribute(arg.name, this.toString(out, new InstanceScope(scope2, invokedST), defaultArgST));
                    continue;
                }
                invokedST.rawSetAttribute(arg.name, defaultArgST);
                continue;
            }
            invokedST.rawSetAttribute(arg.name, arg.defaultValue);
        }
    }

    public static String getEnclosingInstanceStackString(InstanceScope scope2) {
        List<ST> templates = Interpreter.getEnclosingInstanceStack(scope2, true);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (ST st : templates) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(st.getName());
            ++i;
        }
        return buf.toString();
    }

    public static List<ST> getEnclosingInstanceStack(InstanceScope scope2, boolean topdown) {
        LinkedList<ST> stack = new LinkedList<ST>();
        InstanceScope p = scope2;
        while (p != null) {
            if (topdown) {
                stack.add(0, p.st);
            } else {
                stack.add(p.st);
            }
            p = p.parent;
        }
        return stack;
    }

    public static List<InstanceScope> getScopeStack(InstanceScope scope2, boolean topdown) {
        LinkedList<InstanceScope> stack = new LinkedList<InstanceScope>();
        InstanceScope p = scope2;
        while (p != null) {
            if (topdown) {
                stack.add(0, p);
            } else {
                stack.add(p);
            }
            p = p.parent;
        }
        return stack;
    }

    public static List<EvalTemplateEvent> getEvalTemplateEventStack(InstanceScope scope2, boolean topdown) {
        LinkedList<EvalTemplateEvent> stack = new LinkedList<EvalTemplateEvent>();
        InstanceScope p = scope2;
        while (p != null) {
            EvalTemplateEvent eval = (EvalTemplateEvent)p.events.get(p.events.size() - 1);
            if (topdown) {
                stack.add(0, eval);
            } else {
                stack.add(eval);
            }
            p = p.parent;
        }
        return stack;
    }

    protected void trace(InstanceScope scope2, int ip) {
        ST self = scope2.st;
        StringBuilder tr = new StringBuilder();
        BytecodeDisassembler dis = new BytecodeDisassembler(self.impl);
        StringBuilder buf = new StringBuilder();
        dis.disassembleInstruction(buf, ip);
        String name = self.impl.name + ":";
        if (Misc.referenceEquals(self.impl.name, "anonymous")) {
            name = "";
        }
        tr.append(String.format("%-40s", name + buf));
        tr.append("\tstack=[");
        for (int i = 0; i <= this.sp; ++i) {
            Object o = this.operands[i];
            this.printForTrace(tr, scope2, o);
        }
        tr.append(" ], calls=");
        tr.append(Interpreter.getEnclosingInstanceStackString(scope2));
        tr.append(", sp=" + this.sp + ", nw=" + this.nwline);
        String s2 = tr.toString();
        if (this.debug) {
            this.executeTrace.add(s2);
        }
        if (trace) {
            System.out.println(s2);
        }
    }

    protected void printForTrace(StringBuilder tr, InstanceScope scope2, Object o) {
        if (o instanceof ST) {
            if (((ST)o).impl == null) {
                tr.append("bad-template()");
            } else {
                tr.append(" " + ((ST)o).impl.name + "()");
            }
            return;
        }
        if ((o = this.convertAnythingIteratableToIterator(scope2, o)) instanceof Iterator) {
            Iterator it = (Iterator)o;
            tr.append(" [");
            while (it.hasNext()) {
                Object iterValue = it.next();
                this.printForTrace(tr, scope2, iterValue);
            }
            tr.append(" ]");
        } else {
            tr.append(" " + o);
        }
    }

    public List<InterpEvent> getEvents() {
        return this.events;
    }

    protected void trackDebugEvent(InstanceScope scope2, InterpEvent e) {
        InstanceScope parent;
        this.events.add(e);
        scope2.events.add(e);
        if (e instanceof EvalTemplateEvent && (parent = scope2.parent) != null) {
            scope2.parent.childEvalTemplateEvents.add((EvalTemplateEvent)e);
        }
    }

    public List<String> getExecutionTrace() {
        return this.executeTrace;
    }

    public static int getShort(byte[] memory, int index) {
        int b1 = memory[index] & 0xFF;
        int b2 = memory[index + 1] & 0xFF;
        return b1 << 8 | b2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ArgumentsMap
    extends HashMap<String, Object> {
        protected ArgumentsMap() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ObjectList
    extends ArrayList<Object> {
        protected ObjectList() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        ANCHOR,
        FORMAT,
        NULL,
        SEPARATOR,
        WRAP;

    }
}

