# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.managedapplications.v2019_07_01 import ApplicationClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationApplicationDefinitionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_definitions_get(self, resource_group):
        response = self.client.application_definitions.get(
            resource_group_name=resource_group.name,
            application_definition_name="str",
            api_version="2019-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_definitions_begin_delete(self, resource_group):
        response = self.client.application_definitions.begin_delete(
            resource_group_name=resource_group.name,
            application_definition_name="str",
            api_version="2019-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_definitions_begin_create_or_update(self, resource_group):
        response = self.client.application_definitions.begin_create_or_update(
            resource_group_name=resource_group.name,
            application_definition_name="str",
            parameters={
                "lockLevel": "str",
                "artifacts": [{"name": "str", "type": "str", "uri": "str"}],
                "authorizations": [{"principalId": "str", "roleDefinitionId": "str"}],
                "createUiDefinition": {},
                "deploymentPolicy": {"deploymentMode": "str"},
                "description": "str",
                "displayName": "str",
                "id": "str",
                "isEnabled": bool,
                "location": "str",
                "lockingPolicy": {"allowedActions": ["str"], "allowedDataActions": ["str"]},
                "mainTemplate": {},
                "managedBy": "str",
                "managementPolicy": {"mode": "str"},
                "name": "str",
                "notificationPolicy": {"notificationEndpoints": [{"uri": "str"}]},
                "packageFileUri": "str",
                "policies": [{"name": "str", "parameters": "str", "policyDefinitionId": "str"}],
                "sku": {"name": "str", "capacity": 0, "family": "str", "model": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2019-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_definitions_list_by_resource_group(self, resource_group):
        response = self.client.application_definitions.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2019-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_definitions_get_by_id(self, resource_group):
        response = self.client.application_definitions.get_by_id(
            resource_group_name=resource_group.name,
            application_definition_name="str",
            api_version="2019-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_definitions_begin_delete_by_id(self, resource_group):
        response = self.client.application_definitions.begin_delete_by_id(
            resource_group_name=resource_group.name,
            application_definition_name="str",
            api_version="2019-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_application_definitions_begin_create_or_update_by_id(self, resource_group):
        response = self.client.application_definitions.begin_create_or_update_by_id(
            resource_group_name=resource_group.name,
            application_definition_name="str",
            parameters={
                "lockLevel": "str",
                "artifacts": [{"name": "str", "type": "str", "uri": "str"}],
                "authorizations": [{"principalId": "str", "roleDefinitionId": "str"}],
                "createUiDefinition": {},
                "deploymentPolicy": {"deploymentMode": "str"},
                "description": "str",
                "displayName": "str",
                "id": "str",
                "isEnabled": bool,
                "location": "str",
                "lockingPolicy": {"allowedActions": ["str"], "allowedDataActions": ["str"]},
                "mainTemplate": {},
                "managedBy": "str",
                "managementPolicy": {"mode": "str"},
                "name": "str",
                "notificationPolicy": {"notificationEndpoints": [{"uri": "str"}]},
                "packageFileUri": "str",
                "policies": [{"name": "str", "parameters": "str", "policyDefinitionId": "str"}],
                "sku": {"name": "str", "capacity": 0, "family": "str", "model": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2019-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
