# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservice.aio import ContainerServiceClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceJWTAuthenticatorsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jwt_authenticators_list_by_managed_cluster(self, resource_group):
        response = self.client.jwt_authenticators.list_by_managed_cluster(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2025-10-02-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jwt_authenticators_get(self, resource_group):
        response = await self.client.jwt_authenticators.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            jwt_authenticator_name="str",
            api_version="2025-10-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jwt_authenticators_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.jwt_authenticators.begin_create_or_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                jwt_authenticator_name="str",
                parameters={
                    "properties": {
                        "claimMappings": {
                            "username": {"expression": "str"},
                            "extra": [{"key": "str", "valueExpression": "str"}],
                            "groups": {"expression": "str"},
                            "uid": {"expression": "str"},
                        },
                        "issuer": {"audiences": ["str"], "url": "str"},
                        "claimValidationRules": [{"expression": "str", "message": "str"}],
                        "provisioningState": "str",
                        "userValidationRules": [{"expression": "str", "message": "str"}],
                    },
                    "id": "str",
                    "name": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-10-02-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_jwt_authenticators_begin_delete(self, resource_group):
        response = await (
            await self.client.jwt_authenticators.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
                jwt_authenticator_name="str",
                api_version="2025-10-02-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
